/* RainLoop Webmail (c) RainLoop Team | Licensed under AGPL v3 */
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "rainloop/v/0.0.0/static/js/";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 212);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/*!**************************************************************!*\
  !*** ./node_modules/babel-runtime/helpers/classCallCheck.js ***!
  \**************************************************************/
/*! no static exports found */
/*! exports used: default */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

exports.default = function (instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
};

/***/ }),
/* 1 */
/*!*****************************!*\
  !*** ./dev/Common/Utils.js ***!
  \*****************************/
/*! exports provided: trim, inArray, isArray, isObject, isFunc, isUnd, isNull, has, bind, noop, noopTrue, noopFalse, jassl, silentTryCatch, isNormal, isPosNumeric, pInt, pString, pBool, boolToAjax, isNonEmptyArray, encodeURIComponent, decodeURIComponent, decodeURI, encodeURI, simpleQueryParser, fakeMd5, encodeHtml, splitPlainText, timeOutAction, timeOutActionSecond, inFocus, removeInFocus, removeSelection, replySubjectAdd, roundNumber, friendlySize, log, delegateRun, killCtrlACtrlS, createCommandLegacy, convertThemeName, quoteName, microtime, timestamp, convertLangName, draggablePlace, defautOptionsAfterRender, clearBqSwitcher, previewMessage, settingsSaveHelperFunction, settingsSaveHelperSimpleFunction, settingsSaveHelperSubscribeFunction, findEmailAndLinks, htmlToPlain, plainToHtml, folderListOptionsBuilder, selectElement, detectDropdownVisibility, triggerAutocompleteInputChange, getConfigurationFromScriptTag, disposeOne, disposeObject, delegateRunOnDestroy, appendStyles, changeTheme, computedPagenatorHelper, getFileExtension, mimeContentType, isTransparent, getRealHeight, resizeAndCrop, mailToHelper, domReady, windowResize, windowResizeCallback */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "trim", function() { return trim; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "inArray", function() { return inArray; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isArray", function() { return isArray; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isObject", function() { return isObject; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isFunc", function() { return isFunc; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isUnd", function() { return isUnd; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isNull", function() { return isNull; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "has", function() { return has; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "bind", function() { return bind; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "noop", function() { return noop; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "noopTrue", function() { return noopTrue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "noopFalse", function() { return noopFalse; });
/* harmony export (immutable) */ __webpack_exports__["silentTryCatch"] = silentTryCatch;
/* harmony export (immutable) */ __webpack_exports__["isNormal"] = isNormal;
/* harmony export (immutable) */ __webpack_exports__["isPosNumeric"] = isPosNumeric;
/* harmony export (immutable) */ __webpack_exports__["pInt"] = pInt;
/* harmony export (immutable) */ __webpack_exports__["pString"] = pString;
/* harmony export (immutable) */ __webpack_exports__["pBool"] = pBool;
/* harmony export (immutable) */ __webpack_exports__["boolToAjax"] = boolToAjax;
/* harmony export (immutable) */ __webpack_exports__["isNonEmptyArray"] = isNonEmptyArray;
/* harmony export (immutable) */ __webpack_exports__["encodeURIComponent"] = encodeURIComponent;
/* harmony export (immutable) */ __webpack_exports__["decodeURIComponent"] = decodeURIComponent;
/* harmony export (immutable) */ __webpack_exports__["decodeURI"] = decodeURI;
/* harmony export (immutable) */ __webpack_exports__["encodeURI"] = encodeURI;
/* harmony export (immutable) */ __webpack_exports__["simpleQueryParser"] = simpleQueryParser;
/* harmony export (immutable) */ __webpack_exports__["fakeMd5"] = fakeMd5;
/* harmony export (immutable) */ __webpack_exports__["encodeHtml"] = encodeHtml;
/* harmony export (immutable) */ __webpack_exports__["splitPlainText"] = splitPlainText;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "timeOutAction", function() { return timeOutAction; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "timeOutActionSecond", function() { return timeOutActionSecond; });
/* harmony export (immutable) */ __webpack_exports__["inFocus"] = inFocus;
/* harmony export (immutable) */ __webpack_exports__["removeInFocus"] = removeInFocus;
/* harmony export (immutable) */ __webpack_exports__["removeSelection"] = removeSelection;
/* harmony export (immutable) */ __webpack_exports__["replySubjectAdd"] = replySubjectAdd;
/* harmony export (immutable) */ __webpack_exports__["roundNumber"] = roundNumber;
/* harmony export (immutable) */ __webpack_exports__["friendlySize"] = friendlySize;
/* harmony export (immutable) */ __webpack_exports__["log"] = log;
/* harmony export (immutable) */ __webpack_exports__["delegateRun"] = delegateRun;
/* harmony export (immutable) */ __webpack_exports__["killCtrlACtrlS"] = killCtrlACtrlS;
/* harmony export (immutable) */ __webpack_exports__["createCommandLegacy"] = createCommandLegacy;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "convertThemeName", function() { return convertThemeName; });
/* harmony export (immutable) */ __webpack_exports__["quoteName"] = quoteName;
/* harmony export (immutable) */ __webpack_exports__["microtime"] = microtime;
/* harmony export (immutable) */ __webpack_exports__["timestamp"] = timestamp;
/* harmony export (immutable) */ __webpack_exports__["convertLangName"] = convertLangName;
/* harmony export (immutable) */ __webpack_exports__["draggablePlace"] = draggablePlace;
/* harmony export (immutable) */ __webpack_exports__["defautOptionsAfterRender"] = defautOptionsAfterRender;
/* harmony export (immutable) */ __webpack_exports__["clearBqSwitcher"] = clearBqSwitcher;
/* harmony export (immutable) */ __webpack_exports__["previewMessage"] = previewMessage;
/* harmony export (immutable) */ __webpack_exports__["settingsSaveHelperFunction"] = settingsSaveHelperFunction;
/* harmony export (immutable) */ __webpack_exports__["settingsSaveHelperSimpleFunction"] = settingsSaveHelperSimpleFunction;
/* harmony export (immutable) */ __webpack_exports__["settingsSaveHelperSubscribeFunction"] = settingsSaveHelperSubscribeFunction;
/* harmony export (immutable) */ __webpack_exports__["findEmailAndLinks"] = findEmailAndLinks;
/* harmony export (immutable) */ __webpack_exports__["htmlToPlain"] = htmlToPlain;
/* harmony export (immutable) */ __webpack_exports__["plainToHtml"] = plainToHtml;
/* harmony export (immutable) */ __webpack_exports__["folderListOptionsBuilder"] = folderListOptionsBuilder;
/* harmony export (immutable) */ __webpack_exports__["selectElement"] = selectElement;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "detectDropdownVisibility", function() { return detectDropdownVisibility; });
/* harmony export (immutable) */ __webpack_exports__["triggerAutocompleteInputChange"] = triggerAutocompleteInputChange;
/* harmony export (immutable) */ __webpack_exports__["getConfigurationFromScriptTag"] = getConfigurationFromScriptTag;
/* harmony export (immutable) */ __webpack_exports__["disposeOne"] = disposeOne;
/* harmony export (immutable) */ __webpack_exports__["disposeObject"] = disposeObject;
/* harmony export (immutable) */ __webpack_exports__["delegateRunOnDestroy"] = delegateRunOnDestroy;
/* harmony export (immutable) */ __webpack_exports__["appendStyles"] = appendStyles;
/* harmony export (immutable) */ __webpack_exports__["changeTheme"] = changeTheme;
/* harmony export (immutable) */ __webpack_exports__["computedPagenatorHelper"] = computedPagenatorHelper;
/* harmony export (immutable) */ __webpack_exports__["getFileExtension"] = getFileExtension;
/* harmony export (immutable) */ __webpack_exports__["mimeContentType"] = mimeContentType;
/* harmony export (immutable) */ __webpack_exports__["isTransparent"] = isTransparent;
/* harmony export (immutable) */ __webpack_exports__["getRealHeight"] = getRealHeight;
/* harmony export (immutable) */ __webpack_exports__["resizeAndCrop"] = resizeAndCrop;
/* harmony export (immutable) */ __webpack_exports__["mailToHelper"] = mailToHelper;
/* harmony export (immutable) */ __webpack_exports__["domReady"] = domReady;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "windowResize", function() { return windowResize; });
/* harmony export (immutable) */ __webpack_exports__["windowResizeCallback"] = windowResizeCallback;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! $ */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Autolinker__ = __webpack_require__(/*! Autolinker */ 107);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Autolinker___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_Autolinker__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Mime__ = __webpack_require__(/*! Common/Mime */ 108);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Common_Jassl__ = __webpack_require__(/*! Common/Jassl */ 84);
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "jassl", function() { return __WEBPACK_IMPORTED_MODULE_8_Common_Jassl__["a"]; });












var trim = __WEBPACK_IMPORTED_MODULE_1_____default.a.trim;
var inArray = __WEBPACK_IMPORTED_MODULE_1_____default.a.inArray;
var isArray = __WEBPACK_IMPORTED_MODULE_2_____default.a.isArray;
var isObject = __WEBPACK_IMPORTED_MODULE_2_____default.a.isObject;
var isFunc = __WEBPACK_IMPORTED_MODULE_2_____default.a.isFunction;
var isUnd = __WEBPACK_IMPORTED_MODULE_2_____default.a.isUndefined;
var isNull = __WEBPACK_IMPORTED_MODULE_2_____default.a.isNull;
var has = __WEBPACK_IMPORTED_MODULE_2_____default.a.has;
var bind = __WEBPACK_IMPORTED_MODULE_2_____default.a.bind;
var noop = function noop() {}; // eslint-disable-line no-empty-function
var noopTrue = function noopTrue() {
	return true;
};
var noopFalse = function noopFalse() {
	return false;
};



/**
 * @param {Function} func
 */
function silentTryCatch(func) {
	try {
		func();
	} catch (e) {} // eslint-disable-line no-empty
}

/**
 * @param {*} value
 * @returns {boolean}
 */
function isNormal(value) {
	return !isUnd(value) && !isNull(value);
}

/**
 * @param {(string|number)} value
 * @param {boolean=} includeZero = true
 * @returns {boolean}
 */
function isPosNumeric(value) {
	var includeZero = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

	return !isNormal(value) ? false : includeZero ? /^[0-9]*$/.test(value.toString()) : /^[1-9]+[0-9]*$/.test(value.toString());
}

/**
 * @param {*} value
 * @param {number=} defaultValur = 0
 * @returns {number}
 */
function pInt(value) {
	var defaultValur = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

	var result = isNormal(value) && '' !== value ? __WEBPACK_IMPORTED_MODULE_0_window___default.a.parseInt(value, 10) : defaultValur;
	return __WEBPACK_IMPORTED_MODULE_0_window___default.a.isNaN(result) ? defaultValur : result;
}

/**
 * @param {*} value
 * @returns {string}
 */
function pString(value) {
	return isNormal(value) ? '' + value : '';
}

/**
 * @param {*} value
 * @returns {boolean}
 */
function pBool(value) {
	return !!value;
}

/**
 * @param {*} value
 * @returns {string}
 */
function boolToAjax(value) {
	return value ? '1' : '0';
}

/**
 * @param {*} values
 * @returns {boolean}
 */
function isNonEmptyArray(values) {
	return isArray(values) && 0 < values.length;
}

/**
 * @param {string} component
 * @returns {string}
 */
function encodeURIComponent(component) {
	return __WEBPACK_IMPORTED_MODULE_0_window___default.a.encodeURIComponent(component);
}

/**
 * @param {string} component
 * @returns {string}
 */
function decodeURIComponent(component) {
	return __WEBPACK_IMPORTED_MODULE_0_window___default.a.decodeURIComponent(component);
}

/**
 * @param {string} url
 * @returns {string}
 */
function decodeURI(url) {
	return __WEBPACK_IMPORTED_MODULE_0_window___default.a.decodeURI(url);
}

/**
 * @param {string} url
 * @returns {string}
 */
function encodeURI(url) {
	return __WEBPACK_IMPORTED_MODULE_0_window___default.a.encodeURI(url);
}

/**
 * @param {string} queryString
 * @returns {Object}
 */
function simpleQueryParser(queryString) {
	var index = 0,
	    len = 0,
	    temp = null;

	var queries = queryString.split('&'),
	    params = {};

	for (len = queries.length; index < len; index++) {
		temp = queries[index].split('=');
		params[decodeURIComponent(temp[0])] = decodeURIComponent(temp[1]);
	}

	return params;
}

/**
 * @param {number=} len = 32
 * @returns {string}
 */
function fakeMd5() {
	var len = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 32;

	var line = '0123456789abcdefghijklmnopqrstuvwxyz',
	    lineLen = line.length;

	len = pInt(len);

	var result = '';
	while (result.length < len) {
		result += line.substr(__WEBPACK_IMPORTED_MODULE_0_window___default.a.Math.round(__WEBPACK_IMPORTED_MODULE_0_window___default.a.Math.random() * lineLen), 1);
	}

	return result;
}

/**
 * @param {string} text
 * @returns {string}
 */
function encodeHtml(text) {
	return isNormal(text) ? __WEBPACK_IMPORTED_MODULE_2_____default.a.escape(text.toString()) : '';
}

/**
 * @param {string} text
 * @param {number=} len = 100
 * @returns {string}
 */
function splitPlainText(text) {
	var len = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 100;

	var prefix = '',
	    subText = '',
	    result = text,
	    spacePos = 0,
	    newLinePos = 0;

	while (result.length > len) {
		subText = result.substring(0, len);
		spacePos = subText.lastIndexOf(' ');
		newLinePos = subText.lastIndexOf('\n');

		if (-1 !== newLinePos) {
			spacePos = newLinePos;
		}

		if (-1 === spacePos) {
			spacePos = len;
		}

		prefix += subText.substring(0, spacePos) + '\n';
		result = result.substring(spacePos + 1);
	}

	return prefix + result;
}

var timeOutAction = function () {
	var timeOuts = {};
	return function (action, fFunction, timeOut) {
		timeOuts[action] = isUnd(timeOuts[action]) ? 0 : timeOuts[action];
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.clearTimeout(timeOuts[action]);
		timeOuts[action] = __WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(fFunction, timeOut);
	};
}();

var timeOutActionSecond = function () {
	var timeOuts = {};
	return function (action, fFunction, timeOut) {
		if (!timeOuts[action]) {
			timeOuts[action] = __WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {
				fFunction();
				timeOuts[action] = 0;
			}, timeOut);
		}
	};
}();



/**
 * @returns {boolean}
 */
function inFocus() {
	try {
		if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement) {
			if (isUnd(__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement.__inFocusCache)) {
				__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement.__inFocusCache = __WEBPACK_IMPORTED_MODULE_1_____default()(__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement).is('input,textarea,iframe,.cke_editable');
			}

			return !!__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement.__inFocusCache;
		}
	} catch (e) {} // eslint-disable-line no-empty

	return false;
}

/**
 * @param {boolean} force
 * @returns {void}
 */
function removeInFocus(force) {
	if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.document && __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement && __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement.blur) {
		try {
			var activeEl = __WEBPACK_IMPORTED_MODULE_1_____default()(__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement);
			if (activeEl && activeEl.is('input,textarea')) {
				__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement.blur();
			} else if (force) {
				__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement.blur();
			}
		} catch (e) {} // eslint-disable-line no-empty
	}
}

/**
 * @returns {void}
 */
function removeSelection() {
	try {
		if (__WEBPACK_IMPORTED_MODULE_0_window___default.a && __WEBPACK_IMPORTED_MODULE_0_window___default.a.getSelection) {
			var sel = __WEBPACK_IMPORTED_MODULE_0_window___default.a.getSelection();
			if (sel && sel.removeAllRanges) {
				sel.removeAllRanges();
			}
		} else if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.document && __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.selection && __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.selection.empty) {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.selection.empty();
		}
	} catch (e) {} // eslint-disable-line no-empty
}

/**
 * @param {string} prefix
 * @param {string} subject
 * @returns {string}
 */
function replySubjectAdd(prefix, subject) {
	prefix = trim(prefix.toUpperCase());
	subject = trim(subject.replace(/[\s]+/g, ' '));

	var drop = false,
	    re = 'RE' === prefix,
	    fwd = 'FWD' === prefix;

	var parts = [],
	    prefixIsRe = !fwd;

	if ('' !== subject) {
		__WEBPACK_IMPORTED_MODULE_2_____default.a.each(subject.split(':'), function (part) {
			var trimmedPart = trim(part);
			if (!drop && (/^(RE|FWD)$/i.test(trimmedPart) || /^(RE|FWD)[\[\(][\d]+[\]\)]$/i.test(trimmedPart))) {
				if (!re) {
					re = !!/^RE/i.test(trimmedPart);
				}

				if (!fwd) {
					fwd = !!/^FWD/i.test(trimmedPart);
				}
			} else {
				parts.push(part);
				drop = true;
			}
		});
	}

	if (prefixIsRe) {
		re = false;
	} else {
		fwd = false;
	}

	return trim((prefixIsRe ? 'Re: ' : 'Fwd: ') + (re ? 'Re: ' : '') + (fwd ? 'Fwd: ' : '') + trim(parts.join(':')));
}

/**
 * @param {number} num
 * @param {number} dec
 * @returns {number}
 */
function roundNumber(num, dec) {
	return __WEBPACK_IMPORTED_MODULE_0_window___default.a.Math.round(num * __WEBPACK_IMPORTED_MODULE_0_window___default.a.Math.pow(10, dec)) / __WEBPACK_IMPORTED_MODULE_0_window___default.a.Math.pow(10, dec);
}

/**
 * @param {(number|string)} sizeInBytes
 * @returns {string}
 */
function friendlySize(sizeInBytes) {
	sizeInBytes = pInt(sizeInBytes);

	switch (true) {
		case 1073741824 <= sizeInBytes:
			return roundNumber(sizeInBytes / 1073741824, 1) + 'GB';
		case 1048576 <= sizeInBytes:
			return roundNumber(sizeInBytes / 1048576, 1) + 'MB';
		case 1024 <= sizeInBytes:
			return roundNumber(sizeInBytes / 1024, 0) + 'KB';
		// no default
	}

	return sizeInBytes + 'B';
}

/**
 * @param {string} desc
 */
function log(desc) {
	if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.console && __WEBPACK_IMPORTED_MODULE_0_window___default.a.console.log) {
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.console.log(desc);
	}
}

/**
 * @param {?} object
 * @param {string} methodName
 * @param {Array=} params
 * @param {number=} delay = 0
 */
function delegateRun(object, methodName, params) {
	var delay = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;

	if (object && object[methodName]) {
		delay = pInt(delay);
		params = isArray(params) ? params : [];

		if (0 >= delay) {
			object[methodName].apply(object, params);
		} else {
			__WEBPACK_IMPORTED_MODULE_2_____default.a.delay(function () {
				object[methodName].apply(object, params);
			}, delay);
		}
	}
}

/**
 * @param {?} event
 */
function killCtrlACtrlS(event) {
	event = event || __WEBPACK_IMPORTED_MODULE_0_window___default.a.event;
	if (event && event.ctrlKey && !event.shiftKey && !event.altKey) {
		var key = event.keyCode || event.which;
		if (key === __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["EventKeyCode"].S) {
			event.preventDefault();
			return;
		} else if (key === __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["EventKeyCode"].A) {
			var sender = event.target || event.srcElement;
			if (sender && ('true' === '' + sender.contentEditable || sender.tagName && sender.tagName.match(/INPUT|TEXTAREA/i))) {
				return;
			}

			if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.getSelection) {
				__WEBPACK_IMPORTED_MODULE_0_window___default.a.getSelection().removeAllRanges();
			} else if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.selection && __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.selection.clear) {
				__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.selection.clear();
			}

			event.preventDefault();
		}
	}
}

/**
 * @param {(Object|null|undefined)} context
 * @param {Function} fExecute
 * @param {(Function|boolean|null)=} fCanExecute = true
 * @returns {Function}
 */
function createCommandLegacy(context, fExecute) {
	var fCanExecute = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

	var fResult = null;
	var fNonEmpty = function fNonEmpty() {
		for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
			args[_key] = arguments[_key];
		}

		if (fResult && fResult.canExecute && fResult.canExecute()) {
			fExecute.apply(context, args);
		}
		return false;
	};

	fResult = fExecute ? fNonEmpty : noop;
	fResult.enabled = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(true);
	fResult.isCommand = true;

	if (isFunc(fCanExecute)) {
		fResult.canExecute = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].computed(function () {
			return fResult && fResult.enabled() && fCanExecute.call(context);
		});
	} else {
		fResult.canExecute = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].computed(function () {
			return fResult && fResult.enabled() && !!fCanExecute;
		});
	}

	return fResult;
}

/**
 * @param {string} theme
 * @returns {string}
 */
var convertThemeName = __WEBPACK_IMPORTED_MODULE_2_____default.a.memoize(function (theme) {

	if ('@custom' === theme.substr(-7)) {
		theme = trim(theme.substring(0, theme.length - 7));
	}

	return trim(theme.replace(/[^a-zA-Z0-9]+/g, ' ').replace(/([A-Z])/g, ' $1').replace(/[\s]+/g, ' '));
});

/**
 * @param {string} name
 * @returns {string}
 */
function quoteName(name) {
	return name.replace(/["]/g, '\\"');
}

/**
 * @returns {number}
 */
function microtime() {
	return new __WEBPACK_IMPORTED_MODULE_0_window___default.a.Date().getTime();
}

/**
 * @returns {number}
 */
function timestamp() {
	return __WEBPACK_IMPORTED_MODULE_0_window___default.a.Math.round(microtime() / 1000);
}

/**
 *
 * @param {string} language
 * @param {boolean=} isEng = false
 * @returns {string}
 */
function convertLangName(language) {
	var isEng = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

	return __webpack_require__(/*! Common/Translator */ 8).i18n('LANGS_NAMES' + (true === isEng ? '_EN' : '') + '/LANG_' + language.toUpperCase().replace(/[^a-zA-Z0-9]+/g, '_'), null, language);
}

/**
 * @returns {object}
 */
function draggablePlace() {
	return __WEBPACK_IMPORTED_MODULE_1_____default()('<div class="draggablePlace">' + '<span class="text"></span>&nbsp;' + '<i class="icon-copy icon-white visible-on-ctrl"></i>' + '<i class="icon-mail icon-white hidden-on-ctrl"></i>' + '</div>').appendTo('#rl-hidden');
}

/**
 * @param {object} domOption
 * @param {object} item
 * @returns {void}
 */
function defautOptionsAfterRender(domItem, item) {
	if (item && !isUnd(item.disabled) && domItem) {
		__WEBPACK_IMPORTED_MODULE_1_____default()(domItem).toggleClass('disabled', item.disabled).prop('disabled', item.disabled);
	}
}

/**
 * @param {string} title
 * @param {Object} body
 * @param {boolean} isHtml
 * @param {boolean} print
 */
function clearBqSwitcher(body) {
	body.find('blockquote.rl-bq-switcher').removeClass('rl-bq-switcher hidden-bq');
	body.find('.rlBlockquoteSwitcher').off('.rlBlockquoteSwitcher').remove();
	body.find('[data-html-editor-font-wrapper]').removeAttr('data-html-editor-font-wrapper');
}

/**
 * @param {object} messageData
 * @param {Object} body
 * @param {boolean} isHtml
 * @param {boolean} print
 * @returns {void}
 */
function previewMessage(_ref, body, isHtml, print) {
	var title = _ref.title,
	    subject = _ref.subject,
	    date = _ref.date,
	    fromCreds = _ref.fromCreds,
	    toCreds = _ref.toCreds,
	    toLabel = _ref.toLabel,
	    ccClass = _ref.ccClass,
	    ccCreds = _ref.ccCreds,
	    ccLabel = _ref.ccLabel;

	var win = __WEBPACK_IMPORTED_MODULE_0_window___default.a.open(''),
	    doc = win.document,
	    bodyClone = body.clone(),
	    bodyClass = isHtml ? 'html' : 'plain';

	clearBqSwitcher(bodyClone);

	var html = bodyClone ? bodyClone.html() : '';

	doc.write(__webpack_require__(/*! Html/PreviewMessage.html */ 109).replace('{{title}}', encodeHtml(title)).replace('{{subject}}', encodeHtml(subject)).replace('{{date}}', encodeHtml(date)).replace('{{fromCreds}}', encodeHtml(fromCreds)).replace('{{toCreds}}', encodeHtml(toCreds)).replace('{{toLabel}}', encodeHtml(toLabel)).replace('{{ccClass}}', encodeHtml(ccClass)).replace('{{ccCreds}}', encodeHtml(ccCreds)).replace('{{ccLabel}}', encodeHtml(ccLabel)).replace('{{bodyClass}}', bodyClass).replace('{{html}}', html));

	doc.close();

	if (print) {
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {
			return win.print();
		}, 100);
	}
}

/**
 * @param {Function} fCallback
 * @param {?} koTrigger
 * @param {?} context = null
 * @param {number=} timer = 1000
 * @returns {Function}
 */
function settingsSaveHelperFunction(fCallback, koTrigger) {
	var context = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
	var timer = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1000;

	timer = pInt(timer);
	return function (type, data, cached, requestAction, requestParameters) {
		koTrigger.call(context, data && data.Result ? __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["SaveSettingsStep"].TrueResult : __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["SaveSettingsStep"].FalseResult);
		if (fCallback) {
			fCallback.call(context, type, data, cached, requestAction, requestParameters);
		}
		__WEBPACK_IMPORTED_MODULE_2_____default.a.delay(function () {
			koTrigger.call(context, __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["SaveSettingsStep"].Idle);
		}, timer);
	};
}

/**
 * @param {object} koTrigger
 * @param {mixed} context
 * @returns {mixed}
 */
function settingsSaveHelperSimpleFunction(koTrigger, context) {
	return settingsSaveHelperFunction(null, koTrigger, context, 1000);
}

/**
 * @param {object} remote
 * @param {string} settingName
 * @param {string} type
 * @param {function} fTriggerFunction
 * @returns {function}
 */
function settingsSaveHelperSubscribeFunction(remote, settingName, type, fTriggerFunction) {
	return function (value) {

		if (remote) {
			switch (type) {
				case 'bool':
				case 'boolean':
					value = value ? '1' : '0';
					break;
				case 'int':
				case 'integer':
				case 'number':
					value = pInt(value);
					break;
				case 'trim':
					value = trim(value);
					break;
				default:
					value = pString(value);
					break;
			}

			var data = {};
			data[settingName] = value;

			if (remote.saveAdminConfig) {
				remote.saveAdminConfig(fTriggerFunction || null, data);
			} else if (remote.saveSettings) {
				remote.saveSettings(fTriggerFunction || null, data);
			}
		}
	};
}

/**
 * @param {string} html
 * @returns {string}
 */
function findEmailAndLinks(html) {
	//	return html;
	return __WEBPACK_IMPORTED_MODULE_4_Autolinker___default.a ? __WEBPACK_IMPORTED_MODULE_4_Autolinker___default.a.link(html, {
		newWindow: true,
		stripPrefix: false,
		urls: true,
		email: true,
		mention: false,
		phone: false,
		hashtag: false,
		replaceFn: function replaceFn(match) {
			return !(match && 'url' === match.getType() && match.matchedText && 0 !== match.matchedText.indexOf('http'));
		}
	}) : html;
}

/**
 * @param {string} html
 * @returns {string}
 */
function htmlToPlain(html) {
	var pos = 0,
	    limit = 0,
	    iP1 = 0,
	    iP2 = 0,
	    iP3 = 0,
	    text = '';

	var convertBlockquote = function convertBlockquote(blockquoteText) {
		blockquoteText = '> ' + trim(blockquoteText).replace(/\n/gm, '\n> ');
		return blockquoteText.replace(/(^|\n)([> ]+)/gm, function () {
			for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
				args[_key2] = arguments[_key2];
			}

			return args && 2 < args.length ? args[1] + trim(args[2].replace(/[\s]/g, '')) + ' ' : '';
		});
	};

	var convertDivs = function convertDivs() {
		for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
			args[_key3] = arguments[_key3];
		}

		if (args && 1 < args.length) {
			var divText = trim(args[1]);
			if (0 < divText.length) {
				divText = divText.replace(/<div[^>]*>([\s\S\r\n]*)<\/div>/gmi, convertDivs);
				divText = '\n' + trim(divText) + '\n';
			}

			return divText;
		}

		return '';
	};

	var convertPre = function convertPre() {
		for (var _len4 = arguments.length, args = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
			args[_key4] = arguments[_key4];
		}

		return args && 1 < args.length ? args[1].toString().replace(/[\n]/gm, '<br />').replace(/[\r]/gm, '') : '';
	},
	    fixAttibuteValue = function fixAttibuteValue() {
		for (var _len5 = arguments.length, args = Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
			args[_key5] = arguments[_key5];
		}

		return args && 1 < args.length ? '' + args[1] + __WEBPACK_IMPORTED_MODULE_2_____default.a.escape(args[2]) : '';
	},
	    convertLinks = function convertLinks() {
		for (var _len6 = arguments.length, args = Array(_len6), _key6 = 0; _key6 < _len6; _key6++) {
			args[_key6] = arguments[_key6];
		}

		return args && 1 < args.length ? trim(args[1]) : '';
	};

	text = html.replace(/<p[^>]*><\/p>/gi, '').replace(/<pre[^>]*>([\s\S\r\n\t]*)<\/pre>/gmi, convertPre).replace(/[\s]+/gm, ' ').replace(/((?:href|data)\s?=\s?)("[^"]+?"|'[^']+?')/gmi, fixAttibuteValue).replace(/<br[^>]*>/gmi, '\n').replace(/<\/h[\d]>/gi, '\n').replace(/<\/p>/gi, '\n\n').replace(/<ul[^>]*>/gmi, '\n').replace(/<\/ul>/gi, '\n').replace(/<li[^>]*>/gmi, ' * ').replace(/<\/li>/gi, '\n').replace(/<\/td>/gi, '\n').replace(/<\/tr>/gi, '\n').replace(/<hr[^>]*>/gmi, '\n_______________________________\n\n').replace(/<div[^>]*>([\s\S\r\n]*)<\/div>/gmi, convertDivs).replace(/<blockquote[^>]*>/gmi, '\n__bq__start__\n').replace(/<\/blockquote>/gmi, '\n__bq__end__\n').replace(/<a [^>]*>([\s\S\r\n]*?)<\/a>/gmi, convertLinks).replace(/<\/div>/gi, '\n').replace(/&nbsp;/gi, ' ').replace(/&quot;/gi, '"').replace(/<[^>]*>/gm, '');

	text = __WEBPACK_IMPORTED_MODULE_5_Common_Globals__["$div"].html(text).text();

	text = text.replace(/\n[ \t]+/gm, '\n').replace(/[\n]{3,}/gm, '\n\n').replace(/&gt;/gi, '>').replace(/&lt;/gi, '<').replace(/&amp;/gi, '&');

	text = splitPlainText(text);

	pos = 0;
	limit = 800;

	while (0 < limit) {
		limit -= 1;
		iP1 = text.indexOf('__bq__start__', pos);
		if (-1 < iP1) {
			iP2 = text.indexOf('__bq__start__', iP1 + 5);
			iP3 = text.indexOf('__bq__end__', iP1 + 5);

			if ((-1 === iP2 || iP3 < iP2) && iP1 < iP3) {
				text = text.substring(0, iP1) + convertBlockquote(text.substring(iP1 + 13, iP3)) + text.substring(iP3 + 11);

				pos = 0;
			} else if (-1 < iP2 && iP2 < iP3) {
				pos = iP2 - 1;
			} else {
				pos = 0;
			}
		} else {
			break;
		}
	}

	text = text.replace(/__bq__start__/gm, '').replace(/__bq__end__/gm, '');

	return text;
}

/**
 * @param {string} plain
 * @param {boolean} findEmailAndLinksInText = false
 * @returns {string}
 */
function plainToHtml(plain) {
	var findEmailAndLinksInText = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

	plain = plain.toString().replace(/\r/g, '');
	plain = plain.replace(/^>[> ]>+/gm, function (_ref2) {
		var match = _ref2[0];
		return match ? match.replace(/[ ]+/g, '') : match;
	});

	var bIn = false,
	    bDo = true,
	    bStart = true,
	    aNextText = [],
	    sLine = '',
	    iIndex = 0,
	    aText = plain.split('\n');

	do {
		bDo = false;
		aNextText = [];
		for (iIndex = 0; iIndex < aText.length; iIndex++) {
			sLine = aText[iIndex];
			bStart = '>' === sLine.substr(0, 1);
			if (bStart && !bIn) {
				bDo = true;
				bIn = true;
				aNextText.push('~~~blockquote~~~');
				aNextText.push(sLine.substr(1));
			} else if (!bStart && bIn) {
				if ('' !== sLine) {
					bIn = false;
					aNextText.push('~~~/blockquote~~~');
					aNextText.push(sLine);
				} else {
					aNextText.push(sLine);
				}
			} else if (bStart && bIn) {
				aNextText.push(sLine.substr(1));
			} else {
				aNextText.push(sLine);
			}
		}

		if (bIn) {
			bIn = false;
			aNextText.push('~~~/blockquote~~~');
		}

		aText = aNextText;
	} while (bDo);

	plain = aText.join('\n');

	plain = plain
	// .replace(/~~~\/blockquote~~~\n~~~blockquote~~~/g, '\n')
	.replace(/&/g, '&amp;').replace(/>/g, '&gt;').replace(/</g, '&lt;').replace(/~~~blockquote~~~[\s]*/g, '<blockquote>').replace(/[\s]*~~~\/blockquote~~~/g, '</blockquote>').replace(/\n/g, '<br />');

	return findEmailAndLinksInText ? findEmailAndLinks(plain) : plain;
}

__WEBPACK_IMPORTED_MODULE_0_window___default.a['rainloop_Utils_htmlToPlain'] = htmlToPlain; // eslint-disable-line dot-notation
__WEBPACK_IMPORTED_MODULE_0_window___default.a['rainloop_Utils_plainToHtml'] = plainToHtml; // eslint-disable-line dot-notation

/**
 * @param {Array} aSystem
 * @param {Array} aList
 * @param {Array=} aDisabled
 * @param {Array=} aHeaderLines
 * @param {?number=} iUnDeep
 * @param {Function=} fDisableCallback
 * @param {Function=} fVisibleCallback
 * @param {Function=} fRenameCallback
 * @param {boolean=} bSystem
 * @param {boolean=} bBuildUnvisible
 * @returns {Array}
 */
function folderListOptionsBuilder(aSystem, aList, aDisabled, aHeaderLines, iUnDeep, fDisableCallback, fVisibleCallback, fRenameCallback, bSystem, bBuildUnvisible) {
	var
	/**
  * @type {?FolderModel}
  */
	oItem = null,
	    bSep = false,
	    iIndex = 0,
	    iLen = 0,
	    aResult = [];

	var sDeepPrefix = '\xA0\xA0\xA0';

	bBuildUnvisible = isUnd(bBuildUnvisible) ? false : !!bBuildUnvisible;
	bSystem = !isNormal(bSystem) ? 0 < aSystem.length : bSystem;
	iUnDeep = !isNormal(iUnDeep) ? 0 : iUnDeep;
	fDisableCallback = isNormal(fDisableCallback) ? fDisableCallback : null;
	fVisibleCallback = isNormal(fVisibleCallback) ? fVisibleCallback : null;
	fRenameCallback = isNormal(fRenameCallback) ? fRenameCallback : null;

	if (!isArray(aDisabled)) {
		aDisabled = [];
	}

	if (!isArray(aHeaderLines)) {
		aHeaderLines = [];
	}

	for (iIndex = 0, iLen = aHeaderLines.length; iIndex < iLen; iIndex++) {
		aResult.push({
			id: aHeaderLines[iIndex][0],
			name: aHeaderLines[iIndex][1],
			system: false,
			seporator: false,
			disabled: false
		});
	}

	bSep = true;
	for (iIndex = 0, iLen = aSystem.length; iIndex < iLen; iIndex++) {
		oItem = aSystem[iIndex];
		if (fVisibleCallback ? fVisibleCallback(oItem) : true) {
			if (bSep && 0 < aResult.length) {
				aResult.push({
					id: '---',
					name: '---',
					system: false,
					seporator: true,
					disabled: true
				});
			}

			bSep = false;
			aResult.push({
				id: oItem.fullNameRaw,
				name: fRenameCallback ? fRenameCallback(oItem) : oItem.name(),
				system: true,
				seporator: false,
				disabled: !oItem.selectable || -1 < inArray(oItem.fullNameRaw, aDisabled) || (fDisableCallback ? fDisableCallback(oItem) : false)
			});
		}
	}

	bSep = true;
	for (iIndex = 0, iLen = aList.length; iIndex < iLen; iIndex++) {
		oItem = aList[iIndex];
		// if (oItem.subScribed() || !oItem.existen || bBuildUnvisible)
		if ((oItem.subScribed() || !oItem.existen || bBuildUnvisible) && (oItem.selectable || oItem.hasSubScribedSubfolders())) {
			if (fVisibleCallback ? fVisibleCallback(oItem) : true) {
				if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FolderType"].User === oItem.type() || !bSystem || oItem.hasSubScribedSubfolders()) {
					if (bSep && 0 < aResult.length) {
						aResult.push({
							id: '---',
							name: '---',
							system: false,
							seporator: true,
							disabled: true
						});
					}

					bSep = false;
					aResult.push({
						id: oItem.fullNameRaw,
						name: new __WEBPACK_IMPORTED_MODULE_0_window___default.a.Array(oItem.deep + 1 - iUnDeep).join(sDeepPrefix) + (fRenameCallback ? fRenameCallback(oItem) : oItem.name()),
						system: false,
						seporator: false,
						disabled: !oItem.selectable || -1 < inArray(oItem.fullNameRaw, aDisabled) || (fDisableCallback ? fDisableCallback(oItem) : false)
					});
				}
			}
		}

		if (oItem.subScribed() && 0 < oItem.subFolders().length) {
			aResult = aResult.concat(folderListOptionsBuilder([], oItem.subFolders(), aDisabled, [], iUnDeep, fDisableCallback, fVisibleCallback, fRenameCallback, bSystem, bBuildUnvisible));
		}
	}

	return aResult;
}

/**
 * @param {object} element
 * @returns {void}
 */
function selectElement(element) {
	var sel = null,
	    range = null;

	if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.getSelection) {
		sel = __WEBPACK_IMPORTED_MODULE_0_window___default.a.getSelection();
		sel.removeAllRanges();
		range = __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.createRange();
		range.selectNodeContents(element);
		sel.addRange(range);
	} else if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.selection) {
		range = __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.body.createTextRange();
		range.moveToElementText(element);
		range.select();
	}
}

var detectDropdownVisibility = __WEBPACK_IMPORTED_MODULE_2_____default.a.debounce(function () {
	Object(__WEBPACK_IMPORTED_MODULE_5_Common_Globals__["dropdownVisibility"])(!!__WEBPACK_IMPORTED_MODULE_2_____default.a.find(__WEBPACK_IMPORTED_MODULE_5_Common_Globals__["data"].aBootstrapDropdowns, function (item) {
		return item.hasClass('open');
	}));
}, 50);

/**
 * @param {boolean=} delay = false
 */
function triggerAutocompleteInputChange() {
	var delay = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;


	var fFunc = function fFunc() {
		__WEBPACK_IMPORTED_MODULE_1_____default()('.checkAutocomplete').trigger('change');
	};

	if (delay) {
		__WEBPACK_IMPORTED_MODULE_2_____default.a.delay(fFunc, 100);
	} else {
		fFunc();
	}
}

var configurationScriptTagCache = {};

/**
 * @param {string} configuration
 * @returns {object}
 */
function getConfigurationFromScriptTag(configuration) {
	if (!configurationScriptTagCache[configuration]) {
		configurationScriptTagCache[configuration] = __WEBPACK_IMPORTED_MODULE_1_____default()('script[type="application/json"][data-configuration="' + configuration + '"]');
	}

	try {
		return JSON.parse(configurationScriptTagCache[configuration].text());
	} catch (e) {} // eslint-disable-line no-empty

	return {};
}

/**
 * @param {mixed} mPropOrValue
 * @param {mixed} value
 */
function disposeOne(propOrValue, value) {
	var disposable = value || propOrValue;
	if (disposable && 'function' === typeof disposable.dispose) {
		disposable.dispose();
	}
}

/**
 * @param {Object} object
 */
function disposeObject(object) {
	if (object) {
		if (isArray(object.disposables)) {
			__WEBPACK_IMPORTED_MODULE_2_____default.a.each(object.disposables, disposeOne);
		}

		__WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].utils.objectForEach(object, disposeOne);
	}
}

/**
 * @param {Object|Array} objectOrObjects
 * @returns {void}
 */
function delegateRunOnDestroy(objectOrObjects) {
	if (objectOrObjects) {
		if (isArray(objectOrObjects)) {
			__WEBPACK_IMPORTED_MODULE_2_____default.a.each(objectOrObjects, function (item) {
				delegateRunOnDestroy(item);
			});
		} else if (objectOrObjects && objectOrObjects.onDestroy) {
			objectOrObjects.onDestroy();
		}
	}
}

/**
 * @param {object} $styleTag
 * @param {string} css
 * @returns {boolean}
 */
function appendStyles($styleTag, css) {
	if ($styleTag && $styleTag[0]) {
		if ($styleTag[0].styleSheet && !isUnd($styleTag[0].styleSheet.cssText)) {
			$styleTag[0].styleSheet.cssText = css;
		} else {
			$styleTag.text(css);
		}

		return true;
	}

	return false;
}

var __themeTimer = 0,
    __themeAjax = null;

/**
 * @param {string} value
 * @param {function=} themeTrigger = noop
 * @returns {void}
 */
function changeTheme(value) {
	var themeTrigger = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : noop;

	var themeLink = __WEBPACK_IMPORTED_MODULE_1_____default()('#app-theme-link'),
	    clearTimer = function clearTimer() {
		__themeTimer = __WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {
			return themeTrigger(__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["SaveSettingsStep"].Idle);
		}, 1000);
		__themeAjax = null;
	};

	var themeStyle = __WEBPACK_IMPORTED_MODULE_1_____default()('#app-theme-style'),
	    url = themeLink.attr('href');

	if (!url) {
		url = themeStyle.attr('data-href');
	}

	if (url) {
		url = url.toString().replace(/\/-\/[^\/]+\/\-\//, '/-/' + value + '/-/');
		url = url.replace(/\/Css\/[^\/]+\/User\//, '/Css/0/User/');
		url = url.replace(/\/Hash\/[^\/]+\//, '/Hash/-/');

		if ('Json/' !== url.substring(url.length - 5, url.length)) {
			url += 'Json/';
		}

		__WEBPACK_IMPORTED_MODULE_0_window___default.a.clearTimeout(__themeTimer);

		themeTrigger(__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["SaveSettingsStep"].Animate);

		if (__themeAjax && __themeAjax.abort) {
			__themeAjax.abort();
		}

		__themeAjax = __WEBPACK_IMPORTED_MODULE_1_____default.a.ajax({
			url: url,
			dataType: 'json'
		}).then(function (data) {

			if (data && isArray(data) && 2 === data.length) {
				if (themeLink && themeLink[0] && (!themeStyle || !themeStyle[0])) {
					themeStyle = __WEBPACK_IMPORTED_MODULE_1_____default()('<style id="app-theme-style"></style>');
					themeLink.after(themeStyle);
					themeLink.remove();
				}

				if (themeStyle && themeStyle[0]) {
					if (appendStyles(themeStyle, data[1])) {
						themeStyle.attr('data-href', url).attr('data-theme', data[0]);
					}
				}

				themeTrigger(__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["SaveSettingsStep"].TrueResult);
			}
		}).then(clearTimer, clearTimer);
	}
}

/**
 * @returns {function}
 */
function computedPagenatorHelper(koCurrentPage, koPageCount) {
	return function () {

		var currentPage = koCurrentPage(),
		    pageCount = koPageCount(),
		    result = [],
		    fAdd = function fAdd(index) {
			var push = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
			var customName = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';


			var data = {
				current: index === currentPage,
				name: '' === customName ? index.toString() : customName.toString(),
				custom: '' !== customName,
				title: '' === customName ? '' : index.toString(),
				value: index.toString()
			};

			if (push) {
				result.push(data);
			} else {
				result.unshift(data);
			}
		};

		var prev = 0,
		    next = 0,
		    limit = 2;

		if (1 < pageCount || 0 < pageCount && pageCount < currentPage) {
			if (pageCount < currentPage) {
				fAdd(pageCount);
				prev = pageCount;
				next = pageCount;
			} else {
				if (3 >= currentPage || pageCount - 2 <= currentPage) {
					limit += 2;
				}

				fAdd(currentPage);
				prev = currentPage;
				next = currentPage;
			}

			while (0 < limit) {

				prev -= 1;
				next += 1;

				if (0 < prev) {
					fAdd(prev, false);
					limit -= 1;
				}

				if (pageCount >= next) {
					fAdd(next, true);
					limit -= 1;
				} else if (0 >= prev) {
					break;
				}
			}

			if (3 === prev) {
				fAdd(2, false);
			} else if (3 < prev) {
				fAdd(Math.round((prev - 1) / 2), false, '...');
			}

			if (pageCount - 2 === next) {
				fAdd(pageCount - 1, true);
			} else if (pageCount - 2 > next) {
				fAdd(Math.round((pageCount + next) / 2), true, '...');
			}

			// first and last
			if (1 < prev) {
				fAdd(1, false);
			}

			if (pageCount > next) {
				fAdd(pageCount, true);
			}
		}

		return result;
	};
}

/**
 * @param {string} fileName
 * @returns {string}
 */
function getFileExtension(fileName) {
	fileName = trim(fileName).toLowerCase();

	var result = fileName.split('.').pop();
	return result === fileName ? '' : result;
}

/**
 * @param {string} fileName
 * @returns {string}
 */
function mimeContentType(fileName) {
	var ext = '',
	    result = 'application/octet-stream';

	fileName = trim(fileName).toLowerCase();

	if ('winmail.dat' === fileName) {
		return 'application/ms-tnef';
	}

	ext = getFileExtension(fileName);
	if (ext && 0 < ext.length && !isUnd(__WEBPACK_IMPORTED_MODULE_7_Common_Mime__["a" /* Mime */][ext])) {
		result = __WEBPACK_IMPORTED_MODULE_7_Common_Mime__["a" /* Mime */][ext];
	}

	return result;
}

/**
 * @param {string} color
 * @returns {boolean}
 */
function isTransparent(color) {
	return 'rgba(0, 0, 0, 0)' === color || 'transparent' === color;
}

/**
 * @param {Object} $el
 * @returns {number}
 */
function getRealHeight($el) {
	$el.clone().show().appendTo(__WEBPACK_IMPORTED_MODULE_5_Common_Globals__["$hcont"]);
	var result = __WEBPACK_IMPORTED_MODULE_5_Common_Globals__["$hcont"].height();
	__WEBPACK_IMPORTED_MODULE_5_Common_Globals__["$hcont"].empty();
	return result;
}

/**
 * @param {string} url
 * @param {number} value
 * @param {Function} fCallback
 */
function resizeAndCrop(url, value, fCallback) {
	var img = new __WEBPACK_IMPORTED_MODULE_0_window___default.a.Image();
	img.onload = function () {

		var diff = [0, 0];

		var canvas = __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.createElement('canvas'),
		    ctx = canvas.getContext('2d');

		canvas.width = value;
		canvas.height = value;

		if (this.width > this.height) {
			diff = [this.width - this.height, 0];
		} else {
			diff = [0, this.height - this.width];
		}

		ctx.fillStyle = '#fff';
		ctx.fillRect(0, 0, value, value);
		ctx.drawImage(this, diff[0] / 2, diff[1] / 2, this.width - diff[0], this.height - diff[1], 0, 0, value, value);

		fCallback(canvas.toDataURL('image/jpeg'));
	};

	img.src = url;
}

/**
 * @param {string} mailToUrl
 * @param {Function} PopupComposeVoreModel
 * @returns {boolean}
 */
function mailToHelper(mailToUrl, PopupComposeVoreModel) {
	if (mailToUrl && 'mailto:' === mailToUrl.toString().substr(0, 7).toLowerCase()) {
		if (!PopupComposeVoreModel) {
			return true;
		}

		mailToUrl = mailToUrl.toString().substr(7);

		var to = [],
		    cc = null,
		    bcc = null,
		    params = {};

		var email = mailToUrl.replace(/\?.+$/, ''),
		    query = mailToUrl.replace(/^[^\?]*\?/, ''),
		    EmailModel = __webpack_require__(/*! Model/Email */ 44).default,
		    emailObj = new EmailModel(),
		    fParseEmailLine = function fParseEmailLine(line) {
			return line ? __WEBPACK_IMPORTED_MODULE_2_____default.a.compact(__WEBPACK_IMPORTED_MODULE_2_____default.a.map(decodeURIComponent(line).split(/[,]/), function (item) {
				emailObj.clear();
				emailObj.mailsoParse(item);
				return '' !== emailObj.email ? emailObj : null;
			})) : null;
		};

		to = fParseEmailLine(email);
		params = simpleQueryParser(query);

		if (!isUnd(params.cc)) {
			cc = fParseEmailLine(decodeURIComponent(params.cc));
		}

		if (!isUnd(params.bcc)) {
			bcc = fParseEmailLine(decodeURIComponent(params.bcc));
		}

		__webpack_require__(/*! Knoin/Knoin */ 9).showScreenPopup(PopupComposeVoreModel, [__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["ComposeType"].Empty, null, to, cc, bcc, isUnd(params.subject) ? null : pString(decodeURIComponent(params.subject)), isUnd(params.body) ? null : plainToHtml(pString(decodeURIComponent(params.body)))]);

		return true;
	}

	return false;
}

/**
 * @param {Function} fn
 * @returns {void}
 */
function domReady(fn) {
	__WEBPACK_IMPORTED_MODULE_1_____default()(function () {
		return fn();
	});
	//
	//	if ('loading' !== window.document.readyState)
	//	{
	//		fn();
	//	}
	//	else
	//	{
	//		window.document.addEventListener('DOMContentLoaded', fn);
	//	}
}

var windowResize = __WEBPACK_IMPORTED_MODULE_2_____default.a.debounce(function (timeout) {
	if (isUnd(timeout) || isNull(timeout)) {
		__WEBPACK_IMPORTED_MODULE_5_Common_Globals__["$win"].resize();
	} else {
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {
			__WEBPACK_IMPORTED_MODULE_5_Common_Globals__["$win"].resize();
		}, timeout);
	}
}, 50);

/**
 * @returns {void}
 */
function windowResizeCallback() {
	windowResize();
}

var substr = __WEBPACK_IMPORTED_MODULE_0_window___default.a.String.substr;
if ('b' !== 'ab'.substr(-1)) {
	substr = function substr(str, start, length) {
		start = 0 > start ? str.length + start : start;
		return str.substr(start, length);
	};

	__WEBPACK_IMPORTED_MODULE_0_window___default.a.String.substr = substr;
}

/***/ }),
/* 2 */
/*!****************************!*\
  !*** ./dev/External/ko.js ***!
  \****************************/
/*! exports provided: default */
/*! exports used: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! $ */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Opentip__ = __webpack_require__(/*! Opentip */ 105);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_pikaday__ = __webpack_require__(/*! pikaday */ 106);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_pikaday___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_pikaday__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);









var ko = __WEBPACK_IMPORTED_MODULE_0_window___default.a.ko,
    $win = __WEBPACK_IMPORTED_MODULE_2_____default()(__WEBPACK_IMPORTED_MODULE_0_window___default.a),
    fDisposalTooltipHelper = function fDisposalTooltipHelper(element) {
	ko.utils.domNodeDisposal.addDisposeCallback(element, function () {
		if (element && element.__opentip) {
			element.__opentip.deactivate();
		}
	});
};

ko.bindingHandlers.updateWidth = {
	init: function init(element, fValueAccessor) {
		var $el = __WEBPACK_IMPORTED_MODULE_2_____default()(element),
		    fValue = fValueAccessor(),
		    fInit = function fInit() {
			fValue($el.width());
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {
				fValue($el.width());
			}, __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Magics"].Time500ms);
		};

		$win.on('resize', fInit);
		fInit();

		ko.utils.domNodeDisposal.addDisposeCallback(element, function () {
			$win.off('resize', fInit);
		});
	}
};

ko.bindingHandlers.editor = {
	init: function init(element, fValueAccessor) {

		var editor = null;

		var fValue = fValueAccessor(),
		    HtmlEditor = __webpack_require__(/*! Common/HtmlEditor */ 85).default,
		    fUpdateEditorValue = function fUpdateEditorValue() {
			if (fValue && fValue.__editor) {
				fValue.__editor.setHtmlOrPlain(fValue());
			}
		},
		    fUpdateKoValue = function fUpdateKoValue() {
			if (fValue && fValue.__editor) {
				fValue(fValue.__editor.getDataWithHtmlMark());
			}
		},
		    fOnReady = function fOnReady() {
			fValue.__editor = editor;
			fUpdateEditorValue();
		};

		if (ko.isObservable(fValue) && HtmlEditor) {
			editor = new HtmlEditor(element, fUpdateKoValue, fOnReady, fUpdateKoValue);

			fValue.__fetchEditorValue = fUpdateKoValue;

			fValue.subscribe(fUpdateEditorValue);

			// ko.utils.domNodeDisposal.addDisposeCallback(element, () => {
			// });
		}
	}
};

ko.bindingHandlers.json = {
	init: function init(element, fValueAccessor) {
		__WEBPACK_IMPORTED_MODULE_2_____default()(element).text(__WEBPACK_IMPORTED_MODULE_0_window___default.a.JSON.stringify(ko.unwrap(fValueAccessor())));
	},
	update: function update(element, fValueAccessor) {
		__WEBPACK_IMPORTED_MODULE_2_____default()(element).text(__WEBPACK_IMPORTED_MODULE_0_window___default.a.JSON.stringify(ko.unwrap(fValueAccessor())));
	}
};

ko.bindingHandlers.scrollerShadows = {
	init: function init(element) {

		var limit = 8,
		    $el = __WEBPACK_IMPORTED_MODULE_2_____default()(element),
		    cont = $el.find('[data-scroller-shadows-content]')[0] || null,
		    fFunc = __WEBPACK_IMPORTED_MODULE_1_____default.a.throttle(function () {
			$el.toggleClass('scroller-shadow-top', limit < cont.scrollTop).toggleClass('scroller-shadow-bottom', cont.scrollTop + limit < cont.scrollHeight - cont.clientHeight);
		}, 100);

		if (cont) {
			__WEBPACK_IMPORTED_MODULE_2_____default()(cont).on('scroll resize', fFunc);
			$win.on('resize', fFunc);

			ko.utils.domNodeDisposal.addDisposeCallback(cont, function () {
				__WEBPACK_IMPORTED_MODULE_2_____default()(cont).off();
				$win.off('resize', fFunc);
			});
		}
	}
};

ko.bindingHandlers.pikaday = {
	init: function init(element, fValueAccessor, fAllBindingsAccessor, viewModel, bindingContext) {

		ko.bindingHandlers.textInput.init(element, fValueAccessor, fAllBindingsAccessor, viewModel, bindingContext);

		if (__WEBPACK_IMPORTED_MODULE_4_pikaday___default.a) {
			element.__pikaday = new __WEBPACK_IMPORTED_MODULE_4_pikaday___default.a({
				field: element
			});
		}
	}
};

ko.bindingHandlers.visibleAnimated = {
	init: function init(element, fValueAccessor) {
		var $el = __WEBPACK_IMPORTED_MODULE_2_____default()(element);
		$el.addClass('rl-animated-inited');
		if (ko.unwrap(fValueAccessor())) {
			$el.show();
		} else {
			$el.hide();
		}
	},
	update: function update(element, fValueAccessor) {
		var $el = __WEBPACK_IMPORTED_MODULE_2_____default()(element);
		if (ko.unwrap(fValueAccessor())) {
			$el.addClass('rl-animated-hidden').show();
			__WEBPACK_IMPORTED_MODULE_1_____default.a.delay(function () {
				$el.removeClass('rl-animated-hidden');
			}, 10);
		} else {
			$el.hide().removeClass('rl-animated-hidden');
		}
	}
};

ko.bindingHandlers.tooltip = {
	init: function init(element, fValueAccessor) {

		var $el = __WEBPACK_IMPORTED_MODULE_2_____default()(element),
		    fValue = fValueAccessor(),
		    isMobile = 'on' === ($el.data('tooltip-mobile') || 'off'),
		    Globals = __webpack_require__(/*! Common/Globals */ 7);

		if (!Globals.bMobileDevice || isMobile) {
			var sValue = !ko.isObservable(fValue) && __WEBPACK_IMPORTED_MODULE_1_____default.a.isFunction(fValue) ? fValue() : ko.unwrap(fValue);

			element.__opentip = new __WEBPACK_IMPORTED_MODULE_3_Opentip__["a" /* default */](element, {
				'style': 'rainloopTip',
				'element': element,
				'tipJoint': $el.data('tooltip-join') || 'bottom'
			});

			Globals.dropdownVisibility.subscribe(function (v) {
				if (v) {
					element.__opentip.hide();
				}
			});

			if ('' === sValue) {
				element.__opentip.hide();
				element.__opentip.deactivate();
				element.__opentip.setContent('');
			} else {
				element.__opentip.activate();
			}

			if ('on' === ($el.data('tooltip-i18n') || 'on')) {
				var Translator = __webpack_require__(/*! Common/Translator */ 8);

				element.__opentip.setContent(Translator.i18n(sValue));

				Translator.trigger.subscribe(function () {
					element.__opentip.setContent(Translator.i18n(sValue));
				});

				Globals.dropdownVisibility.subscribe(function () {
					if (element && element.__opentip) {
						element.__opentip.setContent(Translator.i18n(sValue));
					}
				});
			} else {
				element.__opentip.setContent(sValue);
			}

			$win.on('rl.tooltips.diactivate', function () {
				element.__opentip.hide();
				element.__opentip.deactivate();
			});

			$win.on('rl.tooltips.activate', function () {
				element.__opentip.activate();
			});
		}
	},
	update: function update(element, fValueAccessor) {

		var $el = __WEBPACK_IMPORTED_MODULE_2_____default()(element),
		    fValue = fValueAccessor(),
		    isMobile = 'on' === ($el.data('tooltip-mobile') || 'off'),
		    Globals = __webpack_require__(/*! Common/Globals */ 7);

		if ((!Globals.bMobileDevice || isMobile) && element.__opentip) {
			var sValue = !ko.isObservable(fValue) && __WEBPACK_IMPORTED_MODULE_1_____default.a.isFunction(fValue) ? fValue() : ko.unwrap(fValue);
			if (sValue) {
				element.__opentip.setContent('on' === ($el.data('tooltip-i18n') || 'on') ? __webpack_require__(/*! Common/Translator */ 8).i18n(sValue) : sValue);

				element.__opentip.activate();
			} else {
				element.__opentip.hide();
				element.__opentip.deactivate();
				element.__opentip.setContent('');
			}
		}
	}
};

ko.bindingHandlers.tooltipErrorTip = {
	init: function init(element) {

		var $el = __WEBPACK_IMPORTED_MODULE_2_____default()(element);

		element.__opentip = new __WEBPACK_IMPORTED_MODULE_3_Opentip__["a" /* default */](element, {
			style: 'rainloopErrorTip',
			hideOn: 'mouseout click',
			element: element,
			tipJoint: $el.data('tooltip-join') || 'top'
		});

		element.__opentip.deactivate();

		__WEBPACK_IMPORTED_MODULE_2_____default()(__WEBPACK_IMPORTED_MODULE_0_window___default.a.document).on('click', function () {
			if (element && element.__opentip) {
				element.__opentip.hide();
			}
		});

		fDisposalTooltipHelper(element);
	},
	update: function update(element, fValueAccessor) {

		var $el = __WEBPACK_IMPORTED_MODULE_2_____default()(element),
		    fValue = fValueAccessor(),
		    value = !ko.isObservable(fValue) && __WEBPACK_IMPORTED_MODULE_1_____default.a.isFunction(fValue) ? fValue() : ko.unwrap(fValue),
		    openTips = element.__opentip;

		if (openTips) {
			if ('' === value) {
				openTips.hide();
				openTips.deactivate();
				openTips.setContent('');
			} else {
				__WEBPACK_IMPORTED_MODULE_1_____default.a.delay(function () {
					if ($el.is(':visible')) {
						openTips.setContent(value);
						openTips.activate();
						openTips.show();
					} else {
						openTips.hide();
						openTips.deactivate();
						openTips.setContent('');
					}
				}, __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Magics"].Time100ms);
			}
		}
	}
};

ko.bindingHandlers.registrateBootstrapDropdown = {
	init: function init(element) {
		var Globals = __webpack_require__(/*! Common/Globals */ 7);
		if (Globals && Globals.data.aBootstrapDropdowns) {
			Globals.data.aBootstrapDropdowns.push(__WEBPACK_IMPORTED_MODULE_2_____default()(element));

			__WEBPACK_IMPORTED_MODULE_2_____default()(element).click(function () {
				__webpack_require__(/*! Common/Utils */ 1).detectDropdownVisibility();
			});

			// ko.utils.domNodeDisposal.addDisposeCallback(element, () => {
			// });
		}
	}
};

ko.bindingHandlers.openDropdownTrigger = {
	update: function update(element, fValueAccessor) {
		if (ko.unwrap(fValueAccessor())) {
			var $el = __WEBPACK_IMPORTED_MODULE_2_____default()(element);
			if (!$el.hasClass('open')) {
				$el.find('.dropdown-toggle').dropdown('toggle');
			}

			$el.find('.dropdown-toggle').focus();

			__webpack_require__(/*! Common/Utils */ 1).detectDropdownVisibility();
			fValueAccessor()(false);
		}
	}
};

ko.bindingHandlers.dropdownCloser = {
	init: function init(element) {
		__WEBPACK_IMPORTED_MODULE_2_____default()(element).closest('.dropdown').on('click', '.e-item', function () {
			__WEBPACK_IMPORTED_MODULE_2_____default()(element).dropdown('toggle');
		});
	}
};

ko.bindingHandlers.popover = {
	init: function init(element, fValueAccessor) {
		__WEBPACK_IMPORTED_MODULE_2_____default()(element).popover(ko.unwrap(fValueAccessor()));

		ko.utils.domNodeDisposal.addDisposeCallback(element, function () {
			__WEBPACK_IMPORTED_MODULE_2_____default()(element).popover('destroy');
		});
	}
};

ko.bindingHandlers.csstext = {};
ko.bindingHandlers.csstext.init = ko.bindingHandlers.csstext.update = function (element, fValueAccessor) {
	if (element && element.styleSheet && 'undefined' !== typeof element.styleSheet.cssText) {
		element.styleSheet.cssText = ko.unwrap(fValueAccessor());
	} else {
		__WEBPACK_IMPORTED_MODULE_2_____default()(element).text(ko.unwrap(fValueAccessor()));
	}
};

ko.bindingHandlers.resizecrop = {
	init: function init(element) {
		__WEBPACK_IMPORTED_MODULE_2_____default()(element).addClass('resizecrop').resizecrop({
			'width': '100',
			'height': '100',
			'wrapperCSS': {
				'border-radius': '10px'
			}
		});
	},
	update: function update(element, fValueAccessor) {
		fValueAccessor()();
		__WEBPACK_IMPORTED_MODULE_2_____default()(element).resizecrop({
			'width': '100',
			'height': '100'
		});
	}
};

ko.bindingHandlers.onKeyDown = {
	init: function init(element, fValueAccessor, fAllBindingsAccessor, viewModel) {
		__WEBPACK_IMPORTED_MODULE_2_____default()(element).on('keydown.koOnKeyDown', function (event) {
			if (event) {
				return fValueAccessor().call(viewModel, event);
			}

			return true;
		});

		ko.utils.domNodeDisposal.addDisposeCallback(element, function () {
			__WEBPACK_IMPORTED_MODULE_2_____default()(element).off('keydown.koOnKeyDown');
		});
	}
};

ko.bindingHandlers.onEnter = {
	init: function init(element, fValueAccessor, fAllBindingsAccessor, viewModel) {
		__WEBPACK_IMPORTED_MODULE_2_____default()(element).on('keypress.koOnEnter', function (event) {
			if (event && 13 === __WEBPACK_IMPORTED_MODULE_0_window___default.a.parseInt(event.keyCode, 10)) {
				__WEBPACK_IMPORTED_MODULE_2_____default()(element).trigger('change');
				fValueAccessor().call(viewModel);
			}
		});

		ko.utils.domNodeDisposal.addDisposeCallback(element, function () {
			__WEBPACK_IMPORTED_MODULE_2_____default()(element).off('keypress.koOnEnter');
		});
	}
};

ko.bindingHandlers.onSpace = {
	init: function init(element, fValueAccessor, fAllBindingsAccessor, viewModel) {
		__WEBPACK_IMPORTED_MODULE_2_____default()(element).on('keyup.koOnSpace', function (event) {
			if (event && 32 === __WEBPACK_IMPORTED_MODULE_0_window___default.a.parseInt(event.keyCode, 10)) {
				fValueAccessor().call(viewModel, event);
			}
		});

		ko.utils.domNodeDisposal.addDisposeCallback(element, function () {
			__WEBPACK_IMPORTED_MODULE_2_____default()(element).off('keyup.koOnSpace');
		});
	}
};

ko.bindingHandlers.onTab = {
	init: function init(element, fValueAccessor, fAllBindingsAccessor, viewModel) {
		__WEBPACK_IMPORTED_MODULE_2_____default()(element).on('keydown.koOnTab', function (event) {
			if (event && 9 === __WEBPACK_IMPORTED_MODULE_0_window___default.a.parseInt(event.keyCode, 10)) {
				return fValueAccessor().call(viewModel, !!event.shiftKey);
			}
			return true;
		});

		ko.utils.domNodeDisposal.addDisposeCallback(element, function () {
			__WEBPACK_IMPORTED_MODULE_2_____default()(element).off('keydown.koOnTab');
		});
	}
};

ko.bindingHandlers.onEsc = {
	init: function init(element, fValueAccessor, fAllBindingsAccessor, viewModel) {
		__WEBPACK_IMPORTED_MODULE_2_____default()(element).on('keyup.koOnEsc', function (event) {
			if (event && 27 === __WEBPACK_IMPORTED_MODULE_0_window___default.a.parseInt(event.keyCode, 10)) {
				__WEBPACK_IMPORTED_MODULE_2_____default()(element).trigger('change');
				fValueAccessor().call(viewModel);
			}
		});

		ko.utils.domNodeDisposal.addDisposeCallback(element, function () {
			__WEBPACK_IMPORTED_MODULE_2_____default()(element).off('keyup.koOnEsc');
		});
	}
};

ko.bindingHandlers.clickOnTrue = {
	update: function update(element, fValueAccessor) {
		if (ko.unwrap(fValueAccessor())) {
			__WEBPACK_IMPORTED_MODULE_2_____default()(element).click();
		}
	}
};

ko.bindingHandlers.modal = {
	init: function init(element, fValueAccessor) {

		var Globals = __webpack_require__(/*! Common/Globals */ 7),
		    Utils = __webpack_require__(/*! Common/Utils */ 1);

		__WEBPACK_IMPORTED_MODULE_2_____default()(element).toggleClass('fade', !Globals.bMobileDevice).modal({
			'keyboard': false,
			'show': ko.unwrap(fValueAccessor())
		}).on('shown.koModal', Utils.windowResizeCallback).find('.close').on('click.koModal', function () {
			fValueAccessor()(false);
		});

		ko.utils.domNodeDisposal.addDisposeCallback(element, function () {
			__WEBPACK_IMPORTED_MODULE_2_____default()(element).off('shown.koModal').find('.close').off('click.koModal');
		});
	},
	update: function update(element, fValueAccessor) {

		var Globals = __webpack_require__(/*! Common/Globals */ 7);

		__WEBPACK_IMPORTED_MODULE_2_____default()(element).modal(ko.unwrap(fValueAccessor()) ? 'show' : 'hide');

		if (Globals.$html.hasClass('rl-anim')) {
			Globals.$html.addClass('rl-modal-animation');
			__WEBPACK_IMPORTED_MODULE_1_____default.a.delay(function () {
				Globals.$html.removeClass('rl-modal-animation');
			}, __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Magics"].Time500ms);
		}
	}
};

ko.bindingHandlers.moment = {
	init: function init(element, fValueAccessor) {
		__webpack_require__(/*! Common/Momentor */ 40).momentToNode(__WEBPACK_IMPORTED_MODULE_2_____default()(element).addClass('moment').data('moment-time', ko.unwrap(fValueAccessor())));
	},
	update: function update(element, fValueAccessor) {
		__webpack_require__(/*! Common/Momentor */ 40).momentToNode(__WEBPACK_IMPORTED_MODULE_2_____default()(element).data('moment-time', ko.unwrap(fValueAccessor())));
	}
};

ko.bindingHandlers.i18nInit = {
	init: function init(element) {
		__webpack_require__(/*! Common/Translator */ 8).i18nToNodes(element);
	}
};

ko.bindingHandlers.translatorInit = {
	init: function init(element) {
		__webpack_require__(/*! Common/Translator */ 8).i18nToNodes(element);
	}
};

ko.bindingHandlers.i18nUpdate = {
	update: function update(element, fValueAccessor) {
		ko.unwrap(fValueAccessor());
		__webpack_require__(/*! Common/Translator */ 8).i18nToNodes(element);
	}
};

ko.bindingHandlers.link = {
	update: function update(element, fValueAccessor) {
		__WEBPACK_IMPORTED_MODULE_2_____default()(element).attr('href', ko.unwrap(fValueAccessor()));
	}
};

ko.bindingHandlers.title = {
	update: function update(element, fValueAccessor) {
		__WEBPACK_IMPORTED_MODULE_2_____default()(element).attr('title', ko.unwrap(fValueAccessor()));
	}
};

ko.bindingHandlers.textF = {
	init: function init(element, fValueAccessor) {
		__WEBPACK_IMPORTED_MODULE_2_____default()(element).text(ko.unwrap(fValueAccessor()));
	}
};

ko.bindingHandlers.initDom = {
	init: function init(element, fValueAccessor) {
		fValueAccessor()(element);
	}
};

ko.bindingHandlers.initFixedTrigger = {
	init: function init(element, fValueAccessor) {
		var values = ko.unwrap(fValueAccessor()),
		    $el = __WEBPACK_IMPORTED_MODULE_2_____default()(element),
		    top = values[1] || 0;

		var $container = __WEBPACK_IMPORTED_MODULE_2_____default()(values[0] || null);
		$container = $container[0] ? $container : null;
		if ($container) {
			$win.resize(function () {
				var offset = $container ? $container.offset() : null;
				if (offset && offset.top) {
					$el.css('top', offset.top + top);
				}
			});
		}
	}
};

ko.bindingHandlers.initResizeTrigger = {
	init: function init(element, fValueAccessor) {
		var values = ko.unwrap(fValueAccessor());
		__WEBPACK_IMPORTED_MODULE_2_____default()(element).css({
			'height': values[1],
			'min-height': values[1]
		});
	},
	update: function update(oElement, fValueAccessor) {

		var Utils = __webpack_require__(/*! Common/Utils */ 1),
		    Globals = __webpack_require__(/*! Common/Globals */ 7),
		    values = ko.unwrap(fValueAccessor());

		var value = Utils.pInt(values[1]),
		    size = 0,
		    offset = __WEBPACK_IMPORTED_MODULE_2_____default()(oElement).offset().top;

		if (0 < offset) {
			offset += Utils.pInt(values[2]);
			size = Globals.$win.height() - offset;

			if (value < size) {
				value = size;
			}

			__WEBPACK_IMPORTED_MODULE_2_____default()(oElement).css({
				'height': value,
				'min-height': value
			});
		}
	}
};

ko.bindingHandlers.appendDom = {
	update: function update(element, fValueAccessor) {
		__WEBPACK_IMPORTED_MODULE_2_____default()(element).hide().empty().append(ko.unwrap(fValueAccessor())).show();
	}
};

ko.bindingHandlers.draggable = {
	init: function init(element, fValueAccessor, fAllBindingsAccessor) {

		var Globals = __webpack_require__(/*! Common/Globals */ 7),
		    Utils = __webpack_require__(/*! Common/Utils */ 1);

		if (!Globals.bMobileDevice) {
			var triggerZone = 100,
			    scrollSpeed = 3,
			    fAllValueFunc = fAllBindingsAccessor(),
			    droppableSelector = fAllValueFunc && fAllValueFunc.droppableSelector ? fAllValueFunc.droppableSelector : '',
			    conf = {
				distance: 20,
				handle: '.dragHandle',
				cursorAt: { top: 22, left: 3 },
				refreshPositions: true,
				scroll: true,
				drag: null,
				stop: null,
				helper: null
			};

			if (droppableSelector) {
				conf.drag = function (event) {

					__WEBPACK_IMPORTED_MODULE_2_____default()(droppableSelector).each(function () {
						var $this = __WEBPACK_IMPORTED_MODULE_2_____default()(this),
						    // eslint-disable-line no-invalid-this
						offset = $this.offset(),
						    bottomPos = offset.top + $this.height();

						__WEBPACK_IMPORTED_MODULE_0_window___default.a.clearInterval($this.data('timerScroll'));
						$this.data('timerScroll', false);

						if (event.pageX >= offset.left && event.pageX <= offset.left + $this.width()) {
							if (event.pageY >= bottomPos - triggerZone && event.pageY <= bottomPos) {
								var moveUp = function moveUp() {
									$this.scrollTop($this.scrollTop() + scrollSpeed);
									Utils.windowResize();
								};

								$this.data('timerScroll', __WEBPACK_IMPORTED_MODULE_0_window___default.a.setInterval(moveUp, 10));
								moveUp();
							}

							if (event.pageY >= offset.top && event.pageY <= offset.top + triggerZone) {
								var moveDown = function moveDown() {
									$this.scrollTop($this.scrollTop() - scrollSpeed);
									Utils.windowResize();
								};

								$this.data('timerScroll', __WEBPACK_IMPORTED_MODULE_0_window___default.a.setInterval(moveDown, 10));
								moveDown();
							}
						}
					});
				};

				conf.stop = function () {
					__WEBPACK_IMPORTED_MODULE_2_____default()(droppableSelector).each(function () {
						var $this = __WEBPACK_IMPORTED_MODULE_2_____default()(this); // eslint-disable-line no-invalid-this
						__WEBPACK_IMPORTED_MODULE_0_window___default.a.clearInterval($this.data('timerScroll'));
						$this.data('timerScroll', false);
					});
				};
			}

			conf.helper = function (event) {
				return fValueAccessor()(event && event.target ? ko.dataFor(event.target) : null);
			};

			__WEBPACK_IMPORTED_MODULE_2_____default()(element).draggable(conf).on('mousedown.koDraggable', function () {
				Utils.removeInFocus();
			});

			ko.utils.domNodeDisposal.addDisposeCallback(element, function () {
				__WEBPACK_IMPORTED_MODULE_2_____default()(element).off('mousedown.koDraggable').draggable('destroy');
			});
		}
	}
};

ko.bindingHandlers.droppable = {
	init: function init(element, fValueAccessor, fAllBindingsAccessor) {
		var Globals = __webpack_require__(/*! Common/Globals */ 7);
		if (!Globals.bMobileDevice) {
			var fValueFunc = fValueAccessor(),
			    fAllValueFunc = fAllBindingsAccessor(),
			    fOverCallback = fAllValueFunc && fAllValueFunc.droppableOver ? fAllValueFunc.droppableOver : null,
			    fOutCallback = fAllValueFunc && fAllValueFunc.droppableOut ? fAllValueFunc.droppableOut : null,
			    conf = {
				tolerance: 'pointer',
				hoverClass: 'droppableHover',
				drop: null,
				over: null,
				out: null
			};

			if (fValueFunc) {
				conf.drop = function (event, ui) {
					fValueFunc(event, ui);
				};

				if (fOverCallback) {
					conf.over = function (event, ui) {
						fOverCallback(event, ui);
					};
				}

				if (fOutCallback) {
					conf.out = function (event, ui) {
						fOutCallback(event, ui);
					};
				}

				__WEBPACK_IMPORTED_MODULE_2_____default()(element).droppable(conf);

				ko.utils.domNodeDisposal.addDisposeCallback(element, function () {
					__WEBPACK_IMPORTED_MODULE_2_____default()(element).droppable('destroy');
				});
			}
		}
	}
};

ko.bindingHandlers.nano = {
	init: function init(element) {

		var Globals = __webpack_require__(/*! Common/Globals */ 7),
		    Settings = __webpack_require__(/*! Storage/Settings */ 10);

		if (!Globals.bDisableNanoScroll && !Settings.appSettingsGet('useNativeScrollbars')) {
			__WEBPACK_IMPORTED_MODULE_2_____default()(element).addClass('nano').nanoScroller({
				iOSNativeScrolling: false,
				preventPageScrolling: true
			});
		}
	}
};

ko.bindingHandlers.saveTrigger = {
	init: function init(element) {

		var $el = __WEBPACK_IMPORTED_MODULE_2_____default()(element);

		$el.data('save-trigger-type', $el.is('input[type=text],input[type=email],input[type=password],select,textarea') ? 'input' : 'custom');

		if ('custom' === $el.data('save-trigger-type')) {
			$el.append('&nbsp;&nbsp;<i class="icon-spinner animated"></i><i class="icon-remove error"></i><i class="icon-ok success"></i>').addClass('settings-saved-trigger');
		} else {
			$el.addClass('settings-saved-trigger-input');
		}
	},
	update: function update(element, fValueAccessor) {
		var value = ko.unwrap(fValueAccessor()),
		    $el = __WEBPACK_IMPORTED_MODULE_2_____default()(element);

		if ('custom' === $el.data('save-trigger-type')) {
			switch (value.toString()) {
				case '1':
					$el.find('.animated,.error').hide().removeClass('visible').end().find('.success').show().addClass('visible');
					break;
				case '0':
					$el.find('.animated,.success').hide().removeClass('visible').end().find('.error').show().addClass('visible');
					break;
				case '-2':
					$el.find('.error,.success').hide().removeClass('visible').end().find('.animated').show().addClass('visible');
					break;
				default:
					$el.find('.animated').hide().end().find('.error,.success').removeClass('visible');
					break;
			}
		} else {
			switch (value.toString()) {
				case '1':
					$el.addClass('success').removeClass('error');
					break;
				case '0':
					$el.addClass('error').removeClass('success');
					break;
				case '-2':
					break;
				default:
					$el.removeClass('error success');
					break;
			}
		}
	}
};

ko.bindingHandlers.emailsTags = {
	init: function init(element, fValueAccessor, fAllBindingsAccessor) {

		var Utils = __webpack_require__(/*! Common/Utils */ 1),
		    EmailModel = __webpack_require__(/*! Model/Email */ 44).default,
		    $el = __WEBPACK_IMPORTED_MODULE_2_____default()(element),
		    fValue = fValueAccessor(),
		    fAllBindings = fAllBindingsAccessor(),
		    fAutoCompleteSource = fAllBindings.autoCompleteSource || null,
		    fFocusCallback = function fFocusCallback(value) {
			if (fValue && fValue.focused) {
				fValue.focused(!!value);
			}
		};

		$el.inputosaurus({
			parseOnBlur: true,
			allowDragAndDrop: true,
			focusCallback: fFocusCallback,
			inputDelimiters: [',', ';', '\n'],
			autoCompleteSource: fAutoCompleteSource,
			// elementHook: (el, item) => {
			// 	if (el && item)
			// 	{
			// 		el.addClass('pgp');
			// 	}
			// },
			parseHook: function parseHook(input) {
				return __WEBPACK_IMPORTED_MODULE_1_____default.a.map(input, function (inputValue) {
					var value = Utils.trim(inputValue);
					if ('' !== value) {
						var email = new EmailModel();
						email.mailsoParse(value);
						return [email.toLine(false), email];
					}
					return [value, null];
				});
			},
			'change': function change(event) {
				$el.data('EmailsTagsValue', event.target.value);
				fValue(event.target.value);
			}
		});

		if (fValue && fValue.focused && fValue.focused.subscribe) {
			fValue.focused.subscribe(function (value) {
				$el.inputosaurus(value ? 'focus' : 'blur');
			});
		}
	},
	update: function update(element, fValueAccessor) {

		var $oEl = __WEBPACK_IMPORTED_MODULE_2_____default()(element),
		    fValue = fValueAccessor(),
		    value = ko.unwrap(fValue);

		if ($oEl.data('EmailsTagsValue') !== value) {
			$oEl.val(value);
			$oEl.data('EmailsTagsValue', value);
			$oEl.inputosaurus('refresh');
		}
	}
};

ko.bindingHandlers.command = {
	init: function init(element, fValueAccessor, fAllBindingsAccessor, viewModel, bindingContext) {
		var jqElement = __WEBPACK_IMPORTED_MODULE_2_____default()(element),
		    command = fValueAccessor();

		if (!command || !command.isCommand) {
			throw new Error('Value should be a command');
		}

		if (!command.enabled) {
			command.enabled = ko.observable(true);
		}

		if (!command.canExecute) {
			var __realCanExecute = command.__realCanExecute;
			if (__WEBPACK_IMPORTED_MODULE_1_____default.a.isFunction(__realCanExecute)) {
				command.canExecute = ko.computed(function () {
					return command.enabled() && __realCanExecute.call(viewModel, viewModel);
				});
			} else {
				command.canExecute = ko.computed(function () {
					return command.enabled() && !!__realCanExecute;
				});
			}
		}

		jqElement.addClass('command');
		ko.bindingHandlers[jqElement.is('form') ? 'submit' : 'click'].init(element, fValueAccessor, fAllBindingsAccessor, viewModel, bindingContext);
	},
	update: function update(element, fValueAccessor) {

		var jqElement = __WEBPACK_IMPORTED_MODULE_2_____default()(element),
		    command = fValueAccessor();

		var result = command.enabled();

		jqElement.toggleClass('command-not-enabled', !result);

		if (result) {
			result = command.canExecute();
			jqElement.toggleClass('command-can-not-be-execute', !result);
		}

		jqElement.toggleClass('command-disabled disable disabled', !result).toggleClass('no-disabled', !!result);

		if (jqElement.is('input') || jqElement.is('button')) {
			jqElement.prop('disabled', !result);
		}
	}
};

// extenders

ko.extenders.trimmer = function (target) {
	var Utils = __webpack_require__(/*! Common/Utils */ 1),
	    result = ko.computed({
		read: target,
		write: function write(newValue) {
			target(Utils.trim(newValue.toString()));
		}
	});

	result(target());
	return result;
};

ko.extenders.posInterer = function (target, defaultVal) {
	var Utils = __webpack_require__(/*! Common/Utils */ 1),
	    result = ko.computed({
		read: target,
		write: function write(newValue) {
			var val = Utils.pInt(newValue.toString(), defaultVal);
			if (0 >= val) {
				val = defaultVal;
			}

			if (val === target() && '' + val !== '' + newValue) {
				target(val + 1);
			}

			target(val);
		}
	});

	result(target());
	return result;
};

ko.extenders.limitedList = function (target, limitedList) {
	var Utils = __webpack_require__(/*! Common/Utils */ 1),
	    result = ko.computed({
		read: target,
		write: function write(newValue) {

			var currentValue = ko.unwrap(target),
			    list = ko.unwrap(limitedList);

			if (Utils.isNonEmptyArray(list)) {
				if (-1 < Utils.inArray(newValue, list)) {
					target(newValue);
				} else if (-1 < Utils.inArray(currentValue, list)) {
					target(currentValue + ' ');
					target(currentValue);
				} else {
					target(list[0] + ' ');
					target(list[0]);
				}
			} else {
				target('');
			}
		}
	}).extend({ notify: 'always' });

	result(target());

	if (!result.valueHasMutated) {
		result.valueHasMutated = function () {
			target.valueHasMutated();
		};
	}

	return result;
};

ko.extenders.reversible = function (target) {

	var value = target();

	target.commit = function () {
		value = target();
	};

	target.reverse = function () {
		target(value);
	};

	target.commitedValue = function () {
		return value;
	};
	return target;
};

ko.extenders.toggleSubscribe = function (target, options) {
	target.subscribe(options[1], options[0], 'beforeChange');
	target.subscribe(options[2], options[0]);
	return target;
};

ko.extenders.toggleSubscribeProperty = function (target, options) {

	var prop = options[1];
	if (prop) {
		target.subscribe(function (prev) {
			if (prev && prev[prop]) {
				prev[prop](false);
			}
		}, options[0], 'beforeChange');

		target.subscribe(function (next) {
			if (next && next[prop]) {
				next[prop](true);
			}
		}, options[0]);
	}

	return target;
};

ko.extenders.falseTimeout = function (target, option) {
	target.iFalseTimeoutTimeout = 0;
	target.subscribe(function (value) {
		if (value) {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.clearTimeout(target.iFalseTimeoutTimeout);
			target.iFalseTimeoutTimeout = __WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {
				target(false);
				target.iFalseTimeoutTimeout = 0;
			}, __webpack_require__(/*! Common/Utils */ 1).pInt(option));
		}
	});

	return target;
};

ko.extenders.specialThrottle = function (target, option) {
	target.iSpecialThrottleTimeoutValue = __webpack_require__(/*! Common/Utils */ 1).pInt(option);
	if (0 < target.iSpecialThrottleTimeoutValue) {
		target.iSpecialThrottleTimeout = 0;
		target.valueForRead = ko.observable(!!target()).extend({ throttle: 10 });

		return ko.computed({
			read: target.valueForRead,
			write: function write(bValue) {

				if (bValue) {
					target.valueForRead(bValue);
				} else {
					if (target.valueForRead()) {
						__WEBPACK_IMPORTED_MODULE_0_window___default.a.clearTimeout(target.iSpecialThrottleTimeout);
						target.iSpecialThrottleTimeout = __WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {
							target.valueForRead(false);
							target.iSpecialThrottleTimeout = 0;
						}, target.iSpecialThrottleTimeoutValue);
					} else {
						target.valueForRead(bValue);
					}
				}
			}
		});
	}

	return target;
};

ko.extenders.idleTrigger = function (target) {
	target.trigger = ko.observable(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["SaveSettingsStep"].Idle);
	return target;
};

// functions

ko.observable.fn.idleTrigger = function () {
	return this.extend({ 'idleTrigger': true });
};

ko.observable.fn.validateNone = function () {
	this.hasError = ko.observable(false);
	return this;
};

ko.observable.fn.validateEmail = function () {
	var _this = this;

	this.hasError = ko.observable(false);

	this.subscribe(function (value) {
		_this.hasError('' !== value && !/^[^@\s]+@[^@\s]+$/.test(value));
	});

	this.valueHasMutated();
	return this;
};

ko.observable.fn.validateSimpleEmail = function () {
	var _this2 = this;

	this.hasError = ko.observable(false);

	this.subscribe(function (value) {
		_this2.hasError('' !== value && !/^.+@.+$/.test(value));
	});

	this.valueHasMutated();
	return this;
};

ko.observable.fn.deleteAccessHelper = function () {
	this.extend({ falseTimeout: 3000 }).extend({ toggleSubscribeProperty: [this, 'deleteAccess'] });
	return this;
};

ko.observable.fn.validateFunc = function (fFunc) {
	var _this3 = this;

	this.hasFuncError = ko.observable(false);

	if (__WEBPACK_IMPORTED_MODULE_1_____default.a.isFunction(fFunc)) {
		this.subscribe(function (value) {
			_this3.hasFuncError(!fFunc(value));
		});

		this.valueHasMutated();
	}

	return this;
};

/* harmony default export */ __webpack_exports__["a"] = (ko);

/***/ }),
/* 3 */
/*!*****************************!*\
  !*** ./dev/Common/Enums.js ***!
  \*****************************/
/*! exports provided: FileType, StorageResultType, Focused, State, StateType, Capa, KeyState, FolderType, ServerFolderType, LoginSignMeTypeAsString, LoginSignMeType, ComposeType, UploadErrorCode, SetSystemFoldersNotification, ClientSideKeyName, EventKeyCode, MessageSetAction, MessageSelectAction, DesktopNotification, MessagePriority, EditorDefaultType, ServerSecure, SearchDateType, SaveSettingsStep, Layout, FilterConditionField, FilterConditionType, FiltersAction, FilterRulesType, SignedVerifyStatus, ContactPropertyType, Magics, Ports, Notification */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FileType", function() { return FileType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StorageResultType", function() { return StorageResultType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Focused", function() { return Focused; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "State", function() { return State; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StateType", function() { return StateType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Capa", function() { return Capa; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "KeyState", function() { return KeyState; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FolderType", function() { return FolderType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ServerFolderType", function() { return ServerFolderType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LoginSignMeTypeAsString", function() { return LoginSignMeTypeAsString; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LoginSignMeType", function() { return LoginSignMeType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ComposeType", function() { return ComposeType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UploadErrorCode", function() { return UploadErrorCode; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SetSystemFoldersNotification", function() { return SetSystemFoldersNotification; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ClientSideKeyName", function() { return ClientSideKeyName; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EventKeyCode", function() { return EventKeyCode; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MessageSetAction", function() { return MessageSetAction; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MessageSelectAction", function() { return MessageSelectAction; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DesktopNotification", function() { return DesktopNotification; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MessagePriority", function() { return MessagePriority; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EditorDefaultType", function() { return EditorDefaultType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ServerSecure", function() { return ServerSecure; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SearchDateType", function() { return SearchDateType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SaveSettingsStep", function() { return SaveSettingsStep; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Layout", function() { return Layout; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FilterConditionField", function() { return FilterConditionField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FilterConditionType", function() { return FilterConditionType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FiltersAction", function() { return FiltersAction; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FilterRulesType", function() { return FilterRulesType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SignedVerifyStatus", function() { return SignedVerifyStatus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ContactPropertyType", function() { return ContactPropertyType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Magics", function() { return Magics; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Ports", function() { return Ports; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Notification", function() { return Notification; });

/* eslint quote-props: 0 */

/**
 * @enum {string}
 */
var FileType = {
	'Unknown': 'unknown',
	'Text': 'text',
	'Html': 'html',
	'Code': 'code',
	'Eml': 'eml',
	'WordText': 'word-text',
	'Pdf': 'pdf',
	'Image': 'image',
	'Audio': 'audio',
	'Video': 'video',
	'Sheet': 'sheet',
	'Presentation': 'presentation',
	'Certificate': 'certificate',
	'CertificateBin': 'certificate-bin',
	'Archive': 'archive'
};

/**
 * @enum {string}
 */
var StorageResultType = {
	'Success': 'success',
	'Abort': 'abort',
	'Error': 'error',
	'Unload': 'unload'
};

/**
 * @enum {string}
 */
var Focused = {
	'None': 'none',
	'MessageList': 'message-list',
	'MessageView': 'message-view',
	'FolderList': 'folder-list'
};

/**
 * @enum {number}
 */
var State = {
	'Empty': 10,
	'Login': 20,
	'Auth': 30
};

/**
 * @enum {number}
 */
var StateType = {
	'Webmail': 0,
	'Admin': 1
};

/**
 * @enum {string}
 */
var Capa = {
	'TwoFactor': 'TWO_FACTOR',
	'TwoFactorForce': 'TWO_FACTOR_FORCE',
	'OpenPGP': 'OPEN_PGP',
	'Prefetch': 'PREFETCH',
	'Gravatar': 'GRAVATAR',
	'Folders': 'FOLDERS',
	'Composer': 'COMPOSER',
	'Contacts': 'CONTACTS',
	'Reload': 'RELOAD',
	'Search': 'SEARCH',
	'SearchAdv': 'SEARCH_ADV',
	'MessageActions': 'MESSAGE_ACTIONS',
	'MessageListActions': 'MESSAGELIST_ACTIONS',
	'AttachmentsActions': 'ATTACHMENTS_ACTIONS',
	'DangerousActions': 'DANGEROUS_ACTIONS',
	'Settings': 'SETTINGS',
	'Help': 'HELP',
	'Themes': 'THEMES',
	'UserBackground': 'USER_BACKGROUND',
	'Sieve': 'SIEVE',
	'Filters': 'FILTERS',
	'AttachmentThumbnails': 'ATTACHMENT_THUMBNAILS',
	'Templates': 'TEMPLATES',
	'AutoLogout': 'AUTOLOGOUT',
	'AdditionalAccounts': 'ADDITIONAL_ACCOUNTS',
	'Identities': 'IDENTITIES'
};

/**
 * @enum {string}
 */
var KeyState = {
	'All': 'all',
	'None': 'none',
	'ContactList': 'contact-list',
	'MessageList': 'message-list',
	'FolderList': 'folder-list',
	'MessageView': 'message-view',
	'Compose': 'compose',
	'Settings': 'settings',
	'Menu': 'menu',
	'PopupComposeOpenPGP': 'compose-open-pgp',
	'PopupMessageOpenPGP': 'message-open-pgp',
	'PopupViewOpenPGP': 'view-open-pgp',
	'PopupKeyboardShortcutsHelp': 'popup-keyboard-shortcuts-help',
	'PopupAsk': 'popup-ask'
};

/**
 * @enum {number}
 */
var FolderType = {
	'Inbox': 10,
	'SentItems': 11,
	'Draft': 12,
	'Trash': 13,
	'Spam': 14,
	'Archive': 15,
	'NotSpam': 80,
	'User': 99
};

/**
 * @enum {number}
 */
var ServerFolderType = {
	'USER': 0,
	'INBOX': 1,
	'SENT': 2,
	'DRAFTS': 3,
	'JUNK': 4,
	'TRASH': 5,
	'IMPORTANT': 10,
	'FLAGGED': 11,
	'ALL': 12
};

/**
 * @enum {string}
 */
var LoginSignMeTypeAsString = {
	'DefaultOff': 'defaultoff',
	'DefaultOn': 'defaulton',
	'Unused': 'unused'
};

/**
 * @enum {number}
 */
var LoginSignMeType = {
	'DefaultOff': 0,
	'DefaultOn': 1,
	'Unused': 2
};

/**
 * @enum {string}
 */
var ComposeType = {
	'Empty': 'empty',
	'Reply': 'reply',
	'ReplyAll': 'replyall',
	'Forward': 'forward',
	'ForwardAsAttachment': 'forward-as-attachment',
	'Draft': 'draft',
	'EditAsNew': 'editasnew'
};

/**
 * @enum {number}
 */
var UploadErrorCode = {
	'Normal': 0,
	'FileIsTooBig': 1,
	'FilePartiallyUploaded': 2,
	'FileNoUploaded': 3,
	'MissingTempFolder': 4,
	'FileOnSaveingError': 5,
	'FileType': 98,
	'Unknown': 99
};

/**
 * @enum {number}
 */
var SetSystemFoldersNotification = {
	'None': 0,
	'Sent': 1,
	'Draft': 2,
	'Spam': 3,
	'Trash': 4,
	'Archive': 5
};

/**
 * @enum {number}
 */
var ClientSideKeyName = {
	'FoldersLashHash': 0,
	'MessagesInboxLastHash': 1,
	'MailBoxListSize': 2,
	'ExpandedFolders': 3,
	'FolderListSize': 4,
	'MessageListSize': 5,
	'LastReplyAction': 6,
	'LastSignMe': 7,
	'ComposeLastIdentityID': 8,
	'MessageHeaderFullInfo': 9,
	'MessageAttachmnetControls': 10
};

/**
 * @enum {number}
 */
var EventKeyCode = {
	'Backspace': 8,
	'Tab': 9,
	'Enter': 13,
	'Esc': 27,
	'PageUp': 33,
	'PageDown': 34,
	'Left': 37,
	'Right': 39,
	'Up': 38,
	'Down': 40,
	'End': 35,
	'Home': 36,
	'Space': 32,
	'Insert': 45,
	'Delete': 46,
	'A': 65,
	'S': 83
};

/**
 * @enum {number}
 */
var MessageSetAction = {
	'SetSeen': 0,
	'UnsetSeen': 1,
	'SetFlag': 2,
	'UnsetFlag': 3
};

/**
 * @enum {number}
 */
var MessageSelectAction = {
	'All': 0,
	'None': 1,
	'Invert': 2,
	'Unseen': 3,
	'Seen': 4,
	'Flagged': 5,
	'Unflagged': 6
};

/**
 * @enum {number}
 */
var DesktopNotification = {
	'Allowed': 0,
	'NotAllowed': 1,
	'Denied': 2,
	'NotSupported': 9
};

/**
 * @enum {number}
 */
var MessagePriority = {
	'Low': 5,
	'Normal': 3,
	'High': 1
};

/**
 * @enum {string}
 */
var EditorDefaultType = {
	'Html': 'Html',
	'Plain': 'Plain',
	'HtmlForced': 'HtmlForced',
	'PlainForced': 'PlainForced'
};

/**
 * @enum {number}
 */
var ServerSecure = {
	'None': 0,
	'SSL': 1,
	'TLS': 2
};

/**
 * @enum {number}
 */
var SearchDateType = {
	'All': -1,
	'Days3': 3,
	'Days7': 7,
	'Month': 30
};

/**
 * @enum {number}
 */
var SaveSettingsStep = {
	'Animate': -2,
	'Idle': -1,
	'TrueResult': 1,
	'FalseResult': 0
};

/**
 * @enum {number}
 */
var Layout = {
	'NoPreview': 0,
	'SidePreview': 1,
	'BottomPreview': 2
};

/**
 * @enum {string}
 */
var FilterConditionField = {
	'From': 'From',
	'Recipient': 'Recipient',
	'Subject': 'Subject',
	'Header': 'Header',
	'Size': 'Size'
};

/**
 * @enum {string}
 */
var FilterConditionType = {
	'Contains': 'Contains',
	'NotContains': 'NotContains',
	'EqualTo': 'EqualTo',
	'NotEqualTo': 'NotEqualTo',
	'Regex': 'Regex',
	'Over': 'Over',
	'Under': 'Under'
};

/**
 * @enum {string}
 */
var FiltersAction = {
	'None': 'None',
	'MoveTo': 'MoveTo',
	'Discard': 'Discard',
	'Vacation': 'Vacation',
	'Reject': 'Reject',
	'Forward': 'Forward'
};

/**
 * @enum {string}
 */
var FilterRulesType = {
	'All': 'All',
	'Any': 'Any'
};

/**
 * @enum {number}
 */
var SignedVerifyStatus = {
	'UnknownPublicKeys': -4,
	'UnknownPrivateKey': -3,
	'Unverified': -2,
	'Error': -1,
	'None': 0,
	'Success': 1
};

/**
 * @enum {number}
 */
var ContactPropertyType = {

	'Unknown': 0,

	'FullName': 10,

	'FirstName': 15,
	'LastName': 16,
	'MiddleName': 16,
	'Nick': 18,

	'NamePrefix': 20,
	'NameSuffix': 21,

	'Email': 30,
	'Phone': 31,
	'Web': 32,

	'Birthday': 40,

	'Facebook': 90,
	'Skype': 91,
	'GitHub': 92,

	'Note': 110,

	'Custom': 250
};

/**
 * @enum {number}
 */
var Magics = {
	'EventWhichMouseMiddle': 3,
	'ifvisibleIdle10s': 10,

	'BitLength2048': 2048,
	'BitLength1024': 1024,

	'Size350px': 350,
	'Size50px': 50,
	'Size20px': 20,
	'Size1px': 1,

	'Time30mInMin': 30,

	'Time60m': 60000 * 60,
	'Time30m': 60000 * 30,
	'Time20m': 60000 * 20,
	'Time15m': 60000 * 15,
	'Time10m': 60000 * 10,
	'Time5m': 60000 * 5,
	'Time3m': 60000 * 3,
	'Time2m': 60000 * 2,
	'Time1m': 60000,
	'Time30s': 30000,
	'Time10s': 10000,
	'Time7s': 7000,
	'Time5s': 5000,
	'Time3s': 3000,
	'Time1s': 1000,
	'Time500ms': 500,
	'Time350ms': 350,
	'Time250ms': 250,
	'Time200ms': 200,
	'Time100ms': 100,
	'Time50ms': 50,
	'Time20ms': 20,
	'Time10ms': 10,
	'Time1ms': 1
};

/**
 * @enum {number}
 */
var Ports = {
	'Imap': 143,
	'ImapSsl': 993,
	'Smtp': 25,
	'SmtpSsl': 465,
	'SmtpStartTls': 587
};

/**
 * @enum {number}
 */
var Notification = {
	'InvalidToken': 101,
	'AuthError': 102,
	'AccessError': 103,
	'ConnectionError': 104,
	'CaptchaError': 105,
	'SocialFacebookLoginAccessDisable': 106,
	'SocialTwitterLoginAccessDisable': 107,
	'SocialGoogleLoginAccessDisable': 108,
	'DomainNotAllowed': 109,
	'AccountNotAllowed': 110,

	'AccountTwoFactorAuthRequired': 120,
	'AccountTwoFactorAuthError': 121,

	'CouldNotSaveNewPassword': 130,
	'CurrentPasswordIncorrect': 131,
	'NewPasswordShort': 132,
	'NewPasswordWeak': 133,
	'NewPasswordForbidden': 134,

	'ContactsSyncError': 140,

	'CantGetMessageList': 201,
	'CantGetMessage': 202,
	'CantDeleteMessage': 203,
	'CantMoveMessage': 204,
	'CantCopyMessage': 205,

	'CantSaveMessage': 301,
	'CantSendMessage': 302,
	'InvalidRecipients': 303,

	'CantSaveFilters': 351,
	'CantGetFilters': 352,
	'FiltersAreNotCorrect': 355,

	'CantCreateFolder': 400,
	'CantRenameFolder': 401,
	'CantDeleteFolder': 402,
	'CantSubscribeFolder': 403,
	'CantUnsubscribeFolder': 404,
	'CantDeleteNonEmptyFolder': 405,

	'CantSaveSettings': 501,
	'CantSavePluginSettings': 502,

	'DomainAlreadyExists': 601,

	'CantInstallPackage': 701,
	'CantDeletePackage': 702,
	'InvalidPluginPackage': 703,
	'UnsupportedPluginPackage': 704,

	'LicensingServerIsUnavailable': 710,
	'LicensingExpired': 711,
	'LicensingBanned': 712,

	'DemoSendMessageError': 750,
	'DemoAccountError': 751,

	'AccountAlreadyExists': 801,
	'AccountDoesNotExist': 802,

	'MailServerError': 901,
	'ClientViewError': 902,
	'InvalidInputArgument': 903,

	'AjaxFalse': 950,
	'AjaxAbort': 951,
	'AjaxParse': 952,
	'AjaxTimeout': 953,

	'UnknownNotification': 999,
	'UnknownError': 999
};

/***/ }),
/* 4 */
/*!*************************************************************************!*\
  !*** ./node_modules/babel-runtime/helpers/possibleConstructorReturn.js ***!
  \*************************************************************************/
/*! no static exports found */
/*! exports used: default */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _typeof2 = __webpack_require__(/*! ../helpers/typeof */ 87);

var _typeof3 = _interopRequireDefault(_typeof2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = function (self, call) {
  if (!self) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return call && ((typeof call === "undefined" ? "undefined" : (0, _typeof3.default)(call)) === "object" || typeof call === "function") ? call : self;
};

/***/ }),
/* 5 */
/*!********************************************************!*\
  !*** ./node_modules/babel-runtime/helpers/inherits.js ***!
  \********************************************************/
/*! no static exports found */
/*! exports used: default */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _setPrototypeOf = __webpack_require__(/*! ../core-js/object/set-prototype-of */ 137);

var _setPrototypeOf2 = _interopRequireDefault(_setPrototypeOf);

var _create = __webpack_require__(/*! ../core-js/object/create */ 141);

var _create2 = _interopRequireDefault(_create);

var _typeof2 = __webpack_require__(/*! ../helpers/typeof */ 87);

var _typeof3 = _interopRequireDefault(_typeof2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = function (subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === "undefined" ? "undefined" : (0, _typeof3.default)(superClass)));
  }

  subClass.prototype = (0, _create2.default)(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });
  if (superClass) _setPrototypeOf2.default ? (0, _setPrototypeOf2.default)(subClass, superClass) : subClass.__proto__ = superClass;
};

/***/ }),
/* 6 */
/*!***************************!*\
  !*** external "window._" ***!
  \***************************/
/*! no static exports found */
/*! exports used: default */
/***/ (function(module, exports) {

module.exports = window._;

/***/ }),
/* 7 */
/*!*******************************!*\
  !*** ./dev/Common/Globals.js ***!
  \*******************************/
/*! exports provided: $win, $doc, $html, $body, $div, $hcont, startMicrotime, community, dropdownVisibility, useKeyboardShortcuts, sUserAgent, bIE, bChrome, bSafari, bMobileDevice, bDisableNanoScroll, bAnimationSupported, bXMLHttpRequestSupported, bIsHttps, htmlEditorDefaultConfig, htmlEditorLangsMap, bAllowPdfPreview, VIEW_MODELS, moveAction, leftPanelDisabled, leftPanelType, leftPanelWidth, popupVisibilityNames, popupVisibility, keyScopeReal, keyScopeFake, keyScope, data */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "$win", function() { return $win; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "$doc", function() { return $doc; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "$html", function() { return $html; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "$body", function() { return $body; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "$div", function() { return $div; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "$hcont", function() { return $hcont; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "startMicrotime", function() { return startMicrotime; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "community", function() { return community; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "dropdownVisibility", function() { return dropdownVisibility; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "useKeyboardShortcuts", function() { return useKeyboardShortcuts; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "sUserAgent", function() { return sUserAgent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "bIE", function() { return bIE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "bChrome", function() { return bChrome; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "bSafari", function() { return bSafari; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "bMobileDevice", function() { return bMobileDevice; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "bDisableNanoScroll", function() { return bDisableNanoScroll; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "bAnimationSupported", function() { return bAnimationSupported; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "bXMLHttpRequestSupported", function() { return bXMLHttpRequestSupported; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "bIsHttps", function() { return bIsHttps; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "htmlEditorDefaultConfig", function() { return htmlEditorDefaultConfig; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "htmlEditorLangsMap", function() { return htmlEditorLangsMap; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "bAllowPdfPreview", function() { return bAllowPdfPreview; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VIEW_MODELS", function() { return VIEW_MODELS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "moveAction", function() { return moveAction; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "leftPanelDisabled", function() { return leftPanelDisabled; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "leftPanelType", function() { return leftPanelType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "leftPanelWidth", function() { return leftPanelWidth; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "popupVisibilityNames", function() { return popupVisibilityNames; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "popupVisibility", function() { return popupVisibility; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "keyScopeReal", function() { return keyScopeReal; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "keyScopeFake", function() { return keyScopeFake; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "keyScope", function() { return keyScope; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "data", function() { return data; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! $ */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_key__ = __webpack_require__(/*! key */ 19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_key___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_key__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);

/* global RL_COMMUNITY */








var $win = __WEBPACK_IMPORTED_MODULE_2_____default()(__WEBPACK_IMPORTED_MODULE_0_window___default.a);
$win.__sizes = [0, 0];



var $doc = __WEBPACK_IMPORTED_MODULE_2_____default()(__WEBPACK_IMPORTED_MODULE_0_window___default.a.document);

var $html = __WEBPACK_IMPORTED_MODULE_2_____default()('html');

var $body = __WEBPACK_IMPORTED_MODULE_2_____default()('body');

var $div = __WEBPACK_IMPORTED_MODULE_2_____default()('<div></div>');

var $hcont = __WEBPACK_IMPORTED_MODULE_2_____default()('<div></div>');
$hcont.attr('area', 'hidden').css({ position: 'absolute', left: -5000 }).appendTo($body);

var startMicrotime = new __WEBPACK_IMPORTED_MODULE_0_window___default.a.Date().getTime();

/**
 * @type {boolean}
 */
var community = true;

/**
 * @type {?}
 */
var dropdownVisibility = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false).extend({ rateLimit: 0 });

/**
 * @type {boolean}
 */
var useKeyboardShortcuts = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(true);

/**
 * @type {string}
 */
var sUserAgent = 'navigator' in __WEBPACK_IMPORTED_MODULE_0_window___default.a && 'userAgent' in __WEBPACK_IMPORTED_MODULE_0_window___default.a.navigator && __WEBPACK_IMPORTED_MODULE_0_window___default.a.navigator.userAgent.toLowerCase() || '';

/**
 * @type {boolean}
 */
var bIE = -1 < sUserAgent.indexOf('msie');

/**
 * @type {boolean}
 */
var bChrome = -1 < sUserAgent.indexOf('chrome');

/**
 * @type {boolean}
 */
var bSafari = !bChrome && -1 < sUserAgent.indexOf('safari');

/**
 * @type {boolean}
 */
var bMobileDevice = /android/i.test(sUserAgent) || /iphone/i.test(sUserAgent) || /ipod/i.test(sUserAgent) || /ipad/i.test(sUserAgent) || /blackberry/i.test(sUserAgent);

/**
 * @type {boolean}
 */
var bDisableNanoScroll = bMobileDevice;

/**
 * @type {boolean}
 */
var bAnimationSupported = !bMobileDevice && $html.hasClass('csstransitions') && $html.hasClass('cssanimations');

/**
 * @type {boolean}
 */
var bXMLHttpRequestSupported = !!__WEBPACK_IMPORTED_MODULE_0_window___default.a.XMLHttpRequest;

/**
 * @type {boolean}
 */
var bIsHttps = __WEBPACK_IMPORTED_MODULE_0_window___default.a.document && __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.location ? 'https:' === __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.location.protocol : false;

/**
 * @type {Object}
 */
var htmlEditorDefaultConfig = {
	'title': false,
	'stylesSet': false,
	'customConfig': '',
	'contentsCss': '',
	'toolbarGroups': [{ name: 'spec' }, { name: 'styles' }, { name: 'basicstyles', groups: ['basicstyles', 'cleanup', 'bidi'] }, { name: 'colors' }, bMobileDevice ? {} : { name: 'paragraph', groups: ['list', 'indent', 'blocks', 'align'] }, { name: 'links' }, { name: 'insert' }, { name: 'document', groups: ['mode', 'document', 'doctools'] }, { name: 'others' }],

	'removePlugins': 'liststyle',
	'removeButtons': 'Format,Undo,Redo,Cut,Copy,Paste,Anchor,Strike,Subscript,Superscript,Image,SelectAll,Source',
	'removeDialogTabs': 'link:advanced;link:target;image:advanced;images:advanced',

	'extraPlugins': 'plain,signature',

	'allowedContent': true,
	'extraAllowedContent': true,

	'fillEmptyBlocks': false,
	'ignoreEmptyParagraph': true,
	'disableNativeSpellChecker': false,

	'colorButton_enableAutomatic': false,
	'colorButton_enableMore': true,

	'font_defaultLabel': 'Arial',
	'fontSize_defaultLabel': '13',
	'fontSize_sizes': '10/10px;12/12px;13/13px;14/14px;16/16px;18/18px;20/20px;24/24px;28/28px;36/36px;48/48px'
};

/**
 * @type {Object}
 */
var htmlEditorLangsMap = {
	'ar_sa': 'ar-sa',
	'bg_bg': 'bg',
	'cs_CZ': 'cs',
	'de_de': 'de',
	'el_gr': 'el',
	'es_es': 'es',
	'et_ee': 'et',
	'fr_fr': 'fr',
	'hu_hu': 'hu',
	'is_is': 'is',
	'it_it': 'it',
	'ja_jp': 'ja',
	'ko_kr': 'ko',
	'lt_lt': 'lt',
	'lv_lv': 'lv',
	'fa_ir': 'fa',
	'nb_no': 'nb',
	'nl_nl': 'nl',
	'pl_pl': 'pl',
	'pt_br': 'pt-br',
	'pt_pt': 'pt',
	'ro_ro': 'ro',
	'ru_ru': 'ru',
	'sk_sk': 'sk',
	'sl_si': 'sl',
	'sv_se': 'sv',
	'tr_tr': 'tr',
	'uk_ua': 'uk',
	'zh_cn': 'zh-cn',
	'zh_tw': 'zh'
};

/**
 * @type {boolean}
 */
var bAllowPdfPreview = !bMobileDevice;

if (bAllowPdfPreview && __WEBPACK_IMPORTED_MODULE_0_window___default.a.navigator && __WEBPACK_IMPORTED_MODULE_0_window___default.a.navigator.mimeTypes) {
	bAllowPdfPreview = !!__WEBPACK_IMPORTED_MODULE_1_____default.a.find(__WEBPACK_IMPORTED_MODULE_0_window___default.a.navigator.mimeTypes, function (type) {
		return type && 'application/pdf' === type.type;
	});

	if (!bAllowPdfPreview) {
		bAllowPdfPreview = 'undefined' !== typeof __WEBPACK_IMPORTED_MODULE_0_window___default.a.navigator.mimeTypes['application/pdf'];
	}
}



var VIEW_MODELS = {
	settings: [],
	'settings-removed': [],
	'settings-disabled': []
};

var moveAction = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);
var leftPanelDisabled = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);
var leftPanelType = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable('');
var leftPanelWidth = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(0);

leftPanelDisabled.subscribe(function (value) {
	if (value && moveAction()) {
		moveAction(false);
	}
});

moveAction.subscribe(function (value) {
	if (value && leftPanelDisabled()) {
		leftPanelDisabled(false);
	}
});

// popups
var popupVisibilityNames = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observableArray([]);

var popupVisibility = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].computed(function () {
	return 0 < popupVisibilityNames().length;
});

popupVisibility.subscribe(function (bValue) {
	$html.toggleClass('rl-modal', bValue);
});

// keys
var keyScopeReal = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].All);
var keyScopeFake = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].All);

var keyScope = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].computed({
	read: function read() {
		return keyScopeFake();
	},
	write: function write(value) {

		if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].Menu !== value) {
			if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].Compose === value) {
				// disableKeyFilter
				__WEBPACK_IMPORTED_MODULE_3_key___default.a.filter = function () {
					return useKeyboardShortcuts();
				};
			} else {
				// restoreKeyFilter
				__WEBPACK_IMPORTED_MODULE_3_key___default.a.filter = function (event) {

					if (useKeyboardShortcuts()) {
						var el = event.target || event.srcElement,
						    tagName = el ? el.tagName.toUpperCase() : '';

						return !('INPUT' === tagName || 'SELECT' === tagName || 'TEXTAREA' === tagName || el && 'DIV' === tagName && ('editorHtmlArea' === el.className || 'true' === '' + el.contentEditable));
					}

					return false;
				};
			}

			keyScopeFake(value);
			if (dropdownVisibility()) {
				value = __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].Menu;
			}
		}

		keyScopeReal(value);
	}
});

keyScopeReal.subscribe(function (value) {
	//	window.console.log('keyScope=' + sValue); // DEBUG
	__WEBPACK_IMPORTED_MODULE_3_key___default.a.setScope(value);
});

dropdownVisibility.subscribe(function (value) {
	if (value) {
		keyScope(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].Menu);
	} else if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].Menu === __WEBPACK_IMPORTED_MODULE_3_key___default.a.getScope()) {
		keyScope(keyScopeFake());
	}
});

/**
 * @type {*}
 */
var data = {
	__APP__: null,
	iAjaxErrorCount: 0,
	iTokenErrorCount: 0,
	aBootstrapDropdowns: [],
	iMessageBodyCacheCount: 0,
	bUnload: false
};

/***/ }),
/* 8 */
/*!**********************************!*\
  !*** ./dev/Common/Translator.js ***!
  \**********************************/
/*! exports provided: trigger, i18n, i18nToNodes, initNotificationLanguage, initOnStartOrLangChange, getNotification, getNotificationFromResponse, getUploadErrorDescByCode, reload */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "trigger", function() { return trigger; });
/* harmony export (immutable) */ __webpack_exports__["i18n"] = i18n;
/* harmony export (immutable) */ __webpack_exports__["i18nToNodes"] = i18nToNodes;
/* harmony export (immutable) */ __webpack_exports__["initNotificationLanguage"] = initNotificationLanguage;
/* harmony export (immutable) */ __webpack_exports__["initOnStartOrLangChange"] = initOnStartOrLangChange;
/* harmony export (immutable) */ __webpack_exports__["getNotification"] = getNotification;
/* harmony export (immutable) */ __webpack_exports__["getNotificationFromResponse"] = getNotificationFromResponse;
/* harmony export (immutable) */ __webpack_exports__["getUploadErrorDescByCode"] = getUploadErrorDescByCode;
/* harmony export (immutable) */ __webpack_exports__["reload"] = reload;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! $ */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Momentor__ = __webpack_require__(/*! Common/Momentor */ 40);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Common_Links__ = __webpack_require__(/*! Common/Links */ 14);











var I18N_DATA = __WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopI18N || {};

var I18N_NOTIFICATION_DATA = {};
var I18N_NOTIFICATION_MAP = [[__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].InvalidToken, 'NOTIFICATIONS/INVALID_TOKEN'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].InvalidToken, 'NOTIFICATIONS/INVALID_TOKEN'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].AuthError, 'NOTIFICATIONS/AUTH_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].AccessError, 'NOTIFICATIONS/ACCESS_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].ConnectionError, 'NOTIFICATIONS/CONNECTION_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CaptchaError, 'NOTIFICATIONS/CAPTCHA_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].SocialFacebookLoginAccessDisable, 'NOTIFICATIONS/SOCIAL_FACEBOOK_LOGIN_ACCESS_DISABLE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].SocialTwitterLoginAccessDisable, 'NOTIFICATIONS/SOCIAL_TWITTER_LOGIN_ACCESS_DISABLE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].SocialGoogleLoginAccessDisable, 'NOTIFICATIONS/SOCIAL_GOOGLE_LOGIN_ACCESS_DISABLE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].DomainNotAllowed, 'NOTIFICATIONS/DOMAIN_NOT_ALLOWED'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].AccountNotAllowed, 'NOTIFICATIONS/ACCOUNT_NOT_ALLOWED'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].AccountTwoFactorAuthRequired, 'NOTIFICATIONS/ACCOUNT_TWO_FACTOR_AUTH_REQUIRED'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].AccountTwoFactorAuthError, 'NOTIFICATIONS/ACCOUNT_TWO_FACTOR_AUTH_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CouldNotSaveNewPassword, 'NOTIFICATIONS/COULD_NOT_SAVE_NEW_PASSWORD'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CurrentPasswordIncorrect, 'NOTIFICATIONS/CURRENT_PASSWORD_INCORRECT'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].NewPasswordShort, 'NOTIFICATIONS/NEW_PASSWORD_SHORT'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].NewPasswordWeak, 'NOTIFICATIONS/NEW_PASSWORD_WEAK'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].NewPasswordForbidden, 'NOTIFICATIONS/NEW_PASSWORD_FORBIDDENT'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].ContactsSyncError, 'NOTIFICATIONS/CONTACTS_SYNC_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantGetMessageList, 'NOTIFICATIONS/CANT_GET_MESSAGE_LIST'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantGetMessage, 'NOTIFICATIONS/CANT_GET_MESSAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantDeleteMessage, 'NOTIFICATIONS/CANT_DELETE_MESSAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantMoveMessage, 'NOTIFICATIONS/CANT_MOVE_MESSAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantCopyMessage, 'NOTIFICATIONS/CANT_MOVE_MESSAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantSaveMessage, 'NOTIFICATIONS/CANT_SAVE_MESSAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantSendMessage, 'NOTIFICATIONS/CANT_SEND_MESSAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].InvalidRecipients, 'NOTIFICATIONS/INVALID_RECIPIENTS'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantSaveFilters, 'NOTIFICATIONS/CANT_SAVE_FILTERS'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantGetFilters, 'NOTIFICATIONS/CANT_GET_FILTERS'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].FiltersAreNotCorrect, 'NOTIFICATIONS/FILTERS_ARE_NOT_CORRECT'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantCreateFolder, 'NOTIFICATIONS/CANT_CREATE_FOLDER'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantRenameFolder, 'NOTIFICATIONS/CANT_RENAME_FOLDER'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantDeleteFolder, 'NOTIFICATIONS/CANT_DELETE_FOLDER'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantDeleteNonEmptyFolder, 'NOTIFICATIONS/CANT_DELETE_NON_EMPTY_FOLDER'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantSubscribeFolder, 'NOTIFICATIONS/CANT_SUBSCRIBE_FOLDER'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantUnsubscribeFolder, 'NOTIFICATIONS/CANT_UNSUBSCRIBE_FOLDER'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantSaveSettings, 'NOTIFICATIONS/CANT_SAVE_SETTINGS'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantSavePluginSettings, 'NOTIFICATIONS/CANT_SAVE_PLUGIN_SETTINGS'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].DomainAlreadyExists, 'NOTIFICATIONS/DOMAIN_ALREADY_EXISTS'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantInstallPackage, 'NOTIFICATIONS/CANT_INSTALL_PACKAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantDeletePackage, 'NOTIFICATIONS/CANT_DELETE_PACKAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].InvalidPluginPackage, 'NOTIFICATIONS/INVALID_PLUGIN_PACKAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].UnsupportedPluginPackage, 'NOTIFICATIONS/UNSUPPORTED_PLUGIN_PACKAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].LicensingServerIsUnavailable, 'NOTIFICATIONS/LICENSING_SERVER_IS_UNAVAILABLE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].LicensingExpired, 'NOTIFICATIONS/LICENSING_EXPIRED'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].LicensingBanned, 'NOTIFICATIONS/LICENSING_BANNED'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].DemoSendMessageError, 'NOTIFICATIONS/DEMO_SEND_MESSAGE_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].DemoAccountError, 'NOTIFICATIONS/DEMO_ACCOUNT_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].AccountAlreadyExists, 'NOTIFICATIONS/ACCOUNT_ALREADY_EXISTS'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].AccountDoesNotExist, 'NOTIFICATIONS/ACCOUNT_DOES_NOT_EXIST'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].MailServerError, 'NOTIFICATIONS/MAIL_SERVER_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].InvalidInputArgument, 'NOTIFICATIONS/INVALID_INPUT_ARGUMENT'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].UnknownNotification, 'NOTIFICATIONS/UNKNOWN_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].UnknownError, 'NOTIFICATIONS/UNKNOWN_ERROR']];

var trigger = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(false);

/**
 * @param {string} key
 * @param {Object=} valueList
 * @param {string=} defaulValue
 * @returns {string}
 */
function i18n(key, valueList, defaulValue) {
	var valueName = '',
	    result = I18N_DATA[key];

	if (Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isUnd"])(result)) {
		result = Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isUnd"])(defaulValue) ? key : defaulValue;
	}

	if (!Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isUnd"])(valueList) && !Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isNull"])(valueList)) {
		for (valueName in valueList) {
			if (Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["has"])(valueList, valueName)) {
				result = result.replace('%' + valueName + '%', valueList[valueName]);
			}
		}
	}

	return result;
}

var i18nToNode = function i18nToNode(element) {

	var $el = __WEBPACK_IMPORTED_MODULE_2_____default()(element),
	    key = $el.data('i18n');

	if (key) {
		if ('[' === key.substr(0, 1)) {
			switch (key.substr(0, 6)) {
				case '[html]':
					$el.html(i18n(key.substr(6)));
					break;
				case '[place':
					$el.attr('placeholder', i18n(key.substr(13)));
					break;
				case '[title':
					$el.attr('title', i18n(key.substr(7)));
					break;
				// no default
			}
		} else {
			$el.text(i18n(key));
		}
	}
};

/**
 * @param {Object} elements
 * @param {boolean=} animate = false
 */
function i18nToNodes(elements) {
	var animate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

	__WEBPACK_IMPORTED_MODULE_1_____default.a.defer(function () {

		__WEBPACK_IMPORTED_MODULE_2_____default()('[data-i18n]', elements).each(function (index, item) {
			i18nToNode(item);
		});

		if (animate && __WEBPACK_IMPORTED_MODULE_6_Common_Globals__["bAnimationSupported"]) {
			__WEBPACK_IMPORTED_MODULE_2_____default()('.i18n-animation[data-i18n]', elements).letterfx({
				'fx': 'fall fade',
				'backwards': false,
				'timing': 50,
				'fx_duration': '50ms',
				'letter_end': 'restore',
				'element_end': 'restore'
			});
		}
	});
}

var reloadData = function reloadData() {
	if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopI18N) {
		I18N_DATA = __WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopI18N || {};

		i18nToNodes(__WEBPACK_IMPORTED_MODULE_0_window___default.a.document, true);

		Object(__WEBPACK_IMPORTED_MODULE_7_Common_Momentor__["reload"])();
		trigger(!trigger());
	}

	__WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopI18N = null;
};

/**
 * @returns {void}
 */
function initNotificationLanguage() {
	I18N_NOTIFICATION_MAP.forEach(function (item) {
		I18N_NOTIFICATION_DATA[item[0]] = i18n(item[1]);
	});
}

/**
 * @param {Function} startCallback
 * @param {Function=} langCallback = null
 */
function initOnStartOrLangChange(startCallback) {
	var langCallback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

	if (startCallback) {
		startCallback();
	}

	if (langCallback) {
		trigger.subscribe(function () {
			if (startCallback) {
				startCallback();
			}
			if (langCallback) {
				langCallback();
			}
		});
	} else if (startCallback) {
		trigger.subscribe(startCallback);
	}
}

/**
 * @param {number} code
 * @param {*=} message = ''
 * @param {*=} defCode = null
 * @returns {string}
 */
function getNotification(code) {
	var message = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
	var defCode = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

	code = __WEBPACK_IMPORTED_MODULE_0_window___default.a.parseInt(code, 10) || 0;
	if (__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].ClientViewError === code && message) {
		return message;
	}

	defCode = defCode ? __WEBPACK_IMPORTED_MODULE_0_window___default.a.parseInt(defCode, 10) || 0 : 0;
	return Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isUnd"])(I18N_NOTIFICATION_DATA[code]) ? defCode && Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isUnd"])(I18N_NOTIFICATION_DATA[defCode]) ? I18N_NOTIFICATION_DATA[defCode] : '' : I18N_NOTIFICATION_DATA[code];
}

/**
 * @param {object} response
 * @param {number} defCode = Notification.UnknownNotification
 * @returns {string}
 */
function getNotificationFromResponse(response) {
	var defCode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].UnknownNotification;

	return response && response.ErrorCode ? getNotification(Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pInt"])(response.ErrorCode), response.ErrorMessage || '') : getNotification(defCode);
}

/**
 * @param {*} code
 * @returns {string}
 */
function getUploadErrorDescByCode(code) {
	var result = '';
	switch (__WEBPACK_IMPORTED_MODULE_0_window___default.a.parseInt(code, 10) || 0) {
		case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["UploadErrorCode"].FileIsTooBig:
			result = i18n('UPLOAD/ERROR_FILE_IS_TOO_BIG');
			break;
		case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["UploadErrorCode"].FilePartiallyUploaded:
			result = i18n('UPLOAD/ERROR_FILE_PARTIALLY_UPLOADED');
			break;
		case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["UploadErrorCode"].FileNoUploaded:
			result = i18n('UPLOAD/ERROR_NO_FILE_UPLOADED');
			break;
		case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["UploadErrorCode"].MissingTempFolder:
			result = i18n('UPLOAD/ERROR_MISSING_TEMP_FOLDER');
			break;
		case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["UploadErrorCode"].FileOnSaveingError:
			result = i18n('UPLOAD/ERROR_ON_SAVING_FILE');
			break;
		case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["UploadErrorCode"].FileType:
			result = i18n('UPLOAD/ERROR_FILE_TYPE');
			break;
		default:
			result = i18n('UPLOAD/ERROR_UNKNOWN');
			break;
	}

	return result;
}

/**
 * @param {boolean} admin
 * @param {string} language
 */
function reload(admin, language) {
	var start = Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["microtime"])();

	__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["$html"].addClass('rl-changing-language');

	return new __WEBPACK_IMPORTED_MODULE_0_window___default.a.Promise(function (resolve, reject) {
		__WEBPACK_IMPORTED_MODULE_2_____default.a.ajax({
			url: Object(__WEBPACK_IMPORTED_MODULE_8_Common_Links__["n" /* langLink */])(language, admin),
			dataType: 'script',
			cache: true
		}).then(function () {
			__WEBPACK_IMPORTED_MODULE_1_____default.a.delay(function () {

				reloadData();

				var isRtl = -1 < Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])((language || '').toLowerCase(), ['ar', 'ar_sa', 'he', 'he_he', 'ur', 'ur_ir']);

				__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["$html"].removeClass('rl-changing-language').removeClass('rl-rtl rl-ltr')
				// .attr('dir', isRtl ? 'rtl' : 'ltr')
				.addClass(isRtl ? 'rl-rtl' : 'rl-ltr');

				resolve();
			}, 500 < Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["microtime"])() - start ? 1 : 500);
		}, function () {
			__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["$html"].removeClass('rl-changing-language');
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopI18N = null;
			reject();
		});
	});
}

// init section
__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["$html"].addClass('rl-' + (__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["$html"].attr('dir') || 'ltr'));

/***/ }),
/* 9 */
/*!****************************!*\
  !*** ./dev/Knoin/Knoin.js ***!
  \****************************/
/*! exports provided: ViewType, hideLoading, createCommand, addSettingsViewModel, removeSettingsViewModel, disableSettingsViewModel, routeOff, routeOn, screen, getScreenPopup, hideScreenPopup, vmRunHook, buildViewModel, showScreenPopup, warmUpScreenPopup, isPopupVisible, screenOnRoute, startScreens, setHash, commandDecorator, command, viewDecorator, view, viewModel, popupDecorator, popup, settingsMenuKeysHendler */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ViewType", function() { return ViewType; });
/* harmony export (immutable) */ __webpack_exports__["hideLoading"] = hideLoading;
/* harmony export (immutable) */ __webpack_exports__["createCommand"] = createCommand;
/* harmony export (immutable) */ __webpack_exports__["addSettingsViewModel"] = addSettingsViewModel;
/* harmony export (immutable) */ __webpack_exports__["removeSettingsViewModel"] = removeSettingsViewModel;
/* harmony export (immutable) */ __webpack_exports__["disableSettingsViewModel"] = disableSettingsViewModel;
/* harmony export (immutable) */ __webpack_exports__["routeOff"] = routeOff;
/* harmony export (immutable) */ __webpack_exports__["routeOn"] = routeOn;
/* harmony export (immutable) */ __webpack_exports__["screen"] = screen;
/* harmony export (immutable) */ __webpack_exports__["getScreenPopup"] = getScreenPopup;
/* harmony export (immutable) */ __webpack_exports__["hideScreenPopup"] = hideScreenPopup;
/* harmony export (immutable) */ __webpack_exports__["vmRunHook"] = vmRunHook;
/* harmony export (immutable) */ __webpack_exports__["buildViewModel"] = buildViewModel;
/* harmony export (immutable) */ __webpack_exports__["showScreenPopup"] = showScreenPopup;
/* harmony export (immutable) */ __webpack_exports__["warmUpScreenPopup"] = warmUpScreenPopup;
/* harmony export (immutable) */ __webpack_exports__["isPopupVisible"] = isPopupVisible;
/* harmony export (immutable) */ __webpack_exports__["screenOnRoute"] = screenOnRoute;
/* harmony export (immutable) */ __webpack_exports__["startScreens"] = startScreens;
/* harmony export (immutable) */ __webpack_exports__["setHash"] = setHash;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "commandDecorator", function() { return commandDecorator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "command", function() { return commandDecorator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "viewDecorator", function() { return viewDecorator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "view", function() { return viewDecorator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "viewModel", function() { return viewDecorator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "popupDecorator", function() { return popupDecorator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "popup", function() { return popupDecorator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "settingsMenuKeysHendler", function() { return settingsMenuKeysHendler; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! $ */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_hasher__ = __webpack_require__(/*! hasher */ 110);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_hasher___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_hasher__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_crossroads__ = __webpack_require__(/*! crossroads */ 86);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_crossroads___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_crossroads__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Plugins__ = __webpack_require__(/*! Common/Plugins */ 33);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);













var currentScreen = null,
    defaultScreenName = '';

var SCREENS = {};

var ViewType = {
	Popup: 'Popups',
	Left: 'Left',
	Right: 'Right',
	Center: 'Center'
};

/**
 * @returns {void}
 */
function hideLoading() {
	__WEBPACK_IMPORTED_MODULE_1_____default()('#rl-content').addClass('rl-content-show');
	__WEBPACK_IMPORTED_MODULE_1_____default()('#rl-loading').hide().remove();
}

/**
 * @param {Function} fExecute
 * @param {(Function|boolean|null)=} fCanExecute = true
 * @returns {Function}
 */
function createCommand(fExecute) {
	var fCanExecute = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

	return Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["createCommandLegacy"])(null, fExecute, fCanExecute);
}

/**
 * @param {Function} SettingsViewModelClass
 * @param {string} template
 * @param {string} labelName
 * @param {string} route
 * @param {boolean=} isDefault = false
 * @returns {void}
 */
function addSettingsViewModel(SettingsViewModelClass, template, labelName, route) {
	var isDefault = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;

	SettingsViewModelClass.__rlSettingsData = {
		Label: labelName,
		Template: template,
		Route: route,
		IsDefault: !!isDefault
	};

	__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["VIEW_MODELS"].settings.push(SettingsViewModelClass);
}

/**
 * @param {Function} SettingsViewModelClass
 * @returns {void}
 */
function removeSettingsViewModel(SettingsViewModelClass) {
	__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["VIEW_MODELS"]['settings-removed'].push(SettingsViewModelClass);
}

/**
 * @param {Function} SettingsViewModelClass
 * @returns {void}
 */
function disableSettingsViewModel(SettingsViewModelClass) {
	__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["VIEW_MODELS"]['settings-disabled'].push(SettingsViewModelClass);
}

/**
 * @returns {void}
 */
function routeOff() {
	__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.changed.active = false;
}

/**
 * @returns {void}
 */
function routeOn() {
	__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.changed.active = true;
}

/**
 * @param {string} screenName
 * @returns {?Object}
 */
function screen(screenName) {
	return '' !== screenName && !Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["isUnd"])(SCREENS[screenName]) ? SCREENS[screenName] : null;
}

/**
 * @param {Function} ViewModelClassToShow
 * @returns {Function|null}
 */
function getScreenPopup(PopuViewModelClass) {
	var result = null;
	if (PopuViewModelClass) {
		result = PopuViewModelClass;
		if (PopuViewModelClass.default) {
			result = PopuViewModelClass.default;
		}
	}

	return result;
}

/**
 * @param {Function} ViewModelClassToHide
 * @returns {void}
 */
function hideScreenPopup(ViewModelClassToHide) {
	var ModalView = getScreenPopup(ViewModelClassToHide);
	if (ModalView && ModalView.__vm && ModalView.__dom) {
		ModalView.__vm.modalVisibility(false);
	}
}

/**
 * @param {string} hookName
 * @param {Function} ViewModelClass
 * @param {mixed=} params = null
 */
function vmRunHook(hookName, ViewModelClass) {
	var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

	__WEBPACK_IMPORTED_MODULE_0_____default.a.each(ViewModelClass.__names, function (name) {
		Object(__WEBPACK_IMPORTED_MODULE_6_Common_Plugins__["f" /* runHook */])(hookName, [name, ViewModelClass.__vm, params]);
	});
}

/**
 * @param {Function} ViewModelClass
 * @param {Object=} vmScreen
 * @returns {*}
 */
function buildViewModel(ViewModelClass, vmScreen) {
	if (ViewModelClass && !ViewModelClass.__builded) {
		var vmDom = null;
		var vm = new ViewModelClass(vmScreen),
		    position = ViewModelClass.__type || '',
		    vmPlace = position ? __WEBPACK_IMPORTED_MODULE_1_____default()('#rl-content #rl-' + position.toLowerCase()) : null;

		ViewModelClass.__builded = true;
		ViewModelClass.__vm = vm;

		vm.onShowTrigger = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(false);
		vm.onHideTrigger = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(false);

		vm.viewModelName = ViewModelClass.__name;
		vm.viewModelNames = ViewModelClass.__names;
		vm.viewModelTemplateID = ViewModelClass.__templateID;
		vm.viewModelPosition = ViewModelClass.__type;

		if (vmPlace && 1 === vmPlace.length) {
			vmDom = __WEBPACK_IMPORTED_MODULE_1_____default()('<div></div>').addClass('rl-view-model').addClass('RL-' + vm.viewModelTemplateID).hide();
			vmDom.appendTo(vmPlace);

			vm.viewModelDom = vmDom;
			ViewModelClass.__dom = vmDom;

			if (ViewType.Popup === position) {
				vm.cancelCommand = vm.closeCommand = createCommand(function () {
					hideScreenPopup(ViewModelClass);
				});

				vm.modalVisibility.subscribe(function (value) {
					if (value) {
						vm.viewModelDom.show();
						vm.storeAndSetKeyScope();

						__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["popupVisibilityNames"].push(vm.viewModelName);
						vm.viewModelDom.css('z-index', 3000 + Object(__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["popupVisibilityNames"])().length + 10);

						if (vm.onShowTrigger) {
							vm.onShowTrigger(!vm.onShowTrigger());
						}

						Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["delegateRun"])(vm, 'onShowWithDelay', [], 500);
					} else {
						Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["delegateRun"])(vm, 'onHide');
						Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["delegateRun"])(vm, 'onHideWithDelay', [], 500);

						if (vm.onHideTrigger) {
							vm.onHideTrigger(!vm.onHideTrigger());
						}

						vm.restoreKeyScope();

						vmRunHook('view-model-on-hide', ViewModelClass);

						__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["popupVisibilityNames"].remove(vm.viewModelName);
						vm.viewModelDom.css('z-index', 2000);

						__WEBPACK_IMPORTED_MODULE_0_____default.a.delay(function () {
							return vm.viewModelDom.hide();
						}, 300);
					}
				});
			}

			vmRunHook('view-model-pre-build', ViewModelClass, vmDom);

			__WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].applyBindingAccessorsToNode(vmDom[0], {
				translatorInit: true,
				template: function template() {
					return { name: vm.viewModelTemplateID };
				}
			}, vm);

			Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["delegateRun"])(vm, 'onBuild', [vmDom]);
			if (vm && ViewType.Popup === position) {
				vm.registerPopupKeyDown();
			}

			vmRunHook('view-model-post-build', ViewModelClass, vmDom);
		} else {
			Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["log"])('Cannot find view model position: ' + position);
		}
	}

	return ViewModelClass ? ViewModelClass.__vm : null;
}

/**
 * @param {Function} ViewModelClassToShow
 * @param {Array=} params
 * @returns {void}
 */
function showScreenPopup(ViewModelClassToShow) {
	var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

	var ModalView = getScreenPopup(ViewModelClassToShow);
	if (ModalView) {
		buildViewModel(ModalView);

		if (ModalView.__vm && ModalView.__dom) {
			Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["delegateRun"])(ModalView.__vm, 'onBeforeShow', params || []);

			ModalView.__vm.modalVisibility(true);

			Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["delegateRun"])(ModalView.__vm, 'onShow', params || []);

			vmRunHook('view-model-on-show', ModalView, params || []);
		}
	}
}

/**
 * @param {Function} ViewModelClassToShow
 * @returns {void}
 */
function warmUpScreenPopup(ViewModelClassToShow) {
	var ModalView = getScreenPopup(ViewModelClassToShow);
	if (ModalView) {
		buildViewModel(ModalView);

		if (ModalView.__vm && ModalView.__dom) {
			Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["delegateRun"])(ModalView.__vm, 'onWarmUp');
		}
	}
}

/**
 * @param {Function} ViewModelClassToShow
 * @returns {boolean}
 */
function isPopupVisible(ViewModelClassToShow) {
	var ModalView = getScreenPopup(ViewModelClassToShow);
	return ModalView && ModalView.__vm ? ModalView.__vm.modalVisibility() : false;
}

/**
 * @param {string} screenName
 * @param {string} subPart
 * @returns {void}
 */
function screenOnRoute(screenName, subPart) {
	var vmScreen = null,
	    isSameScreen = false,
	    cross = null;

	if ('' === Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["pString"])(screenName)) {
		screenName = defaultScreenName;
	}

	if ('' !== screenName) {
		vmScreen = screen(screenName);
		if (!vmScreen) {
			vmScreen = screen(defaultScreenName);
			if (vmScreen) {
				subPart = screenName + '/' + subPart;
				screenName = defaultScreenName;
			}
		}

		if (vmScreen && vmScreen.__started) {
			isSameScreen = currentScreen && vmScreen === currentScreen;

			if (!vmScreen.__builded) {
				vmScreen.__builded = true;

				if (Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["isNonEmptyArray"])(vmScreen.viewModels())) {
					__WEBPACK_IMPORTED_MODULE_0_____default.a.each(vmScreen.viewModels(), function (ViewModelClass) {
						buildViewModel(ViewModelClass, vmScreen);
					});
				}

				Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["delegateRun"])(vmScreen, 'onBuild');
			}

			__WEBPACK_IMPORTED_MODULE_0_____default.a.defer(function () {
				// hide screen
				if (currentScreen && !isSameScreen) {
					Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["delegateRun"])(currentScreen, 'onHide');
					Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["delegateRun"])(currentScreen, 'onHideWithDelay', [], 500);

					if (currentScreen.onHideTrigger) {
						currentScreen.onHideTrigger(!currentScreen.onHideTrigger());
					}

					if (Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["isNonEmptyArray"])(currentScreen.viewModels())) {
						__WEBPACK_IMPORTED_MODULE_0_____default.a.each(currentScreen.viewModels(), function (ViewModelClass) {
							if (ViewModelClass.__vm && ViewModelClass.__dom && ViewType.Popup !== ViewModelClass.__vm.viewModelPosition) {
								ViewModelClass.__dom.hide();
								ViewModelClass.__vm.viewModelVisibility(false);

								Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["delegateRun"])(ViewModelClass.__vm, 'onHide');
								Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["delegateRun"])(ViewModelClass.__vm, 'onHideWithDelay', [], 500);

								if (ViewModelClass.__vm.onHideTrigger) {
									ViewModelClass.__vm.onHideTrigger(!ViewModelClass.__vm.onHideTrigger());
								}
							}
						});
					}
				}
				// --

				currentScreen = vmScreen;

				// show screen
				if (currentScreen && !isSameScreen) {
					Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["delegateRun"])(currentScreen, 'onShow');
					if (currentScreen.onShowTrigger) {
						currentScreen.onShowTrigger(!currentScreen.onShowTrigger());
					}

					Object(__WEBPACK_IMPORTED_MODULE_6_Common_Plugins__["f" /* runHook */])('screen-on-show', [currentScreen.screenName(), currentScreen]);

					if (Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["isNonEmptyArray"])(currentScreen.viewModels())) {
						__WEBPACK_IMPORTED_MODULE_0_____default.a.each(currentScreen.viewModels(), function (ViewModelClass) {

							if (ViewModelClass.__vm && ViewModelClass.__dom && ViewType.Popup !== ViewModelClass.__vm.viewModelPosition) {
								Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["delegateRun"])(ViewModelClass.__vm, 'onBeforeShow');

								ViewModelClass.__dom.show();
								ViewModelClass.__vm.viewModelVisibility(true);

								Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["delegateRun"])(ViewModelClass.__vm, 'onShow');
								if (ViewModelClass.__vm.onShowTrigger) {
									ViewModelClass.__vm.onShowTrigger(!ViewModelClass.__vm.onShowTrigger());
								}

								Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["delegateRun"])(ViewModelClass.__vm, 'onShowWithDelay', [], 200);
								vmRunHook('view-model-on-show', ViewModelClass);
							}
						});
					}
				}
				// --

				cross = vmScreen && vmScreen.__cross ? vmScreen.__cross() : null;
				if (cross) {
					cross.parse(subPart);
				}
			});
		}
	}
}

/**
 * @param {Array} screensClasses
 * @returns {void}
 */
function startScreens(screensClasses) {
	__WEBPACK_IMPORTED_MODULE_0_____default.a.each(screensClasses, function (CScreen) {
		if (CScreen) {
			var vmScreen = new CScreen(),
			    screenName = vmScreen ? vmScreen.screenName() : '';

			if (vmScreen && '' !== screenName) {
				if ('' === defaultScreenName) {
					defaultScreenName = screenName;
				}

				SCREENS[screenName] = vmScreen;
			}
		}
	});

	__WEBPACK_IMPORTED_MODULE_0_____default.a.each(SCREENS, function (vmScreen) {
		if (vmScreen && !vmScreen.__started && vmScreen.__start) {
			vmScreen.__started = true;
			vmScreen.__start();

			Object(__WEBPACK_IMPORTED_MODULE_6_Common_Plugins__["f" /* runHook */])('screen-pre-start', [vmScreen.screenName(), vmScreen]);
			Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["delegateRun"])(vmScreen, 'onStart');
			Object(__WEBPACK_IMPORTED_MODULE_6_Common_Plugins__["f" /* runHook */])('screen-post-start', [vmScreen.screenName(), vmScreen]);
		}
	});

	var cross = __WEBPACK_IMPORTED_MODULE_4_crossroads___default.a.create();
	cross.addRoute(/^([a-zA-Z0-9\-]*)\/?(.*)$/, screenOnRoute);

	__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.initialized.add(cross.parse, cross);
	__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.changed.add(cross.parse, cross);
	__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.init();

	__WEBPACK_IMPORTED_MODULE_0_____default.a.delay(function () {
		return __WEBPACK_IMPORTED_MODULE_7_Common_Globals__["$html"].removeClass('rl-started-trigger').addClass('rl-started');
	}, 100);
	__WEBPACK_IMPORTED_MODULE_0_____default.a.delay(function () {
		return __WEBPACK_IMPORTED_MODULE_7_Common_Globals__["$html"].addClass('rl-started-delay');
	}, 200);
}

/**
 * @param {string} sHash
 * @param {boolean=} silence = false
 * @param {boolean=} replace = false
 * @returns {void}
 */
function setHash(hash) {
	var silence = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
	var replace = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

	hash = '#' === hash.substr(0, 1) ? hash.substr(1) : hash;
	hash = '/' === hash.substr(0, 1) ? hash.substr(1) : hash;

	var cmd = replace ? 'replaceHash' : 'setHash';

	if (silence) {
		__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.changed.active = false;
		__WEBPACK_IMPORTED_MODULE_3_hasher___default.a[cmd](hash);
		__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.changed.active = true;
	} else {
		__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.changed.active = true;
		__WEBPACK_IMPORTED_MODULE_3_hasher___default.a[cmd](hash);
		__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.setHash(hash);
	}
}

/**
 * @param {Object} params
 * @returns {Function}
 */
function viewDecorator(_ref) {
	var name = _ref.name,
	    type = _ref.type,
	    templateID = _ref.templateID;

	return function (target) {
		if (target) {
			if (name) {
				if (Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["isArray"])(name)) {
					target.__names = name;
				} else {
					target.__names = [name];
				}

				target.__name = target.__names[0];
			}

			if (type) {
				target.__type = type;
			}

			if (templateID) {
				target.__templateID = templateID;
			}
		}
	};
}

/**
 * @param {Object} params
 * @returns {Function}
 */
function popupDecorator(_ref2) {
	var name = _ref2.name,
	    templateID = _ref2.templateID;

	return viewDecorator({ name: name, type: ViewType.Popup, templateID: templateID });
}

/**
 * @param {Function} canExecute
 * @returns {Function}
 */
function commandDecorator() {
	var canExecute = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

	return function (target, key, descriptor) {

		if (!key || !key.match(/Command$/)) {
			throw new Error('name "' + key + '" should end with Command suffix');
		}

		var value = descriptor.value || descriptor.initializer(),
		    normCanExecute = Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["isFunc"])(canExecute) ? canExecute : function () {
			return !!canExecute;
		};

		descriptor.value = function () {
			if (normCanExecute.call(this, this)) {
				for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
					args[_key] = arguments[_key];
				}

				value.apply(this, args);
			}

			return false;
		};

		descriptor.value.__realCanExecute = normCanExecute;
		descriptor.value.isCommand = true;

		return descriptor;
	};
}

/**
 * @param {miced} $items
 * @returns {Function}
 */
function settingsMenuKeysHendler($items) {
	return __WEBPACK_IMPORTED_MODULE_0_____default.a.throttle(function (event, handler) {

		var up = handler && 'up' === handler.shortcut;

		if (event && $items.length) {
			var index = $items.index($items.filter('.selected'));
			if (up && 0 < index) {
				index -= 1;
			} else if (!up && index < $items.length - 1) {
				index += 1;
			}

			var resultHash = $items.eq(index).attr('href');
			if (resultHash) {
				setHash(resultHash, false, true);
			}
		}
	}, __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Magics"].Time200ms);
}



/***/ }),
/* 10 */
/*!*********************************!*\
  !*** ./dev/Storage/Settings.js ***!
  \*********************************/
/*! exports provided: settingsGet, settingsSet, appSettingsGet, capa */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (immutable) */ __webpack_exports__["settingsGet"] = settingsGet;
/* harmony export (immutable) */ __webpack_exports__["settingsSet"] = settingsSet;
/* harmony export (immutable) */ __webpack_exports__["appSettingsGet"] = appSettingsGet;
/* harmony export (immutable) */ __webpack_exports__["capa"] = capa;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);




var SETTINGS = __WEBPACK_IMPORTED_MODULE_0_window___default.a.__rlah_data() || null;
SETTINGS = Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isNormal"])(SETTINGS) ? SETTINGS : {};

var APP_SETTINGS = SETTINGS.System || null;
APP_SETTINGS = Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isNormal"])(APP_SETTINGS) ? APP_SETTINGS : {};

/**
 * @param {string} name
 * @returns {*}
 */
function settingsGet(name) {
  return Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(SETTINGS[name]) ? null : SETTINGS[name];
}

/**
 * @param {string} name
 * @param {*} value
 */
function settingsSet(name, value) {
  SETTINGS[name] = value;
}

/**
 * @param {string} name
 * @returns {*}
 */
function appSettingsGet(name) {
  return Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(APP_SETTINGS[name]) ? null : APP_SETTINGS[name];
}

/**
 * @param {string} name
 * @returns {boolean}
 */
function capa(name) {
  var values = settingsGet('Capa');
  return Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isArray"])(values) && Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isNormal"])(name) && -1 < Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["inArray"])(name, values);
}

/***/ }),
/* 11 */
/*!*************************!*\
  !*** external "window" ***!
  \*************************/
/*! no static exports found */
/*! exports used: default */
/***/ (function(module, exports) {

module.exports = window;

/***/ }),
/* 12 */
/*!********************************!*\
  !*** external "window.jQuery" ***!
  \********************************/
/*! no static exports found */
/*! exports used: default */
/***/ (function(module, exports) {

module.exports = window.jQuery;

/***/ }),
/* 13 */
/*!***************************************!*\
  !*** ./dev/Knoin/AbstractViewNext.js ***!
  \***************************************/
/*! exports provided: AbstractViewNext */
/*! exports used: AbstractViewNext */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AbstractViewNext; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);








var AbstractViewNext = function () {
	function AbstractViewNext() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, AbstractViewNext);

		this.bDisabeCloseOnEsc = false;
		this.sDefaultKeyScope = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["KeyState"].None;
		this.sCurrentKeyScope = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["KeyState"].None;
		this.viewModelVisibility = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(false);
		this.modalVisibility = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(false).extend({ rateLimit: 0 });
		this.viewModelName = '';
		this.viewModelNames = [];
		this.viewModelDom = null;
	}

	/**
  * @returns {void}
  */
	AbstractViewNext.prototype.storeAndSetKeyScope = function storeAndSetKeyScope() {
		this.sCurrentKeyScope = Object(__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["keyScope"])();
		Object(__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["keyScope"])(this.sDefaultKeyScope);
	};

	/**
  * @returns {void}
  */


	AbstractViewNext.prototype.restoreKeyScope = function restoreKeyScope() {
		Object(__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["keyScope"])(this.sCurrentKeyScope);
	};

	/**
  * @returns {void}
  */


	AbstractViewNext.prototype.registerPopupKeyDown = function registerPopupKeyDown() {
		var _this = this;

		__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$win"].on('keydown', function (event) {
			if (event && _this.modalVisibility && _this.modalVisibility()) {
				if (!_this.bDisabeCloseOnEsc && __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["EventKeyCode"].Esc === event.keyCode) {
					Object(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["delegateRun"])(_this, 'cancelCommand');
					return false;
				} else if (__WEBPACK_IMPORTED_MODULE_3_Common_Enums__["EventKeyCode"].Backspace === event.keyCode && !Object(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["inFocus"])()) {
					return false;
				}
			}

			return true;
		});
	};

	AbstractViewNext.prototype.cancelCommand = function cancelCommand() {}; // eslint-disable-line no-empty-function


	AbstractViewNext.prototype.closeCommand = function closeCommand() {}; // eslint-disable-line no-empty-function


	return AbstractViewNext;
}();

/***/ }),
/* 14 */
/*!*****************************!*\
  !*** ./dev/Common/Links.js ***!
  \*****************************/
/*! exports provided: populateAuthSuffix, subQueryPrefix, root, rootAdmin, rootUser, attachmentRaw, attachmentDownload, attachmentPreview, attachmentThumbnailPreview, attachmentPreviewAsPlain, attachmentFramed, serverRequest, upload, uploadContacts, uploadBackground, append, change, ajax, messageViewLink, messageDownloadLink, avatarLink, publicLink, userBackground, phpInfo, langLink, exportContactsVcf, exportContactsCsv, socialGoogle, socialTwitter, socialFacebook, staticPrefix, emptyContactPic, sound, notificationMailIcon, openPgpJs, openPgpWorkerJs, openPgpWorkerPath, themePreviewLink, inbox, settings, about, admin, mailBox */
/*! exports used: ajax, append, attachmentDownload, attachmentFramed, attachmentPreview, attachmentPreviewAsPlain, attachmentThumbnailPreview, avatarLink, change, emptyContactPic, exportContactsCsv, exportContactsVcf, inbox, langLink, mailBox, messageDownloadLink, messageViewLink, notificationMailIcon, openPgpJs, openPgpWorkerJs, phpInfo, populateAuthSuffix, root, rootAdmin, rootUser, settings, socialFacebook, socialGoogle, socialTwitter, sound, subQueryPrefix, themePreviewLink, upload, uploadBackground, uploadContacts, userBackground */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["v"] = populateAuthSuffix;
/* harmony export (immutable) */ __webpack_exports__["E"] = subQueryPrefix;
/* harmony export (immutable) */ __webpack_exports__["w"] = root;
/* harmony export (immutable) */ __webpack_exports__["x"] = rootAdmin;
/* harmony export (immutable) */ __webpack_exports__["y"] = rootUser;
/* unused harmony export attachmentRaw */
/* harmony export (immutable) */ __webpack_exports__["c"] = attachmentDownload;
/* harmony export (immutable) */ __webpack_exports__["e"] = attachmentPreview;
/* harmony export (immutable) */ __webpack_exports__["g"] = attachmentThumbnailPreview;
/* harmony export (immutable) */ __webpack_exports__["f"] = attachmentPreviewAsPlain;
/* harmony export (immutable) */ __webpack_exports__["d"] = attachmentFramed;
/* unused harmony export serverRequest */
/* harmony export (immutable) */ __webpack_exports__["G"] = upload;
/* harmony export (immutable) */ __webpack_exports__["I"] = uploadContacts;
/* harmony export (immutable) */ __webpack_exports__["H"] = uploadBackground;
/* harmony export (immutable) */ __webpack_exports__["b"] = append;
/* harmony export (immutable) */ __webpack_exports__["i"] = change;
/* harmony export (immutable) */ __webpack_exports__["a"] = ajax;
/* harmony export (immutable) */ __webpack_exports__["q"] = messageViewLink;
/* harmony export (immutable) */ __webpack_exports__["p"] = messageDownloadLink;
/* harmony export (immutable) */ __webpack_exports__["h"] = avatarLink;
/* unused harmony export publicLink */
/* harmony export (immutable) */ __webpack_exports__["J"] = userBackground;
/* harmony export (immutable) */ __webpack_exports__["u"] = phpInfo;
/* harmony export (immutable) */ __webpack_exports__["n"] = langLink;
/* harmony export (immutable) */ __webpack_exports__["l"] = exportContactsVcf;
/* harmony export (immutable) */ __webpack_exports__["k"] = exportContactsCsv;
/* harmony export (immutable) */ __webpack_exports__["B"] = socialGoogle;
/* harmony export (immutable) */ __webpack_exports__["C"] = socialTwitter;
/* harmony export (immutable) */ __webpack_exports__["A"] = socialFacebook;
/* unused harmony export staticPrefix */
/* harmony export (immutable) */ __webpack_exports__["j"] = emptyContactPic;
/* harmony export (immutable) */ __webpack_exports__["D"] = sound;
/* harmony export (immutable) */ __webpack_exports__["r"] = notificationMailIcon;
/* harmony export (immutable) */ __webpack_exports__["s"] = openPgpJs;
/* harmony export (immutable) */ __webpack_exports__["t"] = openPgpWorkerJs;
/* unused harmony export openPgpWorkerPath */
/* harmony export (immutable) */ __webpack_exports__["F"] = themePreviewLink;
/* harmony export (immutable) */ __webpack_exports__["m"] = inbox;
/* harmony export (immutable) */ __webpack_exports__["z"] = settings;
/* unused harmony export about */
/* unused harmony export admin */
/* harmony export (immutable) */ __webpack_exports__["o"] = mailBox;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);





var ROOT = './',
    HASH_PREFIX = '#/',
    SERVER_PREFIX = './?',
    SUB_QUERY_PREFIX = '&q[]=',
    VERSION = __WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["appSettingsGet"]('version'),
    WEB_PREFIX = __WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["appSettingsGet"]('webPath') || '',
    VERSION_PREFIX = __WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["appSettingsGet"]('webVersionPath') || 'rainloop/v/' + VERSION + '/',
    STATIC_PREFIX = VERSION_PREFIX + 'static/',
    ADMIN_HOST_USE = !!__WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["appSettingsGet"]('adminHostUse'),
    ADMIN_PATH = __WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["appSettingsGet"]('adminPath') || 'admin';

var AUTH_PREFIX = __WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["settingsGet"]('AuthAccountHash') || '0';

/**
 * @returns {void}
 */
function populateAuthSuffix() {
  AUTH_PREFIX = __WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["settingsGet"]('AuthAccountHash') || '0';
}

/**
 * @returns {string}
 */
function subQueryPrefix() {
  return SUB_QUERY_PREFIX;
}

/**
 * @param {string=} startupUrl
 * @returns {string}
 */
function root() {
  var startupUrl = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

  return HASH_PREFIX + Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["pString"])(startupUrl);
}

/**
 * @returns {string}
 */
function rootAdmin() {
  return ADMIN_HOST_USE ? ROOT : SERVER_PREFIX + ADMIN_PATH;
}

/**
 * @returns {string}
 */
function rootUser() {
  return ROOT;
}

/**
 * @param {string} type
 * @param {string} download
 * @param {string=} customSpecSuffix
 * @returns {string}
 */
function attachmentRaw(type, download, customSpecSuffix) {
  customSpecSuffix = Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(customSpecSuffix) ? AUTH_PREFIX : customSpecSuffix;
  return SERVER_PREFIX + '/Raw/' + SUB_QUERY_PREFIX + '/' + customSpecSuffix + '/' + type + '/' + SUB_QUERY_PREFIX + '/' + download;
}

/**
 * @param {string} download
 * @param {string=} customSpecSuffix
 * @returns {string}
 */
function attachmentDownload(download, customSpecSuffix) {
  return attachmentRaw('Download', download, customSpecSuffix);
}

/**
 * @param {string} download
 * @param {string=} customSpecSuffix
 * @returns {string}
 */
function attachmentPreview(download, customSpecSuffix) {
  return attachmentRaw('View', download, customSpecSuffix);
}

/**
 * @param {string} download
 * @param {string=} customSpecSuffix
 * @returns {string}
 */
function attachmentThumbnailPreview(download, customSpecSuffix) {
  return attachmentRaw('ViewThumbnail', download, customSpecSuffix);
}

/**
 * @param {string} download
 * @param {string=} customSpecSuffix
 * @returns {string}
 */
function attachmentPreviewAsPlain(download, customSpecSuffix) {
  return attachmentRaw('ViewAsPlain', download, customSpecSuffix);
}

/**
 * @param {string} download
 * @param {string=} customSpecSuffix
 * @returns {string}
 */
function attachmentFramed(download, customSpecSuffix) {
  return attachmentRaw('FramedView', download, customSpecSuffix);
}

/**
 * @param {string} type
 * @returns {string}
 */
function serverRequest(type) {
  return SERVER_PREFIX + '/' + type + '/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/';
}

/**
 * @returns {string}
 */
function upload() {
  return serverRequest('Upload');
}

/**
 * @returns {string}
 */
function uploadContacts() {
  return serverRequest('UploadContacts');
}

/**
 * @returns {string}
 */
function uploadBackground() {
  return serverRequest('UploadBackground');
}

/**
 * @returns {string}
 */
function append() {
  return serverRequest('Append');
}

/**
 * @param {string} email
 * @returns {string}
 */
function change(email) {
  return serverRequest('Change') + Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["encodeURIComponent"])(email) + '/';
}

/**
 * @param {string} add
 * @returns {string}
 */
function ajax(add) {
  return serverRequest('Ajax') + add;
}

/**
 * @param {string} requestHash
 * @returns {string}
 */
function messageViewLink(requestHash) {
  return SERVER_PREFIX + '/Raw/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/ViewAsPlain/' + SUB_QUERY_PREFIX + '/' + requestHash;
}

/**
 * @param {string} requestHash
 * @returns {string}
 */
function messageDownloadLink(requestHash) {
  return SERVER_PREFIX + '/Raw/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/Download/' + SUB_QUERY_PREFIX + '/' + requestHash;
}

/**
 * @param {string} email
 * @returns {string}
 */
function avatarLink(email) {
  return SERVER_PREFIX + '/Raw/0/Avatar/' + Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["encodeURIComponent"])(email) + '/';
}

/**
 * @param {string} hash
 * @returns {string}
 */
function publicLink(hash) {
  return SERVER_PREFIX + '/Raw/0/Public/' + hash + '/';
}

/**
 * @param {string} hash
 * @returns {string}
 */
function userBackground(hash) {
  return SERVER_PREFIX + '/Raw/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/UserBackground/' + SUB_QUERY_PREFIX + '/' + hash;
}

/**
 * @returns {string}
 */
function phpInfo() {
  return SERVER_PREFIX + '/Info';
}

/**
 * @param {string} lang
 * @param {boolean} isAdmin
 * @returns {string}
 */
function langLink(lang, isAdmin) {
  return SERVER_PREFIX + '/Lang/0/' + (isAdmin ? 'Admin' : 'App') + '/' + __WEBPACK_IMPORTED_MODULE_0_window___default.a.encodeURI(lang) + '/' + VERSION + '/';
}

/**
 * @returns {string}
 */
function exportContactsVcf() {
  return SERVER_PREFIX + '/Raw/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/ContactsVcf/';
}

/**
 * @returns {string}
 */
function exportContactsCsv() {
  return SERVER_PREFIX + '/Raw/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/ContactsCsv/';
}

/**
 * @param {boolean} xauth = false
 * @returns {string}
 */
function socialGoogle() {
  var xauth = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

  return SERVER_PREFIX + 'SocialGoogle' + ('' !== AUTH_PREFIX ? '/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/' : '') + (xauth ? '&xauth=1' : '');
}

/**
 * @returns {string}
 */
function socialTwitter() {
  return SERVER_PREFIX + 'SocialTwitter' + ('' !== AUTH_PREFIX ? '/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/' : '');
}

/**
 * @returns {string}
 */
function socialFacebook() {
  return SERVER_PREFIX + 'SocialFacebook' + ('' !== AUTH_PREFIX ? '/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/' : '');
}

/**
 * @param {string} path
 * @returns {string}
 */
function staticPrefix(path) {
  return STATIC_PREFIX + path;
}

/**
 * @returns {string}
 */
function emptyContactPic() {
  return staticPrefix('css/images/empty-contact.png');
}

/**
 * @param {string} fileName
 * @returns {string}
 */
function sound(fileName) {
  return staticPrefix('sounds/' + fileName);
}

/**
 * @returns {string}
 */
function notificationMailIcon() {
  return staticPrefix('css/images/icom-message-notification.png');
}

/**
 * @returns {string}
 */
function openPgpJs() {
  return staticPrefix('js/min/openpgp.min.js');
}

/**
 * @returns {string}
 */
function openPgpWorkerJs() {
  return staticPrefix('js/min/openpgp.worker.min.js');
}

/**
 * @returns {string}
 */
function openPgpWorkerPath() {
  return staticPrefix('js/min/');
}

/**
 * @param {string} theme
 * @returns {string}
 */
function themePreviewLink(theme) {
  var prefix = VERSION_PREFIX;
  if ('@custom' === theme.substr(-7)) {
    theme = Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["trim"])(theme.substring(0, theme.length - 7));
    prefix = WEB_PREFIX;
  }

  return prefix + 'themes/' + __WEBPACK_IMPORTED_MODULE_0_window___default.a.encodeURI(theme) + '/images/preview.png';
}

/**
 * @param {string} inboxFolderName = 'INBOX'
 * @returns {string}
 */
function inbox() {
  var inboxFolderName = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'INBOX';

  return HASH_PREFIX + 'mailbox/' + inboxFolderName;
}

/**
 * @param {string=} screenName = ''
 * @returns {string}
 */
function settings() {
  var screenName = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

  return HASH_PREFIX + 'settings' + (screenName ? '/' + screenName : '');
}

/**
 * @returns {string}
 */
function about() {
  return HASH_PREFIX + 'about';
}

/**
 * @param {string} screenName
 * @returns {string}
 */
function admin(screenName) {
  var result = HASH_PREFIX;
  switch (screenName) {
    case 'AdminDomains':
      result += 'domains';
      break;
    case 'AdminSecurity':
      result += 'security';
      break;
    case 'AdminLicensing':
      result += 'licensing';
      break;
    // no default
  }

  return result;
}

/**
 * @param {string} folder
 * @param {number=} page = 1
 * @param {string=} search = ''
 * @param {string=} threadUid = ''
 * @returns {string}
 */
function mailBox(folder) {
  var page = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
  var search = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
  var threadUid = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';

  page = Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isNormal"])(page) ? Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["pInt"])(page) : 1;
  search = Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["pString"])(search);

  var result = HASH_PREFIX + 'mailbox/';

  if ('' !== folder) {
    var resultThreadUid = Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["pInt"])(threadUid);
    result += __WEBPACK_IMPORTED_MODULE_0_window___default.a.encodeURI(folder) + (0 < resultThreadUid ? '~' + resultThreadUid : '');
  }

  if (1 < page) {
    result = result.replace(/[\/]+$/, '');
    result += '/p' + page;
  }

  if ('' !== search) {
    result = result.replace(/[\/]+$/, '');
    result += '/' + __WEBPACK_IMPORTED_MODULE_0_window___default.a.encodeURI(search);
  }

  return result;
}

/***/ }),
/* 15 */
/*!**********************************************************************************!*\
  !*** ./node_modules/babel-runtime/core-js/object/get-own-property-descriptor.js ***!
  \**********************************************************************************/
/*! no static exports found */
/*! exports used: default */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(/*! core-js/library/fn/object/get-own-property-descriptor */ 79), __esModule: true };

/***/ }),
/* 16 */
/*!*********************************!*\
  !*** ./dev/Helper/Apps/User.js ***!
  \*********************************/
/*! exports provided: getApp */
/*! exports used: getApp */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = getApp;

/**
 * @returns {AppUser}
 */
function getApp() {
  return __webpack_require__(/*! App/User */ 173).default;
}

/***/ }),
/* 17 */
/*!*********************************!*\
  !*** ./dev/Remote/User/Ajax.js ***!
  \*********************************/
/*! exports provided: default */
/*! exports used: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Consts__ = __webpack_require__(/*! Common/Consts */ 20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Cache__ = __webpack_require__(/*! Common/Cache */ 27);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Links__ = __webpack_require__(/*! Common/Links */ 14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Common_Base64__ = __webpack_require__(/*! Common/Base64 */ 217);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Stores_User_App__ = __webpack_require__(/*! Stores/User/App */ 34);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_Stores_User_Settings__ = __webpack_require__(/*! Stores/User/Settings */ 41);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_Helper_Apps_User__ = __webpack_require__(/*! Helper/Apps/User */ 16);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13_Remote_AbstractAjax__ = __webpack_require__(/*! Remote/AbstractAjax */ 148);























var RemoteUserAjax = function (_AbstractAjaxRemote) {
	__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(RemoteUserAjax, _AbstractAjaxRemote);

	function RemoteUserAjax() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, RemoteUserAjax);

		var _this = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractAjaxRemote.call(this));

		_this.oRequests = {};
		return _this;
	}

	/**
  * @param {?Function} fCallback
  */


	RemoteUserAjax.prototype.folders = function folders(fCallback) {
		this.defaultRequest(fCallback, 'Folders', {
			'SentFolder': __WEBPACK_IMPORTED_MODULE_9_Storage_Settings__["settingsGet"]('SentFolder'),
			'DraftFolder': __WEBPACK_IMPORTED_MODULE_9_Storage_Settings__["settingsGet"]('DraftFolder'),
			'SpamFolder': __WEBPACK_IMPORTED_MODULE_9_Storage_Settings__["settingsGet"]('SpamFolder'),
			'TrashFolder': __WEBPACK_IMPORTED_MODULE_9_Storage_Settings__["settingsGet"]('TrashFolder'),
			'ArchiveFolder': __WEBPACK_IMPORTED_MODULE_9_Storage_Settings__["settingsGet"]('ArchiveFolder')
		}, null, '', ['Folders']);
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sEmail
  * @param {string} sLogin
  * @param {string} sPassword
  * @param {boolean} bSignMe
  * @param {string=} sLanguage
  * @param {string=} sAdditionalCode
  * @param {boolean=} bAdditionalCodeSignMe
  */


	RemoteUserAjax.prototype.login = function login(fCallback, sEmail, sLogin, sPassword, bSignMe, sLanguage, sAdditionalCode, bAdditionalCodeSignMe) {
		this.defaultRequest(fCallback, 'Login', {
			'Email': sEmail,
			'Login': sLogin,
			'Password': sPassword,
			'Language': sLanguage || '',
			'AdditionalCode': sAdditionalCode || '',
			'AdditionalCodeSignMe': bAdditionalCodeSignMe ? '1' : '0',
			'SignMe': bSignMe ? '1' : '0'
		});
	};

	/**
  * @param {?Function} fCallback
  */


	RemoteUserAjax.prototype.getTwoFactor = function getTwoFactor(fCallback) {
		this.defaultRequest(fCallback, 'GetTwoFactorInfo');
	};

	/**
  * @param {?Function} fCallback
  */


	RemoteUserAjax.prototype.createTwoFactor = function createTwoFactor(fCallback) {
		this.defaultRequest(fCallback, 'CreateTwoFactorSecret');
	};

	/**
  * @param {?Function} fCallback
  */


	RemoteUserAjax.prototype.clearTwoFactor = function clearTwoFactor(fCallback) {
		this.defaultRequest(fCallback, 'ClearTwoFactorInfo');
	};

	/**
  * @param {?Function} fCallback
  */


	RemoteUserAjax.prototype.showTwoFactorSecret = function showTwoFactorSecret(fCallback) {
		this.defaultRequest(fCallback, 'ShowTwoFactorSecret');
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sCode
  */


	RemoteUserAjax.prototype.testTwoFactor = function testTwoFactor(fCallback, sCode) {
		this.defaultRequest(fCallback, 'TestTwoFactorInfo', {
			'Code': sCode
		});
	};

	/**
  * @param {?Function} fCallback
  * @param {boolean} bEnable
  */


	RemoteUserAjax.prototype.enableTwoFactor = function enableTwoFactor(fCallback, bEnable) {
		this.defaultRequest(fCallback, 'EnableTwoFactor', {
			'Enable': bEnable ? '1' : '0'
		});
	};

	/**
  * @param {?Function} fCallback
  */


	RemoteUserAjax.prototype.clearTwoFactorInfo = function clearTwoFactorInfo(fCallback) {
		this.defaultRequest(fCallback, 'ClearTwoFactorInfo');
	};

	/**
  * @param {?Function} fCallback
  */


	RemoteUserAjax.prototype.contactsSync = function contactsSync(fCallback) {
		this.defaultRequest(fCallback, 'ContactsSync', null, __WEBPACK_IMPORTED_MODULE_5_Common_Consts__["d" /* CONTACTS_SYNC_AJAX_TIMEOUT */]);
	};

	/**
  * @param {?Function} fCallback
  * @param {boolean} bEnable
  * @param {string} sUrl
  * @param {string} sUser
  * @param {string} sPassword
  */


	RemoteUserAjax.prototype.saveContactsSyncData = function saveContactsSyncData(fCallback, bEnable, sUrl, sUser, sPassword) {
		this.defaultRequest(fCallback, 'SaveContactsSyncData', {
			'Enable': bEnable ? '1' : '0',
			'Url': sUrl,
			'User': sUser,
			'Password': sPassword
		});
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sEmail
  * @param {string} sPassword
  * @param {boolean=} bNew
  */


	RemoteUserAjax.prototype.accountSetup = function accountSetup(fCallback, sEmail, sPassword) {
		var bNew = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;

		this.defaultRequest(fCallback, 'AccountSetup', {
			'Email': sEmail,
			'Password': sPassword,
			'New': bNew ? '1' : '0'
		});
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sEmailToDelete
  */


	RemoteUserAjax.prototype.accountDelete = function accountDelete(fCallback, sEmailToDelete) {
		this.defaultRequest(fCallback, 'AccountDelete', {
			'EmailToDelete': sEmailToDelete
		});
	};

	/**
  * @param {?Function} fCallback
  * @param {Array} aAccounts
  * @param {Array} aIdentities
  */


	RemoteUserAjax.prototype.accountsAndIdentitiesSortOrder = function accountsAndIdentitiesSortOrder(fCallback, aAccounts, aIdentities) {
		this.defaultRequest(fCallback, 'AccountsAndIdentitiesSortOrder', {
			'Accounts': aAccounts,
			'Identities': aIdentities
		});
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sId
  * @param {string} sEmail
  * @param {string} sName
  * @param {string} sReplyTo
  * @param {string} sBcc
  * @param {string} sSignature
  * @param {boolean} bSignatureInsertBefore
  */


	RemoteUserAjax.prototype.identityUpdate = function identityUpdate(fCallback, sId, sEmail, sName, sReplyTo, sBcc, sSignature, bSignatureInsertBefore) {
		this.defaultRequest(fCallback, 'IdentityUpdate', {
			'Id': sId,
			'Email': sEmail,
			'Name': sName,
			'ReplyTo': sReplyTo,
			'Bcc': sBcc,
			'Signature': sSignature,
			'SignatureInsertBefore': bSignatureInsertBefore ? '1' : '0'
		});
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sIdToDelete
  */


	RemoteUserAjax.prototype.identityDelete = function identityDelete(fCallback, sIdToDelete) {
		this.defaultRequest(fCallback, 'IdentityDelete', {
			'IdToDelete': sIdToDelete
		});
	};

	/**
  * @param {?Function} fCallback
  */


	RemoteUserAjax.prototype.accountsAndIdentities = function accountsAndIdentities(fCallback) {
		this.defaultRequest(fCallback, 'AccountsAndIdentities');
	};

	/**
  * @param {?Function} fCallback
  */


	RemoteUserAjax.prototype.accountsCounts = function accountsCounts(fCallback) {
		this.defaultRequest(fCallback, 'AccountsCounts');
	};

	/**
  * @param {?Function} fCallback
  * @param {Array} filters
  * @param {string} raw
  * @param {boolean} isRawIsActive
  */


	RemoteUserAjax.prototype.filtersSave = function filtersSave(fCallback, filters, raw, isRawIsActive) {
		this.defaultRequest(fCallback, 'FiltersSave', {
			'Raw': raw,
			'RawIsActive': Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["boolToAjax"])(isRawIsActive),
			'Filters': __WEBPACK_IMPORTED_MODULE_3_____default.a.map(filters, function (item) {
				return item.toJson();
			})
		});
	};

	/**
  * @param {?Function} fCallback
  */


	RemoteUserAjax.prototype.filtersGet = function filtersGet(fCallback) {
		this.defaultRequest(fCallback, 'Filters', {});
	};

	/**
  * @param {?Function} fCallback
  */


	RemoteUserAjax.prototype.templates = function templates(fCallback) {
		this.defaultRequest(fCallback, 'Templates', {});
	};

	/**
  * @param {Function} fCallback
  * @param {string} sID
  */


	RemoteUserAjax.prototype.templateGetById = function templateGetById(fCallback, sID) {
		this.defaultRequest(fCallback, 'TemplateGetByID', {
			'ID': sID
		});
	};

	/**
  * @param {Function} fCallback
  * @param {string} sID
  */


	RemoteUserAjax.prototype.templateDelete = function templateDelete(fCallback, sID) {
		this.defaultRequest(fCallback, 'TemplateDelete', {
			'IdToDelete': sID
		});
	};

	/**
  * @param {Function} fCallback
  * @param {string} sID
  * @param {string} sName
  * @param {string} sBody
  */


	RemoteUserAjax.prototype.templateSetup = function templateSetup(fCallback, sID, sName, sBody) {
		this.defaultRequest(fCallback, 'TemplateSetup', {
			'ID': sID,
			'Name': sName,
			'Body': sBody
		});
	};

	/**
  * @param {Function} fCallback
  * @param {string} sFolderFullNameRaw
  * @param {number=} iOffset = 0
  * @param {number=} iLimit = 20
  * @param {string=} sSearch = ''
  * @param {string=} sThreadUid = ''
  * @param {boolean=} bSilent = false
  */


	RemoteUserAjax.prototype.messageList = function messageList(fCallback, sFolderFullNameRaw) {
		var iOffset = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
		var iLimit = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 20;
		var sSearch = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : '';
		var sThreadUid = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : '';
		var bSilent = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : false;


		sFolderFullNameRaw = Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["pString"])(sFolderFullNameRaw);

		var folderHash = Object(__WEBPACK_IMPORTED_MODULE_6_Common_Cache__["g" /* getFolderHash */])(sFolderFullNameRaw),
		    useThreads = __WEBPACK_IMPORTED_MODULE_10_Stores_User_App__["a" /* default */].threadsAllowed() && __WEBPACK_IMPORTED_MODULE_11_Stores_User_Settings__["a" /* default */].useThreads(),
		    inboxUidNext = Object(__WEBPACK_IMPORTED_MODULE_6_Common_Cache__["h" /* getFolderInboxName */])() === sFolderFullNameRaw ? Object(__WEBPACK_IMPORTED_MODULE_6_Common_Cache__["i" /* getFolderUidNext */])(sFolderFullNameRaw) : '';

		if ('' !== folderHash && ('' === sSearch || -1 === sSearch.indexOf('is:'))) {
			return this.defaultRequest(fCallback, 'MessageList', {}, '' === sSearch ? __WEBPACK_IMPORTED_MODULE_5_Common_Consts__["g" /* DEFAULT_AJAX_TIMEOUT */] : __WEBPACK_IMPORTED_MODULE_5_Common_Consts__["m" /* SEARCH_AJAX_TIMEOUT */], 'MessageList/' + Object(__WEBPACK_IMPORTED_MODULE_7_Common_Links__["E" /* subQueryPrefix */])() + '/' + __WEBPACK_IMPORTED_MODULE_8_Common_Base64__["a" /* urlsafe_encode */]([sFolderFullNameRaw, iOffset, iLimit, sSearch, __WEBPACK_IMPORTED_MODULE_10_Stores_User_App__["a" /* default */].projectHash(), folderHash, inboxUidNext, useThreads ? '1' : '0', useThreads ? sThreadUid : ''].join(String.fromCharCode(0))), bSilent ? [] : ['MessageList']);
		}

		return this.defaultRequest(fCallback, 'MessageList', {
			Folder: sFolderFullNameRaw,
			Offset: iOffset,
			Limit: iLimit,
			Search: sSearch,
			UidNext: inboxUidNext,
			UseThreads: useThreads ? '1' : '0',
			ThreadUid: useThreads ? sThreadUid : ''
		}, '' === sSearch ? __WEBPACK_IMPORTED_MODULE_5_Common_Consts__["g" /* DEFAULT_AJAX_TIMEOUT */] : __WEBPACK_IMPORTED_MODULE_5_Common_Consts__["m" /* SEARCH_AJAX_TIMEOUT */], '', bSilent ? [] : ['MessageList']);
	};

	/**
  * @param {?Function} fCallback
  * @param {Array} aDownloads
  */


	RemoteUserAjax.prototype.messageUploadAttachments = function messageUploadAttachments(fCallback, aDownloads) {
		this.defaultRequest(fCallback, 'MessageUploadAttachments', {
			'Attachments': aDownloads
		}, 999000);
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sFolderFullNameRaw
  * @param {number} iUid
  * @returns {boolean}
  */


	RemoteUserAjax.prototype.message = function message(fCallback, sFolderFullNameRaw, iUid) {

		sFolderFullNameRaw = Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["pString"])(sFolderFullNameRaw);
		iUid = Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["pInt"])(iUid);

		if (Object(__WEBPACK_IMPORTED_MODULE_6_Common_Cache__["e" /* getFolderFromCacheList */])(sFolderFullNameRaw) && 0 < iUid) {
			this.defaultRequest(fCallback, 'Message', {}, null, 'Message/' + Object(__WEBPACK_IMPORTED_MODULE_7_Common_Links__["E" /* subQueryPrefix */])() + '/' + __WEBPACK_IMPORTED_MODULE_8_Common_Base64__["a" /* urlsafe_encode */]([sFolderFullNameRaw, iUid, __WEBPACK_IMPORTED_MODULE_10_Stores_User_App__["a" /* default */].projectHash(), __WEBPACK_IMPORTED_MODULE_10_Stores_User_App__["a" /* default */].threadsAllowed() && __WEBPACK_IMPORTED_MODULE_11_Stores_User_Settings__["a" /* default */].useThreads() ? '1' : '0'].join(String.fromCharCode(0))), ['Message']);

			return true;
		}

		return false;
	};

	/**
  * @param {?Function} fCallback
  * @param {Array} aExternals
  */


	RemoteUserAjax.prototype.composeUploadExternals = function composeUploadExternals(fCallback, aExternals) {
		this.defaultRequest(fCallback, 'ComposeUploadExternals', {
			'Externals': aExternals
		}, 999000);
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sUrl
  * @param {string} sAccessToken
  */


	RemoteUserAjax.prototype.composeUploadDrive = function composeUploadDrive(fCallback, sUrl, sAccessToken) {
		this.defaultRequest(fCallback, 'ComposeUploadDrive', {
			'AccessToken': sAccessToken,
			'Url': sUrl
		}, 999000);
	};

	/**
  * @param {?Function} fCallback
  * @param {string} folder
  * @param {Array=} list = []
  */


	RemoteUserAjax.prototype.folderInformation = function folderInformation(fCallback, folder) {
		var list = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];


		var request = true;
		var uids = [];

		if (Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isArray"])(list) && 0 < list.length) {
			request = false;
			__WEBPACK_IMPORTED_MODULE_3_____default.a.each(list, function (messageListItem) {
				if (!Object(__WEBPACK_IMPORTED_MODULE_6_Common_Cache__["j" /* getMessageFlagsFromCache */])(messageListItem.folderFullNameRaw, messageListItem.uid)) {
					uids.push(messageListItem.uid);
				}

				if (0 < messageListItem.threads().length) {
					__WEBPACK_IMPORTED_MODULE_3_____default.a.each(messageListItem.threads(), function (uid) {
						if (!Object(__WEBPACK_IMPORTED_MODULE_6_Common_Cache__["j" /* getMessageFlagsFromCache */])(messageListItem.folderFullNameRaw, uid)) {
							uids.push(uid);
						}
					});
				}
			});

			if (0 < uids.length) {
				request = true;
			}
		}

		if (request) {
			this.defaultRequest(fCallback, 'FolderInformation', {
				'Folder': folder,
				'FlagsUids': Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isArray"])(uids) ? uids.join(',') : '',
				'UidNext': Object(__WEBPACK_IMPORTED_MODULE_6_Common_Cache__["h" /* getFolderInboxName */])() === folder ? Object(__WEBPACK_IMPORTED_MODULE_6_Common_Cache__["i" /* getFolderUidNext */])(folder) : ''
			});
		} else if (__WEBPACK_IMPORTED_MODULE_11_Stores_User_Settings__["a" /* default */].useThreads()) {
			Object(__WEBPACK_IMPORTED_MODULE_12_Helper_Apps_User__["a" /* getApp */])().reloadFlagsCurrentMessageListAndMessageFromCache();
		}
	};

	/**
  * @param {?Function} fCallback
  * @param {Array} aFolders
  */


	RemoteUserAjax.prototype.folderInformationMultiply = function folderInformationMultiply(fCallback, aFolders) {
		this.defaultRequest(fCallback, 'FolderInformationMultiply', {
			'Folders': aFolders
		});
	};

	/**
  * @param {?Function} fCallback
  */


	RemoteUserAjax.prototype.logout = function logout(fCallback) {
		this.defaultRequest(fCallback, 'Logout');
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sFolderFullNameRaw
  * @param {Array} aUids
  * @param {boolean} bSetFlagged
  */


	RemoteUserAjax.prototype.messageSetFlagged = function messageSetFlagged(fCallback, sFolderFullNameRaw, aUids, bSetFlagged) {
		this.defaultRequest(fCallback, 'MessageSetFlagged', {
			'Folder': sFolderFullNameRaw,
			'Uids': aUids.join(','),
			'SetAction': bSetFlagged ? '1' : '0'
		});
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sFolderFullNameRaw
  * @param {Array} aUids
  * @param {boolean} bSetSeen
  */


	RemoteUserAjax.prototype.messageSetSeen = function messageSetSeen(fCallback, sFolderFullNameRaw, aUids, bSetSeen) {
		this.defaultRequest(fCallback, 'MessageSetSeen', {
			'Folder': sFolderFullNameRaw,
			'Uids': aUids.join(','),
			'SetAction': bSetSeen ? '1' : '0'
		});
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sFolderFullNameRaw
  * @param {boolean} bSetSeen
  * @param {Array} aThreadUids = null
  */


	RemoteUserAjax.prototype.messageSetSeenToAll = function messageSetSeenToAll(fCallback, sFolderFullNameRaw, bSetSeen) {
		var aThreadUids = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;

		this.defaultRequest(fCallback, 'MessageSetSeenToAll', {
			'Folder': sFolderFullNameRaw,
			'SetAction': bSetSeen ? '1' : '0',
			'ThreadUids': aThreadUids ? aThreadUids.join(',') : ''
		});
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sIdentityID
  * @param {string} sMessageFolder
  * @param {string} sMessageUid
  * @param {string} sDraftFolder
  * @param {string} sTo
  * @param {string} sCc
  * @param {string} sBcc
  * @param {string} sReplyTo
  * @param {string} sSubject
  * @param {boolean} bTextIsHtml
  * @param {string} sText
  * @param {Array} aAttachments
  * @param {(Array|null)} aDraftInfo
  * @param {string} sInReplyTo
  * @param {string} sReferences
  * @param {boolean} bMarkAsImportant
  */


	RemoteUserAjax.prototype.saveMessage = function saveMessage(fCallback, sIdentityID, sMessageFolder, sMessageUid, sDraftFolder, sTo, sCc, sBcc, sReplyTo, sSubject, bTextIsHtml, sText, aAttachments, aDraftInfo, sInReplyTo, sReferences, bMarkAsImportant) {

		this.defaultRequest(fCallback, 'SaveMessage', {
			'IdentityID': sIdentityID,
			'MessageFolder': sMessageFolder,
			'MessageUid': sMessageUid,
			'DraftFolder': sDraftFolder,
			'To': sTo,
			'Cc': sCc,
			'Bcc': sBcc,
			'ReplyTo': sReplyTo,
			'Subject': sSubject,
			'TextIsHtml': bTextIsHtml ? '1' : '0',
			'Text': sText,
			'DraftInfo': aDraftInfo,
			'InReplyTo': sInReplyTo,
			'References': sReferences,
			'MarkAsImportant': bMarkAsImportant ? '1' : '0',
			'Attachments': aAttachments
		}, __WEBPACK_IMPORTED_MODULE_5_Common_Consts__["l" /* SAVE_MESSAGE_AJAX_TIMEOUT */]);
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sMessageFolder
  * @param {string} sMessageUid
  * @param {string} sReadReceipt
  * @param {string} sSubject
  * @param {string} sText
  */


	RemoteUserAjax.prototype.sendReadReceiptMessage = function sendReadReceiptMessage(fCallback, sMessageFolder, sMessageUid, sReadReceipt, sSubject, sText) {
		this.defaultRequest(fCallback, 'SendReadReceiptMessage', {
			'MessageFolder': sMessageFolder,
			'MessageUid': sMessageUid,
			'ReadReceipt': sReadReceipt,
			'Subject': sSubject,
			'Text': sText
		});
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sIdentityID
  * @param {string} sMessageFolder
  * @param {string} sMessageUid
  * @param {string} sSentFolder
  * @param {string} sTo
  * @param {string} sCc
  * @param {string} sBcc
  * @param {string} sReplyTo
  * @param {string} sSubject
  * @param {boolean} bTextIsHtml
  * @param {string} sText
  * @param {Array} aAttachments
  * @param {(Array|null)} aDraftInfo
  * @param {string} sInReplyTo
  * @param {string} sReferences
  * @param {boolean} bRequestDsn
  * @param {boolean} bRequestReadReceipt
  * @param {boolean} bMarkAsImportant
  */


	RemoteUserAjax.prototype.sendMessage = function sendMessage(fCallback, sIdentityID, sMessageFolder, sMessageUid, sSentFolder, sTo, sCc, sBcc, sReplyTo, sSubject, bTextIsHtml, sText, aAttachments, aDraftInfo, sInReplyTo, sReferences, bRequestDsn, bRequestReadReceipt, bMarkAsImportant) {

		this.defaultRequest(fCallback, 'SendMessage', {
			'IdentityID': sIdentityID,
			'MessageFolder': sMessageFolder,
			'MessageUid': sMessageUid,
			'SentFolder': sSentFolder,
			'To': sTo,
			'Cc': sCc,
			'Bcc': sBcc,
			'ReplyTo': sReplyTo,
			'Subject': sSubject,
			'TextIsHtml': bTextIsHtml ? '1' : '0',
			'Text': sText,
			'DraftInfo': aDraftInfo,
			'InReplyTo': sInReplyTo,
			'References': sReferences,
			'Dsn': bRequestDsn ? '1' : '0',
			'ReadReceiptRequest': bRequestReadReceipt ? '1' : '0',
			'MarkAsImportant': bMarkAsImportant ? '1' : '0',
			'Attachments': aAttachments
		}, __WEBPACK_IMPORTED_MODULE_5_Common_Consts__["n" /* SEND_MESSAGE_AJAX_TIMEOUT */]);
	};

	/**
  * @param {?Function} fCallback
  * @param {Object} oData
  */


	RemoteUserAjax.prototype.saveSystemFolders = function saveSystemFolders(fCallback, oData) {
		this.defaultRequest(fCallback, 'SystemFoldersUpdate', oData);
	};

	/**
  * @param {?Function} fCallback
  * @param {Object} oData
  */


	RemoteUserAjax.prototype.saveSettings = function saveSettings(fCallback, oData) {
		this.defaultRequest(fCallback, 'SettingsUpdate', oData);
	};

	/**
  * @param {string} key
  * @param {?Function} valueFn
  * @param {?Function} fn
  */


	RemoteUserAjax.prototype.saveSettingsHelper = function saveSettingsHelper(key, valueFn, fn) {
		var _this2 = this;

		return function (value) {
			var _this2$saveSettings;

			_this2.saveSettings(fn || null, (_this2$saveSettings = {}, _this2$saveSettings[key] = valueFn ? valueFn(value) : value, _this2$saveSettings));
		};
	};

	/**
  * @param {?Function} fCallback
  * @param {string} prevPassword
  * @param {string} newPassword
  */


	RemoteUserAjax.prototype.changePassword = function changePassword(fCallback, prevPassword, newPassword) {
		this.defaultRequest(fCallback, 'ChangePassword', {
			'PrevPassword': prevPassword,
			'NewPassword': newPassword
		});
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sFolderFullNameRaw
  */


	RemoteUserAjax.prototype.folderClear = function folderClear(fCallback, sFolderFullNameRaw) {
		this.defaultRequest(fCallback, 'FolderClear', {
			'Folder': sFolderFullNameRaw
		});
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sFolderFullNameRaw
  * @param {boolean} bSubscribe
  */


	RemoteUserAjax.prototype.folderSetSubscribe = function folderSetSubscribe(fCallback, sFolderFullNameRaw, bSubscribe) {
		this.defaultRequest(fCallback, 'FolderSubscribe', {
			'Folder': sFolderFullNameRaw,
			'Subscribe': bSubscribe ? '1' : '0'
		});
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sFolderFullNameRaw
  * @param {boolean} bCheckable
  */


	RemoteUserAjax.prototype.folderSetCheckable = function folderSetCheckable(fCallback, sFolderFullNameRaw, bCheckable) {
		this.defaultRequest(fCallback, 'FolderCheckable', {
			'Folder': sFolderFullNameRaw,
			'Checkable': bCheckable ? '1' : '0'
		});
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sFolder
  * @param {string} sToFolder
  * @param {Array} aUids
  * @param {string=} sLearning
  * @param {boolean=} bMarkAsRead
  */


	RemoteUserAjax.prototype.messagesMove = function messagesMove(fCallback, sFolder, sToFolder, aUids, sLearning, bMarkAsRead) {
		this.defaultRequest(fCallback, 'MessageMove', {
			'FromFolder': sFolder,
			'ToFolder': sToFolder,
			'Uids': aUids.join(','),
			'MarkAsRead': bMarkAsRead ? '1' : '0',
			'Learning': sLearning || ''
		}, null, '', ['MessageList']);
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sFolder
  * @param {string} sToFolder
  * @param {Array} aUids
  */


	RemoteUserAjax.prototype.messagesCopy = function messagesCopy(fCallback, sFolder, sToFolder, aUids) {
		this.defaultRequest(fCallback, 'MessageCopy', {
			'FromFolder': sFolder,
			'ToFolder': sToFolder,
			'Uids': aUids.join(',')
		});
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sFolder
  * @param {Array} aUids
  */


	RemoteUserAjax.prototype.messagesDelete = function messagesDelete(fCallback, sFolder, aUids) {
		this.defaultRequest(fCallback, 'MessageDelete', {
			'Folder': sFolder,
			'Uids': aUids.join(',')
		}, null, '', ['MessageList']);
	};

	/**
  * @param {?Function} fCallback
  */


	RemoteUserAjax.prototype.appDelayStart = function appDelayStart(fCallback) {
		this.defaultRequest(fCallback, 'AppDelayStart');
	};

	/**
  * @param {?Function} fCallback
  */


	RemoteUserAjax.prototype.quota = function quota(fCallback) {
		this.defaultRequest(fCallback, 'Quota');
	};

	/**
  * @param {?Function} fCallback
  * @param {number} iOffset
  * @param {number} iLimit
  * @param {string} sSearch
  */


	RemoteUserAjax.prototype.contacts = function contacts(fCallback, iOffset, iLimit, sSearch) {
		this.defaultRequest(fCallback, 'Contacts', {
			'Offset': iOffset,
			'Limit': iLimit,
			'Search': sSearch
		}, null, '', ['Contacts']);
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sRequestUid
  * @param {string} sUid
  * @param {Array} aProperties
  */


	RemoteUserAjax.prototype.contactSave = function contactSave(fCallback, sRequestUid, sUid, aProperties) {
		this.defaultRequest(fCallback, 'ContactSave', {
			'RequestUid': sRequestUid,
			'Uid': Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["trim"])(sUid),
			'Properties': aProperties
		});
	};

	/**
  * @param {?Function} fCallback
  * @param {Array} aUids
  */


	RemoteUserAjax.prototype.contactsDelete = function contactsDelete(fCallback, aUids) {
		this.defaultRequest(fCallback, 'ContactsDelete', {
			'Uids': aUids.join(',')
		});
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sQuery
  * @param {number} iPage
  */


	RemoteUserAjax.prototype.suggestions = function suggestions(fCallback, sQuery, iPage) {
		this.defaultRequest(fCallback, 'Suggestions', {
			'Query': sQuery,
			'Page': iPage
		}, null, '', ['Suggestions']);
	};

	/**
  * @param {?Function} fCallback
  */


	RemoteUserAjax.prototype.clearUserBackground = function clearUserBackground(fCallback) {
		this.defaultRequest(fCallback, 'ClearUserBackground');
	};

	/**
  * @param {?Function} fCallback
  */


	RemoteUserAjax.prototype.facebookUser = function facebookUser(fCallback) {
		this.defaultRequest(fCallback, 'SocialFacebookUserInformation');
	};

	/**
  * @param {?Function} fCallback
  */


	RemoteUserAjax.prototype.facebookDisconnect = function facebookDisconnect(fCallback) {
		this.defaultRequest(fCallback, 'SocialFacebookDisconnect');
	};

	/**
  * @param {?Function} fCallback
  */


	RemoteUserAjax.prototype.twitterUser = function twitterUser(fCallback) {
		this.defaultRequest(fCallback, 'SocialTwitterUserInformation');
	};

	/**
  * @param {?Function} fCallback
  */


	RemoteUserAjax.prototype.twitterDisconnect = function twitterDisconnect(fCallback) {
		this.defaultRequest(fCallback, 'SocialTwitterDisconnect');
	};

	/**
  * @param {?Function} fCallback
  */


	RemoteUserAjax.prototype.googleUser = function googleUser(fCallback) {
		this.defaultRequest(fCallback, 'SocialGoogleUserInformation');
	};

	/**
  * @param {?Function} fCallback
  */


	RemoteUserAjax.prototype.googleDisconnect = function googleDisconnect(fCallback) {
		this.defaultRequest(fCallback, 'SocialGoogleDisconnect');
	};

	/**
  * @param {?Function} fCallback
  */


	RemoteUserAjax.prototype.socialUsers = function socialUsers(fCallback) {
		this.defaultRequest(fCallback, 'SocialUsers');
	};

	return RemoteUserAjax;
}(__WEBPACK_IMPORTED_MODULE_13_Remote_AbstractAjax__["a" /* AbstractAjaxRemote */]);

/* harmony default export */ __webpack_exports__["a"] = (new RemoteUserAjax());

/***/ }),
/* 18 */
/*!***********************************!*\
  !*** ./dev/Component/Abstract.js ***!
  \***********************************/
/*! exports provided: AbstractComponent, componentExportHelper */
/*! exports used: AbstractComponent, componentExportHelper */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AbstractComponent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return componentExportHelper; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! $ */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 8);








var AbstractComponent = function () {
	function AbstractComponent() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, AbstractComponent);

		this.disposable = [];
	}

	AbstractComponent.prototype.dispose = function dispose() {
		this.disposable.forEach(function (funcToDispose) {
			if (funcToDispose && funcToDispose.dispose) {
				funcToDispose.dispose();
			}
		});
	};

	return AbstractComponent;
}();

/**
 * @param {*} ClassObject
 * @param {string} templateID = ''
 * @returns {Object}
 */


var componentExportHelper = function componentExportHelper(ClassObject) {
	var templateID = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
	return {
		template: templateID ? { element: templateID } : '<b></b>',
		viewModel: {
			createViewModel: function createViewModel(params, componentInfo) {

				params = params || {};
				params.element = null;

				if (componentInfo && componentInfo.element) {
					params.component = componentInfo;
					params.element = __WEBPACK_IMPORTED_MODULE_1_____default()(componentInfo.element);

					Object(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18nToNodes"])(params.element);

					if (!Object(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["isUnd"])(params.inline) && __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].unwrap(params.inline)) {
						params.element.css('display', 'inline-block');
					}
				}

				return new ClassObject(params);
			}
		}
	};
};



/***/ }),
/* 19 */
/*!*****************************!*\
  !*** external "window.key" ***!
  \*****************************/
/*! no static exports found */
/*! exports used: default */
/***/ (function(module, exports) {

module.exports = window.key;

/***/ }),
/* 20 */
/*!******************************!*\
  !*** ./dev/Common/Consts.js ***!
  \******************************/
/*! exports provided: MESSAGES_PER_PAGE, MESSAGES_PER_PAGE_VALUES, CONTACTS_PER_PAGE, DEFAULT_AJAX_TIMEOUT, SEARCH_AJAX_TIMEOUT, SEND_MESSAGE_AJAX_TIMEOUT, SAVE_MESSAGE_AJAX_TIMEOUT, CONTACTS_SYNC_AJAX_TIMEOUT, UNUSED_OPTION_VALUE, CLIENT_SIDE_STORAGE_INDEX_NAME, IMAP_DEFAULT_PORT, IMAP_DEFAULT_SECURE_PORT, SMTP_DEFAULT_PORT, SMTP_DEFAULT_SECURE_PORT, SIEVE_DEFAULT_PORT, MESSAGE_BODY_CACHE_LIMIT, AJAX_ERROR_LIMIT, TOKEN_ERROR_LIMIT, RAINLOOP_TRIAL_KEY, DATA_IMAGE_USER_DOT_PIC, DATA_IMAGE_TRANSP_PIC, DATA_IMAGE_LAZY_PLACEHOLDER_PIC */
/*! exports used: AJAX_ERROR_LIMIT, CLIENT_SIDE_STORAGE_INDEX_NAME, CONTACTS_PER_PAGE, CONTACTS_SYNC_AJAX_TIMEOUT, DATA_IMAGE_LAZY_PLACEHOLDER_PIC, DATA_IMAGE_USER_DOT_PIC, DEFAULT_AJAX_TIMEOUT, IMAP_DEFAULT_PORT, MESSAGES_PER_PAGE, MESSAGES_PER_PAGE_VALUES, MESSAGE_BODY_CACHE_LIMIT, SAVE_MESSAGE_AJAX_TIMEOUT, SEARCH_AJAX_TIMEOUT, SEND_MESSAGE_AJAX_TIMEOUT, SIEVE_DEFAULT_PORT, SMTP_DEFAULT_PORT, TOKEN_ERROR_LIMIT, UNUSED_OPTION_VALUE */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "i", function() { return MESSAGES_PER_PAGE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "j", function() { return MESSAGES_PER_PAGE_VALUES; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return CONTACTS_PER_PAGE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return DEFAULT_AJAX_TIMEOUT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "m", function() { return SEARCH_AJAX_TIMEOUT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "n", function() { return SEND_MESSAGE_AJAX_TIMEOUT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "l", function() { return SAVE_MESSAGE_AJAX_TIMEOUT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return CONTACTS_SYNC_AJAX_TIMEOUT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "r", function() { return UNUSED_OPTION_VALUE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return CLIENT_SIDE_STORAGE_INDEX_NAME; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return IMAP_DEFAULT_PORT; });
/* unused harmony export IMAP_DEFAULT_SECURE_PORT */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "p", function() { return SMTP_DEFAULT_PORT; });
/* unused harmony export SMTP_DEFAULT_SECURE_PORT */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "o", function() { return SIEVE_DEFAULT_PORT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "k", function() { return MESSAGE_BODY_CACHE_LIMIT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AJAX_ERROR_LIMIT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "q", function() { return TOKEN_ERROR_LIMIT; });
/* unused harmony export RAINLOOP_TRIAL_KEY */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return DATA_IMAGE_USER_DOT_PIC; });
/* unused harmony export DATA_IMAGE_TRANSP_PIC */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return DATA_IMAGE_LAZY_PLACEHOLDER_PIC; });

var MESSAGES_PER_PAGE = 20;

var MESSAGES_PER_PAGE_VALUES = [10, 20, 30, 50, 100];

var CONTACTS_PER_PAGE = 50;

var DEFAULT_AJAX_TIMEOUT = 30000;

var SEARCH_AJAX_TIMEOUT = 300000;

var SEND_MESSAGE_AJAX_TIMEOUT = 300000;

var SAVE_MESSAGE_AJAX_TIMEOUT = 200000;

var CONTACTS_SYNC_AJAX_TIMEOUT = 200000;

var UNUSED_OPTION_VALUE = '__UNUSE__';

var CLIENT_SIDE_STORAGE_INDEX_NAME = 'rlcsc';

var IMAP_DEFAULT_PORT = 143;

var IMAP_DEFAULT_SECURE_PORT = 993;

var SMTP_DEFAULT_PORT = 25;

var SMTP_DEFAULT_SECURE_PORT = 465;

var SIEVE_DEFAULT_PORT = 4190;

var MESSAGE_BODY_CACHE_LIMIT = 15;

var AJAX_ERROR_LIMIT = 7;

var TOKEN_ERROR_LIMIT = 10;

var RAINLOOP_TRIAL_KEY = 'RAINLOOP-TRIAL-KEY';

/* eslint max-len: 0 */
var DATA_IMAGE_USER_DOT_PIC = 'data:image/png;base64,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';

var DATA_IMAGE_TRANSP_PIC = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQIW2NkAAIAAAoAAggA9GkAAAAASUVORK5CYII=';

var DATA_IMAGE_LAZY_PLACEHOLDER_PIC = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsQAAA7EAZUrDhsAAAANSURBVBhXYzh8+PB/AAffA0nNPuCLAAAAAElFTkSuQmCC';

/***/ }),
/* 21 */
/*!*********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_global.js ***!
  \*********************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
var global = module.exports = typeof window != 'undefined' && window.Math == Math
  ? window : typeof self != 'undefined' && self.Math == Math ? self
  // eslint-disable-next-line no-new-func
  : Function('return this')();
if (typeof __g == 'number') __g = global; // eslint-disable-line no-undef


/***/ }),
/* 22 */
/*!*******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_core.js ***!
  \*******************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

var core = module.exports = { version: '2.5.1' };
if (typeof __e == 'number') __e = core; // eslint-disable-line no-undef


/***/ }),
/* 23 */
/*!**************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_descriptors.js ***!
  \**************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

// Thank's IE8 for his funny defineProperty
module.exports = !__webpack_require__(/*! ./_fails */ 30)(function () {
  return Object.defineProperty({}, 'a', { get: function () { return 7; } }).a != 7;
});


/***/ }),
/* 24 */
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_to-iobject.js ***!
  \*************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

// to indexed object, toObject with fallback for non-array-like ES3 strings
var IObject = __webpack_require__(/*! ./_iobject */ 81);
var defined = __webpack_require__(/*! ./_defined */ 49);
module.exports = function (it) {
  return IObject(defined(it));
};


/***/ }),
/* 25 */
/*!******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_has.js ***!
  \******************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

var hasOwnProperty = {}.hasOwnProperty;
module.exports = function (it, key) {
  return hasOwnProperty.call(it, key);
};


/***/ }),
/* 26 */
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-dp.js ***!
  \************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

var anObject = __webpack_require__(/*! ./_an-object */ 35);
var IE8_DOM_DEFINE = __webpack_require__(/*! ./_ie8-dom-define */ 55);
var toPrimitive = __webpack_require__(/*! ./_to-primitive */ 46);
var dP = Object.defineProperty;

exports.f = __webpack_require__(/*! ./_descriptors */ 23) ? Object.defineProperty : function defineProperty(O, P, Attributes) {
  anObject(O);
  P = toPrimitive(P, true);
  anObject(Attributes);
  if (IE8_DOM_DEFINE) try {
    return dP(O, P, Attributes);
  } catch (e) { /* empty */ }
  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported!');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};


/***/ }),
/* 27 */
/*!*****************************!*\
  !*** ./dev/Common/Cache.js ***!
  \*****************************/
/*! exports provided: clear, getUserPic, getMessageKey, addRequestedMessage, hasRequestedMessage, addNewMessageCache, hasNewMessageAndRemoveFromCache, clearNewMessageCache, getFolderInboxName, getFolderFullNameRaw, setFolderFullNameRaw, getFolderHash, setFolderHash, getFolderUidNext, setFolderUidNext, getFolderFromCacheList, setFolderToCacheList, removeFolderFromCacheList, getMessageFlagsFromCache, setMessageFlagsToCache, clearMessageFlagsFromCacheByFolder, initMessageFlagsFromCache, storeMessageFlagsToCache, storeMessageFlagsToCacheByFolderAndUid, storeMessageFlagsToCacheBySetAction */
/*! exports used: addNewMessageCache, addRequestedMessage, clearMessageFlagsFromCacheByFolder, clearNewMessageCache, getFolderFromCacheList, getFolderFullNameRaw, getFolderHash, getFolderInboxName, getFolderUidNext, getMessageFlagsFromCache, getUserPic, hasNewMessageAndRemoveFromCache, hasRequestedMessage, initMessageFlagsFromCache, removeFolderFromCacheList, setFolderFullNameRaw, setFolderHash, setFolderToCacheList, setFolderUidNext, setMessageFlagsToCache, storeMessageFlagsToCache, storeMessageFlagsToCacheByFolderAndUid, storeMessageFlagsToCacheBySetAction */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export clear */
/* harmony export (immutable) */ __webpack_exports__["k"] = getUserPic;
/* unused harmony export getMessageKey */
/* harmony export (immutable) */ __webpack_exports__["b"] = addRequestedMessage;
/* harmony export (immutable) */ __webpack_exports__["m"] = hasRequestedMessage;
/* harmony export (immutable) */ __webpack_exports__["a"] = addNewMessageCache;
/* harmony export (immutable) */ __webpack_exports__["l"] = hasNewMessageAndRemoveFromCache;
/* harmony export (immutable) */ __webpack_exports__["d"] = clearNewMessageCache;
/* harmony export (immutable) */ __webpack_exports__["h"] = getFolderInboxName;
/* harmony export (immutable) */ __webpack_exports__["f"] = getFolderFullNameRaw;
/* harmony export (immutable) */ __webpack_exports__["p"] = setFolderFullNameRaw;
/* harmony export (immutable) */ __webpack_exports__["g"] = getFolderHash;
/* harmony export (immutable) */ __webpack_exports__["q"] = setFolderHash;
/* harmony export (immutable) */ __webpack_exports__["i"] = getFolderUidNext;
/* harmony export (immutable) */ __webpack_exports__["s"] = setFolderUidNext;
/* harmony export (immutable) */ __webpack_exports__["e"] = getFolderFromCacheList;
/* harmony export (immutable) */ __webpack_exports__["r"] = setFolderToCacheList;
/* harmony export (immutable) */ __webpack_exports__["o"] = removeFolderFromCacheList;
/* harmony export (immutable) */ __webpack_exports__["j"] = getMessageFlagsFromCache;
/* harmony export (immutable) */ __webpack_exports__["t"] = setMessageFlagsToCache;
/* harmony export (immutable) */ __webpack_exports__["c"] = clearMessageFlagsFromCacheByFolder;
/* harmony export (immutable) */ __webpack_exports__["n"] = initMessageFlagsFromCache;
/* harmony export (immutable) */ __webpack_exports__["u"] = storeMessageFlagsToCache;
/* harmony export (immutable) */ __webpack_exports__["v"] = storeMessageFlagsToCacheByFolderAndUid;
/* harmony export (immutable) */ __webpack_exports__["w"] = storeMessageFlagsToCacheBySetAction;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Links__ = __webpack_require__(/*! Common/Links */ 14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);







var FOLDERS_CACHE = {},
    FOLDERS_NAME_CACHE = {},
    FOLDERS_HASH_CACHE = {},
    FOLDERS_UID_NEXT_CACHE = {},
    MESSAGE_FLAGS_CACHE = {},
    NEW_MESSAGE_CACHE = {},
    inboxFolderName = '';

var REQUESTED_MESSAGE_CACHE = {},
    capaGravatar = __WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["capa"](__WEBPACK_IMPORTED_MODULE_1_Common_Enums__["Capa"].Gravatar);

/**
 * @returns {void}
 */
function clear() {
	FOLDERS_CACHE = {};
	FOLDERS_NAME_CACHE = {};
	FOLDERS_HASH_CACHE = {};
	FOLDERS_UID_NEXT_CACHE = {};
	MESSAGE_FLAGS_CACHE = {};
}

/**
 * @param {string} email
 * @param {Function} callback
 * @returns {string}
 */
function getUserPic(email, callback) {
	email = Object(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["trim"])(email);
	callback(capaGravatar && '' !== email ? __WEBPACK_IMPORTED_MODULE_3_Common_Links__["h" /* avatarLink */](email) : '', email);
}

/**
 * @param {string} folderFullNameRaw
 * @param {string} uid
 * @returns {string}
 */
function getMessageKey(folderFullNameRaw, uid) {
	return folderFullNameRaw + '#' + uid;
}

/**
 * @param {string} folder
 * @param {string} uid
 */
function addRequestedMessage(folder, uid) {
	REQUESTED_MESSAGE_CACHE[getMessageKey(folder, uid)] = true;
}

/**
 * @param {string} folder
 * @param {string} uid
 * @returns {boolean}
 */
function hasRequestedMessage(folder, uid) {
	return true === REQUESTED_MESSAGE_CACHE[getMessageKey(folder, uid)];
}

/**
 * @param {string} folderFullNameRaw
 * @param {string} uid
 */
function addNewMessageCache(folderFullNameRaw, uid) {
	NEW_MESSAGE_CACHE[getMessageKey(folderFullNameRaw, uid)] = true;
}

/**
 * @param {string} folderFullNameRaw
 * @param {string} uid
 */
function hasNewMessageAndRemoveFromCache(folderFullNameRaw, uid) {
	if (NEW_MESSAGE_CACHE[getMessageKey(folderFullNameRaw, uid)]) {
		NEW_MESSAGE_CACHE[getMessageKey(folderFullNameRaw, uid)] = null;
		return true;
	}
	return false;
}

/**
 * @returns {void}
 */
function clearNewMessageCache() {
	NEW_MESSAGE_CACHE = {};
}

/**
 * @returns {string}
 */
function getFolderInboxName() {
	return '' === inboxFolderName ? 'INBOX' : inboxFolderName;
}

/**
 * @param {string} folderHash
 * @returns {string}
 */
function getFolderFullNameRaw(folderHash) {
	return '' !== folderHash && FOLDERS_NAME_CACHE[folderHash] ? FOLDERS_NAME_CACHE[folderHash] : '';
}

/**
 * @param {string} folderHash
 * @param {string} folderFullNameRaw
 */
function setFolderFullNameRaw(folderHash, folderFullNameRaw) {
	FOLDERS_NAME_CACHE[folderHash] = folderFullNameRaw;
	if ('INBOX' === folderFullNameRaw || '' === inboxFolderName) {
		inboxFolderName = folderFullNameRaw;
	}
}

/**
 * @param {string} folderFullNameRaw
 * @returns {string}
 */
function getFolderHash(folderFullNameRaw) {
	return '' !== folderFullNameRaw && FOLDERS_HASH_CACHE[folderFullNameRaw] ? FOLDERS_HASH_CACHE[folderFullNameRaw] : '';
}

/**
 * @param {string} folderFullNameRaw
 * @param {string} folderHash
 */
function setFolderHash(folderFullNameRaw, folderHash) {
	if ('' !== folderFullNameRaw) {
		FOLDERS_HASH_CACHE[folderFullNameRaw] = folderHash;
	}
}

/**
 * @param {string} folderFullNameRaw
 * @returns {string}
 */
function getFolderUidNext(folderFullNameRaw) {
	return '' !== folderFullNameRaw && FOLDERS_UID_NEXT_CACHE[folderFullNameRaw] ? FOLDERS_UID_NEXT_CACHE[folderFullNameRaw] : '';
}

/**
 * @param {string} folderFullNameRaw
 * @param {string} uidNext
 */
function setFolderUidNext(folderFullNameRaw, uidNext) {
	FOLDERS_UID_NEXT_CACHE[folderFullNameRaw] = uidNext;
}

/**
 * @param {string} folderFullNameRaw
 * @returns {?FolderModel}
 */
function getFolderFromCacheList(folderFullNameRaw) {
	return '' !== folderFullNameRaw && FOLDERS_CACHE[folderFullNameRaw] ? FOLDERS_CACHE[folderFullNameRaw] : null;
}

/**
 * @param {string} folderFullNameRaw
 * @param {?FolderModel} folder
 */
function setFolderToCacheList(folderFullNameRaw, folder) {
	FOLDERS_CACHE[folderFullNameRaw] = folder;
}

/**
 * @param {string} folderFullNameRaw
 */
function removeFolderFromCacheList(folderFullNameRaw) {
	setFolderToCacheList(folderFullNameRaw, null);
}

/**
 * @param {string} folderFullName
 * @param {string} uid
 * @returns {?Array}
 */
function getMessageFlagsFromCache(folderFullName, uid) {
	return MESSAGE_FLAGS_CACHE[folderFullName] && MESSAGE_FLAGS_CACHE[folderFullName][uid] ? MESSAGE_FLAGS_CACHE[folderFullName][uid] : null;
}

/**
 * @param {string} folderFullName
 * @param {string} uid
 * @param {Array} flagsCache
 */
function setMessageFlagsToCache(folderFullName, uid, flagsCache) {
	if (!MESSAGE_FLAGS_CACHE[folderFullName]) {
		MESSAGE_FLAGS_CACHE[folderFullName] = {};
	}

	MESSAGE_FLAGS_CACHE[folderFullName][uid] = flagsCache;
}

/**
 * @param {string} folderFullName
 */
function clearMessageFlagsFromCacheByFolder(folderFullName) {
	MESSAGE_FLAGS_CACHE[folderFullName] = {};
}

/**
 * @param {(MessageModel|null)} message
 */
function initMessageFlagsFromCache(message) {

	if (message) {
		var uid = message.uid,
		    flags = getMessageFlagsFromCache(message.folderFullNameRaw, uid);

		if (flags && 0 < flags.length) {
			message.flagged(!!flags[1]);

			if (!message.isSimpleMessage) {
				message.unseen(!!flags[0]);
				message.answered(!!flags[2]);
				message.forwarded(!!flags[3]);
				message.isReadReceipt(!!flags[4]);
				message.deletedMark(!!flags[5]);
			}
		}

		if (0 < message.threads().length) {
			var unseenSubUid = __WEBPACK_IMPORTED_MODULE_0_____default.a.find(message.threads(), function (sSubUid) {
				if (uid !== sSubUid) {
					var subFlags = getMessageFlagsFromCache(message.folderFullNameRaw, sSubUid);
					return subFlags && 0 < subFlags.length && !!subFlags[0];
				}
				return false;
			});

			var flaggedSubUid = __WEBPACK_IMPORTED_MODULE_0_____default.a.find(message.threads(), function (sSubUid) {
				if (uid !== sSubUid) {
					var subFlags = getMessageFlagsFromCache(message.folderFullNameRaw, sSubUid);
					return subFlags && 0 < subFlags.length && !!subFlags[1];
				}
				return false;
			});

			message.hasUnseenSubMessage(unseenSubUid && 0 < Object(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["pInt"])(unseenSubUid));
			message.hasFlaggedSubMessage(flaggedSubUid && 0 < Object(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["pInt"])(flaggedSubUid));
		}
	}
}

/**
 * @param {(MessageModel|null)} message
 */
function storeMessageFlagsToCache(message) {
	if (message) {
		setMessageFlagsToCache(message.folderFullNameRaw, message.uid, [message.unseen(), message.flagged(), message.answered(), message.forwarded(), message.isReadReceipt(), message.deletedMark()]);
	}
}

/**
 * @param {string} folder
 * @param {string} uid
 * @param {Array} flags
 */
function storeMessageFlagsToCacheByFolderAndUid(folder, uid, flags) {
	if (Object(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["isArray"])(flags) && 0 < flags.length) {
		setMessageFlagsToCache(folder, uid, flags);
	}
}

/**
 * @param {string} folder
 * @param {string} uid
 * @param {number} setAction
 */
function storeMessageFlagsToCacheBySetAction(folder, uid, setAction) {

	var unread = 0;
	var flags = getMessageFlagsFromCache(folder, uid);

	if (Object(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["isArray"])(flags) && 0 < flags.length) {
		if (flags[0]) {
			unread = 1;
		}

		switch (setAction) {
			case __WEBPACK_IMPORTED_MODULE_1_Common_Enums__["MessageSetAction"].SetSeen:
				flags[0] = false;
				break;
			case __WEBPACK_IMPORTED_MODULE_1_Common_Enums__["MessageSetAction"].UnsetSeen:
				flags[0] = true;
				break;
			case __WEBPACK_IMPORTED_MODULE_1_Common_Enums__["MessageSetAction"].SetFlag:
				flags[1] = true;
				break;
			case __WEBPACK_IMPORTED_MODULE_1_Common_Enums__["MessageSetAction"].UnsetFlag:
				flags[1] = false;
				break;
			// no default
		}

		setMessageFlagsToCache(folder, uid, flags);
	}

	return unread;
}

/***/ }),
/* 28 */
/*!*******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_hide.js ***!
  \*******************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

var dP = __webpack_require__(/*! ./_object-dp */ 26);
var createDesc = __webpack_require__(/*! ./_property-desc */ 39);
module.exports = __webpack_require__(/*! ./_descriptors */ 23) ? function (object, key, value) {
  return dP.f(object, key, createDesc(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};


/***/ }),
/* 29 */
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_is-object.js ***!
  \************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

module.exports = function (it) {
  return typeof it === 'object' ? it !== null : typeof it === 'function';
};


/***/ }),
/* 30 */
/*!********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_fails.js ***!
  \********************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

module.exports = function (exec) {
  try {
    return !!exec();
  } catch (e) {
    return true;
  }
};


/***/ }),
/* 31 */,
/* 32 */
/*!*********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_export.js ***!
  \*********************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(/*! ./_global */ 21);
var core = __webpack_require__(/*! ./_core */ 22);
var ctx = __webpack_require__(/*! ./_ctx */ 58);
var hide = __webpack_require__(/*! ./_hide */ 28);
var PROTOTYPE = 'prototype';

var $export = function (type, name, source) {
  var IS_FORCED = type & $export.F;
  var IS_GLOBAL = type & $export.G;
  var IS_STATIC = type & $export.S;
  var IS_PROTO = type & $export.P;
  var IS_BIND = type & $export.B;
  var IS_WRAP = type & $export.W;
  var exports = IS_GLOBAL ? core : core[name] || (core[name] = {});
  var expProto = exports[PROTOTYPE];
  var target = IS_GLOBAL ? global : IS_STATIC ? global[name] : (global[name] || {})[PROTOTYPE];
  var key, own, out;
  if (IS_GLOBAL) source = name;
  for (key in source) {
    // contains in native
    own = !IS_FORCED && target && target[key] !== undefined;
    if (own && key in exports) continue;
    // export native or passed
    out = own ? target[key] : source[key];
    // prevent global pollution for namespaces
    exports[key] = IS_GLOBAL && typeof target[key] != 'function' ? source[key]
    // bind timers to global for call from export context
    : IS_BIND && own ? ctx(out, global)
    // wrap global constructors for prevent change them in library
    : IS_WRAP && target[key] == out ? (function (C) {
      var F = function (a, b, c) {
        if (this instanceof C) {
          switch (arguments.length) {
            case 0: return new C();
            case 1: return new C(a);
            case 2: return new C(a, b);
          } return new C(a, b, c);
        } return C.apply(this, arguments);
      };
      F[PROTOTYPE] = C[PROTOTYPE];
      return F;
    // make static versions for prototype methods
    })(out) : IS_PROTO && typeof out == 'function' ? ctx(Function.call, out) : out;
    // export proto methods to core.%CONSTRUCTOR%.methods.%NAME%
    if (IS_PROTO) {
      (exports.virtual || (exports.virtual = {}))[key] = out;
      // export proto methods to core.%CONSTRUCTOR%.prototype.%NAME%
      if (type & $export.R && expProto && !expProto[key]) hide(expProto, key, out);
    }
  }
};
// type bitmap
$export.F = 1;   // forced
$export.G = 2;   // global
$export.S = 4;   // static
$export.P = 8;   // proto
$export.B = 16;  // bind
$export.W = 32;  // wrap
$export.U = 64;  // safe
$export.R = 128; // real proto method for `library`
module.exports = $export;


/***/ }),
/* 33 */
/*!*******************************!*\
  !*** ./dev/Common/Plugins.js ***!
  \*******************************/
/*! exports provided: addHook, runHook, mainSettingsGet, remoteRequest, addSettingsViewModel, addSettingsViewModelForAdmin, runSettingsViewModelHooks, settingsGet */
/*! exports used: addHook, addSettingsViewModel, addSettingsViewModelForAdmin, mainSettingsGet, remoteRequest, runHook, runSettingsViewModelHooks, settingsGet */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = addHook;
/* harmony export (immutable) */ __webpack_exports__["f"] = runHook;
/* harmony export (immutable) */ __webpack_exports__["d"] = mainSettingsGet;
/* harmony export (immutable) */ __webpack_exports__["e"] = remoteRequest;
/* harmony export (immutable) */ __webpack_exports__["b"] = addSettingsViewModel;
/* harmony export (immutable) */ __webpack_exports__["c"] = addSettingsViewModelForAdmin;
/* harmony export (immutable) */ __webpack_exports__["g"] = runSettingsViewModelHooks;
/* harmony export (immutable) */ __webpack_exports__["h"] = settingsGet;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);






var SIMPLE_HOOKS = {},
    USER_VIEW_MODELS_HOOKS = [],
    ADMIN_VIEW_MODELS_HOOKS = [];

/**
 * @param {string} name
 * @param {Function} callback
 */
function addHook(name, callback) {
	if (Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isFunc"])(callback)) {
		if (!Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isArray"])(SIMPLE_HOOKS[name])) {
			SIMPLE_HOOKS[name] = [];
		}

		SIMPLE_HOOKS[name].push(callback);
	}
}

/**
 * @param {string} name
 * @param {Array=} args = []
 */
function runHook(name) {
	var args = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

	if (Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isArray"])(SIMPLE_HOOKS[name])) {
		__WEBPACK_IMPORTED_MODULE_0_____default.a.each(SIMPLE_HOOKS[name], function (callback) {
			callback.apply(undefined, args);
		});
	}
}

/**
 * @param {string} name
 * @returns {?}
 */
function mainSettingsGet(name) {
	return __WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"](name);
}

/**
 * @param {Function} callback
 * @param {string} action
 * @param {Object=} parameters
 * @param {?number=} timeout
 */
function remoteRequest(callback, action, parameters, timeout) {
	if (__WEBPACK_IMPORTED_MODULE_2_Common_Globals__["data"].__APP__) {
		__WEBPACK_IMPORTED_MODULE_2_Common_Globals__["data"].__APP__.remote().defaultRequest(callback, 'Plugin' + action, parameters, timeout);
	}
}

/**
 * @param {Function} SettingsViewModelClass
 * @param {string} labelName
 * @param {string} template
 * @param {string} route
 */
function addSettingsViewModel(SettingsViewModelClass, template, labelName, route) {
	USER_VIEW_MODELS_HOOKS.push([SettingsViewModelClass, template, labelName, route]);
}

/**
 * @param {Function} SettingsViewModelClass
 * @param {string} labelName
 * @param {string} template
 * @param {string} route
 */
function addSettingsViewModelForAdmin(SettingsViewModelClass, template, labelName, route) {
	ADMIN_VIEW_MODELS_HOOKS.push([SettingsViewModelClass, template, labelName, route]);
}

/**
 * @param {boolean} admin
 */
function runSettingsViewModelHooks(admin) {
	var Knoin = __webpack_require__(/*! Knoin/Knoin */ 9);
	__WEBPACK_IMPORTED_MODULE_0_____default.a.each(admin ? ADMIN_VIEW_MODELS_HOOKS : USER_VIEW_MODELS_HOOKS, function (view) {
		Knoin.addSettingsViewModel(view[0], view[1], view[2], view[3]);
	});
}

/**
 * @param {string} pluginSection
 * @param {string} name
 * @returns {?}
 */
function settingsGet(pluginSection, name) {
	var plugins = __WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('Plugins');
	plugins = plugins && !Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(plugins[pluginSection]) ? plugins[pluginSection] : null;
	return plugins ? Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(plugins[name]) ? null : plugins[name] : null;
}

/***/ }),
/* 34 */
/*!********************************!*\
  !*** ./dev/Stores/User/App.js ***!
  \********************************/
/*! exports provided: default */
/*! exports used: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Stores_AbstractApp__ = __webpack_require__(/*! Stores/AbstractApp */ 144);














var AppUserStore = function (_AbstractAppStore) {
	__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(AppUserStore, _AbstractAppStore);

	function AppUserStore() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, AppUserStore);

		var _this = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractAppStore.call(this));

		_this.currentAudio = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable('');

		_this.focusedState = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Focused"].None);

		var isMobile = __WEBPACK_IMPORTED_MODULE_7_Storage_Settings__["appSettingsGet"]('mobile');

		_this.focusedState.subscribe(function (value) {
			switch (value) {
				case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Focused"].MessageList:
					Object(__WEBPACK_IMPORTED_MODULE_5_Common_Globals__["keyScope"])(__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["KeyState"].MessageList);
					if (isMobile) {
						Object(__WEBPACK_IMPORTED_MODULE_5_Common_Globals__["leftPanelDisabled"])(true);
					}
					break;
				case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Focused"].MessageView:
					Object(__WEBPACK_IMPORTED_MODULE_5_Common_Globals__["keyScope"])(__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["KeyState"].MessageView);
					if (isMobile) {
						Object(__WEBPACK_IMPORTED_MODULE_5_Common_Globals__["leftPanelDisabled"])(true);
					}
					break;
				case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Focused"].FolderList:
					Object(__WEBPACK_IMPORTED_MODULE_5_Common_Globals__["keyScope"])(__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["KeyState"].FolderList);
					if (isMobile) {
						Object(__WEBPACK_IMPORTED_MODULE_5_Common_Globals__["leftPanelDisabled"])(false);
					}
					break;
				default:
					break;
			}
		});

		_this.projectHash = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable('');
		_this.threadsAllowed = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(false);

		_this.composeInEdit = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(false);

		_this.contactsAutosave = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(false);
		_this.useLocalProxyForExternalImages = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(false);

		_this.contactsIsAllowed = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(false);

		_this.attachmentsActions = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observableArray([]);

		_this.devEmail = '';
		_this.devPassword = '';
		return _this;
	}

	AppUserStore.prototype.populate = function populate() {

		_AbstractAppStore.prototype.populate.call(this);

		this.projectHash(__WEBPACK_IMPORTED_MODULE_7_Storage_Settings__["settingsGet"]('ProjectHash'));

		this.contactsAutosave(!!__WEBPACK_IMPORTED_MODULE_7_Storage_Settings__["settingsGet"]('ContactsAutosave'));
		this.useLocalProxyForExternalImages(!!__WEBPACK_IMPORTED_MODULE_7_Storage_Settings__["settingsGet"]('UseLocalProxyForExternalImages'));

		this.contactsIsAllowed(!!__WEBPACK_IMPORTED_MODULE_7_Storage_Settings__["settingsGet"]('ContactsIsAllowed'));

		var attachmentsActions = __WEBPACK_IMPORTED_MODULE_7_Storage_Settings__["appSettingsGet"]('attachmentsActions');
		this.attachmentsActions(Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["isNonEmptyArray"])(attachmentsActions) ? attachmentsActions : []);

		this.devEmail = __WEBPACK_IMPORTED_MODULE_7_Storage_Settings__["settingsGet"]('DevEmail');
		this.devPassword = __WEBPACK_IMPORTED_MODULE_7_Storage_Settings__["settingsGet"]('DevPassword');
	};

	return AppUserStore;
}(__WEBPACK_IMPORTED_MODULE_8_Stores_AbstractApp__["a" /* AbstractAppStore */]);

/* harmony default export */ __webpack_exports__["a"] = (new AppUserStore());

/***/ }),
/* 35 */
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_an-object.js ***!
  \************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(/*! ./_is-object */ 29);
module.exports = function (it) {
  if (!isObject(it)) throw TypeError(it + ' is not an object!');
  return it;
};


/***/ }),
/* 36 */
/*!******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_wks.js ***!
  \******************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

var store = __webpack_require__(/*! ./_shared */ 67)('wks');
var uid = __webpack_require__(/*! ./_uid */ 52);
var Symbol = __webpack_require__(/*! ./_global */ 21).Symbol;
var USE_SYMBOL = typeof Symbol == 'function';

var $exports = module.exports = function (name) {
  return store[name] || (store[name] =
    USE_SYMBOL && Symbol[name] || (USE_SYMBOL ? Symbol : uid)('Symbol.' + name));
};

$exports.store = store;


/***/ }),
/* 37 */
/*!******************************!*\
  !*** ./dev/Common/Events.js ***!
  \******************************/
/*! exports provided: sub, pub */
/*! exports used: pub, sub */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["b"] = sub;
/* harmony export (immutable) */ __webpack_exports__["a"] = pub;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Plugins__ = __webpack_require__(/*! Common/Plugins */ 33);





var SUBS = {};

/**
 * @param {string|Object} name
 * @param {Function} func
 * @param {Object=} context
 */
function sub(name, func, context) {
	if (Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isObject"])(name)) {
		context = func || null;
		func = null;

		__WEBPACK_IMPORTED_MODULE_0_____default.a.each(name, function (subFunc, subName) {
			sub(subName, subFunc, context);
		});
	} else {
		if (Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(SUBS[name])) {
			SUBS[name] = [];
		}

		SUBS[name].push([func, context]);
	}
}

/**
 * @param {string} name
 * @param {Array=} args
 */
function pub(name, args) {
	__WEBPACK_IMPORTED_MODULE_2_Common_Plugins__["f" /* runHook */]('rl-pub', [name, args]);

	if (!Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(SUBS[name])) {
		__WEBPACK_IMPORTED_MODULE_0_____default.a.each(SUBS[name], function (items) {
			if (items[0]) {
				items[0].apply(items[1] || null, args || []);
			}
		});
	}
}

/***/ }),
/* 38 */
/*!***********************************!*\
  !*** ./dev/Stores/User/Folder.js ***!
  \***********************************/
/*! exports provided: default */
/*! exports used: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Consts__ = __webpack_require__(/*! Common/Consts */ 20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Cache__ = __webpack_require__(/*! Common/Cache */ 27);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Common_Momentor__ = __webpack_require__(/*! Common/Momentor */ 40);














var FolderUserStore = function () {
	function FolderUserStore() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, FolderUserStore);

		this.displaySpecSetting = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(true);

		this.sentFolder = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable('');
		this.draftFolder = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable('');
		this.spamFolder = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable('');
		this.trashFolder = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable('');
		this.archiveFolder = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable('');

		this.namespace = '';

		this.folderList = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observableArray([]);
		this.folderList.optimized = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(false);
		this.folderList.error = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable('');

		this.foldersLoading = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(false);
		this.foldersCreating = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(false);
		this.foldersDeleting = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(false);
		this.foldersRenaming = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(false);

		this.foldersInboxUnreadCount = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(0);

		this.currentFolder = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(null).extend({ toggleSubscribeProperty: [this, 'selected'] });

		this.sieveAllowFileintoInbox = !!Object(__WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"])('SieveAllowFileintoInbox');

		this.computers();
		this.subscribers();
	}

	FolderUserStore.prototype.computers = function computers() {
		var _this = this;

		this.draftFolderNotEnabled = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].computed(function () {
			return '' === _this.draftFolder() || __WEBPACK_IMPORTED_MODULE_5_Common_Consts__["r" /* UNUSED_OPTION_VALUE */] === _this.draftFolder();
		});

		this.foldersListWithSingleInboxRootFolder = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].computed(function () {
			return !__WEBPACK_IMPORTED_MODULE_2_____default.a.find(_this.folderList(), function (folder) {
				return folder && !folder.isSystemFolder() && folder.visible();
			});
		});

		this.currentFolderFullNameRaw = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].computed(function () {
			return _this.currentFolder() ? _this.currentFolder().fullNameRaw : '';
		});

		this.currentFolderFullName = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].computed(function () {
			return _this.currentFolder() ? _this.currentFolder().fullName : '';
		});
		this.currentFolderFullNameHash = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].computed(function () {
			return _this.currentFolder() ? _this.currentFolder().fullNameHash : '';
		});

		this.foldersChanging = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].computed(function () {
			var loading = _this.foldersLoading(),
			    creating = _this.foldersCreating(),
			    deleting = _this.foldersDeleting(),
			    renaming = _this.foldersRenaming();

			return loading || creating || deleting || renaming;
		});

		this.folderListSystemNames = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].computed(function () {

			var list = [Object(__WEBPACK_IMPORTED_MODULE_7_Common_Cache__["h" /* getFolderInboxName */])()],
			    folders = _this.folderList(),
			    sentFolder = _this.sentFolder(),
			    draftFolder = _this.draftFolder(),
			    spamFolder = _this.spamFolder(),
			    trashFolder = _this.trashFolder(),
			    archiveFolder = _this.archiveFolder();

			if (Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["isArray"])(folders) && 0 < folders.length) {
				if ('' !== sentFolder && __WEBPACK_IMPORTED_MODULE_5_Common_Consts__["r" /* UNUSED_OPTION_VALUE */] !== sentFolder) {
					list.push(sentFolder);
				}
				if ('' !== draftFolder && __WEBPACK_IMPORTED_MODULE_5_Common_Consts__["r" /* UNUSED_OPTION_VALUE */] !== draftFolder) {
					list.push(draftFolder);
				}
				if ('' !== spamFolder && __WEBPACK_IMPORTED_MODULE_5_Common_Consts__["r" /* UNUSED_OPTION_VALUE */] !== spamFolder) {
					list.push(spamFolder);
				}
				if ('' !== trashFolder && __WEBPACK_IMPORTED_MODULE_5_Common_Consts__["r" /* UNUSED_OPTION_VALUE */] !== trashFolder) {
					list.push(trashFolder);
				}
				if ('' !== archiveFolder && __WEBPACK_IMPORTED_MODULE_5_Common_Consts__["r" /* UNUSED_OPTION_VALUE */] !== archiveFolder) {
					list.push(archiveFolder);
				}
			}

			return list;
		});

		this.folderListSystem = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].computed(function () {
			return __WEBPACK_IMPORTED_MODULE_2_____default.a.compact(__WEBPACK_IMPORTED_MODULE_2_____default.a.map(_this.folderListSystemNames(), function (name) {
				return Object(__WEBPACK_IMPORTED_MODULE_7_Common_Cache__["e" /* getFolderFromCacheList */])(name);
			}));
		});

		this.folderMenuForMove = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].computed(function () {
			return Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["folderListOptionsBuilder"])(_this.folderListSystem(), _this.folderList(), [_this.currentFolderFullNameRaw()], null, null, null, null, function (item) {
				return item ? item.localName() : '';
			});
		});

		this.folderMenuForFilters = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].computed(function () {
			return Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["folderListOptionsBuilder"])(_this.folderListSystem(), _this.folderList(), [_this.sieveAllowFileintoInbox ? '' : 'INBOX'], [['', '']], null, null, null, function (item) {
				return item ? item.localName() : '';
			});
		});
	};

	FolderUserStore.prototype.subscribers = function subscribers() {
		var fRemoveSystemFolderType = function fRemoveSystemFolderType(observable) {
			return function () {
				var folder = Object(__WEBPACK_IMPORTED_MODULE_7_Common_Cache__["e" /* getFolderFromCacheList */])(observable());
				if (folder) {
					folder.type(__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["FolderType"].User);
				}
			};
		};
		var fSetSystemFolderType = function fSetSystemFolderType(type) {
			return function (value) {
				var folder = Object(__WEBPACK_IMPORTED_MODULE_7_Common_Cache__["e" /* getFolderFromCacheList */])(value);
				if (folder) {
					folder.type(type);
				}
			};
		};

		this.sentFolder.subscribe(fRemoveSystemFolderType(this.sentFolder), this, 'beforeChange');
		this.draftFolder.subscribe(fRemoveSystemFolderType(this.draftFolder), this, 'beforeChange');
		this.spamFolder.subscribe(fRemoveSystemFolderType(this.spamFolder), this, 'beforeChange');
		this.trashFolder.subscribe(fRemoveSystemFolderType(this.trashFolder), this, 'beforeChange');
		this.archiveFolder.subscribe(fRemoveSystemFolderType(this.archiveFolder), this, 'beforeChange');

		this.sentFolder.subscribe(fSetSystemFolderType(__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["FolderType"].SentItems), this);
		this.draftFolder.subscribe(fSetSystemFolderType(__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["FolderType"].Draft), this);
		this.spamFolder.subscribe(fSetSystemFolderType(__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["FolderType"].Spam), this);
		this.trashFolder.subscribe(fSetSystemFolderType(__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["FolderType"].Trash), this);
		this.archiveFolder.subscribe(fSetSystemFolderType(__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["FolderType"].Archive), this);
	};

	/**
  * @returns {Array}
  */


	FolderUserStore.prototype.getNextFolderNames = function getNextFolderNames() {

		var result = [],
		    limit = 5,
		    utc = Object(__WEBPACK_IMPORTED_MODULE_8_Common_Momentor__["momentNowUnix"])(),
		    timeout = utc - 60 * 5,
		    timeouts = [],
		    inboxFolderName = Object(__WEBPACK_IMPORTED_MODULE_7_Common_Cache__["h" /* getFolderInboxName */])(),
		    fSearchFunction = function fSearchFunction(list) {
			__WEBPACK_IMPORTED_MODULE_2_____default.a.each(list, function (folder) {
				if (folder && inboxFolderName !== folder.fullNameRaw && folder.selectable && folder.existen && timeout > folder.interval && (folder.isSystemFolder() || folder.subScribed() && folder.checkable())) {
					timeouts.push([folder.interval, folder.fullNameRaw]);
				}

				if (folder && 0 < folder.subFolders().length) {
					fSearchFunction(folder.subFolders());
				}
			});
		};

		fSearchFunction(this.folderList());

		timeouts.sort(function (a, b) {
			if (a[0] < b[0]) {
				return -1;
			} else if (a[0] > b[0]) {
				return 1;
			}

			return 0;
		});

		__WEBPACK_IMPORTED_MODULE_2_____default.a.find(timeouts, function (aItem) {
			var folder = Object(__WEBPACK_IMPORTED_MODULE_7_Common_Cache__["e" /* getFolderFromCacheList */])(aItem[1]);
			if (folder) {
				folder.interval = utc;
				result.push(aItem[1]);
			}

			return limit <= result.length;
		});

		return __WEBPACK_IMPORTED_MODULE_2_____default.a.uniq(result);
	};

	return FolderUserStore;
}();

/* harmony default export */ __webpack_exports__["a"] = (new FolderUserStore());

/***/ }),
/* 39 */
/*!****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_property-desc.js ***!
  \****************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

module.exports = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};


/***/ }),
/* 40 */
/*!********************************!*\
  !*** ./dev/Common/Momentor.js ***!
  \********************************/
/*! exports provided: momentNow, momentNowUnix, searchSubtractFormatDateHelper, format, momentToNode, reload */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (immutable) */ __webpack_exports__["momentNow"] = momentNow;
/* harmony export (immutable) */ __webpack_exports__["momentNowUnix"] = momentNowUnix;
/* harmony export (immutable) */ __webpack_exports__["searchSubtractFormatDateHelper"] = searchSubtractFormatDateHelper;
/* harmony export (immutable) */ __webpack_exports__["format"] = format;
/* harmony export (immutable) */ __webpack_exports__["momentToNode"] = momentToNode;
/* harmony export (immutable) */ __webpack_exports__["reload"] = reload;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! $ */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_moment__ = __webpack_require__(/*! moment */ 75);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_moment___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_moment__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 8);







var _moment = null;
var _momentNow = 0;

var updateMomentNow = __WEBPACK_IMPORTED_MODULE_1_____default.a.debounce(function () {
	_moment = __WEBPACK_IMPORTED_MODULE_3_moment___default()();
}, 500, true);

var updateMomentNowUnix = __WEBPACK_IMPORTED_MODULE_1_____default.a.debounce(function () {
	_momentNow = __WEBPACK_IMPORTED_MODULE_3_moment___default()().unix();
}, 500, true);

/**
 * @returns {moment}
 */
function momentNow() {
	updateMomentNow();
	return _moment || __WEBPACK_IMPORTED_MODULE_3_moment___default()();
}

/**
 * @returns {number}
 */
function momentNowUnix() {
	updateMomentNowUnix();
	return _momentNow || 0;
}

/**
 * @param {number} date
 * @returns {string}
 */
function searchSubtractFormatDateHelper(date) {
	return momentNow().clone().subtract(date, 'days').format('YYYY.MM.DD');
}

/**
 * @param {Object} m
 * @returns {string}
 */
function formatCustomShortDate(m) {
	var now = momentNow();
	if (m && now) {
		switch (true) {
			case 4 >= now.diff(m, 'hours'):
				return m.fromNow();
			case now.format('L') === m.format('L'):
				return Object(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('MESSAGE_LIST/TODAY_AT', {
					TIME: m.format('LT')
				});
			case now.clone().subtract(1, 'days').format('L') === m.format('L'):
				return Object(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('MESSAGE_LIST/YESTERDAY_AT', {
					TIME: m.format('LT')
				});
			case now.year() === m.year():
				return m.format('D MMM.');
			// no default
		}
	}

	return m ? m.format('LL') : '';
}

/**
 * @param {number} timeStampInUTC
 * @param {string} formatStr
 * @returns {string}
 */
function format(timeStampInUTC, formatStr) {

	var m = null,
	    result = '';

	var now = momentNowUnix();

	timeStampInUTC = 0 < timeStampInUTC ? timeStampInUTC : 0 === timeStampInUTC ? now : 0;
	timeStampInUTC = now < timeStampInUTC ? now : timeStampInUTC;

	m = 0 < timeStampInUTC ? __WEBPACK_IMPORTED_MODULE_3_moment___default.a.unix(timeStampInUTC) : null;

	if (m && 1970 === m.year()) {
		m = null;
	}

	if (m) {
		switch (formatStr) {
			case 'FROMNOW':
				result = m.fromNow();
				break;
			case 'SHORT':
				result = formatCustomShortDate(m);
				break;
			case 'FULL':
				result = m.format('LLL');
				break;
			default:
				result = m.format(formatStr);
				break;
		}
	}

	return result;
}

/**
 * @param {Object} element
 * @returns {void}
 */
function momentToNode(element) {
	var key = '',
	    time = 0;
	var $el = __WEBPACK_IMPORTED_MODULE_2_____default()(element);

	time = $el.data('moment-time');
	if (time) {
		key = $el.data('moment-format');
		if (key) {
			$el.text(format(time, key));
		}

		key = $el.data('moment-format-title');
		if (key) {
			$el.attr('title', format(time, key));
		}
	}
}

/**
 * @returns {void}
 */
function reload() {
	__WEBPACK_IMPORTED_MODULE_1_____default.a.defer(function () {
		__WEBPACK_IMPORTED_MODULE_2_____default()('.moment', __WEBPACK_IMPORTED_MODULE_0_window___default.a.document).each(function (index, item) {
			momentToNode(item);
		});
	});
}

/***/ }),
/* 41 */
/*!*************************************!*\
  !*** ./dev/Stores/User/Settings.js ***!
  \*************************************/
/*! exports provided: default */
/*! exports used: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Consts__ = __webpack_require__(/*! Common/Consts */ 20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Events__ = __webpack_require__(/*! Common/Events */ 37);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);













var SettingsUserStore = function () {
	function SettingsUserStore() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, SettingsUserStore);

		this.iAutoLogoutTimer = 0;

		this.layout = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Layout"].SidePreview).extend({ limitedList: [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Layout"].SidePreview, __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Layout"].BottomPreview, __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Layout"].NoPreview] });

		this.editorDefaultType = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EditorDefaultType"].Html).extend({ limitedList: [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EditorDefaultType"].Html, __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EditorDefaultType"].Plain, __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EditorDefaultType"].HtmlForced, __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EditorDefaultType"].PlainForced] });

		this.messagesPerPage = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(__WEBPACK_IMPORTED_MODULE_3_Common_Consts__["i" /* MESSAGES_PER_PAGE */]).extend({ limitedList: __WEBPACK_IMPORTED_MODULE_3_Common_Consts__["j" /* MESSAGES_PER_PAGE_VALUES */] });

		this.showImages = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(false);
		this.useCheckboxesInList = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(true);
		this.allowDraftAutosave = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(true);
		this.useThreads = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(false);
		this.replySameFolder = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(false);

		this.autoLogout = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Magics"].Time30mInMin);

		this.computers();
		this.subscribers();
	}

	SettingsUserStore.prototype.computers = function computers() {
		var _this = this;

		this.usePreviewPane = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].computed(function () {
			return __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Layout"].NoPreview !== _this.layout();
		});
	};

	SettingsUserStore.prototype.subscribers = function subscribers() {
		this.layout.subscribe(function (value) {
			__WEBPACK_IMPORTED_MODULE_5_Common_Globals__["$html"].toggleClass('rl-no-preview-pane', __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Layout"].NoPreview === value);
			__WEBPACK_IMPORTED_MODULE_5_Common_Globals__["$html"].toggleClass('rl-side-preview-pane', __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Layout"].SidePreview === value);
			__WEBPACK_IMPORTED_MODULE_5_Common_Globals__["$html"].toggleClass('rl-bottom-preview-pane', __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Layout"].BottomPreview === value);
			__WEBPACK_IMPORTED_MODULE_7_Common_Events__["a" /* pub */]('layout', [value]);
		});
	};

	SettingsUserStore.prototype.populate = function populate() {
		var _this2 = this;

		this.layout(Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["pInt"])(__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["settingsGet"]('Layout')));
		this.editorDefaultType(__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["settingsGet"]('EditorDefaultType'));

		this.autoLogout(Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["pInt"])(__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["settingsGet"]('AutoLogout')));
		this.messagesPerPage(__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["settingsGet"]('MPP'));

		this.showImages(!!__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["settingsGet"]('ShowImages'));
		this.useCheckboxesInList(!!__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["settingsGet"]('UseCheckboxesInList'));
		this.allowDraftAutosave(!!__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["settingsGet"]('AllowDraftAutosave'));
		this.useThreads(!!__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["settingsGet"]('UseThreads'));
		this.replySameFolder(!!__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["settingsGet"]('ReplySameFolder'));

		__WEBPACK_IMPORTED_MODULE_7_Common_Events__["b" /* sub */]('rl.auto-logout-refresh', function () {
			__WEBPACK_IMPORTED_MODULE_1_window___default.a.clearTimeout(_this2.iAutoLogoutTimer);
			if (0 < _this2.autoLogout() && !__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["settingsGet"]('AccountSignMe')) {
				_this2.iAutoLogoutTimer = __WEBPACK_IMPORTED_MODULE_1_window___default.a.setTimeout(function () {
					__WEBPACK_IMPORTED_MODULE_7_Common_Events__["a" /* pub */]('rl.auto-logout');
				}, _this2.autoLogout() * __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Magics"].Time1m);
			}
		});

		__WEBPACK_IMPORTED_MODULE_7_Common_Events__["a" /* pub */]('rl.auto-logout-refresh');
	};

	return SettingsUserStore;
}();

/* harmony default export */ __webpack_exports__["a"] = (new SettingsUserStore());

/***/ }),
/* 42 */
/*!************************************!*\
  !*** ./dev/Knoin/AbstractModel.js ***!
  \************************************/
/*! exports provided: AbstractModel */
/*! exports used: AbstractModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AbstractModel; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);




var AbstractModel = function () {

	/**
  * @param {string} modelName = ''
  */
	function AbstractModel() {
		var modelName = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, AbstractModel);

		this.sModelName = '';
		this.disposables = [];

		this.sModelName = modelName || '';
	}

	AbstractModel.prototype.regDisposables = function regDisposables(value) {
		var _this = this;

		if (Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isArray"])(value)) {
			value.forEach(function (item) {
				_this.disposables.push(item);
			});
		} else if (value) {
			this.disposables.push(value);
		}
	};

	AbstractModel.prototype.onDestroy = function onDestroy() {
		Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["disposeObject"])(this);
	};

	return AbstractModel;
}();

/***/ }),
/* 43 */
/*!***********************************!*\
  !*** ./dev/View/Popup/Compose.js ***!
  \***********************************/
/*! exports provided: ComposePopupView, default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ComposePopupView", function() { return ComposePopupView; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return ComposePopupView; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor__ = __webpack_require__(/*! babel-runtime/core-js/object/get-own-property-descriptor */ 15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6____ = __webpack_require__(/*! $ */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_key__ = __webpack_require__(/*! key */ 19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_key___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_8_key__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Jua__ = __webpack_require__(/*! Jua */ 99);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Jua___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_9_Jua__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_Common_Consts__ = __webpack_require__(/*! Common/Consts */ 20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14_Common_Links__ = __webpack_require__(/*! Common/Links */ 14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_16_Common_Momentor__ = __webpack_require__(/*! Common/Momentor */ 40);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_17_Common_Cache__ = __webpack_require__(/*! Common/Cache */ 27);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_18_Common_HtmlEditor__ = __webpack_require__(/*! Common/HtmlEditor */ 85);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_19_Stores_User_App__ = __webpack_require__(/*! Stores/User/App */ 34);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_20_Stores_User_Settings__ = __webpack_require__(/*! Stores/User/Settings */ 41);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_21_Stores_User_Identity__ = __webpack_require__(/*! Stores/User/Identity */ 98);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_22_Stores_User_Account__ = __webpack_require__(/*! Stores/User/Account */ 47);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_23_Stores_User_Folder__ = __webpack_require__(/*! Stores/User/Folder */ 38);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_24_Stores_User_Pgp__ = __webpack_require__(/*! Stores/User/Pgp */ 53);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_25_Stores_User_Message__ = __webpack_require__(/*! Stores/User/Message */ 45);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_26_Stores_Social__ = __webpack_require__(/*! Stores/Social */ 56);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax__ = __webpack_require__(/*! Remote/User/Ajax */ 17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_28_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_29_Common_Events__ = __webpack_require__(/*! Common/Events */ 37);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_30_Model_ComposeAttachment__ = __webpack_require__(/*! Model/ComposeAttachment */ 233);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_31_Helper_Apps_User__ = __webpack_require__(/*! Helper/Apps/User */ 16);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_32_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_33_Knoin_AbstractViewNext__ = __webpack_require__(/*! Knoin/AbstractViewNext */ 13);





var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _class, _desc, _value, _class2;

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
	var desc = {};
	Object['ke' + 'ys'](descriptor).forEach(function (key) {
		desc[key] = descriptor[key];
	});
	desc.enumerable = !!desc.enumerable;
	desc.configurable = !!desc.configurable;

	if ('value' in desc || desc.initializer) {
		desc.writable = true;
	}

	desc = decorators.slice().reverse().reduce(function (desc, decorator) {
		return decorator(target, property, desc) || desc;
	}, desc);

	if (context && desc.initializer !== void 0) {
		desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
		desc.initializer = undefined;
	}

	if (desc.initializer === void 0) {
		Object['define' + 'Property'](target, property, desc);
		desc = null;
	}

	return desc;
}










































var ComposePopupView = (_dec = Object(__WEBPACK_IMPORTED_MODULE_32_Knoin_Knoin__["popup"])({
	name: 'View/Popup/Compose',
	templateID: 'PopupsCompose'
}), _dec2 = Object(__WEBPACK_IMPORTED_MODULE_32_Knoin_Knoin__["command"])(function (self) {
	return self.canBeSentOrSaved();
}), _dec3 = Object(__WEBPACK_IMPORTED_MODULE_32_Knoin_Knoin__["command"])(function (self) {
	return self.canBeSentOrSaved();
}), _dec4 = Object(__WEBPACK_IMPORTED_MODULE_32_Knoin_Knoin__["command"])(function (self) {
	return self.isDraftFolderMessage();
}), _dec5 = Object(__WEBPACK_IMPORTED_MODULE_32_Knoin_Knoin__["command"])(function (self) {
	return self.canBeSentOrSaved();
}), _dec6 = Object(__WEBPACK_IMPORTED_MODULE_32_Knoin_Knoin__["command"])(function (self) {
	return self.allowContacts;
}), _dec7 = Object(__WEBPACK_IMPORTED_MODULE_32_Knoin_Knoin__["command"])(function (self) {
	return self.dropboxEnabled();
}), _dec8 = Object(__WEBPACK_IMPORTED_MODULE_32_Knoin_Knoin__["command"])(function (self) {
	return self.driveEnabled();
}), _dec(_class = (_class2 = function (_AbstractViewNext) {
	__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits___default()(ComposePopupView, _AbstractViewNext);

	function ComposePopupView() {
		__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default()(this, ComposePopupView);

		var _this = __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractViewNext.call(this));

		var fEmailOutInHelper = function fEmailOutInHelper(context, identity, name, isIn) {
			if (identity && context && identity[name]() && (isIn ? true : context[name]())) {
				var identityEmail = identity[name]();
				var list = Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["trim"])(context[name]()).split(/[,]/);

				list = __WEBPACK_IMPORTED_MODULE_5_____default.a.filter(list, function (email) {
					email = Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["trim"])(email);
					return email && Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["trim"])(identityEmail) !== email;
				});

				if (isIn) {
					list.push(identityEmail);
				}

				context[name](list.join(','));
			}
		};

		_this.oLastMessage = null;
		_this.oEditor = null;
		_this.aDraftInfo = null;
		_this.sInReplyTo = '';
		_this.bFromDraft = false;
		_this.sReferences = '';

		_this.sLastFocusedField = 'to';

		_this.resizerTrigger = __WEBPACK_IMPORTED_MODULE_5_____default.a.bind(_this.resizerTrigger, _this);

		_this.allowContacts = !!__WEBPACK_IMPORTED_MODULE_19_Stores_User_App__["a" /* default */].contactsIsAllowed();
		_this.allowFolders = !!__WEBPACK_IMPORTED_MODULE_28_Storage_Settings__["capa"](__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["Capa"].Folders);

		_this.bSkipNextHide = false;
		_this.composeInEdit = __WEBPACK_IMPORTED_MODULE_19_Stores_User_App__["a" /* default */].composeInEdit;
		_this.editorDefaultType = __WEBPACK_IMPORTED_MODULE_20_Stores_User_Settings__["a" /* default */].editorDefaultType;

		_this.capaOpenPGP = __WEBPACK_IMPORTED_MODULE_24_Stores_User_Pgp__["a" /* default */].capaOpenPGP;

		_this.identitiesDropdownTrigger = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);

		_this.to = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable('');
		_this.to.focused = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);
		_this.cc = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable('');
		_this.cc.focused = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);
		_this.bcc = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable('');
		_this.bcc.focused = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);
		_this.replyTo = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable('');
		_this.replyTo.focused = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);

		__WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].computed(function () {
			switch (true) {
				case _this.to.focused():
					_this.sLastFocusedField = 'to';
					break;
				case _this.cc.focused():
					_this.sLastFocusedField = 'cc';
					break;
				case _this.bcc.focused():
					_this.sLastFocusedField = 'bcc';
					break;
				// no default
			}
		}).extend({ notify: 'always' });

		_this.subject = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable('');
		_this.subject.focused = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);

		_this.isHtml = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);

		_this.requestDsn = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);
		_this.requestReadReceipt = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);
		_this.markAsImportant = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);

		_this.sendError = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);
		_this.sendSuccessButSaveError = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);
		_this.savedError = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);

		_this.sendButtonSuccess = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].computed(function () {
			return !_this.sendError() && !_this.sendSuccessButSaveError();
		});

		_this.sendErrorDesc = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable('');
		_this.savedErrorDesc = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable('');

		_this.sendError.subscribe(function (value) {
			if (!value) {
				_this.sendErrorDesc('');
			}
		});

		_this.savedError.subscribe(function (value) {
			if (!value) {
				_this.savedErrorDesc('');
			}
		});

		_this.sendSuccessButSaveError.subscribe(function (value) {
			if (!value) {
				_this.savedErrorDesc('');
			}
		});

		_this.savedTime = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(0);
		_this.savedTimeText = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].computed(function () {
			return 0 < _this.savedTime() ? Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["i18n"])('COMPOSE/SAVED_TIME', { 'TIME': Object(__WEBPACK_IMPORTED_MODULE_16_Common_Momentor__["format"])(_this.savedTime() - 1, 'LT') }) : '';
		});

		_this.emptyToError = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);
		_this.emptyToErrorTooltip = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].computed(function () {
			return _this.emptyToError() ? Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["i18n"])('COMPOSE/EMPTY_TO_ERROR_DESC') : '';
		});

		_this.attachmentsInProcessError = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);
		_this.attachmentsInErrorError = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);

		_this.attachmentsErrorTooltip = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].computed(function () {
			var result = '';
			switch (true) {
				case _this.attachmentsInProcessError():
					result = Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["i18n"])('COMPOSE/ATTACHMENTS_UPLOAD_ERROR_DESC');
					break;
				case _this.attachmentsInErrorError():
					result = Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["i18n"])('COMPOSE/ATTACHMENTS_ERROR_DESC');
					break;
				// no default
			}
			return result;
		});

		_this.showCc = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);
		_this.showBcc = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);
		_this.showReplyTo = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);

		_this.cc.subscribe(function (value) {
			if (false === _this.showCc() && 0 < value.length) {
				_this.showCc(true);
			}
		});

		_this.bcc.subscribe(function (value) {
			if (false === _this.showBcc() && 0 < value.length) {
				_this.showBcc(true);
			}
		});

		_this.replyTo.subscribe(function (value) {
			if (false === _this.showReplyTo() && 0 < value.length) {
				_this.showReplyTo(true);
			}
		});

		_this.draftFolder = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable('');
		_this.draftUid = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable('');
		_this.sending = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);
		_this.saving = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);
		_this.attachments = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observableArray([]);

		_this.attachmentsInProcess = _this.attachments.filter(function (item) {
			return item && !item.complete();
		});
		_this.attachmentsInReady = _this.attachments.filter(function (item) {
			return item && item.complete();
		});
		_this.attachmentsInError = _this.attachments.filter(function (item) {
			return item && '' !== item.error();
		});

		_this.attachmentsCount = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].computed(function () {
			return _this.attachments().length;
		});
		_this.attachmentsInErrorCount = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].computed(function () {
			return _this.attachmentsInError().length;
		});
		_this.attachmentsInProcessCount = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].computed(function () {
			return _this.attachmentsInProcess().length;
		});
		_this.isDraftFolderMessage = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].computed(function () {
			return '' !== _this.draftFolder() && '' !== _this.draftUid();
		});

		_this.attachmentsPlace = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);

		_this.attachments.subscribe(_this.resizerTrigger);
		_this.attachmentsPlace.subscribe(_this.resizerTrigger);

		_this.attachmentsInErrorCount.subscribe(function (value) {
			if (0 === value) {
				_this.attachmentsInErrorError(false);
			}
		});

		_this.composeUploaderButton = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(null);
		_this.composeUploaderDropPlace = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(null);
		_this.dragAndDropEnabled = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);
		_this.dragAndDropOver = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false).extend({ throttle: 1 });
		_this.dragAndDropVisible = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false).extend({ throttle: 1 });
		_this.attacheMultipleAllowed = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);
		_this.addAttachmentEnabled = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);

		_this.composeEditorArea = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(null);

		_this.identities = __WEBPACK_IMPORTED_MODULE_21_Stores_User_Identity__["a" /* default */].identities;
		_this.identitiesOptions = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].computed(function () {
			return __WEBPACK_IMPORTED_MODULE_5_____default.a.map(__WEBPACK_IMPORTED_MODULE_21_Stores_User_Identity__["a" /* default */].identities(), function (item) {
				return {
					'item': item,
					'optValue': item.id(),
					'optText': item.formattedName()
				};
			});
		});

		_this.currentIdentity = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(_this.identities()[0] ? _this.identities()[0] : null);

		_this.currentIdentity.extend({ toggleSubscribe: [_this, function (identity) {
				fEmailOutInHelper(_this, identity, 'bcc');
				fEmailOutInHelper(_this, identity, 'replyTo');
			}, function (identity) {
				fEmailOutInHelper(_this, identity, 'bcc', true);
				fEmailOutInHelper(_this, identity, 'replyTo', true);
			}] });

		_this.currentIdentityView = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].computed(function () {
			var item = _this.currentIdentity();
			return item ? item.formattedName() : 'unknown';
		});

		_this.to.subscribe(function (value) {
			if (_this.emptyToError() && 0 < value.length) {
				_this.emptyToError(false);
			}
		});

		_this.attachmentsInProcess.subscribe(function (value) {
			if (_this.attachmentsInProcessError() && Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isArray"])(value) && 0 === value.length) {
				_this.attachmentsInProcessError(false);
			}
		});

		_this.resizer = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false).extend({ throttle: 50 });

		_this.resizer.subscribe(function () {
			if (_this.oEditor) {
				_this.oEditor.resize();
			}
		});

		_this.canBeSentOrSaved = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].computed(function () {
			return !_this.sending() && !_this.saving();
		});

		_this.sendMessageResponse = __WEBPACK_IMPORTED_MODULE_5_____default.a.bind(_this.sendMessageResponse, _this);
		_this.saveMessageResponse = __WEBPACK_IMPORTED_MODULE_5_____default.a.bind(_this.saveMessageResponse, _this);

		__WEBPACK_IMPORTED_MODULE_29_Common_Events__["b" /* sub */]('interval.2m', function () {
			if (_this.modalVisibility() && !__WEBPACK_IMPORTED_MODULE_23_Stores_User_Folder__["a" /* default */].draftFolderNotEnabled() && __WEBPACK_IMPORTED_MODULE_20_Stores_User_Settings__["a" /* default */].allowDraftAutosave() && !_this.isEmptyForm(false) && !_this.saving() && !_this.sending() && !_this.savedError()) {
				_this.saveCommand();
			}
		});

		_this.showCc.subscribe(_this.resizerTrigger);
		_this.showBcc.subscribe(_this.resizerTrigger);
		_this.showReplyTo.subscribe(_this.resizerTrigger);

		_this.dropboxEnabled = __WEBPACK_IMPORTED_MODULE_26_Stores_Social__["a" /* default */].dropbox.enabled;
		_this.dropboxApiKey = __WEBPACK_IMPORTED_MODULE_26_Stores_Social__["a" /* default */].dropbox.apiKey;

		_this.driveEnabled = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(__WEBPACK_IMPORTED_MODULE_13_Common_Globals__["bXMLHttpRequestSupported"] && !!__WEBPACK_IMPORTED_MODULE_28_Storage_Settings__["settingsGet"]('AllowGoogleSocial') && !!__WEBPACK_IMPORTED_MODULE_28_Storage_Settings__["settingsGet"]('AllowGoogleSocialDrive') && !!__WEBPACK_IMPORTED_MODULE_28_Storage_Settings__["settingsGet"]('GoogleClientID') && !!__WEBPACK_IMPORTED_MODULE_28_Storage_Settings__["settingsGet"]('GoogleApiKey'));

		_this.driveVisible = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);

		_this.driveCallback = __WEBPACK_IMPORTED_MODULE_5_____default.a.bind(_this.driveCallback, _this);

		_this.onMessageUploadAttachments = __WEBPACK_IMPORTED_MODULE_5_____default.a.bind(_this.onMessageUploadAttachments, _this);

		_this.bDisabeCloseOnEsc = true;
		_this.sDefaultKeyScope = __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["KeyState"].Compose;

		_this.tryToClosePopup = __WEBPACK_IMPORTED_MODULE_5_____default.a.debounce(__WEBPACK_IMPORTED_MODULE_5_____default.a.bind(_this.tryToClosePopup, _this), __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["Magics"].Time200ms);

		_this.emailsSource = __WEBPACK_IMPORTED_MODULE_5_____default.a.bind(_this.emailsSource, _this);
		_this.autosaveFunction = __WEBPACK_IMPORTED_MODULE_5_____default.a.bind(_this.autosaveFunction, _this);

		_this.iTimer = 0;
		return _this;
	}

	ComposePopupView.prototype.sendCommand = function sendCommand() {

		var sTo = Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["trim"])(this.to()),
		    sCc = Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["trim"])(this.cc()),
		    sBcc = Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["trim"])(this.bcc());
		var sSentFolder = __WEBPACK_IMPORTED_MODULE_23_Stores_User_Folder__["a" /* default */].sentFolder();

		this.attachmentsInProcessError(false);
		this.attachmentsInErrorError(false);
		this.emptyToError(false);

		if (0 < this.attachmentsInProcess().length) {
			this.attachmentsInProcessError(true);
			this.attachmentsPlace(true);
		} else if (0 < this.attachmentsInError().length) {
			this.attachmentsInErrorError(true);
			this.attachmentsPlace(true);
		}

		if ('' === sTo && '' === sCc && '' === sBcc) {
			this.emptyToError(true);
		}

		if (!this.emptyToError() && !this.attachmentsInErrorError() && !this.attachmentsInProcessError()) {
			if (__WEBPACK_IMPORTED_MODULE_20_Stores_User_Settings__["a" /* default */].replySameFolder()) {
				if (Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isArray"])(this.aDraftInfo) && 3 === this.aDraftInfo.length && Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isNormal"])(this.aDraftInfo[2]) && 0 < this.aDraftInfo[2].length) {
					sSentFolder = this.aDraftInfo[2];
				}
			}

			if (!this.allowFolders) {
				sSentFolder = __WEBPACK_IMPORTED_MODULE_12_Common_Consts__["r" /* UNUSED_OPTION_VALUE */];
			}

			if ('' === sSentFolder) {
				Object(__WEBPACK_IMPORTED_MODULE_32_Knoin_Knoin__["showScreenPopup"])(__webpack_require__(/*! View/Popup/FolderSystem */ 100), [__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["SetSystemFoldersNotification"].Sent]);
			} else {
				this.sendError(false);
				this.sending(true);

				if (Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isArray"])(this.aDraftInfo) && 3 === this.aDraftInfo.length) {
					var flagsCache = Object(__WEBPACK_IMPORTED_MODULE_17_Common_Cache__["j" /* getMessageFlagsFromCache */])(this.aDraftInfo[2], this.aDraftInfo[1]);
					if (flagsCache) {
						if ('forward' === this.aDraftInfo[0]) {
							flagsCache[3] = true;
						} else {
							flagsCache[2] = true;
						}

						Object(__WEBPACK_IMPORTED_MODULE_17_Common_Cache__["t" /* setMessageFlagsToCache */])(this.aDraftInfo[2], this.aDraftInfo[1], flagsCache);
						Object(__WEBPACK_IMPORTED_MODULE_31_Helper_Apps_User__["a" /* getApp */])().reloadFlagsCurrentMessageListAndMessageFromCache();
						Object(__WEBPACK_IMPORTED_MODULE_17_Common_Cache__["q" /* setFolderHash */])(this.aDraftInfo[2], '');
					}
				}

				sSentFolder = __WEBPACK_IMPORTED_MODULE_12_Common_Consts__["r" /* UNUSED_OPTION_VALUE */] === sSentFolder ? '' : sSentFolder;

				Object(__WEBPACK_IMPORTED_MODULE_17_Common_Cache__["q" /* setFolderHash */])(this.draftFolder(), '');
				Object(__WEBPACK_IMPORTED_MODULE_17_Common_Cache__["q" /* setFolderHash */])(sSentFolder, '');

				__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax__["a" /* default */].sendMessage(this.sendMessageResponse, this.currentIdentity() ? this.currentIdentity().id() : '', this.draftFolder(), this.draftUid(), sSentFolder, sTo, this.cc(), this.bcc(), this.replyTo(), this.subject(), this.oEditor ? this.oEditor.isHtml() : false, this.oEditor ? this.oEditor.getData(true) : '', this.prepearAttachmentsForSendOrSave(), this.aDraftInfo, this.sInReplyTo, this.sReferences, this.requestDsn(), this.requestReadReceipt(), this.markAsImportant());
			}
		}
	};

	ComposePopupView.prototype.saveCommand = function saveCommand() {

		if (!this.allowFolders) {
			return false;
		}

		if (__WEBPACK_IMPORTED_MODULE_23_Stores_User_Folder__["a" /* default */].draftFolderNotEnabled()) {
			Object(__WEBPACK_IMPORTED_MODULE_32_Knoin_Knoin__["showScreenPopup"])(__webpack_require__(/*! View/Popup/FolderSystem */ 100), [__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["SetSystemFoldersNotification"].Draft]);
		} else {
			this.savedError(false);
			this.saving(true);

			this.autosaveStart();

			Object(__WEBPACK_IMPORTED_MODULE_17_Common_Cache__["q" /* setFolderHash */])(__WEBPACK_IMPORTED_MODULE_23_Stores_User_Folder__["a" /* default */].draftFolder(), '');

			__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax__["a" /* default */].saveMessage(this.saveMessageResponse, this.currentIdentity() ? this.currentIdentity().id() : '', this.draftFolder(), this.draftUid(), __WEBPACK_IMPORTED_MODULE_23_Stores_User_Folder__["a" /* default */].draftFolder(), this.to(), this.cc(), this.bcc(), this.replyTo(), this.subject(), this.oEditor ? this.oEditor.isHtml() : false, this.oEditor ? this.oEditor.getData(true) : '', this.prepearAttachmentsForSendOrSave(), this.aDraftInfo, this.sInReplyTo, this.sReferences, this.markAsImportant());
		}

		return true;
	};

	ComposePopupView.prototype.deleteCommand = function deleteCommand() {
		var _this2 = this;

		var PopupsAskViewModel = __webpack_require__(/*! View/Popup/Ask */ 77);
		if (!Object(__WEBPACK_IMPORTED_MODULE_32_Knoin_Knoin__["isPopupVisible"])(PopupsAskViewModel) && this.modalVisibility()) {
			Object(__WEBPACK_IMPORTED_MODULE_32_Knoin_Knoin__["showScreenPopup"])(PopupsAskViewModel, [Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["i18n"])('POPUPS_ASK/DESC_WANT_DELETE_MESSAGES'), function () {
				if (_this2.modalVisibility()) {
					Object(__WEBPACK_IMPORTED_MODULE_31_Helper_Apps_User__["a" /* getApp */])().deleteMessagesFromFolderWithoutCheck(_this2.draftFolder(), [_this2.draftUid()]);
					Object(__WEBPACK_IMPORTED_MODULE_32_Knoin_Knoin__["hideScreenPopup"])(ComposePopupView);
				}
			}]);
		}
	};

	ComposePopupView.prototype.skipCommand = function skipCommand() {

		this.bSkipNextHide = true;

		if (this.modalVisibility() && !this.saving() && !this.sending() && !__WEBPACK_IMPORTED_MODULE_23_Stores_User_Folder__["a" /* default */].draftFolderNotEnabled() && __WEBPACK_IMPORTED_MODULE_20_Stores_User_Settings__["a" /* default */].allowDraftAutosave()) {
			this.saveCommand();
		}

		this.tryToClosePopup();
	};

	ComposePopupView.prototype.contactsCommand = function contactsCommand() {
		var _this3 = this;

		if (this.allowContacts) {
			this.skipCommand();
			__WEBPACK_IMPORTED_MODULE_5_____default.a.delay(function () {
				Object(__WEBPACK_IMPORTED_MODULE_32_Knoin_Knoin__["showScreenPopup"])(__webpack_require__(/*! View/Popup/Contacts */ 181), [true, _this3.sLastFocusedField]);
			}, __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["Magics"].Time200ms);
		}
	};

	ComposePopupView.prototype.dropboxCommand = function dropboxCommand() {
		var _this4 = this;

		if (__WEBPACK_IMPORTED_MODULE_4_window___default.a.Dropbox) {
			__WEBPACK_IMPORTED_MODULE_4_window___default.a.Dropbox.choose({
				success: function success(files) {
					if (files && files[0] && files[0].link) {
						_this4.addDropboxAttachment(files[0]);
					}
				},
				linkType: 'direct',
				multiselect: false
			});
		}
		return true;
	};

	ComposePopupView.prototype.driveCommand = function driveCommand() {
		this.driveOpenPopup();
		return true;
	};

	ComposePopupView.prototype.autosaveFunction = function autosaveFunction() {
		if (this.modalVisibility() && !__WEBPACK_IMPORTED_MODULE_23_Stores_User_Folder__["a" /* default */].draftFolderNotEnabled() && __WEBPACK_IMPORTED_MODULE_20_Stores_User_Settings__["a" /* default */].allowDraftAutosave() && !this.isEmptyForm(false) && !this.saving() && !this.sending() && !this.savedError()) {
			this.saveCommand();
		}

		this.autosaveStart();
	};

	ComposePopupView.prototype.autosaveStart = function autosaveStart() {
		__WEBPACK_IMPORTED_MODULE_4_window___default.a.clearTimeout(this.iTimer);
		this.iTimer = __WEBPACK_IMPORTED_MODULE_4_window___default.a.setTimeout(this.autosaveFunction, __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["Magics"].Time1m);
	};

	ComposePopupView.prototype.autosaveStop = function autosaveStop() {
		__WEBPACK_IMPORTED_MODULE_4_window___default.a.clearTimeout(this.iTimer);
	};

	ComposePopupView.prototype.emailsSource = function emailsSource(oData, fResponse) {
		Object(__WEBPACK_IMPORTED_MODULE_31_Helper_Apps_User__["a" /* getApp */])().getAutocomplete(oData.term, function (aData) {
			fResponse(__WEBPACK_IMPORTED_MODULE_5_____default.a.map(aData, function (oEmailItem) {
				return oEmailItem.toLine(false);
			}));
		});
	};

	ComposePopupView.prototype.openOpenPgpPopup = function openOpenPgpPopup() {
		var _this5 = this;

		if (__WEBPACK_IMPORTED_MODULE_24_Stores_User_Pgp__["a" /* default */].capaOpenPGP() && this.oEditor && !this.oEditor.isHtml()) {
			Object(__WEBPACK_IMPORTED_MODULE_32_Knoin_Knoin__["showScreenPopup"])(__webpack_require__(/*! View/Popup/ComposeOpenPgp */ 236), [function (result) {
				_this5.editor(function (editor) {
					editor.setPlain(result);
				});
			}, this.oEditor.getData(false), this.currentIdentity(), this.to(), this.cc(), this.bcc()]);
		}
	};

	ComposePopupView.prototype.reloadDraftFolder = function reloadDraftFolder() {
		var draftFolder = __WEBPACK_IMPORTED_MODULE_23_Stores_User_Folder__["a" /* default */].draftFolder();
		if ('' !== draftFolder && __WEBPACK_IMPORTED_MODULE_12_Common_Consts__["r" /* UNUSED_OPTION_VALUE */] !== draftFolder) {
			Object(__WEBPACK_IMPORTED_MODULE_17_Common_Cache__["q" /* setFolderHash */])(draftFolder, '');
			if (__WEBPACK_IMPORTED_MODULE_23_Stores_User_Folder__["a" /* default */].currentFolderFullNameRaw() === draftFolder) {
				Object(__WEBPACK_IMPORTED_MODULE_31_Helper_Apps_User__["a" /* getApp */])().reloadMessageList(true);
			} else {
				Object(__WEBPACK_IMPORTED_MODULE_31_Helper_Apps_User__["a" /* getApp */])().folderInformation(draftFolder);
			}
		}
	};

	ComposePopupView.prototype.findIdentityByMessage = function findIdentityByMessage(composeType, message) {

		var resultIndex = 1000,
		    resultIdentity = null;
		var identities = __WEBPACK_IMPORTED_MODULE_21_Stores_User_Identity__["a" /* default */].identities(),
		    identitiesCache = {},
		    fEachHelper = function fEachHelper(item) {
			if (item && item.email && identitiesCache[item.email]) {
				if (!resultIdentity || resultIndex > identitiesCache[item.email][1]) {
					resultIdentity = identitiesCache[item.email][0];
					resultIndex = identitiesCache[item.email][1];
				}
			}
		};

		__WEBPACK_IMPORTED_MODULE_5_____default.a.each(identities, function (item, index) {
			identitiesCache[item.email()] = [item, index];
		});

		if (message) {
			switch (composeType) {
				case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].Empty:
					break;
				case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].Reply:
				case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].ReplyAll:
				case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].Forward:
				case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].ForwardAsAttachment:
					__WEBPACK_IMPORTED_MODULE_5_____default.a.each(__WEBPACK_IMPORTED_MODULE_5_____default.a.union(message.to, message.cc, message.bcc), fEachHelper);
					if (!resultIdentity) {
						__WEBPACK_IMPORTED_MODULE_5_____default.a.each(message.deliveredTo, fEachHelper);
					}
					break;
				case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].Draft:
					__WEBPACK_IMPORTED_MODULE_5_____default.a.each(__WEBPACK_IMPORTED_MODULE_5_____default.a.union(message.from, message.replyTo), fEachHelper);
					break;
				// no default
			}
		}

		return resultIdentity || identities[0] || null;
	};

	ComposePopupView.prototype.selectIdentity = function selectIdentity(identity) {
		if (identity && identity.item) {
			this.currentIdentity(identity.item);
			this.setSignatureFromIdentity(identity.item);
		}
	};

	ComposePopupView.prototype.sendMessageResponse = function sendMessageResponse(statusResult, data) {
		var result = false,
		    message = '';

		this.sending(false);

		if (__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["StorageResultType"].Success === statusResult && data && data.Result) {
			result = true;
			if (this.modalVisibility()) {
				Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["delegateRun"])(this, 'closeCommand');
			}
		}

		if (this.modalVisibility() && !result) {
			if (data && __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["Notification"].CantSaveMessage === data.ErrorCode) {
				this.sendSuccessButSaveError(true);
				this.savedErrorDesc(Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["trim"])(Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["i18n"])('COMPOSE/SAVED_ERROR_ON_SEND')));
			} else {
				message = Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["getNotification"])(data && data.ErrorCode ? data.ErrorCode : __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["Notification"].CantSendMessage, data && data.ErrorMessage ? data.ErrorMessage : '');

				this.sendError(true);
				this.sendErrorDesc(message || Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["getNotification"])(__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["Notification"].CantSendMessage));
			}
		}

		this.reloadDraftFolder();
	};

	ComposePopupView.prototype.saveMessageResponse = function saveMessageResponse(statusResult, oData) {

		var result = false;

		this.saving(false);

		if (__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["StorageResultType"].Success === statusResult && oData && oData.Result) {
			if (oData.Result.NewFolder && oData.Result.NewUid) {
				result = true;

				if (this.bFromDraft) {
					var message = __WEBPACK_IMPORTED_MODULE_25_Stores_User_Message__["a" /* default */].message();
					if (message && this.draftFolder() === message.folderFullNameRaw && this.draftUid() === message.uid) {
						__WEBPACK_IMPORTED_MODULE_25_Stores_User_Message__["a" /* default */].message(null);
					}
				}

				this.draftFolder(oData.Result.NewFolder);
				this.draftUid(oData.Result.NewUid);

				this.savedTime(__WEBPACK_IMPORTED_MODULE_4_window___default.a.Math.round(new __WEBPACK_IMPORTED_MODULE_4_window___default.a.Date().getTime() / 1000));

				if (this.bFromDraft) {
					Object(__WEBPACK_IMPORTED_MODULE_17_Common_Cache__["q" /* setFolderHash */])(this.draftFolder(), '');
				}
			}
		}

		if (!result) {
			this.savedError(true);
			this.savedErrorDesc(Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["getNotification"])(__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["Notification"].CantSaveMessage));
		}

		this.reloadDraftFolder();
	};

	ComposePopupView.prototype.onHide = function onHide() {
		this.autosaveStop();

		if (!this.bSkipNextHide) {
			__WEBPACK_IMPORTED_MODULE_19_Stores_User_App__["a" /* default */].composeInEdit(false);
			this.reset();
		}

		this.bSkipNextHide = false;

		this.to.focused(false);

		Object(__WEBPACK_IMPORTED_MODULE_32_Knoin_Knoin__["routeOn"])();
	};

	ComposePopupView.prototype.editor = function editor(fOnInit) {
		var _this6 = this;

		if (fOnInit) {
			if (!this.oEditor && this.composeEditorArea()) {
				// _.delay(() => {
				this.oEditor = new __WEBPACK_IMPORTED_MODULE_18_Common_HtmlEditor__["HtmlEditor"](this.composeEditorArea(), null, function () {
					fOnInit(_this6.oEditor);
					_this6.resizerTrigger();
				}, function (bHtml) {
					_this6.isHtml(!!bHtml);
				});
				// }, 1000);
			} else if (this.oEditor) {
				fOnInit(this.oEditor);
				this.resizerTrigger();
			}
		}
	};

	ComposePopupView.prototype.converSignature = function converSignature(signature) {
		var limit = 10,
		    fromLine = '';

		var moments = [],
		    momentRegx = /{{MOMENT:([^}]+)}}/g;

		signature = signature.replace(/[\r]/g, '');

		fromLine = this.oLastMessage ? this.emailArrayToStringLineHelper(this.oLastMessage.from, true) : '';
		if ('' !== fromLine) {
			signature = signature.replace(/{{FROM-FULL}}/g, fromLine);

			if (-1 === fromLine.indexOf(' ') && 0 < fromLine.indexOf('@')) {
				fromLine = fromLine.replace(/@[\S]+/, '');
			}

			signature = signature.replace(/{{FROM}}/g, fromLine);
		}

		signature = signature.replace(/[\s]{1,2}{{FROM}}/g, '{{FROM}}');
		signature = signature.replace(/[\s]{1,2}{{FROM-FULL}}/g, '{{FROM-FULL}}');

		signature = signature.replace(/{{FROM}}/g, '');
		signature = signature.replace(/{{FROM-FULL}}/g, '');

		if (-1 < signature.indexOf('{{DATE}}')) {
			signature = signature.replace(/{{DATE}}/g, Object(__WEBPACK_IMPORTED_MODULE_16_Common_Momentor__["format"])(0, 'llll'));
		}

		if (-1 < signature.indexOf('{{TIME}}')) {
			signature = signature.replace(/{{TIME}}/g, Object(__WEBPACK_IMPORTED_MODULE_16_Common_Momentor__["format"])(0, 'LT'));
		}
		if (-1 < signature.indexOf('{{MOMENT:')) {
			try {
				var match = null;
				while (null !== (match = momentRegx.exec(signature))) // eslint-disable-line no-cond-assign
				{
					if (match && match[0] && match[1]) {
						moments.push([match[0], match[1]]);
					}

					limit -= 1;
					if (0 === limit) {
						break;
					}
				}

				if (moments && 0 < moments.length) {
					__WEBPACK_IMPORTED_MODULE_5_____default.a.each(moments, function (data) {
						signature = signature.replace(data[0], Object(__WEBPACK_IMPORTED_MODULE_16_Common_Momentor__["format"])(0, data[1]));
					});
				}

				signature = signature.replace(/{{MOMENT:[^}]+}}/g, '');
			} catch (e) {} // eslint-disable-line no-empty
		}

		return signature;
	};

	ComposePopupView.prototype.setSignatureFromIdentity = function setSignatureFromIdentity(identity) {
		var _this7 = this;

		if (identity) {
			this.editor(function (editor) {
				var isHtml = false,
				    signature = identity.signature();

				if ('' !== signature) {
					if (':HTML:' === signature.substr(0, 6)) {
						isHtml = true;
						signature = signature.substr(6);
					}
				}

				editor.setSignature(_this7.converSignature(signature), isHtml, !!identity.signatureInsertBefore());
			});
		}
	};

	/**
  * @param {string=} type = ComposeType.Empty
  * @param {?MessageModel|Array=} oMessageOrArray = null
  * @param {Array=} aToEmails = null
  * @param {Array=} aCcEmails = null
  * @param {Array=} aBccEmails = null
  * @param {string=} sCustomSubject = null
  * @param {string=} sCustomPlainText = null
  */


	ComposePopupView.prototype.onShow = function onShow(type, oMessageOrArray, aToEmails, aCcEmails, aBccEmails, sCustomSubject, sCustomPlainText) {
		var _this8 = this;

		Object(__WEBPACK_IMPORTED_MODULE_32_Knoin_Knoin__["routeOff"])();

		this.autosaveStart();

		if (__WEBPACK_IMPORTED_MODULE_19_Stores_User_App__["a" /* default */].composeInEdit()) {
			type = type || __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].Empty;
			if (__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].Empty !== type) {
				Object(__WEBPACK_IMPORTED_MODULE_32_Knoin_Knoin__["showScreenPopup"])(__webpack_require__(/*! View/Popup/Ask */ 77), [Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["i18n"])('COMPOSE/DISCARD_UNSAVED_DATA'), function () {
					_this8.initOnShow(type, oMessageOrArray, aToEmails, aCcEmails, aBccEmails, sCustomSubject, sCustomPlainText);
				}, null, null, null, false]);
			} else {
				this.addEmailsTo(this.to, aToEmails);
				this.addEmailsTo(this.cc, aCcEmails);
				this.addEmailsTo(this.bcc, aBccEmails);

				if (Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isNormal"])(sCustomSubject) && '' !== sCustomSubject && '' === this.subject()) {
					this.subject(sCustomSubject);
				}
			}
		} else {
			this.initOnShow(type, oMessageOrArray, aToEmails, aCcEmails, aBccEmails, sCustomSubject, sCustomPlainText);
		}
	};

	ComposePopupView.prototype.onWarmUp = function onWarmUp() {
		if (this.modalVisibility && !this.modalVisibility()) {
			this.editor(function (editor) {
				return editor.modeToggle(false);
			});
		}
	};

	/**
  * @param {Function} fKoValue
  * @param {Array} emails
  */


	ComposePopupView.prototype.addEmailsTo = function addEmailsTo(fKoValue, emails) {
		if (Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isNonEmptyArray"])(emails)) {
			var value = Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["trim"])(fKoValue()),
			    values = __WEBPACK_IMPORTED_MODULE_5_____default.a.uniq(__WEBPACK_IMPORTED_MODULE_5_____default.a.compact(__WEBPACK_IMPORTED_MODULE_5_____default.a.map(emails, function (item) {
				return item ? item.toLine(false) : null;
			})));

			fKoValue(value + ('' === value ? '' : ', ') + Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["trim"])(values.join(', ')));
		}
	};

	/**
  *
  * @param {Array} aList
  * @param {boolean} bFriendly
  * @returns {string}
  */


	ComposePopupView.prototype.emailArrayToStringLineHelper = function emailArrayToStringLineHelper(aList, bFriendly) {
		bFriendly = !!bFriendly;
		return __WEBPACK_IMPORTED_MODULE_5_____default.a.map(aList, function (item) {
			return item.toLine(bFriendly);
		}).join(', ');
	};

	/**
  * @param {string=} sType = ComposeType.Empty
  * @param {?MessageModel|Array=} oMessageOrArray = null
  * @param {Array=} aToEmails = null
  * @param {Array=} aCcEmails = null
  * @param {Array=} aBccEmails = null
  * @param {string=} sCustomSubject = null
  * @param {string=} sCustomPlainText = null
  */


	ComposePopupView.prototype.initOnShow = function initOnShow(sType, oMessageOrArray, aToEmails, aCcEmails, aBccEmails, sCustomSubject, sCustomPlainText) {
		var _this9 = this;

		__WEBPACK_IMPORTED_MODULE_19_Stores_User_App__["a" /* default */].composeInEdit(true);

		var sFrom = '',
		    sTo = '',
		    sCc = '',
		    sDate = '',
		    sSubject = '',
		    sText = '',
		    sReplyTitle = '',
		    identity = null,
		    aDraftInfo = null,
		    message = null;

		var excludeEmail = {},
		    mEmail = __WEBPACK_IMPORTED_MODULE_22_Stores_User_Account__["a" /* default */].email(),
		    lineComposeType = sType || __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].Empty;

		oMessageOrArray = oMessageOrArray || null;
		if (oMessageOrArray && Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isNormal"])(oMessageOrArray)) {
			message = Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isArray"])(oMessageOrArray) && 1 === oMessageOrArray.length ? oMessageOrArray[0] : !Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isArray"])(oMessageOrArray) ? oMessageOrArray : null;
		}

		this.oLastMessage = message;

		if (null !== mEmail) {
			excludeEmail[mEmail] = true;
		}

		this.reset();

		identity = this.findIdentityByMessage(lineComposeType, message);
		if (identity) {
			excludeEmail[identity.email()] = true;
		}

		if (Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isNonEmptyArray"])(aToEmails)) {
			this.to(this.emailArrayToStringLineHelper(aToEmails));
		}

		if (Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isNonEmptyArray"])(aCcEmails)) {
			this.cc(this.emailArrayToStringLineHelper(aCcEmails));
		}

		if (Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isNonEmptyArray"])(aBccEmails)) {
			this.bcc(this.emailArrayToStringLineHelper(aBccEmails));
		}

		if ('' !== lineComposeType && message) {
			sDate = Object(__WEBPACK_IMPORTED_MODULE_16_Common_Momentor__["format"])(message.dateTimeStampInUTC(), 'FULL');
			sSubject = message.subject();
			aDraftInfo = message.aDraftInfo;

			var clonedText = __WEBPACK_IMPORTED_MODULE_6_____default()(message.body).clone();
			if (clonedText) {
				Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["clearBqSwitcher"])(clonedText);

				sText = clonedText.html();
			}

			var resplyAllParts = null;
			switch (lineComposeType) {
				case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].Empty:
					break;

				case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].Reply:
					this.to(this.emailArrayToStringLineHelper(message.replyEmails(excludeEmail)));
					this.subject(Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["replySubjectAdd"])('Re', sSubject));
					this.prepearMessageAttachments(message, lineComposeType);
					this.aDraftInfo = ['reply', message.uid, message.folderFullNameRaw];
					this.sInReplyTo = message.sMessageId;
					this.sReferences = Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["trim"])(this.sInReplyTo + ' ' + message.sReferences);
					break;

				case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].ReplyAll:
					resplyAllParts = message.replyAllEmails(excludeEmail);
					this.to(this.emailArrayToStringLineHelper(resplyAllParts[0]));
					this.cc(this.emailArrayToStringLineHelper(resplyAllParts[1]));
					this.subject(Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["replySubjectAdd"])('Re', sSubject));
					this.prepearMessageAttachments(message, lineComposeType);
					this.aDraftInfo = ['reply', message.uid, message.folderFullNameRaw];
					this.sInReplyTo = message.sMessageId;
					this.sReferences = Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["trim"])(this.sInReplyTo + ' ' + message.references());
					break;

				case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].Forward:
					this.subject(Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["replySubjectAdd"])('Fwd', sSubject));
					this.prepearMessageAttachments(message, lineComposeType);
					this.aDraftInfo = ['forward', message.uid, message.folderFullNameRaw];
					this.sInReplyTo = message.sMessageId;
					this.sReferences = Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["trim"])(this.sInReplyTo + ' ' + message.sReferences);
					break;

				case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].ForwardAsAttachment:
					this.subject(Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["replySubjectAdd"])('Fwd', sSubject));
					this.prepearMessageAttachments(message, lineComposeType);
					this.aDraftInfo = ['forward', message.uid, message.folderFullNameRaw];
					this.sInReplyTo = message.sMessageId;
					this.sReferences = Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["trim"])(this.sInReplyTo + ' ' + message.sReferences);
					break;

				case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].Draft:
					this.to(this.emailArrayToStringLineHelper(message.to));
					this.cc(this.emailArrayToStringLineHelper(message.cc));
					this.bcc(this.emailArrayToStringLineHelper(message.bcc));
					this.replyTo(this.emailArrayToStringLineHelper(message.replyTo));

					this.bFromDraft = true;

					this.draftFolder(message.folderFullNameRaw);
					this.draftUid(message.uid);

					this.subject(sSubject);
					this.prepearMessageAttachments(message, lineComposeType);

					this.aDraftInfo = Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isNonEmptyArray"])(aDraftInfo) && 3 === aDraftInfo.length ? aDraftInfo : null;
					this.sInReplyTo = message.sInReplyTo;
					this.sReferences = message.sReferences;
					break;

				case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].EditAsNew:
					this.to(this.emailArrayToStringLineHelper(message.to));
					this.cc(this.emailArrayToStringLineHelper(message.cc));
					this.bcc(this.emailArrayToStringLineHelper(message.bcc));
					this.replyTo(this.emailArrayToStringLineHelper(message.replyTo));

					this.subject(sSubject);
					this.prepearMessageAttachments(message, lineComposeType);

					this.aDraftInfo = Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isNonEmptyArray"])(aDraftInfo) && 3 === aDraftInfo.length ? aDraftInfo : null;
					this.sInReplyTo = message.sInReplyTo;
					this.sReferences = message.sReferences;
					break;
				// no default
			}

			switch (lineComposeType) {
				case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].Reply:
				case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].ReplyAll:
					sFrom = message.fromToLine(false, true);
					sReplyTitle = Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["i18n"])('COMPOSE/REPLY_MESSAGE_TITLE', {
						'DATETIME': sDate,
						'EMAIL': sFrom
					});

					sText = '<br /><br />' + sReplyTitle + ':' + '<br /><br />' + '<blockquote>' + Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["trim"])(sText) + '</blockquote>';

					break;

				case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].Forward:
					sFrom = message.fromToLine(false, true);
					sTo = message.toToLine(false, true);
					sCc = message.ccToLine(false, true);
					sText = '<br /><br />' + Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["i18n"])('COMPOSE/FORWARD_MESSAGE_TOP_TITLE') + '<br />' + Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["i18n"])('COMPOSE/FORWARD_MESSAGE_TOP_FROM') + ': ' + sFrom + '<br />' + Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["i18n"])('COMPOSE/FORWARD_MESSAGE_TOP_TO') + ': ' + sTo + (0 < sCc.length ? '<br />' + Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["i18n"])('COMPOSE/FORWARD_MESSAGE_TOP_CC') + ': ' + sCc : '') + '<br />' + Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["i18n"])('COMPOSE/FORWARD_MESSAGE_TOP_SENT') + ': ' + Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["encodeHtml"])(sDate) + '<br />' + Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["i18n"])('COMPOSE/FORWARD_MESSAGE_TOP_SUBJECT') + ': ' + Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["encodeHtml"])(sSubject) + '<br /><br />' + Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["trim"])(sText) + '<br /><br />';
					break;

				case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].ForwardAsAttachment:
					sText = '';
					break;
				// no default
			}

			this.editor(function (editor) {

				editor.setHtml(sText, false);

				if (__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["EditorDefaultType"].PlainForced === _this9.editorDefaultType() || !message.isHtml() && __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["EditorDefaultType"].HtmlForced !== _this9.editorDefaultType()) {
					editor.modeToggle(false);
				}

				if (identity && __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].Draft !== lineComposeType && __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].EditAsNew !== lineComposeType) {
					_this9.setSignatureFromIdentity(identity);
				}

				_this9.setFocusInPopup();
			});
		} else if (__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].Empty === lineComposeType) {
			this.subject(Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isNormal"])(sCustomSubject) ? '' + sCustomSubject : '');

			sText = Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isNormal"])(sCustomPlainText) ? '' + sCustomPlainText : '';

			this.editor(function (editor) {

				editor.setHtml(sText, false);

				if (__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["EditorDefaultType"].Html !== _this9.editorDefaultType() && __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["EditorDefaultType"].HtmlForced !== _this9.editorDefaultType()) {
					editor.modeToggle(false);
				}

				if (identity) {
					_this9.setSignatureFromIdentity(identity);
				}

				_this9.setFocusInPopup();
			});
		} else if (Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isNonEmptyArray"])(oMessageOrArray)) {
			__WEBPACK_IMPORTED_MODULE_5_____default.a.each(oMessageOrArray, function (item) {
				_this9.addMessageAsAttachment(item);
			});

			this.editor(function (editor) {

				editor.setHtml('', false);

				if (__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["EditorDefaultType"].Html !== _this9.editorDefaultType() && __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["EditorDefaultType"].HtmlForced !== _this9.editorDefaultType()) {
					editor.modeToggle(false);
				}

				if (identity && __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].Draft !== lineComposeType && __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].EditAsNew !== lineComposeType) {
					_this9.setSignatureFromIdentity(identity);
				}

				_this9.setFocusInPopup();
			});
		} else {
			this.setFocusInPopup();
		}

		var downloads = this.getAttachmentsDownloadsForUpload();
		if (Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isNonEmptyArray"])(downloads)) {
			__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax__["a" /* default */].messageUploadAttachments(this.onMessageUploadAttachments, downloads);
		}

		if (identity) {
			this.currentIdentity(identity);
		}

		this.resizerTrigger();
	};

	ComposePopupView.prototype.onMessageUploadAttachments = function onMessageUploadAttachments(sResult, oData) {
		var _this10 = this;

		if (__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["StorageResultType"].Success === sResult && oData && oData.Result) {
			if (!this.viewModelVisibility()) {
				__WEBPACK_IMPORTED_MODULE_5_____default.a.each(oData.Result, function (id, tempName) {
					var attachment = _this10.getAttachmentById(id);
					if (attachment) {
						attachment.tempName(tempName);
						attachment.waiting(false).uploading(false).complete(true);
					}
				});
			}
		} else {
			this.setMessageAttachmentFailedDownloadText();
		}
	};

	ComposePopupView.prototype.setFocusInPopup = function setFocusInPopup() {
		var _this11 = this;

		if (!__WEBPACK_IMPORTED_MODULE_13_Common_Globals__["bMobileDevice"]) {
			__WEBPACK_IMPORTED_MODULE_5_____default.a.delay(function () {

				if ('' === _this11.to()) {
					_this11.to.focused(true);
				} else if (_this11.oEditor) {
					if (!_this11.to.focused()) {
						_this11.oEditor.focus();
					}
				}
			}, __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["Magics"].Time100ms);
		}
	};

	ComposePopupView.prototype.onShowWithDelay = function onShowWithDelay() {
		this.resizerTrigger();
	};

	ComposePopupView.prototype.tryToClosePopup = function tryToClosePopup() {
		var _this12 = this;

		var PopupsAskViewModel = __webpack_require__(/*! View/Popup/Ask */ 77);
		if (!Object(__WEBPACK_IMPORTED_MODULE_32_Knoin_Knoin__["isPopupVisible"])(PopupsAskViewModel) && this.modalVisibility()) {
			if (this.bSkipNextHide || this.isEmptyForm() && !this.draftUid()) {
				Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["delegateRun"])(this, 'closeCommand');
			} else {
				Object(__WEBPACK_IMPORTED_MODULE_32_Knoin_Knoin__["showScreenPopup"])(PopupsAskViewModel, [Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["i18n"])('POPUPS_ASK/DESC_WANT_CLOSE_THIS_WINDOW'), function () {
					if (_this12.modalVisibility()) {
						Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["delegateRun"])(_this12, 'closeCommand');
					}
				}]);
			}
		}
	};

	ComposePopupView.prototype.onBuild = function onBuild() {
		var _this13 = this;

		this.initUploader();

		__WEBPACK_IMPORTED_MODULE_8_key___default()('ctrl+q, command+q, ctrl+w, command+w', __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["KeyState"].Compose, __WEBPACK_IMPORTED_MODULE_11_Common_Utils__["noopFalse"]);

		__WEBPACK_IMPORTED_MODULE_8_key___default()('`', __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["KeyState"].Compose, function () {
			if (_this13.oEditor && !_this13.oEditor.hasFocus() && !Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["inFocus"])()) {
				_this13.identitiesDropdownTrigger(true);
				return false;
			}

			return true;
		});

		__WEBPACK_IMPORTED_MODULE_8_key___default()('ctrl+`', __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["KeyState"].Compose, function () {
			_this13.identitiesDropdownTrigger(true);
			return false;
		});

		__WEBPACK_IMPORTED_MODULE_8_key___default()('esc, ctrl+down, command+down', __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["KeyState"].Compose, function () {
			_this13.skipCommand();
			return false;
		});

		if (this.allowFolders) {
			__WEBPACK_IMPORTED_MODULE_8_key___default()('ctrl+s, command+s', __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["KeyState"].Compose, function () {
				_this13.saveCommand();
				return false;
			});
		}

		if (__WEBPACK_IMPORTED_MODULE_28_Storage_Settings__["appSettingsGet"]('allowCtrlEnterOnCompose')) {
			__WEBPACK_IMPORTED_MODULE_8_key___default()('ctrl+enter, command+enter', __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["KeyState"].Compose, function () {
				_this13.sendCommand();
				return false;
			});
		}

		__WEBPACK_IMPORTED_MODULE_8_key___default()('shift+esc', __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["KeyState"].Compose, function () {
			if (_this13.modalVisibility()) {
				_this13.tryToClosePopup();
			}
			return false;
		});

		__WEBPACK_IMPORTED_MODULE_29_Common_Events__["b" /* sub */]('window.resize.real', this.resizerTrigger);
		__WEBPACK_IMPORTED_MODULE_29_Common_Events__["b" /* sub */]('window.resize.real', __WEBPACK_IMPORTED_MODULE_5_____default.a.debounce(this.resizerTrigger, __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["Magics"].Time50ms));

		__WEBPACK_IMPORTED_MODULE_26_Stores_Social__["a" /* default */].appendDropbox();

		if (this.driveEnabled()) {
			__WEBPACK_IMPORTED_MODULE_6_____default.a.getScript('https://apis.google.com/js/api.js', function () {
				if (__WEBPACK_IMPORTED_MODULE_4_window___default.a.gapi) {
					_this13.driveVisible(true);
				}
			});
		}

		__WEBPACK_IMPORTED_MODULE_4_window___default.a.setInterval(function () {
			if (_this13.modalVisibility() && _this13.oEditor) {
				_this13.oEditor.resize();
			}
		}, __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["Magics"].Time5s);
	};

	ComposePopupView.prototype.driveCallback = function driveCallback(accessToken, data) {
		var _this14 = this;

		if (data && __WEBPACK_IMPORTED_MODULE_4_window___default.a.XMLHttpRequest && __WEBPACK_IMPORTED_MODULE_4_window___default.a.google && data[__WEBPACK_IMPORTED_MODULE_4_window___default.a.google.picker.Response.ACTION] === __WEBPACK_IMPORTED_MODULE_4_window___default.a.google.picker.Action.PICKED && data[__WEBPACK_IMPORTED_MODULE_4_window___default.a.google.picker.Response.DOCUMENTS] && data[__WEBPACK_IMPORTED_MODULE_4_window___default.a.google.picker.Response.DOCUMENTS][0] && data[__WEBPACK_IMPORTED_MODULE_4_window___default.a.google.picker.Response.DOCUMENTS][0].id) {
			var request = new __WEBPACK_IMPORTED_MODULE_4_window___default.a.XMLHttpRequest();
			request.open('GET', 'https://www.googleapis.com/drive/v2/files/' + data[__WEBPACK_IMPORTED_MODULE_4_window___default.a.google.picker.Response.DOCUMENTS][0].id);
			request.setRequestHeader('Authorization', 'Bearer ' + accessToken);
			request.addEventListener('load', function () {
				if (request && request.responseText) {
					var response = __WEBPACK_IMPORTED_MODULE_4_window___default.a.JSON.parse(request.responseText),
					    fExport = function fExport(item, mimeType, ext) {
						if (item && item.exportLinks) {
							if (item.exportLinks[mimeType]) {
								response.downloadUrl = item.exportLinks[mimeType];
								response.title = item.title + '.' + ext;
								response.mimeType = mimeType;
							} else if (item.exportLinks['application/pdf']) {
								response.downloadUrl = item.exportLinks['application/pdf'];
								response.title = item.title + '.pdf';
								response.mimeType = 'application/pdf';
							}
						}
					};

					if (response && !response.downloadUrl && response.mimeType && response.exportLinks) {
						switch (response.mimeType.toString().toLowerCase()) {
							case 'application/vnd.google-apps.document':
								fExport(response, 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'docx');
								break;
							case 'application/vnd.google-apps.spreadsheet':
								fExport(response, 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'xlsx');
								break;
							case 'application/vnd.google-apps.drawing':
								fExport(response, 'image/png', 'png');
								break;
							case 'application/vnd.google-apps.presentation':
								fExport(response, 'application/vnd.openxmlformats-officedocument.presentationml.presentation', 'pptx');
								break;
							default:
								fExport(response, 'application/pdf', 'pdf');
								break;
						}
					}

					if (response && response.downloadUrl) {
						_this14.addDriveAttachment(response, accessToken);
					}
				}
			});

			request.send();
		}
	};

	ComposePopupView.prototype.driveCreatePiker = function driveCreatePiker(authToken) {
		var _this15 = this;

		if (__WEBPACK_IMPORTED_MODULE_4_window___default.a.gapi && authToken && authToken.access_token) {
			__WEBPACK_IMPORTED_MODULE_4_window___default.a.gapi.load('picker', {
				callback: function callback() {
					if (__WEBPACK_IMPORTED_MODULE_4_window___default.a.google && __WEBPACK_IMPORTED_MODULE_4_window___default.a.google.picker) {
						var drivePicker = new __WEBPACK_IMPORTED_MODULE_4_window___default.a.google.picker.PickerBuilder()
						// .addView(window.google.picker.ViewId.FOLDERS)
						.addView(__WEBPACK_IMPORTED_MODULE_4_window___default.a.google.picker.ViewId.DOCS).setAppId(__WEBPACK_IMPORTED_MODULE_28_Storage_Settings__["settingsGet"]('GoogleClientID')).setOAuthToken(authToken.access_token).setCallback(__WEBPACK_IMPORTED_MODULE_5_____default.a.bind(_this15.driveCallback, _this15, authToken.access_token)).enableFeature(__WEBPACK_IMPORTED_MODULE_4_window___default.a.google.picker.Feature.NAV_HIDDEN)
						// .setOrigin(window.location.protocol + '//' + window.location.host)
						.build();

						drivePicker.setVisible(true);
					}
				}
			});
		}
	};

	ComposePopupView.prototype.driveOpenPopup = function driveOpenPopup() {
		var _this16 = this;

		if (__WEBPACK_IMPORTED_MODULE_4_window___default.a.gapi) {
			__WEBPACK_IMPORTED_MODULE_4_window___default.a.gapi.load('auth', {
				callback: function callback() {
					var authToken = __WEBPACK_IMPORTED_MODULE_4_window___default.a.gapi.auth.getToken(),
					    fResult = function fResult(authResult) {
						if (authResult && !authResult.error) {
							var token = __WEBPACK_IMPORTED_MODULE_4_window___default.a.gapi.auth.getToken();
							if (token) {
								_this16.driveCreatePiker(token);
							}

							return true;
						}

						return false;
					};

					if (!authToken) {
						__WEBPACK_IMPORTED_MODULE_4_window___default.a.gapi.auth.authorize({
							'client_id': __WEBPACK_IMPORTED_MODULE_28_Storage_Settings__["settingsGet"]('GoogleClientID'),
							'scope': 'https://www.googleapis.com/auth/drive.readonly',
							'immediate': true
						}, function (authResult) {
							if (!fResult(authResult)) {
								__WEBPACK_IMPORTED_MODULE_4_window___default.a.gapi.auth.authorize({
									'client_id': __WEBPACK_IMPORTED_MODULE_28_Storage_Settings__["settingsGet"]('GoogleClientID'),
									'scope': 'https://www.googleapis.com/auth/drive.readonly',
									'immediate': false
								}, fResult);
							}
						});
					} else {
						_this16.driveCreatePiker(authToken);
					}
				}
			});
		}
	};

	/**
  * @param {string} id
  * @returns {?Object}
  */


	ComposePopupView.prototype.getAttachmentById = function getAttachmentById(id) {
		return __WEBPACK_IMPORTED_MODULE_5_____default.a.find(this.attachments(), function (item) {
			return item && id === item.id;
		});
	};

	ComposePopupView.prototype.cancelAttachmentHelper = function cancelAttachmentHelper(id, oJua) {
		var _this17 = this;

		return function () {
			var attachment = __WEBPACK_IMPORTED_MODULE_5_____default.a.find(_this17.attachments(), function (item) {
				return item && item.id === id;
			});
			if (attachment) {
				_this17.attachments.remove(attachment);
				Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["delegateRunOnDestroy"])(attachment);

				if (oJua) {
					oJua.cancel(id);
				}
			}
		};
	};

	ComposePopupView.prototype.initUploader = function initUploader() {
		var _this18 = this;

		if (this.composeUploaderButton()) {
			var uploadCache = {},
			    attachmentSizeLimit = Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["pInt"])(__WEBPACK_IMPORTED_MODULE_28_Storage_Settings__["settingsGet"]('AttachmentLimit')),
			    oJua = new __WEBPACK_IMPORTED_MODULE_9_Jua___default.a({
				'action': Object(__WEBPACK_IMPORTED_MODULE_14_Common_Links__["G" /* upload */])(),
				'name': 'uploader',
				'queueSize': 2,
				'multipleSizeLimit': 50,
				'clickElement': this.composeUploaderButton(),
				'dragAndDropElement': this.composeUploaderDropPlace()
			});

			if (oJua) {
				oJua
				// .on('onLimitReached', (limit) => {
				// 	alert(limit);
				// })
				.on('onDragEnter', function () {
					_this18.dragAndDropOver(true);
				}).on('onDragLeave', function () {
					_this18.dragAndDropOver(false);
				}).on('onBodyDragEnter', function () {
					_this18.attachmentsPlace(true);
					_this18.dragAndDropVisible(true);
				}).on('onBodyDragLeave', function () {
					_this18.dragAndDropVisible(false);
				}).on('onProgress', function (id, loaded, total) {

					var item = uploadCache[id];
					if (!item) {
						item = _this18.getAttachmentById(id);
						if (item) {
							uploadCache[id] = item;
						}
					}

					if (item) {
						item.progress(__WEBPACK_IMPORTED_MODULE_4_window___default.a.Math.floor(loaded / total * 100));
					}
				}).on('onSelect', function (sId, oData) {

					_this18.dragAndDropOver(false);

					var fileName = Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isUnd"])(oData.FileName) ? '' : oData.FileName.toString(),
					    size = Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isNormal"])(oData.Size) ? Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["pInt"])(oData.Size) : null,
					    attachment = new __WEBPACK_IMPORTED_MODULE_30_Model_ComposeAttachment__["a" /* ComposeAttachmentModel */](sId, fileName, size);

					attachment.cancel = _this18.cancelAttachmentHelper(sId, oJua);

					_this18.attachments.push(attachment);

					_this18.attachmentsPlace(true);

					if (0 < size && 0 < attachmentSizeLimit && attachmentSizeLimit < size) {
						attachment.waiting(false).uploading(true).complete(true).error(Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["i18n"])('UPLOAD/ERROR_FILE_IS_TOO_BIG'));

						return false;
					}

					return true;
				}).on('onStart', function (id) {

					var item = uploadCache[id];
					if (!item) {
						item = _this18.getAttachmentById(id);
						if (item) {
							uploadCache[id] = item;
						}
					}

					if (item) {
						item.waiting(false).uploading(true).complete(false);
					}
				}).on('onComplete', function (id, result, data) {

					var attachment = _this18.getAttachmentById(id),
					    errorCode = data && data.Result && data.Result.ErrorCode ? data.Result.ErrorCode : null,
					    attachmentJson = result && data && data.Result && data.Result.Attachment ? data.Result.Attachment : null;

					var error = '';
					if (null !== errorCode) {
						error = Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["getUploadErrorDescByCode"])(errorCode);
					} else if (!attachmentJson) {
						error = Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["i18n"])('UPLOAD/ERROR_UNKNOWN');
					}

					if (attachment) {
						if ('' !== error && 0 < error.length) {
							attachment.waiting(false).uploading(false).complete(true).error(error);
						} else if (attachmentJson) {
							attachment.waiting(false).uploading(false).complete(true);

							attachment.initByUploadJson(attachmentJson);
						}

						if (Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isUnd"])(uploadCache[id])) {
							delete uploadCache[id];
						}
					}
				});

				this.addAttachmentEnabled(true).dragAndDropEnabled(oJua.isDragAndDropSupported());
			} else {
				this.addAttachmentEnabled(false).dragAndDropEnabled(false);
			}
		}
	};

	/**
  * @returns {Object}
  */


	ComposePopupView.prototype.prepearAttachmentsForSendOrSave = function prepearAttachmentsForSendOrSave() {
		var result = {};
		__WEBPACK_IMPORTED_MODULE_5_____default.a.each(this.attachmentsInReady(), function (item) {
			if (item && '' !== item.tempName() && item.enabled()) {
				result[item.tempName()] = [item.fileName(), item.isInline ? '1' : '0', item.CID, item.contentLocation];
			}
		});

		return result;
	};

	/**
  * @param {MessageModel} message
  */


	ComposePopupView.prototype.addMessageAsAttachment = function addMessageAsAttachment(message) {
		if (message) {
			var temp = message.subject();
			temp = '.eml' === temp.substr(-4).toLowerCase() ? temp : temp + '.eml';

			var attachment = new __WEBPACK_IMPORTED_MODULE_30_Model_ComposeAttachment__["a" /* ComposeAttachmentModel */](message.requestHash, temp, message.size());

			attachment.fromMessage = true;
			attachment.cancel = this.cancelAttachmentHelper(message.requestHash);
			attachment.waiting(false).uploading(true).complete(true);

			this.attachments.push(attachment);
		}
	};

	/**
  * @param {string} url
  * @param {string} name
  * @param {number} size
  * @returns {ComposeAttachmentModel}
  */


	ComposePopupView.prototype.addAttachmentHelper = function addAttachmentHelper(url, name, size) {
		var attachment = new __WEBPACK_IMPORTED_MODULE_30_Model_ComposeAttachment__["a" /* ComposeAttachmentModel */](url, name, size);

		attachment.fromMessage = false;
		attachment.cancel = this.cancelAttachmentHelper(url);
		attachment.waiting(false).uploading(true).complete(false);

		this.attachments.push(attachment);

		this.attachmentsPlace(true);

		return attachment;
	};

	/**
  * @param {Object} dropboxFile
  * @returns {boolean}
  */


	ComposePopupView.prototype.addDropboxAttachment = function addDropboxAttachment(dropboxFile) {
		var attachmentSizeLimit = Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["pInt"])(__WEBPACK_IMPORTED_MODULE_28_Storage_Settings__["settingsGet"]('AttachmentLimit')),
		    mSize = dropboxFile.bytes,
		    attachment = this.addAttachmentHelper(dropboxFile.link, dropboxFile.name, mSize);

		if (0 < mSize && 0 < attachmentSizeLimit && attachmentSizeLimit < mSize) {
			attachment.uploading(false).complete(true);
			attachment.error(Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["i18n"])('UPLOAD/ERROR_FILE_IS_TOO_BIG'));
			return false;
		}

		__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax__["a" /* default */].composeUploadExternals(function (statusResult, data) {

			var result = false;
			attachment.uploading(false).complete(true);

			if (__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["StorageResultType"].Success === statusResult && data && data.Result) {
				if (data.Result[attachment.id]) {
					result = true;
					attachment.tempName(data.Result[attachment.id]);
				}
			}

			if (!result) {
				attachment.error(Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["getUploadErrorDescByCode"])(__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["UploadErrorCode"].FileNoUploaded));
			}
		}, [dropboxFile.link]);

		return true;
	};

	/**
  * @param {Object} driveFile
  * @param {string} accessToken
  * @returns {boolean}
  */


	ComposePopupView.prototype.addDriveAttachment = function addDriveAttachment(driveFile, accessToken) {
		var attachmentSizeLimit = Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["pInt"])(__WEBPACK_IMPORTED_MODULE_28_Storage_Settings__["settingsGet"]('AttachmentLimit')),
		    size = driveFile.fileSize ? Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["pInt"])(driveFile.fileSize) : 0,
		    attachment = this.addAttachmentHelper(driveFile.downloadUrl, driveFile.title, size);

		if (0 < size && 0 < attachmentSizeLimit && attachmentSizeLimit < size) {
			attachment.uploading(false).complete(true);
			attachment.error(Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["i18n"])('UPLOAD/ERROR_FILE_IS_TOO_BIG'));
			return false;
		}

		__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax__["a" /* default */].composeUploadDrive(function (statusResult, data) {

			var result = false;
			attachment.uploading(false).complete(true);

			if (__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["StorageResultType"].Success === statusResult && data && data.Result) {
				if (data.Result[attachment.id]) {
					result = true;
					attachment.tempName(data.Result[attachment.id][0]);
					attachment.size(Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["pInt"])(data.Result[attachment.id][1]));
				}
			}

			if (!result) {
				attachment.error(Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["getUploadErrorDescByCode"])(__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["UploadErrorCode"].FileNoUploaded));
			}
		}, driveFile.downloadUrl, accessToken);

		return true;
	};

	/**
  * @param {MessageModel} message
  * @param {string} type
  */


	ComposePopupView.prototype.prepearMessageAttachments = function prepearMessageAttachments(message, type) {
		var _this19 = this;

		if (message) {
			if (__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].ForwardAsAttachment === type) {
				this.addMessageAsAttachment(message);
			} else {
				var attachments = message.attachments();
				__WEBPACK_IMPORTED_MODULE_5_____default.a.each(Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isNonEmptyArray"])(attachments) ? attachments : [], function (item) {
					var add = false;
					switch (type) {
						case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].Reply:
						case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].ReplyAll:
							add = item.isLinked;
							break;

						case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].Forward:
						case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].Draft:
						case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].EditAsNew:
							add = true;
							break;
						// no default
					}

					if (add) {
						var attachment = new __WEBPACK_IMPORTED_MODULE_30_Model_ComposeAttachment__["a" /* ComposeAttachmentModel */](item.download, item.fileName, item.estimatedSize, item.isInline, item.isLinked, item.cid, item.contentLocation);

						attachment.fromMessage = true;
						attachment.cancel = _this19.cancelAttachmentHelper(item.download);
						attachment.waiting(false).uploading(true).complete(false);

						_this19.attachments.push(attachment);
					}
				});
			}
		}
	};

	ComposePopupView.prototype.removeLinkedAttachments = function removeLinkedAttachments() {
		var arrachment = __WEBPACK_IMPORTED_MODULE_5_____default.a.find(this.attachments(), function (item) {
			return item && item.isLinked;
		});
		if (arrachment) {
			this.attachments.remove(arrachment);
			Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["delegateRunOnDestroy"])(arrachment);
		}
	};

	ComposePopupView.prototype.setMessageAttachmentFailedDownloadText = function setMessageAttachmentFailedDownloadText() {
		__WEBPACK_IMPORTED_MODULE_5_____default.a.each(this.attachments(), function (attachment) {
			if (attachment && attachment.fromMessage) {
				attachment.waiting(false).uploading(false).complete(true).error(Object(__WEBPACK_IMPORTED_MODULE_15_Common_Translator__["getUploadErrorDescByCode"])(__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["UploadErrorCode"].FileNoUploaded));
			}
		});
	};

	/**
  * @param {boolean=} includeAttachmentInProgress = true
  * @returns {boolean}
  */


	ComposePopupView.prototype.isEmptyForm = function isEmptyForm() {
		var includeAttachmentInProgress = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;


		var withoutAttachment = includeAttachmentInProgress ? 0 === this.attachments().length : 0 === this.attachmentsInReady().length;

		return 0 === this.to().length && 0 === this.cc().length && 0 === this.bcc().length && 0 === this.replyTo().length && 0 === this.subject().length && withoutAttachment && (!this.oEditor || '' === this.oEditor.getData());
	};

	ComposePopupView.prototype.reset = function reset() {
		this.to('');
		this.cc('');
		this.bcc('');
		this.replyTo('');
		this.subject('');

		this.requestDsn(false);
		this.requestReadReceipt(false);
		this.markAsImportant(false);

		this.attachmentsPlace(false);

		this.aDraftInfo = null;
		this.sInReplyTo = '';
		this.bFromDraft = false;
		this.sReferences = '';

		this.sendError(false);
		this.sendSuccessButSaveError(false);
		this.savedError(false);
		this.savedTime(0);
		this.emptyToError(false);
		this.attachmentsInProcessError(false);

		this.showCc(false);
		this.showBcc(false);
		this.showReplyTo(false);

		Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["delegateRunOnDestroy"])(this.attachments());
		this.attachments([]);

		this.dragAndDropOver(false);
		this.dragAndDropVisible(false);

		this.draftFolder('');
		this.draftUid('');

		this.sending(false);
		this.saving(false);

		if (this.oEditor) {
			this.oEditor.clear(false);
		}
	};

	/**
  * @returns {Array}
  */


	ComposePopupView.prototype.getAttachmentsDownloadsForUpload = function getAttachmentsDownloadsForUpload() {
		return __WEBPACK_IMPORTED_MODULE_5_____default.a.map(__WEBPACK_IMPORTED_MODULE_5_____default.a.filter(this.attachments(), function (item) {
			return item && '' === item.tempName();
		}), function (item) {
			return item.id;
		});
	};

	ComposePopupView.prototype.resizerTrigger = function resizerTrigger() {
		this.resizer(!this.resizer());
	};

	return ComposePopupView;
}(__WEBPACK_IMPORTED_MODULE_33_Knoin_AbstractViewNext__["a" /* AbstractViewNext */]), (_applyDecoratedDescriptor(_class2.prototype, 'sendCommand', [_dec2], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default()(_class2.prototype, 'sendCommand'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'saveCommand', [_dec3], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default()(_class2.prototype, 'saveCommand'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'deleteCommand', [_dec4], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default()(_class2.prototype, 'deleteCommand'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'skipCommand', [_dec5], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default()(_class2.prototype, 'skipCommand'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'contactsCommand', [_dec6], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default()(_class2.prototype, 'contactsCommand'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'dropboxCommand', [_dec7], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default()(_class2.prototype, 'dropboxCommand'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'driveCommand', [_dec8], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default()(_class2.prototype, 'driveCommand'), _class2.prototype)), _class2)) || _class);




/***/ }),
/* 44 */
/*!****************************!*\
  !*** ./dev/Model/Email.js ***!
  \****************************/
/*! exports provided: EmailModel, default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EmailModel", function() { return EmailModel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return EmailModel; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);




var EmailModel = function () {

	/**
  * @param {string=} email = ''
  * @param {string=} name = ''
  * @param {string=} dkimStatus = 'none'
  * @param {string=} dkimValue = ''
  */
	function EmailModel() {
		var email = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
		var name = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
		var dkimStatus = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'none';
		var dkimValue = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';

		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, EmailModel);

		this.email = '';
		this.name = '';
		this.dkimStatus = '';
		this.dkimValue = '';

		this.email = email;
		this.name = name;
		this.dkimStatus = dkimStatus;
		this.dkimValue = dkimValue;

		this.clearDuplicateName();
	}

	/**
  * @static
  * @param {AjaxJsonEmail} json
  * @returns {?EmailModel}
  */


	EmailModel.newInstanceFromJson = function newInstanceFromJson(json) {
		var email = new EmailModel();
		return email.initByJson(json) ? email : null;
	};

	/**
  * @static
  * @param {string} line
  * @param {string=} delimiter = ';'
  * @returns {Array}
  */


	EmailModel.splitHelper = function splitHelper(line) {
		var delimiter = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : ';';

		line = line.replace(/[\r\n]+/g, '; ').replace(/[\s]+/g, ' ');

		var index = 0,
		    len = 0,
		    at = false,
		    char = '',
		    result = '';

		for (len = line.length; index < len; index++) {
			char = line.charAt(index);
			switch (char) {
				case '@':
					at = true;
					break;
				case ' ':
					if (at) {
						at = false;
						result += delimiter;
					}
					break;
				// no default
			}

			result += char;
		}

		return result.split(delimiter);
	};

	/**
  * @returns {void}
  */


	EmailModel.prototype.clear = function clear() {
		this.email = '';
		this.name = '';

		this.dkimStatus = 'none';
		this.dkimValue = '';
	};

	/**
  * @returns {boolean}
  */


	EmailModel.prototype.validate = function validate() {
		return '' !== this.name || '' !== this.email;
	};

	/**
  * @param {boolean} withoutName = false
  * @returns {string}
  */


	EmailModel.prototype.hash = function hash() {
		var withoutName = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

		return '#' + (withoutName ? '' : this.name) + '#' + this.email + '#';
	};

	/**
  * @returns {void}
  */


	EmailModel.prototype.clearDuplicateName = function clearDuplicateName() {
		if (this.name === this.email) {
			this.name = '';
		}
	};

	/**
  * @param {string} query
  * @returns {boolean}
  */


	EmailModel.prototype.search = function search(query) {
		return -1 < (this.name + ' ' + this.email).toLowerCase().indexOf(query.toLowerCase());
	};

	/**
  * @param {string} str
  */


	EmailModel.prototype.parse = function parse(str) {
		this.clear();

		str = Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["trim"])(str);

		var regex = /(?:"([^"]+)")? ?[<]?(.*?@[^>,]+)>?,? ?/g,
		    match = regex.exec(str);

		if (match) {
			this.name = match[1] || '';
			this.email = match[2] || '';

			this.clearDuplicateName();
		} else if (/^[^@]+@[^@]+$/.test(str)) {
			this.name = '';
			this.email = str;
		}
	};

	/**
  * @param {AjaxJsonEmail} oJsonEmail
  * @returns {boolean}
  */


	EmailModel.prototype.initByJson = function initByJson(json) {
		var result = false;
		if (json && 'Object/Email' === json['@Object']) {
			this.name = Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["trim"])(json.Name);
			this.email = Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["trim"])(json.Email);
			this.dkimStatus = Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["trim"])(json.DkimStatus || '');
			this.dkimValue = Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["trim"])(json.DkimValue || '');

			result = '' !== this.email;
			this.clearDuplicateName();
		}

		return result;
	};

	/**
  * @param {boolean} friendlyView
  * @param {boolean=} wrapWithLink = false
  * @param {boolean=} useEncodeHtml = false
  * @returns {string}
  */


	EmailModel.prototype.toLine = function toLine(friendlyView) {
		var wrapWithLink = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
		var useEncodeHtml = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

		var result = '';
		if ('' !== this.email) {
			if (friendlyView && '' !== this.name) {
				result = wrapWithLink ? '<a href="mailto:' + Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["encodeHtml"])('"' + this.name + '" <' + this.email + '>') + '" target="_blank" tabindex="-1">' + Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["encodeHtml"])(this.name) + '</a>' : useEncodeHtml ? Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["encodeHtml"])(this.name) : this.name;
			} else {
				result = this.email;
				if ('' !== this.name) {
					if (wrapWithLink) {
						result = Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["encodeHtml"])('"' + this.name + '" <') + '<a href="mailto:' + Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["encodeHtml"])('"' + this.name + '" <' + this.email + '>') + '" target="_blank" tabindex="-1">' + Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["encodeHtml"])(result) + '</a>' + Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["encodeHtml"])('>');
					} else {
						result = '"' + this.name + '" <' + result + '>';
						if (useEncodeHtml) {
							result = Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["encodeHtml"])(result);
						}
					}
				} else if (wrapWithLink) {
					result = '<a href="mailto:' + Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["encodeHtml"])(this.email) + '" target="_blank" tabindex="-1">' + Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["encodeHtml"])(this.email) + '</a>';
				}
			}
		}

		return result;
	};

	/**
  * @param {string} $sEmailAddress
  * @returns {boolean}
  */


	EmailModel.prototype.mailsoParse = function mailsoParse($sEmailAddress) {
		$sEmailAddress = Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["trim"])($sEmailAddress);
		if ('' === $sEmailAddress) {
			return false;
		}

		var substr = function substr(str, start, len) {
			str = Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["pString"])(str);
			var end = str.length;

			if (0 > start) {
				start += end;
			}

			end = 'undefined' === typeof len ? end : 0 > len ? len + end : len + start;

			return start >= str.length || 0 > start || start > end ? false : str.slice(start, end);
		};

		var substrReplace = function substrReplace(str, replace, start, length) {
			str = Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["pString"])(str);
			if (0 > start) {
				start += str.length;
			}

			length = 'undefined' !== typeof length ? length : str.length;
			if (0 > length) {
				length = length + str.length - start;
			}
			return str.slice(0, start) + replace.substr(0, length) + replace.slice(length) + str.slice(start + length);
		};

		var $sName = '',
		    $sEmail = '',
		    $sComment = '',
		    $bInName = false,
		    $bInAddress = false,
		    $bInComment = false,
		    $aRegs = null,
		    $iStartIndex = 0,
		    $iEndIndex = 0,
		    $iCurrentIndex = 0;

		while ($iCurrentIndex < $sEmailAddress.length) {
			switch ($sEmailAddress.substr($iCurrentIndex, 1)) {
				case '"':
					if (!$bInName && !$bInAddress && !$bInComment) {
						$bInName = true;
						$iStartIndex = $iCurrentIndex;
					} else if (!$bInAddress && !$bInComment) {
						$iEndIndex = $iCurrentIndex;
						$sName = substr($sEmailAddress, $iStartIndex + 1, $iEndIndex - $iStartIndex - 1);
						$sEmailAddress = substrReplace($sEmailAddress, '', $iStartIndex, $iEndIndex - $iStartIndex + 1);
						$iEndIndex = 0;
						$iCurrentIndex = 0;
						$iStartIndex = 0;
						$bInName = false;
					}
					break;
				case '<':
					if (!$bInName && !$bInAddress && !$bInComment) {
						if (0 < $iCurrentIndex && 0 === $sName.length) {
							$sName = substr($sEmailAddress, 0, $iCurrentIndex);
						}

						$bInAddress = true;
						$iStartIndex = $iCurrentIndex;
					}
					break;
				case '>':
					if ($bInAddress) {
						$iEndIndex = $iCurrentIndex;
						$sEmail = substr($sEmailAddress, $iStartIndex + 1, $iEndIndex - $iStartIndex - 1);
						$sEmailAddress = substrReplace($sEmailAddress, '', $iStartIndex, $iEndIndex - $iStartIndex + 1);
						$iEndIndex = 0;
						$iCurrentIndex = 0;
						$iStartIndex = 0;
						$bInAddress = false;
					}
					break;
				case '(':
					if (!$bInName && !$bInAddress && !$bInComment) {
						$bInComment = true;
						$iStartIndex = $iCurrentIndex;
					}
					break;
				case ')':
					if ($bInComment) {
						$iEndIndex = $iCurrentIndex;
						$sComment = substr($sEmailAddress, $iStartIndex + 1, $iEndIndex - $iStartIndex - 1);
						$sEmailAddress = substrReplace($sEmailAddress, '', $iStartIndex, $iEndIndex - $iStartIndex + 1);
						$iEndIndex = 0;
						$iCurrentIndex = 0;
						$iStartIndex = 0;
						$bInComment = false;
					}
					break;
				case '\\':
					$iCurrentIndex += 1;
					break;
				// no default
			}

			$iCurrentIndex += 1;
		}

		if (0 === $sEmail.length) {
			$aRegs = $sEmailAddress.match(/[^@\s]+@\S+/i);
			if ($aRegs && $aRegs[0]) {
				$sEmail = $aRegs[0];
			} else {
				$sName = $sEmailAddress;
			}
		}

		if (0 < $sEmail.length && 0 === $sName.length && 0 === $sComment.length) {
			$sName = $sEmailAddress.replace($sEmail, '');
		}

		$sEmail = Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["trim"])($sEmail).replace(/^[<]+/, '').replace(/[>]+$/, '');
		$sName = Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["trim"])($sName).replace(/^["']+/, '').replace(/["']+$/, '');
		$sComment = Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["trim"])($sComment).replace(/^[(]+/, '').replace(/[)]+$/, '');

		// Remove backslash
		$sName = $sName.replace(/\\\\(.)/g, '$1');
		$sComment = $sComment.replace(/\\\\(.)/g, '$1');

		this.name = $sName;
		this.email = $sEmail;

		this.clearDuplicateName();
		return true;
	};

	return EmailModel;
}();



/***/ }),
/* 45 */
/*!************************************!*\
  !*** ./dev/Stores/User/Message.js ***!
  \************************************/
/*! exports provided: default */
/*! exports used: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4____ = __webpack_require__(/*! $ */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Cache__ = __webpack_require__(/*! Common/Cache */ 27);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Common_Consts__ = __webpack_require__(/*! Common/Consts */ 20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Common_Links__ = __webpack_require__(/*! Common/Links */ 14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_Common_Momentor__ = __webpack_require__(/*! Common/Momentor */ 40);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13_Helper_Message__ = __webpack_require__(/*! Helper/Message */ 175);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14_Model_Message__ = __webpack_require__(/*! Model/Message */ 214);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_16_Stores_User_App__ = __webpack_require__(/*! Stores/User/App */ 34);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_17_Stores_User_Account__ = __webpack_require__(/*! Stores/User/Account */ 47);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_18_Stores_User_Folder__ = __webpack_require__(/*! Stores/User/Folder */ 38);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_19_Stores_User_Pgp__ = __webpack_require__(/*! Stores/User/Pgp */ 53);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_20_Stores_User_Settings__ = __webpack_require__(/*! Stores/User/Settings */ 41);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_21_Stores_User_Notification__ = __webpack_require__(/*! Stores/User/Notification */ 145);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_22_Helper_Apps_User__ = __webpack_require__(/*! Helper/Apps/User */ 16);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_23_Remote_User_Ajax__ = __webpack_require__(/*! Remote/User/Ajax */ 17);



































var MessageUserStore = function () {
	function MessageUserStore() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, MessageUserStore);

		this.staticMessage = new __WEBPACK_IMPORTED_MODULE_14_Model_Message__["a" /* MessageModel */]();

		this.messageList = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observableArray([]).extend({ rateLimit: 0 });

		this.messageListCount = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(0);
		this.messageListSearch = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable('');
		this.messageListThreadUid = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable('');
		this.messageListPage = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(1);
		this.messageListPageBeforeThread = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(1);
		this.messageListError = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable('');

		this.messageListEndFolder = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable('');
		this.messageListEndSearch = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable('');
		this.messageListEndThreadUid = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable('');
		this.messageListEndPage = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(1);

		this.messageListLoading = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(false);
		this.messageListIsNotCompleted = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(false);
		this.messageListCompleteLoadingThrottle = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(false).extend({ throttle: 200 });
		this.messageListCompleteLoadingThrottleForAnimation = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(false).extend({ specialThrottle: 700 });

		this.messageListDisableAutoSelect = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(false).extend({ falseTimeout: 500 });

		this.selectorMessageSelected = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(null);
		this.selectorMessageFocused = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(null);

		// message viewer
		this.message = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(null);

		this.message.viewTrigger = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(false);

		this.messageError = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable('');

		this.messageCurrentLoading = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(false);

		this.messageLoadingThrottle = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(false).extend({ throttle: __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Magics"].Time50ms });

		this.messageFullScreenMode = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(false);

		this.messagesBodiesDom = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(null);
		this.messageActiveDom = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(null);

		this.computers();
		this.subscribers();

		this.onMessageResponse = __WEBPACK_IMPORTED_MODULE_2_____default.a.bind(this.onMessageResponse, this);

		this.purgeMessageBodyCacheThrottle = __WEBPACK_IMPORTED_MODULE_2_____default.a.throttle(this.purgeMessageBodyCache, __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Magics"].Time30s);
	}

	MessageUserStore.prototype.computers = function computers() {
		var _this = this;

		this.messageLoading = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].computed(function () {
			return _this.messageCurrentLoading();
		});

		this.messageListEndHash = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].computed(function () {
			return _this.messageListEndFolder() + '|' + _this.messageListEndSearch() + '|' + _this.messageListEndThreadUid() + '|' + _this.messageListEndPage();
		});

		this.messageListPageCount = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].computed(function () {
			var page = __WEBPACK_IMPORTED_MODULE_1_window___default.a.Math.ceil(_this.messageListCount() / __WEBPACK_IMPORTED_MODULE_20_Stores_User_Settings__["a" /* default */].messagesPerPage());
			return 0 >= page ? 1 : page;
		});

		this.mainMessageListSearch = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].computed({
			read: this.messageListSearch,
			write: function write(value) {
				Object(__WEBPACK_IMPORTED_MODULE_15_Knoin_Knoin__["setHash"])(Object(__WEBPACK_IMPORTED_MODULE_10_Common_Links__["o" /* mailBox */])(__WEBPACK_IMPORTED_MODULE_18_Stores_User_Folder__["a" /* default */].currentFolderFullNameHash(), 1, Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["trim"])(value.toString()), _this.messageListThreadUid()));
			}
		});

		this.messageListCompleteLoading = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].computed(function () {
			var one = _this.messageListLoading(),
			    two = _this.messageListIsNotCompleted();
			return one || two;
		});

		this.isMessageSelected = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].computed(function () {
			return null !== _this.message();
		});

		this.messageListChecked = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].computed(function () {
			return __WEBPACK_IMPORTED_MODULE_2_____default.a.filter(_this.messageList(), function (item) {
				return item.checked();
			});
		}).extend({ rateLimit: 0 });

		this.hasCheckedMessages = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].computed(function () {
			return 0 < _this.messageListChecked().length;
		}).extend({ rateLimit: 0 });

		this.messageListCheckedOrSelected = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].computed(function () {
			var checked = _this.messageListChecked(),
			    selectedMessage = _this.selectorMessageSelected(),
			    focusedMessage = _this.selectorMessageFocused();

			if (checked.length) {
				return __WEBPACK_IMPORTED_MODULE_2_____default.a.union(checked, selectedMessage ? [selectedMessage] : []);
			} else if (selectedMessage) {
				return [selectedMessage];
			}

			return focusedMessage ? [focusedMessage] : [];
		});

		this.messageListCheckedOrSelectedUidsWithSubMails = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].computed(function () {
			var result = [];
			__WEBPACK_IMPORTED_MODULE_2_____default.a.each(_this.messageListCheckedOrSelected(), function (message) {
				if (message) {
					result.push(message.uid);
					if (1 < message.threadsLen()) {
						result = __WEBPACK_IMPORTED_MODULE_2_____default.a.union(result, message.threads());
					}
				}
			});
			return result;
		});
	};

	MessageUserStore.prototype.subscribers = function subscribers() {
		var _this2 = this;

		this.messageListCompleteLoading.subscribe(function (value) {
			value = !!value;
			_this2.messageListCompleteLoadingThrottle(value);
			_this2.messageListCompleteLoadingThrottleForAnimation(value);
		});

		this.messageList.subscribe(__WEBPACK_IMPORTED_MODULE_2_____default.a.debounce(function (list) {
			__WEBPACK_IMPORTED_MODULE_2_____default.a.each(list, function (item) {
				if (item && item.newForAnimation()) {
					item.newForAnimation(false);
				}
			});
		}, __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Magics"].Time500ms));

		this.message.subscribe(function (message) {

			if (message) {
				if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Layout"].NoPreview === __WEBPACK_IMPORTED_MODULE_20_Stores_User_Settings__["a" /* default */].layout()) {
					__WEBPACK_IMPORTED_MODULE_16_Stores_User_App__["a" /* default */].focusedState(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Focused"].MessageView);
				}
			} else {
				__WEBPACK_IMPORTED_MODULE_16_Stores_User_App__["a" /* default */].focusedState(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Focused"].MessageList);

				_this2.messageFullScreenMode(false);
				_this2.hideMessageBodies();
			}
		});

		this.messageLoading.subscribe(function (value) {
			_this2.messageLoadingThrottle(value);
		});

		this.messagesBodiesDom.subscribe(function (dom) {
			if (dom && !(dom instanceof __WEBPACK_IMPORTED_MODULE_4_____default.a)) {
				_this2.messagesBodiesDom(__WEBPACK_IMPORTED_MODULE_4_____default()(dom));
			}
		});

		this.messageListEndFolder.subscribe(function (folder) {
			var message = _this2.message();
			if (message && folder && folder !== message.folderFullNameRaw) {
				_this2.message(null);
			}
		});
	};

	MessageUserStore.prototype.purgeMessageBodyCache = function purgeMessageBodyCache() {

		var count = 0;
		var end = __WEBPACK_IMPORTED_MODULE_9_Common_Globals__["data"].iMessageBodyCacheCount - __WEBPACK_IMPORTED_MODULE_8_Common_Consts__["k" /* MESSAGE_BODY_CACHE_LIMIT */];

		if (0 < end) {
			var messagesDom = this.messagesBodiesDom();
			if (messagesDom) {
				messagesDom.find('.rl-cache-class').each(function () {
					var item = __WEBPACK_IMPORTED_MODULE_4_____default()(this); // eslint-disable-line no-invalid-this
					if (end > item.data('rl-cache-count')) {
						item.addClass('rl-cache-purge');
						count += 1;
					}
				});

				if (0 < count) {
					__WEBPACK_IMPORTED_MODULE_2_____default.a.delay(function () {
						return messagesDom.find('.rl-cache-purge').remove();
					}, __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Magics"].Time350ms);
				}
			}
		}
	};

	MessageUserStore.prototype.initUidNextAndNewMessages = function initUidNextAndNewMessages(folder, uidNext, newMessages) {
		if (Object(__WEBPACK_IMPORTED_MODULE_7_Common_Cache__["h" /* getFolderInboxName */])() === folder && Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["isNormal"])(uidNext) && '' !== uidNext) {
			if (Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["isArray"])(newMessages) && 0 < newMessages.length) {
				__WEBPACK_IMPORTED_MODULE_2_____default.a.each(newMessages, function (item) {
					Object(__WEBPACK_IMPORTED_MODULE_7_Common_Cache__["a" /* addNewMessageCache */])(folder, item.Uid);
				});

				__WEBPACK_IMPORTED_MODULE_21_Stores_User_Notification__["a" /* default */].playSoundNotification();

				var len = newMessages.length;
				if (3 < len) {
					__WEBPACK_IMPORTED_MODULE_21_Stores_User_Notification__["a" /* default */].displayDesktopNotification(Object(__WEBPACK_IMPORTED_MODULE_10_Common_Links__["r" /* notificationMailIcon */])(), __WEBPACK_IMPORTED_MODULE_17_Stores_User_Account__["a" /* default */].email(), Object(__WEBPACK_IMPORTED_MODULE_11_Common_Translator__["i18n"])('MESSAGE_LIST/NEW_MESSAGE_NOTIFICATION', {
						'COUNT': len
					}), { 'Folder': '', 'Uid': '' });
				} else {
					__WEBPACK_IMPORTED_MODULE_2_____default.a.each(newMessages, function (item) {
						__WEBPACK_IMPORTED_MODULE_21_Stores_User_Notification__["a" /* default */].displayDesktopNotification(Object(__WEBPACK_IMPORTED_MODULE_10_Common_Links__["r" /* notificationMailIcon */])(), __WEBPACK_IMPORTED_MODULE_13_Helper_Message__["b" /* emailArrayToString */](__WEBPACK_IMPORTED_MODULE_13_Helper_Message__["a" /* emailArrayFromJson */](item.From), false), item.Subject, { 'Folder': item.Folder, 'Uid': item.Uid });
					});
				}
			}

			Object(__WEBPACK_IMPORTED_MODULE_7_Common_Cache__["s" /* setFolderUidNext */])(folder, uidNext);
		}
	};

	MessageUserStore.prototype.hideMessageBodies = function hideMessageBodies() {
		var messagesDom = this.messagesBodiesDom();
		if (messagesDom) {
			messagesDom.find('.b-text-part').hide();
		}
	};

	/**
  * @param {string} fromFolderFullNameRaw
  * @param {Array} uidForRemove
  * @param {string=} toFolderFullNameRaw = ''
  * @param {boolean=} copy = false
  */


	MessageUserStore.prototype.removeMessagesFromList = function removeMessagesFromList(fromFolderFullNameRaw, uidForRemove) {
		var _this3 = this;

		var toFolderFullNameRaw = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
		var copy = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;


		uidForRemove = __WEBPACK_IMPORTED_MODULE_2_____default.a.map(uidForRemove, function (mValue) {
			return Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["pInt"])(mValue);
		});

		var unseenCount = 0,
		    messageList = this.messageList(),
		    currentMessage = this.message();

		var trashFolder = __WEBPACK_IMPORTED_MODULE_18_Stores_User_Folder__["a" /* default */].trashFolder(),
		    spamFolder = __WEBPACK_IMPORTED_MODULE_18_Stores_User_Folder__["a" /* default */].spamFolder(),
		    fromFolder = Object(__WEBPACK_IMPORTED_MODULE_7_Common_Cache__["e" /* getFolderFromCacheList */])(fromFolderFullNameRaw),
		    toFolder = '' === toFolderFullNameRaw ? null : Object(__WEBPACK_IMPORTED_MODULE_7_Common_Cache__["e" /* getFolderFromCacheList */])(toFolderFullNameRaw || ''),
		    currentFolderFullNameRaw = __WEBPACK_IMPORTED_MODULE_18_Stores_User_Folder__["a" /* default */].currentFolderFullNameRaw(),
		    messages = currentFolderFullNameRaw === fromFolderFullNameRaw ? __WEBPACK_IMPORTED_MODULE_2_____default.a.filter(messageList, function (item) {
			return item && -1 < Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["inArray"])(Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["pInt"])(item.uid), uidForRemove);
		}) : [];

		__WEBPACK_IMPORTED_MODULE_2_____default.a.each(messages, function (item) {
			if (item && item.unseen()) {
				unseenCount += 1;
			}
		});

		if (fromFolder && !copy) {
			fromFolder.messageCountAll(0 <= fromFolder.messageCountAll() - uidForRemove.length ? fromFolder.messageCountAll() - uidForRemove.length : 0);

			if (0 < unseenCount) {
				fromFolder.messageCountUnread(0 <= fromFolder.messageCountUnread() - unseenCount ? fromFolder.messageCountUnread() - unseenCount : 0);
			}
		}

		if (toFolder) {
			if (trashFolder === toFolder.fullNameRaw || spamFolder === toFolder.fullNameRaw) {
				unseenCount = 0;
			}

			toFolder.messageCountAll(toFolder.messageCountAll() + uidForRemove.length);
			if (0 < unseenCount) {
				toFolder.messageCountUnread(toFolder.messageCountUnread() + unseenCount);
			}

			toFolder.actionBlink(true);
		}

		if (0 < messages.length) {
			if (copy) {
				__WEBPACK_IMPORTED_MODULE_2_____default.a.each(messages, function (item) {
					item.checked(false);
				});
			} else {
				this.messageListIsNotCompleted(true);

				__WEBPACK_IMPORTED_MODULE_2_____default.a.each(messages, function (item) {
					if (currentMessage && currentMessage.hash === item.hash) {
						currentMessage = null;
						_this3.message(null);
					}

					item.deleted(true);
				});

				__WEBPACK_IMPORTED_MODULE_2_____default.a.delay(function () {
					__WEBPACK_IMPORTED_MODULE_2_____default.a.each(messages, function (item) {
						_this3.messageList.remove(item);
					});
				}, __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Magics"].Time350ms);
			}
		}

		if ('' !== fromFolderFullNameRaw) {
			Object(__WEBPACK_IMPORTED_MODULE_7_Common_Cache__["q" /* setFolderHash */])(fromFolderFullNameRaw, '');
		}

		if ('' !== toFolderFullNameRaw) {
			Object(__WEBPACK_IMPORTED_MODULE_7_Common_Cache__["q" /* setFolderHash */])(toFolderFullNameRaw, '');
		}

		if ('' !== this.messageListThreadUid()) {
			messageList = this.messageList();

			if (messageList && 0 < messageList.length && !!__WEBPACK_IMPORTED_MODULE_2_____default.a.find(messageList, function (item) {
				return !!(item && item.deleted() && item.uid === _this3.messageListThreadUid());
			})) {
				var message = __WEBPACK_IMPORTED_MODULE_2_____default.a.find(messageList, function (item) {
					return item && !item.deleted();
				});
				if (message && this.messageListThreadUid() !== Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["pString"])(message.uid)) {
					this.messageListThreadUid(Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["pString"])(message.uid));

					Object(__WEBPACK_IMPORTED_MODULE_15_Knoin_Knoin__["setHash"])(Object(__WEBPACK_IMPORTED_MODULE_10_Common_Links__["o" /* mailBox */])(__WEBPACK_IMPORTED_MODULE_18_Stores_User_Folder__["a" /* default */].currentFolderFullNameHash(), this.messageListPage(), this.messageListSearch(), this.messageListThreadUid()), true, true);
				} else if (!message) {
					if (1 < this.messageListPage()) {
						this.messageListPage(this.messageListPage() - 1);

						Object(__WEBPACK_IMPORTED_MODULE_15_Knoin_Knoin__["setHash"])(Object(__WEBPACK_IMPORTED_MODULE_10_Common_Links__["o" /* mailBox */])(__WEBPACK_IMPORTED_MODULE_18_Stores_User_Folder__["a" /* default */].currentFolderFullNameHash(), this.messageListPage(), this.messageListSearch(), this.messageListThreadUid()), true, true);
					} else {
						this.messageListThreadUid('');

						Object(__WEBPACK_IMPORTED_MODULE_15_Knoin_Knoin__["setHash"])(Object(__WEBPACK_IMPORTED_MODULE_10_Common_Links__["o" /* mailBox */])(__WEBPACK_IMPORTED_MODULE_18_Stores_User_Folder__["a" /* default */].currentFolderFullNameHash(), this.messageListPageBeforeThread(), this.messageListSearch()), true, true);
					}
				}
			}
		}
	};

	/**
  * @param {Object} messageTextBody
  */


	MessageUserStore.prototype.initBlockquoteSwitcher = function initBlockquoteSwitcher(messageTextBody) {
		if (messageTextBody) {
			var $oList = __WEBPACK_IMPORTED_MODULE_4_____default()('blockquote:not(.rl-bq-switcher)', messageTextBody).filter(function () {
				return 0 === __WEBPACK_IMPORTED_MODULE_4_____default()(this).parent().closest('blockquote', messageTextBody).length; // eslint-disable-line no-invalid-this
			});

			if ($oList && 0 < $oList.length) {
				$oList.each(function () {
					var $this = __WEBPACK_IMPORTED_MODULE_4_____default()(this); // eslint-disable-line no-invalid-this

					var h = $this.height();
					if (0 === h) {
						h = Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["getRealHeight"])($this);
					}

					if ('' !== Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["trim"])($this.text()) && (0 === h || 100 < h)) {
						$this.addClass('rl-bq-switcher hidden-bq');
						__WEBPACK_IMPORTED_MODULE_4_____default()('<span class="rlBlockquoteSwitcher"><i class="icon-ellipsis" /></span>').insertBefore($this).on('click.rlBlockquoteSwitcher', function () {
							$this.toggleClass('hidden-bq');
							Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["windowResize"])();
						}).after('<br />').before('<br />');
					}
				});
			}
		}
	};

	/**
  * @param {Object} messageTextBody
  * @param {Object} message
  */


	MessageUserStore.prototype.initOpenPgpControls = function initOpenPgpControls(messageTextBody, message) {
		if (messageTextBody && messageTextBody.find) {
			messageTextBody.find('.b-plain-openpgp:not(.inited)').each(function () {
				__WEBPACK_IMPORTED_MODULE_19_Stores_User_Pgp__["a" /* default */].initMessageBodyControls(__WEBPACK_IMPORTED_MODULE_4_____default()(this), message); // eslint-disable-line no-invalid-this
			});
		}
	};

	MessageUserStore.prototype.setMessage = function setMessage(data, cached) {

		var isNew = false,
		    body = null,
		    id = '',
		    plain = '',
		    resultHtml = '',
		    pgpSigned = false,
		    messagesDom = this.messagesBodiesDom(),
		    selectedMessage = this.selectorMessageSelected(),
		    message = this.message();

		if (data && message && data.Result && 'Object/Message' === data.Result['@Object'] && message.folderFullNameRaw === data.Result.Folder) {
			var threads = message.threads();
			if (message.uid !== data.Result.Uid && 1 < threads.length && -1 < Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["inArray"])(data.Result.Uid, threads)) {
				message = __WEBPACK_IMPORTED_MODULE_14_Model_Message__["a" /* MessageModel */].newInstanceFromJson(data.Result);
				if (message) {
					message.threads(threads);
					Object(__WEBPACK_IMPORTED_MODULE_7_Common_Cache__["n" /* initMessageFlagsFromCache */])(message);

					this.message(this.staticMessage.populateByMessageListItem(message));
					message = this.message();

					isNew = true;
				}
			}

			if (message && message.uid === data.Result.Uid) {
				this.messageError('');

				message.initUpdateByMessageJson(data.Result);
				Object(__WEBPACK_IMPORTED_MODULE_7_Common_Cache__["b" /* addRequestedMessage */])(message.folderFullNameRaw, message.uid);

				if (!cached) {
					message.initFlagsByJson(data.Result);
				}

				messagesDom = messagesDom && messagesDom[0] ? messagesDom : null;
				if (messagesDom) {
					id = 'rl-mgs-' + message.hash.replace(/[^a-zA-Z0-9]/g, '');

					var textBody = messagesDom.find('#' + id);
					if (!textBody || !textBody[0]) {
						var isHtml = false;
						if (Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["isNormal"])(data.Result.Html) && '' !== data.Result.Html) {
							isHtml = true;
							resultHtml = data.Result.Html.toString();
						} else if (Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["isNormal"])(data.Result.Plain) && '' !== data.Result.Plain) {
							isHtml = false;
							resultHtml = Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["plainToHtml"])(data.Result.Plain.toString(), false);

							if ((message.isPgpSigned() || message.isPgpEncrypted()) && __WEBPACK_IMPORTED_MODULE_19_Stores_User_Pgp__["a" /* default */].capaOpenPGP()) {
								plain = Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["pString"])(data.Result.Plain);

								var isPgpEncrypted = /---BEGIN PGP MESSAGE---/.test(plain);
								if (!isPgpEncrypted) {
									pgpSigned = /-----BEGIN PGP SIGNED MESSAGE-----/.test(plain) && /-----BEGIN PGP SIGNATURE-----/.test(plain);
								}

								__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$div"].empty();
								if (pgpSigned && message.isPgpSigned()) {
									resultHtml = __WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$div"].append(__WEBPACK_IMPORTED_MODULE_4_____default()('<pre class="b-plain-openpgp signed"></pre>').text(plain)).html();
								} else if (isPgpEncrypted && message.isPgpEncrypted()) {
									resultHtml = __WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$div"].append(__WEBPACK_IMPORTED_MODULE_4_____default()('<pre class="b-plain-openpgp encrypted"></pre>').text(plain)).html();
								} else {
									resultHtml = '<pre>' + resultHtml + '</pre>';
								}

								__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$div"].empty();

								message.isPgpSigned(pgpSigned);
								message.isPgpEncrypted(isPgpEncrypted);
							} else {
								resultHtml = '<pre>' + resultHtml + '</pre>';
							}
						} else {
							isHtml = false;
							resultHtml = '<pre>' + resultHtml + '</pre>';
						}

						__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["data"].iMessageBodyCacheCount += 1;

						body = __WEBPACK_IMPORTED_MODULE_4_____default()('<div id="' + id + '" ></div>').hide().addClass('rl-cache-class');
						body.data('rl-cache-count', __WEBPACK_IMPORTED_MODULE_9_Common_Globals__["data"].iMessageBodyCacheCount);

						body.html(Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["findEmailAndLinks"])(resultHtml)).addClass('b-text-part ' + (isHtml ? 'html' : 'plain'));

						message.isHtml(!!isHtml);
						message.hasImages(!!data.Result.HasExternals);

						message.body = body;
						if (message.body) {
							messagesDom.append(message.body);
						}

						message.storeDataInDom();

						if (data.Result.HasInternals) {
							message.showInternalImages(true);
						}

						if (message.hasImages() && __WEBPACK_IMPORTED_MODULE_20_Stores_User_Settings__["a" /* default */].showImages()) {
							message.showExternalImages(true);
						}

						this.purgeMessageBodyCacheThrottle();
					} else {
						message.body = textBody;
						if (message.body) {
							__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["data"].iMessageBodyCacheCount += 1;
							message.body.data('rl-cache-count', __WEBPACK_IMPORTED_MODULE_9_Common_Globals__["data"].iMessageBodyCacheCount);
							message.fetchDataFromDom();
						}
					}

					this.messageActiveDom(message.body);

					this.hideMessageBodies();

					if (body) {
						this.initOpenPgpControls(body, message);

						this.initBlockquoteSwitcher(body);
					}

					message.body.show();
				}

				Object(__WEBPACK_IMPORTED_MODULE_7_Common_Cache__["n" /* initMessageFlagsFromCache */])(message);
				if (message.unseen() || message.hasUnseenSubMessage()) {
					Object(__WEBPACK_IMPORTED_MODULE_22_Helper_Apps_User__["a" /* getApp */])().messageListAction(message.folderFullNameRaw, __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["MessageSetAction"].SetSeen, [message]);
				}

				if (isNew) {
					message = this.message();

					if (selectedMessage && message && (message.folderFullNameRaw !== selectedMessage.folderFullNameRaw || message.uid !== selectedMessage.uid)) {
						this.selectorMessageSelected(null);
						if (1 === this.messageList().length) {
							this.selectorMessageFocused(null);
						}
					} else if (!selectedMessage && message) {
						selectedMessage = __WEBPACK_IMPORTED_MODULE_2_____default.a.find(this.messageList(), function (subMessage) {
							return subMessage && subMessage.folderFullNameRaw === message.folderFullNameRaw && subMessage.uid === message.uid;
						});

						if (selectedMessage) {
							this.selectorMessageSelected(selectedMessage);
							this.selectorMessageFocused(selectedMessage);
						}
					}
				}

				Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["windowResize"])();
			}
		}
	};

	MessageUserStore.prototype.selectMessage = function selectMessage(oMessage) {
		if (oMessage) {
			this.message(this.staticMessage.populateByMessageListItem(oMessage));
			this.populateMessageBody(this.message());
		} else {
			this.message(null);
		}
	};

	MessageUserStore.prototype.selectMessageByFolderAndUid = function selectMessageByFolderAndUid(sFolder, sUid) {
		if (sFolder && sUid) {
			this.message(this.staticMessage.populateByMessageListItem(null));
			this.message().folderFullNameRaw = sFolder;
			this.message().uid = sUid;

			this.populateMessageBody(this.message());
		} else {
			this.message(null);
		}
	};

	MessageUserStore.prototype.populateMessageBody = function populateMessageBody(oMessage) {
		if (oMessage) {
			if (__WEBPACK_IMPORTED_MODULE_23_Remote_User_Ajax__["a" /* default */].message(this.onMessageResponse, oMessage.folderFullNameRaw, oMessage.uid)) {
				this.messageCurrentLoading(true);
			}
		}
	};

	/**
  * @param {string} sResult
  * @param {AjaxJsonDefaultResponse} oData
  * @param {boolean} bCached
  */


	MessageUserStore.prototype.onMessageResponse = function onMessageResponse(sResult, oData, bCached) {

		this.hideMessageBodies();

		this.messageCurrentLoading(false);

		if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["StorageResultType"].Success === sResult && oData && oData.Result) {
			this.setMessage(oData, bCached);
		} else if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["StorageResultType"].Unload === sResult) {
			this.message(null);
			this.messageError('');
		} else if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["StorageResultType"].Abort !== sResult) {
			this.message(null);
			this.messageError(oData && oData.ErrorCode ? Object(__WEBPACK_IMPORTED_MODULE_11_Common_Translator__["getNotification"])(oData.ErrorCode) : Object(__WEBPACK_IMPORTED_MODULE_11_Common_Translator__["getNotification"])(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Notification"].UnknownError));
		}
	};

	/**
  * @param {Array} list
  * @returns {string}
  */


	MessageUserStore.prototype.calculateMessageListHash = function calculateMessageListHash(list) {
		return __WEBPACK_IMPORTED_MODULE_2_____default.a.map(list, function (message) {
			return '' + message.hash + '_' + message.threadsLen() + '_' + message.flagHash();
		}).join('|');
	};

	MessageUserStore.prototype.setMessageList = function setMessageList(data, cached) {
		if (data && data.Result && 'Collection/MessageCollection' === data.Result['@Object'] && data.Result['@Collection'] && Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["isArray"])(data.Result['@Collection'])) {
			var newCount = 0,
			    unreadCountChange = false;

			var list = [],
			    utc = Object(__WEBPACK_IMPORTED_MODULE_12_Common_Momentor__["momentNowUnix"])(),
			    iCount = Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["pInt"])(data.Result.MessageResultCount),
			    iOffset = Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["pInt"])(data.Result.Offset);

			var folder = Object(__WEBPACK_IMPORTED_MODULE_7_Common_Cache__["e" /* getFolderFromCacheList */])(Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["isNormal"])(data.Result.Folder) ? data.Result.Folder : '');

			if (folder && !cached) {
				folder.interval = utc;

				Object(__WEBPACK_IMPORTED_MODULE_7_Common_Cache__["q" /* setFolderHash */])(data.Result.Folder, data.Result.FolderHash);

				if (Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["isNormal"])(data.Result.MessageCount)) {
					folder.messageCountAll(data.Result.MessageCount);
				}

				if (Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["isNormal"])(data.Result.MessageUnseenCount)) {
					if (Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["pInt"])(folder.messageCountUnread()) !== Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["pInt"])(data.Result.MessageUnseenCount)) {
						unreadCountChange = true;
					}

					folder.messageCountUnread(data.Result.MessageUnseenCount);
				}

				this.initUidNextAndNewMessages(folder.fullNameRaw, data.Result.UidNext, data.Result.NewMessages);
			}

			if (unreadCountChange && folder) {
				Object(__WEBPACK_IMPORTED_MODULE_7_Common_Cache__["c" /* clearMessageFlagsFromCacheByFolder */])(folder.fullNameRaw);
			}

			__WEBPACK_IMPORTED_MODULE_2_____default.a.each(data.Result['@Collection'], function (jsonMessage) {
				if (jsonMessage && 'Object/Message' === jsonMessage['@Object']) {
					var message = __WEBPACK_IMPORTED_MODULE_14_Model_Message__["a" /* MessageModel */].newInstanceFromJson(jsonMessage);
					if (message) {
						if (Object(__WEBPACK_IMPORTED_MODULE_7_Common_Cache__["l" /* hasNewMessageAndRemoveFromCache */])(message.folderFullNameRaw, message.uid) && 5 >= newCount) {
							newCount += 1;
							message.newForAnimation(true);
						}

						message.deleted(false);

						if (cached) {
							Object(__WEBPACK_IMPORTED_MODULE_7_Common_Cache__["n" /* initMessageFlagsFromCache */])(message);
						} else {
							Object(__WEBPACK_IMPORTED_MODULE_7_Common_Cache__["u" /* storeMessageFlagsToCache */])(message);
						}

						list.push(message);
					}
				}
			});

			this.messageListCount(iCount);
			this.messageListSearch(Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["isNormal"])(data.Result.Search) ? data.Result.Search : '');
			this.messageListPage(__WEBPACK_IMPORTED_MODULE_1_window___default.a.Math.ceil(iOffset / __WEBPACK_IMPORTED_MODULE_20_Stores_User_Settings__["a" /* default */].messagesPerPage() + 1));
			this.messageListThreadUid(Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["isNormal"])(data.Result.ThreadUid) ? Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["pString"])(data.Result.ThreadUid) : '');

			this.messageListEndFolder(Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["isNormal"])(data.Result.Folder) ? data.Result.Folder : '');
			this.messageListEndSearch(this.messageListSearch());
			this.messageListEndThreadUid(this.messageListThreadUid());
			this.messageListEndPage(this.messageListPage());

			this.messageListDisableAutoSelect(true);

			this.messageList(list);
			this.messageListIsNotCompleted(false);

			Object(__WEBPACK_IMPORTED_MODULE_7_Common_Cache__["d" /* clearNewMessageCache */])();

			if (folder && (cached || unreadCountChange || __WEBPACK_IMPORTED_MODULE_20_Stores_User_Settings__["a" /* default */].useThreads())) {
				Object(__WEBPACK_IMPORTED_MODULE_22_Helper_Apps_User__["a" /* getApp */])().folderInformation(folder.fullNameRaw, list);
			}
		} else {
			this.messageListCount(0);
			this.messageList([]);
			this.messageListError(Object(__WEBPACK_IMPORTED_MODULE_11_Common_Translator__["getNotification"])(data && data.ErrorCode ? data.ErrorCode : __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Notification"].CantGetMessageList));
		}
	};

	return MessageUserStore;
}();

/* harmony default export */ __webpack_exports__["a"] = (new MessageUserStore());

/***/ }),
/* 46 */
/*!***************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_to-primitive.js ***!
  \***************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

// 7.1.1 ToPrimitive(input [, PreferredType])
var isObject = __webpack_require__(/*! ./_is-object */ 29);
// instead of the ES6 spec version, we didn't implement @@toPrimitive case
// and the second argument - flag - preferred type is a string
module.exports = function (it, S) {
  if (!isObject(it)) return it;
  var fn, val;
  if (S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
  if (typeof (fn = it.valueOf) == 'function' && !isObject(val = fn.call(it))) return val;
  if (!S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
  throw TypeError("Can't convert object to primitive value");
};


/***/ }),
/* 47 */
/*!************************************!*\
  !*** ./dev/Stores/User/Account.js ***!
  \************************************/
/*! exports provided: default */
/*! exports used: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);







var AccountUserStore = function () {
	function AccountUserStore() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, AccountUserStore);

		this.email = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable('');
		this.parentEmail = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable('');

		this.signature = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable('');

		this.accounts = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observableArray([]);
		this.accounts.loading = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(false).extend({ throttle: __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["Magics"].Time100ms });

		this.computers();
	}

	AccountUserStore.prototype.computers = function computers() {
		var _this = this;

		this.accountsEmails = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].computed(function () {
			return __WEBPACK_IMPORTED_MODULE_2_____default.a.compact(__WEBPACK_IMPORTED_MODULE_2_____default.a.map(_this.accounts(), function (item) {
				return item ? item.email : null;
			}));
		});

		this.accountsUnreadCount = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].computed(function () {
			return 0;
		});
		// this.accountsUnreadCount = ko.computed(() => {
		// 	let result = 0;
		// 	_.each(this.accounts(), (item) => {
		// 		if (item)
		// 		{
		// 			result += item.count();
		// 		}
		// 	});
		// 	return result;
		// });
	};

	AccountUserStore.prototype.populate = function populate() {
		this.email(__WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["settingsGet"]('Email'));
		this.parentEmail(__WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["settingsGet"]('ParentEmail'));
	};

	/**
  * @returns {boolean}
  */


	AccountUserStore.prototype.isRootAccount = function isRootAccount() {
		return '' === this.parentEmail();
	};

	return AccountUserStore;
}();

/* harmony default export */ __webpack_exports__["a"] = (new AccountUserStore());

/***/ }),
/* 48 */,
/* 49 */
/*!**********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_defined.js ***!
  \**********************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

// 7.2.1 RequireObjectCoercible(argument)
module.exports = function (it) {
  if (it == undefined) throw TypeError("Can't call method on  " + it);
  return it;
};


/***/ }),
/* 50 */
/*!**************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-gopd.js ***!
  \**************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

var pIE = __webpack_require__(/*! ./_object-pie */ 51);
var createDesc = __webpack_require__(/*! ./_property-desc */ 39);
var toIObject = __webpack_require__(/*! ./_to-iobject */ 24);
var toPrimitive = __webpack_require__(/*! ./_to-primitive */ 46);
var has = __webpack_require__(/*! ./_has */ 25);
var IE8_DOM_DEFINE = __webpack_require__(/*! ./_ie8-dom-define */ 55);
var gOPD = Object.getOwnPropertyDescriptor;

exports.f = __webpack_require__(/*! ./_descriptors */ 23) ? gOPD : function getOwnPropertyDescriptor(O, P) {
  O = toIObject(O);
  P = toPrimitive(P, true);
  if (IE8_DOM_DEFINE) try {
    return gOPD(O, P);
  } catch (e) { /* empty */ }
  if (has(O, P)) return createDesc(!pIE.f.call(O, P), O[P]);
};


/***/ }),
/* 51 */
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-pie.js ***!
  \*************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

exports.f = {}.propertyIsEnumerable;


/***/ }),
/* 52 */
/*!******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_uid.js ***!
  \******************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

var id = 0;
var px = Math.random();
module.exports = function (key) {
  return 'Symbol('.concat(key === undefined ? '' : key, ')_', (++id + px).toString(36));
};


/***/ }),
/* 53 */
/*!********************************!*\
  !*** ./dev/Stores/User/Pgp.js ***!
  \********************************/
/*! exports provided: default */
/*! exports used: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3____ = __webpack_require__(/*! $ */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Stores_User_Account__ = __webpack_require__(/*! Stores/User/Account */ 47);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 9);













var PgpUserStore = function () {
	function PgpUserStore() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, PgpUserStore);

		this.capaOpenPGP = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(false);

		this.openpgp = null;

		this.openpgpkeys = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observableArray([]);
		this.openpgpKeyring = null;

		this.openpgpkeysPublic = this.openpgpkeys.filter(function (item) {
			return !!(item && !item.isPrivate);
		});
		this.openpgpkeysPrivate = this.openpgpkeys.filter(function (item) {
			return !!(item && item.isPrivate);
		});
	}

	/**
  * @returns {boolean}
  */


	PgpUserStore.prototype.isSupported = function isSupported() {
		return !!this.openpgp;
	};

	PgpUserStore.prototype.findKeyByHex = function findKeyByHex(keys, hash) {
		return __WEBPACK_IMPORTED_MODULE_2_____default.a.find(keys, function (item) {
			return hash && item && (hash === item.id || -1 < item.ids.indexOf(hash));
		});
	};

	PgpUserStore.prototype.findPublicKeyByHex = function findPublicKeyByHex(hash) {
		return this.findKeyByHex(this.openpgpkeysPublic(), hash);
	};

	PgpUserStore.prototype.findPrivateKeyByHex = function findPrivateKeyByHex(hash) {
		return this.findKeyByHex(this.openpgpkeysPrivate(), hash);
	};

	PgpUserStore.prototype.findPublicKeysByEmail = function findPublicKeysByEmail(email) {
		return __WEBPACK_IMPORTED_MODULE_2_____default.a.compact(__WEBPACK_IMPORTED_MODULE_2_____default.a.flatten(__WEBPACK_IMPORTED_MODULE_2_____default.a.map(this.openpgpkeysPublic(), function (item) {
			var key = item && -1 < item.emails.indexOf(email) ? item : null;
			return key ? key.getNativeKeys() : [null];
		}), true));
	};

	PgpUserStore.prototype.findPublicKeysBySigningKeyIds = function findPublicKeysBySigningKeyIds(signingKeyIds) {
		var _this = this;

		return __WEBPACK_IMPORTED_MODULE_2_____default.a.compact(__WEBPACK_IMPORTED_MODULE_2_____default.a.flatten(__WEBPACK_IMPORTED_MODULE_2_____default.a.map(signingKeyIds, function (id) {
			var key = id && id.toHex ? _this.findPublicKeyByHex(id.toHex()) : null;
			return key ? key.getNativeKeys() : [null];
		}), true));
	};

	PgpUserStore.prototype.findPrivateKeysByEncryptionKeyIds = function findPrivateKeysByEncryptionKeyIds(encryptionKeyIds, recipients, returnWrapKeys) {
		var _this2 = this;

		var result = Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isArray"])(encryptionKeyIds) ? __WEBPACK_IMPORTED_MODULE_2_____default.a.compact(__WEBPACK_IMPORTED_MODULE_2_____default.a.flatten(__WEBPACK_IMPORTED_MODULE_2_____default.a.map(encryptionKeyIds, function (id) {
			var key = id && id.toHex ? _this2.findPrivateKeyByHex(id.toHex()) : null;
			return key ? returnWrapKeys ? [key] : key.getNativeKeys() : [null];
		}), true)) : [];

		if (0 === result.length && Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isNonEmptyArray"])(recipients)) {
			result = __WEBPACK_IMPORTED_MODULE_2_____default.a.uniq(__WEBPACK_IMPORTED_MODULE_2_____default.a.compact(__WEBPACK_IMPORTED_MODULE_2_____default.a.flatten(__WEBPACK_IMPORTED_MODULE_2_____default.a.map(recipients, function (sEmail) {
				var keys = sEmail ? _this2.findAllPrivateKeysByEmailNotNative(sEmail) : null;
				return keys ? returnWrapKeys ? keys : __WEBPACK_IMPORTED_MODULE_2_____default.a.flatten(__WEBPACK_IMPORTED_MODULE_2_____default.a.map(keys, function (key) {
					return key.getNativeKeys();
				}), true) : [null];
			}), true)), function (key) {
				return key.id;
			});
		}

		return result;
	};

	/**
  * @param {string} email
  * @returns {?}
  */


	PgpUserStore.prototype.findPublicKeyByEmailNotNative = function findPublicKeyByEmailNotNative(email) {
		return __WEBPACK_IMPORTED_MODULE_2_____default.a.find(this.openpgpkeysPublic(), function (item) {
			return item && -1 < item.emails.indexOf(email);
		}) || null;
	};

	/**
  * @param {string} email
  * @returns {?}
  */


	PgpUserStore.prototype.findPrivateKeyByEmailNotNative = function findPrivateKeyByEmailNotNative(email) {
		return __WEBPACK_IMPORTED_MODULE_2_____default.a.find(this.openpgpkeysPrivate(), function (item) {
			return item && -1 < item.emails.indexOf(email);
		}) || null;
	};

	/**
  * @param {string} email
  * @returns {?}
  */


	PgpUserStore.prototype.findAllPublicKeysByEmailNotNative = function findAllPublicKeysByEmailNotNative(email) {
		return __WEBPACK_IMPORTED_MODULE_2_____default.a.filter(this.openpgpkeysPublic(), function (item) {
			return item && -1 < item.emails.indexOf(email);
		}) || null;
	};

	/**
  * @param {string} email
  * @returns {?}
  */


	PgpUserStore.prototype.findAllPrivateKeysByEmailNotNative = function findAllPrivateKeysByEmailNotNative(email) {
		return __WEBPACK_IMPORTED_MODULE_2_____default.a.filter(this.openpgpkeysPrivate(), function (item) {
			return item && -1 < item.emails.indexOf(email);
		}) || null;
	};

	/**
  * @param {string} email
  * @param {string=} password
  * @returns {?}
  */


	PgpUserStore.prototype.findPrivateKeyByEmail = function findPrivateKeyByEmail(email, password) {

		var privateKey = null;
		var key = __WEBPACK_IMPORTED_MODULE_2_____default.a.find(this.openpgpkeysPrivate(), function (item) {
			return item && -1 < item.emails.indexOf(email);
		});

		if (key) {
			try {
				privateKey = key.getNativeKeys()[0] || null;
				if (privateKey) {
					privateKey.decrypt(Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pString"])(password));
				}
			} catch (e) {
				privateKey = null;
			}
		}

		return privateKey;
	};

	/**
  * @param {string=} password
  * @returns {?}
  */


	PgpUserStore.prototype.findSelfPrivateKey = function findSelfPrivateKey(password) {
		return this.findPrivateKeyByEmail(__WEBPACK_IMPORTED_MODULE_6_Stores_User_Account__["a" /* default */].email(), password);
	};

	PgpUserStore.prototype.decryptMessage = function decryptMessage(message, recipients, fCallback) {
		var _this3 = this;

		if (message && message.getEncryptionKeyIds) {
			var privateKeys = this.findPrivateKeysByEncryptionKeyIds(message.getEncryptionKeyIds(), recipients, true);
			if (privateKeys && 0 < privateKeys.length) {
				Object(__WEBPACK_IMPORTED_MODULE_7_Knoin_Knoin__["showScreenPopup"])(__webpack_require__(/*! View/Popup/MessageOpenPgp */ 213), [function (decryptedKey) {

					if (decryptedKey) {
						message.decrypt(decryptedKey).then(function (decryptedMessage) {
							var privateKey = null;
							if (decryptedMessage) {
								privateKey = _this3.findPrivateKeyByHex(decryptedKey.primaryKey.keyid.toHex());
								if (privateKey) {
									_this3.verifyMessage(decryptedMessage, function (oValidKey, aSigningKeyIds) {
										fCallback(privateKey, decryptedMessage, oValidKey || null, aSigningKeyIds || null);
									});
								} else {
									fCallback(privateKey, decryptedMessage);
								}
							} else {
								fCallback(privateKey, decryptedMessage);
							}
						}, function () {
							fCallback(null, null);
						});
					} else {
						fCallback(null, null);
					}
				}, privateKeys]);

				return false;
			}
		}

		fCallback(null, null);

		return false;
	};

	PgpUserStore.prototype.verifyMessage = function verifyMessage(message, fCallback) {
		if (message && message.getSigningKeyIds) {
			var signingKeyIds = message.getSigningKeyIds();
			if (signingKeyIds && 0 < signingKeyIds.length) {
				var publicKeys = this.findPublicKeysBySigningKeyIds(signingKeyIds);
				if (publicKeys && 0 < publicKeys.length) {
					try {
						var result = message.verify(publicKeys),
						    valid = __WEBPACK_IMPORTED_MODULE_2_____default.a.find(__WEBPACK_IMPORTED_MODULE_2_____default.a.isArray(result) ? result : [], function (item) {
							return item && item.valid && item.keyid;
						});

						if (valid && valid.keyid && valid.keyid && valid.keyid.toHex) {
							fCallback(this.findPublicKeyByHex(valid.keyid.toHex()));
							return true;
						}
					} catch (e) {
						Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["log"])(e);
					}
				}

				fCallback(null, signingKeyIds);
				return false;
			}
		}

		fCallback(null);
		return false;
	};

	PgpUserStore.prototype.controlsHelper = function controlsHelper(dom, verControl, success, title, text) {
		if (success) {
			dom.removeClass('error').addClass('success').attr('title', title);
			verControl.removeClass('error').addClass('success').attr('title', title);
		} else {
			dom.removeClass('success').addClass('error').attr('title', title);
			verControl.removeClass('success').addClass('error').attr('title', title);
		}

		if (!Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isUnd"])(text)) {
			dom.text(Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["trim"])(text));
		}
	};

	PgpUserStore.domControlEncryptedClickHelper = function domControlEncryptedClickHelper(store, dom, armoredMessage, recipients) {

		return function () {

			var message = null;
			var $this = __WEBPACK_IMPORTED_MODULE_3_____default()(this); // eslint-disable-line no-invalid-this

			if ($this.hasClass('success')) {
				return false;
			}

			try {
				message = store.openpgp.message.readArmored(armoredMessage);
			} catch (e) {
				Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["log"])(e);
			}

			if (message && message.getText && message.verify && message.decrypt) {
				store.decryptMessage(message, recipients, function (validPrivateKey, decryptedMessage, validPublicKey, signingKeyIds) {
					if (decryptedMessage) {
						if (validPublicKey) {
							store.controlsHelper(dom, $this, true, Object(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('PGP_NOTIFICATIONS/GOOD_SIGNATURE', {
								'USER': validPublicKey.user + ' (' + validPublicKey.id + ')'
							}), decryptedMessage.getText());
						} else if (validPrivateKey) {
							var keyIds = Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isNonEmptyArray"])(signingKeyIds) ? signingKeyIds : null,
							    additional = keyIds ? __WEBPACK_IMPORTED_MODULE_2_____default.a.compact(__WEBPACK_IMPORTED_MODULE_2_____default.a.map(keyIds, function (item) {
								return item && item.toHex ? item.toHex() : null;
							})).join(', ') : '';

							store.controlsHelper(dom, $this, false, Object(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('PGP_NOTIFICATIONS/UNVERIFIRED_SIGNATURE') + (additional ? ' (' + additional + ')' : ''), decryptedMessage.getText());
						} else {
							store.controlsHelper(dom, $this, false, Object(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('PGP_NOTIFICATIONS/DECRYPTION_ERROR'));
						}
					} else {
						store.controlsHelper(dom, $this, false, Object(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('PGP_NOTIFICATIONS/DECRYPTION_ERROR'));
					}
				});

				return false;
			}

			store.controlsHelper(dom, $this, false, Object(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('PGP_NOTIFICATIONS/DECRYPTION_ERROR'));
			return false;
		};
	};

	PgpUserStore.domControlSignedClickHelper = function domControlSignedClickHelper(store, dom, armoredMessage) {

		return function () {

			var message = null;
			var $this = __WEBPACK_IMPORTED_MODULE_3_____default()(this); // eslint-disable-line no-invalid-this

			if ($this.hasClass('success') || $this.hasClass('error')) {
				return false;
			}

			try {
				message = store.openpgp.cleartext.readArmored(armoredMessage);
			} catch (e) {
				Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["log"])(e);
			}

			if (message && message.getText && message.verify) {
				store.verifyMessage(message, function (validKey, signingKeyIds) {
					if (validKey) {
						store.controlsHelper(dom, $this, true, Object(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('PGP_NOTIFICATIONS/GOOD_SIGNATURE', {
							'USER': validKey.user + ' (' + validKey.id + ')'
						}), message.getText());
					} else {
						var keyIds = Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isNonEmptyArray"])(signingKeyIds) ? signingKeyIds : null,
						    additional = keyIds ? __WEBPACK_IMPORTED_MODULE_2_____default.a.compact(__WEBPACK_IMPORTED_MODULE_2_____default.a.map(keyIds, function (item) {
							return item && item.toHex ? item.toHex() : null;
						})).join(', ') : '';

						store.controlsHelper(dom, $this, false, Object(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('PGP_NOTIFICATIONS/UNVERIFIRED_SIGNATURE') + (additional ? ' (' + additional + ')' : ''));
					}
				});

				return false;
			}

			store.controlsHelper(dom, $this, false, Object(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('PGP_NOTIFICATIONS/DECRYPTION_ERROR'));
			return false;
		};
	};

	/**
  * @param {*} dom
  * @param {MessageModel} rainLoopMessage
  */


	PgpUserStore.prototype.initMessageBodyControls = function initMessageBodyControls(dom, rainLoopMessage) {
		if (dom && !dom.hasClass('inited')) {
			dom.addClass('inited');

			var encrypted = dom.hasClass('encrypted'),
			    signed = dom.hasClass('signed'),
			    recipients = rainLoopMessage ? rainLoopMessage.getEmails(['from', 'to', 'cc']) : [];

			var verControl = null;

			if (encrypted || signed) {
				var domText = dom.text();
				dom.data('openpgp-original', domText);

				if (encrypted) {
					verControl = __WEBPACK_IMPORTED_MODULE_3_____default()('<div class="b-openpgp-control"><i class="icon-lock"></i></div>').attr('title', Object(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('MESSAGE/PGP_ENCRYPTED_MESSAGE_DESC')).on('click', PgpUserStore.domControlEncryptedClickHelper(this, dom, domText, recipients));
				} else if (signed) {
					verControl = __WEBPACK_IMPORTED_MODULE_3_____default()('<div class="b-openpgp-control"><i class="icon-lock"></i></div>').attr('title', Object(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('MESSAGE/PGP_SIGNED_MESSAGE_DESC')).on('click', PgpUserStore.domControlSignedClickHelper(this, dom, domText));
				}

				if (verControl) {
					dom.before(verControl).before('<div></div>');
				}
			}
		}
	};

	return PgpUserStore;
}();

/* harmony default export */ __webpack_exports__["a"] = (new PgpUserStore());

/***/ }),
/* 54 */
/*!****************************************!*\
  !*** ./dev/Component/AbstractInput.js ***!
  \****************************************/
/*! exports provided: AbstractInput, default */
/*! exports used: AbstractInput */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AbstractInput; });
/* unused harmony export default */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 18);









var AbstractInput = function (_AbstractComponent) {
	__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(AbstractInput, _AbstractComponent);

	/**
  * @param {Object} params
  */
	function AbstractInput(params) {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, AbstractInput);

		var _this = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractComponent.call(this));

		_this.value = params.value || '';
		_this.size = params.size || 0;
		_this.label = params.label || '';
		_this.preLabel = params.preLabel || '';
		_this.enable = Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isUnd"])(params.enable) ? true : params.enable;
		_this.trigger = params.trigger && params.trigger.subscribe ? params.trigger : null;
		_this.placeholder = params.placeholder || '';

		_this.labeled = !Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isUnd"])(params.label);
		_this.preLabeled = !Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isUnd"])(params.preLabel);
		_this.triggered = !Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isUnd"])(params.trigger) && !!_this.trigger;

		_this.classForTrigger = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable('');

		_this.className = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].computed(function () {
			var size = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].unwrap(_this.size),
			    suffixValue = _this.trigger ? ' ' + Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["trim"])('settings-saved-trigger-input ' + _this.classForTrigger()) : '';
			return (0 < size ? 'span' + size : '') + suffixValue;
		});

		if (!Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isUnd"])(params.width) && params.element) {
			params.element.find('input,select,textarea').css('width', params.width);
		}

		_this.disposable.push(_this.className);

		if (_this.trigger) {
			_this.setTriggerState(_this.trigger());

			_this.disposable.push(_this.trigger.subscribe(_this.setTriggerState, _this));
		}
		return _this;
	}

	AbstractInput.prototype.setTriggerState = function setTriggerState(value) {
		switch (Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["pInt"])(value)) {
			case __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["SaveSettingsStep"].TrueResult:
				this.classForTrigger('success');
				break;
			case __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["SaveSettingsStep"].FalseResult:
				this.classForTrigger('error');
				break;
			default:
				this.classForTrigger('');
				break;
		}
	};

	return AbstractInput;
}(__WEBPACK_IMPORTED_MODULE_6_Component_Abstract__["a" /* AbstractComponent */]);



/***/ }),
/* 55 */
/*!*****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_ie8-dom-define.js ***!
  \*****************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

module.exports = !__webpack_require__(/*! ./_descriptors */ 23) && !__webpack_require__(/*! ./_fails */ 30)(function () {
  return Object.defineProperty(__webpack_require__(/*! ./_dom-create */ 59)('div'), 'a', { get: function () { return 7; } }).a != 7;
});


/***/ }),
/* 56 */
/*!******************************!*\
  !*** ./dev/Stores/Social.js ***!
  \******************************/
/*! exports provided: default */
/*! exports used: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3____ = __webpack_require__(/*! $ */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);







var SocialStore = function () {
	function SocialStore() {
		var _this = this;

		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, SocialStore);

		this.google = {};
		this.twitter = {};
		this.facebook = {};
		this.dropbox = {};

		// Google
		this.google.enabled = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(false);

		this.google.clientID = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable('');
		this.google.clientSecret = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable('');
		this.google.apiKey = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable('');

		this.google.loading = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(false);
		this.google.userName = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable('');

		this.google.loggined = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].computed(function () {
			return '' !== _this.google.userName();
		});

		this.google.capa = {};
		this.google.capa.auth = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(false);
		this.google.capa.authFast = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(false);
		this.google.capa.drive = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(false);
		this.google.capa.preview = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(false);

		this.google.require = {};
		this.google.require.clientSettings = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].computed(function () {
			return _this.google.enabled() && (_this.google.capa.auth() || _this.google.capa.drive());
		});

		this.google.require.apiKeySettings = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].computed(function () {
			return _this.google.enabled() && _this.google.capa.drive();
		});

		// Facebook
		this.facebook.enabled = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(false);
		this.facebook.appID = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable('');
		this.facebook.appSecret = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable('');
		this.facebook.loading = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(false);
		this.facebook.userName = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable('');
		this.facebook.supported = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(false);

		this.facebook.loggined = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].computed(function () {
			return '' !== _this.facebook.userName();
		});

		// Twitter
		this.twitter.enabled = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(false);
		this.twitter.consumerKey = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable('');
		this.twitter.consumerSecret = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable('');
		this.twitter.loading = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(false);
		this.twitter.userName = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable('');

		this.twitter.loggined = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].computed(function () {
			return '' !== _this.twitter.userName();
		});

		// Dropbox
		this.dropbox.enabled = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(false);
		this.dropbox.apiKey = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable('');
	}

	SocialStore.prototype.populate = function populate() {
		this.google.enabled(!!__WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["settingsGet"]('AllowGoogleSocial'));
		this.google.clientID(__WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["settingsGet"]('GoogleClientID'));
		this.google.clientSecret(__WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["settingsGet"]('GoogleClientSecret'));
		this.google.apiKey(__WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["settingsGet"]('GoogleApiKey'));

		this.google.capa.auth(!!__WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["settingsGet"]('AllowGoogleSocialAuth'));
		this.google.capa.authFast(!!__WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["settingsGet"]('AllowGoogleSocialAuthFast'));
		this.google.capa.drive(!!__WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["settingsGet"]('AllowGoogleSocialDrive'));
		this.google.capa.preview(!!__WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["settingsGet"]('AllowGoogleSocialPreview'));

		this.facebook.enabled(!!__WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["settingsGet"]('AllowFacebookSocial'));
		this.facebook.appID(__WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["settingsGet"]('FacebookAppID'));
		this.facebook.appSecret(__WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["settingsGet"]('FacebookAppSecret'));
		this.facebook.supported(!!__WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["settingsGet"]('SupportedFacebookSocial'));

		this.twitter.enabled = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(!!__WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["settingsGet"]('AllowTwitterSocial'));
		this.twitter.consumerKey = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(__WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["settingsGet"]('TwitterConsumerKey'));
		this.twitter.consumerSecret = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(__WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["settingsGet"]('TwitterConsumerSecret'));

		this.dropbox.enabled(!!__WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["settingsGet"]('AllowDropboxSocial'));
		this.dropbox.apiKey(__WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["settingsGet"]('DropboxApiKey'));
	};

	SocialStore.prototype.appendDropbox = function appendDropbox() {
		if (!__WEBPACK_IMPORTED_MODULE_1_window___default.a.Dropbox && this.dropbox.enabled() && this.dropbox.apiKey()) {
			if (!__WEBPACK_IMPORTED_MODULE_1_window___default.a.document.getElementById('dropboxjs')) {
				var script = __WEBPACK_IMPORTED_MODULE_1_window___default.a.document.createElement('script');
				script.type = 'text/javascript';
				script.src = 'https://www.dropbox.com/static/api/2/dropins.js';
				__WEBPACK_IMPORTED_MODULE_3_____default()(script).attr('id', 'dropboxjs').attr('data-app-key', this.dropbox.apiKey());

				__WEBPACK_IMPORTED_MODULE_1_window___default.a.document.body.appendChild(script);
			}
		}
	};

	return SocialStore;
}();

/* harmony default export */ __webpack_exports__["a"] = (new SocialStore());

/***/ }),
/* 57 */
/*!********************************!*\
  !*** ./dev/Stores/Language.js ***!
  \********************************/
/*! exports provided: default */
/*! exports used: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);






var LanguageStore = function () {
	function LanguageStore() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, LanguageStore);

		this.languages = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observableArray([]);
		this.languagesAdmin = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observableArray([]);

		this.language = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable('').extend({ limitedList: this.languages }).extend({ reversible: true });

		this.languageAdmin = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable('').extend({ limitedList: this.languagesAdmin }).extend({ reversible: true });

		this.userLanguage = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable('');
		this.userLanguageAdmin = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable('');
	}

	LanguageStore.prototype.populate = function populate() {
		var aLanguages = __WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["appSettingsGet"]('languages'),
		    aLanguagesAdmin = __WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["appSettingsGet"]('languagesAdmin');

		this.languages(Object(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["isArray"])(aLanguages) ? aLanguages : []);
		this.languagesAdmin(Object(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["isArray"])(aLanguagesAdmin) ? aLanguagesAdmin : []);

		this.language(__WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('Language'));
		this.languageAdmin(__WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('LanguageAdmin'));

		this.userLanguage(__WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('UserLanguage'));
		this.userLanguageAdmin(__WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('UserLanguageAdmin'));
	};

	return LanguageStore;
}();

/* harmony default export */ __webpack_exports__["a"] = (new LanguageStore());

/***/ }),
/* 58 */
/*!******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_ctx.js ***!
  \******************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

// optional / simple context binding
var aFunction = __webpack_require__(/*! ./_a-function */ 78);
module.exports = function (fn, that, length) {
  aFunction(fn);
  if (that === undefined) return fn;
  switch (length) {
    case 1: return function (a) {
      return fn.call(that, a);
    };
    case 2: return function (a, b) {
      return fn.call(that, a, b);
    };
    case 3: return function (a, b, c) {
      return fn.call(that, a, b, c);
    };
  }
  return function (/* ...args */) {
    return fn.apply(that, arguments);
  };
};


/***/ }),
/* 59 */
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_dom-create.js ***!
  \*************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(/*! ./_is-object */ 29);
var document = __webpack_require__(/*! ./_global */ 21).document;
// typeof document.createElement is 'object' in old IE
var is = isObject(document) && isObject(document.createElement);
module.exports = function (it) {
  return is ? document.createElement(it) : {};
};


/***/ }),
/* 60 */
/*!******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_cof.js ***!
  \******************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

var toString = {}.toString;

module.exports = function (it) {
  return toString.call(it).slice(8, -1);
};


/***/ }),
/* 61 */
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_to-integer.js ***!
  \*************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

// 7.1.4 ToInteger
var ceil = Math.ceil;
var floor = Math.floor;
module.exports = function (it) {
  return isNaN(it = +it) ? 0 : (it > 0 ? floor : ceil)(it);
};


/***/ }),
/* 62 */
/*!**********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_library.js ***!
  \**********************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

module.exports = true;


/***/ }),
/* 63 */
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_iterators.js ***!
  \************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

module.exports = {};


/***/ }),
/* 64 */
/*!****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-create.js ***!
  \****************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])
var anObject = __webpack_require__(/*! ./_an-object */ 35);
var dPs = __webpack_require__(/*! ./_object-dps */ 116);
var enumBugKeys = __webpack_require__(/*! ./_enum-bug-keys */ 68);
var IE_PROTO = __webpack_require__(/*! ./_shared-key */ 66)('IE_PROTO');
var Empty = function () { /* empty */ };
var PROTOTYPE = 'prototype';

// Create object with fake `null` prototype: use iframe Object with cleared prototype
var createDict = function () {
  // Thrash, waste and sodomy: IE GC bug
  var iframe = __webpack_require__(/*! ./_dom-create */ 59)('iframe');
  var i = enumBugKeys.length;
  var lt = '<';
  var gt = '>';
  var iframeDocument;
  iframe.style.display = 'none';
  __webpack_require__(/*! ./_html */ 120).appendChild(iframe);
  iframe.src = 'javascript:'; // eslint-disable-line no-script-url
  // createDict = iframe.contentWindow.Object;
  // html.removeChild(iframe);
  iframeDocument = iframe.contentWindow.document;
  iframeDocument.open();
  iframeDocument.write(lt + 'script' + gt + 'document.F=Object' + lt + '/script' + gt);
  iframeDocument.close();
  createDict = iframeDocument.F;
  while (i--) delete createDict[PROTOTYPE][enumBugKeys[i]];
  return createDict();
};

module.exports = Object.create || function create(O, Properties) {
  var result;
  if (O !== null) {
    Empty[PROTOTYPE] = anObject(O);
    result = new Empty();
    Empty[PROTOTYPE] = null;
    // add "__proto__" for Object.getPrototypeOf polyfill
    result[IE_PROTO] = O;
  } else result = createDict();
  return Properties === undefined ? result : dPs(result, Properties);
};


/***/ }),
/* 65 */
/*!**************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-keys.js ***!
  \**************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.14 / 15.2.3.14 Object.keys(O)
var $keys = __webpack_require__(/*! ./_object-keys-internal */ 90);
var enumBugKeys = __webpack_require__(/*! ./_enum-bug-keys */ 68);

module.exports = Object.keys || function keys(O) {
  return $keys(O, enumBugKeys);
};


/***/ }),
/* 66 */
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_shared-key.js ***!
  \*************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

var shared = __webpack_require__(/*! ./_shared */ 67)('keys');
var uid = __webpack_require__(/*! ./_uid */ 52);
module.exports = function (key) {
  return shared[key] || (shared[key] = uid(key));
};


/***/ }),
/* 67 */
/*!*********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_shared.js ***!
  \*********************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(/*! ./_global */ 21);
var SHARED = '__core-js_shared__';
var store = global[SHARED] || (global[SHARED] = {});
module.exports = function (key) {
  return store[key] || (store[key] = {});
};


/***/ }),
/* 68 */
/*!****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_enum-bug-keys.js ***!
  \****************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

// IE 8- don't enum bug keys
module.exports = (
  'constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf'
).split(',');


/***/ }),
/* 69 */
/*!********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_set-to-string-tag.js ***!
  \********************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

var def = __webpack_require__(/*! ./_object-dp */ 26).f;
var has = __webpack_require__(/*! ./_has */ 25);
var TAG = __webpack_require__(/*! ./_wks */ 36)('toStringTag');

module.exports = function (it, tag, stat) {
  if (it && !has(it = stat ? it : it.prototype, TAG)) def(it, TAG, { configurable: true, value: tag });
};


/***/ }),
/* 70 */
/*!**********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_wks-ext.js ***!
  \**********************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

exports.f = __webpack_require__(/*! ./_wks */ 36);


/***/ }),
/* 71 */
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_wks-define.js ***!
  \*************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(/*! ./_global */ 21);
var core = __webpack_require__(/*! ./_core */ 22);
var LIBRARY = __webpack_require__(/*! ./_library */ 62);
var wksExt = __webpack_require__(/*! ./_wks-ext */ 70);
var defineProperty = __webpack_require__(/*! ./_object-dp */ 26).f;
module.exports = function (name) {
  var $Symbol = core.Symbol || (core.Symbol = LIBRARY ? {} : global.Symbol || {});
  if (name.charAt(0) != '_' && !(name in $Symbol)) defineProperty($Symbol, name, { value: wksExt.f(name) });
};


/***/ }),
/* 72 */
/*!*****************************!*\
  !*** ./dev/Stores/Theme.js ***!
  \*****************************/
/*! exports provided: default */
/*! exports used: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);






var ThemeStore = function () {
	function ThemeStore() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, ThemeStore);

		this.themes = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observableArray([]);
		this.themeBackgroundName = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable('');
		this.themeBackgroundHash = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable('');

		this.theme = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable('').extend({ limitedList: this.themes });
	}

	ThemeStore.prototype.populate = function populate() {
		var themes = __WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["appSettingsGet"]('themes');

		this.themes(Object(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["isArray"])(themes) ? themes : []);
		this.theme(__WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('Theme'));
		this.themeBackgroundName(__WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('UserBackgroundName'));
		this.themeBackgroundHash(__WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('UserBackgroundHash'));
	};

	return ThemeStore;
}();

/* harmony default export */ __webpack_exports__["a"] = (new ThemeStore());

/***/ }),
/* 73 */
/*!***********************************!*\
  !*** ./dev/Component/Checkbox.js ***!
  \***********************************/
/*! exports provided: default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 18);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Component_AbstracCheckbox__ = __webpack_require__(/*! Component/AbstracCheckbox */ 96);







var CheckboxComponent = function (_AbstracCheckbox) {
  __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(CheckboxComponent, _AbstracCheckbox);

  function CheckboxComponent() {
    __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, CheckboxComponent);

    return __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstracCheckbox.apply(this, arguments));
  }

  return CheckboxComponent;
}(__WEBPACK_IMPORTED_MODULE_4_Component_AbstracCheckbox__["a" /* AbstracCheckbox */]);

/* harmony default export */ __webpack_exports__["default"] = (Object(__WEBPACK_IMPORTED_MODULE_3_Component_Abstract__["b" /* componentExportHelper */])(CheckboxComponent, 'CheckboxComponent'));

/***/ }),
/* 74 */,
/* 75 */
/*!********************************!*\
  !*** external "window.moment" ***!
  \********************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

module.exports = window.moment;

/***/ }),
/* 76 */
/*!*************************************!*\
  !*** ./dev/Knoin/AbstractScreen.js ***!
  \*************************************/
/*! exports provided: AbstractScreen */
/*! exports used: AbstractScreen */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AbstractScreen; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_crossroads__ = __webpack_require__(/*! crossroads */ 86);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_crossroads___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_crossroads__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);






var AbstractScreen = function () {
	function AbstractScreen(screenName) {
		var viewModels = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, AbstractScreen);

		this.oCross = null;

		this.sScreenName = screenName;
		this.aViewModels = Object(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["isArray"])(viewModels) ? viewModels : [];
	}

	/**
  * @returns {Array}
  */


	AbstractScreen.prototype.viewModels = function viewModels() {
		return this.aViewModels;
	};

	/**
  * @returns {string}
  */


	AbstractScreen.prototype.screenName = function screenName() {
		return this.sScreenName;
	};

	/**
  * @returns {?Array)}
  */


	AbstractScreen.prototype.routes = function routes() {
		return null;
	};

	/**
  * @returns {?Object}
  */


	AbstractScreen.prototype.__cross = function __cross() {
		return this.oCross;
	};

	/**
  * @returns {void}
  */


	AbstractScreen.prototype.__start = function __start() {
		var route = null,
		    fMatcher = null;
		var routes = this.routes();

		if (Object(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["isNonEmptyArray"])(routes)) {
			fMatcher = __WEBPACK_IMPORTED_MODULE_1_____default.a.bind(this.onRoute || __WEBPACK_IMPORTED_MODULE_3_Common_Utils__["noop"], this);
			route = __WEBPACK_IMPORTED_MODULE_2_crossroads___default.a.create();

			routes.forEach(function (item) {
				if (item && route) {
					route.addRoute(item[0], fMatcher).rules = item[1];
				}
			});

			this.oCross = route;
		}
	};

	return AbstractScreen;
}();

/***/ }),
/* 77 */
/*!*******************************!*\
  !*** ./dev/View/Popup/Ask.js ***!
  \*******************************/
/*! exports provided: AskPopupView, default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AskPopupView", function() { return AskPopupView; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return AskPopupView; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_key__ = __webpack_require__(/*! key */ 19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_key___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_key__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Knoin_AbstractViewNext__ = __webpack_require__(/*! Knoin/AbstractViewNext */ 13);




var _dec, _class;











var AskPopupView = (_dec = Object(__WEBPACK_IMPORTED_MODULE_8_Knoin_Knoin__["popup"])({
	name: 'View/Popup/Ask',
	templateID: 'PopupsAsk'
}), _dec(_class = function (_AbstractViewNext) {
	__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(AskPopupView, _AbstractViewNext);

	function AskPopupView() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, AskPopupView);

		var _this = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractViewNext.call(this));

		_this.askDesc = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable('');
		_this.yesButton = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable('');
		_this.noButton = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable('');

		_this.yesFocus = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(false);
		_this.noFocus = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(false);

		_this.fYesAction = null;
		_this.fNoAction = null;

		_this.bFocusYesOnShow = true;
		_this.bDisabeCloseOnEsc = true;
		_this.sDefaultKeyScope = __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].PopupAsk;
		return _this;
	}

	AskPopupView.prototype.clearPopup = function clearPopup() {
		this.askDesc('');
		this.yesButton(Object(__WEBPACK_IMPORTED_MODULE_7_Common_Translator__["i18n"])('POPUPS_ASK/BUTTON_YES'));
		this.noButton(Object(__WEBPACK_IMPORTED_MODULE_7_Common_Translator__["i18n"])('POPUPS_ASK/BUTTON_NO'));

		this.yesFocus(false);
		this.noFocus(false);

		this.fYesAction = null;
		this.fNoAction = null;
	};

	AskPopupView.prototype.yesClick = function yesClick() {
		this.cancelCommand();

		if (Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["isFunc"])(this.fYesAction)) {
			this.fYesAction.call(null);
		}
	};

	AskPopupView.prototype.noClick = function noClick() {
		this.cancelCommand();

		if (Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["isFunc"])(this.fNoAction)) {
			this.fNoAction.call(null);
		}
	};

	/**
  * @param {string} sAskDesc
  * @param {Function=} fYesFunc
  * @param {Function=} fNoFunc
  * @param {string=} sYesButton
  * @param {string=} sNoButton
  * @param {boolean=} bFocusYesOnShow = true
  * @returns {void}
  */


	AskPopupView.prototype.onShow = function onShow(askDesc) {
		var fYesFunc = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
		var fNoFunc = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
		var yesButton = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';
		var noButton = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : '';
		var isFocusYesOnShow = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : true;


		this.clearPopup();

		this.fYesAction = fYesFunc || null;
		this.fNoAction = fNoFunc || null;

		this.askDesc(askDesc || '');

		if (yesButton) {
			this.yesButton(yesButton);
		}

		if (noButton) {
			this.noButton(noButton);
		}

		this.bFocusYesOnShow = !!isFocusYesOnShow;
	};

	AskPopupView.prototype.onShowWithDelay = function onShowWithDelay() {
		if (this.bFocusYesOnShow) {
			this.yesFocus(true);
		}
	};

	AskPopupView.prototype.onBuild = function onBuild() {
		var _this2 = this;

		__WEBPACK_IMPORTED_MODULE_4_key___default()('tab, shift+tab, right, left', __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].PopupAsk, function () {
			if (_this2.yesFocus()) {
				_this2.noFocus(true);
			} else {
				_this2.yesFocus(true);
			}
			return false;
		});

		__WEBPACK_IMPORTED_MODULE_4_key___default()('esc', __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].PopupAsk, function () {
			_this2.noClick();
			return false;
		});
	};

	return AskPopupView;
}(__WEBPACK_IMPORTED_MODULE_9_Knoin_AbstractViewNext__["a" /* AbstractViewNext */])) || _class);




/***/ }),
/* 78 */
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_a-function.js ***!
  \*************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

module.exports = function (it) {
  if (typeof it != 'function') throw TypeError(it + ' is not a function!');
  return it;
};


/***/ }),
/* 79 */
/*!*******************************************************************************!*\
  !*** ./node_modules/core-js/library/fn/object/get-own-property-descriptor.js ***!
  \*******************************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ../../modules/es6.object.get-own-property-descriptor */ 80);
var $Object = __webpack_require__(/*! ../../modules/_core */ 22).Object;
module.exports = function getOwnPropertyDescriptor(it, key) {
  return $Object.getOwnPropertyDescriptor(it, key);
};


/***/ }),
/* 80 */
/*!****************************************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.object.get-own-property-descriptor.js ***!
  \****************************************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.6 Object.getOwnPropertyDescriptor(O, P)
var toIObject = __webpack_require__(/*! ./_to-iobject */ 24);
var $getOwnPropertyDescriptor = __webpack_require__(/*! ./_object-gopd */ 50).f;

__webpack_require__(/*! ./_object-sap */ 82)('getOwnPropertyDescriptor', function () {
  return function getOwnPropertyDescriptor(it, key) {
    return $getOwnPropertyDescriptor(toIObject(it), key);
  };
});


/***/ }),
/* 81 */
/*!**********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_iobject.js ***!
  \**********************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

// fallback for non-array-like ES3 and non-enumerable old V8 strings
var cof = __webpack_require__(/*! ./_cof */ 60);
// eslint-disable-next-line no-prototype-builtins
module.exports = Object('z').propertyIsEnumerable(0) ? Object : function (it) {
  return cof(it) == 'String' ? it.split('') : Object(it);
};


/***/ }),
/* 82 */
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-sap.js ***!
  \*************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

// most Object methods by ES6 should accept primitives
var $export = __webpack_require__(/*! ./_export */ 32);
var core = __webpack_require__(/*! ./_core */ 22);
var fails = __webpack_require__(/*! ./_fails */ 30);
module.exports = function (KEY, exec) {
  var fn = (core.Object || {})[KEY] || Object[KEY];
  var exp = {};
  exp[KEY] = exec(fn);
  $export($export.S + $export.F * fails(function () { fn(1); }), 'Object', exp);
};


/***/ }),
/* 83 */
/*!************************************!*\
  !*** external "window.progressJs" ***!
  \************************************/
/*! no static exports found */
/*! exports used: default */
/***/ (function(module, exports) {

module.exports = window.progressJs;

/***/ }),
/* 84 */
/*!*****************************!*\
  !*** ./dev/Common/Jassl.js ***!
  \*****************************/
/*! exports provided: jassl */
/*! exports used: jassl */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = jassl;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_window__);



// let rainloopCaches = window.caches && window.caches.open ? window.caches : null;

/**
 * @param {src} src
 * @param {boolean} async = false
 * @returns {Promise}
 */
function jassl(src) {
	var async = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;


	if (!__WEBPACK_IMPORTED_MODULE_0_window___default.a.Promise || !__WEBPACK_IMPORTED_MODULE_0_window___default.a.Promise.all) {
		throw new Error('Promises are not available your environment.');
	}

	if (!src) {
		throw new Error('src should not be empty.');
	}

	return new __WEBPACK_IMPORTED_MODULE_0_window___default.a.Promise(function (resolve, reject) {

		var element = __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.createElement('script');

		element.onload = function () {
			resolve(src);
		};

		element.onerror = function () {
			reject(new Error(src));
		};

		element.async = true === async;
		element.src = src;

		__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.body.appendChild(element);
	}) /* .then((s) => {
    const found = s && rainloopCaches ? s.match(/rainloop\/v\/([^\/]+)\/static\//) : null;
    if (found && found[1])
    {
    rainloopCaches.open('rainloop-offline-' + found[1]).then(
    	(cache) => cache.add(s)
    ).catch(() => {
    	rainloopCaches = null;
    });
    }
    return s;
    })*/;
}

/***/ }),
/* 85 */
/*!**********************************!*\
  !*** ./dev/Common/HtmlEditor.js ***!
  \**********************************/
/*! exports provided: HtmlEditor, default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HtmlEditor", function() { return HtmlEditor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return HtmlEditor; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3____ = __webpack_require__(/*! $ */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);









var HtmlEditor = function () {

	/**
  * @param {Object} element
  * @param {Function=} onBlur
  * @param {Function=} onReady
  * @param {Function=} onModeChange
  */
	function HtmlEditor(element) {
		var onBlur = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
		var onReady = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
		var onModeChange = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;

		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, HtmlEditor);

		this.blurTimer = 0;
		this.__resizable = false;
		this.__inited = false;
		this.onBlur = null;
		this.onReady = null;
		this.onModeChange = null;

		this.onBlur = onBlur;
		this.onReady = onReady;
		this.onModeChange = onModeChange;

		this.element = element;
		this.$element = __WEBPACK_IMPORTED_MODULE_3_____default()(element);

		this.resize = __WEBPACK_IMPORTED_MODULE_2_____default.a.throttle(__WEBPACK_IMPORTED_MODULE_2_____default.a.bind(this.resizeEditor, this), 100);

		this.init();
	}

	HtmlEditor.prototype.runOnBlur = function runOnBlur() {
		if (this.onBlur) {
			this.onBlur();
		}
	};

	HtmlEditor.prototype.blurTrigger = function blurTrigger() {
		var _this = this;

		if (this.onBlur) {
			__WEBPACK_IMPORTED_MODULE_1_window___default.a.clearTimeout(this.blurTimer);
			this.blurTimer = __WEBPACK_IMPORTED_MODULE_1_window___default.a.setTimeout(function () {
				_this.runOnBlur();
			}, __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Magics"].Time200ms);
		}
	};

	HtmlEditor.prototype.focusTrigger = function focusTrigger() {
		if (this.onBlur) {
			__WEBPACK_IMPORTED_MODULE_1_window___default.a.clearTimeout(this.blurTimer);
		}
	};

	/**
  * @returns {boolean}
  */


	HtmlEditor.prototype.isHtml = function isHtml() {
		return this.editor ? 'wysiwyg' === this.editor.mode : false;
	};

	/**
  * @returns {void}
  */


	HtmlEditor.prototype.clearCachedSignature = function clearCachedSignature() {
		if (this.editor) {
			this.editor.execCommand('insertSignature', {
				clearCache: true
			});
		}
	};

	/**
  * @param {string} signature
  * @param {bool} html
  * @param {bool} insertBefore
  * @returns {void}
  */


	HtmlEditor.prototype.setSignature = function setSignature(signature, html) {
		var insertBefore = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

		if (this.editor) {
			this.editor.execCommand('insertSignature', {
				isHtml: html,
				insertBefore: insertBefore,
				signature: signature
			});
		}
	};

	/**
  * @returns {boolean}
  */


	HtmlEditor.prototype.checkDirty = function checkDirty() {
		return this.editor ? this.editor.checkDirty() : false;
	};

	HtmlEditor.prototype.resetDirty = function resetDirty() {
		if (this.editor) {
			this.editor.resetDirty();
		}
	};

	/**
  * @param {boolean=} wrapIsHtml = false
  * @returns {string}
  */


	HtmlEditor.prototype.getData = function getData() {
		var wrapIsHtml = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;


		var result = '';
		if (this.editor) {
			try {
				if ('plain' === this.editor.mode && this.editor.plugins.plain && this.editor.__plain) {
					result = this.editor.__plain.getRawData();
				} else {
					result = wrapIsHtml ? '<div data-html-editor-font-wrapper="true" style="font-family: arial, sans-serif; font-size: 13px;">' + this.editor.getData() + '</div>' : this.editor.getData();
				}
			} catch (e) {} // eslint-disable-line no-empty
		}

		return result;
	};

	/**
  * @param {boolean=} wrapIsHtml = false
  * @returns {string}
  */


	HtmlEditor.prototype.getDataWithHtmlMark = function getDataWithHtmlMark() {
		var wrapIsHtml = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

		return (this.isHtml() ? ':HTML:' : '') + this.getData(wrapIsHtml);
	};

	HtmlEditor.prototype.modeToggle = function modeToggle(plain, resize) {
		if (this.editor) {
			try {
				if (plain) {
					if ('plain' === this.editor.mode) {
						this.editor.setMode('wysiwyg');
					}
				} else if ('wysiwyg' === this.editor.mode) {
					this.editor.setMode('plain');
				}
			} catch (e) {} // eslint-disable-line no-empty

			if (resize) {
				this.resize();
			}
		}
	};

	HtmlEditor.prototype.setHtmlOrPlain = function setHtmlOrPlain(text, focus) {
		if (':HTML:' === text.substr(0, 6)) {
			this.setHtml(text.substr(6), focus);
		} else {
			this.setPlain(text, focus);
		}
	};

	HtmlEditor.prototype.setHtml = function setHtml(html, focus) {
		if (this.editor && this.__inited) {
			this.clearCachedSignature();

			this.modeToggle(true);

			html = html.replace(/<p[^>]*><\/p>/ig, '');

			try {
				this.editor.setData(html);
			} catch (e) {} // eslint-disable-line no-empty

			if (focus) {
				this.focus();
			}
		}
	};

	HtmlEditor.prototype.replaceHtml = function replaceHtml(find, _replaceHtml) {
		if (this.editor && this.__inited && 'wysiwyg' === this.editor.mode) {
			try {
				this.editor.setData(this.editor.getData().replace(find, _replaceHtml));
			} catch (e) {} // eslint-disable-line no-empty
		}
	};

	HtmlEditor.prototype.setPlain = function setPlain(plain, focus) {
		if (this.editor && this.__inited) {
			this.clearCachedSignature();

			this.modeToggle(false);
			if ('plain' === this.editor.mode && this.editor.plugins.plain && this.editor.__plain) {
				this.editor.__plain.setRawData(plain);
			} else {
				try {
					this.editor.setData(plain);
				} catch (e) {} // eslint-disable-line no-empty
			}

			if (focus) {
				this.focus();
			}
		}
	};

	HtmlEditor.prototype.init = function init() {
		var _this2 = this;

		if (this.element && !this.editor) {
			var initFunc = function initFunc() {

				var config = __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["htmlEditorDefaultConfig"],
				    language = __WEBPACK_IMPORTED_MODULE_6_Storage_Settings__["settingsGet"]('Language'),
				    allowSource = !!__WEBPACK_IMPORTED_MODULE_6_Storage_Settings__["appSettingsGet"]('allowHtmlEditorSourceButton'),
				    biti = !!__WEBPACK_IMPORTED_MODULE_6_Storage_Settings__["appSettingsGet"]('allowHtmlEditorBitiButtons');

				if ((allowSource || !biti) && !config.toolbarGroups.__cfgInited) {
					config.toolbarGroups.__cfgInited = true;

					if (allowSource) {
						config.removeButtons = config.removeButtons.replace(',Source', '');
					}

					if (!biti) {
						config.removePlugins += (config.removePlugins ? ',' : '') + 'bidi';
					}
				}

				config.enterMode = __WEBPACK_IMPORTED_MODULE_1_window___default.a.CKEDITOR.ENTER_BR;
				config.shiftEnterMode = __WEBPACK_IMPORTED_MODULE_1_window___default.a.CKEDITOR.ENTER_P;

				config.language = __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["htmlEditorLangsMap"][(language || 'en').toLowerCase()] || 'en';
				if (__WEBPACK_IMPORTED_MODULE_1_window___default.a.CKEDITOR.env) {
					__WEBPACK_IMPORTED_MODULE_1_window___default.a.CKEDITOR.env.isCompatible = true;
				}

				_this2.editor = __WEBPACK_IMPORTED_MODULE_1_window___default.a.CKEDITOR.appendTo(_this2.element, config);

				_this2.editor.on('key', function (event) {
					if (event && event.data && __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Tab === event.data.keyCode) {
						return false;
					}

					return true;
				});

				_this2.editor.on('blur', function () {
					_this2.blurTrigger();
				});

				_this2.editor.on('mode', function () {
					_this2.blurTrigger();
					if (_this2.onModeChange) {
						_this2.onModeChange('plain' !== _this2.editor.mode);
					}
				});

				_this2.editor.on('focus', function () {
					_this2.focusTrigger();
				});

				if (__WEBPACK_IMPORTED_MODULE_1_window___default.a.FileReader) {
					_this2.editor.on('drop', function (event) {
						if (0 < event.data.dataTransfer.getFilesCount()) {
							var file = event.data.dataTransfer.getFile(0);
							if (file && __WEBPACK_IMPORTED_MODULE_1_window___default.a.FileReader && event.data.dataTransfer.id && file.type && file.type.match(/^image/i)) {
								var id = event.data.dataTransfer.id,
								    imageId = '[img=' + id + ']',
								    reader = new __WEBPACK_IMPORTED_MODULE_1_window___default.a.FileReader();

								reader.onloadend = function () {
									if (reader.result) {
										_this2.replaceHtml(imageId, '<img src="' + reader.result + '" />');
									}
								};

								reader.readAsDataURL(file);

								event.data.dataTransfer.setData('text/html', imageId);
							}
						}
					});
				}

				_this2.editor.on('instanceReady', function () {

					if (_this2.editor.removeMenuItem) {
						_this2.editor.removeMenuItem('cut');
						_this2.editor.removeMenuItem('copy');
						_this2.editor.removeMenuItem('paste');
					}

					_this2.__resizable = true;
					_this2.__inited = true;

					_this2.resize();

					if (_this2.onReady) {
						_this2.onReady();
					}
				});
			};

			if (__WEBPACK_IMPORTED_MODULE_1_window___default.a.CKEDITOR) {
				initFunc();
			} else {
				__WEBPACK_IMPORTED_MODULE_1_window___default.a.__initEditor = initFunc;
			}
		}
	};

	HtmlEditor.prototype.focus = function focus() {
		if (this.editor) {
			try {
				this.editor.focus();
			} catch (e) {} // eslint-disable-line no-empty
		}
	};

	HtmlEditor.prototype.hasFocus = function hasFocus() {
		if (this.editor) {
			try {
				return !!this.editor.focusManager.hasFocus;
			} catch (e) {} // eslint-disable-line no-empty
		}

		return false;
	};

	HtmlEditor.prototype.blur = function blur() {
		if (this.editor) {
			try {
				this.editor.focusManager.blur(true);
			} catch (e) {} // eslint-disable-line no-empty
		}
	};

	HtmlEditor.prototype.resizeEditor = function resizeEditor() {
		if (this.editor && this.__resizable) {
			try {
				this.editor.resize(this.$element.width(), this.$element.innerHeight());
			} catch (e) {} // eslint-disable-line no-empty
		}
	};

	HtmlEditor.prototype.setReadOnly = function setReadOnly(value) {
		if (this.editor) {
			try {
				this.editor.setReadOnly(!!value);
			} catch (e) {} // eslint-disable-line no-empty
		}
	};

	HtmlEditor.prototype.clear = function clear(focus) {
		this.setHtml('', focus);
	};

	return HtmlEditor;
}();



/***/ }),
/* 86 */
/*!************************************!*\
  !*** external "window.crossroads" ***!
  \************************************/
/*! no static exports found */
/*! exports used: default */
/***/ (function(module, exports) {

module.exports = window.crossroads;

/***/ }),
/* 87 */
/*!******************************************************!*\
  !*** ./node_modules/babel-runtime/helpers/typeof.js ***!
  \******************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _iterator = __webpack_require__(/*! ../core-js/symbol/iterator */ 111);

var _iterator2 = _interopRequireDefault(_iterator);

var _symbol = __webpack_require__(/*! ../core-js/symbol */ 127);

var _symbol2 = _interopRequireDefault(_symbol);

var _typeof = typeof _symbol2.default === "function" && typeof _iterator2.default === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof _symbol2.default === "function" && obj.constructor === _symbol2.default && obj !== _symbol2.default.prototype ? "symbol" : typeof obj; };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = typeof _symbol2.default === "function" && _typeof(_iterator2.default) === "symbol" ? function (obj) {
  return typeof obj === "undefined" ? "undefined" : _typeof(obj);
} : function (obj) {
  return obj && typeof _symbol2.default === "function" && obj.constructor === _symbol2.default && obj !== _symbol2.default.prototype ? "symbol" : typeof obj === "undefined" ? "undefined" : _typeof(obj);
};

/***/ }),
/* 88 */
/*!**************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_iter-define.js ***!
  \**************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var LIBRARY = __webpack_require__(/*! ./_library */ 62);
var $export = __webpack_require__(/*! ./_export */ 32);
var redefine = __webpack_require__(/*! ./_redefine */ 89);
var hide = __webpack_require__(/*! ./_hide */ 28);
var has = __webpack_require__(/*! ./_has */ 25);
var Iterators = __webpack_require__(/*! ./_iterators */ 63);
var $iterCreate = __webpack_require__(/*! ./_iter-create */ 115);
var setToStringTag = __webpack_require__(/*! ./_set-to-string-tag */ 69);
var getPrototypeOf = __webpack_require__(/*! ./_object-gpo */ 121);
var ITERATOR = __webpack_require__(/*! ./_wks */ 36)('iterator');
var BUGGY = !([].keys && 'next' in [].keys()); // Safari has buggy iterators w/o `next`
var FF_ITERATOR = '@@iterator';
var KEYS = 'keys';
var VALUES = 'values';

var returnThis = function () { return this; };

module.exports = function (Base, NAME, Constructor, next, DEFAULT, IS_SET, FORCED) {
  $iterCreate(Constructor, NAME, next);
  var getMethod = function (kind) {
    if (!BUGGY && kind in proto) return proto[kind];
    switch (kind) {
      case KEYS: return function keys() { return new Constructor(this, kind); };
      case VALUES: return function values() { return new Constructor(this, kind); };
    } return function entries() { return new Constructor(this, kind); };
  };
  var TAG = NAME + ' Iterator';
  var DEF_VALUES = DEFAULT == VALUES;
  var VALUES_BUG = false;
  var proto = Base.prototype;
  var $native = proto[ITERATOR] || proto[FF_ITERATOR] || DEFAULT && proto[DEFAULT];
  var $default = $native || getMethod(DEFAULT);
  var $entries = DEFAULT ? !DEF_VALUES ? $default : getMethod('entries') : undefined;
  var $anyNative = NAME == 'Array' ? proto.entries || $native : $native;
  var methods, key, IteratorPrototype;
  // Fix native
  if ($anyNative) {
    IteratorPrototype = getPrototypeOf($anyNative.call(new Base()));
    if (IteratorPrototype !== Object.prototype && IteratorPrototype.next) {
      // Set @@toStringTag to native iterators
      setToStringTag(IteratorPrototype, TAG, true);
      // fix for some old engines
      if (!LIBRARY && !has(IteratorPrototype, ITERATOR)) hide(IteratorPrototype, ITERATOR, returnThis);
    }
  }
  // fix Array#{values, @@iterator}.name in V8 / FF
  if (DEF_VALUES && $native && $native.name !== VALUES) {
    VALUES_BUG = true;
    $default = function values() { return $native.call(this); };
  }
  // Define iterator
  if ((!LIBRARY || FORCED) && (BUGGY || VALUES_BUG || !proto[ITERATOR])) {
    hide(proto, ITERATOR, $default);
  }
  // Plug for library
  Iterators[NAME] = $default;
  Iterators[TAG] = returnThis;
  if (DEFAULT) {
    methods = {
      values: DEF_VALUES ? $default : getMethod(VALUES),
      keys: IS_SET ? $default : getMethod(KEYS),
      entries: $entries
    };
    if (FORCED) for (key in methods) {
      if (!(key in proto)) redefine(proto, key, methods[key]);
    } else $export($export.P + $export.F * (BUGGY || VALUES_BUG), NAME, methods);
  }
  return methods;
};


/***/ }),
/* 89 */
/*!***********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_redefine.js ***!
  \***********************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(/*! ./_hide */ 28);


/***/ }),
/* 90 */
/*!***********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-keys-internal.js ***!
  \***********************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

var has = __webpack_require__(/*! ./_has */ 25);
var toIObject = __webpack_require__(/*! ./_to-iobject */ 24);
var arrayIndexOf = __webpack_require__(/*! ./_array-includes */ 117)(false);
var IE_PROTO = __webpack_require__(/*! ./_shared-key */ 66)('IE_PROTO');

module.exports = function (object, names) {
  var O = toIObject(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) if (key != IE_PROTO) has(O, key) && result.push(key);
  // Don't enum bug & hidden keys
  while (names.length > i) if (has(O, key = names[i++])) {
    ~arrayIndexOf(result, key) || result.push(key);
  }
  return result;
};


/***/ }),
/* 91 */
/*!**************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-gops.js ***!
  \**************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

exports.f = Object.getOwnPropertySymbols;


/***/ }),
/* 92 */
/*!**************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-gopn.js ***!
  \**************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.7 / 15.2.3.4 Object.getOwnPropertyNames(O)
var $keys = __webpack_require__(/*! ./_object-keys-internal */ 90);
var hiddenKeys = __webpack_require__(/*! ./_enum-bug-keys */ 68).concat('length', 'prototype');

exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return $keys(O, hiddenKeys);
};


/***/ }),
/* 93 */
/*!*******************************!*\
  !*** ./dev/Storage/Client.js ***!
  \*******************************/
/*! exports provided: set, get */
/*! exports used: get, set */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["b"] = set;
/* harmony export (immutable) */ __webpack_exports__["a"] = get;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_ClientStorageDriver_Cookie__ = __webpack_require__(/*! Common/ClientStorageDriver/Cookie */ 218);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_ClientStorageDriver_LocalStorage__ = __webpack_require__(/*! Common/ClientStorageDriver/LocalStorage */ 220);





var SupportedStorageDriver = __WEBPACK_IMPORTED_MODULE_0_____default.a.find([__WEBPACK_IMPORTED_MODULE_2_Common_ClientStorageDriver_LocalStorage__["a" /* LocalStorageDriver */], __WEBPACK_IMPORTED_MODULE_1_Common_ClientStorageDriver_Cookie__["a" /* CookieDriver */]], function (StorageDriver) {
  return StorageDriver && StorageDriver.supported();
});

var driver = SupportedStorageDriver ? new SupportedStorageDriver() : null;

/**
 * @param {number} key
 * @param {*} data
 * @returns {boolean}
 */
function set(key, data) {
  return driver ? driver.set('p' + key, data) : false;
}

/**
 * @param {number} key
 * @returns {*}
 */
function get(key) {
  return driver ? driver.get('p' + key) : null;
}

/***/ }),
/* 94 */
/*!***********************************!*\
  !*** ./dev/Promises/User/Ajax.js ***!
  \***********************************/
/*! exports provided: default */
/*! exports used: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Promises_User_Populator__ = __webpack_require__(/*! Promises/User/Populator */ 221);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Promises_AbstractAjax__ = __webpack_require__(/*! Promises/AbstractAjax */ 223);









var UserAjaxUserPromises = function (_AbstractAjaxPromises) {
	__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(UserAjaxUserPromises, _AbstractAjaxPromises);

	function UserAjaxUserPromises() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, UserAjaxUserPromises);

		var _this = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractAjaxPromises.call(this));

		_this.foldersTimeout = 0;
		return _this;
	}

	UserAjaxUserPromises.prototype.foldersReload = function foldersReload(fTrigger) {
		return this.abort('Folders').postRequest('Folders', fTrigger).then(function (data) {
			__WEBPACK_IMPORTED_MODULE_4_Promises_User_Populator__["a" /* default */].foldersList(data.Result);
			__WEBPACK_IMPORTED_MODULE_4_Promises_User_Populator__["a" /* default */].foldersAdditionalParameters(data.Result);
			return true;
		});
	};

	UserAjaxUserPromises.prototype.foldersReloadWithTimeout = function foldersReloadWithTimeout(fTrigger) {
		var _this2 = this;

		this.setTrigger(fTrigger, true);

		__WEBPACK_IMPORTED_MODULE_3_window___default.a.clearTimeout(this.foldersTimeout);
		this.foldersTimeout = __WEBPACK_IMPORTED_MODULE_3_window___default.a.setTimeout(function () {
			_this2.foldersReload(fTrigger);
		}, 500);
	};

	UserAjaxUserPromises.prototype.folderDelete = function folderDelete(sFolderFullNameRaw, fTrigger) {
		return this.postRequest('FolderDelete', fTrigger, {
			'Folder': sFolderFullNameRaw
		});
	};

	UserAjaxUserPromises.prototype.folderCreate = function folderCreate(sNewFolderName, sParentName, fTrigger) {
		return this.postRequest('FolderCreate', fTrigger, {
			'Folder': sNewFolderName,
			'Parent': sParentName
		});
	};

	UserAjaxUserPromises.prototype.folderRename = function folderRename(sPrevFolderFullNameRaw, sNewFolderName, fTrigger) {
		return this.postRequest('FolderRename', fTrigger, {
			'Folder': sPrevFolderFullNameRaw,
			'NewFolderName': sNewFolderName
		});
	};

	UserAjaxUserPromises.prototype.attachmentsActions = function attachmentsActions(sAction, aHashes, fTrigger) {
		return this.postRequest('AttachmentsActions', fTrigger, {
			'Do': sAction,
			'Hashes': aHashes
		});
	};

	UserAjaxUserPromises.prototype.welcomeClose = function welcomeClose() {
		return this.postRequest('WelcomeClose');
	};

	return UserAjaxUserPromises;
}(__WEBPACK_IMPORTED_MODULE_5_Promises_AbstractAjax__["a" /* AbstractAjaxPromises */]);

/* harmony default export */ __webpack_exports__["a"] = (new UserAjaxUserPromises());

/***/ }),
/* 95 */
/*!*************************************!*\
  !*** ./dev/View/Popup/Languages.js ***!
  \*************************************/
/*! exports provided: LanguagesPopupView, default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LanguagesPopupView", function() { return LanguagesPopupView; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return LanguagesPopupView; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Knoin_AbstractViewNext__ = __webpack_require__(/*! Knoin/AbstractViewNext */ 13);




var _dec, _class;






// import {view, ViewType} from 'Knoin/Knoin';



var LanguagesPopupView = (_dec = Object(__WEBPACK_IMPORTED_MODULE_6_Knoin_Knoin__["popup"])({
	name: 'View/Popup/Languages',
	templateID: 'PopupsLanguages'
}), _dec(_class = function (_AbstractViewNext) {
	__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(LanguagesPopupView, _AbstractViewNext);

	function LanguagesPopupView() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, LanguagesPopupView);

		var _this = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractViewNext.call(this));

		_this.fLang = null;
		_this.userLanguage = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable('');

		_this.langs = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observableArray([]);

		_this.languages = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].computed(function () {
			var userLanguage = _this.userLanguage();
			return __WEBPACK_IMPORTED_MODULE_3_____default.a.map(_this.langs(), function (language) {
				return {
					key: language,
					user: language === userLanguage,
					selected: __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false),
					fullName: Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["convertLangName"])(language)
				};
			});
		});

		_this.langs.subscribe(function () {
			_this.setLanguageSelection();
		});
		return _this;
	}

	LanguagesPopupView.prototype.languageTooltipName = function languageTooltipName(language) {
		var result = Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["convertLangName"])(language, true);
		return Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["convertLangName"])(language, false) === result ? '' : result;
	};

	LanguagesPopupView.prototype.setLanguageSelection = function setLanguageSelection() {
		var currentLang = this.fLang ? __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].unwrap(this.fLang) : '';
		__WEBPACK_IMPORTED_MODULE_3_____default.a.each(this.languages(), function (item) {
			item.selected(item.key === currentLang);
		});
	};

	LanguagesPopupView.prototype.onBeforeShow = function onBeforeShow() {
		this.fLang = null;
		this.userLanguage('');

		this.langs([]);
	};

	LanguagesPopupView.prototype.onShow = function onShow(fLanguage, langs, userLanguage) {
		this.fLang = fLanguage;
		this.userLanguage(userLanguage || '');

		this.langs(langs);
	};

	LanguagesPopupView.prototype.changeLanguage = function changeLanguage(lang) {
		if (this.fLang) {
			this.fLang(lang);
		}

		this.cancelCommand();
	};

	return LanguagesPopupView;
}(__WEBPACK_IMPORTED_MODULE_7_Knoin_AbstractViewNext__["a" /* AbstractViewNext */])) || _class);




/***/ }),
/* 96 */
/*!******************************************!*\
  !*** ./dev/Component/AbstracCheckbox.js ***!
  \******************************************/
/*! exports provided: AbstracCheckbox, default */
/*! exports used: AbstracCheckbox */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AbstracCheckbox; });
/* unused harmony export default */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 18);








var AbstracCheckbox = function (_AbstractComponent) {
	__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(AbstracCheckbox, _AbstractComponent);

	/**
  * @param {Object} params = {}
  */
	function AbstracCheckbox() {
		var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, AbstracCheckbox);

		var _this = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractComponent.call(this));

		_this.value = params.value;
		if (Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isUnd"])(_this.value) || !_this.value.subscribe) {
			_this.value = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isUnd"])(_this.value) ? false : !!_this.value);
		}

		_this.enable = params.enable;
		if (Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isUnd"])(_this.enable) || !_this.enable.subscribe) {
			_this.enable = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isUnd"])(_this.enable) ? true : !!_this.enable);
		}

		_this.disable = params.disable;
		if (Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isUnd"])(_this.disable) || !_this.disable.subscribe) {
			_this.disable = __WEBPACK_IMPORTED_MODULE_3_ko__["a" /* default */].observable(Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isUnd"])(_this.disable) ? false : !!_this.disable);
		}

		_this.label = params.label || '';
		_this.inline = Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isUnd"])(params.inline) ? false : params.inline;

		_this.readOnly = Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isUnd"])(params.readOnly) ? false : !!params.readOnly;
		_this.inverted = Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isUnd"])(params.inverted) ? false : !!params.inverted;

		_this.labeled = !Object(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isUnd"])(params.label);
		_this.labelAnimated = !!params.labelAnimated;
		return _this;
	}

	AbstracCheckbox.prototype.click = function click() {
		if (!this.readOnly && this.enable() && !this.disable()) {
			this.value(!this.value());
		}
	};

	return AbstracCheckbox;
}(__WEBPACK_IMPORTED_MODULE_5_Component_Abstract__["a" /* AbstractComponent */]);



/***/ }),
/* 97 */
/*!*********************************!*\
  !*** ./dev/Storage/RainLoop.js ***!
  \*********************************/
/*! exports provided: isStorageSupported, getHash, setHash, clearHash, checkTimestamp */
/*! exports used: checkTimestamp, clearHash, getHash, isStorageSupported, setHash */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["d"] = isStorageSupported;
/* harmony export (immutable) */ __webpack_exports__["c"] = getHash;
/* harmony export (immutable) */ __webpack_exports__["e"] = setHash;
/* harmony export (immutable) */ __webpack_exports__["b"] = clearHash;
/* harmony export (immutable) */ __webpack_exports__["a"] = checkTimestamp;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_window__);



var STORAGE_KEY = '__rlA';
var TIME_KEY = '__rlT';

/**
 * @param {string} storageName
 * @returns {boolean}
 */
function isStorageSupported(storageName) {
	if (storageName in __WEBPACK_IMPORTED_MODULE_0_window___default.a && __WEBPACK_IMPORTED_MODULE_0_window___default.a[storageName] && __WEBPACK_IMPORTED_MODULE_0_window___default.a[storageName].setItem) {
		var s = __WEBPACK_IMPORTED_MODULE_0_window___default.a[storageName],
		    key = 'testLocalStorage_' + __WEBPACK_IMPORTED_MODULE_0_window___default.a.Math.random();

		try {
			s.setItem(key, key);
			if (key === s.getItem(key)) {
				s.removeItem(key);
				return true;
			}
		} catch (e) {} // eslint-disable-line no-empty
	}

	return false;
}

var SESS_STORAGE = isStorageSupported('sessionStorage') ? __WEBPACK_IMPORTED_MODULE_0_window___default.a.sessionStorage || null : null;
var WIN_STORAGE = __WEBPACK_IMPORTED_MODULE_0_window___default.a.top || __WEBPACK_IMPORTED_MODULE_0_window___default.a || null;

var __get = function __get(key) {

	var result = null;
	if (SESS_STORAGE) {
		result = SESS_STORAGE.getItem(key) || null;
	} else if (WIN_STORAGE && __WEBPACK_IMPORTED_MODULE_0_window___default.a.JSON) {
		var data = WIN_STORAGE.name && '{' === WIN_STORAGE.name.toString().substr(0, 1) ? __WEBPACK_IMPORTED_MODULE_0_window___default.a.JSON.parse(WIN_STORAGE.name.toString()) : null;
		result = data ? data[key] || null : null;
	}

	return result;
};

var __set = function __set(key, value) {

	if (SESS_STORAGE) {
		SESS_STORAGE.setItem(key, value);
	} else if (WIN_STORAGE && __WEBPACK_IMPORTED_MODULE_0_window___default.a.JSON) {
		var data = WIN_STORAGE.name && '{' === WIN_STORAGE.name.toString().substr(0, 1) ? __WEBPACK_IMPORTED_MODULE_0_window___default.a.JSON.parse(WIN_STORAGE.name.toString()) : null;
		data = data || {};
		data[key] = value;

		WIN_STORAGE.name = __WEBPACK_IMPORTED_MODULE_0_window___default.a.JSON.stringify(data);
	}
};

var timestamp = function timestamp() {
	return __WEBPACK_IMPORTED_MODULE_0_window___default.a.Math.round(new __WEBPACK_IMPORTED_MODULE_0_window___default.a.Date().getTime() / 1000);
};

var setTimestamp = function setTimestamp() {
	return __set(TIME_KEY, timestamp());
};

var getTimestamp = function getTimestamp() {
	var time = __get(TIME_KEY, 0);
	return time ? __WEBPACK_IMPORTED_MODULE_0_window___default.a.parseInt(time, 10) || 0 : 0;
};

/**
 * @returns {string}
 */
function getHash() {
	return __get(STORAGE_KEY);
}

/**
 * @returns {void}
 */
function setHash() {
	var key = 'AuthAccountHash',
	    appData = __WEBPACK_IMPORTED_MODULE_0_window___default.a.__rlah_data();

	__set(STORAGE_KEY, appData && appData[key] ? appData[key] : '');
	setTimestamp();
}

/**
 * @returns {void}
 */
function clearHash() {
	__set(STORAGE_KEY, '');
	setTimestamp();
}

/**
 * @returns {boolean}
 */
function checkTimestamp() {
	if (timestamp() > getTimestamp() + 1000 * 60 * 60) // 60m
		{
			clearHash();
			return true;
		}
	return false;
}

// init section
__WEBPACK_IMPORTED_MODULE_0_window___default.a.setInterval(setTimestamp, 1000 * 60); // 1m

/***/ }),
/* 98 */
/*!*************************************!*\
  !*** ./dev/Stores/User/Identity.js ***!
  \*************************************/
/*! exports provided: default */
/*! exports used: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ko__ = __webpack_require__(/*! ko */ 2);





var IdentityUserStore = function IdentityUserStore() {
	var _this = this;

	__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, IdentityUserStore);

	this.identities = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observableArray([]);
	this.identities.loading = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(false).extend({ throttle: 100 });

	this.identitiesIDS = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].computed(function () {
		return __WEBPACK_IMPORTED_MODULE_1_____default.a.compact(__WEBPACK_IMPORTED_MODULE_1_____default.a.map(_this.identities(), function (item) {
			return item ? item.id : null;
		}));
	});
};

/* harmony default export */ __webpack_exports__["a"] = (new IdentityUserStore());

/***/ }),
/* 99 */
/*!*****************************!*\
  !*** external "window.Jua" ***!
  \*****************************/
/*! no static exports found */
/*! exports used: default */
/***/ (function(module, exports) {

module.exports = window.Jua;

/***/ }),
/* 100 */
/*!****************************************!*\
  !*** ./dev/View/Popup/FolderSystem.js ***!
  \****************************************/
/*! exports provided: FolderSystemPopupView, default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FolderSystemPopupView", function() { return FolderSystemPopupView; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return FolderSystemPopupView; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Consts__ = __webpack_require__(/*! Common/Consts */ 20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__ = __webpack_require__(/*! Stores/User/Folder */ 38);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_Remote_User_Ajax__ = __webpack_require__(/*! Remote/User/Ajax */ 17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13_Knoin_AbstractViewNext__ = __webpack_require__(/*! Knoin/AbstractViewNext */ 13);




var _dec, _class;

















var FolderSystemPopupView = (_dec = Object(__WEBPACK_IMPORTED_MODULE_12_Knoin_Knoin__["popup"])({
	name: 'View/Popup/FolderSystem',
	templateID: 'PopupsFolderSystem'
}), _dec(_class = function (_AbstractViewNext) {
	__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(FolderSystemPopupView, _AbstractViewNext);

	function FolderSystemPopupView() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, FolderSystemPopupView);

		var _this = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractViewNext.call(this));

		_this.sChooseOnText = '';
		_this.sUnuseText = '';

		Object(__WEBPACK_IMPORTED_MODULE_8_Common_Translator__["initOnStartOrLangChange"])(function () {
			_this.sChooseOnText = Object(__WEBPACK_IMPORTED_MODULE_8_Common_Translator__["i18n"])('POPUPS_SYSTEM_FOLDERS/SELECT_CHOOSE_ONE');
			_this.sUnuseText = Object(__WEBPACK_IMPORTED_MODULE_8_Common_Translator__["i18n"])('POPUPS_SYSTEM_FOLDERS/SELECT_UNUSE_NAME');
		});

		_this.notification = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable('');

		_this.folderSelectList = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].computed(function () {
			return Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["folderListOptionsBuilder"])([], __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].folderList(), __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].folderListSystemNames(), [['', _this.sChooseOnText], [__WEBPACK_IMPORTED_MODULE_6_Common_Consts__["r" /* UNUSED_OPTION_VALUE */], _this.sUnuseText]], null, null, null, null, null, true);
		});

		_this.sentFolder = __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].sentFolder;
		_this.draftFolder = __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].draftFolder;
		_this.spamFolder = __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].spamFolder;
		_this.trashFolder = __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].trashFolder;
		_this.archiveFolder = __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].archiveFolder;

		var fSetSystemFolders = function fSetSystemFolders() {
			__WEBPACK_IMPORTED_MODULE_10_Storage_Settings__["settingsSet"]('SentFolder', __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].sentFolder());
			__WEBPACK_IMPORTED_MODULE_10_Storage_Settings__["settingsSet"]('DraftFolder', __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].draftFolder());
			__WEBPACK_IMPORTED_MODULE_10_Storage_Settings__["settingsSet"]('SpamFolder', __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].spamFolder());
			__WEBPACK_IMPORTED_MODULE_10_Storage_Settings__["settingsSet"]('TrashFolder', __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].trashFolder());
			__WEBPACK_IMPORTED_MODULE_10_Storage_Settings__["settingsSet"]('ArchiveFolder', __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].archiveFolder());
		},
		    fSaveSystemFolders = __WEBPACK_IMPORTED_MODULE_3_____default.a.debounce(function () {
			fSetSystemFolders();
			__WEBPACK_IMPORTED_MODULE_11_Remote_User_Ajax__["a" /* default */].saveSystemFolders(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["noop"], {
				SentFolder: __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].sentFolder(),
				DraftFolder: __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].draftFolder(),
				SpamFolder: __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].spamFolder(),
				TrashFolder: __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].trashFolder(),
				ArchiveFolder: __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].archiveFolder(),
				NullFolder: 'NullFolder'
			});
		}, __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Magics"].Time1s),
		    fCallback = function fCallback() {
			fSetSystemFolders();
			fSaveSystemFolders();
		};

		__WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].sentFolder.subscribe(fCallback);
		__WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].draftFolder.subscribe(fCallback);
		__WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].spamFolder.subscribe(fCallback);
		__WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].trashFolder.subscribe(fCallback);
		__WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].archiveFolder.subscribe(fCallback);

		_this.defautOptionsAfterRender = __WEBPACK_IMPORTED_MODULE_7_Common_Utils__["defautOptionsAfterRender"];
		return _this;
	}

	/**
  * @param {number=} notificationType = SetSystemFoldersNotification.None
  */


	FolderSystemPopupView.prototype.onShow = function onShow() {
		var notificationType = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["SetSystemFoldersNotification"].None;


		var notification = '';
		switch (notificationType) {
			case __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["SetSystemFoldersNotification"].Sent:
				notification = Object(__WEBPACK_IMPORTED_MODULE_8_Common_Translator__["i18n"])('POPUPS_SYSTEM_FOLDERS/NOTIFICATION_SENT');
				break;
			case __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["SetSystemFoldersNotification"].Draft:
				notification = Object(__WEBPACK_IMPORTED_MODULE_8_Common_Translator__["i18n"])('POPUPS_SYSTEM_FOLDERS/NOTIFICATION_DRAFTS');
				break;
			case __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["SetSystemFoldersNotification"].Spam:
				notification = Object(__WEBPACK_IMPORTED_MODULE_8_Common_Translator__["i18n"])('POPUPS_SYSTEM_FOLDERS/NOTIFICATION_SPAM');
				break;
			case __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["SetSystemFoldersNotification"].Trash:
				notification = Object(__WEBPACK_IMPORTED_MODULE_8_Common_Translator__["i18n"])('POPUPS_SYSTEM_FOLDERS/NOTIFICATION_TRASH');
				break;
			case __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["SetSystemFoldersNotification"].Archive:
				notification = Object(__WEBPACK_IMPORTED_MODULE_8_Common_Translator__["i18n"])('POPUPS_SYSTEM_FOLDERS/NOTIFICATION_ARCHIVE');
				break;
			// no default
		}

		this.notification(notification);
	};

	return FolderSystemPopupView;
}(__WEBPACK_IMPORTED_MODULE_13_Knoin_AbstractViewNext__["a" /* AbstractViewNext */])) || _class);




/***/ }),
/* 101 */,
/* 102 */,
/* 103 */,
/* 104 */
/*!**************************!*\
  !*** ./dev/bootstrap.js ***!
  \**************************/
/*! exports provided: default */
/*! exports used: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Plugins__ = __webpack_require__(/*! Common/Plugins */ 33);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Model_Email__ = __webpack_require__(/*! Model/Email */ 44);









/* harmony default export */ __webpack_exports__["a"] = (function (App) {

	__WEBPACK_IMPORTED_MODULE_2_Common_Globals__["data"].__APP__ = App;

	__WEBPACK_IMPORTED_MODULE_2_Common_Globals__["$win"].on('keydown', __WEBPACK_IMPORTED_MODULE_1_Common_Utils__["killCtrlACtrlS"]).on('unload', function () {
		__WEBPACK_IMPORTED_MODULE_2_Common_Globals__["data"].bUnload = true;
	});

	__WEBPACK_IMPORTED_MODULE_2_Common_Globals__["$html"].addClass(__WEBPACK_IMPORTED_MODULE_2_Common_Globals__["bMobileDevice"] ? 'mobile' : 'no-mobile').on('click.dropdown.data-api', __WEBPACK_IMPORTED_MODULE_1_Common_Utils__["detectDropdownVisibility"]);

	var rl = __WEBPACK_IMPORTED_MODULE_0_window___default.a.rl || {};

	rl.i18n = __WEBPACK_IMPORTED_MODULE_5_Common_Translator__["i18n"];
	rl.createCommand = __WEBPACK_IMPORTED_MODULE_1_Common_Utils__["createCommandLegacy"];

	rl.addSettingsViewModel = __WEBPACK_IMPORTED_MODULE_4_Common_Plugins__["b" /* addSettingsViewModel */];
	rl.addSettingsViewModelForAdmin = __WEBPACK_IMPORTED_MODULE_4_Common_Plugins__["c" /* addSettingsViewModelForAdmin */];

	rl.addHook = __WEBPACK_IMPORTED_MODULE_4_Common_Plugins__["a" /* addHook */];
	rl.settingsGet = __WEBPACK_IMPORTED_MODULE_4_Common_Plugins__["d" /* mainSettingsGet */];
	rl.pluginSettingsGet = __WEBPACK_IMPORTED_MODULE_4_Common_Plugins__["h" /* settingsGet */];
	rl.pluginRemoteRequest = __WEBPACK_IMPORTED_MODULE_4_Common_Plugins__["e" /* remoteRequest */];

	rl.EmailModel = __WEBPACK_IMPORTED_MODULE_6_Model_Email__["EmailModel"];
	rl.Enums = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__;

	__WEBPACK_IMPORTED_MODULE_0_window___default.a.rl = rl;

	__WEBPACK_IMPORTED_MODULE_0_window___default.a.__APP_BOOT = function (fErrorCallback) {

		Object(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["domReady"])(function () {

			__WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {

				if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopTEMPLATES && __WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopTEMPLATES[0]) {
					__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.getElementById('rl-templates').innerHTML = __WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopTEMPLATES[0];

					__WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {

						__WEBPACK_IMPORTED_MODULE_2_Common_Globals__["$html"].removeClass('no-js rl-booted-trigger').addClass('rl-booted');

						App.bootstart();
					}, __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["Magics"].Time10ms);
				} else {
					fErrorCallback();
				}

				__WEBPACK_IMPORTED_MODULE_0_window___default.a.__APP_BOOT = null;
			}, __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["Magics"].Time10ms);
		});
	};
});

/***/ }),
/* 105 */
/*!*********************************!*\
  !*** ./dev/External/Opentip.js ***!
  \*********************************/
/*! exports provided: Opentip, default */
/*! exports used: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export Opentip */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Opentip; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_window__);



var Opentip = __WEBPACK_IMPORTED_MODULE_0_window___default.a.Opentip || {};

Opentip.styles = Opentip.styles || {};

Opentip.styles.rainloop = {

	'extends': 'standard',

	'fixed': true,
	'target': true,

	'delay': 0.2,
	'hideDelay': 0,

	'hideEffect': 'fade',
	'hideEffectDuration': 0.2,

	'showEffect': 'fade',
	'showEffectDuration': 0.2,

	'showOn': 'mouseover click',
	'removeElementsOnHide': true,

	'background': '#fff',
	'shadow': false,

	'borderColor': '#999',
	'borderRadius': 2,
	'borderWidth': 1
};

Opentip.styles.rainloopTip = {
	'extends': 'rainloop',
	'delay': 0.4,
	'group': 'rainloopTips'
};

Opentip.styles.rainloopErrorTip = {
	'extends': 'rainloop',
	'className': 'rainloopErrorTip'
};



/***/ }),
/* 106 */
/*!*****************************************!*\
  !*** ./node_modules/pikaday/pikaday.js ***!
  \*****************************************/
/*! no static exports found */
/*! exports used: default */
/***/ (function(module, exports, __webpack_require__) {

/*!
 * Pikaday
 *
 * Copyright © 2014 David Bushell | BSD & MIT license | https://github.com/dbushell/Pikaday
 */

(function (root, factory)
{
    'use strict';

    var moment;
    if (true) {
        // CommonJS module
        // Load moment.js as an optional dependency
        try { moment = __webpack_require__(/*! moment */ 75); } catch (e) {}
        module.exports = factory(moment);
    } else if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(function (req)
        {
            // Load moment.js as an optional dependency
            var id = 'moment';
            try { moment = req(id); } catch (e) {}
            return factory(moment);
        });
    } else {
        root.Pikaday = factory(root.moment);
    }
}(this, function (moment)
{
    'use strict';

    /**
     * feature detection and helper functions
     */
    var hasMoment = typeof moment === 'function',

    hasEventListeners = !!window.addEventListener,

    document = window.document,

    sto = window.setTimeout,

    addEvent = function(el, e, callback, capture)
    {
        if (hasEventListeners) {
            el.addEventListener(e, callback, !!capture);
        } else {
            el.attachEvent('on' + e, callback);
        }
    },

    removeEvent = function(el, e, callback, capture)
    {
        if (hasEventListeners) {
            el.removeEventListener(e, callback, !!capture);
        } else {
            el.detachEvent('on' + e, callback);
        }
    },

    trim = function(str)
    {
        return str.trim ? str.trim() : str.replace(/^\s+|\s+$/g,'');
    },

    hasClass = function(el, cn)
    {
        return (' ' + el.className + ' ').indexOf(' ' + cn + ' ') !== -1;
    },

    addClass = function(el, cn)
    {
        if (!hasClass(el, cn)) {
            el.className = (el.className === '') ? cn : el.className + ' ' + cn;
        }
    },

    removeClass = function(el, cn)
    {
        el.className = trim((' ' + el.className + ' ').replace(' ' + cn + ' ', ' '));
    },

    isArray = function(obj)
    {
        return (/Array/).test(Object.prototype.toString.call(obj));
    },

    isDate = function(obj)
    {
        return (/Date/).test(Object.prototype.toString.call(obj)) && !isNaN(obj.getTime());
    },

    isWeekend = function(date)
    {
        var day = date.getDay();
        return day === 0 || day === 6;
    },

    isLeapYear = function(year)
    {
        // solution by Matti Virkkunen: http://stackoverflow.com/a/4881951
        return year % 4 === 0 && year % 100 !== 0 || year % 400 === 0;
    },

    getDaysInMonth = function(year, month)
    {
        return [31, isLeapYear(year) ? 29 : 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31][month];
    },

    setToStartOfDay = function(date)
    {
        if (isDate(date)) date.setHours(0,0,0,0);
    },

    compareDates = function(a,b)
    {
        // weak date comparison (use setToStartOfDay(date) to ensure correct result)
        return a.getTime() === b.getTime();
    },

    extend = function(to, from, overwrite)
    {
        var prop, hasProp;
        for (prop in from) {
            hasProp = to[prop] !== undefined;
            if (hasProp && typeof from[prop] === 'object' && from[prop] !== null && from[prop].nodeName === undefined) {
                if (isDate(from[prop])) {
                    if (overwrite) {
                        to[prop] = new Date(from[prop].getTime());
                    }
                }
                else if (isArray(from[prop])) {
                    if (overwrite) {
                        to[prop] = from[prop].slice(0);
                    }
                } else {
                    to[prop] = extend({}, from[prop], overwrite);
                }
            } else if (overwrite || !hasProp) {
                to[prop] = from[prop];
            }
        }
        return to;
    },

    fireEvent = function(el, eventName, data)
    {
        var ev;

        if (document.createEvent) {
            ev = document.createEvent('HTMLEvents');
            ev.initEvent(eventName, true, false);
            ev = extend(ev, data);
            el.dispatchEvent(ev);
        } else if (document.createEventObject) {
            ev = document.createEventObject();
            ev = extend(ev, data);
            el.fireEvent('on' + eventName, ev);
        }
    },

    adjustCalendar = function(calendar) {
        if (calendar.month < 0) {
            calendar.year -= Math.ceil(Math.abs(calendar.month)/12);
            calendar.month += 12;
        }
        if (calendar.month > 11) {
            calendar.year += Math.floor(Math.abs(calendar.month)/12);
            calendar.month -= 12;
        }
        return calendar;
    },

    /**
     * defaults and localisation
     */
    defaults = {

        // bind the picker to a form field
        field: null,

        // automatically show/hide the picker on `field` focus (default `true` if `field` is set)
        bound: undefined,

        // position of the datepicker, relative to the field (default to bottom & left)
        // ('bottom' & 'left' keywords are not used, 'top' & 'right' are modifier on the bottom/left position)
        position: 'bottom left',

        // automatically fit in the viewport even if it means repositioning from the position option
        reposition: true,

        // the default output format for `.toString()` and `field` value
        format: 'YYYY-MM-DD',

        // the toString function which gets passed a current date object and format
        // and returns a string
        toString: null,

        // used to create date object from current input string
        parse: null,

        // the initial date to view when first opened
        defaultDate: null,

        // make the `defaultDate` the initial selected value
        setDefaultDate: false,

        // first day of week (0: Sunday, 1: Monday etc)
        firstDay: 0,

        // the default flag for moment's strict date parsing
        formatStrict: false,

        // the minimum/earliest date that can be selected
        minDate: null,
        // the maximum/latest date that can be selected
        maxDate: null,

        // number of years either side, or array of upper/lower range
        yearRange: 10,

        // show week numbers at head of row
        showWeekNumber: false,

        // Week picker mode
        pickWholeWeek: false,

        // used internally (don't config outside)
        minYear: 0,
        maxYear: 9999,
        minMonth: undefined,
        maxMonth: undefined,

        startRange: null,
        endRange: null,

        isRTL: false,

        // Additional text to append to the year in the calendar title
        yearSuffix: '',

        // Render the month after year in the calendar title
        showMonthAfterYear: false,

        // Render days of the calendar grid that fall in the next or previous month
        showDaysInNextAndPreviousMonths: false,

        // Allows user to select days that fall in the next or previous month
        enableSelectionDaysInNextAndPreviousMonths: false,

        // how many months are visible
        numberOfMonths: 1,

        // when numberOfMonths is used, this will help you to choose where the main calendar will be (default `left`, can be set to `right`)
        // only used for the first display or when a selected date is not visible
        mainCalendar: 'left',

        // Specify a DOM element to render the calendar in
        container: undefined,

        // Blur field when date is selected
        blurFieldOnSelect : true,

        // internationalization
        i18n: {
            previousMonth : 'Previous Month',
            nextMonth     : 'Next Month',
            months        : ['January','February','March','April','May','June','July','August','September','October','November','December'],
            weekdays      : ['Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday'],
            weekdaysShort : ['Sun','Mon','Tue','Wed','Thu','Fri','Sat']
        },

        // Theme Classname
        theme: null,

        // events array
        events: [],

        // callback function
        onSelect: null,
        onOpen: null,
        onClose: null,
        onDraw: null
    },


    /**
     * templating functions to abstract HTML rendering
     */
    renderDayName = function(opts, day, abbr)
    {
        day += opts.firstDay;
        while (day >= 7) {
            day -= 7;
        }
        return abbr ? opts.i18n.weekdaysShort[day] : opts.i18n.weekdays[day];
    },

    renderDay = function(opts)
    {
        var arr = [];
        var ariaSelected = 'false';
        if (opts.isEmpty) {
            if (opts.showDaysInNextAndPreviousMonths) {
                arr.push('is-outside-current-month');

                if(!opts.enableSelectionDaysInNextAndPreviousMonths) {
                    arr.push('is-selection-disabled');
                }

            } else {
                return '<td class="is-empty"></td>';
            }
        }
        if (opts.isDisabled) {
            arr.push('is-disabled');
        }
        if (opts.isToday) {
            arr.push('is-today');
        }
        if (opts.isSelected) {
            arr.push('is-selected');
            ariaSelected = 'true';
        }
        if (opts.hasEvent) {
            arr.push('has-event');
        }
        if (opts.isInRange) {
            arr.push('is-inrange');
        }
        if (opts.isStartRange) {
            arr.push('is-startrange');
        }
        if (opts.isEndRange) {
            arr.push('is-endrange');
        }
        return '<td data-day="' + opts.day + '" class="' + arr.join(' ') + '" aria-selected="' + ariaSelected + '">' +
                 '<button class="pika-button pika-day" type="button" ' +
                    'data-pika-year="' + opts.year + '" data-pika-month="' + opts.month + '" data-pika-day="' + opts.day + '">' +
                        opts.day +
                 '</button>' +
               '</td>';
    },

    renderWeek = function (d, m, y) {
        // Lifted from http://javascript.about.com/library/blweekyear.htm, lightly modified.
        var onejan = new Date(y, 0, 1),
            weekNum = Math.ceil((((new Date(y, m, d) - onejan) / 86400000) + onejan.getDay()+1)/7);
        return '<td class="pika-week">' + weekNum + '</td>';
    },

    renderRow = function(days, isRTL, pickWholeWeek, isRowSelected)
    {
        return '<tr class="pika-row' + (pickWholeWeek ? ' pick-whole-week' : '') + (isRowSelected ? ' is-selected' : '') + '">' + (isRTL ? days.reverse() : days).join('') + '</tr>';
    },

    renderBody = function(rows)
    {
        return '<tbody>' + rows.join('') + '</tbody>';
    },

    renderHead = function(opts)
    {
        var i, arr = [];
        if (opts.showWeekNumber) {
            arr.push('<th></th>');
        }
        for (i = 0; i < 7; i++) {
            arr.push('<th scope="col"><abbr title="' + renderDayName(opts, i) + '">' + renderDayName(opts, i, true) + '</abbr></th>');
        }
        return '<thead><tr>' + (opts.isRTL ? arr.reverse() : arr).join('') + '</tr></thead>';
    },

    renderTitle = function(instance, c, year, month, refYear, randId)
    {
        var i, j, arr,
            opts = instance._o,
            isMinYear = year === opts.minYear,
            isMaxYear = year === opts.maxYear,
            html = '<div id="' + randId + '" class="pika-title" role="heading" aria-live="assertive">',
            monthHtml,
            yearHtml,
            prev = true,
            next = true;

        for (arr = [], i = 0; i < 12; i++) {
            arr.push('<option value="' + (year === refYear ? i - c : 12 + i - c) + '"' +
                (i === month ? ' selected="selected"': '') +
                ((isMinYear && i < opts.minMonth) || (isMaxYear && i > opts.maxMonth) ? 'disabled="disabled"' : '') + '>' +
                opts.i18n.months[i] + '</option>');
        }

        monthHtml = '<div class="pika-label">' + opts.i18n.months[month] + '<select class="pika-select pika-select-month" tabindex="-1">' + arr.join('') + '</select></div>';

        if (isArray(opts.yearRange)) {
            i = opts.yearRange[0];
            j = opts.yearRange[1] + 1;
        } else {
            i = year - opts.yearRange;
            j = 1 + year + opts.yearRange;
        }

        for (arr = []; i < j && i <= opts.maxYear; i++) {
            if (i >= opts.minYear) {
                arr.push('<option value="' + i + '"' + (i === year ? ' selected="selected"': '') + '>' + (i) + '</option>');
            }
        }
        yearHtml = '<div class="pika-label">' + year + opts.yearSuffix + '<select class="pika-select pika-select-year" tabindex="-1">' + arr.join('') + '</select></div>';

        if (opts.showMonthAfterYear) {
            html += yearHtml + monthHtml;
        } else {
            html += monthHtml + yearHtml;
        }

        if (isMinYear && (month === 0 || opts.minMonth >= month)) {
            prev = false;
        }

        if (isMaxYear && (month === 11 || opts.maxMonth <= month)) {
            next = false;
        }

        if (c === 0) {
            html += '<button class="pika-prev' + (prev ? '' : ' is-disabled') + '" type="button">' + opts.i18n.previousMonth + '</button>';
        }
        if (c === (instance._o.numberOfMonths - 1) ) {
            html += '<button class="pika-next' + (next ? '' : ' is-disabled') + '" type="button">' + opts.i18n.nextMonth + '</button>';
        }

        return html += '</div>';
    },

    renderTable = function(opts, data, randId)
    {
        return '<table cellpadding="0" cellspacing="0" class="pika-table" role="grid" aria-labelledby="' + randId + '">' + renderHead(opts) + renderBody(data) + '</table>';
    },


    /**
     * Pikaday constructor
     */
    Pikaday = function(options)
    {
        var self = this,
            opts = self.config(options);

        self._onMouseDown = function(e)
        {
            if (!self._v) {
                return;
            }
            e = e || window.event;
            var target = e.target || e.srcElement;
            if (!target) {
                return;
            }

            if (!hasClass(target, 'is-disabled')) {
                if (hasClass(target, 'pika-button') && !hasClass(target, 'is-empty') && !hasClass(target.parentNode, 'is-disabled')) {
                    self.setDate(new Date(target.getAttribute('data-pika-year'), target.getAttribute('data-pika-month'), target.getAttribute('data-pika-day')));
                    if (opts.bound) {
                        sto(function() {
                            self.hide();
                            if (opts.blurFieldOnSelect && opts.field) {
                                opts.field.blur();
                            }
                        }, 100);
                    }
                }
                else if (hasClass(target, 'pika-prev')) {
                    self.prevMonth();
                }
                else if (hasClass(target, 'pika-next')) {
                    self.nextMonth();
                }
            }
            if (!hasClass(target, 'pika-select')) {
                // if this is touch event prevent mouse events emulation
                if (e.preventDefault) {
                    e.preventDefault();
                } else {
                    e.returnValue = false;
                    return false;
                }
            } else {
                self._c = true;
            }
        };

        self._onChange = function(e)
        {
            e = e || window.event;
            var target = e.target || e.srcElement;
            if (!target) {
                return;
            }
            if (hasClass(target, 'pika-select-month')) {
                self.gotoMonth(target.value);
            }
            else if (hasClass(target, 'pika-select-year')) {
                self.gotoYear(target.value);
            }
        };

        self._onKeyChange = function(e)
        {
            e = e || window.event;

            if (self.isVisible()) {

                switch(e.keyCode){
                    case 13:
                    case 27:
                        if (opts.field) {
                            opts.field.blur();
                        }
                        break;
                    case 37:
                        e.preventDefault();
                        self.adjustDate('subtract', 1);
                        break;
                    case 38:
                        self.adjustDate('subtract', 7);
                        break;
                    case 39:
                        self.adjustDate('add', 1);
                        break;
                    case 40:
                        self.adjustDate('add', 7);
                        break;
                }
            }
        };

        self._onInputChange = function(e)
        {
            var date;

            if (e.firedBy === self) {
                return;
            }
            if (opts.parse) {
                date = opts.parse(opts.field.value, opts.format);
            } else if (hasMoment) {
                date = moment(opts.field.value, opts.format, opts.formatStrict);
                date = (date && date.isValid()) ? date.toDate() : null;
            }
            else {
                date = new Date(Date.parse(opts.field.value));
            }
            if (isDate(date)) {
              self.setDate(date);
            }
            if (!self._v) {
                self.show();
            }
        };

        self._onInputFocus = function()
        {
            self.show();
        };

        self._onInputClick = function()
        {
            self.show();
        };

        self._onInputBlur = function()
        {
            // IE allows pika div to gain focus; catch blur the input field
            var pEl = document.activeElement;
            do {
                if (hasClass(pEl, 'pika-single')) {
                    return;
                }
            }
            while ((pEl = pEl.parentNode));

            if (!self._c) {
                self._b = sto(function() {
                    self.hide();
                }, 50);
            }
            self._c = false;
        };

        self._onClick = function(e)
        {
            e = e || window.event;
            var target = e.target || e.srcElement,
                pEl = target;
            if (!target) {
                return;
            }
            if (!hasEventListeners && hasClass(target, 'pika-select')) {
                if (!target.onchange) {
                    target.setAttribute('onchange', 'return;');
                    addEvent(target, 'change', self._onChange);
                }
            }
            do {
                if (hasClass(pEl, 'pika-single') || pEl === opts.trigger) {
                    return;
                }
            }
            while ((pEl = pEl.parentNode));
            if (self._v && target !== opts.trigger && pEl !== opts.trigger) {
                self.hide();
            }
        };

        self.el = document.createElement('div');
        self.el.className = 'pika-single' + (opts.isRTL ? ' is-rtl' : '') + (opts.theme ? ' ' + opts.theme : '');

        addEvent(self.el, 'mousedown', self._onMouseDown, true);
        addEvent(self.el, 'touchend', self._onMouseDown, true);
        addEvent(self.el, 'change', self._onChange);
        addEvent(document, 'keydown', self._onKeyChange);

        if (opts.field) {
            if (opts.container) {
                opts.container.appendChild(self.el);
            } else if (opts.bound) {
                document.body.appendChild(self.el);
            } else {
                opts.field.parentNode.insertBefore(self.el, opts.field.nextSibling);
            }
            addEvent(opts.field, 'change', self._onInputChange);

            if (!opts.defaultDate) {
                if (hasMoment && opts.field.value) {
                    opts.defaultDate = moment(opts.field.value, opts.format).toDate();
                } else {
                    opts.defaultDate = new Date(Date.parse(opts.field.value));
                }
                opts.setDefaultDate = true;
            }
        }

        var defDate = opts.defaultDate;

        if (isDate(defDate)) {
            if (opts.setDefaultDate) {
                self.setDate(defDate, true);
            } else {
                self.gotoDate(defDate);
            }
        } else {
            self.gotoDate(new Date());
        }

        if (opts.bound) {
            this.hide();
            self.el.className += ' is-bound';
            addEvent(opts.trigger, 'click', self._onInputClick);
            addEvent(opts.trigger, 'focus', self._onInputFocus);
            addEvent(opts.trigger, 'blur', self._onInputBlur);
        } else {
            this.show();
        }
    };


    /**
     * public Pikaday API
     */
    Pikaday.prototype = {


        /**
         * configure functionality
         */
        config: function(options)
        {
            if (!this._o) {
                this._o = extend({}, defaults, true);
            }

            var opts = extend(this._o, options, true);

            opts.isRTL = !!opts.isRTL;

            opts.field = (opts.field && opts.field.nodeName) ? opts.field : null;

            opts.theme = (typeof opts.theme) === 'string' && opts.theme ? opts.theme : null;

            opts.bound = !!(opts.bound !== undefined ? opts.field && opts.bound : opts.field);

            opts.trigger = (opts.trigger && opts.trigger.nodeName) ? opts.trigger : opts.field;

            opts.disableWeekends = !!opts.disableWeekends;

            opts.disableDayFn = (typeof opts.disableDayFn) === 'function' ? opts.disableDayFn : null;

            var nom = parseInt(opts.numberOfMonths, 10) || 1;
            opts.numberOfMonths = nom > 4 ? 4 : nom;

            if (!isDate(opts.minDate)) {
                opts.minDate = false;
            }
            if (!isDate(opts.maxDate)) {
                opts.maxDate = false;
            }
            if ((opts.minDate && opts.maxDate) && opts.maxDate < opts.minDate) {
                opts.maxDate = opts.minDate = false;
            }
            if (opts.minDate) {
                this.setMinDate(opts.minDate);
            }
            if (opts.maxDate) {
                this.setMaxDate(opts.maxDate);
            }

            if (isArray(opts.yearRange)) {
                var fallback = new Date().getFullYear() - 10;
                opts.yearRange[0] = parseInt(opts.yearRange[0], 10) || fallback;
                opts.yearRange[1] = parseInt(opts.yearRange[1], 10) || fallback;
            } else {
                opts.yearRange = Math.abs(parseInt(opts.yearRange, 10)) || defaults.yearRange;
                if (opts.yearRange > 100) {
                    opts.yearRange = 100;
                }
            }

            return opts;
        },

        /**
         * return a formatted string of the current selection (using Moment.js if available)
         */
        toString: function(format)
        {
            format = format || this._o.format;
            if (!isDate(this._d)) {
                return '';
            }
            if (this._o.toString) {
              return this._o.toString(this._d, format);
            }
            if (hasMoment) {
              return moment(this._d).format(format);
            }
            return this._d.toDateString();
        },

        /**
         * return a Moment.js object of the current selection (if available)
         */
        getMoment: function()
        {
            return hasMoment ? moment(this._d) : null;
        },

        /**
         * set the current selection from a Moment.js object (if available)
         */
        setMoment: function(date, preventOnSelect)
        {
            if (hasMoment && moment.isMoment(date)) {
                this.setDate(date.toDate(), preventOnSelect);
            }
        },

        /**
         * return a Date object of the current selection
         */
        getDate: function()
        {
            return isDate(this._d) ? new Date(this._d.getTime()) : null;
        },

        /**
         * set the current selection
         */
        setDate: function(date, preventOnSelect)
        {
            if (!date) {
                this._d = null;

                if (this._o.field) {
                    this._o.field.value = '';
                    fireEvent(this._o.field, 'change', { firedBy: this });
                }

                return this.draw();
            }
            if (typeof date === 'string') {
                date = new Date(Date.parse(date));
            }
            if (!isDate(date)) {
                return;
            }

            var min = this._o.minDate,
                max = this._o.maxDate;

            if (isDate(min) && date < min) {
                date = min;
            } else if (isDate(max) && date > max) {
                date = max;
            }

            this._d = new Date(date.getTime());
            setToStartOfDay(this._d);
            this.gotoDate(this._d);

            if (this._o.field) {
                this._o.field.value = this.toString();
                fireEvent(this._o.field, 'change', { firedBy: this });
            }
            if (!preventOnSelect && typeof this._o.onSelect === 'function') {
                this._o.onSelect.call(this, this.getDate());
            }
        },

        /**
         * change view to a specific date
         */
        gotoDate: function(date)
        {
            var newCalendar = true;

            if (!isDate(date)) {
                return;
            }

            if (this.calendars) {
                var firstVisibleDate = new Date(this.calendars[0].year, this.calendars[0].month, 1),
                    lastVisibleDate = new Date(this.calendars[this.calendars.length-1].year, this.calendars[this.calendars.length-1].month, 1),
                    visibleDate = date.getTime();
                // get the end of the month
                lastVisibleDate.setMonth(lastVisibleDate.getMonth()+1);
                lastVisibleDate.setDate(lastVisibleDate.getDate()-1);
                newCalendar = (visibleDate < firstVisibleDate.getTime() || lastVisibleDate.getTime() < visibleDate);
            }

            if (newCalendar) {
                this.calendars = [{
                    month: date.getMonth(),
                    year: date.getFullYear()
                }];
                if (this._o.mainCalendar === 'right') {
                    this.calendars[0].month += 1 - this._o.numberOfMonths;
                }
            }

            this.adjustCalendars();
        },

        adjustDate: function(sign, days) {

            var day = this.getDate() || new Date();
            var difference = parseInt(days)*24*60*60*1000;

            var newDay;

            if (sign === 'add') {
                newDay = new Date(day.valueOf() + difference);
            } else if (sign === 'subtract') {
                newDay = new Date(day.valueOf() - difference);
            }

            this.setDate(newDay);
        },

        adjustCalendars: function() {
            this.calendars[0] = adjustCalendar(this.calendars[0]);
            for (var c = 1; c < this._o.numberOfMonths; c++) {
                this.calendars[c] = adjustCalendar({
                    month: this.calendars[0].month + c,
                    year: this.calendars[0].year
                });
            }
            this.draw();
        },

        gotoToday: function()
        {
            this.gotoDate(new Date());
        },

        /**
         * change view to a specific month (zero-index, e.g. 0: January)
         */
        gotoMonth: function(month)
        {
            if (!isNaN(month)) {
                this.calendars[0].month = parseInt(month, 10);
                this.adjustCalendars();
            }
        },

        nextMonth: function()
        {
            this.calendars[0].month++;
            this.adjustCalendars();
        },

        prevMonth: function()
        {
            this.calendars[0].month--;
            this.adjustCalendars();
        },

        /**
         * change view to a specific full year (e.g. "2012")
         */
        gotoYear: function(year)
        {
            if (!isNaN(year)) {
                this.calendars[0].year = parseInt(year, 10);
                this.adjustCalendars();
            }
        },

        /**
         * change the minDate
         */
        setMinDate: function(value)
        {
            if(value instanceof Date) {
                setToStartOfDay(value);
                this._o.minDate = value;
                this._o.minYear  = value.getFullYear();
                this._o.minMonth = value.getMonth();
            } else {
                this._o.minDate = defaults.minDate;
                this._o.minYear  = defaults.minYear;
                this._o.minMonth = defaults.minMonth;
                this._o.startRange = defaults.startRange;
            }

            this.draw();
        },

        /**
         * change the maxDate
         */
        setMaxDate: function(value)
        {
            if(value instanceof Date) {
                setToStartOfDay(value);
                this._o.maxDate = value;
                this._o.maxYear = value.getFullYear();
                this._o.maxMonth = value.getMonth();
            } else {
                this._o.maxDate = defaults.maxDate;
                this._o.maxYear = defaults.maxYear;
                this._o.maxMonth = defaults.maxMonth;
                this._o.endRange = defaults.endRange;
            }

            this.draw();
        },

        setStartRange: function(value)
        {
            this._o.startRange = value;
        },

        setEndRange: function(value)
        {
            this._o.endRange = value;
        },

        /**
         * refresh the HTML
         */
        draw: function(force)
        {
            if (!this._v && !force) {
                return;
            }
            var opts = this._o,
                minYear = opts.minYear,
                maxYear = opts.maxYear,
                minMonth = opts.minMonth,
                maxMonth = opts.maxMonth,
                html = '',
                randId;

            if (this._y <= minYear) {
                this._y = minYear;
                if (!isNaN(minMonth) && this._m < minMonth) {
                    this._m = minMonth;
                }
            }
            if (this._y >= maxYear) {
                this._y = maxYear;
                if (!isNaN(maxMonth) && this._m > maxMonth) {
                    this._m = maxMonth;
                }
            }

            randId = 'pika-title-' + Math.random().toString(36).replace(/[^a-z]+/g, '').substr(0, 2);

            for (var c = 0; c < opts.numberOfMonths; c++) {
                html += '<div class="pika-lendar">' + renderTitle(this, c, this.calendars[c].year, this.calendars[c].month, this.calendars[0].year, randId) + this.render(this.calendars[c].year, this.calendars[c].month, randId) + '</div>';
            }

            this.el.innerHTML = html;

            if (opts.bound) {
                if(opts.field.type !== 'hidden') {
                    sto(function() {
                        opts.trigger.focus();
                    }, 1);
                }
            }

            if (typeof this._o.onDraw === 'function') {
                this._o.onDraw(this);
            }

            if (opts.bound) {
                // let the screen reader user know to use arrow keys
                opts.field.setAttribute('aria-label', 'Use the arrow keys to pick a date');
            }
        },

        adjustPosition: function()
        {
            var field, pEl, width, height, viewportWidth, viewportHeight, scrollTop, left, top, clientRect;

            if (this._o.container) return;

            this.el.style.position = 'absolute';

            field = this._o.trigger;
            pEl = field;
            width = this.el.offsetWidth;
            height = this.el.offsetHeight;
            viewportWidth = window.innerWidth || document.documentElement.clientWidth;
            viewportHeight = window.innerHeight || document.documentElement.clientHeight;
            scrollTop = window.pageYOffset || document.body.scrollTop || document.documentElement.scrollTop;

            if (typeof field.getBoundingClientRect === 'function') {
                clientRect = field.getBoundingClientRect();
                left = clientRect.left + window.pageXOffset;
                top = clientRect.bottom + window.pageYOffset;
            } else {
                left = pEl.offsetLeft;
                top  = pEl.offsetTop + pEl.offsetHeight;
                while((pEl = pEl.offsetParent)) {
                    left += pEl.offsetLeft;
                    top  += pEl.offsetTop;
                }
            }

            // default position is bottom & left
            if ((this._o.reposition && left + width > viewportWidth) ||
                (
                    this._o.position.indexOf('right') > -1 &&
                    left - width + field.offsetWidth > 0
                )
            ) {
                left = left - width + field.offsetWidth;
            }
            if ((this._o.reposition && top + height > viewportHeight + scrollTop) ||
                (
                    this._o.position.indexOf('top') > -1 &&
                    top - height - field.offsetHeight > 0
                )
            ) {
                top = top - height - field.offsetHeight;
            }

            this.el.style.left = left + 'px';
            this.el.style.top = top + 'px';
        },

        /**
         * render HTML for a particular month
         */
        render: function(year, month, randId)
        {
            var opts   = this._o,
                now    = new Date(),
                days   = getDaysInMonth(year, month),
                before = new Date(year, month, 1).getDay(),
                data   = [],
                row    = [];
            setToStartOfDay(now);
            if (opts.firstDay > 0) {
                before -= opts.firstDay;
                if (before < 0) {
                    before += 7;
                }
            }
            var previousMonth = month === 0 ? 11 : month - 1,
                nextMonth = month === 11 ? 0 : month + 1,
                yearOfPreviousMonth = month === 0 ? year - 1 : year,
                yearOfNextMonth = month === 11 ? year + 1 : year,
                daysInPreviousMonth = getDaysInMonth(yearOfPreviousMonth, previousMonth);
            var cells = days + before,
                after = cells;
            while(after > 7) {
                after -= 7;
            }
            cells += 7 - after;
            var isWeekSelected = false;
            for (var i = 0, r = 0; i < cells; i++)
            {
                var day = new Date(year, month, 1 + (i - before)),
                    isSelected = isDate(this._d) ? compareDates(day, this._d) : false,
                    isToday = compareDates(day, now),
                    hasEvent = opts.events.indexOf(day.toDateString()) !== -1 ? true : false,
                    isEmpty = i < before || i >= (days + before),
                    dayNumber = 1 + (i - before),
                    monthNumber = month,
                    yearNumber = year,
                    isStartRange = opts.startRange && compareDates(opts.startRange, day),
                    isEndRange = opts.endRange && compareDates(opts.endRange, day),
                    isInRange = opts.startRange && opts.endRange && opts.startRange < day && day < opts.endRange,
                    isDisabled = (opts.minDate && day < opts.minDate) ||
                                 (opts.maxDate && day > opts.maxDate) ||
                                 (opts.disableWeekends && isWeekend(day)) ||
                                 (opts.disableDayFn && opts.disableDayFn(day));

                if (isEmpty) {
                    if (i < before) {
                        dayNumber = daysInPreviousMonth + dayNumber;
                        monthNumber = previousMonth;
                        yearNumber = yearOfPreviousMonth;
                    } else {
                        dayNumber = dayNumber - days;
                        monthNumber = nextMonth;
                        yearNumber = yearOfNextMonth;
                    }
                }

                var dayConfig = {
                        day: dayNumber,
                        month: monthNumber,
                        year: yearNumber,
                        hasEvent: hasEvent,
                        isSelected: isSelected,
                        isToday: isToday,
                        isDisabled: isDisabled,
                        isEmpty: isEmpty,
                        isStartRange: isStartRange,
                        isEndRange: isEndRange,
                        isInRange: isInRange,
                        showDaysInNextAndPreviousMonths: opts.showDaysInNextAndPreviousMonths,
                        enableSelectionDaysInNextAndPreviousMonths: opts.enableSelectionDaysInNextAndPreviousMonths
                    };

                if (opts.pickWholeWeek && isSelected) {
                    isWeekSelected = true;
                }

                row.push(renderDay(dayConfig));

                if (++r === 7) {
                    if (opts.showWeekNumber) {
                        row.unshift(renderWeek(i - before, month, year));
                    }
                    data.push(renderRow(row, opts.isRTL, opts.pickWholeWeek, isWeekSelected));
                    row = [];
                    r = 0;
                    isWeekSelected = false;
                }
            }
            return renderTable(opts, data, randId);
        },

        isVisible: function()
        {
            return this._v;
        },

        show: function()
        {
            if (!this.isVisible()) {
                this._v = true;
                this.draw();
                removeClass(this.el, 'is-hidden');
                if (this._o.bound) {
                    addEvent(document, 'click', this._onClick);
                    this.adjustPosition();
                }
                if (typeof this._o.onOpen === 'function') {
                    this._o.onOpen.call(this);
                }
            }
        },

        hide: function()
        {
            var v = this._v;
            if (v !== false) {
                if (this._o.bound) {
                    removeEvent(document, 'click', this._onClick);
                }
                this.el.style.position = 'static'; // reset
                this.el.style.left = 'auto';
                this.el.style.top = 'auto';
                addClass(this.el, 'is-hidden');
                this._v = false;
                if (v !== undefined && typeof this._o.onClose === 'function') {
                    this._o.onClose.call(this);
                }
            }
        },

        /**
         * GAME OVER
         */
        destroy: function()
        {
            this.hide();
            removeEvent(this.el, 'mousedown', this._onMouseDown, true);
            removeEvent(this.el, 'touchend', this._onMouseDown, true);
            removeEvent(this.el, 'change', this._onChange);
            removeEvent(document, 'keydown', this._onKeyChange);
            if (this._o.field) {
                removeEvent(this._o.field, 'change', this._onInputChange);
                if (this._o.bound) {
                    removeEvent(this._o.trigger, 'click', this._onInputClick);
                    removeEvent(this._o.trigger, 'focus', this._onInputFocus);
                    removeEvent(this._o.trigger, 'blur', this._onInputBlur);
                }
            }
            if (this.el.parentNode) {
                this.el.parentNode.removeChild(this.el);
            }
        }

    };

    return Pikaday;

}));


/***/ }),
/* 107 */
/*!************************************!*\
  !*** external "window.Autolinker" ***!
  \************************************/
/*! no static exports found */
/*! exports used: default */
/***/ (function(module, exports) {

module.exports = window.Autolinker;

/***/ }),
/* 108 */
/*!****************************!*\
  !*** ./dev/Common/Mime.js ***!
  \****************************/
/*! exports provided: Mime, default */
/*! exports used: Mime */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Mime; });
/* unused harmony export default */

/* eslint key-spacing: 0 */
/* eslint quote-props: 0 */

var Mime = {
	'eml': 'message/rfc822',
	'mime': 'message/rfc822',
	'txt': 'text/plain',
	'text': 'text/plain',
	'def': 'text/plain',
	'list': 'text/plain',
	'in': 'text/plain',
	'ini': 'text/plain',
	'log': 'text/plain',
	'sql': 'text/plain',
	'cfg': 'text/plain',
	'conf': 'text/plain',
	'asc': 'text/plain',
	'rtx': 'text/richtext',
	'vcard': 'text/vcard',
	'vcf': 'text/vcard',
	'htm': 'text/html',
	'html': 'text/html',
	'csv': 'text/csv',
	'ics': 'text/calendar',
	'ifb': 'text/calendar',
	'xml': 'text/xml',
	'json': 'application/json',
	'swf': 'application/x-shockwave-flash',
	'hlp': 'application/winhlp',
	'wgt': 'application/widget',
	'chm': 'application/vnd.ms-htmlhelp',
	'p10': 'application/pkcs10',
	'p7c': 'application/pkcs7-mime',
	'p7m': 'application/pkcs7-mime',
	'p7s': 'application/pkcs7-signature',
	'torrent': 'application/x-bittorrent',

	// scripts
	'js': 'application/javascript',
	'pl': 'text/perl',
	'css': 'text/css',
	'asp': 'text/asp',
	'php': 'application/x-httpd-php',
	'php3': 'application/x-httpd-php',
	'php4': 'application/x-httpd-php',
	'php5': 'application/x-httpd-php',
	'phtml': 'application/x-httpd-php',

	// images
	'png': 'image/png',
	'jpg': 'image/jpeg',
	'jpeg': 'image/jpeg',
	'jpe': 'image/jpeg',
	'jfif': 'image/jpeg',
	'gif': 'image/gif',
	'bmp': 'image/bmp',
	'cgm': 'image/cgm',
	'ief': 'image/ief',
	'ico': 'image/x-icon',
	'tif': 'image/tiff',
	'tiff': 'image/tiff',
	'svg': 'image/svg+xml',
	'svgz': 'image/svg+xml',
	'djv': 'image/vnd.djvu',
	'djvu': 'image/vnd.djvu',
	'webp': 'image/webp',

	// archives
	'zip': 'application/zip',
	'7z': 'application/x-7z-compressed',
	'rar': 'application/x-rar-compressed',
	'exe': 'application/x-msdownload',
	'dll': 'application/x-msdownload',
	'scr': 'application/x-msdownload',
	'com': 'application/x-msdownload',
	'bat': 'application/x-msdownload',
	'msi': 'application/x-msdownload',
	'cab': 'application/vnd.ms-cab-compressed',
	'gz': 'application/x-gzip',
	'tgz': 'application/x-gzip',
	'bz': 'application/x-bzip',
	'bz2': 'application/x-bzip2',
	'deb': 'application/x-debian-package',

	// fonts
	'psf': 'application/x-font-linux-psf',
	'otf': 'application/x-font-otf',
	'pcf': 'application/x-font-pcf',
	'snf': 'application/x-font-snf',
	'ttf': 'application/x-font-ttf',
	'ttc': 'application/x-font-ttf',

	// audio
	'mp3': 'audio/mpeg',
	'amr': 'audio/amr',
	'aac': 'audio/x-aac',
	'aif': 'audio/x-aiff',
	'aifc': 'audio/x-aiff',
	'aiff': 'audio/x-aiff',
	'wav': 'audio/x-wav',
	'wma': 'audio/x-ms-wma',
	'wax': 'audio/x-ms-wax',
	'midi': 'audio/midi',
	'mp4a': 'audio/mp4',
	'ogg': 'audio/ogg',
	'weba': 'audio/webm',
	'ra': 'audio/x-pn-realaudio',
	'ram': 'audio/x-pn-realaudio',
	'rmp': 'audio/x-pn-realaudio-plugin',
	'm3u': 'audio/x-mpegurl',

	// video
	'flv': 'video/x-flv',
	'qt': 'video/quicktime',
	'mov': 'video/quicktime',
	'wmv': 'video/windows-media',
	'avi': 'video/x-msvideo',
	'mpg': 'video/mpeg',
	'mpeg': 'video/mpeg',
	'mpe': 'video/mpeg',
	'm1v': 'video/mpeg',
	'm2v': 'video/mpeg',
	'3gp': 'video/3gpp',
	'3g2': 'video/3gpp2',
	'h261': 'video/h261',
	'h263': 'video/h263',
	'h264': 'video/h264',
	'jpgv': 'video/jpgv',
	'mp4': 'video/mp4',
	'mp4v': 'video/mp4',
	'mpg4': 'video/mp4',
	'ogv': 'video/ogg',
	'webm': 'video/webm',
	'm4v': 'video/x-m4v',
	'asf': 'video/x-ms-asf',
	'asx': 'video/x-ms-asf',
	'wm': 'video/x-ms-wm',
	'wmx': 'video/x-ms-wmx',
	'wvx': 'video/x-ms-wvx',
	'movie': 'video/x-sgi-movie',

	// adobe
	'pdf': 'application/pdf',
	'psd': 'image/vnd.adobe.photoshop',
	'ai': 'application/postscript',
	'eps': 'application/postscript',
	'ps': 'application/postscript',

	// ms office
	'doc': 'application/msword',
	'dot': 'application/msword',
	'rtf': 'application/rtf',
	'xls': 'application/vnd.ms-excel',
	'ppt': 'application/vnd.ms-powerpoint',
	'docx': 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
	'xlsx': 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
	'dotx': 'application/vnd.openxmlformats-officedocument.wordprocessingml.template',
	'pptx': 'application/vnd.openxmlformats-officedocument.presentationml.presentation',

	// open office
	'odt': 'application/vnd.oasis.opendocument.text',
	'ods': 'application/vnd.oasis.opendocument.spreadsheet'
};



/***/ }),
/* 109 */
/*!**************************************!*\
  !*** ./dev/Html/PreviewMessage.html ***!
  \**************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

module.exports = "<html>\n<head>\n\t<meta charset=\"utf-8\" />\n\t<meta name=\"viewport\" content=\"user-scalable=no\" />\n\t<meta name=\"apple-mobile-web-app-capable\" content=\"yes\" />\n\t<meta name=\"robots\" content=\"noindex, nofollow, noodp\" />\n\t<title>{{title}}</title>\n\t<style>\nhtml, body {\n\tbackground-color: #fff;\n\tfont-size: 13px;\n\tfont-family: arial, sans-serif;\n\tmargin: 0;\n\tpadding: 0;\n}\n\na {color: blue; text-decoration: underline}\na:visited {color: #609}\na:active {color: red}\nblockquote {border-left: 2px solid black; margin: 0; padding: 0px 10px}\n\npre {\n\tmargin: 0px;\n\tpadding: 0px;\n\tfont-family: Monaco, Menlo, Consolas, 'Courier New', monospace;\n\tbackground: #fff;\n\tborder: none;\n\twhite-space: pre-wrap;\n\tword-wrap: break-word;\n\tword-break: break-all;\n}\n\n.body-wrp {\n\tpadding: 10px;\n}\n\n.body-wrp.html pre {\n\tfont-family: Monaco, Menlo, Consolas, 'Courier New', monospace;\n\twhite-space: pre-wrap;\n\tword-wrap: break-word;\n\tword-break: normal;\n}\n\n.body-wrp.plain {\n\tpadding: 15px;\n\twhite-space: pre-wrap;\n\tfont-family: Monaco, Menlo, Consolas, 'Courier New', monospace;\n}\n\n.body-wrp.plain pre {\n\tmargin: 0px;\n\tpadding: 0px;\n\tbackground: #fff;\n\tborder: none;\n\tfont-family: Monaco, Menlo, Consolas, 'Courier New', monospace;\n\twhite-space: pre-wrap;\n\tword-wrap: break-word;\n\tword-break: normal;\n}\n\n.body-wrp.plain blockquote {\n\tborder-left: 2px solid blue;\n\tcolor: blue;\n}\n\n.body-wrp.plain blockquote blockquote {\n\tborder-left: 2px solid green;\n\tcolor: green;\n}\n\n.body-wrp.plain blockquote blockquote blockquote {\n\tborder-left: 2px solid red;\n\tcolor: red;\n}\n.rl-preview-subject {\n\tfont-size: 16px;\n\tfont-weight: bold;\n\tpadding: 15px;\n}\n.rl-preview-creds-from, .rl-preview-creds-to, .rl-preview-creds-cc {\n\tfont-size: 12px;\n\tpadding: 5px 15px;\n}\n.rl-preview-date {\n\tfloat: right;\n\tfont-size: 12px;\n\tpadding: 10px 15px;\n}\n.rl-preview-section {\n\tpadding: 0;\n\tmargin: 0;\n\tborder-bottom: 1px solid #ccc;\n}\n.rl-preview-hide {\n\tdisplay: none;\n}\n\t</style>\n</head>\n<body>\n\t<div class=\"rl-preview-section\">\n\t\t<div class=\"rl-preview-subject\">{{subject}}</div>\n\t</div>\n\t<div class=\"rl-preview-section\">\n\t\t<div class=\"rl-preview-date\">{{date}}</div>\n\t\t<div class=\"rl-preview-creds-from\">{{fromCreds}}</div>\n\t\t<div class=\"rl-preview-creds-to\">{{toLabel}}: {{toCreds}}</div>\n\t\t<div class=\"rl-preview-creds-cc {{ccClass}}\">{{ccLabel}}: {{ccCreds}}</div>\n\t</div>\n\t<div class=\"body-wrp {{bodyClass}}\">{{html}}</div>\n</body>\n</html>"

/***/ }),
/* 110 */
/*!********************************!*\
  !*** external "window.hasher" ***!
  \********************************/
/*! no static exports found */
/*! exports used: default */
/***/ (function(module, exports) {

module.exports = window.hasher;

/***/ }),
/* 111 */
/*!***************************************************************!*\
  !*** ./node_modules/babel-runtime/core-js/symbol/iterator.js ***!
  \***************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(/*! core-js/library/fn/symbol/iterator */ 112), __esModule: true };

/***/ }),
/* 112 */
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/fn/symbol/iterator.js ***!
  \************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ../../modules/es6.string.iterator */ 113);
__webpack_require__(/*! ../../modules/web.dom.iterable */ 123);
module.exports = __webpack_require__(/*! ../../modules/_wks-ext */ 70).f('iterator');


/***/ }),
/* 113 */
/*!*********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.string.iterator.js ***!
  \*********************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $at = __webpack_require__(/*! ./_string-at */ 114)(true);

// 21.1.3.27 String.prototype[@@iterator]()
__webpack_require__(/*! ./_iter-define */ 88)(String, 'String', function (iterated) {
  this._t = String(iterated); // target
  this._i = 0;                // next index
// 21.1.5.2.1 %StringIteratorPrototype%.next()
}, function () {
  var O = this._t;
  var index = this._i;
  var point;
  if (index >= O.length) return { value: undefined, done: true };
  point = $at(O, index);
  this._i += point.length;
  return { value: point, done: false };
});


/***/ }),
/* 114 */
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_string-at.js ***!
  \************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

var toInteger = __webpack_require__(/*! ./_to-integer */ 61);
var defined = __webpack_require__(/*! ./_defined */ 49);
// true  -> String#at
// false -> String#codePointAt
module.exports = function (TO_STRING) {
  return function (that, pos) {
    var s = String(defined(that));
    var i = toInteger(pos);
    var l = s.length;
    var a, b;
    if (i < 0 || i >= l) return TO_STRING ? '' : undefined;
    a = s.charCodeAt(i);
    return a < 0xd800 || a > 0xdbff || i + 1 === l || (b = s.charCodeAt(i + 1)) < 0xdc00 || b > 0xdfff
      ? TO_STRING ? s.charAt(i) : a
      : TO_STRING ? s.slice(i, i + 2) : (a - 0xd800 << 10) + (b - 0xdc00) + 0x10000;
  };
};


/***/ }),
/* 115 */
/*!**************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_iter-create.js ***!
  \**************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var create = __webpack_require__(/*! ./_object-create */ 64);
var descriptor = __webpack_require__(/*! ./_property-desc */ 39);
var setToStringTag = __webpack_require__(/*! ./_set-to-string-tag */ 69);
var IteratorPrototype = {};

// 25.1.2.1.1 %IteratorPrototype%[@@iterator]()
__webpack_require__(/*! ./_hide */ 28)(IteratorPrototype, __webpack_require__(/*! ./_wks */ 36)('iterator'), function () { return this; });

module.exports = function (Constructor, NAME, next) {
  Constructor.prototype = create(IteratorPrototype, { next: descriptor(1, next) });
  setToStringTag(Constructor, NAME + ' Iterator');
};


/***/ }),
/* 116 */
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-dps.js ***!
  \*************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

var dP = __webpack_require__(/*! ./_object-dp */ 26);
var anObject = __webpack_require__(/*! ./_an-object */ 35);
var getKeys = __webpack_require__(/*! ./_object-keys */ 65);

module.exports = __webpack_require__(/*! ./_descriptors */ 23) ? Object.defineProperties : function defineProperties(O, Properties) {
  anObject(O);
  var keys = getKeys(Properties);
  var length = keys.length;
  var i = 0;
  var P;
  while (length > i) dP.f(O, P = keys[i++], Properties[P]);
  return O;
};


/***/ }),
/* 117 */
/*!*****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_array-includes.js ***!
  \*****************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

// false -> Array#indexOf
// true  -> Array#includes
var toIObject = __webpack_require__(/*! ./_to-iobject */ 24);
var toLength = __webpack_require__(/*! ./_to-length */ 118);
var toAbsoluteIndex = __webpack_require__(/*! ./_to-absolute-index */ 119);
module.exports = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = toIObject($this);
    var length = toLength(O.length);
    var index = toAbsoluteIndex(fromIndex, length);
    var value;
    // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare
    if (IS_INCLUDES && el != el) while (length > index) {
      value = O[index++];
      // eslint-disable-next-line no-self-compare
      if (value != value) return true;
    // Array#indexOf ignores holes, Array#includes - not
    } else for (;length > index; index++) if (IS_INCLUDES || index in O) {
      if (O[index] === el) return IS_INCLUDES || index || 0;
    } return !IS_INCLUDES && -1;
  };
};


/***/ }),
/* 118 */
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_to-length.js ***!
  \************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

// 7.1.15 ToLength
var toInteger = __webpack_require__(/*! ./_to-integer */ 61);
var min = Math.min;
module.exports = function (it) {
  return it > 0 ? min(toInteger(it), 0x1fffffffffffff) : 0; // pow(2, 53) - 1 == 9007199254740991
};


/***/ }),
/* 119 */
/*!********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_to-absolute-index.js ***!
  \********************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

var toInteger = __webpack_require__(/*! ./_to-integer */ 61);
var max = Math.max;
var min = Math.min;
module.exports = function (index, length) {
  index = toInteger(index);
  return index < 0 ? max(index + length, 0) : min(index, length);
};


/***/ }),
/* 120 */
/*!*******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_html.js ***!
  \*******************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

var document = __webpack_require__(/*! ./_global */ 21).document;
module.exports = document && document.documentElement;


/***/ }),
/* 121 */
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-gpo.js ***!
  \*************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.9 / 15.2.3.2 Object.getPrototypeOf(O)
var has = __webpack_require__(/*! ./_has */ 25);
var toObject = __webpack_require__(/*! ./_to-object */ 122);
var IE_PROTO = __webpack_require__(/*! ./_shared-key */ 66)('IE_PROTO');
var ObjectProto = Object.prototype;

module.exports = Object.getPrototypeOf || function (O) {
  O = toObject(O);
  if (has(O, IE_PROTO)) return O[IE_PROTO];
  if (typeof O.constructor == 'function' && O instanceof O.constructor) {
    return O.constructor.prototype;
  } return O instanceof Object ? ObjectProto : null;
};


/***/ }),
/* 122 */
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_to-object.js ***!
  \************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

// 7.1.13 ToObject(argument)
var defined = __webpack_require__(/*! ./_defined */ 49);
module.exports = function (it) {
  return Object(defined(it));
};


/***/ }),
/* 123 */
/*!******************************************************************!*\
  !*** ./node_modules/core-js/library/modules/web.dom.iterable.js ***!
  \******************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ./es6.array.iterator */ 124);
var global = __webpack_require__(/*! ./_global */ 21);
var hide = __webpack_require__(/*! ./_hide */ 28);
var Iterators = __webpack_require__(/*! ./_iterators */ 63);
var TO_STRING_TAG = __webpack_require__(/*! ./_wks */ 36)('toStringTag');

var DOMIterables = ('CSSRuleList,CSSStyleDeclaration,CSSValueList,ClientRectList,DOMRectList,DOMStringList,' +
  'DOMTokenList,DataTransferItemList,FileList,HTMLAllCollection,HTMLCollection,HTMLFormElement,HTMLSelectElement,' +
  'MediaList,MimeTypeArray,NamedNodeMap,NodeList,PaintRequestList,Plugin,PluginArray,SVGLengthList,SVGNumberList,' +
  'SVGPathSegList,SVGPointList,SVGStringList,SVGTransformList,SourceBufferList,StyleSheetList,TextTrackCueList,' +
  'TextTrackList,TouchList').split(',');

for (var i = 0; i < DOMIterables.length; i++) {
  var NAME = DOMIterables[i];
  var Collection = global[NAME];
  var proto = Collection && Collection.prototype;
  if (proto && !proto[TO_STRING_TAG]) hide(proto, TO_STRING_TAG, NAME);
  Iterators[NAME] = Iterators.Array;
}


/***/ }),
/* 124 */
/*!********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.array.iterator.js ***!
  \********************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var addToUnscopables = __webpack_require__(/*! ./_add-to-unscopables */ 125);
var step = __webpack_require__(/*! ./_iter-step */ 126);
var Iterators = __webpack_require__(/*! ./_iterators */ 63);
var toIObject = __webpack_require__(/*! ./_to-iobject */ 24);

// 22.1.3.4 Array.prototype.entries()
// 22.1.3.13 Array.prototype.keys()
// 22.1.3.29 Array.prototype.values()
// 22.1.3.30 Array.prototype[@@iterator]()
module.exports = __webpack_require__(/*! ./_iter-define */ 88)(Array, 'Array', function (iterated, kind) {
  this._t = toIObject(iterated); // target
  this._i = 0;                   // next index
  this._k = kind;                // kind
// 22.1.5.2.1 %ArrayIteratorPrototype%.next()
}, function () {
  var O = this._t;
  var kind = this._k;
  var index = this._i++;
  if (!O || index >= O.length) {
    this._t = undefined;
    return step(1);
  }
  if (kind == 'keys') return step(0, index);
  if (kind == 'values') return step(0, O[index]);
  return step(0, [index, O[index]]);
}, 'values');

// argumentsList[@@iterator] is %ArrayProto_values% (9.4.4.6, 9.4.4.7)
Iterators.Arguments = Iterators.Array;

addToUnscopables('keys');
addToUnscopables('values');
addToUnscopables('entries');


/***/ }),
/* 125 */
/*!*********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_add-to-unscopables.js ***!
  \*********************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

module.exports = function () { /* empty */ };


/***/ }),
/* 126 */
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_iter-step.js ***!
  \************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

module.exports = function (done, value) {
  return { value: value, done: !!done };
};


/***/ }),
/* 127 */
/*!******************************************************!*\
  !*** ./node_modules/babel-runtime/core-js/symbol.js ***!
  \******************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(/*! core-js/library/fn/symbol */ 128), __esModule: true };

/***/ }),
/* 128 */
/*!*********************************************************!*\
  !*** ./node_modules/core-js/library/fn/symbol/index.js ***!
  \*********************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ../../modules/es6.symbol */ 129);
__webpack_require__(/*! ../../modules/es6.object.to-string */ 134);
__webpack_require__(/*! ../../modules/es7.symbol.async-iterator */ 135);
__webpack_require__(/*! ../../modules/es7.symbol.observable */ 136);
module.exports = __webpack_require__(/*! ../../modules/_core */ 22).Symbol;


/***/ }),
/* 129 */
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.symbol.js ***!
  \************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

// ECMAScript 6 symbols shim
var global = __webpack_require__(/*! ./_global */ 21);
var has = __webpack_require__(/*! ./_has */ 25);
var DESCRIPTORS = __webpack_require__(/*! ./_descriptors */ 23);
var $export = __webpack_require__(/*! ./_export */ 32);
var redefine = __webpack_require__(/*! ./_redefine */ 89);
var META = __webpack_require__(/*! ./_meta */ 130).KEY;
var $fails = __webpack_require__(/*! ./_fails */ 30);
var shared = __webpack_require__(/*! ./_shared */ 67);
var setToStringTag = __webpack_require__(/*! ./_set-to-string-tag */ 69);
var uid = __webpack_require__(/*! ./_uid */ 52);
var wks = __webpack_require__(/*! ./_wks */ 36);
var wksExt = __webpack_require__(/*! ./_wks-ext */ 70);
var wksDefine = __webpack_require__(/*! ./_wks-define */ 71);
var enumKeys = __webpack_require__(/*! ./_enum-keys */ 131);
var isArray = __webpack_require__(/*! ./_is-array */ 132);
var anObject = __webpack_require__(/*! ./_an-object */ 35);
var toIObject = __webpack_require__(/*! ./_to-iobject */ 24);
var toPrimitive = __webpack_require__(/*! ./_to-primitive */ 46);
var createDesc = __webpack_require__(/*! ./_property-desc */ 39);
var _create = __webpack_require__(/*! ./_object-create */ 64);
var gOPNExt = __webpack_require__(/*! ./_object-gopn-ext */ 133);
var $GOPD = __webpack_require__(/*! ./_object-gopd */ 50);
var $DP = __webpack_require__(/*! ./_object-dp */ 26);
var $keys = __webpack_require__(/*! ./_object-keys */ 65);
var gOPD = $GOPD.f;
var dP = $DP.f;
var gOPN = gOPNExt.f;
var $Symbol = global.Symbol;
var $JSON = global.JSON;
var _stringify = $JSON && $JSON.stringify;
var PROTOTYPE = 'prototype';
var HIDDEN = wks('_hidden');
var TO_PRIMITIVE = wks('toPrimitive');
var isEnum = {}.propertyIsEnumerable;
var SymbolRegistry = shared('symbol-registry');
var AllSymbols = shared('symbols');
var OPSymbols = shared('op-symbols');
var ObjectProto = Object[PROTOTYPE];
var USE_NATIVE = typeof $Symbol == 'function';
var QObject = global.QObject;
// Don't use setters in Qt Script, https://github.com/zloirock/core-js/issues/173
var setter = !QObject || !QObject[PROTOTYPE] || !QObject[PROTOTYPE].findChild;

// fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687
var setSymbolDesc = DESCRIPTORS && $fails(function () {
  return _create(dP({}, 'a', {
    get: function () { return dP(this, 'a', { value: 7 }).a; }
  })).a != 7;
}) ? function (it, key, D) {
  var protoDesc = gOPD(ObjectProto, key);
  if (protoDesc) delete ObjectProto[key];
  dP(it, key, D);
  if (protoDesc && it !== ObjectProto) dP(ObjectProto, key, protoDesc);
} : dP;

var wrap = function (tag) {
  var sym = AllSymbols[tag] = _create($Symbol[PROTOTYPE]);
  sym._k = tag;
  return sym;
};

var isSymbol = USE_NATIVE && typeof $Symbol.iterator == 'symbol' ? function (it) {
  return typeof it == 'symbol';
} : function (it) {
  return it instanceof $Symbol;
};

var $defineProperty = function defineProperty(it, key, D) {
  if (it === ObjectProto) $defineProperty(OPSymbols, key, D);
  anObject(it);
  key = toPrimitive(key, true);
  anObject(D);
  if (has(AllSymbols, key)) {
    if (!D.enumerable) {
      if (!has(it, HIDDEN)) dP(it, HIDDEN, createDesc(1, {}));
      it[HIDDEN][key] = true;
    } else {
      if (has(it, HIDDEN) && it[HIDDEN][key]) it[HIDDEN][key] = false;
      D = _create(D, { enumerable: createDesc(0, false) });
    } return setSymbolDesc(it, key, D);
  } return dP(it, key, D);
};
var $defineProperties = function defineProperties(it, P) {
  anObject(it);
  var keys = enumKeys(P = toIObject(P));
  var i = 0;
  var l = keys.length;
  var key;
  while (l > i) $defineProperty(it, key = keys[i++], P[key]);
  return it;
};
var $create = function create(it, P) {
  return P === undefined ? _create(it) : $defineProperties(_create(it), P);
};
var $propertyIsEnumerable = function propertyIsEnumerable(key) {
  var E = isEnum.call(this, key = toPrimitive(key, true));
  if (this === ObjectProto && has(AllSymbols, key) && !has(OPSymbols, key)) return false;
  return E || !has(this, key) || !has(AllSymbols, key) || has(this, HIDDEN) && this[HIDDEN][key] ? E : true;
};
var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(it, key) {
  it = toIObject(it);
  key = toPrimitive(key, true);
  if (it === ObjectProto && has(AllSymbols, key) && !has(OPSymbols, key)) return;
  var D = gOPD(it, key);
  if (D && has(AllSymbols, key) && !(has(it, HIDDEN) && it[HIDDEN][key])) D.enumerable = true;
  return D;
};
var $getOwnPropertyNames = function getOwnPropertyNames(it) {
  var names = gOPN(toIObject(it));
  var result = [];
  var i = 0;
  var key;
  while (names.length > i) {
    if (!has(AllSymbols, key = names[i++]) && key != HIDDEN && key != META) result.push(key);
  } return result;
};
var $getOwnPropertySymbols = function getOwnPropertySymbols(it) {
  var IS_OP = it === ObjectProto;
  var names = gOPN(IS_OP ? OPSymbols : toIObject(it));
  var result = [];
  var i = 0;
  var key;
  while (names.length > i) {
    if (has(AllSymbols, key = names[i++]) && (IS_OP ? has(ObjectProto, key) : true)) result.push(AllSymbols[key]);
  } return result;
};

// 19.4.1.1 Symbol([description])
if (!USE_NATIVE) {
  $Symbol = function Symbol() {
    if (this instanceof $Symbol) throw TypeError('Symbol is not a constructor!');
    var tag = uid(arguments.length > 0 ? arguments[0] : undefined);
    var $set = function (value) {
      if (this === ObjectProto) $set.call(OPSymbols, value);
      if (has(this, HIDDEN) && has(this[HIDDEN], tag)) this[HIDDEN][tag] = false;
      setSymbolDesc(this, tag, createDesc(1, value));
    };
    if (DESCRIPTORS && setter) setSymbolDesc(ObjectProto, tag, { configurable: true, set: $set });
    return wrap(tag);
  };
  redefine($Symbol[PROTOTYPE], 'toString', function toString() {
    return this._k;
  });

  $GOPD.f = $getOwnPropertyDescriptor;
  $DP.f = $defineProperty;
  __webpack_require__(/*! ./_object-gopn */ 92).f = gOPNExt.f = $getOwnPropertyNames;
  __webpack_require__(/*! ./_object-pie */ 51).f = $propertyIsEnumerable;
  __webpack_require__(/*! ./_object-gops */ 91).f = $getOwnPropertySymbols;

  if (DESCRIPTORS && !__webpack_require__(/*! ./_library */ 62)) {
    redefine(ObjectProto, 'propertyIsEnumerable', $propertyIsEnumerable, true);
  }

  wksExt.f = function (name) {
    return wrap(wks(name));
  };
}

$export($export.G + $export.W + $export.F * !USE_NATIVE, { Symbol: $Symbol });

for (var es6Symbols = (
  // 19.4.2.2, 19.4.2.3, 19.4.2.4, 19.4.2.6, 19.4.2.8, 19.4.2.9, 19.4.2.10, 19.4.2.11, 19.4.2.12, 19.4.2.13, 19.4.2.14
  'hasInstance,isConcatSpreadable,iterator,match,replace,search,species,split,toPrimitive,toStringTag,unscopables'
).split(','), j = 0; es6Symbols.length > j;)wks(es6Symbols[j++]);

for (var wellKnownSymbols = $keys(wks.store), k = 0; wellKnownSymbols.length > k;) wksDefine(wellKnownSymbols[k++]);

$export($export.S + $export.F * !USE_NATIVE, 'Symbol', {
  // 19.4.2.1 Symbol.for(key)
  'for': function (key) {
    return has(SymbolRegistry, key += '')
      ? SymbolRegistry[key]
      : SymbolRegistry[key] = $Symbol(key);
  },
  // 19.4.2.5 Symbol.keyFor(sym)
  keyFor: function keyFor(sym) {
    if (!isSymbol(sym)) throw TypeError(sym + ' is not a symbol!');
    for (var key in SymbolRegistry) if (SymbolRegistry[key] === sym) return key;
  },
  useSetter: function () { setter = true; },
  useSimple: function () { setter = false; }
});

$export($export.S + $export.F * !USE_NATIVE, 'Object', {
  // 19.1.2.2 Object.create(O [, Properties])
  create: $create,
  // 19.1.2.4 Object.defineProperty(O, P, Attributes)
  defineProperty: $defineProperty,
  // 19.1.2.3 Object.defineProperties(O, Properties)
  defineProperties: $defineProperties,
  // 19.1.2.6 Object.getOwnPropertyDescriptor(O, P)
  getOwnPropertyDescriptor: $getOwnPropertyDescriptor,
  // 19.1.2.7 Object.getOwnPropertyNames(O)
  getOwnPropertyNames: $getOwnPropertyNames,
  // 19.1.2.8 Object.getOwnPropertySymbols(O)
  getOwnPropertySymbols: $getOwnPropertySymbols
});

// 24.3.2 JSON.stringify(value [, replacer [, space]])
$JSON && $export($export.S + $export.F * (!USE_NATIVE || $fails(function () {
  var S = $Symbol();
  // MS Edge converts symbol values to JSON as {}
  // WebKit converts symbol values to JSON as null
  // V8 throws on boxed symbols
  return _stringify([S]) != '[null]' || _stringify({ a: S }) != '{}' || _stringify(Object(S)) != '{}';
})), 'JSON', {
  stringify: function stringify(it) {
    if (it === undefined || isSymbol(it)) return; // IE8 returns string on undefined
    var args = [it];
    var i = 1;
    var replacer, $replacer;
    while (arguments.length > i) args.push(arguments[i++]);
    replacer = args[1];
    if (typeof replacer == 'function') $replacer = replacer;
    if ($replacer || !isArray(replacer)) replacer = function (key, value) {
      if ($replacer) value = $replacer.call(this, key, value);
      if (!isSymbol(value)) return value;
    };
    args[1] = replacer;
    return _stringify.apply($JSON, args);
  }
});

// 19.4.3.4 Symbol.prototype[@@toPrimitive](hint)
$Symbol[PROTOTYPE][TO_PRIMITIVE] || __webpack_require__(/*! ./_hide */ 28)($Symbol[PROTOTYPE], TO_PRIMITIVE, $Symbol[PROTOTYPE].valueOf);
// 19.4.3.5 Symbol.prototype[@@toStringTag]
setToStringTag($Symbol, 'Symbol');
// 20.2.1.9 Math[@@toStringTag]
setToStringTag(Math, 'Math', true);
// 24.3.3 JSON[@@toStringTag]
setToStringTag(global.JSON, 'JSON', true);


/***/ }),
/* 130 */
/*!*******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_meta.js ***!
  \*******************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

var META = __webpack_require__(/*! ./_uid */ 52)('meta');
var isObject = __webpack_require__(/*! ./_is-object */ 29);
var has = __webpack_require__(/*! ./_has */ 25);
var setDesc = __webpack_require__(/*! ./_object-dp */ 26).f;
var id = 0;
var isExtensible = Object.isExtensible || function () {
  return true;
};
var FREEZE = !__webpack_require__(/*! ./_fails */ 30)(function () {
  return isExtensible(Object.preventExtensions({}));
});
var setMeta = function (it) {
  setDesc(it, META, { value: {
    i: 'O' + ++id, // object ID
    w: {}          // weak collections IDs
  } });
};
var fastKey = function (it, create) {
  // return primitive with prefix
  if (!isObject(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
  if (!has(it, META)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible(it)) return 'F';
    // not necessary to add metadata
    if (!create) return 'E';
    // add missing metadata
    setMeta(it);
  // return object ID
  } return it[META].i;
};
var getWeak = function (it, create) {
  if (!has(it, META)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible(it)) return true;
    // not necessary to add metadata
    if (!create) return false;
    // add missing metadata
    setMeta(it);
  // return hash weak collections IDs
  } return it[META].w;
};
// add metadata on freeze-family methods calling
var onFreeze = function (it) {
  if (FREEZE && meta.NEED && isExtensible(it) && !has(it, META)) setMeta(it);
  return it;
};
var meta = module.exports = {
  KEY: META,
  NEED: false,
  fastKey: fastKey,
  getWeak: getWeak,
  onFreeze: onFreeze
};


/***/ }),
/* 131 */
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_enum-keys.js ***!
  \************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

// all enumerable object keys, includes symbols
var getKeys = __webpack_require__(/*! ./_object-keys */ 65);
var gOPS = __webpack_require__(/*! ./_object-gops */ 91);
var pIE = __webpack_require__(/*! ./_object-pie */ 51);
module.exports = function (it) {
  var result = getKeys(it);
  var getSymbols = gOPS.f;
  if (getSymbols) {
    var symbols = getSymbols(it);
    var isEnum = pIE.f;
    var i = 0;
    var key;
    while (symbols.length > i) if (isEnum.call(it, key = symbols[i++])) result.push(key);
  } return result;
};


/***/ }),
/* 132 */
/*!***********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_is-array.js ***!
  \***********************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

// 7.2.2 IsArray(argument)
var cof = __webpack_require__(/*! ./_cof */ 60);
module.exports = Array.isArray || function isArray(arg) {
  return cof(arg) == 'Array';
};


/***/ }),
/* 133 */
/*!******************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-gopn-ext.js ***!
  \******************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

// fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window
var toIObject = __webpack_require__(/*! ./_to-iobject */ 24);
var gOPN = __webpack_require__(/*! ./_object-gopn */ 92).f;
var toString = {}.toString;

var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames
  ? Object.getOwnPropertyNames(window) : [];

var getWindowNames = function (it) {
  try {
    return gOPN(it);
  } catch (e) {
    return windowNames.slice();
  }
};

module.exports.f = function getOwnPropertyNames(it) {
  return windowNames && toString.call(it) == '[object Window]' ? getWindowNames(it) : gOPN(toIObject(it));
};


/***/ }),
/* 134 */
/*!**********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.object.to-string.js ***!
  \**********************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {



/***/ }),
/* 135 */
/*!***************************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es7.symbol.async-iterator.js ***!
  \***************************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ./_wks-define */ 71)('asyncIterator');


/***/ }),
/* 136 */
/*!***********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es7.symbol.observable.js ***!
  \***********************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ./_wks-define */ 71)('observable');


/***/ }),
/* 137 */
/*!***********************************************************************!*\
  !*** ./node_modules/babel-runtime/core-js/object/set-prototype-of.js ***!
  \***********************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(/*! core-js/library/fn/object/set-prototype-of */ 138), __esModule: true };

/***/ }),
/* 138 */
/*!********************************************************************!*\
  !*** ./node_modules/core-js/library/fn/object/set-prototype-of.js ***!
  \********************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ../../modules/es6.object.set-prototype-of */ 139);
module.exports = __webpack_require__(/*! ../../modules/_core */ 22).Object.setPrototypeOf;


/***/ }),
/* 139 */
/*!*****************************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.object.set-prototype-of.js ***!
  \*****************************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.3.19 Object.setPrototypeOf(O, proto)
var $export = __webpack_require__(/*! ./_export */ 32);
$export($export.S, 'Object', { setPrototypeOf: __webpack_require__(/*! ./_set-proto */ 140).set });


/***/ }),
/* 140 */
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_set-proto.js ***!
  \************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

// Works with __proto__ only. Old v8 can't work with null proto objects.
/* eslint-disable no-proto */
var isObject = __webpack_require__(/*! ./_is-object */ 29);
var anObject = __webpack_require__(/*! ./_an-object */ 35);
var check = function (O, proto) {
  anObject(O);
  if (!isObject(proto) && proto !== null) throw TypeError(proto + ": can't set as prototype!");
};
module.exports = {
  set: Object.setPrototypeOf || ('__proto__' in {} ? // eslint-disable-line
    function (test, buggy, set) {
      try {
        set = __webpack_require__(/*! ./_ctx */ 58)(Function.call, __webpack_require__(/*! ./_object-gopd */ 50).f(Object.prototype, '__proto__').set, 2);
        set(test, []);
        buggy = !(test instanceof Array);
      } catch (e) { buggy = true; }
      return function setPrototypeOf(O, proto) {
        check(O, proto);
        if (buggy) O.__proto__ = proto;
        else set(O, proto);
        return O;
      };
    }({}, false) : undefined),
  check: check
};


/***/ }),
/* 141 */
/*!*************************************************************!*\
  !*** ./node_modules/babel-runtime/core-js/object/create.js ***!
  \*************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(/*! core-js/library/fn/object/create */ 142), __esModule: true };

/***/ }),
/* 142 */
/*!**********************************************************!*\
  !*** ./node_modules/core-js/library/fn/object/create.js ***!
  \**********************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ../../modules/es6.object.create */ 143);
var $Object = __webpack_require__(/*! ../../modules/_core */ 22).Object;
module.exports = function create(P, D) {
  return $Object.create(P, D);
};


/***/ }),
/* 143 */
/*!*******************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.object.create.js ***!
  \*******************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

var $export = __webpack_require__(/*! ./_export */ 32);
// 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])
$export($export.S, 'Object', { create: __webpack_require__(/*! ./_object-create */ 64) });


/***/ }),
/* 144 */
/*!***********************************!*\
  !*** ./dev/Stores/AbstractApp.js ***!
  \***********************************/
/*! exports provided: AbstractAppStore, default */
/*! exports used: AbstractAppStore */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AbstractAppStore; });
/* unused harmony export default */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);






var AbstractAppStore = function () {
	function AbstractAppStore() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, AbstractAppStore);

		this.allowLanguagesOnSettings = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(true);
		this.allowLanguagesOnLogin = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(true);
		this.newMoveToFolder = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(true);

		this.interfaceAnimation = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(true);

		this.interfaceAnimation.subscribe(function (value) {
			var anim = __WEBPACK_IMPORTED_MODULE_2_Common_Globals__["bMobileDevice"] || !value;
			__WEBPACK_IMPORTED_MODULE_2_Common_Globals__["$html"].toggleClass('rl-anim', !anim).toggleClass('no-rl-anim', anim);
		});

		this.interfaceAnimation.valueHasMutated();

		this.prem = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(false);
		this.community = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(true);
	}

	AbstractAppStore.prototype.populate = function populate() {
		this.allowLanguagesOnLogin(!!__WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('AllowLanguagesOnLogin'));
		this.allowLanguagesOnSettings(!!__WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('AllowLanguagesOnSettings'));
		this.newMoveToFolder(!!__WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('NewMoveToFolder'));

		this.interfaceAnimation(!!__WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('InterfaceAnimation'));

		this.prem(!!__WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('PremType'));
		this.community(!!__WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('Community'));
	};

	return AbstractAppStore;
}();



/***/ }),
/* 145 */
/*!*****************************************!*\
  !*** ./dev/Stores/User/Notification.js ***!
  \*****************************************/
/*! exports provided: default */
/*! exports used: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Events__ = __webpack_require__(/*! Common/Events */ 37);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Audio__ = __webpack_require__(/*! Common/Audio */ 146);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);











var NotificationUserStore = function () {
	function NotificationUserStore() {
		var _this = this;

		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, NotificationUserStore);

		this.enableSoundNotification = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(false);
		this.soundNotificationIsSupported = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(false);

		this.allowDesktopNotification = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(false);

		this.desktopNotificationPermissions = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].computed(function () {

			_this.allowDesktopNotification();

			var result = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["DesktopNotification"].NotSupported;

			var NotificationClass = _this.notificationClass();
			if (NotificationClass && NotificationClass.permission) {
				switch (NotificationClass.permission.toLowerCase()) {
					case 'granted':
						result = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["DesktopNotification"].Allowed;
						break;
					case 'denied':
						result = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["DesktopNotification"].Denied;
						break;
					case 'default':
						result = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["DesktopNotification"].NotAllowed;
						break;
					// no default
				}
			} else if (__WEBPACK_IMPORTED_MODULE_1_window___default.a.webkitNotifications && __WEBPACK_IMPORTED_MODULE_1_window___default.a.webkitNotifications.checkPermission) {
				result = __WEBPACK_IMPORTED_MODULE_1_window___default.a.webkitNotifications.checkPermission();
			}

			return result;
		}).extend({ notify: 'always' });

		this.enableDesktopNotification = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].computed({
			read: function read() {
				return _this.allowDesktopNotification() && __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["DesktopNotification"].Allowed === _this.desktopNotificationPermissions();
			},
			write: function write(value) {
				if (value) {
					var NotificationClass = _this.notificationClass(),
					    permission = _this.desktopNotificationPermissions();

					if (NotificationClass && __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["DesktopNotification"].Allowed === permission) {
						_this.allowDesktopNotification(true);
					} else if (NotificationClass && __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["DesktopNotification"].NotAllowed === permission) {
						NotificationClass.requestPermission(function () {

							_this.allowDesktopNotification.valueHasMutated();

							if (__WEBPACK_IMPORTED_MODULE_3_Common_Enums__["DesktopNotification"].Allowed === _this.desktopNotificationPermissions()) {
								if (_this.allowDesktopNotification()) {
									_this.allowDesktopNotification.valueHasMutated();
								} else {
									_this.allowDesktopNotification(true);
								}
							} else {
								if (_this.allowDesktopNotification()) {
									_this.allowDesktopNotification(false);
								} else {
									_this.allowDesktopNotification.valueHasMutated();
								}
							}
						});
					} else {
						_this.allowDesktopNotification(false);
					}
				} else {
					_this.allowDesktopNotification(false);
				}
			}
		}).extend({ notify: 'always' });

		if (!this.enableDesktopNotification.valueHasMutated) {
			this.enableDesktopNotification.valueHasMutated = function () {
				_this.allowDesktopNotification.valueHasMutated();
			};
		}

		this.computers();

		this.initNotificationPlayer();
	}

	NotificationUserStore.prototype.computers = function computers() {
		var _this2 = this;

		this.isDesktopNotificationSupported = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].computed(function () {
			return __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["DesktopNotification"].NotSupported !== _this2.desktopNotificationPermissions();
		});

		this.isDesktopNotificationDenied = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].computed(function () {
			return __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["DesktopNotification"].NotSupported === _this2.desktopNotificationPermissions() || __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["DesktopNotification"].Denied === _this2.desktopNotificationPermissions();
		});
	};

	NotificationUserStore.prototype.initNotificationPlayer = function initNotificationPlayer() {
		if (__WEBPACK_IMPORTED_MODULE_5_Common_Audio__["a" /* default */] && __WEBPACK_IMPORTED_MODULE_5_Common_Audio__["a" /* default */].supportedNotification) {
			this.soundNotificationIsSupported(true);
		} else {
			this.enableSoundNotification(false);
			this.soundNotificationIsSupported(false);
		}
	};

	NotificationUserStore.prototype.playSoundNotification = function playSoundNotification(skipSetting) {
		if (__WEBPACK_IMPORTED_MODULE_5_Common_Audio__["a" /* default */] && __WEBPACK_IMPORTED_MODULE_5_Common_Audio__["a" /* default */].supportedNotification && (skipSetting ? true : this.enableSoundNotification())) {
			__WEBPACK_IMPORTED_MODULE_5_Common_Audio__["a" /* default */].playNotification();
		}
	};

	NotificationUserStore.prototype.displayDesktopNotification = function displayDesktopNotification(imageSrc, title, text, nessageData) {
		if (this.enableDesktopNotification()) {
			var NotificationClass = this.notificationClass(),
			    notification = NotificationClass ? new NotificationClass(title, {
				body: text,
				icon: imageSrc
			}) : null;

			if (notification) {
				if (notification.show) {
					notification.show();
				}

				if (nessageData) {
					notification.onclick = function () {

						__WEBPACK_IMPORTED_MODULE_1_window___default.a.focus();

						if (nessageData.Folder && nessageData.Uid) {
							__WEBPACK_IMPORTED_MODULE_4_Common_Events__["a" /* pub */]('mailbox.message.show', [nessageData.Folder, nessageData.Uid]);
						}
					};
				}

				__WEBPACK_IMPORTED_MODULE_1_window___default.a.setTimeout(function (localNotifications) {
					return function () {
						if (localNotifications.cancel) {
							localNotifications.cancel();
						} else if (localNotifications.close) {
							localNotifications.close();
						}
					};
				}(notification), __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["Magics"].Time7s);
			}
		}
	};

	NotificationUserStore.prototype.populate = function populate() {
		this.enableSoundNotification(!!__WEBPACK_IMPORTED_MODULE_6_Storage_Settings__["settingsGet"]('SoundNotification'));
		this.enableDesktopNotification(!!__WEBPACK_IMPORTED_MODULE_6_Storage_Settings__["settingsGet"]('DesktopNotifications'));
	};

	/**
  * @returns {*|null}
  */


	NotificationUserStore.prototype.notificationClass = function notificationClass() {
		return __WEBPACK_IMPORTED_MODULE_1_window___default.a.Notification && __WEBPACK_IMPORTED_MODULE_1_window___default.a.Notification.requestPermission ? __WEBPACK_IMPORTED_MODULE_1_window___default.a.Notification : null;
	};

	return NotificationUserStore;
}();

/* harmony default export */ __webpack_exports__["a"] = (new NotificationUserStore());

/***/ }),
/* 146 */
/*!*****************************!*\
  !*** ./dev/Common/Audio.js ***!
  \*****************************/
/*! exports provided: default */
/*! exports used: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Links__ = __webpack_require__(/*! Common/Links */ 14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Events__ = __webpack_require__(/*! Common/Events */ 37);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);








var Audio = function () {
	function Audio() {
		var _this = this;

		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, Audio);

		this.notificator = null;
		this.player = null;
		this.supported = false;
		this.supportedMp3 = false;
		this.supportedOgg = false;
		this.supportedWav = false;
		this.supportedNotification = false;

		this.player = this.createNewObject();

		this.supported = !__WEBPACK_IMPORTED_MODULE_2_Common_Globals__["bMobileDevice"] && !__WEBPACK_IMPORTED_MODULE_2_Common_Globals__["bSafari"] && !!this.player && !!this.player.play;
		if (this.supported && this.player && this.player.canPlayType) {
			this.supportedMp3 = '' !== this.player.canPlayType('audio/mpeg;').replace(/no/, '');
			this.supportedWav = '' !== this.player.canPlayType('audio/wav; codecs="1"').replace(/no/, '');
			this.supportedOgg = '' !== this.player.canPlayType('audio/ogg; codecs="vorbis"').replace(/no/, '');
			this.supportedNotification = this.supported && this.supportedMp3;
		}

		if (!this.player || !this.supportedMp3 && !this.supportedOgg && !this.supportedWav) {
			this.supported = false;
			this.supportedMp3 = false;
			this.supportedOgg = false;
			this.supportedWav = false;
			this.supportedNotification = false;
		}

		if (this.supported && this.player) {
			var stopFn = function stopFn() {
				return _this.stop();
			};

			this.player.addEventListener('ended', stopFn);
			this.player.addEventListener('error', stopFn);

			__WEBPACK_IMPORTED_MODULE_4_Common_Events__["b" /* sub */]('audio.api.stop', stopFn);
		}
	}

	Audio.prototype.createNewObject = function createNewObject() {
		var player = __WEBPACK_IMPORTED_MODULE_1_window___default.a.Audio ? new __WEBPACK_IMPORTED_MODULE_1_window___default.a.Audio() : null;
		if (player && player.canPlayType && player.pause && player.play) {
			player.preload = 'none';
			player.loop = false;
			player.autoplay = false;
			player.muted = false;
		}

		return player;
	};

	Audio.prototype.paused = function paused() {
		return this.supported ? !!this.player.paused : true;
	};

	Audio.prototype.stop = function stop() {
		if (this.supported && this.player.pause) {
			this.player.pause();
		}

		__WEBPACK_IMPORTED_MODULE_4_Common_Events__["a" /* pub */]('audio.stop');
	};

	Audio.prototype.pause = function pause() {
		this.stop();
	};

	Audio.prototype.clearName = function clearName() {
		var name = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
		var ext = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';


		name = Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["trim"])(name);
		if (ext && '.' + ext === name.toLowerCase().substr((ext.length + 1) * -1)) {
			name = Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["trim"])(name.substr(0, name.length - 4));
		}

		return '' === name ? 'audio' : name;
	};

	Audio.prototype.playMp3 = function playMp3(url, name) {
		if (this.supported && this.supportedMp3) {
			this.player.src = url;
			this.player.play();

			__WEBPACK_IMPORTED_MODULE_4_Common_Events__["a" /* pub */]('audio.start', [this.clearName(name, 'mp3'), 'mp3']);
		}
	};

	Audio.prototype.playOgg = function playOgg(url, name) {
		if (this.supported && this.supportedOgg) {
			this.player.src = url;
			this.player.play();

			name = this.clearName(name, 'oga');
			name = this.clearName(name, 'ogg');

			__WEBPACK_IMPORTED_MODULE_4_Common_Events__["a" /* pub */]('audio.start', [name, 'ogg']);
		}
	};

	Audio.prototype.playWav = function playWav(url, name) {
		if (this.supported && this.supportedWav) {
			this.player.src = url;
			this.player.play();

			__WEBPACK_IMPORTED_MODULE_4_Common_Events__["a" /* pub */]('audio.start', [this.clearName(name, 'wav'), 'wav']);
		}
	};

	Audio.prototype.playNotification = function playNotification() {
		if (this.supported && this.supportedMp3) {
			if (!this.notificator) {
				this.notificator = this.createNewObject();
				this.notificator.src = __WEBPACK_IMPORTED_MODULE_3_Common_Links__["D" /* sound */]('new-mail.mp3');
			}

			if (this.notificator && this.notificator.play) {
				this.notificator.play();
			}
		}
	};

	return Audio;
}();

/* harmony default export */ __webpack_exports__["a"] = (new Audio());

/***/ }),
/* 147 */
/*!************************************!*\
  !*** ./dev/Stores/User/Contact.js ***!
  \************************************/
/*! exports provided: default */
/*! exports used: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);






var ContactUserStore = function () {
	function ContactUserStore() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, ContactUserStore);

		this.contacts = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observableArray([]);
		this.contacts.loading = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(false).extend({ throttle: __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["Magics"].Time200ms });
		this.contacts.importing = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(false).extend({ throttle: __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["Magics"].Time200ms });
		this.contacts.syncing = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(false).extend({ throttle: __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["Magics"].Time200ms });
		this.contacts.exportingVcf = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(false).extend({ throttle: __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["Magics"].Time200ms });
		this.contacts.exportingCsv = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(false).extend({ throttle: __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["Magics"].Time200ms });

		this.allowContactsSync = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(false);
		this.enableContactsSync = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(false);
		this.contactsSyncUrl = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable('');
		this.contactsSyncUser = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable('');
		this.contactsSyncPass = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable('');
	}

	ContactUserStore.prototype.populate = function populate() {
		this.allowContactsSync(!!__WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('ContactsSyncIsAllowed'));
		this.enableContactsSync(!!__WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('EnableContactsSync'));

		this.contactsSyncUrl(__WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('ContactsSyncUrl'));
		this.contactsSyncUser(__WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('ContactsSyncUser'));
		this.contactsSyncPass(__WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('ContactsSyncPassword'));
	};

	return ContactUserStore;
}();

/* harmony default export */ __webpack_exports__["a"] = (new ContactUserStore());

/***/ }),
/* 148 */
/*!************************************!*\
  !*** ./dev/Remote/AbstractAjax.js ***!
  \************************************/
/*! exports provided: AbstractAjaxRemote, default */
/*! exports used: AbstractAjaxRemote */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AbstractAjaxRemote; });
/* unused harmony export default */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3____ = __webpack_require__(/*! $ */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Consts__ = __webpack_require__(/*! Common/Consts */ 20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Common_Links__ = __webpack_require__(/*! Common/Links */ 14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Common_Plugins__ = __webpack_require__(/*! Common/Plugins */ 33);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);















var AbstractAjaxRemote = function () {
	function AbstractAjaxRemote() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, AbstractAjaxRemote);

		this.oRequests = {};
	}

	/**
  * @param {?Function} fCallback
  * @param {string} sRequestAction
  * @param {string} sType
  * @param {?AjaxJsonDefaultResponse} oData
  * @param {boolean} bCached
  * @param {*=} oRequestParameters
  */


	AbstractAjaxRemote.prototype.defaultResponse = function defaultResponse(fCallback, sRequestAction, sType, oData, bCached, oRequestParameters) {
		var fCall = function fCall() {
			if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["StorageResultType"].Success !== sType && __WEBPACK_IMPORTED_MODULE_7_Common_Globals__["data"].bUnload) {
				sType = __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["StorageResultType"].Unload;
			}

			if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["StorageResultType"].Success === sType && oData && !oData.Result) {
				if (oData && -1 < Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["inArray"])(oData.ErrorCode, [__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Notification"].AuthError, __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Notification"].AccessError, __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Notification"].ConnectionError, __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Notification"].DomainNotAllowed, __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Notification"].AccountNotAllowed, __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Notification"].MailServerError, __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Notification"].UnknownNotification, __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Notification"].UnknownError])) {
					__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["data"].iAjaxErrorCount += 1;
				}

				if (oData && __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Notification"].InvalidToken === oData.ErrorCode) {
					__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["data"].iTokenErrorCount += 1;
				}

				if (__WEBPACK_IMPORTED_MODULE_4_Common_Consts__["q" /* TOKEN_ERROR_LIMIT */] < __WEBPACK_IMPORTED_MODULE_7_Common_Globals__["data"].iTokenErrorCount) {
					if (__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["data"].__APP__ && __WEBPACK_IMPORTED_MODULE_7_Common_Globals__["data"].__APP__.loginAndLogoutReload) {
						__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["data"].__APP__.loginAndLogoutReload(false, true);
					}
				}

				if (oData.ClearAuth || oData.Logout || __WEBPACK_IMPORTED_MODULE_4_Common_Consts__["a" /* AJAX_ERROR_LIMIT */] < __WEBPACK_IMPORTED_MODULE_7_Common_Globals__["data"].iAjaxErrorCount) {
					if (__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["data"].__APP__ && __WEBPACK_IMPORTED_MODULE_7_Common_Globals__["data"].__APP__.clearClientSideToken) {
						__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["data"].__APP__.clearClientSideToken();

						if (!oData.ClearAuth && __WEBPACK_IMPORTED_MODULE_7_Common_Globals__["data"].__APP__.loginAndLogoutReload) {
							__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["data"].__APP__.loginAndLogoutReload(false, true);
						}
					}
				}
			} else if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["StorageResultType"].Success === sType && oData && oData.Result) {
				__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["data"].iAjaxErrorCount = 0;
				__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["data"].iTokenErrorCount = 0;
			}

			Object(__WEBPACK_IMPORTED_MODULE_9_Common_Plugins__["f" /* runHook */])('ajax-default-response', [sRequestAction, __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["StorageResultType"].Success === sType ? oData : null, sType, bCached, oRequestParameters]);

			if (fCallback) {
				fCallback(sType, __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["StorageResultType"].Success === sType ? oData : null, bCached, sRequestAction, oRequestParameters);
			}
		};

		switch (sType) {
			case 'success':
				sType = __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["StorageResultType"].Success;
				break;
			case 'abort':
				sType = __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["StorageResultType"].Abort;
				break;
			default:
				sType = __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["StorageResultType"].Error;
				break;
		}

		if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["StorageResultType"].Error === sType) {
			__WEBPACK_IMPORTED_MODULE_2_____default.a.delay(fCall, 300);
		} else {
			fCall();
		}
	};

	/**
  * @param {?Function} fResultCallback
  * @param {Object} oParameters
  * @param {?number=} iTimeOut = 20000
  * @param {string=} sGetAdd = ''
  * @param {Array=} aAbortActions = []
  * @returns {jQuery.jqXHR}
  */


	AbstractAjaxRemote.prototype.ajaxRequest = function ajaxRequest(fResultCallback, params) {
		var iTimeOut = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 20000;

		var _this = this;

		var sGetAdd = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';
		var abortActions = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : [];

		var isPost = '' === sGetAdd,
		    headers = {},
		    start = new __WEBPACK_IMPORTED_MODULE_1_window___default.a.Date().getTime();

		var action = '';

		params = params || {};
		action = params.Action || '';

		if (action && 0 < abortActions.length) {
			__WEBPACK_IMPORTED_MODULE_2_____default.a.each(abortActions, function (actionToAbort) {
				if (_this.oRequests[actionToAbort]) {
					_this.oRequests[actionToAbort].__aborted = true;
					if (_this.oRequests[actionToAbort].abort) {
						_this.oRequests[actionToAbort].abort();
					}
					_this.oRequests[actionToAbort] = null;
				}
			});
		}

		if (isPost) {
			params.XToken = __WEBPACK_IMPORTED_MODULE_10_Storage_Settings__["appSettingsGet"]('token');
		}

		var oDefAjax = __WEBPACK_IMPORTED_MODULE_3_____default.a.ajax({
			type: isPost ? 'POST' : 'GET',
			url: Object(__WEBPACK_IMPORTED_MODULE_8_Common_Links__["a" /* ajax */])(sGetAdd),
			async: true,
			dataType: 'json',
			data: isPost ? params : {},
			headers: headers,
			timeout: iTimeOut,
			global: true
		});

		oDefAjax.always(function (oData, sType) {

			var cached = false;
			if (oData && oData.Time) {
				cached = Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["pInt"])(oData.Time) > new __WEBPACK_IMPORTED_MODULE_1_window___default.a.Date().getTime() - start;
			}

			if (action && _this.oRequests[action]) {
				if (_this.oRequests[action].__aborted) {
					sType = 'abort';
				}

				_this.oRequests[action] = null;
			}

			_this.defaultResponse(fResultCallback, action, sType, oData, cached, params);
		});

		if (action && 0 < abortActions.length && -1 < Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["inArray"])(action, abortActions)) {
			if (this.oRequests[action]) {
				this.oRequests[action].__aborted = true;
				if (this.oRequests[action].abort) {
					this.oRequests[action].abort();
				}
				this.oRequests[action] = null;
			}

			this.oRequests[action] = oDefAjax;
		}

		return oDefAjax;
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sAction
  * @param {Object=} oParameters
  * @param {?number=} iTimeout
  * @param {string=} sGetAdd = ''
  * @param {Array=} aAbortActions = []
  */


	AbstractAjaxRemote.prototype.defaultRequest = function defaultRequest(fCallback, sAction, oParameters, iTimeout, sGetAdd, aAbortActions) {
		oParameters = oParameters || {};
		oParameters.Action = sAction;

		sGetAdd = Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["pString"])(sGetAdd);

		Object(__WEBPACK_IMPORTED_MODULE_9_Common_Plugins__["f" /* runHook */])('ajax-default-request', [sAction, oParameters, sGetAdd]);

		return this.ajaxRequest(fCallback, oParameters, Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["isUnd"])(iTimeout) ? __WEBPACK_IMPORTED_MODULE_4_Common_Consts__["g" /* DEFAULT_AJAX_TIMEOUT */] : Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["pInt"])(iTimeout), sGetAdd, aAbortActions);
	};

	/**
  * @param {?Function} fCallback
  */


	AbstractAjaxRemote.prototype.noop = function noop(fCallback) {
		this.defaultRequest(fCallback, 'Noop');
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sMessage
  * @param {string} sFileName
  * @param {number} iLineNo
  * @param {string} sLocation
  * @param {string} sHtmlCapa
  * @param {number} iTime
  */


	AbstractAjaxRemote.prototype.jsError = function jsError(fCallback, sMessage, sFileName, iLineNo, sLocation, sHtmlCapa, iTime) {
		this.defaultRequest(fCallback, 'JsError', {
			'Message': sMessage,
			'FileName': sFileName,
			'LineNo': iLineNo,
			'Location': sLocation,
			'HtmlCapa': sHtmlCapa,
			'TimeOnPage': iTime
		});
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sType
  * @param {Array=} mData = null
  * @param {boolean=} bIsError = false
  */


	AbstractAjaxRemote.prototype.jsInfo = function jsInfo(fCallback, sType, mData) {
		var bIsError = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

		this.defaultRequest(fCallback, 'JsInfo', {
			'Type': sType,
			'Data': mData,
			'IsError': bIsError ? '1' : '0'
		});
	};

	/**
  * @param {?Function} fCallback
  */


	AbstractAjaxRemote.prototype.getPublicKey = function getPublicKey(fCallback) {
		this.defaultRequest(fCallback, 'GetPublicKey');
	};

	/**
  * @param {?Function} fCallback
  * @param {string} sVersion
  */


	AbstractAjaxRemote.prototype.jsVersion = function jsVersion(fCallback, sVersion) {
		this.defaultRequest(fCallback, 'Version', {
			'Version': sVersion
		});
	};

	return AbstractAjaxRemote;
}();



/***/ }),
/* 149 */
/*!***********************************!*\
  !*** ./dev/View/Popup/Account.js ***!
  \***********************************/
/*! exports provided: AccountPopupView, default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AccountPopupView", function() { return AccountPopupView; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return AccountPopupView; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor__ = __webpack_require__(/*! babel-runtime/core-js/object/get-own-property-descriptor */ 15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Remote_User_Ajax__ = __webpack_require__(/*! Remote/User/Ajax */ 17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Helper_Apps_User__ = __webpack_require__(/*! Helper/Apps/User */ 16);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_Knoin_AbstractViewNext__ = __webpack_require__(/*! Knoin/AbstractViewNext */ 13);





var _dec, _dec2, _class, _desc, _value, _class2;

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
	var desc = {};
	Object['ke' + 'ys'](descriptor).forEach(function (key) {
		desc[key] = descriptor[key];
	});
	desc.enumerable = !!desc.enumerable;
	desc.configurable = !!desc.configurable;

	if ('value' in desc || desc.initializer) {
		desc.writable = true;
	}

	desc = decorators.slice().reverse().reduce(function (desc, decorator) {
		return decorator(target, property, desc) || desc;
	}, desc);

	if (context && desc.initializer !== void 0) {
		desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
		desc.initializer = undefined;
	}

	if (desc.initializer === void 0) {
		Object['define' + 'Property'](target, property, desc);
		desc = null;
	}

	return desc;
}














var AccountPopupView = (_dec = Object(__WEBPACK_IMPORTED_MODULE_10_Knoin_Knoin__["popup"])({
	name: 'View/Popup/Account',
	templateID: 'PopupsAccount'
}), _dec2 = Object(__WEBPACK_IMPORTED_MODULE_10_Knoin_Knoin__["command"])(function (self) {
	return !self.submitRequest();
}), _dec(_class = (_class2 = function (_AbstractViewNext) {
	__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits___default()(AccountPopupView, _AbstractViewNext);

	function AccountPopupView() {
		__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default()(this, AccountPopupView);

		var _this = __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractViewNext.call(this));

		_this.isNew = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(true);

		_this.email = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable('');
		_this.password = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable('');

		_this.emailError = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);
		_this.passwordError = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);

		_this.email.subscribe(function () {
			_this.emailError(false);
		});

		_this.password.subscribe(function () {
			_this.passwordError(false);
		});

		_this.submitRequest = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);
		_this.submitError = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable('');
		_this.submitErrorAdditional = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable('');

		_this.emailFocus = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);
		return _this;
	}

	AccountPopupView.prototype.addAccountCommand = function addAccountCommand() {
		var _this2 = this;

		this.emailError('' === Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["trim"])(this.email()));
		this.passwordError('' === Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["trim"])(this.password()));

		if (this.emailError() || this.passwordError()) {
			return false;
		}

		this.submitRequest(true);

		__WEBPACK_IMPORTED_MODULE_8_Remote_User_Ajax__["a" /* default */].accountSetup(function (result, data) {

			_this2.submitRequest(false);
			if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["StorageResultType"].Success === result && data) {
				if (data.Result) {
					Object(__WEBPACK_IMPORTED_MODULE_9_Helper_Apps_User__["a" /* getApp */])().accountsAndIdentities();
					_this2.cancelCommand();
				} else {
					_this2.submitError(data.ErrorCode ? Object(__WEBPACK_IMPORTED_MODULE_7_Common_Translator__["getNotification"])(data.ErrorCode) : Object(__WEBPACK_IMPORTED_MODULE_7_Common_Translator__["getNotification"])(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Notification"].UnknownError));

					if (data.ErrorMessageAdditional) {
						_this2.submitErrorAdditional(data.ErrorMessageAdditional);
					}
				}
			} else {
				_this2.submitError(Object(__WEBPACK_IMPORTED_MODULE_7_Common_Translator__["getNotification"])(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Notification"].UnknownError));
				_this2.submitErrorAdditional('');
			}
		}, this.email(), this.password(), this.isNew());

		return true;
	};

	AccountPopupView.prototype.clearPopup = function clearPopup() {
		this.isNew(true);

		this.email('');
		this.password('');

		this.emailError(false);
		this.passwordError(false);

		this.submitRequest(false);
		this.submitError('');
		this.submitErrorAdditional('');
	};

	AccountPopupView.prototype.onShow = function onShow(account) {
		this.clearPopup();
		if (account && account.canBeEdit()) {
			this.isNew(false);
			this.email(account.email);
		}
	};

	AccountPopupView.prototype.onShowWithDelay = function onShowWithDelay() {
		this.emailFocus(true);
	};

	return AccountPopupView;
}(__WEBPACK_IMPORTED_MODULE_11_Knoin_AbstractViewNext__["a" /* AbstractViewNext */]), (_applyDecoratedDescriptor(_class2.prototype, 'addAccountCommand', [_dec2], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default()(_class2.prototype, 'addAccountCommand'), _class2.prototype)), _class2)) || _class);




/***/ }),
/* 150 */
/*!****************************************!*\
  !*** ./dev/Screen/AbstractSettings.js ***!
  \****************************************/
/*! exports provided: AbstractSettingsScreen, default */
/*! exports used: AbstractSettingsScreen */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AbstractSettingsScreen; });
/* unused harmony export default */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4____ = __webpack_require__(/*! $ */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Common_Links__ = __webpack_require__(/*! Common/Links */ 14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Knoin_AbstractScreen__ = __webpack_require__(/*! Knoin/AbstractScreen */ 76);















var AbstractSettingsScreen = function (_AbstractScreen) {
	__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(AbstractSettingsScreen, _AbstractScreen);

	/**
  * @param {Array} viewModels
  */
	function AbstractSettingsScreen(viewModels) {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, AbstractSettingsScreen);

		var _this = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractScreen.call(this, 'settings', viewModels));

		_this.menu = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observableArray([]);

		_this.oCurrentSubScreen = null;
		_this.oViewModelPlace = null;

		_this.setupSettings();
		return _this;
	}

	/**
  * @param {Function=} fCallback
  */


	AbstractSettingsScreen.prototype.setupSettings = function setupSettings() {
		var fCallback = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

		if (fCallback) {
			fCallback();
		}
	};

	AbstractSettingsScreen.prototype.onRoute = function onRoute(subName) {
		var _this2 = this;

		var settingsScreen = null,
		    RoutedSettingsViewModel = null,
		    viewModelPlace = null,
		    viewModelDom = null;

		RoutedSettingsViewModel = __WEBPACK_IMPORTED_MODULE_3_____default.a.find(__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["VIEW_MODELS"].settings, function (SettingsViewModel) {
			return SettingsViewModel && SettingsViewModel.__rlSettingsData && subName === SettingsViewModel.__rlSettingsData.Route;
		});

		if (RoutedSettingsViewModel) {
			if (__WEBPACK_IMPORTED_MODULE_3_____default.a.find(__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["VIEW_MODELS"]['settings-removed'], function (DisabledSettingsViewModel) {
				return DisabledSettingsViewModel && DisabledSettingsViewModel === RoutedSettingsViewModel;
			})) {
				RoutedSettingsViewModel = null;
			}

			if (RoutedSettingsViewModel && __WEBPACK_IMPORTED_MODULE_3_____default.a.find(__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["VIEW_MODELS"]['settings-disabled'], function (DisabledSettingsViewModel) {
				return DisabledSettingsViewModel && DisabledSettingsViewModel === RoutedSettingsViewModel;
			})) {
				RoutedSettingsViewModel = null;
			}
		}

		if (RoutedSettingsViewModel) {
			if (RoutedSettingsViewModel.__builded && RoutedSettingsViewModel.__vm) {
				settingsScreen = RoutedSettingsViewModel.__vm;
			} else {
				viewModelPlace = this.oViewModelPlace;
				if (viewModelPlace && 1 === viewModelPlace.length) {
					settingsScreen = new RoutedSettingsViewModel();

					viewModelDom = __WEBPACK_IMPORTED_MODULE_4_____default()('<div></div>').addClass('rl-settings-view-model').hide();
					viewModelDom.appendTo(viewModelPlace);

					settingsScreen.viewModelDom = viewModelDom;

					settingsScreen.__rlSettingsData = RoutedSettingsViewModel.__rlSettingsData;

					RoutedSettingsViewModel.__dom = viewModelDom;
					RoutedSettingsViewModel.__builded = true;
					RoutedSettingsViewModel.__vm = settingsScreen;

					var tmpl = { name: RoutedSettingsViewModel.__rlSettingsData.Template };
					__WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].applyBindingAccessorsToNode(viewModelDom[0], {
						translatorInit: true,
						template: function template() {
							return tmpl;
						}
					}, settingsScreen);

					Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(settingsScreen, 'onBuild', [viewModelDom]);
				} else {
					Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["log"])('Cannot find sub settings view model position: SettingsSubScreen');
				}
			}

			if (settingsScreen) {
				__WEBPACK_IMPORTED_MODULE_3_____default.a.defer(function () {
					// hide
					if (_this2.oCurrentSubScreen) {
						Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(_this2.oCurrentSubScreen, 'onHide');
						_this2.oCurrentSubScreen.viewModelDom.hide();
					}
					// --

					_this2.oCurrentSubScreen = settingsScreen;

					// show
					if (_this2.oCurrentSubScreen) {
						Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(_this2.oCurrentSubScreen, 'onBeforeShow');
						_this2.oCurrentSubScreen.viewModelDom.show();
						Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(_this2.oCurrentSubScreen, 'onShow');
						Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(_this2.oCurrentSubScreen, 'onShowWithDelay', [], 200);

						__WEBPACK_IMPORTED_MODULE_3_____default.a.each(_this2.menu(), function (item) {
							item.selected(settingsScreen && settingsScreen.__rlSettingsData && item.route === settingsScreen.__rlSettingsData.Route);
						});

						__WEBPACK_IMPORTED_MODULE_4_____default()('#rl-content .b-settings .b-content .content').scrollTop(0);
					}
					// --

					Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["windowResize"])();
				});
			}
		} else {
			Object(__WEBPACK_IMPORTED_MODULE_9_Knoin_Knoin__["setHash"])(Object(__WEBPACK_IMPORTED_MODULE_8_Common_Links__["z" /* settings */])(), false, true);
		}
	};

	AbstractSettingsScreen.prototype.onHide = function onHide() {
		if (this.oCurrentSubScreen && this.oCurrentSubScreen.viewModelDom) {
			Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(this.oCurrentSubScreen, 'onHide');
			this.oCurrentSubScreen.viewModelDom.hide();
		}
	};

	AbstractSettingsScreen.prototype.onBuild = function onBuild() {
		var _this3 = this;

		__WEBPACK_IMPORTED_MODULE_3_____default.a.each(__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["VIEW_MODELS"].settings, function (SettingsViewModel) {
			if (SettingsViewModel && SettingsViewModel.__rlSettingsData && !__WEBPACK_IMPORTED_MODULE_3_____default.a.find(__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["VIEW_MODELS"]['settings-removed'], function (RemoveSettingsViewModel) {
				return RemoveSettingsViewModel && RemoveSettingsViewModel === SettingsViewModel;
			})) {
				_this3.menu.push({
					route: SettingsViewModel.__rlSettingsData.Route,
					label: SettingsViewModel.__rlSettingsData.Label,
					selected: __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false),
					disabled: !!__WEBPACK_IMPORTED_MODULE_3_____default.a.find(__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["VIEW_MODELS"]['settings-disabled'], function (DisabledSettingsViewModel) {
						return DisabledSettingsViewModel && DisabledSettingsViewModel === SettingsViewModel;
					})
				});
			}
		});

		this.oViewModelPlace = __WEBPACK_IMPORTED_MODULE_4_____default()('#rl-content #rl-settings-subscreen');
	};

	AbstractSettingsScreen.prototype.routes = function routes() {
		var DefaultViewModel = __WEBPACK_IMPORTED_MODULE_3_____default.a.find(__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["VIEW_MODELS"].settings, function (SettingsViewModel) {
			return SettingsViewModel && SettingsViewModel.__rlSettingsData && SettingsViewModel.__rlSettingsData.IsDefault;
		}),
		    defaultRoute = DefaultViewModel && DefaultViewModel.__rlSettingsData ? DefaultViewModel.__rlSettingsData.Route : 'general',
		    rules = {
			subname: /^(.*)$/,
			normalize_: function normalize_(rquest, vals) {
				vals.subname = Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isUnd"])(vals.subname) ? defaultRoute : Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pString"])(vals.subname);
				return [vals.subname];
			}
		};

		return [['{subname}/', rules], ['{subname}', rules], ['', rules]];
	};

	return AbstractSettingsScreen;
}(__WEBPACK_IMPORTED_MODULE_10_Knoin_AbstractScreen__["a" /* AbstractScreen */]);



/***/ }),
/* 151 */
/*!************************************!*\
  !*** ./dev/View/Popup/Identity.js ***!
  \************************************/
/*! exports provided: IdentityPopupView, default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "IdentityPopupView", function() { return IdentityPopupView; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return IdentityPopupView; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor__ = __webpack_require__(/*! babel-runtime/core-js/object/get-own-property-descriptor */ 15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Remote_User_Ajax__ = __webpack_require__(/*! Remote/User/Ajax */ 17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Helper_Apps_User__ = __webpack_require__(/*! Helper/Apps/User */ 16);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_Knoin_AbstractViewNext__ = __webpack_require__(/*! Knoin/AbstractViewNext */ 13);





var _dec, _dec2, _class, _desc, _value, _class2;

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
	var desc = {};
	Object['ke' + 'ys'](descriptor).forEach(function (key) {
		desc[key] = descriptor[key];
	});
	desc.enumerable = !!desc.enumerable;
	desc.configurable = !!desc.configurable;

	if ('value' in desc || desc.initializer) {
		desc.writable = true;
	}

	desc = decorators.slice().reverse().reduce(function (desc, decorator) {
		return decorator(target, property, desc) || desc;
	}, desc);

	if (context && desc.initializer !== void 0) {
		desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
		desc.initializer = undefined;
	}

	if (desc.initializer === void 0) {
		Object['define' + 'Property'](target, property, desc);
		desc = null;
	}

	return desc;
}















var IdentityPopupView = (_dec = Object(__WEBPACK_IMPORTED_MODULE_11_Knoin_Knoin__["popup"])({
	name: 'View/Popup/Identity',
	templateID: 'PopupsIdentity'
}), _dec2 = Object(__WEBPACK_IMPORTED_MODULE_11_Knoin_Knoin__["command"])(function (self) {
	return !self.submitRequest();
}), _dec(_class = (_class2 = function (_AbstractViewNext) {
	__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits___default()(IdentityPopupView, _AbstractViewNext);

	function IdentityPopupView() {
		__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default()(this, IdentityPopupView);

		var _this = __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractViewNext.call(this));

		_this.id = '';
		_this.edit = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);
		_this.owner = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);

		_this.email = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable('').validateEmail();
		_this.email.focused = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);
		_this.name = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable('');
		_this.name.focused = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);
		_this.replyTo = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable('').validateSimpleEmail();
		_this.replyTo.focused = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);
		_this.bcc = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable('').validateSimpleEmail();
		_this.bcc.focused = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);

		_this.signature = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable('');
		_this.signatureInsertBefore = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);

		_this.showBcc = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);
		_this.showReplyTo = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);

		_this.submitRequest = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);
		_this.submitError = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable('');

		_this.bcc.subscribe(function (value) {
			if (false === _this.showBcc() && 0 < value.length) {
				_this.showBcc(true);
			}
		});

		_this.replyTo.subscribe(function (value) {
			if (false === _this.showReplyTo() && 0 < value.length) {
				_this.showReplyTo(true);
			}
		});
		return _this;
	}

	IdentityPopupView.prototype.addOrEditIdentityCommand = function addOrEditIdentityCommand() {
		var _this2 = this;

		if (this.signature && this.signature.__fetchEditorValue) {
			this.signature.__fetchEditorValue();
		}

		if (!this.email.hasError()) {
			this.email.hasError('' === Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["trim"])(this.email()));
		}

		if (this.email.hasError()) {
			if (!this.owner()) {
				this.email.focused(true);
			}

			return false;
		}

		if (this.replyTo.hasError()) {
			this.replyTo.focused(true);
			return false;
		}

		if (this.bcc.hasError()) {
			this.bcc.focused(true);
			return false;
		}

		this.submitRequest(true);

		__WEBPACK_IMPORTED_MODULE_9_Remote_User_Ajax__["a" /* default */].identityUpdate(function (result, data) {

			_this2.submitRequest(false);
			if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["StorageResultType"].Success === result && data) {
				if (data.Result) {
					Object(__WEBPACK_IMPORTED_MODULE_10_Helper_Apps_User__["a" /* getApp */])().accountsAndIdentities();
					_this2.cancelCommand();
				} else if (data.ErrorCode) {
					_this2.submitError(Object(__WEBPACK_IMPORTED_MODULE_8_Common_Translator__["getNotification"])(data.ErrorCode));
				}
			} else {
				_this2.submitError(Object(__WEBPACK_IMPORTED_MODULE_8_Common_Translator__["getNotification"])(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Notification"].UnknownError));
			}
		}, this.id, this.email(), this.name(), this.replyTo(), this.bcc(), this.signature(), this.signatureInsertBefore());

		return true;
	};

	IdentityPopupView.prototype.clearPopup = function clearPopup() {
		this.id = '';
		this.edit(false);
		this.owner(false);

		this.name('');
		this.email('');
		this.replyTo('');
		this.bcc('');
		this.signature('');
		this.signatureInsertBefore(false);

		this.email.hasError(false);
		this.replyTo.hasError(false);
		this.bcc.hasError(false);

		this.showBcc(false);
		this.showReplyTo(false);

		this.submitRequest(false);
		this.submitError('');
	};

	/**
  * @param {?IdentityModel} oIdentity
  */


	IdentityPopupView.prototype.onShow = function onShow(identity) {

		this.clearPopup();

		if (identity) {
			this.edit(true);

			this.id = identity.id() || '';
			this.name(identity.name());
			this.email(identity.email());
			this.replyTo(identity.replyTo());
			this.bcc(identity.bcc());
			this.signature(identity.signature());
			this.signatureInsertBefore(identity.signatureInsertBefore());

			this.owner('' === this.id);
		} else {
			this.id = Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["fakeMd5"])();
		}
	};

	IdentityPopupView.prototype.onShowWithDelay = function onShowWithDelay() {
		if (!this.owner() && !__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["bMobileDevice"]) {
			this.email.focused(true);
		}
	};

	IdentityPopupView.prototype.onHideWithDelay = function onHideWithDelay() {
		this.clearPopup();
	};

	return IdentityPopupView;
}(__WEBPACK_IMPORTED_MODULE_12_Knoin_AbstractViewNext__["a" /* AbstractViewNext */]), (_applyDecoratedDescriptor(_class2.prototype, 'addOrEditIdentityCommand', [_dec2], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default()(_class2.prototype, 'addOrEditIdentityCommand'), _class2.prototype)), _class2)) || _class);




/***/ }),
/* 152 */
/*!*****************************!*\
  !*** ./dev/App/Abstract.js ***!
  \*****************************/
/*! exports provided: AbstractApp, default */
/*! exports used: AbstractApp */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AbstractApp; });
/* unused harmony export default */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4____ = __webpack_require__(/*! $ */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_key__ = __webpack_require__(/*! key */ 19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_key___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_7_key__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_ssm__ = __webpack_require__(/*! ssm */ 153);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_ssm___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_8_ssm__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_Common_Links__ = __webpack_require__(/*! Common/Links */ 14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14_Common_Cmd__ = __webpack_require__(/*! Common/Cmd */ 154);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15_Common_Events__ = __webpack_require__(/*! Common/Events */ 37);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_16_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_17_Stores_Language__ = __webpack_require__(/*! Stores/Language */ 57);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_18_Stores_Theme__ = __webpack_require__(/*! Stores/Theme */ 72);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_19_Stores_Social__ = __webpack_require__(/*! Stores/Social */ 56);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_20_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_21_Knoin_AbstractBoot__ = __webpack_require__(/*! Knoin/AbstractBoot */ 161);





























var AbstractApp = function (_AbstractBoot) {
	__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(AbstractApp, _AbstractBoot);

	/**
  * @param {RemoteStorage|AdminRemoteStorage} Remote
  */
	function AbstractApp(Remote) {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, AbstractApp);

		var _this = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractBoot.call(this));

		_this.googlePreviewSupportedCache = null;
		_this.isLocalAutocomplete = true;
		_this.iframe = null;
		_this.lastErrorTime = 0;

		_this.iframe = __WEBPACK_IMPORTED_MODULE_4_____default()('<iframe class="internal-hiddden" />').appendTo('body');

		__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$win"].on('error', function (event) {
			if (event && event.originalEvent && event.originalEvent.message && -1 === Object(__WEBPACK_IMPORTED_MODULE_10_Common_Utils__["inArray"])(event.originalEvent.message, ['Script error.', 'Uncaught Error: Error calling method on NPObject.'])) {
				var time = Object(__WEBPACK_IMPORTED_MODULE_10_Common_Utils__["timestamp"])();
				if (_this.lastErrorTime >= time) {
					return;
				}

				_this.lastErrorTime = time;

				Remote.jsError(__WEBPACK_IMPORTED_MODULE_10_Common_Utils__["noop"], event.originalEvent.message, event.originalEvent.filename, event.originalEvent.lineno, __WEBPACK_IMPORTED_MODULE_3_window___default.a.location && __WEBPACK_IMPORTED_MODULE_3_window___default.a.location.toString ? __WEBPACK_IMPORTED_MODULE_3_window___default.a.location.toString() : '', __WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].attr('class'), Object(__WEBPACK_IMPORTED_MODULE_10_Common_Utils__["microtime"])() - __WEBPACK_IMPORTED_MODULE_9_Common_Globals__["startMicrotime"]);
			}
		});

		__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$win"].on('resize', function () {
			__WEBPACK_IMPORTED_MODULE_15_Common_Events__["a" /* pub */]('window.resize');
		});

		__WEBPACK_IMPORTED_MODULE_15_Common_Events__["b" /* sub */]('window.resize', __WEBPACK_IMPORTED_MODULE_5_____default.a.throttle(function () {
			var iH = __WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$win"].height(),
			    iW = __WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$win"].height();

			if (__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$win"].__sizes[0] !== iH || __WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$win"].__sizes[1] !== iW) {
				__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$win"].__sizes[0] = iH;
				__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$win"].__sizes[1] = iW;

				__WEBPACK_IMPORTED_MODULE_15_Common_Events__["a" /* pub */]('window.resize.real');
			}
		}, __WEBPACK_IMPORTED_MODULE_11_Common_Enums__["Magics"].Time50ms));

		// DEBUG
		//		Events.sub({
		//			'window.resize': function() {
		//				window.console.log('window.resize');
		//			},
		//			'window.resize.real': function() {
		//				window.console.log('window.resize.real');
		//			}
		//		});

		__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$doc"].on('keydown', function (event) {
			if (event && event.ctrlKey) {
				__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].addClass('rl-ctrl-key-pressed');
			}
		}).on('keyup', function (event) {
			if (event && !event.ctrlKey) {
				__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].removeClass('rl-ctrl-key-pressed');
			}
		});

		__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$doc"].on('mousemove keypress click', __WEBPACK_IMPORTED_MODULE_5_____default.a.debounce(function () {
			__WEBPACK_IMPORTED_MODULE_15_Common_Events__["a" /* pub */]('rl.auto-logout-refresh');
		}, __WEBPACK_IMPORTED_MODULE_11_Common_Enums__["Magics"].Time5s));

		__WEBPACK_IMPORTED_MODULE_7_key___default()('esc, enter', __WEBPACK_IMPORTED_MODULE_11_Common_Enums__["KeyState"].All, function () {
			Object(__WEBPACK_IMPORTED_MODULE_10_Common_Utils__["detectDropdownVisibility"])();
		});

		if (__WEBPACK_IMPORTED_MODULE_16_Storage_Settings__["appSettingsGet"]('allowCmdInterface')) {
			__WEBPACK_IMPORTED_MODULE_7_key___default()('ctrl+shift+`', __WEBPACK_IMPORTED_MODULE_11_Common_Enums__["KeyState"].All, function () {
				Object(__WEBPACK_IMPORTED_MODULE_14_Common_Cmd__["a" /* toggle */])();
			});
		}
		return _this;
	}

	AbstractApp.prototype.remote = function remote() {
		return null;
	};

	AbstractApp.prototype.data = function data() {
		return null;
	};

	AbstractApp.prototype.getApplicationConfiguration = function getApplicationConfiguration(name, default_) {
		return this.applicationConfiguration[name] || default_;
	};

	/**
  * @param {string} link
  * @returns {boolean}
  */


	AbstractApp.prototype.download = function download(link) {

		if (__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["sUserAgent"] && (-1 < __WEBPACK_IMPORTED_MODULE_9_Common_Globals__["sUserAgent"].indexOf('chrome') || -1 < __WEBPACK_IMPORTED_MODULE_9_Common_Globals__["sUserAgent"].indexOf('chrome'))) {
			var oLink = __WEBPACK_IMPORTED_MODULE_3_window___default.a.document.createElement('a');
			oLink.href = link;

			if (__WEBPACK_IMPORTED_MODULE_3_window___default.a.document && __WEBPACK_IMPORTED_MODULE_3_window___default.a.document.createEvent) {
				var oE = __WEBPACK_IMPORTED_MODULE_3_window___default.a.document.createEvent.MouseEvents;
				if (oE && oE.initEvent && oLink.dispatchEvent) {
					oE.initEvent('click', true, true);
					oLink.dispatchEvent(oE);
					return true;
				}
			}
		}

		if (__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["bMobileDevice"]) {
			__WEBPACK_IMPORTED_MODULE_3_window___default.a.open(link, '_self');
			__WEBPACK_IMPORTED_MODULE_3_window___default.a.focus();
		} else {
			this.iframe.attr('src', link);
			// window.document.location.href = link;
		}

		return true;
	};

	/**
  * @returns {boolean}
  */


	AbstractApp.prototype.googlePreviewSupported = function googlePreviewSupported() {
		if (null === this.googlePreviewSupportedCache) {
			this.googlePreviewSupportedCache = !!__WEBPACK_IMPORTED_MODULE_16_Storage_Settings__["settingsGet"]('AllowGoogleSocial') && !!__WEBPACK_IMPORTED_MODULE_16_Storage_Settings__["settingsGet"]('AllowGoogleSocialPreview');
		}

		return this.googlePreviewSupportedCache;
	};

	/**
  * @param {string} title
  */


	AbstractApp.prototype.setWindowTitle = function setWindowTitle(title) {
		title = Object(__WEBPACK_IMPORTED_MODULE_10_Common_Utils__["isNormal"])(title) && 0 < title.length ? '' + title : '';
		if (__WEBPACK_IMPORTED_MODULE_16_Storage_Settings__["settingsGet"]('Title')) {
			title += (title ? ' - ' : '') + __WEBPACK_IMPORTED_MODULE_16_Storage_Settings__["settingsGet"]('Title');
		}

		__WEBPACK_IMPORTED_MODULE_3_window___default.a.document.title = title + ' ...';
		__WEBPACK_IMPORTED_MODULE_3_window___default.a.document.title = title;
	};

	AbstractApp.prototype.redirectToAdminPanel = function redirectToAdminPanel() {
		__WEBPACK_IMPORTED_MODULE_5_____default.a.delay(function () {
			__WEBPACK_IMPORTED_MODULE_3_window___default.a.location.href = Object(__WEBPACK_IMPORTED_MODULE_12_Common_Links__["x" /* rootAdmin */])();
		}, __WEBPACK_IMPORTED_MODULE_11_Common_Enums__["Magics"].Time100ms);
	};

	AbstractApp.prototype.clearClientSideToken = function clearClientSideToken() {
		if (__WEBPACK_IMPORTED_MODULE_3_window___default.a.__rlah_clear) {
			__WEBPACK_IMPORTED_MODULE_3_window___default.a.__rlah_clear();
		}
	};

	/**
  * @param {string} token
  */


	AbstractApp.prototype.setClientSideToken = function setClientSideToken(token) {
		if (__WEBPACK_IMPORTED_MODULE_3_window___default.a.__rlah_set) {
			__WEBPACK_IMPORTED_MODULE_3_window___default.a.__rlah_set(token);

			__WEBPACK_IMPORTED_MODULE_16_Storage_Settings__["settingsSet"]('AuthAccountHash', token);
			Object(__WEBPACK_IMPORTED_MODULE_12_Common_Links__["v" /* populateAuthSuffix */])();
		}
	};

	/**
  * @param {boolean=} admin = false
  * @param {boolean=} logout = false
  * @param {boolean=} close = false
  */


	AbstractApp.prototype.loginAndLogoutReload = function loginAndLogoutReload() {
		var admin = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
		var logout = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
		var close = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;


		var inIframe = !!__WEBPACK_IMPORTED_MODULE_16_Storage_Settings__["appSettingsGet"]('inIframe');
		var customLogoutLink = Object(__WEBPACK_IMPORTED_MODULE_10_Common_Utils__["pString"])(__WEBPACK_IMPORTED_MODULE_16_Storage_Settings__["appSettingsGet"]('customLogoutLink'));

		if (logout) {
			this.clearClientSideToken();
		}

		if (logout && close && __WEBPACK_IMPORTED_MODULE_3_window___default.a.close) {
			__WEBPACK_IMPORTED_MODULE_3_window___default.a.close();
		}

		customLogoutLink = customLogoutLink || (admin ? Object(__WEBPACK_IMPORTED_MODULE_12_Common_Links__["x" /* rootAdmin */])() : Object(__WEBPACK_IMPORTED_MODULE_12_Common_Links__["y" /* rootUser */])());

		if (logout && __WEBPACK_IMPORTED_MODULE_3_window___default.a.location.href !== customLogoutLink) {
			__WEBPACK_IMPORTED_MODULE_5_____default.a.delay(function () {

				if (inIframe && __WEBPACK_IMPORTED_MODULE_3_window___default.a.parent) {
					__WEBPACK_IMPORTED_MODULE_3_window___default.a.parent.location.href = customLogoutLink;
				} else {
					__WEBPACK_IMPORTED_MODULE_3_window___default.a.location.href = customLogoutLink;
				}

				__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$win"].trigger('rl.tooltips.diactivate');
			}, __WEBPACK_IMPORTED_MODULE_11_Common_Enums__["Magics"].Time100ms);
		} else {
			Object(__WEBPACK_IMPORTED_MODULE_20_Knoin_Knoin__["routeOff"])();
			Object(__WEBPACK_IMPORTED_MODULE_20_Knoin_Knoin__["setHash"])(Object(__WEBPACK_IMPORTED_MODULE_12_Common_Links__["w" /* root */])(), true);
			Object(__WEBPACK_IMPORTED_MODULE_20_Knoin_Knoin__["routeOff"])();

			__WEBPACK_IMPORTED_MODULE_5_____default.a.delay(function () {

				if (inIframe && __WEBPACK_IMPORTED_MODULE_3_window___default.a.parent) {
					__WEBPACK_IMPORTED_MODULE_3_window___default.a.parent.location.reload();
				} else {
					__WEBPACK_IMPORTED_MODULE_3_window___default.a.location.reload();
				}

				__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$win"].trigger('rl.tooltips.diactivate');
			}, __WEBPACK_IMPORTED_MODULE_11_Common_Enums__["Magics"].Time100ms);
		}
	};

	AbstractApp.prototype.historyBack = function historyBack() {
		__WEBPACK_IMPORTED_MODULE_3_window___default.a.history.back();
	};

	AbstractApp.prototype.bootstart = function bootstart() {

		// log('Ps' + 'ss, hac' + 'kers! The' + 're\'s not' + 'hing inte' + 'resting :' + ')');

		__WEBPACK_IMPORTED_MODULE_15_Common_Events__["a" /* pub */]('rl.bootstart');

		var mobile = __WEBPACK_IMPORTED_MODULE_16_Storage_Settings__["appSettingsGet"]('mobile');

		__WEBPACK_IMPORTED_MODULE_6_ko__["a" /* default */].components.register('SaveTrigger', __webpack_require__(/*! Component/SaveTrigger */ 162).default);
		__WEBPACK_IMPORTED_MODULE_6_ko__["a" /* default */].components.register('Input', __webpack_require__(/*! Component/Input */ 163).default);
		__WEBPACK_IMPORTED_MODULE_6_ko__["a" /* default */].components.register('Select', __webpack_require__(/*! Component/Select */ 164).default);
		__WEBPACK_IMPORTED_MODULE_6_ko__["a" /* default */].components.register('Radio', __webpack_require__(/*! Component/Radio */ 165).default);
		__WEBPACK_IMPORTED_MODULE_6_ko__["a" /* default */].components.register('TextArea', __webpack_require__(/*! Component/TextArea */ 167).default);
		__WEBPACK_IMPORTED_MODULE_6_ko__["a" /* default */].components.register('Date', __webpack_require__(/*! Component/Date */ 168).default);

		__WEBPACK_IMPORTED_MODULE_6_ko__["a" /* default */].components.register('x-script', __webpack_require__(/*! Component/Script */ 169).default);
		// ko.components.register('svg-icon', require('Component/SvgIcon').default);

		if (__WEBPACK_IMPORTED_MODULE_16_Storage_Settings__["appSettingsGet"]('materialDesign') && __WEBPACK_IMPORTED_MODULE_9_Common_Globals__["bAnimationSupported"]) {
			__WEBPACK_IMPORTED_MODULE_6_ko__["a" /* default */].components.register('Checkbox', __webpack_require__(/*! Component/MaterialDesign/Checkbox */ 170).default);
			__WEBPACK_IMPORTED_MODULE_6_ko__["a" /* default */].components.register('CheckboxSimple', __webpack_require__(/*! Component/Checkbox */ 73).default);
		} else {
			// ko.components.register('Checkbox', require('Component/Classic/Checkbox').default);
			// ko.components.register('CheckboxSimple', require('Component/Classic/Checkbox').default);
			__WEBPACK_IMPORTED_MODULE_6_ko__["a" /* default */].components.register('Checkbox', __webpack_require__(/*! Component/Checkbox */ 73).default);
			__WEBPACK_IMPORTED_MODULE_6_ko__["a" /* default */].components.register('CheckboxSimple', __webpack_require__(/*! Component/Checkbox */ 73).default);
		}

		Object(__WEBPACK_IMPORTED_MODULE_13_Common_Translator__["initOnStartOrLangChange"])(__WEBPACK_IMPORTED_MODULE_13_Common_Translator__["initNotificationLanguage"]);

		__WEBPACK_IMPORTED_MODULE_5_____default.a.delay(__WEBPACK_IMPORTED_MODULE_10_Common_Utils__["windowResizeCallback"], __WEBPACK_IMPORTED_MODULE_11_Common_Enums__["Magics"].Time1s);

		__WEBPACK_IMPORTED_MODULE_15_Common_Events__["b" /* sub */]('ssm.mobile-enter', function () {
			Object(__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["leftPanelDisabled"])(true);
		});

		__WEBPACK_IMPORTED_MODULE_15_Common_Events__["b" /* sub */]('ssm.mobile-leave', function () {
			Object(__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["leftPanelDisabled"])(false);
		});

		if (!mobile) {
			__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].addClass('rl-desktop');

			__WEBPACK_IMPORTED_MODULE_8_ssm___default.a.addState({
				id: 'mobile',
				query: '(max-width: 767px)',
				onEnter: function onEnter() {
					__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].addClass('ssm-state-mobile');
					__WEBPACK_IMPORTED_MODULE_15_Common_Events__["a" /* pub */]('ssm.mobile-enter');
				},
				onLeave: function onLeave() {
					__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].removeClass('ssm-state-mobile');
					__WEBPACK_IMPORTED_MODULE_15_Common_Events__["a" /* pub */]('ssm.mobile-leave');
				}
			});

			__WEBPACK_IMPORTED_MODULE_8_ssm___default.a.addState({
				id: 'tablet',
				query: '(min-width: 768px) and (max-width: 999px)',
				onEnter: function onEnter() {
					__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].addClass('ssm-state-tablet');
				},
				onLeave: function onLeave() {
					__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].removeClass('ssm-state-tablet');
				}
			});

			__WEBPACK_IMPORTED_MODULE_8_ssm___default.a.addState({
				id: 'desktop',
				query: '(min-width: 1000px) and (max-width: 1400px)',
				onEnter: function onEnter() {
					__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].addClass('ssm-state-desktop');
				},
				onLeave: function onLeave() {
					__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].removeClass('ssm-state-desktop');
				}
			});

			__WEBPACK_IMPORTED_MODULE_8_ssm___default.a.addState({
				id: 'desktop-large',
				query: '(min-width: 1401px)',
				onEnter: function onEnter() {
					__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].addClass('ssm-state-desktop-large');
				},
				onLeave: function onLeave() {
					__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].removeClass('ssm-state-desktop-large');
				}
			});
		} else {
			__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].addClass('ssm-state-mobile').addClass('rl-mobile');
			__WEBPACK_IMPORTED_MODULE_15_Common_Events__["a" /* pub */]('ssm.mobile-enter');
		}

		__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["leftPanelDisabled"].subscribe(function (bValue) {
			__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].toggleClass('rl-left-panel-disabled', bValue);
			__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].toggleClass('rl-left-panel-enabled', !bValue);
		});

		__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["leftPanelType"].subscribe(function (sValue) {
			__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].toggleClass('rl-left-panel-none', 'none' === sValue);
			__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].toggleClass('rl-left-panel-short', 'short' === sValue);
		});

		__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["leftPanelDisabled"].valueHasMutated();

		__WEBPACK_IMPORTED_MODULE_17_Stores_Language__["a" /* default */].populate();
		__WEBPACK_IMPORTED_MODULE_18_Stores_Theme__["a" /* default */].populate();
		__WEBPACK_IMPORTED_MODULE_19_Stores_Social__["a" /* default */].populate();
	};

	return AbstractApp;
}(__WEBPACK_IMPORTED_MODULE_21_Knoin_AbstractBoot__["a" /* AbstractBoot */]);



/***/ }),
/* 153 */
/*!*****************************!*\
  !*** external "window.ssm" ***!
  \*****************************/
/*! no static exports found */
/*! exports used: default */
/***/ (function(module, exports) {

module.exports = window.ssm;

/***/ }),
/* 154 */
/*!***************************!*\
  !*** ./dev/Common/Cmd.js ***!
  \***************************/
/*! exports provided: bind, toggle */
/*! exports used: toggle */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export bind */
/* harmony export (immutable) */ __webpack_exports__["a"] = toggle;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! $ */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Stores_Theme__ = __webpack_require__(/*! Stores/Theme */ 72);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_Stores_Language__ = __webpack_require__(/*! Stores/Language */ 57);
















var cmdDom = null,
    contoller = null;

/**
 * @params {string} cmd
 * @returns {string}
 */
function cmdError(cmd) {
	return __webpack_require__(/*! Html/Cmds/Error.html */ 155).replace('{{ cmd }}', cmd);
}

/**
 * @returns {string}
 */
function cmdClear(dom) {
	dom.find('.rl-cmd-history-data').empty();
	return '';
}

/**
 * @returns {string}
 */
function cmdHelp(cmds) {
	return __webpack_require__(/*! Html/Cmds/Help.html */ 156).replace('{{ commands }}', cmds.join(' '));
}

/**
 * @returns {string}
 */
function cmdTheme(param, themes) {
	if (param && -1 < Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["inArray"])(param, themes)) {
		Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["changeTheme"])(param);
		return '';
	}
	return __webpack_require__(/*! Html/Cmds/ThemeEmpty.html */ 157).replace('{{ themes }}', themes.join(', '));
}

/**
 * @returns {string}
 */
function cmdLang(param, isAdmin, langs) {
	if (param && -1 < Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["inArray"])(param, langs)) {
		Object(__WEBPACK_IMPORTED_MODULE_8_Common_Translator__["reload"])(isAdmin, param);
		return '';
	}
	return __webpack_require__(/*! Html/Cmds/LangEmpty.html */ 158).replace('{{ langs }}', langs.join(', '));
}

/**
 * @returns {string}
 */
function cmdVersion() {
	return __webpack_require__(/*! Html/Cmds/Version.html */ 159).replace('{{ version }}', __WEBPACK_IMPORTED_MODULE_9_Storage_Settings__["appSettingsGet"]('version') + ' (' + __WEBPACK_IMPORTED_MODULE_9_Storage_Settings__["appSettingsGet"]('appVersionType') + ')');
}

var CmdContoller = function () {
	function CmdContoller(dom) {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, CmdContoller);

		this.dom = null;
		this.opened = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);
		this.cmd = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable('');
		this.focused = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);
		this.themes = __WEBPACK_IMPORTED_MODULE_10_Stores_Theme__["a" /* default */].themes;
		this.cmdHistory = [];
		this.cmdHistoryShift = 0;
		this.cmdHelper = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable('');
		this.cmds = ['help', 'version', 'clear', 'theme', 'lang'];
		this.cmdsWithParameters = ['theme', 'lang'];
		this.isAdmin = false;

		this.dom = dom;
		this.isAdmin = !!__WEBPACK_IMPORTED_MODULE_9_Storage_Settings__["appSettingsGet"]('admin');
	}

	CmdContoller.prototype.runCmd = function runCmd(cmd, params, isTab) {

		var result = '',
		    values = null;

		this.cmdHelper('');

		if (isTab) {
			switch (cmd) {
				case 'lang':
					values = (this.isAdmin ? __WEBPACK_IMPORTED_MODULE_11_Stores_Language__["a" /* default */].languagesAdmin() : __WEBPACK_IMPORTED_MODULE_11_Stores_Language__["a" /* default */].languages()).filter(function (line) {
						return 0 === line.lastIndexOf(params, 0);
					});
					break;
				case 'theme':
					values = __WEBPACK_IMPORTED_MODULE_10_Stores_Theme__["a" /* default */].themes().filter(function (line) {
						return 0 === line.lastIndexOf(params, 0);
					});
					break;
				default:
					break;
			}

			if (cmd && values) {
				if (1 === values.length && values[0]) {
					this.cmd(cmd + ' ' + values[0]);
				} else if (1 < values.length && values[0] && values[1]) {
					var sub = '',
					    index = 0;

					var list = values[0].split(''),
					    len = list.length;

					for (; index < len; index++) {
						if (values[1][index] === list[index]) {
							sub += list[index];
						} else {
							break;
						}
					}

					if (sub) {
						this.cmdHelper('[' + values.join(', ') + ']');
						this.cmd(cmd + ' ' + sub);
					}
				}
			}

			return '';
		}

		switch (cmd) {
			case 'hi':
				result = 'hello';
				break;
			case '?':
			case 'ls':
			case 'help':
				result = cmdHelp(this.cmds);
				break;
			case 'v':
			case 'version':
				result = cmdVersion();
				break;
			case 'clear':
				result = cmdClear(this.dom);
				break;
			case 'theme':
				result = cmdTheme(params, __WEBPACK_IMPORTED_MODULE_10_Stores_Theme__["a" /* default */].themes());
				break;
			case 'lang':
				result = cmdLang(params, this.isAdmin, this.isAdmin ? __WEBPACK_IMPORTED_MODULE_11_Stores_Language__["a" /* default */].languagesAdmin() : __WEBPACK_IMPORTED_MODULE_11_Stores_Language__["a" /* default */].languages());
				break;
			default:
				result = cmdError(cmd);
				break;
		}

		return result;
	};

	CmdContoller.prototype.onCmd = function onCmd(isTab) {
		var _this = this;

		var cmdLine = this.cmd().replace(/[\s]+/, ' '),
		    cmdParts = Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["trim"])(cmdLine).replace().split(/[\s]+/),
		    cmd = cmdParts.shift();

		if ('' === Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["trim"])(cmdLine)) {
			return false;
		}

		if (isTab) {
			if (-1 < Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["inArray"])(cmd, this.cmds)) {
				var result = this.runCmd(cmd, cmdParts.join(' '), true);
				if (result) {
					this.cmd(result);
				}
			} else {
				var values = this.cmds.filter(function (line) {
					return line !== cmd && 0 === line.lastIndexOf(cmd, 0);
				});
				if (1 === values.length && values[0]) {
					this.cmd(values[0] + (-1 < Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["inArray"])(values[0], this.cmdsWithParameters) ? ' ' : ''));
				}
			}
		} else {
			this.cmdHistory.unshift(cmdLine);
			this.cmdHistory = __WEBPACK_IMPORTED_MODULE_3_____default.a.uniq(this.cmdHistory);
			this.cmdHistoryShift = 0;

			var _result = this.runCmd(cmd, cmdParts.join(' '), false),
			    h = this.dom.find('.rl-cmd-history-data');

			if (h && h[0]) {
				h.append(__WEBPACK_IMPORTED_MODULE_2_____default()('<div></div>').html(__webpack_require__(/*! Html/Cmds/Main.html */ 160).replace('{{ cmd }}', cmdLine)));
				if (_result) {
					h.append(__WEBPACK_IMPORTED_MODULE_2_____default()('<div></div>').html(_result));
				}

				__WEBPACK_IMPORTED_MODULE_3_____default.a.delay(function () {
					_this.dom.find('.rl-cmd-history').scrollTop(h.height());
				}, 50);
			}
		}

		return true;
	};

	CmdContoller.prototype.onEsc = function onEsc() {
		this.opened(false);
		return false;
	};

	CmdContoller.prototype.onTab = function onTab() {
		this.onCmd(true);
		return false;
	};

	CmdContoller.prototype.onEnter = function onEnter() {
		this.onCmd(false);
		this.cmd('');
		return false;
	};

	CmdContoller.prototype.onKeyDown = function onKeyDown(event) {
		if (event && event.keyCode && !event.metaKey && !event.ctrlKey && !event.shiftKey && 0 < this.cmdHistory.length) {
			var code = __WEBPACK_IMPORTED_MODULE_1_window___default.a.parseInt(event.keyCode, 10);
			if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["EventKeyCode"].Up === code || __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["EventKeyCode"].Down === code) {
				if (this.cmdHistory[this.cmdHistoryShift]) {
					this.cmd(this.cmdHistory[this.cmdHistoryShift]);
					if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["EventKeyCode"].Up === code) {
						this.cmdHistoryShift += 1;
					} else if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["EventKeyCode"].Down === code) {
						this.cmdHistoryShift -= 1;
					}
				} else {
					this.cmdHistoryShift = 0;
				}

				return false;
			}
		}

		return true;
	};

	return CmdContoller;
}();

/**
 * @returns {void}
 */


function bind(dom) {
	if (!contoller) {
		contoller = new CmdContoller(dom);

		__WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].applyBindingAccessorsToNode(dom[0], {
			translatorInit: true,
			template: function template() {
				return { name: 'Cmd' };
			}
		}, contoller);
	}
}

/**
 * @returns {void}
 */
function init() {
	if (null === cmdDom) {
		cmdDom = __WEBPACK_IMPORTED_MODULE_2_____default()('<div></div>');
		cmdDom.appendTo(__WEBPACK_IMPORTED_MODULE_5_Common_Globals__["$body"]);

		bind(cmdDom);
	}
}

/**
 * @returns {void}
 */
function toggle() {
	if (__WEBPACK_IMPORTED_MODULE_9_Storage_Settings__["appSettingsGet"]('allowCmdInterface')) {
		init();

		__WEBPACK_IMPORTED_MODULE_3_____default.a.delay(function () {
			if (contoller) {
				contoller.opened(!contoller.opened());
				if (contoller.opened()) {
					__WEBPACK_IMPORTED_MODULE_3_____default.a.delay(function () {
						if (contoller && contoller.focused) {
							contoller.focused(true);
						}
					}, __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["Magics"].Time50ms);
				}
			}
		}, __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["Magics"].Time50ms);
	}
}

/***/ }),
/* 155 */
/*!**********************************!*\
  !*** ./dev/Html/Cmds/Error.html ***!
  \**********************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

module.exports = "<span class=\"rl-cmd-clr-error\">Command not found:</span> {{ cmd }}"

/***/ }),
/* 156 */
/*!*********************************!*\
  !*** ./dev/Html/Cmds/Help.html ***!
  \*********************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

module.exports = " <span class=\"rl-cmd-clr-info\">commands:</span> {{ commands }}"

/***/ }),
/* 157 */
/*!***************************************!*\
  !*** ./dev/Html/Cmds/ThemeEmpty.html ***!
  \***************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

module.exports = "theme <span class=\"rl-cmd-clr-info\">[{{ themes }}]</span>"

/***/ }),
/* 158 */
/*!**************************************!*\
  !*** ./dev/Html/Cmds/LangEmpty.html ***!
  \**************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

module.exports = "lang <span class=\"rl-cmd-clr-info\">[{{ langs }}]</span>"

/***/ }),
/* 159 */
/*!************************************!*\
  !*** ./dev/Html/Cmds/Version.html ***!
  \************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

module.exports = " <span class=\"rl-cmd-clr-info\">version:</span> {{ version }}"

/***/ }),
/* 160 */
/*!*********************************!*\
  !*** ./dev/Html/Cmds/Main.html ***!
  \*********************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

module.exports = "<span class=\"rl-cmd-clr-success\">&gt;</span> {{ cmd }}"

/***/ }),
/* 161 */
/*!***********************************!*\
  !*** ./dev/Knoin/AbstractBoot.js ***!
  \***********************************/
/*! exports provided: AbstractBoot */
/*! exports used: AbstractBoot */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AbstractBoot; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);


var AbstractBoot = function () {
	function AbstractBoot() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, AbstractBoot);
	}

	AbstractBoot.prototype.bootstart = function bootstart() {/* no-empty */};

	return AbstractBoot;
}();

/***/ }),
/* 162 */
/*!**************************************!*\
  !*** ./dev/Component/SaveTrigger.js ***!
  \**************************************/
/*! exports provided: default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 18);








var SaveTriggerComponent = function (_AbstractComponent) {
	__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(SaveTriggerComponent, _AbstractComponent);

	/**
  * @param {Object} params
  */
	function SaveTriggerComponent(params) {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, SaveTriggerComponent);

		var _this = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractComponent.call(this));

		_this.element = params.element || null;
		_this.value = params.value && params.value.subscribe ? params.value : null;

		if (_this.element) {
			if (_this.value) {
				_this.element.css('display', 'inline-block');

				if (params.verticalAlign) {
					_this.element.css('vertical-align', params.verticalAlign);
				}

				_this.setState(_this.value());

				_this.disposable.push(_this.value.subscribe(_this.setState, _this));
			} else {
				_this.element.hide();
			}
		}
		return _this;
	}

	SaveTriggerComponent.prototype.setState = function setState(value) {

		switch (Object(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["pInt"])(value)) {
			case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["SaveSettingsStep"].TrueResult:
				this.element.find('.animated,.error').hide().removeClass('visible').end().find('.success').show().addClass('visible');
				break;
			case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["SaveSettingsStep"].FalseResult:
				this.element.find('.animated,.success').hide().removeClass('visible').end().find('.error').show().addClass('visible');
				break;
			case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["SaveSettingsStep"].Animate:
				this.element.find('.error,.success').hide().removeClass('visible').end().find('.animated').show().addClass('visible');
				break;
			case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["SaveSettingsStep"].Idle:
			default:
				this.element.find('.animated').hide().end().find('.error,.success').removeClass('visible');
				break;
		}
	};

	return SaveTriggerComponent;
}(__WEBPACK_IMPORTED_MODULE_5_Component_Abstract__["a" /* AbstractComponent */]);

/* harmony default export */ __webpack_exports__["default"] = (Object(__WEBPACK_IMPORTED_MODULE_5_Component_Abstract__["b" /* componentExportHelper */])(SaveTriggerComponent, 'SaveTriggerComponent'));

/***/ }),
/* 163 */
/*!********************************!*\
  !*** ./dev/Component/Input.js ***!
  \********************************/
/*! exports provided: default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 18);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Component_AbstractInput__ = __webpack_require__(/*! Component/AbstractInput */ 54);







var InputComponent = function (_AbstractInput) {
  __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(InputComponent, _AbstractInput);

  function InputComponent() {
    __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, InputComponent);

    return __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractInput.apply(this, arguments));
  }

  return InputComponent;
}(__WEBPACK_IMPORTED_MODULE_4_Component_AbstractInput__["a" /* AbstractInput */]);

/* harmony default export */ __webpack_exports__["default"] = (Object(__WEBPACK_IMPORTED_MODULE_3_Component_Abstract__["b" /* componentExportHelper */])(InputComponent, 'InputComponent'));

/***/ }),
/* 164 */
/*!*********************************!*\
  !*** ./dev/Component/Select.js ***!
  \*********************************/
/*! exports provided: default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 18);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Component_AbstractInput__ = __webpack_require__(/*! Component/AbstractInput */ 54);









var SelectComponent = function (_AbstractInput) {
	__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(SelectComponent, _AbstractInput);

	/**
  * @param {Object} params
  */
	function SelectComponent(params) {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, SelectComponent);

		var _this = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractInput.call(this, params));

		_this.options = params.options || '';

		_this.optionsText = params.optionsText || null;
		_this.optionsValue = params.optionsValue || null;
		_this.optionsCaption = params.optionsCaption || null;

		if (_this.optionsCaption) {
			_this.optionsCaption = Object(__WEBPACK_IMPORTED_MODULE_3_Common_Translator__["i18n"])(_this.optionsCaption);
		}

		_this.defautOptionsAfterRender = __WEBPACK_IMPORTED_MODULE_4_Common_Utils__["defautOptionsAfterRender"];
		return _this;
	}

	return SelectComponent;
}(__WEBPACK_IMPORTED_MODULE_6_Component_AbstractInput__["a" /* AbstractInput */]);

/* harmony default export */ __webpack_exports__["default"] = (Object(__WEBPACK_IMPORTED_MODULE_5_Component_Abstract__["b" /* componentExportHelper */])(SelectComponent, 'SelectComponent'));

/***/ }),
/* 165 */
/*!********************************!*\
  !*** ./dev/Component/Radio.js ***!
  \********************************/
/*! exports provided: default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 18);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Component_AbstracRadio__ = __webpack_require__(/*! Component/AbstracRadio */ 166);







var RadioComponent = function (_AbstracRadio) {
  __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(RadioComponent, _AbstracRadio);

  function RadioComponent() {
    __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, RadioComponent);

    return __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstracRadio.apply(this, arguments));
  }

  return RadioComponent;
}(__WEBPACK_IMPORTED_MODULE_4_Component_AbstracRadio__["a" /* AbstracRadio */]);

/* harmony default export */ __webpack_exports__["default"] = (Object(__WEBPACK_IMPORTED_MODULE_3_Component_Abstract__["b" /* componentExportHelper */])(RadioComponent, 'RadioComponent'));

/***/ }),
/* 166 */
/*!***************************************!*\
  !*** ./dev/Component/AbstracRadio.js ***!
  \***************************************/
/*! exports provided: AbstracRadio, default */
/*! exports used: AbstracRadio */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AbstracRadio; });
/* unused harmony export default */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 18);









var AbstracRadio = function (_AbstractComponent) {
	__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(AbstracRadio, _AbstractComponent);

	/**
  * @param {Object} params
  */
	function AbstracRadio(params) {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, AbstracRadio);

		var _this = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractComponent.call(this));

		_this.values = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observableArray([]);

		_this.value = params.value;
		if (Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isUnd"])(_this.value) || !_this.value.subscribe) {
			_this.value = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable('');
		}

		_this.inline = Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isUnd"])(params.inline) ? false : params.inline;
		_this.readOnly = Object(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isUnd"])(params.readOnly) ? false : !!params.readOnly;

		if (params.values) {
			_this.values(__WEBPACK_IMPORTED_MODULE_3_____default.a.map(params.values, function (label, value) {
				return { label: label, value: value };
			}));
		}

		_this.click = __WEBPACK_IMPORTED_MODULE_3_____default.a.bind(_this.click, _this);
		return _this;
	}

	AbstracRadio.prototype.click = function click(value) {
		if (!this.readOnly && value) {
			this.value(value.value);
		}
	};

	return AbstracRadio;
}(__WEBPACK_IMPORTED_MODULE_6_Component_Abstract__["a" /* AbstractComponent */]);



/***/ }),
/* 167 */
/*!***********************************!*\
  !*** ./dev/Component/TextArea.js ***!
  \***********************************/
/*! exports provided: default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 18);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Component_AbstractInput__ = __webpack_require__(/*! Component/AbstractInput */ 54);








var DEFAULT_ROWS = 5;

var TextAreaComponent = function (_AbstractInput) {
	__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(TextAreaComponent, _AbstractInput);

	/**
  * @param {Object} params
  */
	function TextAreaComponent(params) {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, TextAreaComponent);

		var _this = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractInput.call(this, params));

		_this.rows = params.rows || DEFAULT_ROWS;
		_this.spellcheck = Object(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["isUnd"])(params.spellcheck) ? false : !!params.spellcheck;
		return _this;
	}

	return TextAreaComponent;
}(__WEBPACK_IMPORTED_MODULE_5_Component_AbstractInput__["a" /* AbstractInput */]);

/* harmony default export */ __webpack_exports__["default"] = (Object(__WEBPACK_IMPORTED_MODULE_4_Component_Abstract__["b" /* componentExportHelper */])(TextAreaComponent, 'TextAreaComponent'));

/***/ }),
/* 168 */
/*!*******************************!*\
  !*** ./dev/Component/Date.js ***!
  \*******************************/
/*! exports provided: default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 18);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Component_AbstractInput__ = __webpack_require__(/*! Component/AbstractInput */ 54);







var DateComponent = function (_AbstractInput) {
  __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(DateComponent, _AbstractInput);

  function DateComponent() {
    __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, DateComponent);

    return __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractInput.apply(this, arguments));
  }

  return DateComponent;
}(__WEBPACK_IMPORTED_MODULE_4_Component_AbstractInput__["a" /* AbstractInput */]);

/* harmony default export */ __webpack_exports__["default"] = (Object(__WEBPACK_IMPORTED_MODULE_3_Component_Abstract__["b" /* componentExportHelper */])(DateComponent, 'DateComponent'));

/***/ }),
/* 169 */
/*!*********************************!*\
  !*** ./dev/Component/Script.js ***!
  \*********************************/
/*! exports provided: default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3____ = __webpack_require__(/*! $ */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 18);







var ScriptComponent = function (_AbstractComponent) {
	__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(ScriptComponent, _AbstractComponent);

	/**
  * @param {Object} params
  */
	function ScriptComponent(params) {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, ScriptComponent);

		var _this = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractComponent.call(this));

		if (params.component && params.component.templateNodes && params.element && params.element[0] && params.element[0].outerHTML) {
			var script = params.element[0].outerHTML;
			script = !script ? '' : script.replace(/<x-script/i, '<script').replace(/<b><\/b><\/x-script>/i, '</script>');

			if (script) {
				params.element.text('');
				params.element.replaceWith(__WEBPACK_IMPORTED_MODULE_3_____default()(script).text(params.component.templateNodes[0] && params.component.templateNodes[0].nodeValue ? params.component.templateNodes[0].nodeValue : ''));
			} else {
				params.element.remove();
			}
		}
		return _this;
	}

	return ScriptComponent;
}(__WEBPACK_IMPORTED_MODULE_4_Component_Abstract__["a" /* AbstractComponent */]);

/* harmony default export */ __webpack_exports__["default"] = (Object(__WEBPACK_IMPORTED_MODULE_4_Component_Abstract__["b" /* componentExportHelper */])(ScriptComponent, 'ScriptComponent'));

/***/ }),
/* 170 */
/*!**************************************************!*\
  !*** ./dev/Component/MaterialDesign/Checkbox.js ***!
  \**************************************************/
/*! exports provided: default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 18);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Component_AbstracCheckbox__ = __webpack_require__(/*! Component/AbstracCheckbox */ 96);









var CheckboxMaterialDesignComponent = function (_AbstracCheckbox) {
	__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(CheckboxMaterialDesignComponent, _AbstracCheckbox);

	/**
  * @param {Object} params
  */
	function CheckboxMaterialDesignComponent(params) {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, CheckboxMaterialDesignComponent);

		var _this = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstracCheckbox.call(this, params));

		_this.animationBox = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false).extend({ falseTimeout: 200 });
		_this.animationCheckmark = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false).extend({ falseTimeout: 200 });

		_this.animationBoxSetTrue = __WEBPACK_IMPORTED_MODULE_3_____default.a.bind(_this.animationBoxSetTrue, _this);
		_this.animationCheckmarkSetTrue = __WEBPACK_IMPORTED_MODULE_3_____default.a.bind(_this.animationCheckmarkSetTrue, _this);

		_this.disposable.push(_this.value.subscribe(function (value) {
			_this.triggerAnimation(value);
		}, _this));
		return _this;
	}

	CheckboxMaterialDesignComponent.prototype.animationBoxSetTrue = function animationBoxSetTrue() {
		this.animationBox(true);
	};

	CheckboxMaterialDesignComponent.prototype.animationCheckmarkSetTrue = function animationCheckmarkSetTrue() {
		this.animationCheckmark(true);
	};

	CheckboxMaterialDesignComponent.prototype.triggerAnimation = function triggerAnimation(box) {
		if (box) {
			this.animationBoxSetTrue();
			__WEBPACK_IMPORTED_MODULE_3_____default.a.delay(this.animationCheckmarkSetTrue, 200);
		} else {
			this.animationCheckmarkSetTrue();
			__WEBPACK_IMPORTED_MODULE_3_____default.a.delay(this.animationBoxSetTrue, 200);
		}
	};

	return CheckboxMaterialDesignComponent;
}(__WEBPACK_IMPORTED_MODULE_6_Component_AbstracCheckbox__["a" /* AbstracCheckbox */]);

/* harmony default export */ __webpack_exports__["default"] = (Object(__WEBPACK_IMPORTED_MODULE_5_Component_Abstract__["b" /* componentExportHelper */])(CheckboxMaterialDesignComponent, 'CheckboxMaterialDesignComponent'));

/***/ }),
/* 171 */,
/* 172 */,
/* 173 */
/*!*************************!*\
  !*** ./dev/App/User.js ***!
  \*************************/
/*! exports provided: default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5____ = __webpack_require__(/*! $ */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_progressJs__ = __webpack_require__(/*! progressJs */ 83);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_progressJs___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_progressJs__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Common_Consts__ = __webpack_require__(/*! Common/Consts */ 20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_Common_Plugins__ = __webpack_require__(/*! Common/Plugins */ 33);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_Common_Momentor__ = __webpack_require__(/*! Common/Momentor */ 40);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13_Common_Cache__ = __webpack_require__(/*! Common/Cache */ 27);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14_Common_Links__ = __webpack_require__(/*! Common/Links */ 14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15_Common_Events__ = __webpack_require__(/*! Common/Events */ 37);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_16_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_17_Stores_Social__ = __webpack_require__(/*! Stores/Social */ 56);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_18_Stores_User_App__ = __webpack_require__(/*! Stores/User/App */ 34);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_19_Stores_User_Settings__ = __webpack_require__(/*! Stores/User/Settings */ 41);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_20_Stores_User_Notification__ = __webpack_require__(/*! Stores/User/Notification */ 145);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_21_Stores_User_Account__ = __webpack_require__(/*! Stores/User/Account */ 47);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_22_Stores_User_Contact__ = __webpack_require__(/*! Stores/User/Contact */ 147);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_23_Stores_User_Identity__ = __webpack_require__(/*! Stores/User/Identity */ 98);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_24_Stores_User_Template__ = __webpack_require__(/*! Stores/User/Template */ 174);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__ = __webpack_require__(/*! Stores/User/Folder */ 38);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_26_Stores_User_Pgp__ = __webpack_require__(/*! Stores/User/Pgp */ 53);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__ = __webpack_require__(/*! Stores/User/Message */ 45);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_28_Stores_User_Quota__ = __webpack_require__(/*! Stores/User/Quota */ 177);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_29_Storage_Client__ = __webpack_require__(/*! Storage/Client */ 93);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_30_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_31_Storage_RainLoop__ = __webpack_require__(/*! Storage/RainLoop */ 97);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__ = __webpack_require__(/*! Remote/User/Ajax */ 17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_33_Promises_User_Ajax__ = __webpack_require__(/*! Promises/User/Ajax */ 94);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_34_Model_Email__ = __webpack_require__(/*! Model/Email */ 44);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_35_Model_Account__ = __webpack_require__(/*! Model/Account */ 224);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_36_Model_Identity__ = __webpack_require__(/*! Model/Identity */ 225);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_37_Model_Template__ = __webpack_require__(/*! Model/Template */ 226);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_38_Model_OpenPgpKey__ = __webpack_require__(/*! Model/OpenPgpKey */ 227);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_39_Screen_User_Login__ = __webpack_require__(/*! Screen/User/Login */ 228);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_40_Screen_User_MailBox__ = __webpack_require__(/*! Screen/User/MailBox */ 230);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_41_Screen_User_Settings__ = __webpack_require__(/*! Screen/User/Settings */ 242);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_42_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_43_App_Abstract__ = __webpack_require__(/*! App/Abstract */ 152);





















































// import {AboutUserScreen} from 'Screen/User/About';








var AppUser = function (_AbstractApp) {
	__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(AppUser, _AbstractApp);

	function AppUser() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, AppUser);

		var _this = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractApp.call(this, __WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */]));

		_this.moveCache = {};

		_this.quotaDebounce = __WEBPACK_IMPORTED_MODULE_4_____default.a.debounce(_this.quota, __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Magics"].Time30s);
		_this.moveOrDeleteResponseHelper = __WEBPACK_IMPORTED_MODULE_4_____default.a.bind(_this.moveOrDeleteResponseHelper, _this);

		_this.messagesMoveTrigger = __WEBPACK_IMPORTED_MODULE_4_____default.a.debounce(_this.messagesMoveTrigger, 500);

		__WEBPACK_IMPORTED_MODULE_3_window___default.a.setInterval(function () {
			return __WEBPACK_IMPORTED_MODULE_15_Common_Events__["a" /* pub */]('interval.30s');
		}, __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Magics"].Time30s);
		__WEBPACK_IMPORTED_MODULE_3_window___default.a.setInterval(function () {
			return __WEBPACK_IMPORTED_MODULE_15_Common_Events__["a" /* pub */]('interval.1m');
		}, __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Magics"].Time1m);
		__WEBPACK_IMPORTED_MODULE_3_window___default.a.setInterval(function () {
			return __WEBPACK_IMPORTED_MODULE_15_Common_Events__["a" /* pub */]('interval.2m');
		}, __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Magics"].Time2m);
		__WEBPACK_IMPORTED_MODULE_3_window___default.a.setInterval(function () {
			return __WEBPACK_IMPORTED_MODULE_15_Common_Events__["a" /* pub */]('interval.3m');
		}, __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Magics"].Time3m);
		__WEBPACK_IMPORTED_MODULE_3_window___default.a.setInterval(function () {
			return __WEBPACK_IMPORTED_MODULE_15_Common_Events__["a" /* pub */]('interval.5m');
		}, __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Magics"].Time5m);
		__WEBPACK_IMPORTED_MODULE_3_window___default.a.setInterval(function () {
			return __WEBPACK_IMPORTED_MODULE_15_Common_Events__["a" /* pub */]('interval.10m');
		}, __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Magics"].Time10m);
		__WEBPACK_IMPORTED_MODULE_3_window___default.a.setInterval(function () {
			return __WEBPACK_IMPORTED_MODULE_15_Common_Events__["a" /* pub */]('interval.15m');
		}, __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Magics"].Time15m);
		__WEBPACK_IMPORTED_MODULE_3_window___default.a.setInterval(function () {
			return __WEBPACK_IMPORTED_MODULE_15_Common_Events__["a" /* pub */]('interval.20m');
		}, __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Magics"].Time20m);

		__WEBPACK_IMPORTED_MODULE_3_window___default.a.setTimeout(function () {
			return __WEBPACK_IMPORTED_MODULE_3_window___default.a.setInterval(function () {
				return __WEBPACK_IMPORTED_MODULE_15_Common_Events__["a" /* pub */]('interval.2m-after5m');
			}, __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Magics"].Time2m);
		}, __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Magics"].Time5m);
		__WEBPACK_IMPORTED_MODULE_3_window___default.a.setTimeout(function () {
			return __WEBPACK_IMPORTED_MODULE_3_window___default.a.setInterval(function () {
				return __WEBPACK_IMPORTED_MODULE_15_Common_Events__["a" /* pub */]('interval.5m-after5m');
			}, __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Magics"].Time5m);
		}, __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Magics"].Time5m);
		__WEBPACK_IMPORTED_MODULE_3_window___default.a.setTimeout(function () {
			return __WEBPACK_IMPORTED_MODULE_3_window___default.a.setInterval(function () {
				return __WEBPACK_IMPORTED_MODULE_15_Common_Events__["a" /* pub */]('interval.10m-after5m');
			}, __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Magics"].Time10m);
		}, __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Magics"].Time5m);

		__WEBPACK_IMPORTED_MODULE_5_____default.a.wakeUp(function () {
			if (Object(__WEBPACK_IMPORTED_MODULE_31_Storage_RainLoop__["a" /* checkTimestamp */])()) {
				_this.reload();
			}

			__WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */].jsVersion(function (sResult, oData) {
				if (__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["StorageResultType"].Success === sResult && oData && !oData.Result) {
					_this.reload();
				}
			}, __WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["appSettingsGet"]('version'));
		}, {}, __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Magics"].Time60m);

		if (Object(__WEBPACK_IMPORTED_MODULE_31_Storage_RainLoop__["a" /* checkTimestamp */])()) {
			_this.reload();
		}

		if (__WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["settingsGet"]('UserBackgroundHash')) {
			__WEBPACK_IMPORTED_MODULE_4_____default.a.delay(function () {
				__WEBPACK_IMPORTED_MODULE_5_____default()('#rl-bg').attr('style', 'background-image: none !important;').backstretch(Object(__WEBPACK_IMPORTED_MODULE_14_Common_Links__["J" /* userBackground */])(__WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["settingsGet"]('UserBackgroundHash')), {
					fade: __WEBPACK_IMPORTED_MODULE_9_Common_Globals__["bAnimationSupported"] ? __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Magics"].Time1s : 0,
					centeredX: true,
					centeredY: true
				}).removeAttr('style');
			}, __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Magics"].Time1s);
		}

		_this.socialUsers = __WEBPACK_IMPORTED_MODULE_4_____default.a.bind(_this.socialUsers, _this);
		return _this;
	}

	AppUser.prototype.remote = function remote() {
		return __WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */];
	};

	AppUser.prototype.reload = function reload() {
		if (__WEBPACK_IMPORTED_MODULE_3_window___default.a.parent && !!__WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["appSettingsGet"]('inIframe')) {
			__WEBPACK_IMPORTED_MODULE_3_window___default.a.parent.location.reload();
		} else {
			__WEBPACK_IMPORTED_MODULE_3_window___default.a.location.reload();
		}
	};

	AppUser.prototype.reloadFlagsCurrentMessageListAndMessageFromCache = function reloadFlagsCurrentMessageListAndMessageFromCache() {
		__WEBPACK_IMPORTED_MODULE_4_____default.a.each(__WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].messageList(), function (message) {
			Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["n" /* initMessageFlagsFromCache */])(message);
		});
		Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["n" /* initMessageFlagsFromCache */])(__WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].message());
	};

	/**
  * @param {boolean=} bDropPagePosition = false
  * @param {boolean=} bDropCurrenFolderCache = false
  */


	AppUser.prototype.reloadMessageList = function reloadMessageList() {
		var bDropPagePosition = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
		var bDropCurrenFolderCache = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;


		var iOffset = (__WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].messageListPage() - 1) * __WEBPACK_IMPORTED_MODULE_19_Stores_User_Settings__["a" /* default */].messagesPerPage();

		if (bDropCurrenFolderCache) {
			Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["q" /* setFolderHash */])(__WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].currentFolderFullNameRaw(), '');
		}

		if (bDropPagePosition) {
			__WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].messageListPage(1);
			__WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].messageListPageBeforeThread(1);
			iOffset = 0;

			Object(__WEBPACK_IMPORTED_MODULE_42_Knoin_Knoin__["setHash"])(Object(__WEBPACK_IMPORTED_MODULE_14_Common_Links__["o" /* mailBox */])(__WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].currentFolderFullNameHash(), __WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].messageListPage(), __WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].messageListSearch(), __WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].messageListThreadUid()), true, true);
		}

		__WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].messageListLoading(true);
		__WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */].messageList(function (sResult, oData, bCached) {

			if (__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["StorageResultType"].Success === sResult && oData && oData.Result) {
				__WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].messageListError('');
				__WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].messageListLoading(false);

				__WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].setMessageList(oData, bCached);
			} else if (__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["StorageResultType"].Unload === sResult) {
				__WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].messageListError('');
				__WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].messageListLoading(false);
			} else if (__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["StorageResultType"].Abort !== sResult) {
				__WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].messageList([]);
				__WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].messageListLoading(false);
				__WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].messageListError(oData && oData.ErrorCode ? Object(__WEBPACK_IMPORTED_MODULE_16_Common_Translator__["getNotification"])(oData.ErrorCode) : Object(__WEBPACK_IMPORTED_MODULE_16_Common_Translator__["i18n"])('NOTIFICATIONS/CANT_GET_MESSAGE_LIST'));
			}
		}, __WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].currentFolderFullNameRaw(), iOffset, __WEBPACK_IMPORTED_MODULE_19_Stores_User_Settings__["a" /* default */].messagesPerPage(), __WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].messageListSearch(), __WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].messageListThreadUid());
	};

	AppUser.prototype.recacheInboxMessageList = function recacheInboxMessageList() {
		__WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */].messageList(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["noop"], Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["h" /* getFolderInboxName */])(), 0, __WEBPACK_IMPORTED_MODULE_19_Stores_User_Settings__["a" /* default */].messagesPerPage(), '', '', true);
	};

	/**
  * @param {Function} fResultFunc
  * @returns {boolean}
  */


	AppUser.prototype.contactsSync = function contactsSync(fResultFunc) {

		var oContacts = __WEBPACK_IMPORTED_MODULE_22_Stores_User_Contact__["a" /* default */].contacts;
		if (oContacts.importing() || oContacts.syncing() || !__WEBPACK_IMPORTED_MODULE_22_Stores_User_Contact__["a" /* default */].enableContactsSync() || !__WEBPACK_IMPORTED_MODULE_22_Stores_User_Contact__["a" /* default */].allowContactsSync()) {
			return false;
		}

		oContacts.syncing(true);

		__WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */].contactsSync(function (sResult, oData) {

			oContacts.syncing(false);

			if (fResultFunc) {
				fResultFunc(sResult, oData);
			}
		});

		return true;
	};

	AppUser.prototype.messagesMoveTrigger = function messagesMoveTrigger() {
		var _this2 = this;

		var sTrashFolder = __WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].trashFolder(),
		    sSpamFolder = __WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].spamFolder();

		__WEBPACK_IMPORTED_MODULE_4_____default.a.each(this.moveCache, function (item) {

			var isSpam = sSpamFolder === item.To,
			    isTrash = sTrashFolder === item.To,
			    isHam = !isSpam && sSpamFolder === item.From && Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["h" /* getFolderInboxName */])() === item.To;

			__WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */].messagesMove(_this2.moveOrDeleteResponseHelper, item.From, item.To, item.Uid, isSpam ? 'SPAM' : isHam ? 'HAM' : '', isSpam || isTrash);
		});

		this.moveCache = {};
	};

	AppUser.prototype.messagesMoveHelper = function messagesMoveHelper(fromFolderFullNameRaw, toFolderFullNameRaw, uidsForMove) {

		var hash = '$$' + fromFolderFullNameRaw + '$$' + toFolderFullNameRaw + '$$';
		if (!this.moveCache[hash]) {
			this.moveCache[hash] = {
				From: fromFolderFullNameRaw,
				To: toFolderFullNameRaw,
				Uid: []
			};
		}

		this.moveCache[hash].Uid = __WEBPACK_IMPORTED_MODULE_4_____default.a.union(this.moveCache[hash].Uid, uidsForMove);
		this.messagesMoveTrigger();
	};

	AppUser.prototype.messagesCopyHelper = function messagesCopyHelper(sFromFolderFullNameRaw, sToFolderFullNameRaw, aUidForCopy) {
		__WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */].messagesCopy(this.moveOrDeleteResponseHelper, sFromFolderFullNameRaw, sToFolderFullNameRaw, aUidForCopy);
	};

	AppUser.prototype.messagesDeleteHelper = function messagesDeleteHelper(sFromFolderFullNameRaw, aUidForRemove) {
		__WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */].messagesDelete(this.moveOrDeleteResponseHelper, sFromFolderFullNameRaw, aUidForRemove);
	};

	AppUser.prototype.moveOrDeleteResponseHelper = function moveOrDeleteResponseHelper(sResult, oData) {

		if (__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["StorageResultType"].Success === sResult && __WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].currentFolder()) {
			if (oData && Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isArray"])(oData.Result) && 2 === oData.Result.length) {
				Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["q" /* setFolderHash */])(oData.Result[0], oData.Result[1]);
			} else {
				Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["q" /* setFolderHash */])(__WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].currentFolderFullNameRaw(), '');

				if (oData && -1 < Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["inArray"])(oData.ErrorCode, [__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Notification"].CantMoveMessage, __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Notification"].CantCopyMessage])) {
					__WEBPACK_IMPORTED_MODULE_3_window___default.a.alert(Object(__WEBPACK_IMPORTED_MODULE_16_Common_Translator__["getNotification"])(oData.ErrorCode));
				}
			}

			this.reloadMessageList(0 === __WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].messageList().length);
			this.quotaDebounce();
		}
	};

	/**
  * @param {string} sFromFolderFullNameRaw
  * @param {Array} aUidForRemove
  */


	AppUser.prototype.deleteMessagesFromFolderWithoutCheck = function deleteMessagesFromFolderWithoutCheck(sFromFolderFullNameRaw, aUidForRemove) {
		this.messagesDeleteHelper(sFromFolderFullNameRaw, aUidForRemove);
		__WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].removeMessagesFromList(sFromFolderFullNameRaw, aUidForRemove);
	};

	/**
  * @param {number} iDeleteType
  * @param {string} sFromFolderFullNameRaw
  * @param {Array} aUidForRemove
  * @param {boolean=} bUseFolder = true
  */


	AppUser.prototype.deleteMessagesFromFolder = function deleteMessagesFromFolder(iDeleteType, sFromFolderFullNameRaw, aUidForRemove, bUseFolder) {
		var _this3 = this;

		var oMoveFolder = null,
		    nSetSystemFoldersNotification = null;

		switch (iDeleteType) {
			case __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["FolderType"].Spam:
				oMoveFolder = Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["e" /* getFolderFromCacheList */])(__WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].spamFolder());
				nSetSystemFoldersNotification = __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["SetSystemFoldersNotification"].Spam;
				break;
			case __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["FolderType"].NotSpam:
				oMoveFolder = Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["e" /* getFolderFromCacheList */])(Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["h" /* getFolderInboxName */])());
				break;
			case __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["FolderType"].Trash:
				oMoveFolder = Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["e" /* getFolderFromCacheList */])(__WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].trashFolder());
				nSetSystemFoldersNotification = __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["SetSystemFoldersNotification"].Trash;
				break;
			case __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["FolderType"].Archive:
				oMoveFolder = Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["e" /* getFolderFromCacheList */])(__WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].archiveFolder());
				nSetSystemFoldersNotification = __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["SetSystemFoldersNotification"].Archive;
				break;
			// no default
		}

		bUseFolder = Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isUnd"])(bUseFolder) ? true : !!bUseFolder;
		if (bUseFolder) {
			if (__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["FolderType"].Spam === iDeleteType && __WEBPACK_IMPORTED_MODULE_10_Common_Consts__["r" /* UNUSED_OPTION_VALUE */] === __WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].spamFolder() || __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["FolderType"].Trash === iDeleteType && __WEBPACK_IMPORTED_MODULE_10_Common_Consts__["r" /* UNUSED_OPTION_VALUE */] === __WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].trashFolder() || __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["FolderType"].Archive === iDeleteType && __WEBPACK_IMPORTED_MODULE_10_Common_Consts__["r" /* UNUSED_OPTION_VALUE */] === __WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].archiveFolder()) {
				bUseFolder = false;
			}
		}

		if (!oMoveFolder && bUseFolder) {
			Object(__WEBPACK_IMPORTED_MODULE_42_Knoin_Knoin__["showScreenPopup"])(__webpack_require__(/*! View/Popup/FolderSystem */ 100), [nSetSystemFoldersNotification]);
		} else if (!bUseFolder || __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["FolderType"].Trash === iDeleteType && (sFromFolderFullNameRaw === __WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].spamFolder() || sFromFolderFullNameRaw === __WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].trashFolder())) {
			Object(__WEBPACK_IMPORTED_MODULE_42_Knoin_Knoin__["showScreenPopup"])(__webpack_require__(/*! View/Popup/Ask */ 77), [Object(__WEBPACK_IMPORTED_MODULE_16_Common_Translator__["i18n"])('POPUPS_ASK/DESC_WANT_DELETE_MESSAGES'), function () {
				_this3.messagesDeleteHelper(sFromFolderFullNameRaw, aUidForRemove);
				__WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].removeMessagesFromList(sFromFolderFullNameRaw, aUidForRemove);
			}]);
		} else if (oMoveFolder) {
			this.messagesMoveHelper(sFromFolderFullNameRaw, oMoveFolder.fullNameRaw, aUidForRemove);
			__WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].removeMessagesFromList(sFromFolderFullNameRaw, aUidForRemove, oMoveFolder.fullNameRaw);
		}
	};

	/**
  * @param {string} sFromFolderFullNameRaw
  * @param {Array} aUidForMove
  * @param {string} sToFolderFullNameRaw
  * @param {boolean=} bCopy = false
  */


	AppUser.prototype.moveMessagesToFolder = function moveMessagesToFolder(sFromFolderFullNameRaw, aUidForMove, sToFolderFullNameRaw, bCopy) {

		if (sFromFolderFullNameRaw !== sToFolderFullNameRaw && Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isArray"])(aUidForMove) && 0 < aUidForMove.length) {
			var oFromFolder = Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["e" /* getFolderFromCacheList */])(sFromFolderFullNameRaw),
			    oToFolder = Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["e" /* getFolderFromCacheList */])(sToFolderFullNameRaw);

			if (oFromFolder && oToFolder) {
				if (Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isUnd"])(bCopy) ? false : !!bCopy) {
					this.messagesCopyHelper(oFromFolder.fullNameRaw, oToFolder.fullNameRaw, aUidForMove);
				} else {
					this.messagesMoveHelper(oFromFolder.fullNameRaw, oToFolder.fullNameRaw, aUidForMove);
				}

				__WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].removeMessagesFromList(oFromFolder.fullNameRaw, aUidForMove, oToFolder.fullNameRaw, bCopy);
				return true;
			}
		}

		return false;
	};

	/**
  * @param {Function=} callback = null
  */


	AppUser.prototype.foldersReload = function foldersReload() {
		var callback = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

		var prom = __WEBPACK_IMPORTED_MODULE_33_Promises_User_Ajax__["a" /* default */].foldersReload(__WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].foldersLoading);
		if (callback) {
			prom.then(function (value) {
				return !!value;
			}).then(callback).catch(function () {
				__WEBPACK_IMPORTED_MODULE_4_____default.a.delay(function () {
					if (callback) {
						callback(false); // eslint-disable-line callback-return
					}
				}, 1);
			});
		}
	};

	AppUser.prototype.foldersPromisesActionHelper = function foldersPromisesActionHelper(promise, errorDefCode) {
		__WEBPACK_IMPORTED_MODULE_33_Promises_User_Ajax__["a" /* default */].abort('Folders').fastResolve(true).then(function () {
			return promise;
		}).then(function () {
			__WEBPACK_IMPORTED_MODULE_33_Promises_User_Ajax__["a" /* default */].foldersReloadWithTimeout(__WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].foldersLoading);
		}, function (errorCode) {
			__WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].folderList.error(Object(__WEBPACK_IMPORTED_MODULE_16_Common_Translator__["getNotification"])(errorCode, '', errorDefCode));
			__WEBPACK_IMPORTED_MODULE_33_Promises_User_Ajax__["a" /* default */].foldersReloadWithTimeout(__WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].foldersLoading);
		});
	};

	AppUser.prototype.reloadOpenPgpKeys = function reloadOpenPgpKeys() {

		if (__WEBPACK_IMPORTED_MODULE_26_Stores_User_Pgp__["a" /* default */].capaOpenPGP()) {
			var keys = [],
			    email = new __WEBPACK_IMPORTED_MODULE_34_Model_Email__["EmailModel"](),
			    openpgpKeyring = __WEBPACK_IMPORTED_MODULE_26_Stores_User_Pgp__["a" /* default */].openpgpKeyring,
			    openpgpKeys = openpgpKeyring ? openpgpKeyring.getAllKeys() : [];

			__WEBPACK_IMPORTED_MODULE_4_____default.a.each(openpgpKeys, function (oItem, iIndex) {
				if (oItem && oItem.primaryKey) {
					var aEmails = [],
					    aUsers = [],
					    primaryUser = oItem.getPrimaryUser(),
					    user = primaryUser && primaryUser.user ? primaryUser.user.userId.userid : oItem.users && oItem.users[0] ? oItem.users[0].userId.userid : '';

					if (oItem.users) {
						__WEBPACK_IMPORTED_MODULE_4_____default.a.each(oItem.users, function (item) {
							if (item.userId) {
								email.clear();
								email.mailsoParse(item.userId.userid);
								if (email.validate()) {
									aEmails.push(email.email);
									aUsers.push(item.userId.userid);
								}
							}
						});
					}

					if (aEmails.length) {
						keys.push(new __WEBPACK_IMPORTED_MODULE_38_Model_OpenPgpKey__["a" /* OpenPgpKeyModel */](iIndex, oItem.primaryKey.getFingerprint(), oItem.primaryKey.getKeyId().toHex().toLowerCase(), __WEBPACK_IMPORTED_MODULE_4_____default.a.uniq(__WEBPACK_IMPORTED_MODULE_4_____default.a.compact(__WEBPACK_IMPORTED_MODULE_4_____default.a.map(oItem.getKeyIds(), function (item) {
							return item && item.toHex ? item.toHex() : null;
						}))), aUsers, aEmails, oItem.isPrivate(), oItem.armor(), user));
					}
				}
			});

			Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRunOnDestroy"])(__WEBPACK_IMPORTED_MODULE_26_Stores_User_Pgp__["a" /* default */].openpgpkeys());
			__WEBPACK_IMPORTED_MODULE_26_Stores_User_Pgp__["a" /* default */].openpgpkeys(keys);
		}
	};

	AppUser.prototype.accountsCounts = function accountsCounts() {
		return false;
		// AccountStore.accounts.loading(true);
		//
		// Remote.accountsCounts((sResult, oData) => {
		//
		// 	AccountStore.accounts.loading(false);
		//
		// 	if (StorageResultType.Success === sResult && oData.Result && oData.Result['Counts'])
		// 	{
		// 		var
		// 			sEmail = AccountStore.email(),
		// 			aAcounts = AccountStore.accounts()
		// 		;
		//
		// 		_.each(oData.Result['Counts'], (oItem) => {
		//
		// 			var oAccount = _.find(aAcounts, (oAccount) => {
		// 				return oAccount && oItem[0] === oAccount.email && sEmail !== oAccount.email;
		// 			});
		//
		// 			if (oAccount)
		// 			{
		// 				oAccount.count(pInt(oItem[1]));
		// 			}
		// 		});
		// 	}
		// });
	};

	AppUser.prototype.accountsAndIdentities = function accountsAndIdentities(bBoot) {
		var _this4 = this;

		__WEBPACK_IMPORTED_MODULE_21_Stores_User_Account__["a" /* default */].accounts.loading(true);
		__WEBPACK_IMPORTED_MODULE_23_Stores_User_Identity__["a" /* default */].identities.loading(true);

		__WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */].accountsAndIdentities(function (sResult, oData) {

			__WEBPACK_IMPORTED_MODULE_21_Stores_User_Account__["a" /* default */].accounts.loading(false);
			__WEBPACK_IMPORTED_MODULE_23_Stores_User_Identity__["a" /* default */].identities.loading(false);

			if (__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["StorageResultType"].Success === sResult && oData.Result) {
				var counts = {},
				    sAccountEmail = __WEBPACK_IMPORTED_MODULE_21_Stores_User_Account__["a" /* default */].email();
				var parentEmail = __WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["settingsGet"]('ParentEmail');

				parentEmail = '' === parentEmail ? sAccountEmail : parentEmail;

				if (Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isArray"])(oData.Result.Accounts)) {
					__WEBPACK_IMPORTED_MODULE_4_____default.a.each(__WEBPACK_IMPORTED_MODULE_21_Stores_User_Account__["a" /* default */].accounts(), function (oAccount) {
						counts[oAccount.email] = oAccount.count();
					});

					Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRunOnDestroy"])(__WEBPACK_IMPORTED_MODULE_21_Stores_User_Account__["a" /* default */].accounts());

					__WEBPACK_IMPORTED_MODULE_21_Stores_User_Account__["a" /* default */].accounts(__WEBPACK_IMPORTED_MODULE_4_____default.a.map(oData.Result.Accounts, function (sValue) {
						return new __WEBPACK_IMPORTED_MODULE_35_Model_Account__["a" /* AccountModel */](sValue, sValue !== parentEmail, counts[sValue] || 0);
					}));
				}

				if (Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isUnd"])(bBoot) ? false : !!bBoot) {
					__WEBPACK_IMPORTED_MODULE_4_____default.a.delay(function () {
						return _this4.accountsCounts();
					}, 1000 * 5);
					__WEBPACK_IMPORTED_MODULE_15_Common_Events__["b" /* sub */]('interval.10m-after5m', function () {
						return _this4.accountsCounts();
					});
				}

				if (Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isArray"])(oData.Result.Identities)) {
					Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRunOnDestroy"])(__WEBPACK_IMPORTED_MODULE_23_Stores_User_Identity__["a" /* default */].identities());

					__WEBPACK_IMPORTED_MODULE_23_Stores_User_Identity__["a" /* default */].identities(__WEBPACK_IMPORTED_MODULE_4_____default.a.map(oData.Result.Identities, function (identityData) {

						var id = Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pString"])(identityData.Id),
						    email = Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pString"])(identityData.Email),
						    identity = new __WEBPACK_IMPORTED_MODULE_36_Model_Identity__["a" /* IdentityModel */](id, email);

						identity.name(Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pString"])(identityData.Name));
						identity.replyTo(Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pString"])(identityData.ReplyTo));
						identity.bcc(Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pString"])(identityData.Bcc));
						identity.signature(Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pString"])(identityData.Signature));
						identity.signatureInsertBefore(!!identityData.SignatureInsertBefore);

						return identity;
					}));
				}
			}
		});
	};

	AppUser.prototype.templates = function templates() {

		__WEBPACK_IMPORTED_MODULE_24_Stores_User_Template__["a" /* default */].templates.loading(true);

		__WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */].templates(function (result, data) {

			__WEBPACK_IMPORTED_MODULE_24_Stores_User_Template__["a" /* default */].templates.loading(false);

			if (__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["StorageResultType"].Success === result && data.Result && Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isArray"])(data.Result.Templates)) {
				Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRunOnDestroy"])(__WEBPACK_IMPORTED_MODULE_24_Stores_User_Template__["a" /* default */].templates());

				__WEBPACK_IMPORTED_MODULE_24_Stores_User_Template__["a" /* default */].templates(__WEBPACK_IMPORTED_MODULE_4_____default.a.compact(__WEBPACK_IMPORTED_MODULE_4_____default.a.map(data.Result.Templates, function (templateData) {
					var template = new __WEBPACK_IMPORTED_MODULE_37_Model_Template__["a" /* TemplateModel */]();
					return template.parse(templateData) ? template : null;
				})));
			}
		});
	};

	AppUser.prototype.quota = function quota() {
		__WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */].quota(function (result, data) {
			if (__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["StorageResultType"].Success === result && data && data.Result && Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isArray"])(data.Result) && 1 < data.Result.length && Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isPosNumeric"])(data.Result[0], true) && Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isPosNumeric"])(data.Result[1], true)) {
				__WEBPACK_IMPORTED_MODULE_28_Stores_User_Quota__["a" /* default */].populateData(Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pInt"])(data.Result[1]), Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pInt"])(data.Result[0]));
			}
		});
	};

	/**
  * @param {string} folder
  * @param {Array=} list = []
  */


	AppUser.prototype.folderInformation = function folderInformation(folder, list) {
		var _this5 = this;

		if ('' !== Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["trim"])(folder)) {
			__WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */].folderInformation(function (result, data) {
				if (__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["StorageResultType"].Success === result) {
					if (data && data.Result && data.Result.Hash && data.Result.Folder) {
						var uid = '',
						    check = false,
						    unreadCountChange = false;

						var folderFromCache = Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["e" /* getFolderFromCacheList */])(data.Result.Folder);
						if (folderFromCache) {
							folderFromCache.interval = Object(__WEBPACK_IMPORTED_MODULE_12_Common_Momentor__["momentNowUnix"])();

							if (data.Result.Hash) {
								Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["q" /* setFolderHash */])(data.Result.Folder, data.Result.Hash);
							}

							if (Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isNormal"])(data.Result.MessageCount)) {
								folderFromCache.messageCountAll(data.Result.MessageCount);
							}

							if (Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isNormal"])(data.Result.MessageUnseenCount)) {
								if (Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pInt"])(folderFromCache.messageCountUnread()) !== Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pInt"])(data.Result.MessageUnseenCount)) {
									unreadCountChange = true;
								}

								folderFromCache.messageCountUnread(data.Result.MessageUnseenCount);
							}

							if (unreadCountChange) {
								Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["c" /* clearMessageFlagsFromCacheByFolder */])(folderFromCache.fullNameRaw);
							}

							if (data.Result.Flags) {
								for (uid in data.Result.Flags) {
									if (Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["has"])(data.Result.Flags, uid)) {
										check = true;
										var flags = data.Result.Flags[uid];
										Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["v" /* storeMessageFlagsToCacheByFolderAndUid */])(folderFromCache.fullNameRaw, uid.toString(), [!flags.IsSeen, !!flags.IsFlagged, !!flags.IsAnswered, !!flags.IsForwarded, !!flags.IsReadReceipt]);
									}
								}

								if (check) {
									_this5.reloadFlagsCurrentMessageListAndMessageFromCache();
								}
							}

							__WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].initUidNextAndNewMessages(folderFromCache.fullNameRaw, data.Result.UidNext, data.Result.NewMessages);

							var hash = Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["g" /* getFolderHash */])(data.Result.Folder);
							if (data.Result.Hash !== hash || '' === hash || unreadCountChange) {
								if (folderFromCache.fullNameRaw === __WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].currentFolderFullNameRaw()) {
									_this5.reloadMessageList();
								} else if (Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["h" /* getFolderInboxName */])() === folderFromCache.fullNameRaw) {
									_this5.recacheInboxMessageList();
								}
							}
						}
					}
				}
			}, folder, list);
		}
	};

	/**
  * @param {boolean=} boot = false
  */


	AppUser.prototype.folderInformationMultiply = function folderInformationMultiply() {
		var _this6 = this;

		var boot = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;


		var folders = __WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].getNextFolderNames();
		if (Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isNonEmptyArray"])(folders)) {
			__WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */].folderInformationMultiply(function (sResult, oData) {
				if (__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["StorageResultType"].Success === sResult) {
					if (oData && oData.Result && oData.Result.List && Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isNonEmptyArray"])(oData.Result.List)) {
						var utc = Object(__WEBPACK_IMPORTED_MODULE_12_Common_Momentor__["momentNowUnix"])();
						__WEBPACK_IMPORTED_MODULE_4_____default.a.each(oData.Result.List, function (item) {

							var hash = Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["g" /* getFolderHash */])(item.Folder),
							    folder = Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["e" /* getFolderFromCacheList */])(item.Folder);
							var unreadCountChange = false;

							if (folder) {
								folder.interval = utc;

								if (item.Hash) {
									Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["q" /* setFolderHash */])(item.Folder, item.Hash);
								}

								if (Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isNormal"])(item.MessageCount)) {
									folder.messageCountAll(item.MessageCount);
								}

								if (Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isNormal"])(item.MessageUnseenCount)) {
									if (Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pInt"])(folder.messageCountUnread()) !== Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pInt"])(item.MessageUnseenCount)) {
										unreadCountChange = true;
									}

									folder.messageCountUnread(item.MessageUnseenCount);
								}

								if (unreadCountChange) {
									Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["c" /* clearMessageFlagsFromCacheByFolder */])(folder.fullNameRaw);
								}

								if (item.Hash !== hash || '' === hash) {
									if (folder.fullNameRaw === __WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].currentFolderFullNameRaw()) {
										_this6.reloadMessageList();
									}
								} else if (unreadCountChange) {
									if (folder.fullNameRaw === __WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].currentFolderFullNameRaw()) {
										var list = __WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].messageList();
										if (Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isNonEmptyArray"])(list)) {
											_this6.folderInformation(folder.fullNameRaw, list);
										}
									}
								}
							}
						});

						if (boot) {
							__WEBPACK_IMPORTED_MODULE_4_____default.a.delay(function () {
								return _this6.folderInformationMultiply(true);
							}, 2000);
						}
					}
				}
			}, folders);
		}
	};

	/**
  * @param {string} sFolderFullNameRaw
  * @param {number} iSetAction
  * @param {Array=} messages = null
  */


	AppUser.prototype.messageListAction = function messageListAction(sFolderFullNameRaw, iSetAction, messages) {

		var folder = null,
		    alreadyUnread = 0,
		    rootUids = [];

		if (Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isUnd"])(messages) || !messages) {
			messages = __WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].messageListChecked();
		}

		rootUids = __WEBPACK_IMPORTED_MODULE_4_____default.a.uniq(__WEBPACK_IMPORTED_MODULE_4_____default.a.compact(__WEBPACK_IMPORTED_MODULE_4_____default.a.map(messages, function (oMessage) {
			return oMessage && oMessage.uid ? oMessage.uid : null;
		})));

		if ('' !== sFolderFullNameRaw && 0 < rootUids.length) {
			switch (iSetAction) {
				case __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["MessageSetAction"].SetSeen:

					__WEBPACK_IMPORTED_MODULE_4_____default.a.each(rootUids, function (sSubUid) {
						alreadyUnread += Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["w" /* storeMessageFlagsToCacheBySetAction */])(sFolderFullNameRaw, sSubUid, iSetAction);
					});

					folder = Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["e" /* getFolderFromCacheList */])(sFolderFullNameRaw);
					if (folder) {
						folder.messageCountUnread(folder.messageCountUnread() - alreadyUnread);
					}

					__WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */].messageSetSeen(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["noop"], sFolderFullNameRaw, rootUids, true);
					break;

				case __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["MessageSetAction"].UnsetSeen:

					__WEBPACK_IMPORTED_MODULE_4_____default.a.each(rootUids, function (sSubUid) {
						alreadyUnread += Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["w" /* storeMessageFlagsToCacheBySetAction */])(sFolderFullNameRaw, sSubUid, iSetAction);
					});

					folder = Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["e" /* getFolderFromCacheList */])(sFolderFullNameRaw);
					if (folder) {
						folder.messageCountUnread(folder.messageCountUnread() - alreadyUnread + rootUids.length);
					}

					__WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */].messageSetSeen(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["noop"], sFolderFullNameRaw, rootUids, false);
					break;

				case __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["MessageSetAction"].SetFlag:

					__WEBPACK_IMPORTED_MODULE_4_____default.a.each(rootUids, function (sSubUid) {
						Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["w" /* storeMessageFlagsToCacheBySetAction */])(sFolderFullNameRaw, sSubUid, iSetAction);
					});

					__WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */].messageSetFlagged(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["noop"], sFolderFullNameRaw, rootUids, true);
					break;

				case __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["MessageSetAction"].UnsetFlag:

					__WEBPACK_IMPORTED_MODULE_4_____default.a.each(rootUids, function (sSubUid) {
						Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["w" /* storeMessageFlagsToCacheBySetAction */])(sFolderFullNameRaw, sSubUid, iSetAction);
					});

					__WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */].messageSetFlagged(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["noop"], sFolderFullNameRaw, rootUids, false);
					break;
				// no default
			}

			this.reloadFlagsCurrentMessageListAndMessageFromCache();
			__WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].message.viewTrigger(!__WEBPACK_IMPORTED_MODULE_27_Stores_User_Message__["a" /* default */].message.viewTrigger());
		}
	};

	AppUser.prototype.googleConnect = function googleConnect() {
		__WEBPACK_IMPORTED_MODULE_3_window___default.a.open(Object(__WEBPACK_IMPORTED_MODULE_14_Common_Links__["B" /* socialGoogle */])(), 'Google', 'left=200,top=100,width=650,height=600,menubar=no,status=no,resizable=yes,scrollbars=yes');
	};

	AppUser.prototype.twitterConnect = function twitterConnect() {
		__WEBPACK_IMPORTED_MODULE_3_window___default.a.open(Object(__WEBPACK_IMPORTED_MODULE_14_Common_Links__["C" /* socialTwitter */])(), 'Twitter', 'left=200,top=100,width=650,height=350,menubar=no,status=no,resizable=yes,scrollbars=yes');
	};

	AppUser.prototype.facebookConnect = function facebookConnect() {
		__WEBPACK_IMPORTED_MODULE_3_window___default.a.open(Object(__WEBPACK_IMPORTED_MODULE_14_Common_Links__["A" /* socialFacebook */])(), 'Facebook', 'left=200,top=100,width=650,height=335,menubar=no,status=no,resizable=yes,scrollbars=yes');
	};

	/**
  * @param {boolean=} fireAllActions = false
  */


	AppUser.prototype.socialUsers = function socialUsers() {
		var fireAllActions = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

		if (true === fireAllActions) {
			__WEBPACK_IMPORTED_MODULE_17_Stores_Social__["a" /* default */].google.loading(true);
			__WEBPACK_IMPORTED_MODULE_17_Stores_Social__["a" /* default */].facebook.loading(true);
			__WEBPACK_IMPORTED_MODULE_17_Stores_Social__["a" /* default */].twitter.loading(true);
		}

		__WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */].socialUsers(function (result, data) {

			if (__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["StorageResultType"].Success === result && data && data.Result) {
				__WEBPACK_IMPORTED_MODULE_17_Stores_Social__["a" /* default */].google.userName(data.Result.Google || '');
				__WEBPACK_IMPORTED_MODULE_17_Stores_Social__["a" /* default */].facebook.userName(data.Result.Facebook || '');
				__WEBPACK_IMPORTED_MODULE_17_Stores_Social__["a" /* default */].twitter.userName(data.Result.Twitter || '');
			} else {
				__WEBPACK_IMPORTED_MODULE_17_Stores_Social__["a" /* default */].google.userName('');
				__WEBPACK_IMPORTED_MODULE_17_Stores_Social__["a" /* default */].facebook.userName('');
				__WEBPACK_IMPORTED_MODULE_17_Stores_Social__["a" /* default */].twitter.userName('');
			}

			__WEBPACK_IMPORTED_MODULE_17_Stores_Social__["a" /* default */].google.loading(false);
			__WEBPACK_IMPORTED_MODULE_17_Stores_Social__["a" /* default */].facebook.loading(false);
			__WEBPACK_IMPORTED_MODULE_17_Stores_Social__["a" /* default */].twitter.loading(false);
		});
	};

	AppUser.prototype.googleDisconnect = function googleDisconnect() {
		__WEBPACK_IMPORTED_MODULE_17_Stores_Social__["a" /* default */].google.loading(true);
		__WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */].googleDisconnect(this.socialUsers);
	};

	AppUser.prototype.facebookDisconnect = function facebookDisconnect() {
		__WEBPACK_IMPORTED_MODULE_17_Stores_Social__["a" /* default */].facebook.loading(true);
		__WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */].facebookDisconnect(this.socialUsers);
	};

	AppUser.prototype.twitterDisconnect = function twitterDisconnect() {
		__WEBPACK_IMPORTED_MODULE_17_Stores_Social__["a" /* default */].twitter.loading(true);
		__WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */].twitterDisconnect(this.socialUsers);
	};

	/**
  * @param {string} query
  * @param {Function} autocompleteCallback
  */


	AppUser.prototype.getAutocomplete = function getAutocomplete(query, autocompleteCallback) {
		__WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */].suggestions(function (result, data) {
			if (__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["StorageResultType"].Success === result && data && Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isArray"])(data.Result)) {
				autocompleteCallback(__WEBPACK_IMPORTED_MODULE_4_____default.a.compact(__WEBPACK_IMPORTED_MODULE_4_____default.a.map(data.Result, function (item) {
					return item && item[0] ? new __WEBPACK_IMPORTED_MODULE_34_Model_Email__["EmailModel"](item[0], item[1]) : null;
				})));
			} else if (__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["StorageResultType"].Abort !== result) {
				autocompleteCallback([]);
			}
		}, query);
	};

	/**
  * @param {string} sFullNameHash
  * @param {boolean} bExpanded
  */


	AppUser.prototype.setExpandedFolder = function setExpandedFolder(sFullNameHash, bExpanded) {
		var aExpandedList = __WEBPACK_IMPORTED_MODULE_29_Storage_Client__["a" /* get */](__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["ClientSideKeyName"].ExpandedFolders);
		if (!Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isArray"])(aExpandedList)) {
			aExpandedList = [];
		}

		if (bExpanded) {
			aExpandedList.push(sFullNameHash);
			aExpandedList = __WEBPACK_IMPORTED_MODULE_4_____default.a.uniq(aExpandedList);
		} else {
			aExpandedList = __WEBPACK_IMPORTED_MODULE_4_____default.a.without(aExpandedList, sFullNameHash);
		}

		__WEBPACK_IMPORTED_MODULE_29_Storage_Client__["b" /* set */](__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["ClientSideKeyName"].ExpandedFolders, aExpandedList);
	};

	AppUser.prototype.initHorizontalLayoutResizer = function initHorizontalLayoutResizer(sClientSideKeyName) {

		var top = null,
		    bottom = null;

		var minHeight = 200,
		    maxHeight = 500,
		    fSetHeight = function fSetHeight(height) {
			if (height) {
				if (top) {
					top.attr('style', 'height:' + height + 'px');
				}

				if (bottom) {
					bottom.attr('style', 'top:' + (55 /* top toolbar */ + height) + 'px');
				}
			}
		},
		    fResizeCreateFunction = function fResizeCreateFunction(event) {
			if (event && event.target) {
				__WEBPACK_IMPORTED_MODULE_5_____default()(event.target).find('.ui-resizable-handle').on('mousedown', function () {
					__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].addClass('rl-resizer');
				}).on('mouseup', function () {
					__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].removeClass('rl-resizer');
				});
			}
		},
		    fResizeStartFunction = function fResizeStartFunction() {
			__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].addClass('rl-resizer');
		},
		    fResizeResizeFunction = __WEBPACK_IMPORTED_MODULE_4_____default.a.debounce(function () {
			__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].addClass('rl-resizer');
		}, 500, true),
		    fResizeStopFunction = function fResizeStopFunction(oEvent, oObject) {
			__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].removeClass('rl-resizer');
			if (oObject && oObject.size && oObject.size.height) {
				__WEBPACK_IMPORTED_MODULE_29_Storage_Client__["b" /* set */](sClientSideKeyName, oObject.size.height);

				fSetHeight(oObject.size.height);

				Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["windowResize"])();
			}
		},
		    oOptions = {
			helper: 'ui-resizable-helper-h',
			minHeight: minHeight,
			maxHeight: maxHeight,
			handles: 's',
			create: fResizeCreateFunction,
			resize: fResizeResizeFunction,
			start: fResizeStartFunction,
			stop: fResizeStopFunction
		},
		    fDisable = function fDisable(bDisable) {
			if (bDisable) {
				if (top && top.hasClass('ui-resizable')) {
					top.resizable('destroy').removeAttr('style');
				}

				if (bottom) {
					bottom.removeAttr('style');
				}
			} else if (__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].hasClass('rl-bottom-preview-pane')) {
				top = __WEBPACK_IMPORTED_MODULE_5_____default()('.b-message-list-wrapper');
				bottom = __WEBPACK_IMPORTED_MODULE_5_____default()('.b-message-view-wrapper');

				if (!top.hasClass('ui-resizable')) {
					top.resizable(oOptions);
				}

				var iHeight = Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pInt"])(__WEBPACK_IMPORTED_MODULE_29_Storage_Client__["a" /* get */](sClientSideKeyName)) || 300;
				fSetHeight(iHeight > minHeight ? iHeight : minHeight);
			}
		};

		fDisable(false);

		__WEBPACK_IMPORTED_MODULE_15_Common_Events__["b" /* sub */]('layout', function (layout) {
			fDisable(__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Layout"].BottomPreview !== layout);
		});
	};

	AppUser.prototype.initVerticalLayoutResizer = function initVerticalLayoutResizer(sClientSideKeyName) {

		var disabledWidth = 60,
		    minWidth = 155,
		    lLeft = __WEBPACK_IMPORTED_MODULE_5_____default()('#rl-left'),
		    right = __WEBPACK_IMPORTED_MODULE_5_____default()('#rl-right'),
		    mLeftWidth = __WEBPACK_IMPORTED_MODULE_29_Storage_Client__["a" /* get */](sClientSideKeyName) || null,
		    fSetWidth = function fSetWidth(iWidth) {
			if (iWidth) {
				Object(__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["leftPanelWidth"])(iWidth);

				__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].removeClass('rl-resizer');

				lLeft.css({
					width: '' + iWidth + 'px'
				});

				right.css({
					left: '' + iWidth + 'px'
				});
			}
		},
		    fDisable = function fDisable(bDisable) {
			if (bDisable) {
				lLeft.resizable('disable');
				fSetWidth(disabledWidth);
			} else {
				lLeft.resizable('enable');
				var width = Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pInt"])(__WEBPACK_IMPORTED_MODULE_29_Storage_Client__["a" /* get */](sClientSideKeyName)) || minWidth;
				fSetWidth(width > minWidth ? width : minWidth);
			}
		},
		    fResizeCreateFunction = function fResizeCreateFunction(event) {
			if (event && event.target) {
				__WEBPACK_IMPORTED_MODULE_5_____default()(event.target).find('.ui-resizable-handle').on('mousedown', function () {
					__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].addClass('rl-resizer');
				}).on('mouseup', function () {
					__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].removeClass('rl-resizer');
				});
			}
		},
		    fResizeResizeFunction = __WEBPACK_IMPORTED_MODULE_4_____default.a.debounce(function () {
			__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].addClass('rl-resizer');
		}, 500, true),
		    fResizeStartFunction = function fResizeStartFunction() {
			__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].addClass('rl-resizer');
		},
		    fResizeStopFunction = function fResizeStopFunction(event, obj) {
			__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].removeClass('rl-resizer');
			if (obj && obj.size && obj.size.width) {
				__WEBPACK_IMPORTED_MODULE_29_Storage_Client__["b" /* set */](sClientSideKeyName, obj.size.width);

				Object(__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["leftPanelWidth"])(obj.size.width);

				right.css({
					left: '' + obj.size.width + 'px'
				});

				lLeft.css({
					position: '',
					top: '',
					left: '',
					height: ''
				});
			}
		};

		if (null !== mLeftWidth) {
			fSetWidth(mLeftWidth > minWidth ? mLeftWidth : minWidth);
		}

		lLeft.resizable({
			helper: 'ui-resizable-helper-w',
			minWidth: minWidth,
			maxWidth: __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Magics"].Size350px,
			handles: 'e',
			create: fResizeCreateFunction,
			resize: fResizeResizeFunction,
			start: fResizeStartFunction,
			stop: fResizeStopFunction
		});

		__WEBPACK_IMPORTED_MODULE_15_Common_Events__["b" /* sub */]('left-panel.off', function () {
			fDisable(true);
		});

		__WEBPACK_IMPORTED_MODULE_15_Common_Events__["b" /* sub */]('left-panel.on', function () {
			fDisable(false);
		});
	};

	AppUser.prototype.logout = function logout() {
		var _this7 = this;

		__WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */].logout(function () {
			_this7.loginAndLogoutReload(false, true, __WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["settingsGet"]('ParentEmail') && 0 < __WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["settingsGet"]('ParentEmail').length);
		});
	};

	AppUser.prototype.bootstartTwoFactorScreen = function bootstartTwoFactorScreen() {
		Object(__WEBPACK_IMPORTED_MODULE_42_Knoin_Knoin__["showScreenPopup"])(__webpack_require__(/*! View/Popup/TwoFactorConfiguration */ 186), [true]);
	};

	AppUser.prototype.bootstartWelcomePopup = function bootstartWelcomePopup(url) {
		Object(__WEBPACK_IMPORTED_MODULE_42_Knoin_Knoin__["showScreenPopup"])(__webpack_require__(/*! View/Popup/WelcomePage */ 264), [url]);
	};

	AppUser.prototype.bootstartLoginScreen = function bootstartLoginScreen() {

		__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].removeClass('rl-user-auth').addClass('rl-user-no-auth');

		var customLoginLink = Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pString"])(__WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["appSettingsGet"]('customLoginLink'));
		if (!customLoginLink) {
			Object(__WEBPACK_IMPORTED_MODULE_42_Knoin_Knoin__["startScreens"])([__WEBPACK_IMPORTED_MODULE_39_Screen_User_Login__["a" /* LoginUserScreen */]]);

			Object(__WEBPACK_IMPORTED_MODULE_11_Common_Plugins__["f" /* runHook */])('rl-start-login-screens');
			__WEBPACK_IMPORTED_MODULE_15_Common_Events__["a" /* pub */]('rl.bootstart-login-screens');
		} else {
			Object(__WEBPACK_IMPORTED_MODULE_42_Knoin_Knoin__["routeOff"])();
			Object(__WEBPACK_IMPORTED_MODULE_42_Knoin_Knoin__["setHash"])(Object(__WEBPACK_IMPORTED_MODULE_14_Common_Links__["w" /* root */])(), true);
			Object(__WEBPACK_IMPORTED_MODULE_42_Knoin_Knoin__["routeOff"])();

			__WEBPACK_IMPORTED_MODULE_4_____default.a.defer(function () {
				__WEBPACK_IMPORTED_MODULE_3_window___default.a.location.href = customLoginLink;
			});
		}
	};

	AppUser.prototype.bootend = function bootend() {
		if (__WEBPACK_IMPORTED_MODULE_6_progressJs___default.a) {
			__WEBPACK_IMPORTED_MODULE_6_progressJs___default.a.set(100).end();
		}
		Object(__WEBPACK_IMPORTED_MODULE_42_Knoin_Knoin__["hideLoading"])();
	};

	AppUser.prototype.bootstart = function bootstart() {
		var _this8 = this;

		_AbstractApp.prototype.bootstart.call(this);

		__WEBPACK_IMPORTED_MODULE_18_Stores_User_App__["a" /* default */].populate();
		__WEBPACK_IMPORTED_MODULE_19_Stores_User_Settings__["a" /* default */].populate();
		__WEBPACK_IMPORTED_MODULE_20_Stores_User_Notification__["a" /* default */].populate();
		__WEBPACK_IMPORTED_MODULE_21_Stores_User_Account__["a" /* default */].populate();
		__WEBPACK_IMPORTED_MODULE_22_Stores_User_Contact__["a" /* default */].populate();

		var contactsSyncInterval = Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pInt"])(__WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["settingsGet"]('ContactsSyncInterval'));

		var jsHash = __WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["appSettingsGet"]('jsHash'),
		    startupUrl = Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pString"])(__WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["settingsGet"]('StartupUrl')),
		    allowGoogle = __WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["settingsGet"]('AllowGoogleSocial'),
		    allowFacebook = __WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["settingsGet"]('AllowFacebookSocial'),
		    allowTwitter = __WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["settingsGet"]('AllowTwitterSocial');

		if (__WEBPACK_IMPORTED_MODULE_6_progressJs___default.a) {
			__WEBPACK_IMPORTED_MODULE_6_progressJs___default.a.set(90);
		}

		__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["leftPanelDisabled"].subscribe(function (value) {
			__WEBPACK_IMPORTED_MODULE_15_Common_Events__["a" /* pub */]('left-panel.' + (value ? 'off' : 'on'));
		});

		this.setWindowTitle('');
		if (__WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["settingsGet"]('Auth')) {
			__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["$html"].addClass('rl-user-auth');

			if (__WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["capa"](__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Capa"].TwoFactor) && __WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["capa"](__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Capa"].TwoFactorForce) && __WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["settingsGet"]('RequireTwoFactor')) {
				this.bootend();
				this.bootstartTwoFactorScreen();
			} else {
				this.setWindowTitle(Object(__WEBPACK_IMPORTED_MODULE_16_Common_Translator__["i18n"])('TITLES/LOADING'));

				// require.ensure([], function() { // require code splitting

				this.foldersReload(function (value) {

					_this8.bootend();

					if (value) {
						if ('' !== startupUrl) {
							Object(__WEBPACK_IMPORTED_MODULE_42_Knoin_Knoin__["routeOff"])();
							Object(__WEBPACK_IMPORTED_MODULE_42_Knoin_Knoin__["setHash"])(Object(__WEBPACK_IMPORTED_MODULE_14_Common_Links__["w" /* root */])(startupUrl), true);
							Object(__WEBPACK_IMPORTED_MODULE_42_Knoin_Knoin__["routeOn"])();
						}

						if (__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["jassl"] && __WEBPACK_IMPORTED_MODULE_3_window___default.a.crypto && __WEBPACK_IMPORTED_MODULE_3_window___default.a.crypto.getRandomValues && __WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["capa"](__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Capa"].OpenPGP)) {
							var openpgpCallback = function openpgpCallback(openpgp) {

								__WEBPACK_IMPORTED_MODULE_26_Stores_User_Pgp__["a" /* default */].openpgp = openpgp;

								if (__WEBPACK_IMPORTED_MODULE_3_window___default.a.Worker) {
									try {
										__WEBPACK_IMPORTED_MODULE_26_Stores_User_Pgp__["a" /* default */].openpgp.initWorker({ path: Object(__WEBPACK_IMPORTED_MODULE_14_Common_Links__["t" /* openPgpWorkerJs */])() });
									} catch (e) {
										Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["log"])(e);
									}
								}

								__WEBPACK_IMPORTED_MODULE_26_Stores_User_Pgp__["a" /* default */].openpgpKeyring = new openpgp.Keyring();
								__WEBPACK_IMPORTED_MODULE_26_Stores_User_Pgp__["a" /* default */].capaOpenPGP(true);

								__WEBPACK_IMPORTED_MODULE_15_Common_Events__["a" /* pub */]('openpgp.init');

								_this8.reloadOpenPgpKeys();
							};

							if (__WEBPACK_IMPORTED_MODULE_3_window___default.a.openpgp) {
								openpgpCallback(__WEBPACK_IMPORTED_MODULE_3_window___default.a.openpgp);
							} else {
								Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["jassl"])(Object(__WEBPACK_IMPORTED_MODULE_14_Common_Links__["s" /* openPgpJs */])()).then(function () {
									if (__WEBPACK_IMPORTED_MODULE_3_window___default.a.openpgp) {
										openpgpCallback(__WEBPACK_IMPORTED_MODULE_3_window___default.a.openpgp);
									}
								});
							}
						} else {
							__WEBPACK_IMPORTED_MODULE_26_Stores_User_Pgp__["a" /* default */].capaOpenPGP(false);
						}

						Object(__WEBPACK_IMPORTED_MODULE_42_Knoin_Knoin__["startScreens"])([__WEBPACK_IMPORTED_MODULE_40_Screen_User_MailBox__["a" /* MailBoxUserScreen */], __WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["capa"](__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Capa"].Settings) ? __WEBPACK_IMPORTED_MODULE_41_Screen_User_Settings__["a" /* SettingsUserScreen */] : null
						// false ? AboutUserScreen : null
						]);

						if (allowGoogle || allowFacebook || allowTwitter) {
							_this8.socialUsers(true);
						}

						__WEBPACK_IMPORTED_MODULE_15_Common_Events__["b" /* sub */]('interval.2m', function () {
							return _this8.folderInformation(Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["h" /* getFolderInboxName */])());
						});
						__WEBPACK_IMPORTED_MODULE_15_Common_Events__["b" /* sub */]('interval.3m', function () {
							var sF = __WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].currentFolderFullNameRaw();
							if (Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["h" /* getFolderInboxName */])() !== sF) {
								_this8.folderInformation(sF);
							}
						});

						__WEBPACK_IMPORTED_MODULE_15_Common_Events__["b" /* sub */]('interval.2m-after5m', function () {
							return _this8.folderInformationMultiply();
						});
						__WEBPACK_IMPORTED_MODULE_15_Common_Events__["b" /* sub */]('interval.15m', function () {
							return _this8.quota();
						});
						__WEBPACK_IMPORTED_MODULE_15_Common_Events__["b" /* sub */]('interval.20m', function () {
							return _this8.foldersReload();
						});

						contactsSyncInterval = 5 <= contactsSyncInterval ? contactsSyncInterval : 20;
						contactsSyncInterval = 320 >= contactsSyncInterval ? contactsSyncInterval : 320;

						__WEBPACK_IMPORTED_MODULE_4_____default.a.delay(function () {
							return _this8.contactsSync();
						}, __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Magics"].Time10s);
						__WEBPACK_IMPORTED_MODULE_4_____default.a.delay(function () {
							return _this8.folderInformationMultiply(true);
						}, __WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Magics"].Time2s);

						__WEBPACK_IMPORTED_MODULE_3_window___default.a.setInterval(function () {
							return _this8.contactsSync();
						}, contactsSyncInterval * 60000 + 5000);

						_this8.accountsAndIdentities(true);

						__WEBPACK_IMPORTED_MODULE_4_____default.a.delay(function () {
							var sF = __WEBPACK_IMPORTED_MODULE_25_Stores_User_Folder__["a" /* default */].currentFolderFullNameRaw();
							if (Object(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["h" /* getFolderInboxName */])() !== sF) {
								_this8.folderInformation(sF);
							}
						}, 1000);

						__WEBPACK_IMPORTED_MODULE_4_____default.a.delay(function () {
							return _this8.quota();
						}, 5000);
						__WEBPACK_IMPORTED_MODULE_4_____default.a.delay(function () {
							return __WEBPACK_IMPORTED_MODULE_32_Remote_User_Ajax__["a" /* default */].appDelayStart(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["noop"]);
						}, 35000);

						__WEBPACK_IMPORTED_MODULE_15_Common_Events__["b" /* sub */]('rl.auto-logout', function () {
							return _this8.logout();
						});

						Object(__WEBPACK_IMPORTED_MODULE_11_Common_Plugins__["f" /* runHook */])('rl-start-user-screens');
						__WEBPACK_IMPORTED_MODULE_15_Common_Events__["a" /* pub */]('rl.bootstart-user-screens');

						if (__WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["settingsGet"]('WelcomePageUrl')) {
							__WEBPACK_IMPORTED_MODULE_4_____default.a.delay(function () {
								return _this8.bootstartWelcomePopup(__WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["settingsGet"]('WelcomePageUrl'));
							}, 1000);
						}

						if (!!__WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["settingsGet"]('AccountSignMe') && __WEBPACK_IMPORTED_MODULE_3_window___default.a.navigator.registerProtocolHandler && __WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["capa"](__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["Capa"].Composer)) {
							__WEBPACK_IMPORTED_MODULE_4_____default.a.delay(function () {
								try {
									__WEBPACK_IMPORTED_MODULE_3_window___default.a.navigator.registerProtocolHandler('mailto', __WEBPACK_IMPORTED_MODULE_3_window___default.a.location.protocol + '//' + __WEBPACK_IMPORTED_MODULE_3_window___default.a.location.host + __WEBPACK_IMPORTED_MODULE_3_window___default.a.location.pathname + '?mailto&to=%s', '' + (__WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["settingsGet"]('Title') || 'RainLoop'));
								} catch (e) {} // eslint-disable-line no-empty

								if (__WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["settingsGet"]('MailToEmail')) {
									Object(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["mailToHelper"])(__WEBPACK_IMPORTED_MODULE_30_Storage_Settings__["settingsGet"]('MailToEmail'), __webpack_require__(/*! View/Popup/Compose */ 43));
								}
							}, 500);
						}

						if (!__WEBPACK_IMPORTED_MODULE_9_Common_Globals__["bMobileDevice"]) {
							__WEBPACK_IMPORTED_MODULE_4_____default.a.defer(function () {
								return _this8.initVerticalLayoutResizer(__WEBPACK_IMPORTED_MODULE_8_Common_Enums__["ClientSideKeyName"].FolderListSize);
							});
						}
					} else {
						_this8.logout();
					}
				});

				// }); // require code splitting
			}
		} else {
			this.bootend();
			this.bootstartLoginScreen();
		}

		if (allowGoogle) {
			__WEBPACK_IMPORTED_MODULE_3_window___default.a['rl_' + jsHash + '_google_service'] = function () {
				__WEBPACK_IMPORTED_MODULE_17_Stores_Social__["a" /* default */].google.loading(true);
				_this8.socialUsers();
			};
		}

		if (allowFacebook) {
			__WEBPACK_IMPORTED_MODULE_3_window___default.a['rl_' + jsHash + '_facebook_service'] = function () {
				__WEBPACK_IMPORTED_MODULE_17_Stores_Social__["a" /* default */].facebook.loading(true);
				_this8.socialUsers();
			};
		}

		if (allowTwitter) {
			__WEBPACK_IMPORTED_MODULE_3_window___default.a['rl_' + jsHash + '_twitter_service'] = function () {
				__WEBPACK_IMPORTED_MODULE_17_Stores_Social__["a" /* default */].twitter.loading(true);
				_this8.socialUsers();
			};
		}

		__WEBPACK_IMPORTED_MODULE_15_Common_Events__["b" /* sub */]('interval.1m', function () {
			return Object(__WEBPACK_IMPORTED_MODULE_12_Common_Momentor__["reload"])();
		});

		Object(__WEBPACK_IMPORTED_MODULE_11_Common_Plugins__["f" /* runHook */])('rl-start-screens');
		__WEBPACK_IMPORTED_MODULE_15_Common_Events__["a" /* pub */]('rl.bootstart-end');
	};

	return AppUser;
}(__WEBPACK_IMPORTED_MODULE_43_App_Abstract__["a" /* AbstractApp */]);

/* harmony default export */ __webpack_exports__["default"] = (new AppUser());

/***/ }),
/* 174 */
/*!*************************************!*\
  !*** ./dev/Stores/User/Template.js ***!
  \*************************************/
/*! exports provided: default */
/*! exports used: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2____);





// import Remote from 'Remote/User/Ajax';

var TemplateUserStore = function () {
	function TemplateUserStore() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, TemplateUserStore);

		this.templates = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observableArray([]);
		this.templates.loading = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(false).extend({ throttle: 100 });

		this.templatesNames = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observableArray([]).extend({ throttle: 1000 });
		this.templatesNames.skipFirst = true;

		this.subscribers();
	}

	TemplateUserStore.prototype.subscribers = function subscribers() {
		var _this = this;

		this.templates.subscribe(function (list) {
			_this.templatesNames(__WEBPACK_IMPORTED_MODULE_2_____default.a.compact(__WEBPACK_IMPORTED_MODULE_2_____default.a.map(list, function (item) {
				return item ? item.name : null;
			})));
		});

		// this.templatesNames.subscribe((aList) => {
		// 	if (this.templatesNames.skipFirst)
		// 	{
		// 		this.templatesNames.skipFirst = false;
		// 	}
		// 	else if (aList && 1 < aList.length)
		// 	{
		// 		Remote.templatesSortOrder(null, aList);
		// 	}
		// });
	};

	return TemplateUserStore;
}();

/* harmony default export */ __webpack_exports__["a"] = (new TemplateUserStore());

/***/ }),
/* 175 */
/*!*******************************!*\
  !*** ./dev/Helper/Message.js ***!
  \*******************************/
/*! exports provided: emailArrayToString, emailArrayToStringClear, emailArrayFromJson, replyHelper */
/*! exports used: emailArrayFromJson, emailArrayToString, emailArrayToStringClear, replyHelper */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["b"] = emailArrayToString;
/* harmony export (immutable) */ __webpack_exports__["c"] = emailArrayToStringClear;
/* harmony export (immutable) */ __webpack_exports__["a"] = emailArrayFromJson;
/* harmony export (immutable) */ __webpack_exports__["d"] = replyHelper;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Model_Email__ = __webpack_require__(/*! Model/Email */ 44);




/**
 * @param {Array.<EmailModel>} emails
 * @param {boolean=} friendlyView = false
 * @param {boolean=} wrapWithLink = false
 * @returns {string}
 */
function emailArrayToString(emails) {
	var friendlyView = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
	var wrapWithLink = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

	var index = 0,
	    len = 0;

	var result = [];
	if (Object(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["isNonEmptyArray"])(emails)) {
		for (len = emails.length; index < len; index++) {
			result.push(emails[index].toLine(friendlyView, wrapWithLink));
		}
	}

	return result.join(', ');
}

/**
 * @param {Array.<EmailModel>} emails
 * @returns {string}
 */
function emailArrayToStringClear(emails) {
	var index = 0,
	    len = 0;

	var result = [];
	if (Object(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["isNonEmptyArray"])(emails)) {
		for (len = emails.length; index < len; index++) {
			if (emails[index] && emails[index].email && '' !== emails[index].name) {
				result.push(emails[index].email);
			}
		}
	}

	return result.join(', ');
}

/**
 * @param {?Array} json
 * @returns {Array.<EmailModel>}
 */
function emailArrayFromJson(json) {
	var index = 0,
	    len = 0,
	    email = null;

	var result = [];
	if (Object(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["isNonEmptyArray"])(json)) {
		for (index = 0, len = json.length; index < len; index++) {
			email = __WEBPACK_IMPORTED_MODULE_1_Model_Email__["EmailModel"].newInstanceFromJson(json[index]);
			if (email) {
				result.push(email);
			}
		}
	}

	return result;
}

/**
 * @param {Array.<EmailModel>} inputEmails
 * @param {Object} unic
 * @param {Array} localEmails
 */
function replyHelper(inputEmails, unic, localEmails) {

	if (inputEmails && 0 < inputEmails.length) {
		var index = 0;
		var len = inputEmails.length;

		for (; index < len; index++) {
			if (Object(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["isUnd"])(unic[inputEmails[index].email])) {
				unic[inputEmails[index].email] = true;
				localEmails.push(inputEmails[index]);
			}
		}
	}
}

/***/ }),
/* 176 */
/*!*********************************!*\
  !*** ./dev/Model/Attachment.js ***!
  \*********************************/
/*! exports provided: staticFileType, staticIconClass, staticCombinedIconClass, AttachmentModel, default */
/*! exports used: AttachmentModel, staticCombinedIconClass, staticFileType, staticIconClass */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return staticFileType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return staticIconClass; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return staticCombinedIconClass; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AttachmentModel; });
/* unused harmony export default */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Common_Links__ = __webpack_require__(/*! Common/Links */ 14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Knoin_AbstractModel__ = __webpack_require__(/*! Knoin/AbstractModel */ 42);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_Common_Audio__ = __webpack_require__(/*! Common/Audio */ 146);

















/**
 * @param {string} sExt
 * @param {string} sMimeType
 * @returns {string}
 */
var staticFileType = __WEBPACK_IMPORTED_MODULE_4_____default.a.memoize(function (ext, mimeType) {
	ext = Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["trim"])(ext).toLowerCase();
	mimeType = Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["trim"])(mimeType).toLowerCase();

	var result = __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Unknown;
	var mimeTypeParts = mimeType.split('/');

	switch (true) {
		case 'image' === mimeTypeParts[0] || -1 < Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["inArray"])(ext, ['png', 'jpg', 'jpeg', 'gif', 'bmp']):
			result = __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Image;
			break;
		case 'audio' === mimeTypeParts[0] || -1 < Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["inArray"])(ext, ['mp3', 'ogg', 'oga', 'wav']):
			result = __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Audio;
			break;
		case 'video' === mimeTypeParts[0] || -1 < Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["inArray"])(ext, ['mkv', 'avi']):
			result = __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Video;
			break;
		case -1 < Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["inArray"])(ext, ['php', 'js', 'css']):
			result = __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Code;
			break;
		case 'eml' === ext || -1 < Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["inArray"])(mimeType, ['message/delivery-status', 'message/rfc822']):
			result = __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Eml;
			break;
		case 'text' === mimeTypeParts[0] && 'html' !== mimeTypeParts[1] || -1 < Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["inArray"])(ext, ['txt', 'log']):
			result = __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Text;
			break;
		case 'text/html' === mimeType || -1 < Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["inArray"])(ext, ['html']):
			result = __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Html;
			break;
		case -1 < Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["inArray"])(mimeTypeParts[1], ['zip', '7z', 'tar', 'rar', 'gzip', 'bzip', 'bzip2', 'x-zip', 'x-7z', 'x-rar', 'x-tar', 'x-gzip', 'x-bzip', 'x-bzip2', 'x-zip-compressed', 'x-7z-compressed', 'x-rar-compressed']) || -1 < Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["inArray"])(ext, ['zip', '7z', 'tar', 'rar', 'gzip', 'bzip', 'bzip2']):
			result = __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Archive;
			break;
		case -1 < Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["inArray"])(mimeTypeParts[1], ['pdf', 'x-pdf']) || -1 < Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["inArray"])(ext, ['pdf']):
			result = __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Pdf;
			break;
		case -1 < Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["inArray"])(mimeType, ['application/pgp-signature', 'application/pgp-keys']) || -1 < Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["inArray"])(ext, ['asc', 'pem', 'ppk']):
			result = __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Certificate;
			break;
		case -1 < Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["inArray"])(mimeType, ['application/pkcs7-signature']) || -1 < Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["inArray"])(ext, ['p7s']):

			result = __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].CertificateBin;
			break;
		case -1 < Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["inArray"])(mimeTypeParts[1], ['rtf', 'msword', 'vnd.msword', 'vnd.openxmlformats-officedocument.wordprocessingml.document', 'vnd.openxmlformats-officedocument.wordprocessingml.template', 'vnd.ms-word.document.macroEnabled.12', 'vnd.ms-word.template.macroEnabled.12']):
			result = __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].WordText;
			break;
		case -1 < Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["inArray"])(mimeTypeParts[1], ['excel', 'ms-excel', 'vnd.ms-excel', 'vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'vnd.openxmlformats-officedocument.spreadsheetml.template', 'vnd.ms-excel.sheet.macroEnabled.12', 'vnd.ms-excel.template.macroEnabled.12', 'vnd.ms-excel.addin.macroEnabled.12', 'vnd.ms-excel.sheet.binary.macroEnabled.12']):
			result = __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Sheet;
			break;
		case -1 < Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["inArray"])(mimeTypeParts[1], ['powerpoint', 'ms-powerpoint', 'vnd.ms-powerpoint', 'vnd.openxmlformats-officedocument.presentationml.presentation', 'vnd.openxmlformats-officedocument.presentationml.template', 'vnd.openxmlformats-officedocument.presentationml.slideshow', 'vnd.ms-powerpoint.addin.macroEnabled.12', 'vnd.ms-powerpoint.presentation.macroEnabled.12', 'vnd.ms-powerpoint.template.macroEnabled.12', 'vnd.ms-powerpoint.slideshow.macroEnabled.12']):
			result = __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Presentation;
			break;
		// no default
	}

	return result;
});

/**
 * @param {string} sFileType
 * @returns {string}
 */
var staticIconClass = __WEBPACK_IMPORTED_MODULE_4_____default.a.memoize(function (fileType) {
	var resultText = '',
	    resultClass = 'icon-file';

	switch (fileType) {
		case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Text:
		case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Eml:
		case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].WordText:
			resultClass = 'icon-file-text';
			break;
		case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Html:
		case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Code:
			resultClass = 'icon-file-code';
			break;
		case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Image:
			resultClass = 'icon-file-image';
			break;
		case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Audio:
			resultClass = 'icon-file-music';
			break;
		case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Video:
			resultClass = 'icon-file-movie';
			break;
		case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Archive:
			resultClass = 'icon-file-zip';
			break;
		case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Certificate:
		case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].CertificateBin:
			resultClass = 'icon-file-certificate';
			break;
		case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Sheet:
			resultClass = 'icon-file-excel';
			break;
		case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Presentation:
			resultClass = 'icon-file-chart-graph';
			break;
		case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Pdf:
			resultText = 'pdf';
			resultClass = 'icon-none';
			break;
		// no default
	}

	return [resultClass, resultText];
});

/**
 * @static
 * @param {string} sFileType
 * @returns {string}
 */
var staticCombinedIconClass = function staticCombinedIconClass(data) {
	var result = '',
	    types = [];

	if (Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["isNonEmptyArray"])(data)) {
		result = 'icon-attachment';
		types = __WEBPACK_IMPORTED_MODULE_4_____default.a.uniq(__WEBPACK_IMPORTED_MODULE_4_____default.a.compact(__WEBPACK_IMPORTED_MODULE_4_____default.a.map(data, function (item) {
			return item ? staticFileType(Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["getFileExtension"])(item[0]), item[1]) : '';
		})));

		if (types && 1 === types.length && types[0]) {
			switch (types[0]) {
				case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Text:
				case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].WordText:
					result = 'icon-file-text';
					break;
				case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Html:
				case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Code:
					result = 'icon-file-code';
					break;
				case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Image:
					result = 'icon-file-image';
					break;
				case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Audio:
					result = 'icon-file-music';
					break;
				case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Video:
					result = 'icon-file-movie';
					break;
				case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Archive:
					result = 'icon-file-zip';
					break;
				case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Certificate:
				case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].CertificateBin:
					result = 'icon-file-certificate';
					break;
				case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Sheet:
					result = 'icon-file-excel';
					break;
				case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Presentation:
					result = 'icon-file-chart-graph';
					break;
				// no default
			}
		}
	}

	return result;
};

var AttachmentModel = function (_AbstractModel) {
	__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(AttachmentModel, _AbstractModel);

	function AttachmentModel() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, AttachmentModel);

		var _this = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractModel.call(this, 'AttachmentModel'));

		_this.checked = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);

		_this.mimeType = '';
		_this.fileName = '';
		_this.fileNameExt = '';
		_this.fileType = __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Unknown;
		_this.estimatedSize = 0;
		_this.friendlySize = '';
		_this.isInline = false;
		_this.isLinked = false;
		_this.isThumbnail = false;
		_this.cid = '';
		_this.cidWithOutTags = '';
		_this.contentLocation = '';
		_this.download = '';
		_this.folder = '';
		_this.uid = '';
		_this.mimeIndex = '';
		_this.framed = false;
		return _this;
	}

	/**
  * @static
  * @param {AjaxJsonAttachment} json
  * @returns {?AttachmentModel}
  */


	AttachmentModel.newInstanceFromJson = function newInstanceFromJson(json) {
		var attachment = new AttachmentModel();
		return attachment.initByJson(json) ? attachment : null;
	};

	/**
  * @param {AjaxJsonAttachment} json
  * @returns {boolean}
  */


	AttachmentModel.prototype.initByJson = function initByJson(json) {
		var bResult = false;
		if (json && 'Object/Attachment' === json['@Object']) {
			this.mimeType = Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["trim"])((json.MimeType || '').toLowerCase());
			this.fileName = Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["trim"])(json.FileName);
			this.estimatedSize = Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["pInt"])(json.EstimatedSize);
			this.isInline = !!json.IsInline;
			this.isLinked = !!json.IsLinked;
			this.isThumbnail = !!json.IsThumbnail;
			this.cid = json.CID;
			this.contentLocation = json.ContentLocation;
			this.download = json.Download;

			this.folder = json.Folder;
			this.uid = json.Uid;
			this.mimeIndex = json.MimeIndex;
			this.framed = !!json.Framed;

			this.friendlySize = Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["friendlySize"])(this.estimatedSize);
			this.cidWithOutTags = this.cid.replace(/^<+/, '').replace(/>+$/, '');

			this.fileNameExt = Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["getFileExtension"])(this.fileName);
			this.fileType = staticFileType(this.fileNameExt, this.mimeType);

			bResult = true;
		}

		return bResult;
	};

	/**
  * @returns {boolean}
  */


	AttachmentModel.prototype.isImage = function isImage() {
		return __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Image === this.fileType;
	};

	/**
  * @returns {boolean}
  */


	AttachmentModel.prototype.isMp3 = function isMp3() {
		return __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Audio === this.fileType && 'mp3' === this.fileNameExt;
	};

	/**
  * @returns {boolean}
  */


	AttachmentModel.prototype.isOgg = function isOgg() {
		return __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Audio === this.fileType && ('oga' === this.fileNameExt || 'ogg' === this.fileNameExt);
	};

	/**
  * @returns {boolean}
  */


	AttachmentModel.prototype.isWav = function isWav() {
		return __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Audio === this.fileType && 'wav' === this.fileNameExt;
	};

	/**
  * @returns {boolean}
  */


	AttachmentModel.prototype.hasThumbnail = function hasThumbnail() {
		return this.isThumbnail;
	};

	/**
  * @returns {boolean}
  */


	AttachmentModel.prototype.isText = function isText() {
		return __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Text === this.fileType || __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Eml === this.fileType || __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Certificate === this.fileType || __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Html === this.fileType || __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Code === this.fileType;
	};

	/**
  * @returns {boolean}
  */


	AttachmentModel.prototype.isPdf = function isPdf() {
		return __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FileType"].Pdf === this.fileType;
	};

	/**
  * @returns {boolean}
  */


	AttachmentModel.prototype.isFramed = function isFramed() {
		return this.framed && __WEBPACK_IMPORTED_MODULE_7_Common_Globals__["data"].__APP__ && __WEBPACK_IMPORTED_MODULE_7_Common_Globals__["data"].__APP__.googlePreviewSupported() && !(this.isPdf() && __WEBPACK_IMPORTED_MODULE_7_Common_Globals__["bAllowPdfPreview"]) && !this.isText() && !this.isImage();
	};

	/**
  * @returns {boolean}
  */


	AttachmentModel.prototype.hasPreview = function hasPreview() {
		return this.isImage() || this.isPdf() && __WEBPACK_IMPORTED_MODULE_7_Common_Globals__["bAllowPdfPreview"] || this.isText() || this.isFramed();
	};

	/**
  * @returns {boolean}
  */


	AttachmentModel.prototype.hasPreplay = function hasPreplay() {
		return __WEBPACK_IMPORTED_MODULE_11_Common_Audio__["a" /* default */].supportedMp3 && this.isMp3() || __WEBPACK_IMPORTED_MODULE_11_Common_Audio__["a" /* default */].supportedOgg && this.isOgg() || __WEBPACK_IMPORTED_MODULE_11_Common_Audio__["a" /* default */].supportedWav && this.isWav();
	};

	/**
  * @returns {string}
  */


	AttachmentModel.prototype.linkDownload = function linkDownload() {
		return Object(__WEBPACK_IMPORTED_MODULE_9_Common_Links__["c" /* attachmentDownload */])(this.download);
	};

	/**
  * @returns {string}
  */


	AttachmentModel.prototype.linkPreview = function linkPreview() {
		return Object(__WEBPACK_IMPORTED_MODULE_9_Common_Links__["e" /* attachmentPreview */])(this.download);
	};

	/**
  * @returns {string}
  */


	AttachmentModel.prototype.linkThumbnail = function linkThumbnail() {
		return this.hasThumbnail() ? Object(__WEBPACK_IMPORTED_MODULE_9_Common_Links__["g" /* attachmentThumbnailPreview */])(this.download) : '';
	};

	/**
  * @returns {string}
  */


	AttachmentModel.prototype.linkThumbnailPreviewStyle = function linkThumbnailPreviewStyle() {
		var link = this.linkThumbnail();
		return '' === link ? '' : 'background:url(' + link + ')';
	};

	/**
  * @returns {string}
  */


	AttachmentModel.prototype.linkFramed = function linkFramed() {
		return Object(__WEBPACK_IMPORTED_MODULE_9_Common_Links__["d" /* attachmentFramed */])(this.download);
	};

	/**
  * @returns {string}
  */


	AttachmentModel.prototype.linkPreviewAsPlain = function linkPreviewAsPlain() {
		return Object(__WEBPACK_IMPORTED_MODULE_9_Common_Links__["f" /* attachmentPreviewAsPlain */])(this.download);
	};

	/**
  * @returns {string}
  */


	AttachmentModel.prototype.linkPreviewMain = function linkPreviewMain() {
		var result = '';
		switch (true) {
			case this.isImage():
			case this.isPdf() && __WEBPACK_IMPORTED_MODULE_7_Common_Globals__["bAllowPdfPreview"]:
				result = this.linkPreview();
				break;
			case this.isText():
				result = this.linkPreviewAsPlain();
				break;
			case this.isFramed():
				result = this.linkFramed();
				break;
			// no default
		}

		return result;
	};

	/**
  * @returns {string}
  */


	AttachmentModel.prototype.generateTransferDownloadUrl = function generateTransferDownloadUrl() {
		var link = this.linkDownload();
		if ('http' !== link.substr(0, 4)) {
			link = __WEBPACK_IMPORTED_MODULE_3_window___default.a.location.protocol + '//' + __WEBPACK_IMPORTED_MODULE_3_window___default.a.location.host + __WEBPACK_IMPORTED_MODULE_3_window___default.a.location.pathname + link;
		}

		return this.mimeType + ':' + this.fileName + ':' + link;
	};

	/**
  * @param {AttachmentModel} attachment
  * @param {*} event
  * @returns {boolean}
  */


	AttachmentModel.prototype.eventDragStart = function eventDragStart(attachment, event) {
		var localEvent = event.originalEvent || event;
		if (attachment && localEvent && localEvent.dataTransfer && localEvent.dataTransfer.setData) {
			localEvent.dataTransfer.setData('DownloadURL', this.generateTransferDownloadUrl());
		}

		return true;
	};

	/**
  * @returns {string}
  */


	AttachmentModel.prototype.iconClass = function iconClass() {
		return staticIconClass(this.fileType)[0];
	};

	/**
  * @returns {string}
  */


	AttachmentModel.prototype.iconText = function iconText() {
		return staticIconClass(this.fileType)[1];
	};

	return AttachmentModel;
}(__WEBPACK_IMPORTED_MODULE_10_Knoin_AbstractModel__["a" /* AbstractModel */]);



/***/ }),
/* 177 */
/*!**********************************!*\
  !*** ./dev/Stores/User/Quota.js ***!
  \**********************************/
/*! exports provided: default */
/*! exports used: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);







var QuotaUserStore = function () {
	function QuotaUserStore() {
		var _this = this;

		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, QuotaUserStore);

		this.quota = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(0);
		this.usage = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].observable(0);

		this.percentage = __WEBPACK_IMPORTED_MODULE_2_ko__["a" /* default */].computed(function () {

			var quota = _this.quota(),
			    usage = _this.usage();

			return 0 < quota ? __WEBPACK_IMPORTED_MODULE_1_window___default.a.Math.ceil(usage / quota * 100) : 0;
		});
	}

	/**
  * @param {number} quota
  * @param {number} usage
  */


	QuotaUserStore.prototype.populateData = function populateData(quota, usage) {
		this.quota(quota * __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["Magics"].BitLength1024);
		this.usage(usage * __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["Magics"].BitLength1024);
	};

	return QuotaUserStore;
}();

/* harmony default export */ __webpack_exports__["a"] = (new QuotaUserStore());

/***/ }),
/* 178 */
/*!***************************************!*\
  !*** ./dev/Promises/AbstractBasic.js ***!
  \***************************************/
/*! exports provided: AbstractBasicPromises */
/*! exports used: AbstractBasicPromises */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AbstractBasicPromises; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);





var AbstractBasicPromises = function () {
	function AbstractBasicPromises() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, AbstractBasicPromises);

		this.oPromisesStack = {};
	}

	AbstractBasicPromises.prototype.func = function func(fFunc) {
		fFunc();
		return this;
	};

	AbstractBasicPromises.prototype.fastResolve = function fastResolve(mData) {
		return __WEBPACK_IMPORTED_MODULE_1_window___default.a.Promise.resolve(mData);
	};

	AbstractBasicPromises.prototype.fastReject = function fastReject(mData) {
		return __WEBPACK_IMPORTED_MODULE_1_window___default.a.Promise.reject(mData);
	};

	AbstractBasicPromises.prototype.setTrigger = function setTrigger(trigger, value) {
		if (trigger) {
			value = !!value;
			(Object(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["isArray"])(trigger) ? trigger : [trigger]).forEach(function (fTrigger) {
				if (fTrigger) {
					fTrigger(value);
				}
			});
		}
	};

	return AbstractBasicPromises;
}();

/***/ }),
/* 179 */
/*!*************************************************!*\
  !*** ./dev/View/User/AbstractSystemDropDown.js ***!
  \*************************************************/
/*! exports provided: AbstractSystemDropDownUserView, default */
/*! exports used: AbstractSystemDropDownUserView */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AbstractSystemDropDownUserView; });
/* unused harmony export default */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_key__ = __webpack_require__(/*! key */ 19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_key___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_key__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Stores_User_App__ = __webpack_require__(/*! Stores/User/App */ 34);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Stores_User_Account__ = __webpack_require__(/*! Stores/User/Account */ 47);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Stores_User_Message__ = __webpack_require__(/*! Stores/User/Message */ 45);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_Common_Links__ = __webpack_require__(/*! Common/Links */ 14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_Common_Events__ = __webpack_require__(/*! Common/Events */ 37);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14_Helper_Apps_User__ = __webpack_require__(/*! Helper/Apps/User */ 16);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_16_Knoin_AbstractViewNext__ = __webpack_require__(/*! Knoin/AbstractViewNext */ 13);
























var AbstractSystemDropDownUserView = function (_AbstractViewNext) {
	__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(AbstractSystemDropDownUserView, _AbstractViewNext);

	function AbstractSystemDropDownUserView() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, AbstractSystemDropDownUserView);

		var _this = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractViewNext.call(this));

		_this.logoImg = Object(__WEBPACK_IMPORTED_MODULE_10_Common_Utils__["trim"])(__WEBPACK_IMPORTED_MODULE_13_Storage_Settings__["settingsGet"]('UserLogo'));
		_this.logoTitle = Object(__WEBPACK_IMPORTED_MODULE_10_Common_Utils__["trim"])(__WEBPACK_IMPORTED_MODULE_13_Storage_Settings__["settingsGet"]('UserLogoTitle'));

		_this.mobile = !!__WEBPACK_IMPORTED_MODULE_13_Storage_Settings__["appSettingsGet"]('mobile');
		_this.mobileDevice = !!__WEBPACK_IMPORTED_MODULE_13_Storage_Settings__["appSettingsGet"]('mobileDevice');

		_this.allowSettings = !!__WEBPACK_IMPORTED_MODULE_13_Storage_Settings__["capa"](__WEBPACK_IMPORTED_MODULE_9_Common_Enums__["Capa"].Settings);
		_this.allowHelp = !!__WEBPACK_IMPORTED_MODULE_13_Storage_Settings__["capa"](__WEBPACK_IMPORTED_MODULE_9_Common_Enums__["Capa"].Help);

		_this.currentAudio = __WEBPACK_IMPORTED_MODULE_6_Stores_User_App__["a" /* default */].currentAudio;

		_this.accountEmail = __WEBPACK_IMPORTED_MODULE_7_Stores_User_Account__["a" /* default */].email;

		_this.accounts = __WEBPACK_IMPORTED_MODULE_7_Stores_User_Account__["a" /* default */].accounts;
		_this.accountsUnreadCount = __WEBPACK_IMPORTED_MODULE_7_Stores_User_Account__["a" /* default */].accountsUnreadCount;

		_this.accountMenuDropdownTrigger = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);
		_this.capaAdditionalAccounts = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(__WEBPACK_IMPORTED_MODULE_13_Storage_Settings__["capa"](__WEBPACK_IMPORTED_MODULE_9_Common_Enums__["Capa"].AdditionalAccounts));

		_this.addAccountClick = __WEBPACK_IMPORTED_MODULE_3_____default.a.bind(_this.addAccountClick, _this);

		__WEBPACK_IMPORTED_MODULE_12_Common_Events__["b" /* sub */]('audio.stop', function () {
			return __WEBPACK_IMPORTED_MODULE_6_Stores_User_App__["a" /* default */].currentAudio('');
		});
		__WEBPACK_IMPORTED_MODULE_12_Common_Events__["b" /* sub */]('audio.start', function (name) {
			return __WEBPACK_IMPORTED_MODULE_6_Stores_User_App__["a" /* default */].currentAudio(name);
		});
		return _this;
	}

	AbstractSystemDropDownUserView.prototype.stopPlay = function stopPlay() {
		__WEBPACK_IMPORTED_MODULE_12_Common_Events__["a" /* pub */]('audio.api.stop');
	};

	AbstractSystemDropDownUserView.prototype.accountClick = function accountClick(account, event) {
		if (account && event && !Object(__WEBPACK_IMPORTED_MODULE_10_Common_Utils__["isUnd"])(event.which) && 1 === event.which) {
			__WEBPACK_IMPORTED_MODULE_7_Stores_User_Account__["a" /* default */].accounts.loading(true);
			__WEBPACK_IMPORTED_MODULE_3_____default.a.delay(function () {
				return __WEBPACK_IMPORTED_MODULE_7_Stores_User_Account__["a" /* default */].accounts.loading(false);
			}, __WEBPACK_IMPORTED_MODULE_9_Common_Enums__["Magics"].Time1s);
		}

		return true;
	};

	AbstractSystemDropDownUserView.prototype.emailTitle = function emailTitle() {
		return __WEBPACK_IMPORTED_MODULE_7_Stores_User_Account__["a" /* default */].email();
	};

	AbstractSystemDropDownUserView.prototype.settingsClick = function settingsClick() {
		if (__WEBPACK_IMPORTED_MODULE_13_Storage_Settings__["capa"](__WEBPACK_IMPORTED_MODULE_9_Common_Enums__["Capa"].Settings)) {
			Object(__WEBPACK_IMPORTED_MODULE_15_Knoin_Knoin__["setHash"])(Object(__WEBPACK_IMPORTED_MODULE_11_Common_Links__["z" /* settings */])());
		}
	};

	AbstractSystemDropDownUserView.prototype.settingsHelp = function settingsHelp() {
		if (__WEBPACK_IMPORTED_MODULE_13_Storage_Settings__["capa"](__WEBPACK_IMPORTED_MODULE_9_Common_Enums__["Capa"].Help)) {
			Object(__WEBPACK_IMPORTED_MODULE_15_Knoin_Knoin__["showScreenPopup"])(__webpack_require__(/*! View/Popup/KeyboardShortcutsHelp */ 180));
		}
	};

	AbstractSystemDropDownUserView.prototype.addAccountClick = function addAccountClick() {
		if (this.capaAdditionalAccounts()) {
			Object(__WEBPACK_IMPORTED_MODULE_15_Knoin_Knoin__["showScreenPopup"])(__webpack_require__(/*! View/Popup/Account */ 149));
		}
	};

	AbstractSystemDropDownUserView.prototype.logoutClick = function logoutClick() {
		Object(__WEBPACK_IMPORTED_MODULE_14_Helper_Apps_User__["a" /* getApp */])().logout();
	};

	AbstractSystemDropDownUserView.prototype.onBuild = function onBuild() {
		var _this2 = this;

		__WEBPACK_IMPORTED_MODULE_5_key___default()('`', [__WEBPACK_IMPORTED_MODULE_9_Common_Enums__["KeyState"].MessageList, __WEBPACK_IMPORTED_MODULE_9_Common_Enums__["KeyState"].MessageView, __WEBPACK_IMPORTED_MODULE_9_Common_Enums__["KeyState"].Settings], function () {
			if (_this2.viewModelVisibility()) {
				__WEBPACK_IMPORTED_MODULE_8_Stores_User_Message__["a" /* default */].messageFullScreenMode(false);
				_this2.accountMenuDropdownTrigger(true);
			}
		});

		// shortcuts help
		__WEBPACK_IMPORTED_MODULE_5_key___default()('shift+/', [__WEBPACK_IMPORTED_MODULE_9_Common_Enums__["KeyState"].MessageList, __WEBPACK_IMPORTED_MODULE_9_Common_Enums__["KeyState"].MessageView, __WEBPACK_IMPORTED_MODULE_9_Common_Enums__["KeyState"].Settings], function () {
			if (_this2.viewModelVisibility()) {
				Object(__WEBPACK_IMPORTED_MODULE_15_Knoin_Knoin__["showScreenPopup"])(__webpack_require__(/*! View/Popup/KeyboardShortcutsHelp */ 180));
				return false;
			}
			return true;
		});
	};

	return AbstractSystemDropDownUserView;
}(__WEBPACK_IMPORTED_MODULE_16_Knoin_AbstractViewNext__["a" /* AbstractViewNext */]);



/***/ }),
/* 180 */
/*!*************************************************!*\
  !*** ./dev/View/Popup/KeyboardShortcutsHelp.js ***!
  \*************************************************/
/*! exports provided: KeyboardShortcutsHelpPopupView, default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "KeyboardShortcutsHelpPopupView", function() { return KeyboardShortcutsHelpPopupView; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return KeyboardShortcutsHelpPopupView; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_key__ = __webpack_require__(/*! key */ 19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_key___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_key__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Knoin_AbstractViewNext__ = __webpack_require__(/*! Knoin/AbstractViewNext */ 13);




var _dec, _class;









var KeyboardShortcutsHelpPopupView = (_dec = Object(__WEBPACK_IMPORTED_MODULE_6_Knoin_Knoin__["popup"])({
	name: 'View/Popup/KeyboardShortcutsHelp',
	templateID: 'PopupsKeyboardShortcutsHelp'
}), _dec(_class = function (_AbstractViewNext) {
	__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(KeyboardShortcutsHelpPopupView, _AbstractViewNext);

	function KeyboardShortcutsHelpPopupView() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, KeyboardShortcutsHelpPopupView);

		var _this = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractViewNext.call(this));

		_this.sDefaultKeyScope = __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].PopupKeyboardShortcutsHelp;
		return _this;
	}

	KeyboardShortcutsHelpPopupView.prototype.onBuild = function onBuild(dom) {
		__WEBPACK_IMPORTED_MODULE_4_key___default()('tab, shift+tab, left, right', __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].PopupKeyboardShortcutsHelp, __WEBPACK_IMPORTED_MODULE_3_____default.a.throttle(function (event, handler) {

			if (event && handler) {
				var $tabs = dom.find('.nav.nav-tabs > li'),
				    isNext = handler && ('tab' === handler.shortcut || 'right' === handler.shortcut);

				var index = $tabs.index($tabs.filter('.active'));
				if (!isNext && 0 < index) {
					index -= 1;
				} else if (isNext && index < $tabs.length - 1) {
					index += 1;
				} else {
					index = isNext ? 0 : $tabs.length - 1;
				}

				$tabs.eq(index).find('a[data-toggle="tab"]').tab('show');
				return false;
			}

			return true;
		}, __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Magics"].Time100ms));
	};

	return KeyboardShortcutsHelpPopupView;
}(__WEBPACK_IMPORTED_MODULE_7_Knoin_AbstractViewNext__["a" /* AbstractViewNext */])) || _class);




/***/ }),
/* 181 */
/*!************************************!*\
  !*** ./dev/View/Popup/Contacts.js ***!
  \************************************/
/*! exports provided: ContactsPopupView, default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ContactsPopupView", function() { return ContactsPopupView; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return ContactsPopupView; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor__ = __webpack_require__(/*! babel-runtime/core-js/object/get-own-property-descriptor */ 15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6____ = __webpack_require__(/*! $ */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_key__ = __webpack_require__(/*! key */ 19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_key___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_8_key__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Jua__ = __webpack_require__(/*! Jua */ 99);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Jua___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_9_Jua__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_Common_Consts__ = __webpack_require__(/*! Common/Consts */ 20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14_Common_Selector__ = __webpack_require__(/*! Common/Selector */ 182);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15_Common_Links__ = __webpack_require__(/*! Common/Links */ 14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_16_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_17_Stores_User_Settings__ = __webpack_require__(/*! Stores/User/Settings */ 41);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_18_Stores_User_Contact__ = __webpack_require__(/*! Stores/User/Contact */ 147);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_19_Remote_User_Ajax__ = __webpack_require__(/*! Remote/User/Ajax */ 17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_20_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_21_Model_Email__ = __webpack_require__(/*! Model/Email */ 44);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_22_Model_Contact__ = __webpack_require__(/*! Model/Contact */ 234);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_23_Model_ContactProperty__ = __webpack_require__(/*! Model/ContactProperty */ 235);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_24_Helper_Apps_User__ = __webpack_require__(/*! Helper/Apps/User */ 16);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_25_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_26_Knoin_AbstractViewNext__ = __webpack_require__(/*! Knoin/AbstractViewNext */ 13);





var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _class, _desc, _value, _class2;

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
	var desc = {};
	Object['ke' + 'ys'](descriptor).forEach(function (key) {
		desc[key] = descriptor[key];
	});
	desc.enumerable = !!desc.enumerable;
	desc.configurable = !!desc.configurable;

	if ('value' in desc || desc.initializer) {
		desc.writable = true;
	}

	desc = decorators.slice().reverse().reduce(function (desc, decorator) {
		return decorator(target, property, desc) || desc;
	}, desc);

	if (context && desc.initializer !== void 0) {
		desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
		desc.initializer = undefined;
	}

	if (desc.initializer === void 0) {
		Object['define' + 'Property'](target, property, desc);
		desc = null;
	}

	return desc;
}



































var ContactsPopupView = (_dec = Object(__WEBPACK_IMPORTED_MODULE_25_Knoin_Knoin__["popup"])({
	name: 'View/Popup/Contacts',
	templateID: 'PopupsContacts'
}), _dec2 = Object(__WEBPACK_IMPORTED_MODULE_25_Knoin_Knoin__["command"])(), _dec3 = Object(__WEBPACK_IMPORTED_MODULE_25_Knoin_Knoin__["command"])(function (self) {
	return 0 < self.contactsCheckedOrSelected().length;
}), _dec4 = Object(__WEBPACK_IMPORTED_MODULE_25_Knoin_Knoin__["command"])(function (self) {
	return 0 < self.contactsCheckedOrSelected().length;
}), _dec5 = Object(__WEBPACK_IMPORTED_MODULE_25_Knoin_Knoin__["command"])(), _dec6 = Object(__WEBPACK_IMPORTED_MODULE_25_Knoin_Knoin__["command"])(function (self) {
	var bV = self.viewHasNonEmptyRequaredProperties(),
	    bReadOnly = self.viewReadOnly();
	return !self.viewSaving() && bV && !bReadOnly;
}), _dec7 = Object(__WEBPACK_IMPORTED_MODULE_25_Knoin_Knoin__["command"])(function (self) {
	return !self.contacts.syncing() && !self.contacts.importing();
}), _dec(_class = (_class2 = function (_AbstractViewNext) {
	__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits___default()(ContactsPopupView, _AbstractViewNext);

	function ContactsPopupView() {
		__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default()(this, ContactsPopupView);

		var _this = __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractViewNext.call(this));

		var fFastClearEmptyListHelper = function fFastClearEmptyListHelper(list) {
			if (list && 0 < list.length) {
				_this.viewProperties.removeAll(list);
				Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["delegateRunOnDestroy"])(list);
			}
		};

		_this.bBackToCompose = false;
		_this.sLastComposeFocusedField = '';

		_this.allowContactsSync = __WEBPACK_IMPORTED_MODULE_18_Stores_User_Contact__["a" /* default */].allowContactsSync;
		_this.enableContactsSync = __WEBPACK_IMPORTED_MODULE_18_Stores_User_Contact__["a" /* default */].enableContactsSync;
		_this.allowExport = !__WEBPACK_IMPORTED_MODULE_13_Common_Globals__["bMobileDevice"];

		_this.search = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable('');
		_this.contactsCount = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(0);
		_this.contacts = __WEBPACK_IMPORTED_MODULE_18_Stores_User_Contact__["a" /* default */].contacts;

		_this.currentContact = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(null);

		_this.importUploaderButton = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(null);

		_this.contactsPage = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(1);
		_this.contactsPageCount = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].computed(function () {
			var iPage = __WEBPACK_IMPORTED_MODULE_4_window___default.a.Math.ceil(_this.contactsCount() / __WEBPACK_IMPORTED_MODULE_12_Common_Consts__["c" /* CONTACTS_PER_PAGE */]);
			return 0 >= iPage ? 1 : iPage;
		});

		_this.contactsPagenator = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].computed(Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["computedPagenatorHelper"])(_this.contactsPage, _this.contactsPageCount));

		_this.emptySelection = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(true);
		_this.viewClearSearch = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);

		_this.viewID = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable('');
		_this.viewReadOnly = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);
		_this.viewProperties = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observableArray([]);

		_this.viewSaveTrigger = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["SaveSettingsStep"].Idle);

		_this.viewPropertiesNames = _this.viewProperties.filter(function (property) {
			return -1 < Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["inArray"])(property.type(), [__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ContactPropertyType"].FirstName, __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ContactPropertyType"].LastName]);
		});

		_this.viewPropertiesOther = _this.viewProperties.filter(function (property) {
			return -1 < Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["inArray"])(property.type(), [__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ContactPropertyType"].Note]);
		});

		_this.viewPropertiesOther = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].computed(function () {
			var list = __WEBPACK_IMPORTED_MODULE_5_____default.a.filter(_this.viewProperties(), function (property) {
				return -1 < Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["inArray"])(property.type(), [__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ContactPropertyType"].Nick]);
			});
			return __WEBPACK_IMPORTED_MODULE_5_____default.a.sortBy(list, function (property) {
				return property.type();
			});
		});

		_this.viewPropertiesEmails = _this.viewProperties.filter(function (property) {
			return __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ContactPropertyType"].Email === property.type();
		});

		_this.viewPropertiesWeb = _this.viewProperties.filter(function (property) {
			return __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ContactPropertyType"].Web === property.type();
		});

		_this.viewHasNonEmptyRequaredProperties = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].computed(function () {
			var names = _this.viewPropertiesNames(),
			    emails = _this.viewPropertiesEmails(),
			    fFilter = function fFilter(property) {
				return '' !== Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["trim"])(property.value());
			};

			return !!(__WEBPACK_IMPORTED_MODULE_5_____default.a.find(names, fFilter) || __WEBPACK_IMPORTED_MODULE_5_____default.a.find(emails, fFilter));
		});

		_this.viewPropertiesPhones = _this.viewProperties.filter(function (property) {
			return __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ContactPropertyType"].Phone === property.type();
		});

		_this.viewPropertiesEmailsNonEmpty = _this.viewPropertiesNames.filter(function (property) {
			return '' !== Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["trim"])(property.value());
		});

		_this.viewPropertiesEmailsEmptyAndOnFocused = _this.viewPropertiesEmails.filter(function (property) {
			var foc = property.focused();
			return '' === Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["trim"])(property.value()) && !foc;
		});

		_this.viewPropertiesPhonesEmptyAndOnFocused = _this.viewPropertiesPhones.filter(function (property) {
			var foc = property.focused();
			return '' === Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["trim"])(property.value()) && !foc;
		});

		_this.viewPropertiesWebEmptyAndOnFocused = _this.viewPropertiesWeb.filter(function (property) {
			var foc = property.focused();
			return '' === Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["trim"])(property.value()) && !foc;
		});

		_this.viewPropertiesOtherEmptyAndOnFocused = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].computed(function () {
			return __WEBPACK_IMPORTED_MODULE_5_____default.a.filter(_this.viewPropertiesOther(), function (property) {
				var foc = property.focused();
				return '' === Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["trim"])(property.value()) && !foc;
			});
		});

		_this.viewPropertiesEmailsEmptyAndOnFocused.subscribe(function (list) {
			fFastClearEmptyListHelper(list);
		});

		_this.viewPropertiesPhonesEmptyAndOnFocused.subscribe(function (list) {
			fFastClearEmptyListHelper(list);
		});

		_this.viewPropertiesWebEmptyAndOnFocused.subscribe(function (list) {
			fFastClearEmptyListHelper(list);
		});

		_this.viewPropertiesOtherEmptyAndOnFocused.subscribe(function (list) {
			fFastClearEmptyListHelper(list);
		});

		_this.viewSaving = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);

		_this.useCheckboxesInList = __WEBPACK_IMPORTED_MODULE_17_Stores_User_Settings__["a" /* default */].useCheckboxesInList;

		_this.search.subscribe(function () {
			_this.reloadContactList();
		});

		_this.contacts.subscribe(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["windowResizeCallback"]);
		_this.viewProperties.subscribe(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["windowResizeCallback"]);

		_this.contactsChecked = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].computed(function () {
			return __WEBPACK_IMPORTED_MODULE_5_____default.a.filter(_this.contacts(), function (item) {
				return item.checked();
			});
		});

		_this.contactsCheckedOrSelected = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].computed(function () {
			var checked = _this.contactsChecked(),
			    selected = _this.currentContact();

			return __WEBPACK_IMPORTED_MODULE_5_____default.a.union(checked, selected ? [selected] : []);
		});

		_this.contactsCheckedOrSelectedUids = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].computed(function () {
			return __WEBPACK_IMPORTED_MODULE_5_____default.a.map(_this.contactsCheckedOrSelected(), function (contact) {
				return contact.idContact;
			});
		});

		_this.selector = new __WEBPACK_IMPORTED_MODULE_14_Common_Selector__["a" /* Selector */](_this.contacts, _this.currentContact, null, '.e-contact-item .actionHandle', '.e-contact-item.selected', '.e-contact-item .checkboxItem', '.e-contact-item.focused');

		_this.selector.on('onItemSelect', function (contact) {
			_this.populateViewContact(contact ? contact : null);
			if (!contact) {
				_this.emptySelection(true);
			}
		});

		_this.selector.on('onItemGetUid', function (contact) {
			return contact ? contact.generateUid() : '';
		});

		_this.bDropPageAfterDelete = false;

		_this.watchDirty = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);
		_this.watchHash = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].observable(false);

		_this.viewHash = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].computed(function () {
			return '' + __WEBPACK_IMPORTED_MODULE_5_____default.a.map(_this.viewProperties(), function (oItem) {
				return oItem.value();
			}).join('');
		});

		// this.saveCommandDebounce = _.debounce(_.bind(this.saveCommand, this), 1000);

		_this.viewHash.subscribe(function () {
			if (_this.watchHash() && !_this.viewReadOnly() && !_this.watchDirty()) {
				_this.watchDirty(true);
			}
		});

		_this.sDefaultKeyScope = __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["KeyState"].ContactList;
		return _this;
	}

	ContactsPopupView.prototype.newCommand = function newCommand() {
		this.populateViewContact(null);
		this.currentContact(null);
	};

	ContactsPopupView.prototype.deleteCommand = function deleteCommand() {
		this.deleteSelectedContacts();
		this.emptySelection(true);
	};

	ContactsPopupView.prototype.newMessageCommand = function newMessageCommand() {

		if (!__WEBPACK_IMPORTED_MODULE_20_Storage_Settings__["capa"](__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["Capa"].Composer)) {
			return false;
		}

		var aE = [],
		    toEmails = null,
		    ccEmails = null,
		    bccEmails = null;

		var aC = this.contactsCheckedOrSelected();
		if (Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isNonEmptyArray"])(aC)) {
			aE = __WEBPACK_IMPORTED_MODULE_5_____default.a.map(aC, function (oItem) {
				if (oItem) {
					var data = oItem.getNameAndEmailHelper(),
					    email = data ? new __WEBPACK_IMPORTED_MODULE_21_Model_Email__["EmailModel"](data[0], data[1]) : null;

					if (email && email.validate()) {
						return email;
					}
				}

				return null;
			});

			aE = __WEBPACK_IMPORTED_MODULE_5_____default.a.compact(aE);
		}

		if (Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isNonEmptyArray"])(aE)) {
			this.bBackToCompose = false;

			Object(__WEBPACK_IMPORTED_MODULE_25_Knoin_Knoin__["hideScreenPopup"])(ContactsPopupView);

			switch (this.sLastComposeFocusedField) {
				case 'cc':
					ccEmails = aE;
					break;
				case 'bcc':
					bccEmails = aE;
					break;
				case 'to':
				default:
					toEmails = aE;
					break;
			}

			this.sLastComposeFocusedField = '';

			__WEBPACK_IMPORTED_MODULE_5_____default.a.delay(function () {
				Object(__WEBPACK_IMPORTED_MODULE_25_Knoin_Knoin__["showScreenPopup"])(__webpack_require__(/*! View/Popup/Compose */ 43), [__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ComposeType"].Empty, null, toEmails, ccEmails, bccEmails]);
			}, __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["Magics"].Time200ms);
		}

		return true;
	};

	ContactsPopupView.prototype.clearCommand = function clearCommand() {
		this.search('');
	};

	ContactsPopupView.prototype.saveCommand = function saveCommand() {
		var _this2 = this;

		this.viewSaving(true);
		this.viewSaveTrigger(__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["SaveSettingsStep"].Animate);

		var requestUid = Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["fakeMd5"])(),
		    properties = [];

		__WEBPACK_IMPORTED_MODULE_5_____default.a.each(this.viewProperties(), function (oItem) {
			if (oItem.type() && '' !== Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["trim"])(oItem.value())) {
				properties.push([oItem.type(), oItem.value(), oItem.typeStr()]);
			}
		});

		__WEBPACK_IMPORTED_MODULE_19_Remote_User_Ajax__["a" /* default */].contactSave(function (sResult, oData) {

			var res = false;
			_this2.viewSaving(false);

			if (__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["StorageResultType"].Success === sResult && oData && oData.Result && oData.Result.RequestUid === requestUid && 0 < Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["pInt"])(oData.Result.ResultID)) {
				if ('' === _this2.viewID()) {
					_this2.viewID(Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["pInt"])(oData.Result.ResultID));
				}

				_this2.reloadContactList();
				res = true;
			}

			__WEBPACK_IMPORTED_MODULE_5_____default.a.delay(function () {
				_this2.viewSaveTrigger(res ? __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["SaveSettingsStep"].TrueResult : __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["SaveSettingsStep"].FalseResult);
			}, __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["Magics"].Time350ms);

			if (res) {
				_this2.watchDirty(false);

				__WEBPACK_IMPORTED_MODULE_5_____default.a.delay(function () {
					_this2.viewSaveTrigger(__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["SaveSettingsStep"].Idle);
				}, __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["Magics"].Time1s);
			}
		}, requestUid, this.viewID(), properties);
	};

	ContactsPopupView.prototype.syncCommand = function syncCommand() {
		var _this3 = this;

		Object(__WEBPACK_IMPORTED_MODULE_24_Helper_Apps_User__["a" /* getApp */])().contactsSync(function (result, data) {
			if (__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["StorageResultType"].Success !== result || !data || !data.Result) {
				__WEBPACK_IMPORTED_MODULE_4_window___default.a.alert(Object(__WEBPACK_IMPORTED_MODULE_16_Common_Translator__["getNotification"])(data && data.ErrorCode ? data.ErrorCode : __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["Notification"].ContactsSyncError));
			}

			_this3.reloadContactList(true);
		});
	};

	ContactsPopupView.prototype.getPropertyPlaceholder = function getPropertyPlaceholder(type) {
		var result = '';
		switch (type) {
			case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ContactPropertyType"].LastName:
				result = 'CONTACTS/PLACEHOLDER_ENTER_LAST_NAME';
				break;
			case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ContactPropertyType"].FirstName:
				result = 'CONTACTS/PLACEHOLDER_ENTER_FIRST_NAME';
				break;
			case __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ContactPropertyType"].Nick:
				result = 'CONTACTS/PLACEHOLDER_ENTER_NICK_NAME';
				break;
			// no default
		}

		return result;
	};

	ContactsPopupView.prototype.addNewProperty = function addNewProperty(type, typeStr) {
		this.viewProperties.push(new __WEBPACK_IMPORTED_MODULE_23_Model_ContactProperty__["a" /* ContactPropertyModel */](type, typeStr || '', '', true, this.getPropertyPlaceholder(type)));
	};

	ContactsPopupView.prototype.addNewOrFocusProperty = function addNewOrFocusProperty(type, typeStr) {
		var item = __WEBPACK_IMPORTED_MODULE_5_____default.a.find(this.viewProperties(), function (prop) {
			return type === prop.type();
		});
		if (item) {
			item.focused(true);
		} else {
			this.addNewProperty(type, typeStr);
		}
	};

	ContactsPopupView.prototype.addNewEmail = function addNewEmail() {
		this.addNewProperty(__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ContactPropertyType"].Email, 'Home');
	};

	ContactsPopupView.prototype.addNewPhone = function addNewPhone() {
		this.addNewProperty(__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ContactPropertyType"].Phone, 'Mobile');
	};

	ContactsPopupView.prototype.addNewWeb = function addNewWeb() {
		this.addNewProperty(__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ContactPropertyType"].Web);
	};

	ContactsPopupView.prototype.addNewNickname = function addNewNickname() {
		this.addNewOrFocusProperty(__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ContactPropertyType"].Nick);
	};

	ContactsPopupView.prototype.addNewNotes = function addNewNotes() {
		this.addNewOrFocusProperty(__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ContactPropertyType"].Note);
	};

	ContactsPopupView.prototype.addNewBirthday = function addNewBirthday() {
		this.addNewOrFocusProperty(__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ContactPropertyType"].Birthday);
	};

	ContactsPopupView.prototype.exportVcf = function exportVcf() {
		Object(__WEBPACK_IMPORTED_MODULE_24_Helper_Apps_User__["a" /* getApp */])().download(Object(__WEBPACK_IMPORTED_MODULE_15_Common_Links__["l" /* exportContactsVcf */])());
	};

	ContactsPopupView.prototype.exportCsv = function exportCsv() {
		Object(__WEBPACK_IMPORTED_MODULE_24_Helper_Apps_User__["a" /* getApp */])().download(Object(__WEBPACK_IMPORTED_MODULE_15_Common_Links__["k" /* exportContactsCsv */])());
	};

	ContactsPopupView.prototype.initUploader = function initUploader() {
		var _this4 = this;

		if (this.importUploaderButton()) {
			var j = new __WEBPACK_IMPORTED_MODULE_9_Jua___default.a({
				'action': Object(__WEBPACK_IMPORTED_MODULE_15_Common_Links__["I" /* uploadContacts */])(),
				'name': 'uploader',
				'queueSize': 1,
				'multipleSizeLimit': 1,
				'disableDragAndDrop': true,
				'disableMultiple': true,
				'disableDocumentDropPrevent': true,
				'clickElement': this.importUploaderButton()
			});

			if (j) {
				j.on('onStart', function () {
					_this4.contacts.importing(true);
				}).on('onComplete', function (id, result, data) {
					_this4.contacts.importing(false);
					_this4.reloadContactList();
					if (!id || !result || !data || !data.Result) {
						__WEBPACK_IMPORTED_MODULE_4_window___default.a.alert(Object(__WEBPACK_IMPORTED_MODULE_16_Common_Translator__["i18n"])('CONTACTS/ERROR_IMPORT_FILE'));
					}
				});
			}
		}
	};

	ContactsPopupView.prototype.removeCheckedOrSelectedContactsFromList = function removeCheckedOrSelectedContactsFromList() {
		var _this5 = this;

		var koContacts = this.contacts,
		    contacts = this.contactsCheckedOrSelected();

		var currentContact = this.currentContact(),
		    count = this.contacts().length;

		if (0 < contacts.length) {
			__WEBPACK_IMPORTED_MODULE_5_____default.a.each(contacts, function (contact) {

				if (currentContact && currentContact.idContact === contact.idContact) {
					currentContact = null;
					_this5.currentContact(null);
				}

				contact.deleted(true);
				count -= 1;
			});

			if (0 >= count) {
				this.bDropPageAfterDelete = true;
			}

			__WEBPACK_IMPORTED_MODULE_5_____default.a.delay(function () {
				__WEBPACK_IMPORTED_MODULE_5_____default.a.each(contacts, function (contact) {
					koContacts.remove(contact);
					Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["delegateRunOnDestroy"])(contact);
				});
			}, __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["Magics"].Time500ms);
		}
	};

	ContactsPopupView.prototype.deleteSelectedContacts = function deleteSelectedContacts() {
		if (0 < this.contactsCheckedOrSelected().length) {
			__WEBPACK_IMPORTED_MODULE_19_Remote_User_Ajax__["a" /* default */].contactsDelete(__WEBPACK_IMPORTED_MODULE_5_____default.a.bind(this.deleteResponse, this), this.contactsCheckedOrSelectedUids());

			this.removeCheckedOrSelectedContactsFromList();
		}
	};

	/**
  * @param {string} sResult
  * @param {AjaxJsonDefaultResponse} oData
  */


	ContactsPopupView.prototype.deleteResponse = function deleteResponse(sResult, oData) {
		var _this6 = this;

		if (__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["Magics"].Time500ms < (__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["StorageResultType"].Success === sResult && oData && oData.Time ? Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["pInt"])(oData.Time) : 0)) {
			this.reloadContactList(this.bDropPageAfterDelete);
		} else {
			__WEBPACK_IMPORTED_MODULE_5_____default.a.delay(function () {
				_this6.reloadContactList(_this6.bDropPageAfterDelete);
			}, __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["Magics"].Time500ms);
		}
	};

	ContactsPopupView.prototype.removeProperty = function removeProperty(oProp) {
		this.viewProperties.remove(oProp);
		Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["delegateRunOnDestroy"])(oProp);
	};

	/**
  * @param {?ContactModel} contact
  */


	ContactsPopupView.prototype.populateViewContact = function populateViewContact(contact) {
		var id = '',
		    lastName = '',
		    firstName = '';
		var list = [];

		this.watchHash(false);

		this.emptySelection(false);
		this.viewReadOnly(false);

		if (contact) {
			id = contact.idContact;
			if (Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isNonEmptyArray"])(contact.properties)) {
				__WEBPACK_IMPORTED_MODULE_5_____default.a.each(contact.properties, function (property) {
					if (property && property[0]) {
						if (__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ContactPropertyType"].LastName === property[0]) {
							lastName = property[1];
						} else if (__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ContactPropertyType"].FirstName === property[0]) {
							firstName = property[1];
						} else {
							list.push(new __WEBPACK_IMPORTED_MODULE_23_Model_ContactProperty__["a" /* ContactPropertyModel */](property[0], property[2] || '', property[1]));
						}
					}
				});
			}

			this.viewReadOnly(!!contact.readOnly);
		}

		list.unshift(new __WEBPACK_IMPORTED_MODULE_23_Model_ContactProperty__["a" /* ContactPropertyModel */](__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ContactPropertyType"].LastName, '', lastName, false, this.getPropertyPlaceholder(__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ContactPropertyType"].LastName)));

		list.unshift(new __WEBPACK_IMPORTED_MODULE_23_Model_ContactProperty__["a" /* ContactPropertyModel */](__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ContactPropertyType"].FirstName, '', firstName, !contact, this.getPropertyPlaceholder(__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["ContactPropertyType"].FirstName)));

		this.viewID(id);

		Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["delegateRunOnDestroy"])(this.viewProperties());

		this.viewProperties([]);
		this.viewProperties(list);

		this.watchDirty(false);
		this.watchHash(true);
	};

	/**
  * @param {boolean=} dropPagePosition = false
  */


	ContactsPopupView.prototype.reloadContactList = function reloadContactList() {
		var _this7 = this;

		var dropPagePosition = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;


		var offset = (this.contactsPage() - 1) * __WEBPACK_IMPORTED_MODULE_12_Common_Consts__["c" /* CONTACTS_PER_PAGE */];

		this.bDropPageAfterDelete = false;

		if (dropPagePosition) {
			this.contactsPage(1);
			offset = 0;
		}

		this.contacts.loading(true);
		__WEBPACK_IMPORTED_MODULE_19_Remote_User_Ajax__["a" /* default */].contacts(function (result, data) {

			var count = 0,
			    list = [];

			if (__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["StorageResultType"].Success === result && data && data.Result && data.Result.List) {
				if (Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isNonEmptyArray"])(data.Result.List)) {
					list = __WEBPACK_IMPORTED_MODULE_5_____default.a.map(data.Result.List, function (item) {
						var contact = new __WEBPACK_IMPORTED_MODULE_22_Model_Contact__["a" /* ContactModel */]();
						return contact.parse(item) ? contact : null;
					});

					list = __WEBPACK_IMPORTED_MODULE_5_____default.a.compact(list);

					count = Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["pInt"])(data.Result.Count);
					count = 0 < count ? count : 0;
				}
			}

			_this7.contactsCount(count);

			Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["delegateRunOnDestroy"])(_this7.contacts());
			_this7.contacts(list);

			_this7.contacts.loading(false);
			_this7.viewClearSearch('' !== _this7.search());
		}, offset, __WEBPACK_IMPORTED_MODULE_12_Common_Consts__["c" /* CONTACTS_PER_PAGE */], this.search());
	};

	ContactsPopupView.prototype.onBuild = function onBuild(dom) {
		var _this8 = this;

		this.oContentVisible = __WEBPACK_IMPORTED_MODULE_6_____default()('.b-list-content', dom);
		this.oContentScrollable = __WEBPACK_IMPORTED_MODULE_6_____default()('.content', this.oContentVisible);

		this.selector.init(this.oContentVisible, this.oContentScrollable, __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["KeyState"].ContactList);

		__WEBPACK_IMPORTED_MODULE_8_key___default()('delete', __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["KeyState"].ContactList, function () {
			_this8.deleteCommand();
			return false;
		});

		__WEBPACK_IMPORTED_MODULE_8_key___default()('c, w', __WEBPACK_IMPORTED_MODULE_10_Common_Enums__["KeyState"].ContactList, function () {
			_this8.newMessageCommand();
			return false;
		});

		var self = this;

		dom.on('click', '.e-pagenator .e-page', function () {
			// eslint-disable-line prefer-arrow-callback
			var page = __WEBPACK_IMPORTED_MODULE_7_ko__["a" /* default */].dataFor(this); // eslint-disable-line no-invalid-this
			if (page) {
				self.contactsPage(Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["pInt"])(page.value));
				self.reloadContactList();
			}
		});

		this.initUploader();
	};

	ContactsPopupView.prototype.onShow = function onShow(bBackToCompose, sLastComposeFocusedField) {
		this.bBackToCompose = Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isUnd"])(bBackToCompose) ? false : !!bBackToCompose;
		this.sLastComposeFocusedField = Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["isUnd"])(sLastComposeFocusedField) ? '' : sLastComposeFocusedField;

		Object(__WEBPACK_IMPORTED_MODULE_25_Knoin_Knoin__["routeOff"])();
		this.reloadContactList(true);
	};

	ContactsPopupView.prototype.onHide = function onHide() {
		Object(__WEBPACK_IMPORTED_MODULE_25_Knoin_Knoin__["routeOn"])();

		this.currentContact(null);
		this.emptySelection(true);
		this.search('');
		this.contactsCount(0);

		Object(__WEBPACK_IMPORTED_MODULE_11_Common_Utils__["delegateRunOnDestroy"])(this.contacts());
		this.contacts([]);

		this.sLastComposeFocusedField = '';

		if (this.bBackToCompose) {
			this.bBackToCompose = false;

			if (__WEBPACK_IMPORTED_MODULE_20_Storage_Settings__["capa"](__WEBPACK_IMPORTED_MODULE_10_Common_Enums__["Capa"].Composer)) {
				Object(__WEBPACK_IMPORTED_MODULE_25_Knoin_Knoin__["showScreenPopup"])(__webpack_require__(/*! View/Popup/Compose */ 43));
			}
		}
	};

	return ContactsPopupView;
}(__WEBPACK_IMPORTED_MODULE_26_Knoin_AbstractViewNext__["a" /* AbstractViewNext */]), (_applyDecoratedDescriptor(_class2.prototype, 'newCommand', [_dec2], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default()(_class2.prototype, 'newCommand'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'deleteCommand', [_dec3], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default()(_class2.prototype, 'deleteCommand'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'newMessageCommand', [_dec4], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default()(_class2.prototype, 'newMessageCommand'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'clearCommand', [_dec5], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default()(_class2.prototype, 'clearCommand'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'saveCommand', [_dec6], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default()(_class2.prototype, 'saveCommand'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'syncCommand', [_dec7], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default()(_class2.prototype, 'syncCommand'), _class2.prototype)), _class2)) || _class);




/***/ }),
/* 182 */
/*!********************************!*\
  !*** ./dev/Common/Selector.js ***!
  \********************************/
/*! exports provided: Selector, default */
/*! exports used: Selector */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Selector; });
/* unused harmony export default */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! $ */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_key__ = __webpack_require__(/*! key */ 19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_key___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_key__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);









var Selector = function () {

	/**
  * @param {koProperty} koList
  * @param {koProperty} koSelectedItem
  * @param {koProperty} koFocusedItem
  * @param {string} sItemSelector
  * @param {string} sItemSelectedSelector
  * @param {string} sItemCheckedSelector
  * @param {string} sItemFocusedSelector
  */
	function Selector(koList, koSelectedItem, koFocusedItem, sItemSelector, sItemSelectedSelector, sItemCheckedSelector, sItemFocusedSelector) {
		var _this = this;

		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, Selector);

		this.selectedItemUseCallback = true;
		this.iSelectNextHelper = 0;
		this.iFocusedNextHelper = 0;
		this.sLastUid = '';
		this.oCallbacks = {};

		this.list = koList;

		this.listChecked = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].computed(function () {
			return __WEBPACK_IMPORTED_MODULE_2_____default.a.filter(_this.list(), function (item) {
				return item.checked();
			});
		}).extend({ rateLimit: 0 });
		this.isListChecked = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].computed(function () {
			return 0 < _this.listChecked().length;
		});

		this.focusedItem = koFocusedItem || __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(null);
		this.selectedItem = koSelectedItem || __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(null);

		this.itemSelectedThrottle = __WEBPACK_IMPORTED_MODULE_2_____default.a.debounce(__WEBPACK_IMPORTED_MODULE_2_____default.a.bind(this.itemSelected, this), 300);

		this.listChecked.subscribe(function (items) {
			if (0 < items.length) {
				if (null === _this.selectedItem()) {
					if (_this.selectedItem.valueHasMutated) {
						_this.selectedItem.valueHasMutated();
					}
				} else {
					_this.selectedItem(null);
				}
			} else if (_this.autoSelect() && _this.focusedItem()) {
				_this.selectedItem(_this.focusedItem());
			}
		}, this);

		this.selectedItem.subscribe(function (item) {

			if (item) {
				if (_this.isListChecked()) {
					__WEBPACK_IMPORTED_MODULE_2_____default.a.each(_this.listChecked(), function (subItem) {
						subItem.checked(false);
					});
				}

				if (_this.selectedItemUseCallback) {
					_this.itemSelectedThrottle(item);
				}
			} else if (_this.selectedItemUseCallback) {
				_this.itemSelected(null);
			}
		}, this);

		this.selectedItem = this.selectedItem.extend({ toggleSubscribeProperty: [this, 'selected'] });
		this.focusedItem = this.focusedItem.extend({ toggleSubscribeProperty: [null, 'focused'] });

		this.sItemSelector = sItemSelector;
		this.sItemSelectedSelector = sItemSelectedSelector;
		this.sItemCheckedSelector = sItemCheckedSelector;
		this.sItemFocusedSelector = sItemFocusedSelector;

		this.focusedItem.subscribe(function (item) {
			if (item) {
				_this.sLastUid = _this.getItemUid(item);
			}
		}, this);

		var aCache = [],
		    aCheckedCache = [],
		    mFocused = null,
		    mSelected = null;

		this.list.subscribe(function (items) {

			if (Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["isArray"])(items)) {
				__WEBPACK_IMPORTED_MODULE_2_____default.a.each(items, function (item) {
					if (item) {
						var uid = _this.getItemUid(item);

						aCache.push(uid);
						if (item.checked()) {
							aCheckedCache.push(uid);
						}
						if (null === mFocused && item.focused()) {
							mFocused = uid;
						}
						if (null === mSelected && item.selected()) {
							mSelected = uid;
						}
					}
				});
			}
		}, this, 'beforeChange');

		this.list.subscribe(function (aItems) {

			var temp = null,
			    getNext = false,
			    isNextFocused = mFocused,
			    isChecked = false,
			    isSelected = false,
			    len = 0;

			var uids = [];

			_this.selectedItemUseCallback = false;

			_this.focusedItem(null);
			_this.selectedItem(null);

			if (Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["isArray"])(aItems)) {
				len = aCheckedCache.length;

				__WEBPACK_IMPORTED_MODULE_2_____default.a.each(aItems, function (item) {

					var uid = _this.getItemUid(item);
					uids.push(uid);

					if (null !== mFocused && mFocused === uid) {
						_this.focusedItem(item);
						mFocused = null;
					}

					if (0 < len && -1 < Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["inArray"])(uid, aCheckedCache)) {
						isChecked = true;
						item.checked(true);
						len -= 1;
					}

					if (!isChecked && null !== mSelected && mSelected === uid) {
						isSelected = true;
						_this.selectedItem(item);
						mSelected = null;
					}
				});

				_this.selectedItemUseCallback = true;

				if (!isChecked && !isSelected && _this.autoSelect()) {
					if (_this.focusedItem()) {
						_this.selectedItem(_this.focusedItem());
					} else if (0 < aItems.length) {
						if (null !== isNextFocused) {
							getNext = false;
							isNextFocused = __WEBPACK_IMPORTED_MODULE_2_____default.a.find(aCache, function (sUid) {
								if (getNext && -1 < Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["inArray"])(sUid, uids)) {
									return sUid;
								} else if (isNextFocused === sUid) {
									getNext = true;
								}
								return false;
							});

							if (isNextFocused) {
								temp = __WEBPACK_IMPORTED_MODULE_2_____default.a.find(aItems, function (oItem) {
									return isNextFocused === _this.getItemUid(oItem);
								});
							}
						}

						_this.selectedItem(temp || null);
						_this.focusedItem(_this.selectedItem());
					}
				}

				if ((0 !== _this.iSelectNextHelper || 0 !== _this.iFocusedNextHelper) && 0 < aItems.length && !_this.focusedItem()) {
					temp = null;
					if (0 !== _this.iFocusedNextHelper) {
						temp = aItems[-1 === _this.iFocusedNextHelper ? aItems.length - 1 : 0] || null;
					}

					if (!temp && 0 !== _this.iSelectNextHelper) {
						temp = aItems[-1 === _this.iSelectNextHelper ? aItems.length - 1 : 0] || null;
					}

					if (temp) {
						if (0 !== _this.iSelectNextHelper) {
							_this.selectedItem(temp || null);
						}

						_this.focusedItem(temp || null);

						_this.scrollToFocused();

						__WEBPACK_IMPORTED_MODULE_2_____default.a.delay(function () {
							return _this.scrollToFocused();
						}, 100);
					}

					_this.iSelectNextHelper = 0;
					_this.iFocusedNextHelper = 0;
				}
			}

			aCache = [];
			aCheckedCache = [];
			mFocused = null;
			mSelected = null;
		});
	}

	Selector.prototype.itemSelected = function itemSelected(item) {

		if (this.isListChecked()) {
			if (!item) {
				(this.oCallbacks.onItemSelect || __WEBPACK_IMPORTED_MODULE_6_Common_Utils__["noop"])(item || null);
			}
		} else if (item) {
			(this.oCallbacks.onItemSelect || __WEBPACK_IMPORTED_MODULE_6_Common_Utils__["noop"])(item);
		}
	};

	/**
  * @param {boolean} forceSelect
  */


	Selector.prototype.goDown = function goDown(forceSelect) {
		this.newSelectPosition(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Down, false, forceSelect);
	};

	/**
  * @param {boolean} forceSelect
  */


	Selector.prototype.goUp = function goUp(forceSelect) {
		this.newSelectPosition(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Up, false, forceSelect);
	};

	Selector.prototype.unselect = function unselect() {
		this.selectedItem(null);
		this.focusedItem(null);
	};

	Selector.prototype.init = function init(contentVisible, contentScrollable) {
		var _this2 = this;

		var keyScope = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'all';


		this.oContentVisible = contentVisible;
		this.oContentScrollable = contentScrollable;

		if (this.oContentVisible && this.oContentScrollable) {
			__WEBPACK_IMPORTED_MODULE_1_____default()(this.oContentVisible).on('selectstart', function (event) {
				if (event && event.preventDefault) {
					event.preventDefault();
				}
			}).on('click', this.sItemSelector, function (event) {
				_this2.actionClick(__WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].dataFor(event.currentTarget), event);
			}).on('click', this.sItemCheckedSelector, function (event) {
				var item = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].dataFor(event.currentTarget);
				if (item) {
					if (event && event.shiftKey) {
						_this2.actionClick(item, event);
					} else {
						_this2.focusedItem(item);
						item.checked(!item.checked());
					}
				}
			});

			__WEBPACK_IMPORTED_MODULE_3_key___default()('enter', keyScope, function () {
				if (_this2.focusedItem() && !_this2.focusedItem().selected()) {
					_this2.actionClick(_this2.focusedItem());
					return false;
				}

				return true;
			});

			__WEBPACK_IMPORTED_MODULE_3_key___default()('ctrl+up, command+up, ctrl+down, command+down', keyScope, function () {
				return false;
			});

			__WEBPACK_IMPORTED_MODULE_3_key___default()('up, shift+up, down, shift+down, home, end, pageup, pagedown, insert, space', keyScope, function (event, handler) {
				if (event && handler && handler.shortcut) {
					var eventKey = 0;
					switch (handler.shortcut) {
						case 'up':
						case 'shift+up':
							eventKey = __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Up;
							break;
						case 'down':
						case 'shift+down':
							eventKey = __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Down;
							break;
						case 'insert':
							eventKey = __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Insert;
							break;
						case 'space':
							eventKey = __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Space;
							break;
						case 'home':
							eventKey = __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Home;
							break;
						case 'end':
							eventKey = __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].End;
							break;
						case 'pageup':
							eventKey = __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].PageUp;
							break;
						case 'pagedown':
							eventKey = __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].PageDown;
							break;
						// no default
					}

					if (0 < eventKey) {
						_this2.newSelectPosition(eventKey, __WEBPACK_IMPORTED_MODULE_3_key___default.a.shift);
						return false;
					}
				}

				return true;
			});
		}
	};

	/**
  * @returns {boolean}
  */


	Selector.prototype.autoSelect = function autoSelect() {
		return !!(this.oCallbacks.onAutoSelect || __WEBPACK_IMPORTED_MODULE_6_Common_Utils__["noopTrue"])();
	};

	/**
  * @param {boolean} up
  */


	Selector.prototype.doUpUpOrDownDown = function doUpUpOrDownDown(up) {
		(this.oCallbacks.onUpUpOrDownDown || __WEBPACK_IMPORTED_MODULE_6_Common_Utils__["noopTrue"])(!!up);
	};

	/**
  * @param {Object} oItem
  * @returns {string}
  */


	Selector.prototype.getItemUid = function getItemUid(item) {

		var uid = '';

		var getItemUidCallback = this.oCallbacks.onItemGetUid || null;
		if (getItemUidCallback && item) {
			uid = getItemUidCallback(item);
		}

		return uid.toString();
	};

	/**
  * @param {number} iEventKeyCode
  * @param {boolean} bShiftKey
  * @param {boolean=} bForceSelect = false
  */


	Selector.prototype.newSelectPosition = function newSelectPosition(iEventKeyCode, bShiftKey, bForceSelect) {

		var index = 0,
		    isNext = false,
		    isStop = false,
		    result = null;

		var pageStep = 10,
		    list = this.list(),
		    listLen = list ? list.length : 0,
		    focused = this.focusedItem();

		if (0 < listLen) {
			if (!focused) {
				if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Down === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Insert === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Space === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Home === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].PageUp === iEventKeyCode) {
					result = list[0];
				} else if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Up === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].End === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].PageDown === iEventKeyCode) {
					result = list[list.length - 1];
				}
			} else if (focused) {
				if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Down === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Up === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Insert === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Space === iEventKeyCode) {
					__WEBPACK_IMPORTED_MODULE_2_____default.a.each(list, function (item) {
						if (!isStop) {
							switch (iEventKeyCode) {
								case __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Up:
									if (focused === item) {
										isStop = true;
									} else {
										result = item;
									}
									break;
								case __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Down:
								case __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Insert:
									if (isNext) {
										result = item;
										isStop = true;
									} else if (focused === item) {
										isNext = true;
									}
									break;
								// no default
							}
						}
					});

					if (!result && (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Down === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Up === iEventKeyCode)) {
						this.doUpUpOrDownDown(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Up === iEventKeyCode);
					}
				} else if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Home === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].End === iEventKeyCode) {
					if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Home === iEventKeyCode) {
						result = list[0];
					} else if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].End === iEventKeyCode) {
						result = list[list.length - 1];
					}
				} else if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].PageDown === iEventKeyCode) {
					for (; index < listLen; index++) {
						if (focused === list[index]) {
							index += pageStep;
							index = listLen - 1 < index ? listLen - 1 : index;
							result = list[index];
							break;
						}
					}
				} else if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].PageUp === iEventKeyCode) {
					for (index = listLen; 0 <= index; index--) {
						if (focused === list[index]) {
							index -= pageStep;
							index = 0 > index ? 0 : index;
							result = list[index];
							break;
						}
					}
				}
			}
		}

		if (result) {
			this.focusedItem(result);

			if (focused) {
				if (bShiftKey) {
					if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Up === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Down === iEventKeyCode) {
						focused.checked(!focused.checked());
					}
				} else if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Insert === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Space === iEventKeyCode) {
					focused.checked(!focused.checked());
				}
			}

			if ((this.autoSelect() || !!bForceSelect) && !this.isListChecked() && __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Space !== iEventKeyCode) {
				this.selectedItem(result);
			}

			this.scrollToFocused();
		} else if (focused) {
			if (bShiftKey && (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Up === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Down === iEventKeyCode)) {
				focused.checked(!focused.checked());
			} else if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Insert === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].Space === iEventKeyCode) {
				focused.checked(!focused.checked());
			}

			this.focusedItem(focused);
		}
	};

	/**
  * @returns {boolean}
  */


	Selector.prototype.scrollToFocused = function scrollToFocused() {

		if (!this.oContentVisible || !this.oContentScrollable) {
			return false;
		}

		var offset = 20,
		    list = this.list(),
		    $focused = __WEBPACK_IMPORTED_MODULE_1_____default()(this.sItemFocusedSelector, this.oContentScrollable),
		    pos = $focused.position(),
		    visibleHeight = this.oContentVisible.height(),
		    focusedHeight = $focused.outerHeight();

		if (list && list[0] && list[0].focused()) {
			this.oContentScrollable.scrollTop(0);
			return true;
		} else if (pos && (0 > pos.top || pos.top + focusedHeight > visibleHeight)) {
			this.oContentScrollable.scrollTop(0 > pos.top ? this.oContentScrollable.scrollTop() + pos.top - offset : this.oContentScrollable.scrollTop() + pos.top - visibleHeight + focusedHeight + offset);

			return true;
		}

		return false;
	};

	/**
  * @param {boolean=} fast = false
  * @returns {boolean}
  */


	Selector.prototype.scrollToTop = function scrollToTop() {
		var fast = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;


		if (!this.oContentVisible || !this.oContentScrollable) {
			return false;
		}

		if (fast || 50 > this.oContentScrollable.scrollTop()) {
			this.oContentScrollable.scrollTop(0);
		} else {
			this.oContentScrollable.stop().animate({ scrollTop: 0 }, 200);
		}

		return true;
	};

	Selector.prototype.eventClickFunction = function eventClickFunction(item, event) {

		var index = 0,
		    length = 0,
		    changeRange = false,
		    isInRange = false,
		    list = [],
		    checked = false,
		    listItem = null,
		    lineUid = '';

		var uid = this.getItemUid(item);
		if (event && event.shiftKey) {
			if ('' !== uid && '' !== this.sLastUid && uid !== this.sLastUid) {
				list = this.list();
				checked = item.checked();

				for (index = 0, length = list.length; index < length; index++) {
					listItem = list[index];
					lineUid = this.getItemUid(listItem);

					changeRange = false;
					if (lineUid === this.sLastUid || lineUid === uid) {
						changeRange = true;
					}

					if (changeRange) {
						isInRange = !isInRange;
					}

					if (isInRange || changeRange) {
						listItem.checked(checked);
					}
				}
			}
		}

		this.sLastUid = '' === uid ? '' : uid;
	};

	/**
  * @param {Object} item
  * @param {Object=} event
  */


	Selector.prototype.actionClick = function actionClick(item) {
		var event = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;


		if (item) {
			var click = true;
			if (event) {
				if (event.shiftKey && !(event.ctrlKey || event.metaKey) && !event.altKey) {
					click = false;
					if ('' === this.sLastUid) {
						this.sLastUid = this.getItemUid(item);
					}

					item.checked(!item.checked());
					this.eventClickFunction(item, event);

					this.focusedItem(item);
				} else if ((event.ctrlKey || event.metaKey) && !event.shiftKey && !event.altKey) {
					click = false;
					this.focusedItem(item);

					if (this.selectedItem() && item !== this.selectedItem()) {
						this.selectedItem().checked(true);
					}

					item.checked(!item.checked());
				}
			}

			if (click) {
				this.selectMessageItem(item);
			}
		}
	};

	Selector.prototype.on = function on(eventName, callback) {
		this.oCallbacks[eventName] = callback;
	};

	Selector.prototype.selectMessageItem = function selectMessageItem(messageItem) {
		this.focusedItem(messageItem);
		this.selectedItem(messageItem);
		this.scrollToFocused();
	};

	return Selector;
}();



/***/ }),
/* 183 */
/*!****************************************!*\
  !*** ./dev/View/Popup/FolderCreate.js ***!
  \****************************************/
/*! exports provided: FolderCreateView, default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FolderCreateView", function() { return FolderCreateView; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return FolderCreateView; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor__ = __webpack_require__(/*! babel-runtime/core-js/object/get-own-property-descriptor */ 15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Consts__ = __webpack_require__(/*! Common/Consts */ 20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__ = __webpack_require__(/*! Stores/User/Folder */ 38);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Promises_User_Ajax__ = __webpack_require__(/*! Promises/User/Ajax */ 94);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_Helper_Apps_User__ = __webpack_require__(/*! Helper/Apps/User */ 16);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13_Knoin_AbstractViewNext__ = __webpack_require__(/*! Knoin/AbstractViewNext */ 13);





var _dec, _dec2, _class, _desc, _value, _class2;

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
	var desc = {};
	Object['ke' + 'ys'](descriptor).forEach(function (key) {
		desc[key] = descriptor[key];
	});
	desc.enumerable = !!desc.enumerable;
	desc.configurable = !!desc.configurable;

	if ('value' in desc || desc.initializer) {
		desc.writable = true;
	}

	desc = decorators.slice().reverse().reduce(function (desc, decorator) {
		return decorator(target, property, desc) || desc;
	}, desc);

	if (context && desc.initializer !== void 0) {
		desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
		desc.initializer = undefined;
	}

	if (desc.initializer === void 0) {
		Object['define' + 'Property'](target, property, desc);
		desc = null;
	}

	return desc;
}

















var FolderCreateView = (_dec = Object(__WEBPACK_IMPORTED_MODULE_12_Knoin_Knoin__["popup"])({
	name: 'View/Popup/FolderCreate',
	templateID: 'PopupsFolderCreate'
}), _dec2 = Object(__WEBPACK_IMPORTED_MODULE_12_Knoin_Knoin__["command"])(function (self) {
	return self.simpleFolderNameValidation(self.folderName());
}), _dec(_class = (_class2 = function (_AbstractViewNext) {
	__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits___default()(FolderCreateView, _AbstractViewNext);

	function FolderCreateView() {
		__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default()(this, FolderCreateView);

		var _this = __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractViewNext.call(this));

		_this.folderName = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable('');
		_this.folderName.focused = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);

		_this.selectedParentValue = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(__WEBPACK_IMPORTED_MODULE_6_Common_Consts__["r" /* UNUSED_OPTION_VALUE */]);

		_this.parentFolderSelectList = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].computed(function () {

			var top = [],
			    list = __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].folderList(),
			    fRenameCallback = function fRenameCallback(oItem) {
				return oItem ? oItem.isSystemFolder() ? oItem.name() + ' ' + oItem.manageFolderSystemName() : oItem.name() : '';
			};

			top.push(['', '']);

			var fDisableCallback = null;
			if ('' !== __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].namespace) {
				fDisableCallback = function fDisableCallback(item) {
					return __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].namespace !== item.fullNameRaw.substr(0, __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].namespace.length);
				};
			}

			return Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["folderListOptionsBuilder"])([], list, [], top, null, fDisableCallback, null, fRenameCallback);
		});

		_this.defautOptionsAfterRender = __WEBPACK_IMPORTED_MODULE_8_Common_Utils__["defautOptionsAfterRender"];
		return _this;
	}

	FolderCreateView.prototype.createFolderCommand = function createFolderCommand() {

		var parentFolderName = this.selectedParentValue();
		if ('' === parentFolderName && 1 < __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].namespace.length) {
			parentFolderName = __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].namespace.substr(0, __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].namespace.length - 1);
		}

		Object(__WEBPACK_IMPORTED_MODULE_11_Helper_Apps_User__["a" /* getApp */])().foldersPromisesActionHelper(__WEBPACK_IMPORTED_MODULE_10_Promises_User_Ajax__["a" /* default */].folderCreate(this.folderName(), parentFolderName, __WEBPACK_IMPORTED_MODULE_9_Stores_User_Folder__["a" /* default */].foldersCreating), __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Notification"].CantCreateFolder);

		this.cancelCommand();
	};

	FolderCreateView.prototype.simpleFolderNameValidation = function simpleFolderNameValidation(sName) {
		return (/^[^\\\/]+$/g.test(Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["trim"])(sName))
		);
	};

	FolderCreateView.prototype.clearPopup = function clearPopup() {
		this.folderName('');
		this.selectedParentValue('');
		this.folderName.focused(false);
	};

	FolderCreateView.prototype.onShow = function onShow() {
		this.clearPopup();
	};

	FolderCreateView.prototype.onShowWithDelay = function onShowWithDelay() {
		if (!__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["bMobileDevice"]) {
			this.folderName.focused(true);
		}
	};

	return FolderCreateView;
}(__WEBPACK_IMPORTED_MODULE_13_Knoin_AbstractViewNext__["a" /* AbstractViewNext */]), (_applyDecoratedDescriptor(_class2.prototype, 'createFolderCommand', [_dec2], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default()(_class2.prototype, 'createFolderCommand'), _class2.prototype)), _class2)) || _class);




/***/ }),
/* 184 */
/*!***********************************!*\
  !*** ./dev/Stores/User/Filter.js ***!
  \***********************************/
/*! exports provided: default */
/*! exports used: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);





var FilterUserStore = function FilterUserStore() {
	__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, FilterUserStore);

	this.capa = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable('');
	this.modules = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable({});

	this.filters = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observableArray([]);

	this.filters.loading = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(false).extend({ throttle: __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["Magics"].Time200ms });
	this.filters.saving = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable(false).extend({ throttle: __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["Magics"].Time200ms });

	this.raw = __WEBPACK_IMPORTED_MODULE_1_ko__["a" /* default */].observable('');
};

/* harmony default export */ __webpack_exports__["a"] = (new FilterUserStore());

/***/ }),
/* 185 */
/*!**********************************!*\
  !*** ./dev/View/Popup/Filter.js ***!
  \**********************************/
/*! exports provided: FilterPopupView, default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FilterPopupView", function() { return FilterPopupView; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return FilterPopupView; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor__ = __webpack_require__(/*! babel-runtime/core-js/object/get-own-property-descriptor */ 15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Stores_User_Filter__ = __webpack_require__(/*! Stores/User/Filter */ 184);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_Stores_User_Folder__ = __webpack_require__(/*! Stores/User/Folder */ 38);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13_Knoin_AbstractViewNext__ = __webpack_require__(/*! Knoin/AbstractViewNext */ 13);





var _dec, _dec2, _class, _desc, _value, _class2;

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
	var desc = {};
	Object['ke' + 'ys'](descriptor).forEach(function (key) {
		desc[key] = descriptor[key];
	});
	desc.enumerable = !!desc.enumerable;
	desc.configurable = !!desc.configurable;

	if ('value' in desc || desc.initializer) {
		desc.writable = true;
	}

	desc = decorators.slice().reverse().reduce(function (desc, decorator) {
		return decorator(target, property, desc) || desc;
	}, desc);

	if (context && desc.initializer !== void 0) {
		desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
		desc.initializer = undefined;
	}

	if (desc.initializer === void 0) {
		Object['define' + 'Property'](target, property, desc);
		desc = null;
	}

	return desc;
}















var FilterPopupView = (_dec = Object(__WEBPACK_IMPORTED_MODULE_12_Knoin_Knoin__["popup"])({
	name: 'View/Popup/Filter',
	templateID: 'PopupsFilter'
}), _dec2 = Object(__WEBPACK_IMPORTED_MODULE_12_Knoin_Knoin__["command"])(), _dec(_class = (_class2 = function (_AbstractViewNext) {
	__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits___default()(FilterPopupView, _AbstractViewNext);

	function FilterPopupView() {
		__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default()(this, FilterPopupView);

		var _this = __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractViewNext.call(this));

		_this.isNew = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(true);

		_this.modules = __WEBPACK_IMPORTED_MODULE_10_Stores_User_Filter__["a" /* default */].modules;

		_this.fTrueCallback = null;
		_this.filter = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(null);

		_this.allowMarkAsRead = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);

		_this.defautOptionsAfterRender = __WEBPACK_IMPORTED_MODULE_8_Common_Utils__["defautOptionsAfterRender"];
		_this.folderSelectList = __WEBPACK_IMPORTED_MODULE_11_Stores_User_Folder__["a" /* default */].folderMenuForFilters;
		_this.selectedFolderValue = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable('');

		_this.selectedFolderValue.subscribe(function () {
			if (_this.filter()) {
				_this.filter().actionValue.error(false);
			}
		});

		_this.actionTypeOptions = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observableArray([]);
		_this.fieldOptions = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observableArray([]);
		_this.typeOptions = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observableArray([]);
		_this.typeOptionsSize = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observableArray([]);

		Object(__WEBPACK_IMPORTED_MODULE_9_Common_Translator__["initOnStartOrLangChange"])(__WEBPACK_IMPORTED_MODULE_4_____default.a.bind(_this.populateOptions, _this));

		_this.modules.subscribe(_this.populateOptions, _this);
		return _this;
	}

	FilterPopupView.prototype.saveFilterCommand = function saveFilterCommand() {

		if (this.filter()) {
			if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FiltersAction"].MoveTo === this.filter().actionType()) {
				this.filter().actionValue(this.selectedFolderValue());
			}

			if (!this.filter().verify()) {
				return false;
			}

			if (this.fTrueCallback) {
				this.fTrueCallback(this.filter());
			}

			if (this.modalVisibility()) {
				Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["delegateRun"])(this, 'closeCommand');
			}
		}

		return true;
	};

	FilterPopupView.prototype.populateOptions = function populateOptions() {
		this.actionTypeOptions([]);

		// this.actionTypeOptions.push({'id': FiltersAction.None,
		// 'name': i18n('POPUPS_FILTER/SELECT_ACTION_NONE')});

		var modules = this.modules();
		if (modules) {
			if (modules.markasread) {
				this.allowMarkAsRead(true);
			}

			if (modules.moveto) {
				this.actionTypeOptions.push({ 'id': __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FiltersAction"].MoveTo,
					'name': Object(__WEBPACK_IMPORTED_MODULE_9_Common_Translator__["i18n"])('POPUPS_FILTER/SELECT_ACTION_MOVE_TO') });
			}

			if (modules.redirect) {
				this.actionTypeOptions.push({ 'id': __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FiltersAction"].Forward,
					'name': Object(__WEBPACK_IMPORTED_MODULE_9_Common_Translator__["i18n"])('POPUPS_FILTER/SELECT_ACTION_FORWARD_TO') });
			}

			if (modules.reject) {
				this.actionTypeOptions.push({ 'id': __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FiltersAction"].Reject,
					'name': Object(__WEBPACK_IMPORTED_MODULE_9_Common_Translator__["i18n"])('POPUPS_FILTER/SELECT_ACTION_REJECT') });
			}

			if (modules.vacation) {
				this.actionTypeOptions.push({ 'id': __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FiltersAction"].Vacation,
					'name': Object(__WEBPACK_IMPORTED_MODULE_9_Common_Translator__["i18n"])('POPUPS_FILTER/SELECT_ACTION_VACATION_MESSAGE') });
			}
		}

		this.actionTypeOptions.push({ 'id': __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FiltersAction"].Discard,
			'name': Object(__WEBPACK_IMPORTED_MODULE_9_Common_Translator__["i18n"])('POPUPS_FILTER/SELECT_ACTION_DISCARD') });

		this.fieldOptions([{ 'id': __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FilterConditionField"].From, 'name': Object(__WEBPACK_IMPORTED_MODULE_9_Common_Translator__["i18n"])('POPUPS_FILTER/SELECT_FIELD_FROM') }, { 'id': __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FilterConditionField"].Recipient, 'name': Object(__WEBPACK_IMPORTED_MODULE_9_Common_Translator__["i18n"])('POPUPS_FILTER/SELECT_FIELD_RECIPIENTS') }, { 'id': __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FilterConditionField"].Subject, 'name': Object(__WEBPACK_IMPORTED_MODULE_9_Common_Translator__["i18n"])('POPUPS_FILTER/SELECT_FIELD_SUBJECT') }, { 'id': __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FilterConditionField"].Size, 'name': Object(__WEBPACK_IMPORTED_MODULE_9_Common_Translator__["i18n"])('POPUPS_FILTER/SELECT_FIELD_SIZE') }, { 'id': __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FilterConditionField"].Header, 'name': Object(__WEBPACK_IMPORTED_MODULE_9_Common_Translator__["i18n"])('POPUPS_FILTER/SELECT_FIELD_HEADER') }]);

		this.typeOptions([{ 'id': __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FilterConditionType"].Contains, 'name': Object(__WEBPACK_IMPORTED_MODULE_9_Common_Translator__["i18n"])('POPUPS_FILTER/SELECT_TYPE_CONTAINS') }, { 'id': __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FilterConditionType"].NotContains, 'name': Object(__WEBPACK_IMPORTED_MODULE_9_Common_Translator__["i18n"])('POPUPS_FILTER/SELECT_TYPE_NOT_CONTAINS') }, { 'id': __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FilterConditionType"].EqualTo, 'name': Object(__WEBPACK_IMPORTED_MODULE_9_Common_Translator__["i18n"])('POPUPS_FILTER/SELECT_TYPE_EQUAL_TO') }, { 'id': __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FilterConditionType"].NotEqualTo, 'name': Object(__WEBPACK_IMPORTED_MODULE_9_Common_Translator__["i18n"])('POPUPS_FILTER/SELECT_TYPE_NOT_EQUAL_TO') }]);

		if (modules && modules.regex) {
			this.typeOptions.push({ 'id': __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FilterConditionType"].Regex, 'name': 'Regex' });
		}

		this.typeOptionsSize([{ 'id': __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FilterConditionType"].Over, 'name': Object(__WEBPACK_IMPORTED_MODULE_9_Common_Translator__["i18n"])('POPUPS_FILTER/SELECT_TYPE_OVER') }, { 'id': __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FilterConditionType"].Under, 'name': Object(__WEBPACK_IMPORTED_MODULE_9_Common_Translator__["i18n"])('POPUPS_FILTER/SELECT_TYPE_UNDER') }]);
	};

	FilterPopupView.prototype.removeCondition = function removeCondition(oConditionToDelete) {
		if (this.filter()) {
			this.filter().removeCondition(oConditionToDelete);
		}
	};

	FilterPopupView.prototype.clearPopup = function clearPopup() {
		this.isNew(true);

		this.fTrueCallback = null;
		this.filter(null);
	};

	FilterPopupView.prototype.onShow = function onShow(oFilter, fTrueCallback, bEdit) {
		this.clearPopup();

		this.fTrueCallback = fTrueCallback;
		this.filter(oFilter);

		if (oFilter) {
			this.selectedFolderValue(oFilter.actionValue());
		}

		this.isNew(!bEdit);

		if (!bEdit && oFilter) {
			oFilter.name.focused(true);
		}
	};

	FilterPopupView.prototype.onShowWithDelay = function onShowWithDelay() {
		if (this.isNew() && this.filter() && !__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["bMobileDevice"]) {
			this.filter().name.focused(true);
		}
	};

	return FilterPopupView;
}(__WEBPACK_IMPORTED_MODULE_13_Knoin_AbstractViewNext__["a" /* AbstractViewNext */]), (_applyDecoratedDescriptor(_class2.prototype, 'saveFilterCommand', [_dec2], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default()(_class2.prototype, 'saveFilterCommand'), _class2.prototype)), _class2)) || _class);




/***/ }),
/* 186 */
/*!**************************************************!*\
  !*** ./dev/View/Popup/TwoFactorConfiguration.js ***!
  \**************************************************/
/*! exports provided: TwoFactorConfigurationPopupView, default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TwoFactorConfigurationPopupView", function() { return TwoFactorConfigurationPopupView; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return TwoFactorConfigurationPopupView; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_window__ = __webpack_require__(/*! window */ 11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_window___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_window__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_qr__ = __webpack_require__(/*! qr */ 250);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_qr___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_qr__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_Remote_User_Ajax__ = __webpack_require__(/*! Remote/User/Ajax */ 17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_Helper_Apps_User__ = __webpack_require__(/*! Helper/Apps/User */ 16);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14_Knoin_AbstractViewNext__ = __webpack_require__(/*! Knoin/AbstractViewNext */ 13);




var _dec, _class;



















var TwoFactorConfigurationPopupView = (_dec = Object(__WEBPACK_IMPORTED_MODULE_13_Knoin_Knoin__["popup"])({
	name: 'View/Popup/TwoFactorConfiguration',
	templateID: 'PopupsTwoFactorConfiguration'
}), _dec(_class = function (_AbstractViewNext) {
	__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(TwoFactorConfigurationPopupView, _AbstractViewNext);

	function TwoFactorConfigurationPopupView() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, TwoFactorConfigurationPopupView);

		var _this = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractViewNext.call(this));

		_this.lock = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);

		_this.capaTwoFactor = __WEBPACK_IMPORTED_MODULE_10_Storage_Settings__["capa"](__WEBPACK_IMPORTED_MODULE_7_Common_Enums__["Capa"].TwoFactor);

		_this.processing = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);
		_this.clearing = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);
		_this.secreting = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);

		_this.viewUser = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable('');
		_this.twoFactorStatus = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);

		_this.twoFactorTested = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);

		_this.viewSecret = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable('');
		_this.viewBackupCodes = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable('');
		_this.viewUrlTitle = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable('');
		_this.viewUrl = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable('');

		_this.viewEnable_ = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);

		_this.viewEnable = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].computed({
			read: _this.viewEnable_,
			write: function write(value) {
				value = !!value;
				if (value && _this.twoFactorTested()) {
					_this.viewEnable_(value);
					__WEBPACK_IMPORTED_MODULE_11_Remote_User_Ajax__["a" /* default */].enableTwoFactor(function (result, data) {
						if (__WEBPACK_IMPORTED_MODULE_7_Common_Enums__["StorageResultType"].Success !== result || !data || !data.Result) {
							_this.viewEnable_(false);
						}
					}, true);
				} else {
					if (!value) {
						_this.viewEnable_(value);
					}

					__WEBPACK_IMPORTED_MODULE_11_Remote_User_Ajax__["a" /* default */].enableTwoFactor(function (result, data) {
						if (__WEBPACK_IMPORTED_MODULE_7_Common_Enums__["StorageResultType"].Success !== result || !data || !data.Result) {
							_this.viewEnable_(false);
						}
					}, false);
				}
			}
		});

		_this.viewTwoFactorEnableTooltip = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].computed(function () {
			Object(__WEBPACK_IMPORTED_MODULE_9_Common_Translator__["trigger"])();
			return _this.twoFactorTested() || _this.viewEnable_() ? '' : Object(__WEBPACK_IMPORTED_MODULE_9_Common_Translator__["i18n"])('POPUPS_TWO_FACTOR_CFG/TWO_FACTOR_SECRET_TEST_BEFORE_DESC');
		});

		_this.viewTwoFactorStatus = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].computed(function () {
			Object(__WEBPACK_IMPORTED_MODULE_9_Common_Translator__["trigger"])();
			return Object(__WEBPACK_IMPORTED_MODULE_9_Common_Translator__["i18n"])(_this.twoFactorStatus() ? 'POPUPS_TWO_FACTOR_CFG/TWO_FACTOR_SECRET_CONFIGURED_DESC' : 'POPUPS_TWO_FACTOR_CFG/TWO_FACTOR_SECRET_NOT_CONFIGURED_DESC');
		});

		_this.twoFactorAllowedEnable = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].computed(function () {
			return _this.viewEnable() || _this.twoFactorTested();
		});

		_this.onResult = __WEBPACK_IMPORTED_MODULE_4_____default.a.bind(_this.onResult, _this);
		_this.onShowSecretResult = __WEBPACK_IMPORTED_MODULE_4_____default.a.bind(_this.onShowSecretResult, _this);
		return _this;
	}

	TwoFactorConfigurationPopupView.prototype.showSecret = function showSecret() {
		this.secreting(true);
		__WEBPACK_IMPORTED_MODULE_11_Remote_User_Ajax__["a" /* default */].showTwoFactorSecret(this.onShowSecretResult);
	};

	TwoFactorConfigurationPopupView.prototype.hideSecret = function hideSecret() {
		this.viewSecret('');
		this.viewBackupCodes('');
		this.viewUrlTitle('');
		this.viewUrl('');
	};

	TwoFactorConfigurationPopupView.prototype.createTwoFactor = function createTwoFactor() {
		this.processing(true);
		__WEBPACK_IMPORTED_MODULE_11_Remote_User_Ajax__["a" /* default */].createTwoFactor(this.onResult);
	};

	TwoFactorConfigurationPopupView.prototype.logout = function logout() {
		Object(__WEBPACK_IMPORTED_MODULE_12_Helper_Apps_User__["a" /* getApp */])().logout();
	};

	TwoFactorConfigurationPopupView.prototype.testTwoFactor = function testTwoFactor() {
		Object(__WEBPACK_IMPORTED_MODULE_13_Knoin_Knoin__["showScreenPopup"])(__webpack_require__(/*! View/Popup/TwoFactorTest */ 251), [this.twoFactorTested]);
	};

	TwoFactorConfigurationPopupView.prototype.clearTwoFactor = function clearTwoFactor() {
		this.viewSecret('');
		this.viewBackupCodes('');
		this.viewUrlTitle('');
		this.viewUrl('');

		this.twoFactorTested(false);

		this.clearing(true);
		__WEBPACK_IMPORTED_MODULE_11_Remote_User_Ajax__["a" /* default */].clearTwoFactor(this.onResult);
	};

	TwoFactorConfigurationPopupView.prototype.onShow = function onShow(bLock) {
		this.lock(!!bLock);

		this.viewSecret('');
		this.viewBackupCodes('');
		this.viewUrlTitle('');
		this.viewUrl('');
	};

	TwoFactorConfigurationPopupView.prototype.onHide = function onHide() {
		if (this.lock()) {
			__WEBPACK_IMPORTED_MODULE_3_window___default.a.location.reload();
		}
	};

	TwoFactorConfigurationPopupView.prototype.getQr = function getQr() {
		return 'otpauth://totp/' + __WEBPACK_IMPORTED_MODULE_3_window___default.a.encodeURIComponent(this.viewUser()) + '?secret=' + __WEBPACK_IMPORTED_MODULE_3_window___default.a.encodeURIComponent(this.viewSecret()) + '&issuer=' + __WEBPACK_IMPORTED_MODULE_3_window___default.a.encodeURIComponent('');
	};

	TwoFactorConfigurationPopupView.prototype.onResult = function onResult(sResult, oData) {
		this.processing(false);
		this.clearing(false);

		if (__WEBPACK_IMPORTED_MODULE_7_Common_Enums__["StorageResultType"].Success === sResult && oData && oData.Result) {
			this.viewUser(Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["pString"])(oData.Result.User));
			this.viewEnable_(!!oData.Result.Enable);
			this.twoFactorStatus(!!oData.Result.IsSet);
			this.twoFactorTested(!!oData.Result.Tested);

			this.viewSecret(Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["pString"])(oData.Result.Secret));
			this.viewBackupCodes(Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["pString"])(oData.Result.BackupCodes).replace(/[\s]+/g, '  '));

			this.viewUrlTitle(Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["pString"])(oData.Result.UrlTitle));
			this.viewUrl(__WEBPACK_IMPORTED_MODULE_6_qr___default.a.toDataURL({ level: 'M', size: 8, value: this.getQr() }));
		} else {
			this.viewUser('');
			this.viewEnable_(false);
			this.twoFactorStatus(false);
			this.twoFactorTested(false);

			this.viewSecret('');
			this.viewBackupCodes('');
			this.viewUrlTitle('');
			this.viewUrl('');
		}
	};

	TwoFactorConfigurationPopupView.prototype.onShowSecretResult = function onShowSecretResult(result, data) {
		this.secreting(false);

		if (__WEBPACK_IMPORTED_MODULE_7_Common_Enums__["StorageResultType"].Success === result && data && data.Result) {
			this.viewSecret(Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["pString"])(data.Result.Secret));
			this.viewUrlTitle(Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["pString"])(data.Result.UrlTitle));
			this.viewUrl(__WEBPACK_IMPORTED_MODULE_6_qr___default.a.toDataURL({ level: 'M', size: 6, value: this.getQr() }));
		} else {
			this.viewSecret('');
			this.viewUrlTitle('');
			this.viewUrl('');
		}
	};

	TwoFactorConfigurationPopupView.prototype.onBuild = function onBuild() {
		if (this.capaTwoFactor) {
			this.processing(true);
			__WEBPACK_IMPORTED_MODULE_11_Remote_User_Ajax__["a" /* default */].getTwoFactor(this.onResult);
		}
	};

	return TwoFactorConfigurationPopupView;
}(__WEBPACK_IMPORTED_MODULE_14_Knoin_AbstractViewNext__["a" /* AbstractViewNext */])) || _class);




/***/ }),
/* 187 */
/*!************************************!*\
  !*** ./dev/View/Popup/Template.js ***!
  \************************************/
/*! exports provided: TemplatePopupView, default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TemplatePopupView", function() { return TemplatePopupView; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return TemplatePopupView; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor__ = __webpack_require__(/*! babel-runtime/core-js/object/get-own-property-descriptor */ 15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Common_HtmlEditor__ = __webpack_require__(/*! Common/HtmlEditor */ 85);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Remote_User_Ajax__ = __webpack_require__(/*! Remote/User/Ajax */ 17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Helper_Apps_User__ = __webpack_require__(/*! Helper/Apps/User */ 16);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_Knoin_AbstractViewNext__ = __webpack_require__(/*! Knoin/AbstractViewNext */ 13);





var _dec, _dec2, _class, _desc, _value, _class2;

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
	var desc = {};
	Object['ke' + 'ys'](descriptor).forEach(function (key) {
		desc[key] = descriptor[key];
	});
	desc.enumerable = !!desc.enumerable;
	desc.configurable = !!desc.configurable;

	if ('value' in desc || desc.initializer) {
		desc.writable = true;
	}

	desc = decorators.slice().reverse().reduce(function (desc, decorator) {
		return decorator(target, property, desc) || desc;
	}, desc);

	if (context && desc.initializer !== void 0) {
		desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
		desc.initializer = undefined;
	}

	if (desc.initializer === void 0) {
		Object['define' + 'Property'](target, property, desc);
		desc = null;
	}

	return desc;
}















var TemplatePopupView = (_dec = Object(__WEBPACK_IMPORTED_MODULE_11_Knoin_Knoin__["popup"])({
	name: 'View/Popup/Template',
	templateID: 'PopupsTemplate'
}), _dec2 = Object(__WEBPACK_IMPORTED_MODULE_11_Knoin_Knoin__["command"])(function (self) {
	return !self.submitRequest();
}), _dec(_class = (_class2 = function (_AbstractViewNext) {
	__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits___default()(TemplatePopupView, _AbstractViewNext);

	function TemplatePopupView() {
		__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default()(this, TemplatePopupView);

		var _this = __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractViewNext.call(this));

		_this.editor = null;
		_this.signatureDom = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(null);

		_this.id = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable('');

		_this.name = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable('');
		_this.name.error = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);
		_this.name.focus = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);

		_this.body = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable('');
		_this.body.loading = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);
		_this.body.error = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);

		_this.name.subscribe(function () {
			_this.name.error(false);
		});

		_this.body.subscribe(function () {
			_this.body.error(false);
		});

		_this.submitRequest = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable(false);
		_this.submitError = __WEBPACK_IMPORTED_MODULE_4_ko__["a" /* default */].observable('');
		return _this;
	}

	TemplatePopupView.prototype.addTemplateCommand = function addTemplateCommand() {
		var _this2 = this;

		this.populateBodyFromEditor();

		this.name.error('' === Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["trim"])(this.name()));
		this.body.error('' === Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["trim"])(this.body()) || ':HTML:' === Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["trim"])(this.body()));

		if (this.name.error() || this.body.error()) {
			return false;
		}

		this.submitRequest(true);

		__WEBPACK_IMPORTED_MODULE_9_Remote_User_Ajax__["a" /* default */].templateSetup(function (result, data) {

			_this2.submitRequest(false);
			if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["StorageResultType"].Success === result && data) {
				if (data.Result) {
					Object(__WEBPACK_IMPORTED_MODULE_10_Helper_Apps_User__["a" /* getApp */])().templates();
					_this2.cancelCommand();
				} else if (data.ErrorCode) {
					_this2.submitError(Object(__WEBPACK_IMPORTED_MODULE_7_Common_Translator__["getNotification"])(data.ErrorCode));
				}
			} else {
				_this2.submitError(Object(__WEBPACK_IMPORTED_MODULE_7_Common_Translator__["getNotification"])(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["Notification"].UnknownError));
			}
		}, this.id(), this.name(), this.body());

		return true;
	};

	TemplatePopupView.prototype.clearPopup = function clearPopup() {
		this.id('');

		this.name('');
		this.name.error(false);

		this.body('');
		this.body.loading(false);
		this.body.error(false);

		this.submitRequest(false);
		this.submitError('');

		if (this.editor) {
			this.editor.setPlain('', false);
		}
	};

	TemplatePopupView.prototype.populateBodyFromEditor = function populateBodyFromEditor() {
		if (this.editor) {
			this.body(this.editor.getDataWithHtmlMark());
		}
	};

	TemplatePopupView.prototype.editorSetBody = function editorSetBody(sBody) {
		var _this3 = this;

		if (!this.editor && this.signatureDom()) {
			this.editor = new __WEBPACK_IMPORTED_MODULE_8_Common_HtmlEditor__["HtmlEditor"](this.signatureDom(), function () {
				_this3.populateBodyFromEditor();
			}, function () {
				_this3.editor.setHtmlOrPlain(sBody);
			});
		} else {
			this.editor.setHtmlOrPlain(sBody);
		}
	};

	TemplatePopupView.prototype.onShow = function onShow(template) {
		var _this4 = this;

		this.clearPopup();

		if (template && template.id) {
			this.id(template.id);
			this.name(template.name);
			this.body(template.body);

			if (template.populated) {
				this.editorSetBody(this.body());
			} else {
				this.body.loading(true);
				this.body.error(false);

				__WEBPACK_IMPORTED_MODULE_9_Remote_User_Ajax__["a" /* default */].templateGetById(function (result, data) {

					_this4.body.loading(false);

					if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["StorageResultType"].Success === result && data && data.Result && 'Object/Template' === data.Result['@Object'] && Object(__WEBPACK_IMPORTED_MODULE_6_Common_Utils__["isNormal"])(data.Result.Body)) {
						template.body = data.Result.Body;
						template.populated = true;

						_this4.body(template.body);
						_this4.body.error(false);
					} else {
						_this4.body('');
						_this4.body.error(true);
					}

					_this4.editorSetBody(_this4.body());
				}, this.id());
			}
		} else {
			this.editorSetBody('');
		}
	};

	TemplatePopupView.prototype.onShowWithDelay = function onShowWithDelay() {
		this.name.focus(true);
	};

	return TemplatePopupView;
}(__WEBPACK_IMPORTED_MODULE_12_Knoin_AbstractViewNext__["a" /* AbstractViewNext */]), (_applyDecoratedDescriptor(_class2.prototype, 'addTemplateCommand', [_dec2], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default()(_class2.prototype, 'addTemplateCommand'), _class2.prototype)), _class2)) || _class);




/***/ }),
/* 188 */,
/* 189 */,
/* 190 */,
/* 191 */,
/* 192 */,
/* 193 */,
/* 194 */,
/* 195 */,
/* 196 */,
/* 197 */,
/* 198 */,
/* 199 */,
/* 200 */,
/* 201 */,
/* 202 */,
/* 203 */,
/* 204 */,
/* 205 */,
/* 206 */,
/* 207 */,
/* 208 */,
/* 209 */,
/* 210 */,
/* 211 */,
/* 212 */
/*!********************!*\
  !*** ./dev/app.js ***!
  \********************/
/*! exports provided:  */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_bootstrap__ = __webpack_require__(/*! bootstrap */ 104);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_App_User__ = __webpack_require__(/*! App/User */ 173);




Object(__WEBPACK_IMPORTED_MODULE_0_bootstrap__["a" /* default */])(__WEBPACK_IMPORTED_MODULE_1_App_User__["default"]);

/***/ }),
/* 213 */
/*!******************************************!*\
  !*** ./dev/View/Popup/MessageOpenPgp.js ***!
  \******************************************/
/*! exports provided: MessageOpenPgpPopupView, default */
/*! all exports used */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MessageOpenPgpPopupView", function() { return MessageOpenPgpPopupView; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return MessageOpenPgpPopupView; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor__ = __webpack_require__(/*! babel-runtime/core-js/object/get-own-property-descriptor */ 15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_key__ = __webpack_require__(/*! key */ 19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_key___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_key__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7____ = __webpack_require__(/*! $ */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_7____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_Knoin_AbstractViewNext__ = __webpack_require__(/*! Knoin/AbstractViewNext */ 13);





var _dec, _dec2, _class, _desc, _value, _class2;

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
	var desc = {};
	Object['ke' + 'ys'](descriptor).forEach(function (key) {
		desc[key] = descriptor[key];
	});
	desc.enumerable = !!desc.enumerable;
	desc.configurable = !!desc.configurable;

	if ('value' in desc || desc.initializer) {
		desc.writable = true;
	}

	desc = decorators.slice().reverse().reduce(function (desc, decorator) {
		return decorator(target, property, desc) || desc;
	}, desc);

	if (context && desc.initializer !== void 0) {
		desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
		desc.initializer = undefined;
	}

	if (desc.initializer === void 0) {
		Object['define' + 'Property'](target, property, desc);
		desc = null;
	}

	return desc;
}












var MessageOpenPgpPopupView = (_dec = Object(__WEBPACK_IMPORTED_MODULE_10_Knoin_Knoin__["popup"])({
	name: 'View/Popup/MessageOpenPgp',
	templateID: 'PopupsMessageOpenPgp'
}), _dec2 = Object(__WEBPACK_IMPORTED_MODULE_10_Knoin_Knoin__["command"])(function (self) {
	return !self.submitRequest();
}), _dec(_class = (_class2 = function (_AbstractViewNext) {
	__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits___default()(MessageOpenPgpPopupView, _AbstractViewNext);

	function MessageOpenPgpPopupView() {
		__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default()(this, MessageOpenPgpPopupView);

		var _this = __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractViewNext.call(this));

		_this.notification = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable('');

		_this.selectedKey = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(null);
		_this.privateKeys = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observableArray([]);

		_this.password = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable('');
		_this.password.focus = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);
		_this.buttonFocus = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);

		_this.resultCallback = null;

		_this.submitRequest = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);

		_this.sDefaultKeyScope = __WEBPACK_IMPORTED_MODULE_9_Common_Enums__["KeyState"].PopupMessageOpenPGP;
		return _this;
	}

	MessageOpenPgpPopupView.prototype.doCommand = function doCommand() {
		var _this2 = this;

		this.submitRequest(true);

		__WEBPACK_IMPORTED_MODULE_4_____default.a.delay(function () {

			var privateKey = null;

			try {
				if (_this2.resultCallback && _this2.selectedKey()) {
					var privateKeys = _this2.selectedKey().getNativeKeys();
					privateKey = privateKeys && privateKeys[0] ? privateKeys[0] : null;

					if (privateKey) {
						try {
							if (!privateKey.decrypt(Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["pString"])(_this2.password()))) {
								Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["log"])('Error: Private key cannot be decrypted');
								privateKey = null;
							}
						} catch (e) {
							Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["log"])(e);
							privateKey = null;
						}
					} else {
						Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["log"])('Error: Private key cannot be found');
					}
				}
			} catch (e) {
				Object(__WEBPACK_IMPORTED_MODULE_8_Common_Utils__["log"])(e);
				privateKey = null;
			}

			_this2.submitRequest(false);

			_this2.cancelCommand();
			_this2.resultCallback(privateKey);
		}, __WEBPACK_IMPORTED_MODULE_9_Common_Enums__["Magics"].Time100ms);
	};

	MessageOpenPgpPopupView.prototype.clearPopup = function clearPopup() {
		this.notification('');

		this.password('');
		this.password.focus(false);
		this.buttonFocus(false);

		this.selectedKey(false);
		this.submitRequest(false);

		this.resultCallback = null;
		this.privateKeys([]);
	};

	MessageOpenPgpPopupView.prototype.onBuild = function onBuild(oDom) {
		var _this3 = this;

		__WEBPACK_IMPORTED_MODULE_6_key___default()('tab,shift+tab', __WEBPACK_IMPORTED_MODULE_9_Common_Enums__["KeyState"].PopupMessageOpenPGP, function () {

			switch (true) {
				case _this3.password.focus():
					_this3.buttonFocus(true);
					break;
				case _this3.buttonFocus():
					_this3.password.focus(true);
					break;
				// no default
			}

			return false;
		});

		var self = this;

		oDom.on('click', '.key-list__item', function () {
			// eslint-disable-line prefer-arrow-callback

			oDom.find('.key-list__item .key-list__item__radio').addClass('icon-radio-unchecked').removeClass('icon-radio-checked');

			__WEBPACK_IMPORTED_MODULE_7_____default()(this).find('.key-list__item__radio') // eslint-disable-line no-invalid-this
			.removeClass('icon-radio-unchecked').addClass('icon-radio-checked');

			self.selectedKey(__WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].dataFor(this)); // eslint-disable-line no-invalid-this

			self.password.focus(true);
		});
	};

	MessageOpenPgpPopupView.prototype.onHideWithDelay = function onHideWithDelay() {
		this.clearPopup();
	};

	MessageOpenPgpPopupView.prototype.onShowWithDelay = function onShowWithDelay() {
		this.password.focus(true);
		//		this.buttonFocus(true);
	};

	MessageOpenPgpPopupView.prototype.onShow = function onShow(fCallback, privateKeys) {
		this.clearPopup();

		this.resultCallback = fCallback;
		this.privateKeys(privateKeys);

		if (this.viewModelDom) {
			this.viewModelDom.find('.key-list__item').first().click();
		}
	};

	return MessageOpenPgpPopupView;
}(__WEBPACK_IMPORTED_MODULE_11_Knoin_AbstractViewNext__["a" /* AbstractViewNext */]), (_applyDecoratedDescriptor(_class2.prototype, 'doCommand', [_dec2], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default()(_class2.prototype, 'doCommand'), _class2.prototype)), _class2)) || _class);




/***/ }),
/* 214 */
/*!******************************!*\
  !*** ./dev/Model/Message.js ***!
  \******************************/
/*! exports provided: MessageModel, default */
/*! exports used: MessageModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return MessageModel; });
/* unused harmony export default */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__ = __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__ = __webpack_require__(/*! babel-runtime/helpers/inherits */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3____ = __webpack_require__(/*! _ */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4____ = __webpack_require__(/*! $ */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_____default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4____);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_ko__ = __webpack_require__(/*! ko */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_moment__ = __webpack_require__(/*! moment */ 75);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_moment___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_moment__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_classnames__ = __webpack_require__(/*! classnames */ 215);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_7_classnames__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_lozad__ = __webpack_require__(/*! lozad */ 216);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_lozad___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_8_lozad__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_Common_Consts__ = __webpack_require__(/*! Common/Consts */ 20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14_Common_Links__ = __webpack_require__(/*! Common/Links */ 14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15_Stores_User_Folder__ = __webpack_require__(/*! Stores/User/Folder */ 38);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_16_Stores_User_Pgp__ = __webpack_require__(/*! Stores/User/Pgp */ 53);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_17_Helper_Message__ = __webpack_require__(/*! Helper/Message */ 175);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_18_Model_Attachment__ = __webpack_require__(/*! Model/Attachment */ 176);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_19_Knoin_AbstractModel__ = __webpack_require__(/*! Knoin/AbstractModel */ 42);




























var MessageModel = function (_AbstractModel) {
	__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_inherits___default()(MessageModel, _AbstractModel);

	function MessageModel() {
		__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_classCallCheck___default()(this, MessageModel);

		var _this = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_possibleConstructorReturn___default()(this, _AbstractModel.call(this, 'MessageModel'));

		_this.folderFullNameRaw = '';
		_this.uid = '';
		_this.hash = '';
		_this.requestHash = '';
		_this.subject = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable('');
		_this.subjectPrefix = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable('');
		_this.subjectSuffix = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable('');
		_this.size = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(0);
		_this.dateTimeStampInUTC = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(0);
		_this.priority = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(__WEBPACK_IMPORTED_MODULE_9_Common_Enums__["MessagePriority"].Normal);

		_this.proxy = false;

		_this.fromEmailString = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable('');
		_this.fromClearEmailString = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable('');
		_this.toEmailsString = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable('');
		_this.toClearEmailsString = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable('');

		_this.senderEmailsString = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable('');
		_this.senderClearEmailsString = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable('');

		_this.emails = [];

		_this.from = [];
		_this.to = [];
		_this.cc = [];
		_this.bcc = [];
		_this.replyTo = [];
		_this.deliveredTo = [];
		_this.unsubsribeLinks = [];

		_this.newForAnimation = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);

		_this.deleted = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);
		_this.deletedMark = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);
		_this.unseen = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);
		_this.flagged = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);
		_this.answered = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);
		_this.forwarded = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);
		_this.isReadReceipt = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);

		_this.focused = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);
		_this.selected = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);
		_this.checked = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);
		_this.hasAttachments = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);
		_this.attachmentsSpecData = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observableArray([]);

		_this.attachmentIconClass = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].computed(function () {
			return Object(__WEBPACK_IMPORTED_MODULE_18_Model_Attachment__["b" /* staticCombinedIconClass */])(_this.hasAttachments() ? _this.attachmentsSpecData() : []);
		});

		_this.body = null;

		_this.isHtml = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);
		_this.hasImages = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);
		_this.attachments = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observableArray([]);

		_this.isPgpSigned = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);
		_this.isPgpEncrypted = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);
		_this.pgpSignedVerifyStatus = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(__WEBPACK_IMPORTED_MODULE_9_Common_Enums__["SignedVerifyStatus"].None);
		_this.pgpSignedVerifyUser = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable('');

		_this.priority = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(__WEBPACK_IMPORTED_MODULE_9_Common_Enums__["MessagePriority"].Normal);
		_this.readReceipt = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable('');

		_this.aDraftInfo = [];
		_this.sMessageId = '';
		_this.sInReplyTo = '';
		_this.sReferences = '';

		_this.hasUnseenSubMessage = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);
		_this.hasFlaggedSubMessage = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observable(false);

		_this.threads = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].observableArray([]);

		_this.threadsLen = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].computed(function () {
			return _this.threads().length;
		});
		_this.isImportant = __WEBPACK_IMPORTED_MODULE_5_ko__["a" /* default */].computed(function () {
			return __WEBPACK_IMPORTED_MODULE_9_Common_Enums__["MessagePriority"].High === _this.priority();
		});

		_this.regDisposables([_this.attachmentIconClass, _this.threadsLen, _this.isImportant]);
		return _this;
	}

	/**
  * @static
  * @param {AjaxJsonMessage} oJsonMessage
  * @returns {?MessageModel}
  */


	MessageModel.newInstanceFromJson = function newInstanceFromJson(json) {
		var oMessageModel = new MessageModel();
		return oMessageModel.initByJson(json) ? oMessageModel : null;
	};

	MessageModel.prototype.clear = function clear() {
		this.folderFullNameRaw = '';
		this.uid = '';
		this.hash = '';
		this.requestHash = '';
		this.subject('');
		this.subjectPrefix('');
		this.subjectSuffix('');
		this.size(0);
		this.dateTimeStampInUTC(0);
		this.priority(__WEBPACK_IMPORTED_MODULE_9_Common_Enums__["MessagePriority"].Normal);

		this.proxy = false;

		this.fromEmailString('');
		this.fromClearEmailString('');
		this.toEmailsString('');
		this.toClearEmailsString('');
		this.senderEmailsString('');
		this.senderClearEmailsString('');

		this.emails = [];

		this.from = [];
		this.to = [];
		this.cc = [];
		this.bcc = [];
		this.replyTo = [];
		this.deliveredTo = [];
		this.unsubsribeLinks = [];

		this.newForAnimation(false);

		this.deleted(false);
		this.deletedMark(false);
		this.unseen(false);
		this.flagged(false);
		this.answered(false);
		this.forwarded(false);
		this.isReadReceipt(false);

		this.selected(false);
		this.checked(false);
		this.hasAttachments(false);
		this.attachmentsSpecData([]);

		this.body = null;
		this.isHtml(false);
		this.hasImages(false);
		this.attachments([]);

		this.isPgpSigned(false);
		this.isPgpEncrypted(false);
		this.pgpSignedVerifyStatus(__WEBPACK_IMPORTED_MODULE_9_Common_Enums__["SignedVerifyStatus"].None);
		this.pgpSignedVerifyUser('');

		this.priority(__WEBPACK_IMPORTED_MODULE_9_Common_Enums__["MessagePriority"].Normal);
		this.readReceipt('');
		this.aDraftInfo = [];
		this.sMessageId = '';
		this.sInReplyTo = '';
		this.sReferences = '';

		this.threads([]);

		this.hasUnseenSubMessage(false);
		this.hasFlaggedSubMessage(false);
	};

	/**
  * @param {Array} properties
  * @returns {Array}
  */


	MessageModel.prototype.getEmails = function getEmails(properties) {
		var _this2 = this;

		return __WEBPACK_IMPORTED_MODULE_3_____default.a.compact(__WEBPACK_IMPORTED_MODULE_3_____default.a.uniq(__WEBPACK_IMPORTED_MODULE_3_____default.a.map(__WEBPACK_IMPORTED_MODULE_3_____default.a.reduce(properties, function (carry, property) {
			return carry.concat(_this2[property]);
		}, []), function (oItem) {
			return oItem ? oItem.email : '';
		})));
	};

	/**
  * @returns {Array}
  */


	MessageModel.prototype.getRecipientsEmails = function getRecipientsEmails() {
		return this.getEmails(['to', 'cc']);
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.friendlySize = function friendlySize() {
		return Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["friendlySize"])(this.size());
	};

	MessageModel.prototype.computeSenderEmail = function computeSenderEmail() {
		var sentFolder = __WEBPACK_IMPORTED_MODULE_15_Stores_User_Folder__["a" /* default */].sentFolder(),
		    draftFolder = __WEBPACK_IMPORTED_MODULE_15_Stores_User_Folder__["a" /* default */].draftFolder();

		this.senderEmailsString(this.folderFullNameRaw === sentFolder || this.folderFullNameRaw === draftFolder ? this.toEmailsString() : this.fromEmailString());

		this.senderClearEmailsString(this.folderFullNameRaw === sentFolder || this.folderFullNameRaw === draftFolder ? this.toClearEmailsString() : this.fromClearEmailString());
	};

	/**
  * @param {AjaxJsonMessage} json
  * @returns {boolean}
  */


	MessageModel.prototype.initByJson = function initByJson(json) {
		var result = false,
		    priority = __WEBPACK_IMPORTED_MODULE_9_Common_Enums__["MessagePriority"].Normal;

		if (json && 'Object/Message' === json['@Object']) {
			priority = Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["pInt"])(json.Priority);
			this.priority(-1 < Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["inArray"])(priority, [__WEBPACK_IMPORTED_MODULE_9_Common_Enums__["MessagePriority"].High, __WEBPACK_IMPORTED_MODULE_9_Common_Enums__["MessagePriority"].Low]) ? priority : __WEBPACK_IMPORTED_MODULE_9_Common_Enums__["MessagePriority"].Normal);

			this.folderFullNameRaw = json.Folder;
			this.uid = json.Uid;
			this.hash = json.Hash;
			this.requestHash = json.RequestHash;

			this.proxy = !!json.ExternalProxy;

			this.size(Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["pInt"])(json.Size));

			this.from = Object(__WEBPACK_IMPORTED_MODULE_17_Helper_Message__["a" /* emailArrayFromJson */])(json.From);
			this.to = Object(__WEBPACK_IMPORTED_MODULE_17_Helper_Message__["a" /* emailArrayFromJson */])(json.To);
			this.cc = Object(__WEBPACK_IMPORTED_MODULE_17_Helper_Message__["a" /* emailArrayFromJson */])(json.Cc);
			this.bcc = Object(__WEBPACK_IMPORTED_MODULE_17_Helper_Message__["a" /* emailArrayFromJson */])(json.Bcc);
			this.replyTo = Object(__WEBPACK_IMPORTED_MODULE_17_Helper_Message__["a" /* emailArrayFromJson */])(json.ReplyTo);
			this.deliveredTo = Object(__WEBPACK_IMPORTED_MODULE_17_Helper_Message__["a" /* emailArrayFromJson */])(json.DeliveredTo);
			this.unsubsribeLinks = Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["isNonEmptyArray"])(json.UnsubsribeLinks) ? json.UnsubsribeLinks : [];

			this.subject(json.Subject);
			if (Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["isArray"])(json.SubjectParts)) {
				this.subjectPrefix(json.SubjectParts[0]);
				this.subjectSuffix(json.SubjectParts[1]);
			} else {
				this.subjectPrefix('');
				this.subjectSuffix(this.subject());
			}

			this.dateTimeStampInUTC(Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["pInt"])(json.DateTimeStampInUTC));
			this.hasAttachments(!!json.HasAttachments);
			this.attachmentsSpecData(Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["isArray"])(json.AttachmentsSpecData) ? json.AttachmentsSpecData : []);

			this.fromEmailString(Object(__WEBPACK_IMPORTED_MODULE_17_Helper_Message__["b" /* emailArrayToString */])(this.from, true));
			this.fromClearEmailString(Object(__WEBPACK_IMPORTED_MODULE_17_Helper_Message__["c" /* emailArrayToStringClear */])(this.from));
			this.toEmailsString(Object(__WEBPACK_IMPORTED_MODULE_17_Helper_Message__["b" /* emailArrayToString */])(this.to, true));
			this.toClearEmailsString(Object(__WEBPACK_IMPORTED_MODULE_17_Helper_Message__["c" /* emailArrayToStringClear */])(this.to));

			this.threads(Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["isArray"])(json.Threads) ? json.Threads : []);

			this.initFlagsByJson(json);
			this.computeSenderEmail();

			result = true;
		}

		return result;
	};

	/**
  * @param {AjaxJsonMessage} json
  * @returns {boolean}
  */


	MessageModel.prototype.initUpdateByMessageJson = function initUpdateByMessageJson(json) {
		var result = false,
		    priority = __WEBPACK_IMPORTED_MODULE_9_Common_Enums__["MessagePriority"].Normal;

		if (json && 'Object/Message' === json['@Object']) {
			priority = Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["pInt"])(json.Priority);
			this.priority(-1 < Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["inArray"])(priority, [__WEBPACK_IMPORTED_MODULE_9_Common_Enums__["MessagePriority"].High, __WEBPACK_IMPORTED_MODULE_9_Common_Enums__["MessagePriority"].Low]) ? priority : __WEBPACK_IMPORTED_MODULE_9_Common_Enums__["MessagePriority"].Normal);

			this.aDraftInfo = json.DraftInfo;

			this.sMessageId = json.MessageId;
			this.sInReplyTo = json.InReplyTo;
			this.sReferences = json.References;

			this.proxy = !!json.ExternalProxy;

			if (__WEBPACK_IMPORTED_MODULE_16_Stores_User_Pgp__["a" /* default */].capaOpenPGP()) {
				this.isPgpSigned(!!json.PgpSigned);
				this.isPgpEncrypted(!!json.PgpEncrypted);
			}

			this.hasAttachments(!!json.HasAttachments);
			this.attachmentsSpecData(Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["isArray"])(json.AttachmentsSpecData) ? json.AttachmentsSpecData : []);

			this.foundedCIDs = Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["isArray"])(json.FoundedCIDs) ? json.FoundedCIDs : [];
			this.attachments(this.initAttachmentsFromJson(json.Attachments));

			this.readReceipt(json.ReadReceipt || '');

			this.computeSenderEmail();

			result = true;
		}

		return result;
	};

	/**
  * @param {(AjaxJsonAttachment|null)} oJsonAttachments
  * @returns {Array}
  */


	MessageModel.prototype.initAttachmentsFromJson = function initAttachmentsFromJson(json) {
		var index = 0,
		    len = 0,
		    attachment = null;
		var result = [];

		if (json && 'Collection/AttachmentCollection' === json['@Object'] && Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["isNonEmptyArray"])(json['@Collection'])) {
			for (index = 0, len = json['@Collection'].length; index < len; index++) {
				attachment = __WEBPACK_IMPORTED_MODULE_18_Model_Attachment__["a" /* AttachmentModel */].newInstanceFromJson(json['@Collection'][index]);
				if (attachment) {
					if ('' !== attachment.cidWithOutTags && 0 < this.foundedCIDs.length && 0 <= Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["inArray"])(attachment.cidWithOutTags, this.foundedCIDs)) {
						attachment.isLinked = true;
					}

					result.push(attachment);
				}
			}
		}

		return result;
	};

	/**
  * @returns {boolean}
  */


	MessageModel.prototype.hasUnsubsribeLinks = function hasUnsubsribeLinks() {
		return this.unsubsribeLinks && 0 < this.unsubsribeLinks.length;
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.getFirstUnsubsribeLink = function getFirstUnsubsribeLink() {
		return this.unsubsribeLinks && 0 < this.unsubsribeLinks.length ? this.unsubsribeLinks[0] || '' : '';
	};

	/**
  * @param {AjaxJsonMessage} json
  * @returns {boolean}
  */


	MessageModel.prototype.initFlagsByJson = function initFlagsByJson(json) {
		var result = false;
		if (json && 'Object/Message' === json['@Object']) {
			this.unseen(!json.IsSeen);
			this.flagged(!!json.IsFlagged);
			this.answered(!!json.IsAnswered);
			this.forwarded(!!json.IsForwarded);
			this.isReadReceipt(!!json.IsReadReceipt);
			this.deletedMark(!!json.IsDeleted);

			result = true;
		}

		return result;
	};

	/**
  * @param {boolean} friendlyView
  * @param {boolean=} wrapWithLink = false
  * @returns {string}
  */


	MessageModel.prototype.fromToLine = function fromToLine(friendlyView) {
		var wrapWithLink = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

		return Object(__WEBPACK_IMPORTED_MODULE_17_Helper_Message__["b" /* emailArrayToString */])(this.from, friendlyView, wrapWithLink);
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.fromDkimData = function fromDkimData() {
		var result = ['none', ''];
		if (Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["isNonEmptyArray"])(this.from) && 1 === this.from.length && this.from[0] && this.from[0].dkimStatus) {
			result = [this.from[0].dkimStatus, this.from[0].dkimValue || ''];
		}

		return result;
	};

	/**
  * @param {boolean} friendlyView
  * @param {boolean=} wrapWithLink = false
  * @returns {string}
  */


	MessageModel.prototype.toToLine = function toToLine(friendlyView) {
		var wrapWithLink = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

		return Object(__WEBPACK_IMPORTED_MODULE_17_Helper_Message__["b" /* emailArrayToString */])(this.to, friendlyView, wrapWithLink);
	};

	/**
  * @param {boolean} friendlyView
  * @param {boolean=} wrapWithLink = false
  * @returns {string}
  */


	MessageModel.prototype.ccToLine = function ccToLine(friendlyView) {
		var wrapWithLink = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

		return Object(__WEBPACK_IMPORTED_MODULE_17_Helper_Message__["b" /* emailArrayToString */])(this.cc, friendlyView, wrapWithLink);
	};

	/**
  * @param {boolean} friendlyView
  * @param {boolean=} wrapWithLink = false
  * @returns {string}
  */


	MessageModel.prototype.bccToLine = function bccToLine(friendlyView) {
		var wrapWithLink = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

		return Object(__WEBPACK_IMPORTED_MODULE_17_Helper_Message__["b" /* emailArrayToString */])(this.bcc, friendlyView, wrapWithLink);
	};

	/**
  * @param {boolean} friendlyView
  * @param {boolean=} wrapWithLink = false
  * @returns {string}
  */


	MessageModel.prototype.replyToToLine = function replyToToLine(friendlyView) {
		var wrapWithLink = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

		return Object(__WEBPACK_IMPORTED_MODULE_17_Helper_Message__["b" /* emailArrayToString */])(this.replyTo, friendlyView, wrapWithLink);
	};

	/**
  * @return string
  */


	MessageModel.prototype.lineAsCss = function lineAsCss() {
		return __WEBPACK_IMPORTED_MODULE_7_classnames___default()({
			'deleted': this.deleted(),
			'deleted-mark': this.deletedMark(),
			'selected': this.selected(),
			'checked': this.checked(),
			'flagged': this.flagged(),
			'unseen': this.unseen(),
			'answered': this.answered(),
			'forwarded': this.forwarded(),
			'focused': this.focused(),
			'important': this.isImportant(),
			'withAttachments': this.hasAttachments(),
			'new': this.newForAnimation(),
			'emptySubject': '' === this.subject(),
			// 'hasChildrenMessage': 1 < this.threadsLen(),
			'hasUnseenSubMessage': this.hasUnseenSubMessage(),
			'hasFlaggedSubMessage': this.hasFlaggedSubMessage()
		});
	};

	/**
  * @returns {boolean}
  */


	MessageModel.prototype.hasVisibleAttachments = function hasVisibleAttachments() {
		return !!__WEBPACK_IMPORTED_MODULE_3_____default.a.find(this.attachments(), function (item) {
			return !item.isLinked;
		});
	};

	/**
  * @param {string} cid
  * @returns {*}
  */


	MessageModel.prototype.findAttachmentByCid = function findAttachmentByCid(cid) {
		var result = null;
		var attachments = this.attachments();

		if (Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["isNonEmptyArray"])(attachments)) {
			cid = cid.replace(/^<+/, '').replace(/>+$/, '');
			result = __WEBPACK_IMPORTED_MODULE_3_____default.a.find(attachments, function (item) {
				return cid === item.cidWithOutTags;
			});
		}

		return result || null;
	};

	/**
  * @param {string} contentLocation
  * @returns {*}
  */


	MessageModel.prototype.findAttachmentByContentLocation = function findAttachmentByContentLocation(contentLocation) {
		var result = null;
		var attachments = this.attachments();

		if (Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["isNonEmptyArray"])(attachments)) {
			result = __WEBPACK_IMPORTED_MODULE_3_____default.a.find(attachments, function (item) {
				return contentLocation === item.contentLocation;
			});
		}

		return result || null;
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.messageId = function messageId() {
		return this.sMessageId;
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.inReplyTo = function inReplyTo() {
		return this.sInReplyTo;
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.references = function references() {
		return this.sReferences;
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.fromAsSingleEmail = function fromAsSingleEmail() {
		return Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["isArray"])(this.from) && this.from[0] ? this.from[0].email : '';
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.viewLink = function viewLink() {
		return Object(__WEBPACK_IMPORTED_MODULE_14_Common_Links__["q" /* messageViewLink */])(this.requestHash);
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.downloadLink = function downloadLink() {
		return Object(__WEBPACK_IMPORTED_MODULE_14_Common_Links__["p" /* messageDownloadLink */])(this.requestHash);
	};

	/**
  * @param {Object} excludeEmails
  * @param {boolean=} last = false
  * @returns {Array}
  */


	MessageModel.prototype.replyEmails = function replyEmails(excludeEmails) {
		var last = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

		var result = [],
		    unic = Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["isUnd"])(excludeEmails) ? {} : excludeEmails;

		Object(__WEBPACK_IMPORTED_MODULE_17_Helper_Message__["d" /* replyHelper */])(this.replyTo, unic, result);
		if (0 === result.length) {
			Object(__WEBPACK_IMPORTED_MODULE_17_Helper_Message__["d" /* replyHelper */])(this.from, unic, result);
		}

		if (0 === result.length && !last) {
			return this.replyEmails({}, true);
		}

		return result;
	};

	/**
  * @param {Object} excludeEmails
  * @param {boolean=} last = false
  * @returns {Array.<Array>}
  */


	MessageModel.prototype.replyAllEmails = function replyAllEmails(excludeEmails) {
		var last = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

		var data = [];
		var toResult = [],
		    ccResult = [],
		    unic = Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["isUnd"])(excludeEmails) ? {} : excludeEmails;

		Object(__WEBPACK_IMPORTED_MODULE_17_Helper_Message__["d" /* replyHelper */])(this.replyTo, unic, toResult);
		if (0 === toResult.length) {
			Object(__WEBPACK_IMPORTED_MODULE_17_Helper_Message__["d" /* replyHelper */])(this.from, unic, toResult);
		}

		Object(__WEBPACK_IMPORTED_MODULE_17_Helper_Message__["d" /* replyHelper */])(this.to, unic, toResult);
		Object(__WEBPACK_IMPORTED_MODULE_17_Helper_Message__["d" /* replyHelper */])(this.cc, unic, ccResult);

		if (0 === toResult.length && !last) {
			data = this.replyAllEmails({}, true);
			return [data[0], ccResult];
		}

		return [toResult, ccResult];
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.textBodyToString = function textBodyToString() {
		return this.body ? this.body.html() : '';
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.attachmentsToStringLine = function attachmentsToStringLine() {
		var attachLines = __WEBPACK_IMPORTED_MODULE_3_____default.a.map(this.attachments(), function (item) {
			return item.fileName + ' (' + item.friendlySize + ')';
		});
		return attachLines && 0 < attachLines.length ? attachLines.join(', ') : '';
	};

	/**
  * @param {boolean=} print = false
  */


	MessageModel.prototype.viewPopupMessage = function viewPopupMessage() {
		var print = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

		this.showLazyExternalImagesInBody();

		var timeStampInUTC = this.dateTimeStampInUTC() || 0,
		    ccLine = this.ccToLine(false),
		    m = 0 < timeStampInUTC ? __WEBPACK_IMPORTED_MODULE_6_moment___default.a.unix(timeStampInUTC) : null;

		Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["previewMessage"])({
			title: this.subject(),
			subject: this.subject(),
			date: m ? m.format('LLL') : '',
			fromCreds: this.fromToLine(false),
			toLabel: Object(__WEBPACK_IMPORTED_MODULE_10_Common_Translator__["i18n"])('MESSAGE/LABEL_TO'),
			toCreds: this.toToLine(false),
			ccClass: ccLine ? '' : 'rl-preview-hide',
			ccLabel: Object(__WEBPACK_IMPORTED_MODULE_10_Common_Translator__["i18n"])('MESSAGE/LABEL_CC'),
			ccCreds: ccLine
		}, this.body, this.isHtml(), print);
	};

	MessageModel.prototype.printMessage = function printMessage() {
		this.viewPopupMessage(true);
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.generateUid = function generateUid() {
		return this.folderFullNameRaw + '/' + this.uid;
	};

	/**
  * @param {MessageModel} message
  * @returns {MessageModel}
  */


	MessageModel.prototype.populateByMessageListItem = function populateByMessageListItem(message) {
		if (message) {
			this.folderFullNameRaw = message.folderFullNameRaw;
			this.uid = message.uid;
			this.hash = message.hash;
			this.requestHash = message.requestHash;
			this.subject(message.subject());
		}

		this.subjectPrefix(this.subjectPrefix());
		this.subjectSuffix(this.subjectSuffix());

		if (message) {
			this.size(message.size());
			this.dateTimeStampInUTC(message.dateTimeStampInUTC());
			this.priority(message.priority());

			this.proxy = message.proxy;

			this.fromEmailString(message.fromEmailString());
			this.fromClearEmailString(message.fromClearEmailString());
			this.toEmailsString(message.toEmailsString());
			this.toClearEmailsString(message.toClearEmailsString());

			this.emails = message.emails;

			this.from = message.from;
			this.to = message.to;
			this.cc = message.cc;
			this.bcc = message.bcc;
			this.replyTo = message.replyTo;
			this.deliveredTo = message.deliveredTo;
			this.unsubsribeLinks = message.unsubsribeLinks;

			this.unseen(message.unseen());
			this.flagged(message.flagged());
			this.answered(message.answered());
			this.forwarded(message.forwarded());
			this.isReadReceipt(message.isReadReceipt());
			this.deletedMark(message.deletedMark());

			this.priority(message.priority());

			this.selected(message.selected());
			this.checked(message.checked());
			this.hasAttachments(message.hasAttachments());
			this.attachmentsSpecData(message.attachmentsSpecData());
		}

		this.body = null;

		this.aDraftInfo = [];
		this.sMessageId = '';
		this.sInReplyTo = '';
		this.sReferences = '';

		if (message) {
			this.threads(message.threads());
		}

		this.computeSenderEmail();

		return this;
	};

	MessageModel.prototype.showLazyExternalImagesInBody = function showLazyExternalImagesInBody() {
		if (this.body) {
			__WEBPACK_IMPORTED_MODULE_4_____default()('.lazy.lazy-inited[data-original]', this.body).each(function () {
				__WEBPACK_IMPORTED_MODULE_4_____default()(this).attr('src', __WEBPACK_IMPORTED_MODULE_4_____default()(this).attr('data-original')) // eslint-disable-line no-invalid-this
				.removeAttr('data-original').removeAttr('data-loaded');
			});
		}
	};

	MessageModel.prototype.lozad = function lozad() {
		__WEBPACK_IMPORTED_MODULE_8_lozad___default()('img.lazy:not(.lazy-inited)', {
			threshold: 0.4,
			load: function load(element) {
				// console.log('lazy', element.dataset.original);
				element.src = __WEBPACK_IMPORTED_MODULE_11_Common_Consts__["e" /* DATA_IMAGE_LAZY_PLACEHOLDER_PIC */];
				__WEBPACK_IMPORTED_MODULE_4_____default()(element).addClass('lazy-inited').attr('src', element.dataset.original).removeAttr('data-loaded').removeAttr('data-original').css({ opacity: 0.3 }).animate({ opacity: 1 }, 500);
			}
		}).observe();
	};

	MessageModel.prototype.showExternalImages = function showExternalImages() {
		var lazy = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

		if (this.body && this.body.data('rl-has-images')) {
			this.hasImages(false);
			this.body.data('rl-has-images', false);

			var attr = this.proxy ? 'data-x-additional-src' : 'data-x-src';
			__WEBPACK_IMPORTED_MODULE_4_____default()('[' + attr + ']', this.body).each(function () {
				var $this = __WEBPACK_IMPORTED_MODULE_4_____default()(this); // eslint-disable-line no-invalid-this
				if (lazy && $this.is('img')) {
					$this.addClass('lazy').attr('data-original', $this.attr(attr)).removeAttr('data-loaded');
				} else {
					$this.attr('src', $this.attr(attr)).removeAttr('data-loaded');
				}
			});

			attr = this.proxy ? 'data-x-additional-style-url' : 'data-x-style-url';
			__WEBPACK_IMPORTED_MODULE_4_____default()('[' + attr + ']', this.body).each(function () {
				var $this = __WEBPACK_IMPORTED_MODULE_4_____default()(this); // eslint-disable-line no-invalid-this
				var style = Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["trim"])($this.attr('style'));
				style = '' === style ? '' : ';' === style.substr(-1) ? style + ' ' : style + '; ';
				$this.attr('style', style + $this.attr(attr));
			});

			if (lazy) {
				this.lozad();
				__WEBPACK_IMPORTED_MODULE_13_Common_Globals__["$win"].resize();
			}

			Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["windowResize"])(500);
		}
	};

	MessageModel.prototype.showInternalImages = function showInternalImages() {
		var _this3 = this;

		var lazy = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

		if (this.body && !this.body.data('rl-init-internal-images')) {
			this.body.data('rl-init-internal-images', true);

			var self = this;

			__WEBPACK_IMPORTED_MODULE_4_____default()('[data-x-src-cid]', this.body).each(function () {
				var $this = __WEBPACK_IMPORTED_MODULE_4_____default()(this),
				    // eslint-disable-line no-invalid-this
				attachment = self.findAttachmentByCid($this.attr('data-x-src-cid'));

				if (attachment && attachment.download) {
					if (lazy && $this.is('img')) {
						$this.addClass('lazy').attr('data-original', attachment.linkPreview());
					} else {
						$this.attr('src', attachment.linkPreview());
					}
				}
			});

			__WEBPACK_IMPORTED_MODULE_4_____default()('[data-x-src-location]', this.body).each(function () {
				var $this = __WEBPACK_IMPORTED_MODULE_4_____default()(this); // eslint-disable-line no-invalid-this
				var attachment = self.findAttachmentByContentLocation($this.attr('data-x-src-location'));
				if (!attachment) {
					attachment = self.findAttachmentByCid($this.attr('data-x-src-location'));
				}

				if (attachment && attachment.download) {
					if (lazy && $this.is('img')) {
						$this.addClass('lazy').attr('data-original', attachment.linkPreview());
					} else {
						$this.attr('src', attachment.linkPreview());
					}
				}
			});

			__WEBPACK_IMPORTED_MODULE_4_____default()('[data-x-style-cid]', this.body).each(function () {
				var style = '',
				    name = '';

				var $this = __WEBPACK_IMPORTED_MODULE_4_____default()(this),
				    // eslint-disable-line no-invalid-this
				attachment = self.findAttachmentByCid($this.attr('data-x-style-cid'));

				if (attachment && attachment.linkPreview) {
					name = $this.attr('data-x-style-cid-name');
					if ('' !== name) {
						style = Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["trim"])($this.attr('style'));
						style = '' === style ? '' : ';' === style.substr(-1) ? style + ' ' : style + '; ';
						$this.attr('style', style + name + ': url(\'' + attachment.linkPreview() + '\')');
					}
				}
			});

			if (lazy) {
				// $('.RL-MailMessageView .messageView .messageItem .content')[0]
				__WEBPACK_IMPORTED_MODULE_3_____default.a.delay(function () {
					return _this3.lozad();
				}, 300);
			}

			Object(__WEBPACK_IMPORTED_MODULE_12_Common_Utils__["windowResize"])(500);
		}
	};

	MessageModel.prototype.storeDataInDom = function storeDataInDom() {
		if (this.body) {
			this.body.data('rl-is-html', !!this.isHtml());
			this.body.data('rl-has-images', !!this.hasImages());
		}
	};

	MessageModel.prototype.fetchDataFromDom = function fetchDataFromDom() {
		if (this.body) {
			this.isHtml(!!this.body.data('rl-is-html'));
			this.hasImages(!!this.body.data('rl-has-images'));
		}
	};

	MessageModel.prototype.replacePlaneTextBody = function replacePlaneTextBody(plain) {
		if (this.body) {
			this.body.html(plain).addClass('b-text-part plain');
		}
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.flagHash = function flagHash() {
		return [this.deleted(), this.deletedMark(), this.unseen(), this.flagged(), this.answered(), this.forwarded(), this.isReadReceipt()].join(',');
	};

	return MessageModel;
}(__WEBPACK_IMPORTED_MODULE_19_Knoin_AbstractModel__["a" /* AbstractModel */]);



/***/ }),
/* 215 */
/*!******************************************!*\
  !*** ./node_modules/classnames/index.js ***!
  \******************************************/
/*! no static exports found */
/*! exports used: default */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
  Copyright (c) 2016 Jed Watson.
  Licensed under the MIT License (MIT), see
  http://jedwatson.github.io/classnames
*/
/* global define */

(function () {
	'use strict';

	var hasOwn = {}.hasOwnProperty;

	function classNames () {
		var classes = [];

		for (var i = 0; i < arguments.length; i++) {
			var arg = arguments[i];
			if (!arg) continue;

			var argType = typeof arg;

			if (argType === 'string' || argType === 'number') {
				classes.push(arg);
			} else if (Array.isArray(arg)) {
				classes.push(classNames.apply(null, arg));
			} else if (argType === 'object') {
				for (var key in arg) {
					if (hasOwn.call(arg, key) && arg[key]) {
						classes.push(key);
					}
				}
			}
		}

		return classes.join(' ');
	}

	if (typeof module !== 'undefined' && module.exports) {
		module.exports = classNames;
	} else if (true) {
		// register as 'classnames', consistent with npm package name
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = function () {
			return classNames;
		}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else {
		window.classNames = classNames;
	}
}());


/***/ }),
/* 216 */
/*!******************************************!*\
  !*** ./node_modules/lozad/dist/lozad.js ***!
  \******************************************/
/*! no static exports found */
/*! exports used: default */
/***/ (function(module, exports, __webpack_require__) {

/*! lozad.js - v1.0.4 - 2017-09-22
* https://github.com/ApoorvSaxena/lozad.js
* Copyright (c) 2017 Apoorv Saxena; Licensed MIT */


(function (global, factory) {
	 true ? module.exports = factory() :
	typeof define === 'function' && define.amd ? define(factory) :
	(global.lozad = factory());
}(this, (function () { 'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var defaultConfig = {
  rootMargin: '0px',
  threshold: 0,
  load: function load(element) {
    element.src = element.dataset.src;
  }
};

function markAsLoaded(element) {
  element.dataset.loaded = true;
}

var isLoaded = function isLoaded(element) {
  return element.dataset.loaded === 'true';
};

var onIntersection = function onIntersection(load) {
  return function (entries, observer) {
    entries.forEach(function (entry) {
      if (entry.intersectionRatio > 0) {
        observer.unobserve(entry.target);
        load(entry.target);
        markAsLoaded(entry.target);
      }
    });
  };
};

var lozad = function () {
  var selector = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '.lozad';
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  var _defaultConfig$option = _extends({}, defaultConfig, options),
      rootMargin = _defaultConfig$option.rootMargin,
      threshold = _defaultConfig$option.threshold,
      load = _defaultConfig$option.load;

  var observer = void 0;

  if (window.IntersectionObserver) {
    observer = new IntersectionObserver(onIntersection(load), {
      rootMargin: rootMargin,
      threshold: threshold
    });
  }

  return {
    observe: function observe() {
      var elements = document.querySelectorAll(selector);
      for (var i = 0; i < elements.length; i++) {
        if (isLoaded(elements[i])) {
          continue;
        }
        if (observer) {
          observer.observe(elem